if(NOT WIN32)
  string(ASCII 27 Esc)
  set(ColourReset "${Esc}[m")
  set(ColourBold  "${Esc}[1m")
  set(Red         "${Esc}[31m")
  set(Green       "${Esc}[32m")
  set(Yellow      "${Esc}[33m")
  set(Blue        "${Esc}[34m")
  set(Magenta     "${Esc}[35m")
  set(Cyan        "${Esc}[36m")
  set(White       "${Esc}[37m")
  set(BoldRed     "${Esc}[1;31m")
  set(BoldGreen   "${Esc}[1;32m")
  set(BoldYellow  "${Esc}[1;33m")
  set(BoldBlue    "${Esc}[1;34m")
  set(BoldMagenta "${Esc}[1;35m")
  set(BoldCyan    "${Esc}[1;36m")
  set(BoldWhite   "${Esc}[1;37m")
endif()

if(XPU)
  set(RUNTIME_KUNLUN_PATH ${CMAKE_CURRENT_SOURCE_DIR})
  message(STATUS "RUNTIME_KUNLUN_PATH is ${RUNTIME_KUNLUN_PATH} .\n")
  set(KUNLUN_XPU_PATH ${RUNTIME_KUNLUN_PATH}/xpu)
  if(NOT DEFINED ENV{XPU_API_PATH})
    message(FATAL_ERROR "${BoldRed}NO ENV{XPU_API_PATH} in your env. Please set XPU_API_PATH.${ColourReset}\n")
  else()
    set(XPU_API_PATH $ENV{XPU_API_PATH})
    message("set XPU_API_PATH from env_var. Val is $ENV{XPU_API_PATH}.")
  endif()

  include_directories(${RUNTIME_KUNLUN_PATH} ${KUNLUN_XPU_PATH}/
                      ${XPU_API_PATH}/output/include ${XPU_API_PATH}/../runtime/include)
  link_directories(${XPU_API_PATH}/output/so/ ${XPU_API_PATH}/../runtime/output/so/)

  add_definitions(-DUSE_XPU)
endif()
