function(get_linux_lsb_release_information)
    find_program(LSB_RELEASE_EXEC lsb_release)
    if(NOT LSB_RELEASE_EXEC)
        message(FATAL_ERROR "Could not detect lsb_release executable, can not gather required information")
    endif()

    execute_process(COMMAND "${LSB_RELEASE_EXEC}" --short --id OUTPUT_VARIABLE LSB_RELEASE_ID_SHORT OUTPUT_STRIP_TRAILING_WHITESPACE)
    execute_process(COMMAND "${LSB_RELEASE_EXEC}" --short --release OUTPUT_VARIABLE LSB_RELEASE_VERSION_SHORT OUTPUT_STRIP_TRAILING_WHITESPACE)
    execute_process(COMMAND "${LSB_RELEASE_EXEC}" --short --codename OUTPUT_VARIABLE LSB_RELEASE_CODENAME_SHORT OUTPUT_STRIP_TRAILING_WHITESPACE)

    set(LSB_RELEASE_ID_SHORT "${LSB_RELEASE_ID_SHORT}" PARENT_SCOPE)
    set(LSB_RELEASE_VERSION_SHORT "${LSB_RELEASE_VERSION_SHORT}" PARENT_SCOPE)
    set(LSB_RELEASE_CODENAME_SHORT "${LSB_RELEASE_CODENAME_SHORT}" PARENT_SCOPE)
endfunction()

if(OPENVINO)
  include(gflags)
  set(VINO_VERSION "2022.3.0")
  if(${CMAKE_SYSTEM_PROCESSOR} MATCHES "(x86)|(X86)|(amd64)|(AMD64)")
    set (X86 TRUE)
  else ()
    set (X86 FALSE)
  endif ()

  if(${CMAKE_SYSTEM_NAME} STREQUAL "Windows")
    set(VINO_URL "https://storage.openvinotoolkit.org/repositories/openvino/packages/2022.3/windows/w_openvino_toolkit_windows_${VINO_VERSION}.9052.9752fafe8eb_x86_64.zip")
    set(URL_HASH "SHA256=adf42b4ffe4d8a39ffebcb476ea8b84e51eefbb5b900db70510412beed2cc722")
  elseif(${CMAKE_SYSTEM_NAME} STREQUAL "Linux")
    get_linux_lsb_release_information()
    if(LSB_RELEASE_ID_SHORT STREQUAL "Ubuntu" AND LSB_RELEASE_VERSION_SHORT VERSION_GREATER_EQUAL 20 AND LSB_RELEASE_VERSION_SHORT VERSION_LESS 22)
      set(VINO_URL "https://storage.openvinotoolkit.org/repositories/openvino/packages/2022.3/linux/l_openvino_toolkit_ubuntu20_${VINO_VERSION}.9052.9752fafe8eb_x86_64.tgz")
      set(URL_HASH "SHA256=e421fc1d9c7e6cce4089aaf344c7f84dcfd8f81ebf4ef2130b145aeca48c4e71")
    elseif(LSB_RELEASE_ID_SHORT STREQUAL "Ubuntu" AND LSB_RELEASE_VERSION_SHORT VERSION_GREATER_EQUAL 18 AND LSB_RELEASE_VERSION_SHORT VERSION_LESS 20)
      set(VINO_URL "https://storage.openvinotoolkit.org/repositories/openvino/packages/2022.3/linux/l_openvino_toolkit_ubuntu18_${VINO_VERSION}.9052.9752fafe8eb_x86_64.tgz")
      set(URL_HASH "SHA256=8337579883d216336572e35066b6c8de52ea5a41f6771a3344ee41c019d27372")
    elseif(LSB_RELEASE_ID_SHORT STREQUAL "CentOS" AND LSB_RELEASE_VERSION_SHORT VERSION_LESS 7.10)
      set(VINO_URL "https://storage.openvinotoolkit.org/repositories/openvino/packages/2022.3/linux/l_openvino_toolkit_centos7_${VINO_VERSION}.9052.9752fafe8eb_x86_64.tgz")
      set(URL_HASH "SHA256=93d6bd23d5e8306384bdc8f3746fe56baad1a0f87b97d0b384b4c0b158227d76")
    elseif(LSB_RELEASE_ID_SHORT STREQUAL "CentOS" AND LSB_RELEASE_VERSION_SHORT VERSION_LESS 8.10)
      set(VINO_URL "https://storage.openvinotoolkit.org/repositories/openvino/packages/2022.3/linux/l_openvino_toolkit_rhel8_${VINO_VERSION}.9052.9752fafe8eb_x86_64.tgz")
      set(URL_HASH "SHA256=519cbdf95d73489c771357f27dbc5829057fcc3b23fd89be06e290b41a8ff934")
    elseif(LSB_RELEASE_ID_SHORT STREQUAL "Debian" AND LSB_RELEASE_VERSION_SHORT VERSION_LESS_EQUAL 9.13 AND X86)
      set(VINO_URL "https://storage.openvinotoolkit.org/repositories/openvino/packages/2022.3/linux/l_openvino_toolkit_debian9_${VINO_VERSION}.9052.9752fafe8eb_arm64.tgz")
      set(URL_HASH "SHA256=4099bb9a257af46fbf7d5c30414ec4e308542704eac666b4b213362208bf8b16")
    else()
      message(STATUS "Linux OS without exist binary, compile OpenVINO source.")
    endif()
  elseif(${CMAKE_SYSTEM_NAME} STREQUAL "Darwin" AND X86)
    set(VINO_URL "https://storage.openvinotoolkit.org/repositories/openvino/packages/2022.3/macos/m_openvino_toolkit_macos_10_15_${VINO_VERSION}.9052.9752fafe8eb_x86_64.tgz")
    set(URL_HASH "SHA256=235221536ddde7937db9ba6cd3c262d6220d2e7c7a24438d046fcd3ca0c73bed")
  else()
    message(FATAL_ERROR "Unsupported CMake System Name '${CMAKE_SYSTEM_NAME}' (expected 'Windows', 'Linux' or 'Darwin')")
    set(VINO_URL "")
    set(URL_HASH "")
    endif()

  if(${VINO_URL} STREQUAL "")
    set(ENABLE_INTEL_GPU OFF CACHE BOOL "Build OV with GPU" FORCE)
    set(ENABLE_INTEL_MYRIAD OFF CACHE BOOL "Build OV with MYRIAD" FORCE)
    set(ENABLE_INTEL_GNA OFF CACHE BOOL "Build OV with GNA" FORCE)
    set(ENABLE_INTEL_CPU ON CACHE BOOL "Build OV with CPU" FORCE)
    set(BUILD_SHARED_LIBS ON CACHE BOOL "Build OV in shared library" FORCE)
    set(ENABLE_SAMPLES OFF CACHE BOOL "Build OV with Example" FORCE)
    set(ENABLE_TESTS OFF CACHE BOOL "Build OV with Tests" FORCE)
    set(ENABLE_COMPILE_TOOL OFF CACHE BOOL "Build OV with COMPILE_TOOL" FORCE)
    set(ENABLE_PYTHON OFF CACHE BOOL "Build python" FORCE)
    set(THREADING "TBB")
    #set(CMAKE_BUILD_TYPE "Debug")
    FetchContent_Declare(openvino
      GIT_REPOSITORY https://github.com/openvinotoolkit/openvino.git
      GIT_TAG 9752fafe8ebf7e30dfea7edd447ff3bf0ac1d01d) # 2022.3.0 on Dec 20, 2022
    FetchContent_MakeAvailable(openvino)
  else()
    FetchContent_Declare(openvino
      URL ${VINO_URL}
      URL_HASH ${URL_HASH}
    )
    FetchContent_MakeAvailable(openvino)
    include_directories(${openvino_SOURCE_DIR}/include)
    link_directories(${openvino_SOURCE_DIR}/lib)
  endif()

  add_definitions(-DUSE_OPENVINO)
endif()
