/*
 * Decompiled with CFR 0.152.
 */
package com.zhanshow.ping.netease.LDNetDiagnoUtils;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.DhcpInfo;
import android.net.NetworkInfo;
import android.net.Proxy;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

@SuppressLint(value={"DefaultLocale"})
public class LDNetUtil {
    public static final String OPEN_IP = "";
    public static final String OPERATOR_URL = "";
    public static final String NETWORKTYPE_INVALID = "UNKNOWN";
    public static final String NETWORKTYPE_WAP = "WAP";
    public static final String NETWORKTYPE_WIFI = "WIFI";

    public static String getNetWorkType(Context context) {
        String mNetWorkType = null;
        ConnectivityManager manager = (ConnectivityManager)context.getSystemService("connectivity");
        if (manager == null) {
            return "ConnectivityManager not found";
        }
        NetworkInfo networkInfo = manager.getActiveNetworkInfo();
        if (networkInfo != null && networkInfo.isConnected()) {
            String type = networkInfo.getTypeName();
            if (type.equalsIgnoreCase(NETWORKTYPE_WIFI)) {
                mNetWorkType = NETWORKTYPE_WIFI;
            } else if (type.equalsIgnoreCase("MOBILE")) {
                String proxyHost = Proxy.getDefaultHost();
                mNetWorkType = TextUtils.isEmpty((CharSequence)proxyHost) ? LDNetUtil.mobileNetworkType(context) : NETWORKTYPE_WAP;
            }
        } else {
            mNetWorkType = NETWORKTYPE_INVALID;
        }
        return mNetWorkType;
    }

    public static Boolean isNetworkConnected(Context context) {
        ConnectivityManager manager = (ConnectivityManager)context.getApplicationContext().getSystemService("connectivity");
        if (manager == null) {
            return false;
        }
        NetworkInfo networkinfo = manager.getActiveNetworkInfo();
        if (networkinfo == null || !networkinfo.isAvailable()) {
            return false;
        }
        return true;
    }

    public static String getMobileOperator(Context context) {
        TelephonyManager telManager = (TelephonyManager)context.getSystemService("phone");
        if (telManager == null) {
            return "\u672a\u77e5\u8fd0\u8425\u5546";
        }
        String operator = telManager.getSimOperator();
        if (operator != null) {
            if (operator.equals("46000") || operator.equals("46002") || operator.equals("46007")) {
                return "\u4e2d\u56fd\u79fb\u52a8";
            }
            if (operator.equals("46001")) {
                return "\u4e2d\u56fd\u8054\u901a";
            }
            if (operator.equals("46003")) {
                return "\u4e2d\u56fd\u7535\u4fe1";
            }
        }
        return "\u672a\u77e5\u8fd0\u8425\u5546";
    }

    public static String getLocalIpByWifi(Context context) {
        WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
        if (wifiManager == null) {
            return "wifiManager not found";
        }
        WifiInfo wifiInfo = wifiManager.getConnectionInfo();
        if (wifiInfo == null) {
            return "wifiInfo not found";
        }
        int ipAddress = wifiInfo.getIpAddress();
        return String.format("%d.%d.%d.%d", ipAddress & 0xFF, ipAddress >> 8 & 0xFF, ipAddress >> 16 & 0xFF, ipAddress >> 24 & 0xFF);
    }

    public static String getLocalIpBy3G() {
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface intf = en.nextElement();
                Enumeration<InetAddress> enumIpAddr = intf.getInetAddresses();
                while (enumIpAddr.hasMoreElements()) {
                    InetAddress inetAddress = enumIpAddr.nextElement();
                    if (inetAddress.isLoopbackAddress() || !(inetAddress instanceof Inet4Address)) continue;
                    return inetAddress.getHostAddress().toString();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String pingGateWayInWifi(Context context) {
        String gateWay = null;
        WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
        if (wifiManager == null) {
            return "wifiManager not found";
        }
        DhcpInfo dhcpInfo = wifiManager.getDhcpInfo();
        if (dhcpInfo != null) {
            int tmp = dhcpInfo.gateway;
            gateWay = String.format("%d.%d.%d.%d", tmp & 0xFF, tmp >> 8 & 0xFF, tmp >> 16 & 0xFF, tmp >> 24 & 0xFF);
        }
        return gateWay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getLocalDns(String dns) {
        Process process = null;
        String str = "";
        BufferedReader reader = null;
        try {
            process = Runtime.getRuntime().exec("getprop net." + dns);
            reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = null;
            while ((line = reader.readLine()) != null) {
                str = str + line;
            }
            reader.close();
            process.waitFor();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
                process.destroy();
            }
            catch (Exception e) {}
        }
        return str.trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> getDomainIp(String _dormain) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        long start = 0L;
        long end = 0L;
        String time = null;
        InetAddress[] remoteInet = null;
        try {
            start = System.currentTimeMillis();
            remoteInet = InetAddress.getAllByName(_dormain);
            if (remoteInet != null) {
                end = System.currentTimeMillis();
                time = end - start + "";
            }
            map.put("remoteInet", remoteInet);
        }
        catch (UnknownHostException e) {
            try {
                end = System.currentTimeMillis();
                time = end - start + "";
                remoteInet = null;
                e.printStackTrace();
                map.put("remoteInet", remoteInet);
            }
            catch (Throwable throwable) {
                map.put("remoteInet", remoteInet);
                map.put("useTime", time);
                throw throwable;
            }
            map.put("useTime", time);
        }
        map.put("useTime", time);
        return map;
    }

    private static String mobileNetworkType(Context context) {
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        if (telephonyManager == null) {
            return "TM==null";
        }
        switch (telephonyManager.getNetworkType()) {
            case 7: {
                return "2G";
            }
            case 4: {
                return "2G";
            }
            case 2: {
                return "2G";
            }
            case 5: {
                return "3G";
            }
            case 6: {
                return "3G";
            }
            case 1: {
                return "2G";
            }
            case 8: {
                return "3G";
            }
            case 10: {
                return "3G";
            }
            case 9: {
                return "3G";
            }
            case 3: {
                return "3G";
            }
            case 14: {
                return "3G";
            }
            case 12: {
                return "3G";
            }
            case 15: {
                return "3G";
            }
            case 11: {
                return "2G";
            }
            case 13: {
                return "4G";
            }
            case 0: {
                return NETWORKTYPE_INVALID;
            }
        }
        return "4G";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStringFromStream(InputStream is) {
        byte[] bytes = new byte[1024];
        int len = 0;
        String res = "";
        try {
            while ((len = is.read(bytes)) != -1) {
                res = res + new String(bytes, 0, len, "gbk");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return res;
    }
}

