/*
 * Decompiled with CFR 0.152.
 */
package com.zhanshow.ping.netease.LDNetDiagnoService;

import android.util.Log;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LDNetTraceRoute {
    private final String LOG_TAG = "LDNetTraceRoute";
    private static LDNetTraceRoute instance;
    LDNetTraceRouteListener listener;
    public boolean isCTrace = true;
    static boolean loaded;
    private static final String MATCH_TRACE_IP = "(?<=From )(?:[0-9]{1,3}\\.){3}[0-9]{1,3}";
    private static final String MATCH_PING_IP = "(?<=from ).*(?=: icmp_seq=1 ttl=)";
    private static final String MATCH_PING_TIME = "(?<=time=).*?ms";

    private LDNetTraceRoute() {
    }

    public static LDNetTraceRoute getInstance() {
        if (instance == null) {
            instance = new LDNetTraceRoute();
        }
        return instance;
    }

    public void initListenter(LDNetTraceRouteListener listener) {
        this.listener = listener;
    }

    public void startTraceRoute(String host) {
        if (this.isCTrace && loaded) {
            try {
                this.startJNICTraceRoute(host);
            }
            catch (UnsatisfiedLinkError e) {
                e.printStackTrace();
                Log.i((String)"LDNetTraceRoute", (String)"\u8c03\u7528java\u6a21\u62dftraceRoute");
                TraceTask trace = new TraceTask(host, 1);
                this.execTrace(trace);
            }
        } else {
            TraceTask trace = new TraceTask(host, 1);
            this.execTrace(trace);
        }
    }

    public void resetInstance() {
        if (instance != null) {
            instance = null;
        }
    }

    public native void startJNICTraceRoute(String var1);

    public void printTraceInfo(String log) {
        this.listener.OnNetTraceUpdated(log);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String execPing(PingTask ping) {
        Process process = null;
        String str = "";
        BufferedReader reader = null;
        try {
            process = Runtime.getRuntime().exec("ping -c 1 " + ping.getHost());
            reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = null;
            while ((line = reader.readLine()) != null) {
                str = str + line;
            }
            reader.close();
            process.waitFor();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
                process.destroy();
            }
            catch (Exception e) {}
        }
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execTrace(TraceTask trace) {
        Pattern patternTrace = Pattern.compile(MATCH_TRACE_IP);
        Pattern patternIp = Pattern.compile(MATCH_PING_IP);
        Pattern patternTime = Pattern.compile(MATCH_PING_TIME);
        Process process = null;
        BufferedReader reader = null;
        boolean finish = false;
        try {
            while (!finish && trace.getHop() < 30) {
                String str = "";
                String command = "ping -c 1 -t " + trace.getHop() + " " + trace.getHost();
                process = Runtime.getRuntime().exec(command);
                reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    str = str + line;
                }
                reader.close();
                process.waitFor();
                Matcher m = patternTrace.matcher(str);
                StringBuilder log = new StringBuilder(256);
                if (m.find()) {
                    String pingIp = m.group();
                    PingTask pingTask = new PingTask(pingIp);
                    String status = this.execPing(pingTask);
                    if (status.length() == 0) {
                        log.append("unknown host or network error\n");
                        finish = true;
                        continue;
                    }
                    Matcher matcherTime = patternTime.matcher(status);
                    if (matcherTime.find()) {
                        String time = matcherTime.group();
                        log.append(trace.getHop());
                        log.append("\t\t");
                        log.append(pingIp);
                        log.append("\t\t");
                        log.append(time);
                        log.append("\t");
                    } else {
                        log.append(trace.getHop());
                        log.append("\t\t");
                        log.append(pingIp);
                        log.append("\t\t timeout \t");
                    }
                    this.listener.OnNetTraceUpdated(log.toString());
                    trace.setHop(trace.getHop() + 1);
                    continue;
                }
                Matcher matchPingIp = patternIp.matcher(str);
                if (matchPingIp.find()) {
                    String pingIp = matchPingIp.group();
                    Matcher matcherTime = patternTime.matcher(str);
                    if (matcherTime.find()) {
                        String time = matcherTime.group();
                        log.append(trace.getHop());
                        log.append("\t\t");
                        log.append(pingIp);
                        log.append("\t\t");
                        log.append(time);
                        log.append("\t");
                        this.listener.OnNetTraceUpdated(log.toString());
                    }
                    finish = true;
                    continue;
                }
                if (str.length() == 0) {
                    log.append("unknown host or network error\t");
                    finish = true;
                } else {
                    log.append(trace.getHop());
                    log.append("\t\t timeout \t");
                    trace.setHop(trace.getHop() + 1);
                }
                this.listener.OnNetTraceUpdated(log.toString());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
                process.destroy();
            }
            catch (Exception e) {}
        }
        this.listener.OnNetTraceFinished();
    }

    static {
        try {
            System.loadLibrary("tracepath");
            loaded = true;
        }
        catch (UnsatisfiedLinkError e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class TraceTask {
        private final String host;
        private int hop;

        public TraceTask(String host, int hop) {
            this.host = host;
            this.hop = hop;
        }

        public String getHost() {
            return this.host;
        }

        public int getHop() {
            return this.hop;
        }

        public void setHop(int hop) {
            this.hop = hop;
        }
    }

    private class PingTask {
        private String host;
        private static final String MATCH_PING_HOST_IP = "(?<=\\().*?(?=\\))";

        public String getHost() {
            return this.host;
        }

        public PingTask(String host) {
            this.host = host;
            Pattern p = Pattern.compile(MATCH_PING_HOST_IP);
            Matcher m = p.matcher(host);
            if (m.find()) {
                this.host = m.group();
            }
        }
    }

    public static interface LDNetTraceRouteListener {
        public void OnNetTraceUpdated(String var1);

        public void OnNetTraceFinished();
    }
}

