/*
 * Decompiled with CFR 0.152.
 */
package com.zhanshow.ping.netease.LDNetDiagnoService;

import android.util.Log;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.List;

public class LDNetSocket {
    private static final int PORT = 80;
    private static final int CONN_TIMES = 4;
    private static final String TIMEOUT = "DNS\u89e3\u6790\u6b63\u5e38,\u8fde\u63a5\u8d85\u65f6,TCP\u5efa\u7acb\u5931\u8d25";
    private static final String IOERR = "DNS\u89e3\u6790\u6b63\u5e38,IO\u5f02\u5e38,TCP\u5efa\u7acb\u5931\u8d25";
    private static final String HOSTERR = "DNS\u89e3\u6790\u5931\u8d25,\u4e3b\u673a\u5730\u5740\u4e0d\u53ef\u8fbe";
    private static LDNetSocket instance = null;
    private LDNetSocketListener listener;
    private int timeOut = 6000;
    public InetAddress[] _remoteInet;
    public List<String> _remoteIpList;
    private boolean[] isConnnected;
    private final long[] RttTimes = new long[4];
    public boolean isCConn = true;
    static boolean loaded;

    private LDNetSocket() {
    }

    public static LDNetSocket getInstance() {
        if (instance == null) {
            instance = new LDNetSocket();
        }
        return instance;
    }

    public void initListener(LDNetSocketListener listener) {
        this.listener = listener;
    }

    public boolean exec(String host) {
        if (this.isCConn && loaded) {
            try {
                this.startJNITelnet(host, "80");
                return true;
            }
            catch (UnsatisfiedLinkError e) {
                e.printStackTrace();
                Log.i((String)"LDNetSocket", (String)"call jni failed, call execUseJava");
                return this.execUseJava(host);
            }
        }
        return this.execUseJava(host);
    }

    private boolean execUseJava(String host) {
        if (this._remoteInet != null && this._remoteIpList != null) {
            int len = this._remoteInet.length;
            this.isConnnected = new boolean[len];
            for (int i = 0; i < len; ++i) {
                if (i != 0) {
                    this.listener.OnNetSocketUpdated("\n");
                }
                this.isConnnected[i] = this.execIP(this._remoteInet[i], this._remoteIpList.get(i));
            }
            boolean[] blArray = this.isConnnected;
            int n = blArray.length;
            for (int i = 0; i < n; ++i) {
                Boolean i2 = blArray[i];
                if (!i2.booleanValue()) continue;
                this.listener.OnNetSocketFinished("\n");
                return true;
            }
        } else {
            this.listener.OnNetSocketFinished(HOSTERR);
        }
        this.listener.OnNetSocketFinished("\n");
        return false;
    }

    private boolean execIP(InetAddress inetAddress, String ip) {
        boolean isConnected = true;
        StringBuilder log = new StringBuilder();
        InetSocketAddress socketAddress = null;
        if (inetAddress != null && ip != null) {
            socketAddress = new InetSocketAddress(inetAddress, 80);
            int flag = 0;
            this.listener.OnNetSocketUpdated("Connect to host: " + ip + "...\n");
            for (int i = 0; i < 4; ++i) {
                this.execSocket(socketAddress, this.timeOut, i);
                if (this.RttTimes[i] == -1L) {
                    this.listener.OnNetSocketUpdated(i + 1 + "'s time=TimeOut,  ");
                    this.timeOut += 4000;
                    if (i <= 0 || this.RttTimes[i - 1] != -1L) continue;
                    flag = -1;
                    break;
                }
                if (this.RttTimes[i] == -2L) {
                    this.listener.OnNetSocketUpdated(i + 1 + "'s time=IOException");
                    if (i <= 0 || this.RttTimes[i - 1] != -2L) continue;
                    flag = -2;
                    break;
                }
                this.listener.OnNetSocketUpdated(i + 1 + "'s time=" + this.RttTimes[i] + "ms,  ");
            }
            long time = 0L;
            int count = 0;
            if (flag == -1) {
                isConnected = false;
            } else if (flag == -2) {
                isConnected = false;
            } else {
                for (int i = 0; i < 4; ++i) {
                    if (this.RttTimes[i] <= 0L) continue;
                    time += this.RttTimes[i];
                    ++count;
                }
                if (count > 0) {
                    log.append("average=" + (time /= (long)count) + "ms");
                }
            }
        } else {
            isConnected = false;
        }
        this.listener.OnNetSocketUpdated(log.toString());
        return isConnected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execSocket(InetSocketAddress socketAddress, int timeOut, int index) {
        Socket socket = null;
        long start = 0L;
        long end = 0L;
        try {
            socket = new Socket();
            start = System.currentTimeMillis();
            socket.connect(socketAddress, timeOut);
            end = System.currentTimeMillis();
            this.RttTimes[index] = end - start;
        }
        catch (SocketTimeoutException e) {
            this.RttTimes[index] = -1L;
            e.printStackTrace();
        }
        catch (IOException e) {
            this.RttTimes[index] = -2L;
            e.printStackTrace();
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void resetInstance() {
        if (instance != null) {
            instance = null;
        }
    }

    public native void startJNITelnet(String var1, String var2);

    public void printSocketInfo(String log) {
        this.listener.OnNetSocketUpdated(log);
    }

    static {
        try {
            System.loadLibrary("tracepath");
            loaded = true;
        }
        catch (UnsatisfiedLinkError e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static interface LDNetSocketListener {
        public void OnNetSocketFinished(String var1);

        public void OnNetSocketUpdated(String var1);
    }
}

