/*
 * Decompiled with CFR 0.152.
 */
package com.zhanshow.ping.netease.LDNetDiagnoService;

import android.util.Log;
import com.zhanshow.ping.netease.LDNetDiagnoUtils.LDPingParse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LDNetPing {
    LDNetPingListener listener;
    private final int _sendCount;
    private static final String MATCH_PING_IP = "(?<=from ).*(?=: icmp_seq=1 ttl=)";

    public LDNetPing(LDNetPingListener listener, int theSendCount) {
        this.listener = listener;
        this._sendCount = theSendCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String execPing(PingTask ping, boolean isNeedL) {
        String cmd = "ping -c ";
        if (isNeedL) {
            cmd = "ping -s 8185 -c  ";
        }
        Process process = null;
        String str = "";
        BufferedReader reader = null;
        try {
            process = Runtime.getRuntime().exec(cmd + this._sendCount + " " + ping.getHost());
            reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = null;
            while ((line = reader.readLine()) != null) {
                str = str + line;
            }
            reader.close();
            process.waitFor();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
                process.destroy();
            }
            catch (Exception e) {}
        }
        return str;
    }

    public void exec(String host, boolean isNeedL) {
        PingTask pingTask = new PingTask(host);
        StringBuilder log = new StringBuilder(256);
        String status = this.execPing(pingTask, isNeedL);
        if (Pattern.compile(MATCH_PING_IP).matcher(status).find()) {
            Log.i((String)"LDNetPing", (String)("status" + status));
            log.append("\t" + status);
        } else if (status.length() == 0) {
            log.append("unknown host or network error");
        } else {
            log.append("timeout");
        }
        String logStr = LDPingParse.getFormattingStr(host, log.toString());
        this.listener.OnNetPingFinished(logStr);
    }

    private class PingTask {
        private String host;
        private static final String MATCH_PING_HOST_IP = "(?<=\\().*?(?=\\))";

        public String getHost() {
            return this.host;
        }

        public PingTask(String host) {
            this.host = host;
            Pattern p = Pattern.compile(MATCH_PING_HOST_IP);
            Matcher m = p.matcher(host);
            if (m.find()) {
                this.host = m.group();
            }
        }
    }

    public static interface LDNetPingListener {
        public void OnNetPingFinished(String var1);
    }
}

