/*
 * Decompiled with CFR 0.152.
 */
package com.zhanshow.ping.netease.LDNetDiagnoService;

import android.content.Context;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.zhanshow.ping.netease.LDNetDiagnoService.LDNetAsyncTaskEx;
import com.zhanshow.ping.netease.LDNetDiagnoService.LDNetDiagnoListener;
import com.zhanshow.ping.netease.LDNetDiagnoService.LDNetPing;
import com.zhanshow.ping.netease.LDNetDiagnoService.LDNetSocket;
import com.zhanshow.ping.netease.LDNetDiagnoService.LDNetTraceRoute;
import com.zhanshow.ping.netease.LDNetDiagnoUtils.LDNetUtil;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class LDNetDiagnoService
extends LDNetAsyncTaskEx<String, String, String>
implements LDNetPing.LDNetPingListener,
LDNetTraceRoute.LDNetTraceRouteListener,
LDNetSocket.LDNetSocketListener {
    private String _appCode;
    private String _appName;
    private String _appVersion;
    private String _UID;
    private String _deviceID;
    private String _dormain;
    private String _carrierName;
    private String _ISOCountryCode;
    private String _MobileCountryCode;
    private String _MobileNetCode;
    private boolean _isNetConnected;
    private boolean _isDomainParseOk;
    private boolean _isSocketConnected;
    private Context _context;
    private String _netType;
    private String _localIp;
    private String _gateWay;
    private String _dns1;
    private String _dns2;
    private InetAddress[] _remoteInet;
    private List<String> _remoteIpList;
    private final StringBuilder _logInfo = new StringBuilder(256);
    private LDNetSocket _netSocker;
    private LDNetPing _netPinger;
    private LDNetTraceRoute _traceRouter;
    private boolean _isRunning;
    private LDNetDiagnoListener _netDiagnolistener;
    private boolean _isUseJNICConn = false;
    private boolean _isUseJNICTrace = true;
    private TelephonyManager _telManager = null;
    private static final int CORE_POOL_SIZE = 1;
    private static final int MAXIMUM_POOL_SIZE = 1;
    private static final int KEEP_ALIVE = 10;
    private static final BlockingQueue<Runnable> sWorkQueue = new LinkedBlockingQueue<Runnable>(2);
    private static final ThreadFactory sThreadFactory = new ThreadFactory(){
        private final AtomicInteger mCount = new AtomicInteger(1);

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, "Trace #" + this.mCount.getAndIncrement());
            t.setPriority(1);
            return t;
        }
    };
    private static ThreadPoolExecutor sExecutor = null;

    public LDNetDiagnoService() {
    }

    public LDNetDiagnoService(Context context, String theAppCode, String theAppName, String theAppVersion, String theUID, String theDeviceID, String theDormain, String theCarrierName, String theISOCountryCode, String theMobileCountryCode, String theMobileNetCode, LDNetDiagnoListener theListener) {
        this._context = context;
        this._appCode = theAppCode;
        this._appName = theAppName;
        this._appVersion = theAppVersion;
        this._UID = theUID;
        this._deviceID = theDeviceID;
        this._dormain = theDormain;
        this._carrierName = theCarrierName;
        this._ISOCountryCode = theISOCountryCode;
        this._MobileCountryCode = theMobileCountryCode;
        this._MobileNetCode = theMobileNetCode;
        this._netDiagnolistener = theListener;
        this._isRunning = false;
        this._remoteIpList = new ArrayList<String>();
        this._telManager = (TelephonyManager)context.getSystemService("phone");
        sExecutor = new ThreadPoolExecutor(1, 1, 10L, TimeUnit.SECONDS, sWorkQueue, sThreadFactory);
    }

    protected String doInBackground(String ... params) {
        if (this.isCancelled()) {
            return null;
        }
        return this.startNetDiagnosis();
    }

    @Override
    protected void onPostExecute(String result) {
        if (this.isCancelled()) {
            return;
        }
        super.onPostExecute(result);
        this.recordStepInfo("\n\u7f51\u7edc\u8bca\u65ad\u7ed3\u675f\n");
        this.stopNetDialogsis();
        if (this._netDiagnolistener != null) {
            this._netDiagnolistener.OnNetDiagnoFinished(this._logInfo.toString());
        }
    }

    protected void onProgressUpdate(String ... values) {
        if (this.isCancelled()) {
            return;
        }
        super.onProgressUpdate(values);
        if (this._netDiagnolistener != null) {
            this._netDiagnolistener.OnNetDiagnoUpdated(values[0]);
        }
    }

    @Override
    protected void onCancelled() {
        this.stopNetDialogsis();
    }

    public String startNetDiagnosis() {
        if (TextUtils.isEmpty((CharSequence)this._dormain)) {
            return "";
        }
        this._isRunning = true;
        this._logInfo.setLength(0);
        this.recordStepInfo("\u5f00\u59cb\u8bca\u65ad...\n");
        this.recordCurrentAppVersion();
        this.recordLocalNetEnvironmentInfo();
        if (this._isNetConnected) {
            this.recordStepInfo("\n\u5f00\u59cbTCP\u8fde\u63a5\u6d4b\u8bd5...");
            this._netSocker = LDNetSocket.getInstance();
            this._netSocker._remoteInet = this._remoteInet;
            this._netSocker._remoteIpList = this._remoteIpList;
            this._netSocker.initListener(this);
            this._netSocker.isCConn = this._isUseJNICConn;
            this._isSocketConnected = this._netSocker.exec(this._dormain);
            if (!(this._isNetConnected && this._isDomainParseOk && this._isSocketConnected)) {
                this.recordStepInfo("\n\u5f00\u59cbping...");
                this._netPinger = new LDNetPing(this, 4);
                this.recordStepInfo("ping...127.0.0.1");
                this._netPinger.exec("127.0.0.1", false);
                this.recordStepInfo("ping\u672c\u673aIP..." + this._localIp);
                this._netPinger.exec(this._localIp, false);
                if ("WIFI".equals(this._netType)) {
                    this.recordStepInfo("ping\u672c\u5730\u7f51\u5173..." + this._gateWay);
                    this._netPinger.exec(this._gateWay, false);
                }
                this.recordStepInfo("ping\u672c\u5730DNS1..." + this._dns1);
                this._netPinger.exec(this._dns1, false);
                this.recordStepInfo("ping\u672c\u5730DNS2..." + this._dns2);
                this._netPinger.exec(this._dns2, false);
            }
            if (this._netPinger == null) {
                this._netPinger = new LDNetPing(this, 4);
            }
            if (this._netPinger != null) {
                // empty if block
            }
            this.recordStepInfo("\n\u5f00\u59cbtraceroute...");
            this._traceRouter = LDNetTraceRoute.getInstance();
            this._traceRouter.initListenter(this);
            this._traceRouter.isCTrace = this._isUseJNICTrace;
            this._traceRouter.startTraceRoute(this._dormain);
            return this._logInfo.toString();
        }
        this.recordStepInfo("\n\n\u5f53\u524d\u4e3b\u673a\u672a\u8054\u7f51,\u8bf7\u68c0\u67e5\u7f51\u7edc\uff01");
        return this._logInfo.toString();
    }

    public void stopNetDialogsis() {
        if (this._isRunning) {
            if (this._netSocker != null) {
                this._netSocker.resetInstance();
                this._netSocker = null;
            }
            if (this._netPinger != null) {
                this._netPinger = null;
            }
            if (this._traceRouter != null) {
                this._traceRouter.resetInstance();
                this._traceRouter = null;
            }
            this.cancel(true);
            if (sExecutor != null && !sExecutor.isShutdown()) {
                sExecutor.shutdown();
                sExecutor = null;
            }
            this._isRunning = false;
        }
    }

    public void setIfUseJNICConn(boolean use) {
        this._isUseJNICConn = use;
    }

    public void setIfUseJNICTrace(boolean use) {
        this._isUseJNICTrace = use;
    }

    public void printLogInfo() {
        System.out.print(this._logInfo);
    }

    private void recordStepInfo(String stepInfo) {
        this._logInfo.append(stepInfo + "\n");
        this.publishProgress(stepInfo + "\n");
    }

    @Override
    public void OnNetTraceFinished() {
    }

    @Override
    public void OnNetTraceUpdated(String log) {
        if (log == null) {
            return;
        }
        if (this._traceRouter != null && this._traceRouter.isCTrace) {
            if (log.contains("ms") || log.contains("***")) {
                log = log + "\n";
            }
            this._logInfo.append(log);
            this.publishProgress(log);
        } else {
            this.recordStepInfo(log);
        }
    }

    @Override
    public void OnNetSocketFinished(String log) {
        this._logInfo.append(log);
        this.publishProgress(log);
    }

    @Override
    public void OnNetSocketUpdated(String log) {
        this._logInfo.append(log);
        this.publishProgress(log);
    }

    private void recordCurrentAppVersion() {
        this.recordStepInfo("\u5e94\u7528\u7248\u672c:\t" + this._appVersion);
        this.recordStepInfo("\u673a\u5668\u7c7b\u578b:\t" + Build.MANUFACTURER + ":" + Build.BRAND + ":" + Build.MODEL);
        this.recordStepInfo("\u7cfb\u7edf\u7248\u672c:\t" + Build.VERSION.RELEASE);
        if (this._telManager != null && TextUtils.isEmpty((CharSequence)this._deviceID)) {
            try {
                this._deviceID = this._telManager.getDeviceId();
            }
            catch (Exception e) {
                e.printStackTrace();
                this._deviceID = "";
            }
        }
        this.recordStepInfo("\u673a\u5668ID:\t" + this._deviceID);
        if (TextUtils.isEmpty((CharSequence)this._carrierName)) {
            this._carrierName = LDNetUtil.getMobileOperator(this._context);
        }
        this.recordStepInfo("\u8fd0\u8425\u5546:\t" + this._carrierName);
        if (this._telManager != null && TextUtils.isEmpty((CharSequence)this._ISOCountryCode)) {
            this._ISOCountryCode = this._telManager.getNetworkCountryIso();
        }
        this.recordStepInfo("ISOCountryCode:\t" + this._ISOCountryCode);
        if (this._telManager != null && TextUtils.isEmpty((CharSequence)this._MobileCountryCode)) {
            String tmp = this._telManager.getNetworkOperator();
            if (tmp.length() >= 3) {
                this._MobileCountryCode = tmp.substring(0, 3);
            }
            if (tmp.length() >= 5) {
                this._MobileNetCode = tmp.substring(3, 5);
            }
        }
        this.recordStepInfo("MobileCountryCode:\t" + this._MobileCountryCode);
        this.recordStepInfo("MobileNetworkCode:\t" + this._MobileNetCode + "\n");
    }

    private void recordLocalNetEnvironmentInfo() {
        this.recordStepInfo("\u8bca\u65ad\u57df\u540d " + this._dormain + "...");
        if (LDNetUtil.isNetworkConnected(this._context).booleanValue()) {
            this._isNetConnected = true;
            this.recordStepInfo("\u5f53\u524d\u662f\u5426\u8054\u7f51:\t\u5df2\u8054\u7f51");
        } else {
            this._isNetConnected = false;
            this.recordStepInfo("\u5f53\u524d\u662f\u5426\u8054\u7f51:\t\u672a\u8054\u7f51");
        }
        this._netType = LDNetUtil.getNetWorkType(this._context);
        this.recordStepInfo("\u5f53\u524d\u8054\u7f51\u7c7b\u578b:\t" + this._netType);
        if (this._isNetConnected) {
            if ("WIFI".equals(this._netType)) {
                this._localIp = LDNetUtil.getLocalIpByWifi(this._context);
                this._gateWay = LDNetUtil.pingGateWayInWifi(this._context);
            } else {
                this._localIp = LDNetUtil.getLocalIpBy3G();
            }
            this.recordStepInfo("\u672c\u5730IP:\t" + this._localIp);
        } else {
            this.recordStepInfo("\u672c\u5730IP:\t127.0.0.1");
        }
        if (this._gateWay != null) {
            this.recordStepInfo("\u672c\u5730\u7f51\u5173:\t" + this._gateWay);
        }
        if (this._isNetConnected) {
            this._dns1 = LDNetUtil.getLocalDns("dns1");
            this._dns2 = LDNetUtil.getLocalDns("dns2");
            this.recordStepInfo("\u672c\u5730DNS:\t" + this._dns1 + "," + this._dns2);
        } else {
            this.recordStepInfo("\u672c\u5730DNS:\t0.0.0.0,0.0.0.0");
        }
        if (this._isNetConnected) {
            this.recordStepInfo("\u8fdc\u7aef\u57df\u540d:\t" + this._dormain);
            this._isDomainParseOk = this.parseDomain(this._dormain);
        }
    }

    private boolean parseDomain(String _dormain) {
        boolean flag = false;
        int len = 0;
        String ipString = "";
        Map<String, Object> map = LDNetUtil.getDomainIp(_dormain);
        String useTime = (String)map.get("useTime");
        this._remoteInet = (InetAddress[])map.get("remoteInet");
        String timeShow = null;
        timeShow = Integer.parseInt(useTime) > 5000 ? " (" + Integer.parseInt(useTime) / 1000 + "s)" : " (" + useTime + "ms)";
        if (this._remoteInet != null) {
            len = this._remoteInet.length;
            for (int i = 0; i < len; ++i) {
                this._remoteIpList.add(this._remoteInet[i].getHostAddress());
                ipString = ipString + this._remoteInet[i].getHostAddress() + ",";
            }
            ipString = ipString.substring(0, ipString.length() - 1);
            this.recordStepInfo("DNS\u89e3\u6790\u7ed3\u679c:\t" + ipString + timeShow);
            flag = true;
        } else if (Integer.parseInt(useTime) > 10000) {
            map = LDNetUtil.getDomainIp(_dormain);
            useTime = (String)map.get("useTime");
            this._remoteInet = (InetAddress[])map.get("remoteInet");
            timeShow = Integer.parseInt(useTime) > 5000 ? " (" + Integer.parseInt(useTime) / 1000 + "s)" : " (" + useTime + "ms)";
            if (this._remoteInet != null) {
                len = this._remoteInet.length;
                for (int i = 0; i < len; ++i) {
                    this._remoteIpList.add(this._remoteInet[i].getHostAddress());
                    ipString = ipString + this._remoteInet[i].getHostAddress() + ",";
                }
                ipString = ipString.substring(0, ipString.length() - 1);
                this.recordStepInfo("DNS\u89e3\u6790\u7ed3\u679c:\t" + ipString + timeShow);
                flag = true;
            } else {
                this.recordStepInfo("DNS\u89e3\u6790\u7ed3\u679c:\t\u89e3\u6790\u5931\u8d25" + timeShow);
            }
        } else {
            this.recordStepInfo("DNS\u89e3\u6790\u7ed3\u679c:\t\u89e3\u6790\u5931\u8d25" + timeShow);
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String requestOperatorInfo() {
        String res = null;
        String url = "";
        HttpURLConnection conn = null;
        try {
            URL Operator_url = new URL(url);
            conn = (HttpURLConnection)Operator_url.openConnection();
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(10000);
            conn.connect();
            int responseCode = conn.getResponseCode();
            if (responseCode == 200) {
                res = LDNetUtil.getStringFromStream(conn.getInputStream());
                if (conn != null) {
                    conn.disconnect();
                }
            }
            String string = res;
            return string;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return res;
    }

    @Override
    public void OnNetPingFinished(String log) {
        this.recordStepInfo(log);
    }

    @Override
    protected ThreadPoolExecutor getThreadPoolExecutor() {
        return sExecutor;
    }
}

