/*
 * Decompiled with CFR 0.152.
 */
package com.zhanshow.ping.netease.LDNetDiagnoService;

import android.os.Handler;
import android.os.Message;
import android.util.Log;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadPoolExecutor;

public abstract class LDNetAsyncTaskEx<Params, Progress, Result> {
    private static final int MESSAGE_POST_RESULT = 1;
    private static final int MESSAGE_POST_PROGRESS = 2;
    private static final int MESSAGE_POST_CANCEL = 3;
    private volatile Status mStatus = Status.PENDING;
    private static final LDNetInternalHandler sHandler = new LDNetInternalHandler();
    private final LDNetWorkerRunnable<Params, Result> mWorker = new LDNetWorkerRunnable<Params, Result>(){

        @Override
        public Result call() throws Exception {
            return LDNetAsyncTaskEx.this.doInBackground(this.mParams);
        }
    };
    private final FutureTask<Result> mFuture = new FutureTask<Result>(this.mWorker){

        @Override
        protected void done() {
            Object result = null;
            try {
                result = this.get();
            }
            catch (InterruptedException e) {
                Log.w((String)this.getClass().getSimpleName(), (Throwable)e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException("An error occured while executing doInBackground()", e.getCause());
            }
            catch (CancellationException e) {
                Message message = sHandler.obtainMessage(3, new LDNetAsyncTaskResult<Object>(LDNetAsyncTaskEx.this, null));
                message.sendToTarget();
                return;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            Message message = sHandler.obtainMessage(1, new LDNetAsyncTaskResult<Object>(LDNetAsyncTaskEx.this, result));
            message.sendToTarget();
        }
    };

    public final Status getStatus() {
        return this.mStatus;
    }

    protected abstract Result doInBackground(Params ... var1);

    protected void onPreExecute() {
    }

    protected void onPostExecute(Result result) {
    }

    protected void onProgressUpdate(Progress ... values) {
    }

    protected void onCancelled() {
    }

    public final boolean isCancelled() {
        return this.mFuture.isCancelled();
    }

    public final boolean cancel(boolean mayInterruptIfRunning) {
        return this.mFuture.cancel(mayInterruptIfRunning);
    }

    public final LDNetAsyncTaskEx<Params, Progress, Result> execute(Params ... params) {
        if (this.mStatus != Status.PENDING) {
            switch (this.mStatus) {
                case RUNNING: {
                    throw new IllegalStateException("Cannot execute task: the task is already running.");
                }
                case FINISHED: {
                    throw new IllegalStateException("Cannot execute task: the task has already been executed (a task can be executed only once)");
                }
            }
        }
        this.mStatus = Status.RUNNING;
        this.onPreExecute();
        this.mWorker.mParams = params;
        ThreadPoolExecutor sExecutor = this.getThreadPoolExecutor();
        if (sExecutor != null) {
            sExecutor.execute(this.mFuture);
            return this;
        }
        return null;
    }

    protected abstract ThreadPoolExecutor getThreadPoolExecutor();

    protected final void publishProgress(Progress ... values) {
        sHandler.obtainMessage(2, new LDNetAsyncTaskResult<Progress>(this, values)).sendToTarget();
    }

    protected void finish(Result result) {
        if (this.isCancelled()) {
            result = null;
        }
        this.onPostExecute(result);
        this.mStatus = Status.FINISHED;
    }

    private static class LDNetAsyncTaskResult<Data> {
        final LDNetAsyncTaskEx mTask;
        final Data[] mData;

        LDNetAsyncTaskResult(LDNetAsyncTaskEx task, Data ... data) {
            this.mTask = task;
            this.mData = data;
        }
    }

    private static abstract class LDNetWorkerRunnable<Params, Result>
    implements Callable<Result> {
        Params[] mParams;

        private LDNetWorkerRunnable() {
        }
    }

    private static class LDNetInternalHandler
    extends Handler {
        private LDNetInternalHandler() {
        }

        public void handleMessage(Message msg) {
            LDNetAsyncTaskResult result = (LDNetAsyncTaskResult)msg.obj;
            switch (msg.what) {
                case 1: {
                    result.mTask.finish(result.mData[0]);
                    break;
                }
                case 2: {
                    result.mTask.onProgressUpdate(result.mData);
                    break;
                }
                case 3: {
                    result.mTask.onCancelled();
                }
            }
        }
    }

    public static enum Status {
        PENDING,
        RUNNING,
        FINISHED;

    }
}

