/*
 * Decompiled with CFR 0.152.
 */
package com.zhanshow.ping.Utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class ZipUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zip(String src, String dest) throws IOException {
        ZipOutputStream out = null;
        try {
            File outFile = new File(dest);
            File fileOrDirectory = new File(src);
            out = new ZipOutputStream(new FileOutputStream(outFile));
            if (fileOrDirectory.isFile()) {
                ZipUtils.zipFileOrDirectory(out, fileOrDirectory, "");
            } else {
                File[] entries = fileOrDirectory.listFiles();
                for (int i = 0; i < entries.length; ++i) {
                    ZipUtils.zipFileOrDirectory(out, entries[i], "");
                }
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void zipFileOrDirectory(ZipOutputStream out, File fileOrDirectory, String curPath) throws IOException {
        FileInputStream in = null;
        try {
            if (!fileOrDirectory.isDirectory()) {
                int bytes_read;
                byte[] buffer = new byte[4096];
                in = new FileInputStream(fileOrDirectory);
                ZipEntry entry = new ZipEntry(curPath + fileOrDirectory.getName());
                out.putNextEntry(entry);
                while ((bytes_read = in.read(buffer)) != -1) {
                    out.write(buffer, 0, bytes_read);
                }
                out.closeEntry();
            } else {
                File[] entries = fileOrDirectory.listFiles();
                for (int i = 0; i < entries.length; ++i) {
                    ZipUtils.zipFileOrDirectory(out, entries[i], curPath + fileOrDirectory.getName() + "/");
                }
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public static void unzip(String zipFileName, String outputDirectory) throws IOException {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(zipFileName);
            Enumeration<? extends ZipEntry> e = zipFile.entries();
            ZipEntry zipEntry = null;
            File dest = new File(outputDirectory);
            dest.mkdirs();
            while (e.hasMoreElements()) {
                zipEntry = e.nextElement();
                String entryName = zipEntry.getName();
                InputStream in = null;
                FileOutputStream out = null;
                try {
                    int c;
                    File df;
                    File f;
                    if (zipEntry.isDirectory()) {
                        String name = zipEntry.getName();
                        name = name.substring(0, name.length() - 1);
                        f = new File(outputDirectory + File.separator + name);
                        f.mkdirs();
                        continue;
                    }
                    int index = entryName.lastIndexOf("\\");
                    if (index != -1) {
                        df = new File(outputDirectory + File.separator + entryName.substring(0, index));
                        df.mkdirs();
                    }
                    if ((index = entryName.lastIndexOf("/")) != -1) {
                        df = new File(outputDirectory + File.separator + entryName.substring(0, index));
                        df.mkdirs();
                    }
                    f = new File(outputDirectory + File.separator + zipEntry.getName());
                    in = zipFile.getInputStream(zipEntry);
                    out = new FileOutputStream(f);
                    byte[] by = new byte[1024];
                    while ((c = in.read(by)) != -1) {
                        out.write(by, 0, c);
                    }
                    out.flush();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    throw new IOException("\u89e3\u538b\u5931\u8d25\uff1a" + ex.toString());
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (out == null) continue;
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new IOException("\u89e3\u538b\u5931\u8d25\uff1a" + ex.toString());
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

