/*
 * Decompiled with CFR 0.152.
 */
package com.zhanshow.ping.Utils.NetInfo;

import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import java.util.UUID;

public class SystemBasicInfo {
    public static String getBuildInfo() {
        StringBuilder builder = new StringBuilder();
        builder.append("Product:" + Build.PRODUCT);
        builder.append("\nTags:" + Build.TAGS);
        builder.append("\nCPU_ABI:" + Build.CPU_ABI);
        builder.append("\nVERSION_CODES.BASE:1");
        builder.append("\nMODEL:" + Build.MODEL);
        builder.append("\nSDK:" + Build.VERSION.SDK);
        builder.append("\nVERSION.RELEASE:" + Build.VERSION.RELEASE);
        builder.append("\nDEVICE:" + Build.DEVICE);
        builder.append("\nBrand:" + Build.BRAND);
        builder.append("\nBoard:" + Build.BOARD);
        builder.append("\nFINGERPRINT:" + Build.FINGERPRINT);
        builder.append("\nID:" + Build.ID);
        builder.append("\nManufacturer:" + Build.MANUFACTURER);
        builder.append("\nUser:" + Build.USER);
        return builder.toString();
    }

    public static String getUUID(Context context) {
        try {
            String androidId = SystemBasicInfo.getAndroidId(context);
            String deviceId = SystemBasicInfo.getDeviceId(context) == null ? "null" : SystemBasicInfo.getDeviceId(context);
            UUID uuid = new UUID(androidId.hashCode(), (long)deviceId.hashCode() << 32 | (long)deviceId.hashCode());
            return uuid.toString();
        }
        catch (Exception e) {
            return "null";
        }
    }

    public static String getAndroidId(Context context) {
        try {
            return Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        }
        catch (Exception e) {
            return "null";
        }
    }

    public static String getDeviceId(Context context) {
        try {
            TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
            return tm.getDeviceId();
        }
        catch (Exception e) {
            return "null";
        }
    }
}

