/*
 * Decompiled with CFR 0.152.
 */
package com.zhanshow.ping.Utils.NetInfo;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.telephony.TelephonyManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import org.apache.http.conn.util.InetAddressUtils;

public class NetBasicInfo {
    public static final String WIFI_NETINTERFACE = "wlan0";
    public static final String MOBILE_NETINTERFACE = "p2p0";
    public static final String APN_CMWAP = "cmwap";
    public static final String APN_CMNET = "cmnet";
    public static final String APN_UNIWAP = "uniwap";
    public static final String APN_UNINET = "uninet";
    public static final String APN_UNI3gWAP = "3gwap";
    public static final String APN_UNI3gNET = "3gnet";
    public static final String APN_CTWAP = "ctwap";
    public static final String APN_CTNET = "ctnet";
    public static final String APN_CTLTE = "ctlte";
    public static final int NETWORK_TYPE_UNKNOWN = 0;
    public static final int NETWORK_TYPE_GPRS = 1;
    public static final int NETWORK_TYPE_EDGE = 2;
    public static final int NETWORK_TYPE_UMTS = 3;
    public static final int NETWORK_TYPE_CDMA = 4;
    public static final int NETWORK_TYPE_EVDO_0 = 5;
    public static final int NETWORK_TYPE_EVDO_A = 6;
    public static final int NETWORK_TYPE_1xRTT = 7;
    public static final int NETWORK_TYPE_HSDPA = 8;
    public static final int NETWORK_TYPE_HSUPA = 9;
    public static final int NETWORK_TYPE_HSPA = 10;
    public static final int NETWORK_TYPE_IDEN = 11;
    public static final int NETWORK_TYPE_EVDO_B = 12;
    public static final int NETWORK_TYPE_LTE = 13;
    public static final int NETWORK_TYPE_EHRPD = 14;
    public static final int NETWORK_TYPE_HSPAP = 15;
    public static final int NETWORK_TYPE_SCDMA = 17;
    public static final int NETWOR_TYPE_TDS_HSDPA = 18;
    public static final int NETWORK_CLASS_UNKNOWN = 0;
    public static final int NETWORK_CLASS_2_G = 1;
    public static final int NETWORK_CLASS_3_G = 2;
    public static final int NETWORK_CLASS_4_G = 3;
    private static volatile NetBasicInfo m_Instance = null;
    private String mNetInterface = "wlan0";
    private Context mContext;

    private NetBasicInfo(Context context) {
        this.mContext = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NetBasicInfo getInstance(Context context) {
        if (m_Instance != null) return m_Instance;
        Class<NetBasicInfo> clazz = NetBasicInfo.class;
        synchronized (NetBasicInfo.class) {
            if (m_Instance != null) return m_Instance;
            m_Instance = new NetBasicInfo(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return m_Instance;
        }
    }

    public static int getNetworkClass(int networkType) {
        switch (networkType) {
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 11: {
                return 1;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: {
                return 2;
            }
            case 13: {
                return 3;
            }
        }
        return 0;
    }

    public String getMacAddress(String netInterface) {
        String strMacAddr = "";
        try {
            NetworkInterface NIC = NetworkInterface.getByName(netInterface);
            if (NIC == null) {
                NIC = NetworkInterface.getByName("rmnet0");
                strMacAddr = "\u6ca1\u6709 " + netInterface + " \u7f51\u5361";
            }
            if (NIC != null) {
                byte[] b = NIC.getHardwareAddress();
                if (b == null) {
                    return strMacAddr;
                }
                StringBuffer buffer = new StringBuffer();
                for (int i = 0; i < b.length; ++i) {
                    String str;
                    if (i != 0) {
                        buffer.append(':');
                    }
                    buffer.append((str = Integer.toHexString(b[i] & 0xFF)).length() == 1 ? 0 + str : str);
                }
                strMacAddr = buffer.toString().toUpperCase();
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        return strMacAddr;
    }

    public String getApnInfo() {
        TelephonyManager tel = (TelephonyManager)this.mContext.getSystemService("phone");
        String opCode = tel.getSimOperator();
        String operatorName = opCode.startsWith("46000") || opCode.startsWith("46002") ? "\u4e2d\u56fd\u79fb\u52a8" : (opCode.equals("46001") ? "\u4e2d\u56fd\u8054\u901a" : (opCode.equals("46003") ? "\u4e2d\u56fd\u7535\u4fe1" : "\u672a\u77e5"));
        ConnectivityManager mag = (ConnectivityManager)this.mContext.getSystemService("connectivity");
        NetworkInfo mobInfo = mag.getNetworkInfo(0);
        NetworkInfo wifiInfo = mag.getNetworkInfo(1);
        StringBuilder mOutputString = new StringBuilder();
        mOutputString.append("MNC Code Info:\n");
        mOutputString.append("IMSI=" + opCode + " <" + operatorName + ">\n");
        mOutputString.append("\nMobile Network Info:\n");
        if (mobInfo != null && mobInfo.getExtraInfo() != null) {
            mOutputString.append("\u8fd0\u8425\u5546\u7c7b\u578b\uff1a");
            if (mobInfo.getExtraInfo().equals(APN_CMWAP) || mobInfo.getExtraInfo().equals(APN_CMNET)) {
                mOutputString.append("\u79fb\u52a8");
            } else if (mobInfo.getExtraInfo().equals(APN_UNIWAP) || mobInfo.getExtraInfo().equals(APN_UNINET) || mobInfo.getExtraInfo().equals(APN_UNI3gWAP) || mobInfo.getExtraInfo().equals(APN_UNI3gNET)) {
                mOutputString.append("\u8054\u901a");
            } else if (mobInfo.getExtraInfo().equals(APN_CTWAP) || mobInfo.getExtraInfo().equals(APN_CTNET) || mobInfo.getExtraInfo().equals(APN_CTLTE)) {
                mOutputString.append("\u7535\u4fe1");
            } else {
                mOutputString.append(operatorName);
            }
            if (mobInfo.getExtraInfo().contains("wap")) {
                mOutputString.append("--Wap");
            } else if (mobInfo.getExtraInfo().contains("net")) {
                mOutputString.append("--Net");
            } else {
                mOutputString.append("--Unkown");
            }
            mOutputString.append("\n\u7f51\u7edc\u7c7b\u578b\uff1a");
            int netType = NetBasicInfo.getNetworkClass(mobInfo.getSubtype());
            switch (netType) {
                case 1: {
                    mOutputString.append("2G\n");
                    break;
                }
                case 2: {
                    mOutputString.append("3G\n");
                    break;
                }
                case 3: {
                    mOutputString.append("4G\n");
                    break;
                }
                default: {
                    mOutputString.append("\u672a\u77e5\n");
                }
            }
        }
        if (mobInfo != null) {
            mOutputString.append("ExtraInfo=" + mobInfo.getExtraInfo() + "\n");
            mOutputString.append("SubtypeName=" + mobInfo.getSubtypeName() + "  SubType = " + mobInfo.getSubtype() + "\n");
            mOutputString.append("TypeName=" + mobInfo.getTypeName() + "  Type = " + mobInfo.getType() + "\n");
        }
        mOutputString.append("\nWIFI Network Info:\n");
        mOutputString.append("ExtraInfo=" + wifiInfo.getExtraInfo() + "\n");
        mOutputString.append("SubtypeName=" + wifiInfo.getSubtypeName() + "  SubType = " + wifiInfo.getSubtype() + "\n");
        mOutputString.append("TypeName=" + wifiInfo.getTypeName() + "  Type = " + wifiInfo.getType() + "\n");
        mOutputString.append("\nIP Info:\n");
        mOutputString.append("IPv4 Address=" + this.GetIp(true) + "\n");
        mOutputString.append("IPv6 Address=" + this.GetIp(false) + "\n");
        mOutputString.append("DNS Address=" + this.getLocalDNS() + "\n");
        return mOutputString.toString();
    }

    public String GetIp(Boolean isV4) {
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface intf = en.nextElement();
                Enumeration<InetAddress> ipAddr = intf.getInetAddresses();
                while (ipAddr.hasMoreElements()) {
                    InetAddress inetAddress = ipAddr.nextElement();
                    if (!(isV4 != false ? !inetAddress.isLoopbackAddress() && InetAddressUtils.isIPv4Address((String)inetAddress.getHostAddress()) : !inetAddress.isLoopbackAddress() && InetAddressUtils.isIPv6Address((String)inetAddress.getHostAddress()))) continue;
                    return inetAddress.getHostAddress();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getLocalDNS() {
        Process cmdProcess = null;
        BufferedReader reader = null;
        String dnsIP = "";
        try {
            cmdProcess = Runtime.getRuntime().exec("getprop net.dns1");
            reader = new BufferedReader(new InputStreamReader(cmdProcess.getInputStream()));
            String string = dnsIP = reader.readLine();
            return string;
        }
        catch (IOException e) {
            String string = null;
            return string;
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (cmdProcess != null) {
                cmdProcess.destroy();
            }
        }
    }
}

