/*
 * Decompiled with CFR 0.152.
 */
package com.zhanshow.ping.Utils;

import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Environment;
import android.provider.MediaStore;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public class FileUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMd5ByFile(File file) {
        FileInputStream in = null;
        try {
            int byteCount;
            in = new FileInputStream(file);
            MessageDigest digester = MessageDigest.getInstance("MD5");
            byte[] bytes = new byte[8192];
            while ((byteCount = in.read(bytes)) > 0) {
                digester.update(bytes, 0, byteCount);
            }
            byte[] digest = digester.digest();
            BigInteger bi = new BigInteger(1, digest);
            String string = String.format("%032x", bi);
            return string;
        }
        catch (Exception e) {
            String string = "";
            return string;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static String getMd5(String source) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.update(source.getBytes());
            BigInteger bi = new BigInteger(1, md5.digest());
            return String.format("%032x", bi);
        }
        catch (Exception e) {
            return "";
        }
    }

    public static File getDataRoot() {
        try {
            if (Environment.getExternalStorageState().equals("mounted") || Environment.getExternalStorageDirectory().exists() && Environment.getExternalStorageDirectory().canWrite()) {
                return Environment.getExternalStorageDirectory();
            }
            return Environment.getDataDirectory();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static File getAppRoot() {
        try {
            File nomedia;
            File root = new File(FileUtil.getDataRoot(), "com.jd.wxsq.app");
            if (!root.exists()) {
                root.mkdirs();
            }
            if (!(nomedia = new File(root, ".nomedia")).exists()) {
                nomedia.createNewFile();
            }
            return root;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static File getModuleRoot() {
        try {
            File root = new File(FileUtil.getAppRoot(), "module");
            if (!root.exists()) {
                root.mkdirs();
            }
            return root;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static File getUpdateRoot() {
        try {
            File root = new File(FileUtil.getAppRoot(), "update");
            if (!root.exists()) {
                root.mkdirs();
            }
            return root;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static File getConfigRoot() {
        File root = new File(FileUtil.getAppRoot(), "config");
        if (!root.exists()) {
            root.mkdirs();
        }
        return root;
    }

    public static File getLogRoot() {
        File root = new File(FileUtil.getAppRoot(), "logs");
        if (!root.exists()) {
            root.mkdirs();
        }
        return root;
    }

    public static File getDcimRoot() {
        File root = new File(Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DCIM), "/JZYC/");
        if (!root.exists()) {
            root.mkdirs();
        }
        return root;
    }

    public static File getWardrobeRoot() {
        File root = new File(FileUtil.getAppRoot(), "wardrobe");
        if (!root.exists()) {
            root.mkdirs();
        }
        return root;
    }

    public static File getHeadImageRoot() {
        File root = new File(FileUtil.getAppRoot(), "headimage");
        if (!root.exists()) {
            root.mkdirs();
        }
        return root;
    }

    public static File getMatchRoot() {
        File root = new File(FileUtil.getAppRoot(), "match");
        if (!root.exists()) {
            root.mkdirs();
        }
        return root;
    }

    public static File getCopyRoot() {
        File root = new File(FileUtil.getAppRoot(), "copy");
        if (!root.exists()) {
            root.mkdirs();
        }
        return root;
    }

    private static File getFileByPath(String path, boolean isDir) {
        File fileModuleRoot = FileUtil.getModuleRoot();
        File file = new File(fileModuleRoot, path);
        if (!file.exists()) {
            if (isDir) {
                file.mkdirs();
            } else {
                file.getParentFile().mkdirs();
                file = new File(fileModuleRoot, path);
            }
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzipFile(String filePath, String unzipPath) {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(filePath);
            Enumeration<? extends ZipEntry> entry = zipFile.entries();
            while (entry.hasMoreElements()) {
                ZipEntry zipEntry = entry.nextElement();
                if (zipEntry.isDirectory()) continue;
                if (zipEntry.getSize() > 0L) {
                    File file = FileUtil.getFileByPath(unzipPath + "/" + zipEntry.getName(), false);
                    BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));
                    InputStream is = zipFile.getInputStream(zipEntry);
                    byte[] buffer = new byte[4096];
                    int len = 0;
                    while ((len = is.read(buffer)) >= 0) {
                        ((OutputStream)os).write(buffer, 0, len);
                    }
                    ((OutputStream)os).flush();
                    ((OutputStream)os).close();
                    continue;
                }
                FileUtil.getFileByPath(unzipPath + "/" + zipEntry.getName(), true);
            }
            zipFile.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzipAssetModule(Context context) {
        if (context == null || context.getResources() == null || context.getResources().getAssets() == null) {
            return;
        }
        ZipInputStream in = null;
        OutputStream os = null;
        try {
            InputStream is = context.getResources().getAssets().open("module.zip");
            in = new ZipInputStream(is);
            ZipEntry entry = in.getNextEntry();
            while (entry != null) {
                File file;
                if (entry.isDirectory()) {
                    file = new File(FileUtil.getAppRoot(), entry.getName());
                    if (!file.exists()) {
                        file.mkdirs();
                    }
                } else {
                    file = new File(FileUtil.getAppRoot(), entry.getName());
                    os = new BufferedOutputStream(new FileOutputStream(file));
                    byte[] buffer = new byte[1000000];
                    int len = 0;
                    while ((len = in.read(buffer)) >= 0) {
                        os.write(buffer, 0, len);
                    }
                    os.flush();
                }
                entry = in.getNextEntry();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void copyDir(String src, String dst) {
        try {
            File fileSrc = new File(src);
            if (!fileSrc.exists()) {
                return;
            }
            File[] filelist = fileSrc.listFiles();
            File fileDst = new File(dst);
            if (!fileDst.exists()) {
                fileDst.mkdirs();
            }
            for (File f : filelist) {
                if (f.isDirectory()) {
                    FileUtil.copyDir(f.getPath() + "/", dst + f.getName() + "/");
                    continue;
                }
                FileUtil.copyFile(f.getPath(), dst + f.getName());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(String src, String dst) {
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            in = new FileInputStream(src);
            out = new FileOutputStream(dst);
            byte[] b = new byte[5120];
            int len = 0;
            while ((len = in.read(b)) > 0) {
                out.write(b, 0, len);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void deleteAlbumFile(Context context, String filePath) {
        File photo = new File(filePath);
        if (!photo.exists()) {
            return;
        }
        photo.delete();
        context.getContentResolver().delete(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, "_data=?", new String[]{photo.getAbsolutePath()});
        context.sendBroadcast(new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE", Uri.parse((String)("file://" + photo))));
    }

    public static void saveImageToGallery(Context context, String filePath) {
        StringBuilder path = new StringBuilder();
        String[] aa = filePath.split("\\/");
        for (int i = 0; i < aa.length - 1; ++i) {
            path.append(aa[i]);
            path.append("/");
        }
        try {
            MediaStore.Images.Media.insertImage((ContentResolver)context.getContentResolver(), (String)path.toString(), (String)filePath, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        context.sendBroadcast(new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE", Uri.parse((String)("file://" + filePath))));
    }

    public static void deleteFiles(File file) {
        try {
            if (file.exists()) {
                if (file.isDirectory()) {
                    File[] childFiles;
                    for (File f : childFiles = file.listFiles()) {
                        FileUtil.deleteFiles(f);
                    }
                } else {
                    file.delete();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

