/*
 * Decompiled with CFR 0.152.
 */
package com.zhanshow.ping.Utils;

import java.util.Calendar;
import java.util.TimeZone;

public class DatatypeConverter {
    private static final byte[] decodeMap = DatatypeConverter.initDecodeMap();
    private static final byte PADDING = 127;

    public static String doFormat(String format, Calendar cal) throws IllegalArgumentException {
        int fidx = 0;
        int flen = format.length();
        StringBuilder buf = new StringBuilder();
        block9: while (fidx < flen) {
            char fch;
            if ((fch = format.charAt(fidx++)) != '%') {
                buf.append(fch);
                continue;
            }
            switch (format.charAt(fidx++)) {
                case 'Y': {
                    DatatypeConverter.formatYear(cal, buf);
                    continue block9;
                }
                case 'M': {
                    DatatypeConverter.formatMonth(cal, buf);
                    continue block9;
                }
                case 'D': {
                    DatatypeConverter.formatDays(cal, buf);
                    continue block9;
                }
                case 'h': {
                    DatatypeConverter.formatHours(cal, buf);
                    continue block9;
                }
                case 'm': {
                    DatatypeConverter.formatMinutes(cal, buf);
                    continue block9;
                }
                case 's': {
                    DatatypeConverter.formatSeconds(cal, buf);
                    continue block9;
                }
                case 'z': {
                    DatatypeConverter.formatTimeZone(cal, buf);
                    continue block9;
                }
            }
            throw new InternalError();
        }
        return buf.toString();
    }

    private static void formatYear(Calendar cal, StringBuilder buf) {
        int year = cal.get(1);
        String s = year <= 0 ? Integer.toString(1 - year) : Integer.toString(year);
        while (s.length() < 4) {
            s = '0' + s;
        }
        if (year <= 0) {
            s = '-' + s;
        }
        buf.append(s);
    }

    private static void formatMonth(Calendar cal, StringBuilder buf) {
        DatatypeConverter.formatTwoDigits(cal.get(2) + 1, buf);
    }

    private static void formatDays(Calendar cal, StringBuilder buf) {
        DatatypeConverter.formatTwoDigits(cal.get(5), buf);
    }

    private static void formatHours(Calendar cal, StringBuilder buf) {
        DatatypeConverter.formatTwoDigits(cal.get(11), buf);
    }

    private static void formatMinutes(Calendar cal, StringBuilder buf) {
        DatatypeConverter.formatTwoDigits(cal.get(12), buf);
    }

    private static void formatSeconds(Calendar cal, StringBuilder buf) {
        int n;
        DatatypeConverter.formatTwoDigits(cal.get(13), buf);
        if (cal.isSet(14) && (n = cal.get(14)) != 0) {
            String ms = Integer.toString(n);
            while (ms.length() < 3) {
                ms = '0' + ms;
            }
            buf.append('.');
            buf.append(ms);
        }
    }

    private static void formatTimeZone(Calendar cal, StringBuilder buf) {
        TimeZone tz = cal.getTimeZone();
        if (tz == null) {
            return;
        }
        int offset = tz.inDaylightTime(cal.getTime()) ? tz.getRawOffset() + (tz.useDaylightTime() ? 3600000 : 0) : tz.getRawOffset();
        if (offset == 0) {
            buf.append('Z');
            return;
        }
        if (offset >= 0) {
            buf.append('+');
        } else {
            buf.append('-');
            offset *= -1;
        }
        DatatypeConverter.formatTwoDigits((offset /= 60000) / 60, buf);
        buf.append(':');
        DatatypeConverter.formatTwoDigits(offset % 60, buf);
    }

    private static void formatTwoDigits(int n, StringBuilder buf) {
        if (n < 10) {
            buf.append('0');
        }
        buf.append(n);
    }

    private static byte[] initDecodeMap() {
        int i;
        byte[] map = new byte[128];
        for (i = 0; i < 128; ++i) {
            map[i] = -1;
        }
        for (i = 65; i <= 90; ++i) {
            map[i] = (byte)(i - 65);
        }
        for (i = 97; i <= 122; ++i) {
            map[i] = (byte)(i - 97 + 26);
        }
        for (i = 48; i <= 57; ++i) {
            map[i] = (byte)(i - 48 + 52);
        }
        map[43] = 62;
        map[47] = 63;
        map[61] = 127;
        return map;
    }

    private static int guessLength(String text) {
        int padSize;
        int j;
        int len = text.length();
        for (j = len - 1; j >= 0; --j) {
            byte code = decodeMap[text.charAt(j)];
            if (code == 127) continue;
            if (code != -1) break;
            return text.length() / 4 * 3;
        }
        if ((padSize = len - ++j) > 2) {
            return text.length() / 4 * 3;
        }
        return text.length() / 4 * 3 - padSize;
    }

    public static byte[] parseBase64Binary(String text) {
        int buflen = DatatypeConverter.guessLength(text);
        byte[] out = new byte[buflen];
        int o = 0;
        int len = text.length();
        byte[] quadruplet = new byte[4];
        int q = 0;
        for (int i = 0; i < len; ++i) {
            char ch = text.charAt(i);
            byte v = decodeMap[ch];
            if (v != -1) {
                quadruplet[q++] = v;
            }
            if (q != 4) continue;
            out[o++] = (byte)(quadruplet[0] << 2 | quadruplet[1] >> 4);
            if (quadruplet[2] != 127) {
                out[o++] = (byte)(quadruplet[1] << 4 | quadruplet[2] >> 2);
            }
            if (quadruplet[3] != 127) {
                out[o++] = (byte)(quadruplet[2] << 6 | quadruplet[3]);
            }
            q = 0;
        }
        if (buflen == o) {
            return out;
        }
        byte[] nb = new byte[o];
        System.arraycopy(out, 0, nb, 0, o);
        return nb;
    }
}

