/*
 * Decompiled with CFR 0.152.
 */
package com.zhanshow.ping.Task;

import android.annotation.SuppressLint;
import android.os.AsyncTask;
import android.os.Handler;
import android.util.Log;
import com.zhanshow.ping.Task.TraceRouteContainer;
import com.zhanshow.ping.Task.TraceTask;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;

public class TraceRouteWithPing {
    public static final String PING_CMD_FORMMAT = "ping -c 1 -t %d ";
    private static final String PING = "PING";
    private static final String FROM_PING = "From";
    private static final String SMALL_FROM_PING = "from";
    private static final String PARENTHESE_OPEN_PING = "(";
    private static final String PARENTHESE_CLOSE_PING = ")";
    private static final String TIME_PING = "time=";
    private static final String EXCEED_PING = "exceed";
    private static final String UNREACHABLE_PING = "100%";
    private static final int TIMEOUT = 30000;
    private static Runnable runnableTimeout;
    private List<TraceRouteContainer> traces;
    private int ttl;
    private int finishedTasks;
    private String urlToPing;
    private String ipToPing;
    private float elapsedTime;
    private Handler handlerTimeout;
    private TraceTask mTask;
    private StringBuilder mTraceRouteResult = new StringBuilder();

    public TraceRouteWithPing(String host, TraceTask task) {
        this.urlToPing = host;
        this.mTask = task;
    }

    public void executeTraceRoute() {
        this.ttl = 1;
        this.finishedTasks = 0;
        this.traces = new ArrayList<TraceRouteContainer>();
        new ExecutePingAsyncTask(50).execute(new Void[0]);
    }

    private String parseIpFromPing(String ping) {
        String ip = "";
        if (ping.contains(FROM_PING) || ping.contains(SMALL_FROM_PING)) {
            int index = ping.indexOf(FROM_PING);
            if (index == 0) {
                index = ping.indexOf(SMALL_FROM_PING);
            }
            if ((ip = ping.substring(index + 5)).contains(PARENTHESE_OPEN_PING)) {
                int indexOpen = ip.indexOf(PARENTHESE_OPEN_PING);
                int indexClose = ip.indexOf(PARENTHESE_CLOSE_PING);
                ip = ip.substring(indexOpen + 1, indexClose);
            } else {
                index = (ip = ip.substring(0, ip.indexOf("\n"))).contains(":") ? ip.indexOf(":") : ip.indexOf(" ");
                ip = ip.substring(0, index);
            }
        } else {
            int indexOpen = ping.indexOf(PARENTHESE_OPEN_PING);
            int indexClose = ping.indexOf(PARENTHESE_CLOSE_PING);
            ip = ping.substring(indexOpen + 1, indexClose);
        }
        return ip;
    }

    private String parseIpToPingFromPing(String ping) {
        String ip = "";
        if (ping.contains(PING)) {
            int indexOpen = ping.indexOf(PARENTHESE_OPEN_PING);
            int indexClose = ping.indexOf(PARENTHESE_CLOSE_PING);
            ip = ping.substring(indexOpen + 1, indexClose);
        }
        return ip;
    }

    private String parseTimeFromPing(String ping) {
        String time = "";
        if (ping.contains(TIME_PING)) {
            int index = ping.indexOf(TIME_PING);
            time = ping.substring(index + 5);
            index = time.indexOf(" ");
            time = time.substring(0, index);
        }
        return time;
    }

    private class ExecutePingAsyncTask
    extends AsyncTask<Void, String, String> {
        private boolean isCancelled;
        private int maxTtl;

        public ExecutePingAsyncTask(int maxTtl) {
            this.maxTtl = maxTtl;
        }

        protected void onProgressUpdate(String ... values) {
            TraceRouteWithPing.this.mTask.setResult(values[0]);
        }

        protected String doInBackground(Void ... params) {
            try {
                String res = this.launchPing(TraceRouteWithPing.this.urlToPing);
                TraceRouteWithPing.this.mTraceRouteResult.append(res);
                this.publishProgress(new String[]{res});
                if (res.contains(TraceRouteWithPing.UNREACHABLE_PING) && !res.contains(TraceRouteWithPing.EXCEED_PING)) {
                    TraceRouteContainer trace = new TraceRouteContainer("", TraceRouteWithPing.this.parseIpFromPing(res), TraceRouteWithPing.this.elapsedTime, false);
                } else {
                    TraceRouteContainer trace = new TraceRouteContainer("", TraceRouteWithPing.this.parseIpFromPing(res), TraceRouteWithPing.this.ttl == this.maxTtl ? Float.parseFloat(TraceRouteWithPing.this.parseTimeFromPing(res)) : TraceRouteWithPing.this.elapsedTime, true);
                    InetAddress inetAddr = InetAddress.getByName(trace.getIp());
                    Log.e((String)"TAG", (String)("getIP is " + trace.getIp()));
                    String hostname = inetAddr.getHostName();
                    String canonicalHostname = inetAddr.getCanonicalHostName();
                    trace.setHostname(hostname);
                    TraceRouteWithPing.this.traces.add(trace);
                }
                return res;
            }
            catch (Exception e) {
                e.printStackTrace();
                return "";
            }
        }

        @SuppressLint(value={"NewApi"})
        private String launchPing(String url) throws Exception {
            String s;
            String command = String.format(TraceRouteWithPing.PING_CMD_FORMMAT, TraceRouteWithPing.this.ttl);
            Log.e((String)"TAG", (String)("The command is : " + command + url));
            long startTime = System.nanoTime();
            new TimeOutAsyncTask(this, TraceRouteWithPing.this.ttl).execute(new Void[0]);
            Process p = Runtime.getRuntime().exec(command + url);
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String res = "";
            while ((s = stdInput.readLine()) != null) {
                res = res + s + "\n";
                if (!s.contains(TraceRouteWithPing.FROM_PING) && !s.contains(TraceRouteWithPing.SMALL_FROM_PING)) continue;
                TraceRouteWithPing.this.elapsedTime = (float)(System.nanoTime() - startTime) / 1000000.0f;
            }
            p.destroy();
            if (res.equals("")) {
                throw new IllegalArgumentException();
            }
            if (TraceRouteWithPing.this.ttl == 1) {
                Log.e((String)"TAG", (String)("ipToPings is : " + TraceRouteWithPing.this.ipToPing + "res is:" + res));
                TraceRouteWithPing.this.ipToPing = TraceRouteWithPing.this.parseIpToPingFromPing(res);
            }
            Log.e((String)"TAG", (String)("launch ping result is : " + res));
            return res;
        }

        protected void onPostExecute(String result) {
            if (!this.isCancelled) {
                try {
                    if (!"".equals(result)) {
                        if ("No connectivity".equals(result)) {
                            Log.e((String)"TAG", (String)"No connection");
                        } else if (TraceRouteWithPing.this.traces.size() > 0 && ((TraceRouteContainer)TraceRouteWithPing.this.traces.get(TraceRouteWithPing.this.traces.size() - 1)).getIp().equals(TraceRouteWithPing.this.ipToPing)) {
                            if (TraceRouteWithPing.this.ttl < this.maxTtl) {
                                TraceRouteWithPing.this.ttl = this.maxTtl;
                                TraceRouteWithPing.this.traces.remove(TraceRouteWithPing.this.traces.size() - 1);
                                new ExecutePingAsyncTask(this.maxTtl).execute(new Void[0]);
                            }
                        } else if (TraceRouteWithPing.this.ttl < this.maxTtl) {
                            TraceRouteWithPing.this.ttl++;
                            new ExecutePingAsyncTask(this.maxTtl).execute(new Void[0]);
                        }
                    }
                    TraceRouteWithPing.this.finishedTasks++;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            super.onPostExecute((Object)result);
        }

        private void onException(Exception e) {
            if (e instanceof IllegalArgumentException) {
                // empty if block
            }
            TraceRouteWithPing.this.finishedTasks++;
        }

        public void setCancelled(boolean isCancelled) {
            this.isCancelled = isCancelled;
        }
    }

    private class TimeOutAsyncTask
    extends AsyncTask<Void, Void, Void> {
        private ExecutePingAsyncTask task;
        private int ttlTask;

        public TimeOutAsyncTask(ExecutePingAsyncTask task, int ttlTask) {
            this.task = task;
            this.ttlTask = ttlTask;
        }

        protected Void doInBackground(Void ... arg0) {
            return null;
        }

        protected void onPostExecute(Void result) {
            if (TraceRouteWithPing.this.handlerTimeout == null) {
                TraceRouteWithPing.this.handlerTimeout = new Handler();
            }
            if (runnableTimeout != null) {
                TraceRouteWithPing.this.handlerTimeout.removeCallbacks(runnableTimeout);
            }
            runnableTimeout = new Runnable(){

                @Override
                public void run() {
                    if (TimeOutAsyncTask.this.task != null && TimeOutAsyncTask.this.ttlTask == TraceRouteWithPing.this.finishedTasks) {
                        TimeOutAsyncTask.this.task.setCancelled(true);
                        TimeOutAsyncTask.this.task.cancel(true);
                    }
                }
            };
            TraceRouteWithPing.this.handlerTimeout.postDelayed(runnableTimeout, 30000L);
            super.onPostExecute((Object)result);
        }
    }
}

