/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.android.apptools.support;

import android.content.Context;
import android.database.Cursor;
import android.support.v4.content.AsyncTaskLoader;
import com.j256.ormlite.android.AndroidCompiledStatement;
import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.stmt.PreparedQuery;
import com.j256.ormlite.stmt.StatementBuilder;
import com.j256.ormlite.support.DatabaseConnection;
import java.sql.SQLException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrmLiteCursorLoader<T>
extends AsyncTaskLoader<Cursor>
implements Dao.DaoObserver {
    protected Dao<T, ?> dao;
    protected PreparedQuery<T> query;
    protected Cursor cursor;

    public OrmLiteCursorLoader(Context context, Dao<T, ?> dao, PreparedQuery<T> query) {
        super(context);
        this.dao = dao;
        this.query = query;
    }

    public Cursor loadInBackground() {
        Cursor cursor;
        try {
            DatabaseConnection connection = this.dao.getConnectionSource().getReadOnlyConnection();
            AndroidCompiledStatement statement = (AndroidCompiledStatement)this.query.compile(connection, StatementBuilder.StatementType.SELECT);
            cursor = statement.getCursor();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        cursor.getCount();
        return cursor;
    }

    public void deliverResult(Cursor newCursor) {
        if (this.isReset()) {
            if (newCursor != null) {
                newCursor.close();
            }
            return;
        }
        Cursor oldCursor = this.cursor;
        this.cursor = newCursor;
        if (this.isStarted()) {
            super.deliverResult((Object)newCursor);
        }
        if (oldCursor != null && oldCursor != newCursor && !oldCursor.isClosed()) {
            oldCursor.close();
        }
    }

    protected void onStartLoading() {
        this.dao.registerObserver((Dao.DaoObserver)this);
        if (this.cursor == null) {
            this.forceLoad();
        } else {
            this.deliverResult(this.cursor);
            if (this.takeContentChanged()) {
                this.forceLoad();
            }
        }
    }

    protected void onStopLoading() {
        this.cancelLoad();
    }

    public void onCanceled(Cursor cursor) {
        if (cursor != null && !cursor.isClosed()) {
            cursor.close();
        }
    }

    protected void onReset() {
        super.onReset();
        this.onStopLoading();
        if (this.cursor != null) {
            if (!this.cursor.isClosed()) {
                this.cursor.close();
            }
            this.cursor = null;
        }
        this.dao.unregisterObserver((Dao.DaoObserver)this);
    }

    public void onChange() {
        this.onContentChanged();
    }

    public PreparedQuery<T> getQuery() {
        return this.query;
    }

    public void setQuery(PreparedQuery<T> mQuery) {
        this.query = mQuery;
    }
}

