import React from 'react';
import { IntlProvider } from 'react-intl';
import { render } from '@testing-library/react';
import { Provider } from 'react-redux';
import configureStore from '@app/configureStore';
import { DEFAULT_LOCALE, translationMessages } from '@app/i18n';
import ConnectedLanguageProvider from '@containers/LanguageProvider';
import { BrowserRouter as Router, browserHistory } from 'react-router-dom';
import { ThemeProvider } from 'styled-components';

export const timeout = ms => new Promise(resolve => setTimeout(resolve, ms));

export const apiResponseGenerator = (ok, data) => ({
  ok,
  data,
});

export const renderProvider = children => {
  const store = configureStore({}, browserHistory);
  const theme = { main: 'violet' };
  return render(
    <Provider store={store}>
      <ConnectedLanguageProvider messages={translationMessages}>
        <ThemeProvider theme={theme}>{children}</ThemeProvider>
      </ConnectedLanguageProvider>
    </Provider>,
  );
};

export const renderWithIntl = children =>
  render(
    <IntlProvider
      locale={DEFAULT_LOCALE}
      messages={translationMessages[DEFAULT_LOCALE]}
    >
      {children}
    </IntlProvider>,
  );

export const getComponentStyles = (Component, props = {}) => {
  renderWithIntl(Component(props));
  const { styledComponentId } = Component(props).type;
  const componentRoots = document.getElementsByClassName(styledComponentId);
  // eslint-disable-next-line no-underscore-dangle
  return window.getComputedStyle(componentRoots[0])._values;
};

export const renderWithRouterAndIntl = children =>
  renderWithIntl(<Router>{children}</Router>);
