﻿using System;
using System.Windows.Data;

namespace Certify.UI.Utils
{
    public class NullableDateFormatter : IValueConverter
    {
        public object Convert(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture)
        {
            if (value == null)
            {
                return "<not set>";
            }

            return ((DateTimeOffset)value).ToString("yyyy-MM-dd");
        }

        public object ConvertBack(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture) => null;
    }
}
