﻿using Certify.Client;
using Certify.Server.Api.Public.Services;
using Microsoft.AspNetCore.Mvc;

namespace Certify.Server.Api.Public.Controllers
{
    /// <summary>
    /// Internal API for extended certificate management. Not intended for general use.
    /// </summary>
    [ApiController]
    [Route("internal/v1/credentials")]
    public partial class StoredCredentialController : ApiControllerBase
    {

        private readonly ILogger<StoredCredentialController> _logger;

        private readonly ICertifyInternalApiClient _client;

        private readonly ManagementAPI _mgmtAPI;

        /// <summary>
        /// Constructor
        /// </summary>
        /// <param name="logger"></param>
        /// <param name="client"></param>
        public StoredCredentialController(ILogger<StoredCredentialController> logger, ICertifyInternalApiClient client, ManagementAPI mgmtApi)
        {
            _logger = logger;
            _client = client;
            _mgmtAPI = mgmtApi;
        }
    }
}
