﻿using Certify.Client;
using Microsoft.AspNetCore.Mvc;

namespace Certify.Server.Api.Public.Controllers
{
    /// <summary>
    /// Internal API controller for access related admin. Some controller endpoints may be Source Generated by Certify.SourceGenerators.
    /// </summary>
    [Route("internal/v1/[controller]")]
    [ApiController]
    public partial class AccessController : ApiControllerBase
    {
        private readonly ILogger<CertificateAuthorityController> _logger;

        private readonly ICertifyInternalApiClient _client;

        /// <summary>
        /// Constructor
        /// </summary>
        /// <param name="logger"></param>
        /// <param name="client"></param>
        public AccessController(ILogger<CertificateAuthorityController> logger, ICertifyInternalApiClient client)
        {
            _logger = logger;
            _client = client;
        }
    }
}
