const fs = require("fs")
const path = require("path")
const diff = require('jest-diff')

let dirname = path.resolve(__dirname, "../__snapshots__/")
const snapOrBakList = fs.readdirSync(dirname)
const noColor = string => string;

const options = {
  aColor: noColor,
  bColor: noColor,
  changeColor: noColor,
  commonColor: noColor,
  patchColor: noColor,
	expand: false
};
let bakList = snapOrBakList.filter(item => item.endsWith('.bak'));

bakList.forEach(backupFileName => {
	// find snapshot generated by rspack
	let snapfileName = backupFileName.slice(0, -4)
	let backupContent  = fs.readFileSync(path.resolve(dirname, backupFileName)).toString()
	let snapContent = "" // content could be empty string when the whole snapshot test has been ignored

	if (snapOrBakList.includes(snapfileName)) {
		snapContent = fs.readFileSync(path.resolve(dirname, snapfileName)).toString()
	}
	let diffResult = diff.diff(backupContent, snapContent, options);
	fs.writeFileSync(path.resolve(dirname, `${snapfileName}.diff`), diffResult)
})


