## API Report File for "@rspack/core"

> Do not edit this file. It is a report generated by [API Extractor](https://api-extractor.com/).

```ts

/// <reference types="node" />

import type { Abortable } from 'node:events';
import { Assumptions } from './assumptions';
import { AsyncParallelHook } from '@rspack/lite-tapable';
import { AsyncSeriesBailHook } from '@rspack/lite-tapable';
import * as binding from '@rspack/binding';
import { BuiltinPlugin } from '@rspack/binding';
import { BuiltinPluginName } from '@rspack/binding';
import { CacheFacade as CacheFacade_2 } from './lib/CacheFacade';
import type { Callback } from '@rspack/lite-tapable';
import { cleanupGlobalTrace } from '@rspack/binding';
import { Compiler as Compiler_2 } from '..';
import { default as default_2 } from './util/hash';
import { RawEvalDevToolModulePluginOptions as EvalDevToolModulePluginOptions } from '@rspack/binding';
import { EventEmitter } from 'events';
import { ExternalObject } from '@rspack/binding';
import fs from 'graceful-fs';
import { fs as fs_2 } from 'fs';
import { HookMap } from '@rspack/lite-tapable';
import { inspect } from 'node:util';
import type { JsAddingRuntimeModule } from '@rspack/binding';
import { JsAfterEmitData } from '@rspack/binding';
import { JsAfterTemplateExecutionData } from '@rspack/binding';
import { JsAlterAssetTagGroupsData } from '@rspack/binding';
import { JsAlterAssetTagsData } from '@rspack/binding';
import type { JsAssetInfo } from '@rspack/binding';
import { JsBeforeAssetTagGenerationData } from '@rspack/binding';
import { JsBeforeEmitData } from '@rspack/binding';
import type { JsBuildMeta } from '@rspack/binding';
import { JsChunk } from '@rspack/binding';
import type { JsChunkGraph } from '@rspack/binding';
import type { JsChunkGroup } from '@rspack/binding';
import type { JsCodegenerationResult } from '@rspack/binding';
import { JsCompilation } from '@rspack/binding';
import type { JsContextModuleFactoryAfterResolveData } from '@rspack/binding';
import type { JsContextModuleFactoryBeforeResolveData } from '@rspack/binding';
import type { JsCreateData } from '@rspack/binding';
import type { JsDependenciesBlock } from '@rspack/binding';
import type { JsDependency } from '@rspack/binding';
import type { JsExportsInfo } from '@rspack/binding';
import type { JsFactoryMeta } from '@rspack/binding';
import { JsHtmlPluginTag } from '@rspack/binding';
import { JsLoaderItem } from '@rspack/binding';
import type { JsModule } from '@rspack/binding';
import type { JsModuleGraph } from '@rspack/binding';
import type { JsModuleGraphConnection } from '@rspack/binding';
import { JsRuntimeModule } from '@rspack/binding';
import type { JsStats } from '@rspack/binding';
import type { JsStatsCompilation } from '@rspack/binding';
import type { JsStatsError } from '@rspack/binding';
import type { JsStatsWarning } from '@rspack/binding';
import * as liteTapable from '@rspack/lite-tapable';
import { Logger as Logger_2 } from './logging/Logger';
import { RawCopyPattern } from '@rspack/binding';
import { RawCssExtractPluginOption } from '@rspack/binding';
import type { RawFuncUseCtx } from '@rspack/binding';
import { RawIgnorePluginOptions } from '@rspack/binding';
import { RawOptions } from '@rspack/binding';
import { RawProgressPluginOptions } from '@rspack/binding';
import { RawProvideOptions } from '@rspack/binding';
import { RawRuntimeChunkOptions } from '@rspack/binding';
import { registerGlobalTrace } from '@rspack/binding';
import { RspackOptionsNormalized as RspackOptionsNormalized_2 } from '.';
import { RawSourceMapDevToolPluginOptions as SourceMapDevToolPluginOptions } from '@rspack/binding';
import sources = require('../compiled/webpack-sources');
import { SyncBailHook } from '@rspack/lite-tapable';
import { SyncHook } from '@rspack/lite-tapable';
import { SyncWaterfallHook } from '@rspack/lite-tapable';
import type * as webpackDevServer from 'webpack-dev-server';

// @public (undocumented)
interface AdditionalData {
    // (undocumented)
    [index: string]: any;
}

// @public (undocumented)
type AffectedHooks = keyof Compiler["hooks"];

// @public (undocumented)
type allKeys<T> = T extends any ? keyof T : never;

// @public (undocumented)
type AllowTarget = "web" | "webworker" | "es3" | "es5" | "es2015" | "es2016" | "es2017" | "es2018" | "es2019" | "es2020" | "es2021" | "es2022" | "node" | "async-node" | `node${number}` | `async-node${number}` | `node${number}.${number}` | `async-node${number}.${number}` | "electron-main" | `electron${number}-main` | `electron${number}.${number}-main` | "electron-renderer" | `electron${number}-renderer` | `electron${number}.${number}-renderer` | "electron-preload" | `electron${number}-preload` | `electron${number}.${number}-preload` | "nwjs" | `nwjs${number}` | `nwjs${number}.${number}` | "node-webkit" | `node-webkit${number}` | `node-webkit${number}.${number}` | "browserslist" | `browserslist:${string}`;

// @public
export type Amd = false | Record<string, any>;

// @public (undocumented)
interface AmdConfig extends BaseModuleConfig {
    // (undocumented)
    moduleId?: string;
    // (undocumented)
    type: "amd";
}

// @public
export type AmdContainer = string;

// @public (undocumented)
export const applyRspackOptionsBaseDefaults: (options: RspackOptionsNormalized) => void;

// @public (undocumented)
export const applyRspackOptionsDefaults: (options: RspackOptionsNormalized) => void;

// @public (undocumented)
type ArrayCardinality = "many" | "atleastone";

// @public (undocumented)
type arrayOutputType<T extends ZodTypeAny, Cardinality extends ArrayCardinality = "many"> = Cardinality extends "atleastone" ? [T["_output"], ...T["_output"][]] : T["_output"][];

// @public
const asRegExp: (test: string | RegExp) => RegExp;

// @public (undocumented)
export interface Asset {
    // (undocumented)
    info: AssetInfo;
    // (undocumented)
    name: string;
    // (undocumented)
    source: Source;
}

// @public (undocumented)
type AssetCondition = string | RegExp;

// @public (undocumented)
type AssetConditions = AssetCondition | AssetCondition[];

// @public (undocumented)
interface AssetEmittedInfo {
    // (undocumented)
    compilation: Compilation;
    // (undocumented)
    content: Buffer;
    // (undocumented)
    outputPath: string;
    // (undocumented)
    source: Source;
    // (undocumented)
    targetPath: string;
}

// @public (undocumented)
export type AssetGeneratorDataUrl = AssetGeneratorDataUrlOptions | AssetGeneratorDataUrlFunction;

// @public (undocumented)
export type AssetGeneratorDataUrlFunction = (content: Buffer, context: {
    filename: string;
    module: Module;
}) => string;

// @public (undocumented)
export type AssetGeneratorDataUrlOptions = {
    encoding?: false | "base64";
    mimetype?: string;
};

// @public
export type AssetGeneratorOptions = AssetInlineGeneratorOptions & AssetResourceGeneratorOptions;

// @public (undocumented)
export type AssetInfo = Partial<Omit<JsAssetInfo, "extras">> & Record<string, any>;

// @public (undocumented)
type AssetInfo_2 = KnownAssetInfo & Record<string, any>;

// @public
export type AssetInlineGeneratorOptions = {
    dataUrl?: AssetGeneratorDataUrl;
};

// @public
export type AssetModuleFilename = Filename;

// @public
export type AssetModuleOutputPath = Filename;

// @public
export type AssetParserDataUrl = AssetParserDataUrlOptions;

// @public
export type AssetParserDataUrlOptions = {
    maxSize?: number | undefined;
};

// @public
export type AssetParserOptions = {
    dataUrlCondition?: AssetParserDataUrlOptions;
};

// @public
export type AssetResourceGeneratorOptions = {
    emit?: boolean;
    filename?: Filename;
    outputPath?: AssetModuleOutputPath;
    publicPath?: PublicPath;
};

// @public (undocumented)
export type Assets = Record<string, Source>;

// @public
export type AsyncChunks = boolean;

// @public (undocumented)
type AsyncParseReturnType<T> = Promise<SyncParseReturnType<T>>;

// @public
export type AuxiliaryComment = string | LibraryCustomUmdCommentObject;

// @public
export type Bail = boolean;

// @public (undocumented)
type BannerContent = string | BannerFunction;

// @public (undocumented)
type BannerFunction = (args: {
    hash: string;
    chunk: JsChunk;
    filename: string;
}) => string;

// @public (undocumented)
export const BannerPlugin: {
    new (args: BannerPluginArgument): {
        name: BuiltinPluginName;
        _args: [args: BannerPluginArgument];
        affectedHooks: "done" | "make" | "environment" | "compile" | "emit" | "afterEmit" | "invalid" | "thisCompilation" | "afterDone" | "compilation" | "normalModuleFactory" | "contextModuleFactory" | "initialize" | "shouldEmit" | "infrastructureLog" | "beforeRun" | "run" | "assetEmitted" | "failed" | "shutdown" | "watchRun" | "watchClose" | "afterEnvironment" | "afterPlugins" | "afterResolvers" | "beforeCompile" | "afterCompile" | "finishMake" | "entryOption" | "additionalPass" | undefined;
        raw(compiler: Compiler_2): BuiltinPlugin;
        apply(compiler: Compiler_2): void;
    };
};

// @public (undocumented)
export type BannerPluginArgument = BannerContent | BannerPluginOptions;

// @public (undocumented)
type BannerPluginOptions = {
    banner: BannerContent;
    entryOnly?: boolean;
    exclude?: Rules;
    include?: Rules;
    raw?: boolean;
    footer?: boolean;
    stage?: number;
    test?: Rules;
};

// @public (undocumented)
abstract class BaseCache {
    // (undocumented)
    abstract get<T>(callback: CallbackCache<T>): void;
    // (undocumented)
    abstract getPromise<T>(): Promise<T | undefined>;
    // (undocumented)
    abstract store<T>(data: T, callback: CallbackCache<void>): void;
    // (undocumented)
    abstract storePromise<T>(data: T): Promise<void>;
}

// @public (undocumented)
interface BaseModuleConfig {
    // (undocumented)
    allowTopLevelThis?: boolean;
    exportInteropAnnotation?: boolean;
    ignoreDynamic?: boolean;
    importInterop?: "swc" | "babel" | "node" | "none";
    lazy?: boolean | string[];
    // @deprecated (undocumented)
    noInterop?: boolean;
    // (undocumented)
    preserveImportMeta?: boolean;
    strict?: boolean;
    strictMode?: boolean;
}

// @public (undocumented)
interface BaseResolveRequest {
    	// (undocumented)
    __innerRequest?: string;
    	// (undocumented)
    __innerRequest_relativePath?: string;
    	// (undocumented)
    __innerRequest_request?: string;
    	// (undocumented)
    context?: object;
    	// (undocumented)
    descriptionFileData?: JsonObject;
    	// (undocumented)
    descriptionFilePath?: string;
    	// (undocumented)
    descriptionFileRoot?: string;
    	// (undocumented)
    fullySpecified?: boolean;
    	// (undocumented)
    ignoreSymlinks?: boolean;
    	// (undocumented)
    path: string | false;
    	// (undocumented)
    relativePath?: string;
}

// @public
export type BaseUri = string;

// @public (undocumented)
type BigIntStatsCallback = (err: NodeJS.ErrnoException | null, stats?: IBigIntStats) => void;

// @public (undocumented)
const BRAND: unique symbol;

// @public (undocumented)
type BRAND<T extends string | number | symbol> = {
    [BRAND]: {
        [k in T]: true;
    };
};

// @public (undocumented)
type BufferCallback = (err: NodeJS.ErrnoException | null, data?: Buffer) => void;

// @public (undocumented)
type BufferEncodingOption = "buffer" | {
    encoding: "buffer";
};

// @public (undocumented)
type BuiltIn = (((...args: any[]) => any) | (new (...args: any[]) => any)) | {
    readonly [Symbol.toStringTag]: string;
} | Date | Error | Generator | Promise<unknown> | RegExp;

// @public (undocumented)
class Cache_2 {
    constructor();
    // (undocumented)
    beginIdle(): void;
    // (undocumented)
    endIdle(callback: CallbackCache<void>): void;
    // (undocumented)
    get<T>(identifier: string, etag: Etag | null, callback: CallbackCache<T>): void;
    // (undocumented)
    hooks: {
        get: AsyncSeriesBailHook<[string, Etag | null, GotHandler[]], any>;
        store: AsyncParallelHook<[string, Etag | null, any]>;
        storeBuildDependencies: AsyncParallelHook<[Iterable<string>]>;
        beginIdle: SyncHook<[]>;
        endIdle: AsyncParallelHook<[]>;
        shutdown: AsyncParallelHook<[]>;
    };
    // (undocumented)
    shutdown(callback: CallbackCache<void>): void;
    // (undocumented)
    static STAGE_DEFAULT: number;
    // (undocumented)
    static STAGE_DISK: number;
    // (undocumented)
    static STAGE_MEMORY: number;
    // (undocumented)
    static STAGE_NETWORK: number;
    // (undocumented)
    store<T>(identifier: string, etag: Etag | null, data: T, callback: CallbackCache<void>): void;
    storeBuildDependencies(dependencies: Iterable<string>, callback: CallbackCache<void>): void;
}

// @public (undocumented)
class CacheFacade {
    constructor(cache: Cache_2, name: string, hashFunction: string | HashConstructor);
    // (undocumented)
    _cache: Cache_2;
    // (undocumented)
    get<T>(identifier: string, etag: Etag | null, callback: CallbackCache<T>): void;
    // (undocumented)
    getChildCache(name: string): CacheFacade;
    // (undocumented)
    getItemCache(identifier: string, etag: Etag | null): ItemCacheFacade;
    // (undocumented)
    getLazyHashedEtag(obj: HashableObject): Etag;
    // (undocumented)
    getPromise<T>(identifier: string, etag: Etag | null): Promise<T | undefined>;
    // (undocumented)
    _hashFunction: string | HashConstructor;
    // (undocumented)
    mergeEtags(a: Etag, b: Etag): Etag;
    // (undocumented)
    _name: string;
    // (undocumented)
    provide<T>(identifier: string, etag: Etag | null, computer: (callback: CallbackNormalErrorCache<T>) => void, callback: CallbackNormalErrorCache<T>): void;
    // (undocumented)
    providePromise<T>(identifier: string, etag: Etag | null, computer: () => Promise<T> | T): Promise<{} | T | null>;
    // (undocumented)
    store<T>(identifier: string, etag: Etag | null, data: T, callback: CallbackCache<void>): void;
    // (undocumented)
    storePromise<T>(identifier: string, etag: Etag | null, data: T): Promise<void>;
}

// @public (undocumented)
type CacheHookMap = Map<string, SyncBailHook<[any[], StatsFactoryContext], any>[]>;

// @public
export type CacheOptions = boolean;

// @public (undocumented)
type CallbackCache<T> = (err?: WebpackError_2 | null, result?: T) => void;

// @public (undocumented)
type CallbackNormalErrorCache<T> = (err?: WebpackError_2 | null, result?: T) => void;

// @public (undocumented)
type CallFn = (...args: any[]) => any;

// @public (undocumented)
export class Chunk {
    constructor(binding: JsChunk);
    // (undocumented)
    static __from_binding(binding: JsChunk): Chunk;
    // (undocumented)
    static __to_binding(chunk: Chunk): JsChunk;
    // (undocumented)
    readonly auxiliaryFiles: ReadonlySet<string>;
    // (undocumented)
    canBeInitial(): boolean;
    // (undocumented)
    readonly chunkReason?: string;
    // (undocumented)
    readonly contentHash: Readonly<Record<string, string>>;
    // (undocumented)
    readonly cssFilenameTemplate?: string;
    // (undocumented)
    readonly filenameTemplate?: string;
    // (undocumented)
    readonly files: ReadonlySet<string>;
    // (undocumented)
    getAllAsyncChunks(): ReadonlySet<Chunk>;
    // (undocumented)
    getAllInitialChunks(): ReadonlySet<Chunk>;
    // (undocumented)
    getAllReferencedChunks(): ReadonlySet<Chunk>;
    // (undocumented)
    getChunkMaps(realHash: boolean): {
        hash: Record<string | number, string>;
        contentHash: Record<string | number, Record<string, string>>;
        name: Record<string | number, string>;
    };
    // (undocumented)
    get groupsIterable(): ReadonlySet<ChunkGroup>;
    // (undocumented)
    readonly hash?: string;
    // (undocumented)
    hasRuntime(): boolean;
    // (undocumented)
    readonly id?: string;
    // (undocumented)
    readonly idNameHints: ReadonlyArray<string>;
    // (undocumented)
    readonly ids: ReadonlyArray<string>;
    // (undocumented)
    isOnlyInitial(): boolean;
    // (undocumented)
    readonly name?: string;
    // (undocumented)
    readonly renderedHash?: string;
    // (undocumented)
    readonly runtime: ReadonlySet<string>;
}

// @public
export type ChunkFilename = Filename;

// @public
export type ChunkFormat = string | false;

// @public (undocumented)
class ChunkGraph {
    // (undocumented)
    static __from_binding(binding: JsChunkGraph): ChunkGraph;
    // (undocumented)
    getChunkEntryDependentChunksIterable(chunk: Chunk): Iterable<Chunk>;
    // (undocumented)
    getChunkEntryModulesIterable(chunk: Chunk): Iterable<Module>;
    // (undocumented)
    getChunkModules(chunk: Chunk): ReadonlyArray<Module>;
    // (undocumented)
    getChunkModulesIterable(chunk: Chunk): Iterable<Module>;
    // (undocumented)
    getChunkModulesIterableBySourceType(chunk: Chunk, sourceType: string): Iterable<Module>;
    // (undocumented)
    getModuleChunks(module: Module): Chunk[];
    // (undocumented)
    getModuleChunksIterable(module: Module): Iterable<Chunk>;
    // (undocumented)
    getModuleId(module: Module): string | null;
}

// @public (undocumented)
export class ChunkGroup {
    protected constructor(inner: JsChunkGroup);
    // (undocumented)
    static __from_binding(binding: JsChunkGroup): ChunkGroup;
    // (undocumented)
    readonly chunks: ReadonlyArray<Chunk>;
    // (undocumented)
    getFiles(): ReadonlyArray<string>;
    // (undocumented)
    getParents(): ReadonlyArray<ChunkGroup>;
    // (undocumented)
    readonly index?: number;
    // (undocumented)
    isInitial(): boolean;
    // (undocumented)
    readonly name?: string;
    // (undocumented)
    readonly origins: ReadonlyArray<ChunkGroupOrigin>;
}

// @public (undocumented)
interface ChunkGroupOrigin {
    // (undocumented)
    module?: Module;
    // (undocumented)
    request?: string;
}

// @public
export type ChunkLoading = false | ChunkLoadingType;

// @public
export type ChunkLoadingGlobal = string;

// @public
export type ChunkLoadingType = string | "jsonp" | "import-scripts" | "require" | "async-node" | "import";

// @public
export type Clean = boolean | {
    keep?: string;
};

// @public (undocumented)
class CodeGenerationResult {
    constructor(result: JsCodegenerationResult);
    // (undocumented)
    get(sourceType: string): string;
}

// @public (undocumented)
type CodeValue = RecursiveArrayOrRecord<CodeValuePrimitive>;

// @public (undocumented)
type CodeValuePrimitive = null | undefined | RegExp | Function | string | number | boolean | bigint | undefined;

// @public (undocumented)
interface CommonJsConfig extends BaseModuleConfig {
    // (undocumented)
    type: "commonjs";
}

// @public (undocumented)
export class Compilation {
    constructor(compiler: Compiler, inner: JsCompilation);
    // @internal
    __internal__deleteAssetSource(filename: string): void;
    // @internal
    __internal__emit_asset_from_loader(filename: string, source: Source, assetInfo: AssetInfo, module: string): void;
    // @internal
    __internal__getAssetFilenames(): string[];
    // @internal
    __internal__getAssetSource(filename: string): Source | void;
    // @internal
    __internal__getChunks(): Chunk[];
    // @internal
    __internal__hasAsset(name: string): boolean;
    // @internal
    __internal__pushDiagnostic(diagnostic: ExternalObject<"Diagnostic">): void;
    // @internal
    __internal__pushDiagnostics(diagnostics: ExternalObject<"Diagnostic[]">): void;
    // @internal
    __internal__pushRspackDiagnostic(diagnostic: binding.JsRspackDiagnostic): void;
    // @internal
    __internal__setAssetSource(filename: string, source: Source): void;
    // (undocumented)
    get __internal__shutdown(): boolean;
    set __internal__shutdown(shutdown: boolean);
    // @internal
    __internal_getInner(): binding.JsCompilation;
    // (undocumented)
    addInclude(context: string, dependency: ReturnType<typeof EntryPlugin.createDependency>, options: EntryOptions, callback: (err?: null | WebpackError_2, module?: Module) => void): void;
    // (undocumented)
    addRuntimeModule(chunk: Chunk, runtimeModule: RuntimeModule): void;
    get assets(): Record<string, Source>;
    // (undocumented)
    buildDependencies: {
        [Symbol.iterator](): Generator<string, void, unknown>;
        has(dep: string): boolean;
        add: (dep: string) => void;
        addAll: (deps: Iterable<string>) => void;
    };
    // (undocumented)
    get builtModules(): ReadonlySet<Module>;
    // (undocumented)
    children: Compilation[];
    // (undocumented)
    childrenCounters: Record<string, number>;
    // (undocumented)
    chunkGraph: ChunkGraph;
    // (undocumented)
    get chunkGroups(): ReadonlyArray<ChunkGroup>;
    // (undocumented)
    get chunks(): ReadonlySet<Chunk>;
    // (undocumented)
    compiler: Compiler;
    // (undocumented)
    contextDependencies: {
        [Symbol.iterator](): Generator<string, void, unknown>;
        has(dep: string): boolean;
        add: (dep: string) => void;
        addAll: (deps: Iterable<string>) => void;
    };
    // (undocumented)
    createChildCompiler(name: string, outputOptions: OutputNormalized, plugins: RspackPluginInstance[]): Compiler;
    // (undocumented)
    createStatsFactory(options: StatsOptions): StatsFactory;
    // (undocumented)
    createStatsOptions(statsValue: StatsValue | undefined, context?: CreateStatsOptionsContext): NormalizedStatsOptions;
    // (undocumented)
    createStatsPrinter(options: StatsOptions): StatsPrinter;
    // (undocumented)
    deleteAsset(filename: string): void;
    emitAsset(filename: string, source: Source, assetInfo?: AssetInfo): void;
    // (undocumented)
    endTime?: number;
    // (undocumented)
    get entries(): Map<string, EntryData>;
    get entrypoints(): ReadonlyMap<string, Entrypoint>;
    // (undocumented)
    get errors(): RspackError[];
    set errors(errors: RspackError[]);
    // (undocumented)
    fileDependencies: {
        [Symbol.iterator](): Generator<string, void, unknown>;
        has(dep: string): boolean;
        add: (dep: string) => void;
        addAll: (deps: Iterable<string>) => void;
    };
    // (undocumented)
    fileSystemInfo: {
        createSnapshot(): null;
    };
    // (undocumented)
    get fullHash(): Readonly<string | null>;
    // (undocumented)
    getAsset(name: string): Readonly<Asset> | void;
    // (undocumented)
    getAssetPath(filename: Filename, data?: PathData): string;
    // (undocumented)
    getAssetPathWithInfo(filename: Filename, data?: PathData): binding.PathWithInfo;
    getAssets(): ReadonlyArray<Asset>;
    // (undocumented)
    getCache(name: string): CacheFacade_2;
    // (undocumented)
    getLogger(name: string | (() => string)): Logger;
    // (undocumented)
    getPath(filename: Filename, data?: PathData): string;
    // (undocumented)
    getPathWithInfo(filename: Filename, data?: PathData): binding.PathWithInfo;
    // (undocumented)
    getStats(): Stats;
    // (undocumented)
    get hash(): Readonly<string | null>;
    // (undocumented)
    hooks: Readonly<{
        processAssets: liteTapable.AsyncSeriesHook<Assets>;
        afterProcessAssets: liteTapable.SyncHook<Assets>;
        childCompiler: liteTapable.SyncHook<[Compiler, string, number]>;
        log: liteTapable.SyncBailHook<[string, LogEntry], true>;
        additionalAssets: any;
        optimizeModules: liteTapable.SyncBailHook<Iterable<Module>, void>;
        afterOptimizeModules: liteTapable.SyncHook<Iterable<Module>, void>;
        optimizeTree: liteTapable.AsyncSeriesHook<[
        Iterable<Chunk>,
        Iterable<Module>
        ]>;
        optimizeChunkModules: liteTapable.AsyncSeriesBailHook<[
        Iterable<Chunk>,
        Iterable<Module>
        ], void>;
        finishModules: liteTapable.AsyncSeriesHook<[Iterable<Module>], void>;
        chunkHash: liteTapable.SyncHook<[Chunk, Hash_2], void>;
        chunkAsset: liteTapable.SyncHook<[Chunk, string], void>;
        processWarnings: liteTapable.SyncWaterfallHook<[Error[]]>;
        succeedModule: liteTapable.SyncHook<[Module], void>;
        stillValidModule: liteTapable.SyncHook<[Module], void>;
        statsPreset: liteTapable.HookMap<liteTapable.SyncHook<[
        Partial<StatsOptions>,
        CreateStatsOptionsContext
        ], void>>;
        statsNormalize: liteTapable.SyncHook<[
        Partial<StatsOptions>,
        CreateStatsOptionsContext
        ], void>;
        statsFactory: liteTapable.SyncHook<[StatsFactory, StatsOptions], void>;
        statsPrinter: liteTapable.SyncHook<[StatsPrinter, StatsOptions], void>;
        buildModule: liteTapable.SyncHook<[Module]>;
        executeModule: liteTapable.SyncHook<[
        ExecuteModuleArgument,
        ExecuteModuleContext
        ]>;
        additionalTreeRuntimeRequirements: liteTapable.SyncHook<[
        Chunk,
        Set<string>
        ], void>;
        runtimeRequirementInTree: liteTapable.HookMap<liteTapable.SyncBailHook<[Chunk, Set<string>], void>>;
        runtimeModule: liteTapable.SyncHook<[JsRuntimeModule, Chunk], void>;
        seal: liteTapable.SyncHook<[], void>;
        afterSeal: liteTapable.AsyncSeriesHook<[], void>;
        needAdditionalPass: liteTapable.SyncBailHook<[], boolean>;
    }>;
    // (undocumented)
    inputFileSystem: InputFileSystem | null;
    // (undocumented)
    logging: Map<string, LogEntry[]>;
    // (undocumented)
    missingDependencies: {
        [Symbol.iterator](): Generator<string, void, unknown>;
        has(dep: string): boolean;
        add: (dep: string) => void;
        addAll: (deps: Iterable<string>) => void;
    };
    // (undocumented)
    moduleGraph: ModuleGraph;
    // (undocumented)
    get modules(): ReadonlySet<Module>;
    // (undocumented)
    name?: string;
    get namedChunkGroups(): ReadonlyMap<string, Readonly<ChunkGroup>>;
    get namedChunks(): ReadonlyMap<string, Readonly<Chunk>>;
    // (undocumented)
    needAdditionalPass: boolean;
    // (undocumented)
    options: RspackOptionsNormalized;
    // (undocumented)
    outputOptions: OutputNormalized;
    // (undocumented)
    static PROCESS_ASSETS_STAGE_ADDITIONAL: number;
    // (undocumented)
    static PROCESS_ASSETS_STAGE_ADDITIONS: number;
    // (undocumented)
    static PROCESS_ASSETS_STAGE_ANALYSE: number;
    // (undocumented)
    static PROCESS_ASSETS_STAGE_DERIVED: number;
    // (undocumented)
    static PROCESS_ASSETS_STAGE_DEV_TOOLING: number;
    // (undocumented)
    static PROCESS_ASSETS_STAGE_NONE: number;
    // (undocumented)
    static PROCESS_ASSETS_STAGE_OPTIMIZE: number;
    // (undocumented)
    static PROCESS_ASSETS_STAGE_OPTIMIZE_COMPATIBILITY: number;
    // (undocumented)
    static PROCESS_ASSETS_STAGE_OPTIMIZE_COUNT: number;
    // (undocumented)
    static PROCESS_ASSETS_STAGE_OPTIMIZE_HASH: number;
    // (undocumented)
    static PROCESS_ASSETS_STAGE_OPTIMIZE_INLINE: number;
    // (undocumented)
    static PROCESS_ASSETS_STAGE_OPTIMIZE_SIZE: number;
    // (undocumented)
    static PROCESS_ASSETS_STAGE_OPTIMIZE_TRANSFER: number;
    // (undocumented)
    static PROCESS_ASSETS_STAGE_PRE_PROCESS: number;
    // (undocumented)
    static PROCESS_ASSETS_STAGE_REPORT: number;
    // (undocumented)
    static PROCESS_ASSETS_STAGE_SUMMARIZE: number;
    // (undocumented)
    rebuildModule(m: Module, f: (err: Error, m: Module) => void): void;
    // (undocumented)
    renameAsset(filename: string, newFilename: string): void;
    // (undocumented)
    resolverFactory: ResolverFactory;
    // (undocumented)
    seal(): void;
    // (undocumented)
    startTime?: number;
    // (undocumented)
    unseal(): void;
    updateAsset(filename: string, newSourceOrFunction: Source | ((source: Source) => Source), assetInfoUpdateOrFunction?: AssetInfo | ((assetInfo: AssetInfo) => AssetInfo)): void;
    // (undocumented)
    get warnings(): RspackError[];
    set warnings(warnings: RspackError[]);
}

// @public (undocumented)
type CompilationHooks = {
    chunkHash: liteTapable.SyncHook<[Chunk, Hash_2]>;
};

// @public (undocumented)
export interface CompilationParams {
    // (undocumented)
    contextModuleFactory: ContextModuleFactory;
    // (undocumented)
    normalModuleFactory: NormalModuleFactory;
}

// @public (undocumented)
export class Compiler {
    constructor(context: string, options: RspackOptionsNormalized);
    // @internal
    get __internal__builtinPlugins(): binding.BuiltinPlugin[];
    // (undocumented)
    __internal__getModuleExecutionResult(id: number): any;
    // @internal
    __internal__rebuild(modifiedFiles?: ReadonlySet<string>, removedFiles?: ReadonlySet<string>, callback?: (error: Error | null) => void): void;
    // (undocumented)
    __internal__registerBuiltinPlugin(plugin: binding.BuiltinPlugin): void;
    // @internal
    get __internal__ruleSet(): RuleSetCompiler;
    // (undocumented)
    cache: Cache_2;
    // (undocumented)
    close(callback: (error?: Error | null) => void): void;
    // (undocumented)
    compile(callback: liteTapable.Callback<Error, Compilation>): void;
    // (undocumented)
    compilerPath: string;
    // (undocumented)
    context: string;
    // (undocumented)
    contextTimestamps?: ReadonlyMap<string, FileSystemInfoEntry_2 | "ignore" | null>;
    // (undocumented)
    createChildCompiler(compilation: Compilation, compilerName: string, compilerIndex: number, outputOptions: OutputNormalized, plugins: RspackPluginInstance[]): Compiler;
    // (undocumented)
    fileTimestamps?: ReadonlyMap<string, FileSystemInfoEntry_2 | "ignore" | null>;
    // (undocumented)
    fsStartTime?: number;
    // (undocumented)
    getCache(name: string): CacheFacade;
    // (undocumented)
    getInfrastructureLogger(name: string | (() => string)): Logger;
    // (undocumented)
    hooks: {
        done: liteTapable.AsyncSeriesHook<Stats>;
        afterDone: liteTapable.SyncHook<Stats>;
        thisCompilation: liteTapable.SyncHook<[Compilation, CompilationParams]>;
        compilation: liteTapable.SyncHook<[Compilation, CompilationParams]>;
        invalid: liteTapable.SyncHook<[string | null, number]>;
        compile: liteTapable.SyncHook<[CompilationParams]>;
        normalModuleFactory: liteTapable.SyncHook<NormalModuleFactory>;
        contextModuleFactory: liteTapable.SyncHook<ContextModuleFactory>;
        initialize: liteTapable.SyncHook<[]>;
        shouldEmit: liteTapable.SyncBailHook<[Compilation], boolean>;
        infrastructureLog: liteTapable.SyncBailHook<[string, string, any[]], true>;
        beforeRun: liteTapable.AsyncSeriesHook<[Compiler]>;
        run: liteTapable.AsyncSeriesHook<[Compiler]>;
        emit: liteTapable.AsyncSeriesHook<[Compilation]>;
        assetEmitted: liteTapable.AsyncSeriesHook<[string, AssetEmittedInfo]>;
        afterEmit: liteTapable.AsyncSeriesHook<[Compilation]>;
        failed: liteTapable.SyncHook<[Error]>;
        shutdown: liteTapable.AsyncSeriesHook<[]>;
        watchRun: liteTapable.AsyncSeriesHook<[Compiler]>;
        watchClose: liteTapable.SyncHook<[]>;
        environment: liteTapable.SyncHook<[]>;
        afterEnvironment: liteTapable.SyncHook<[]>;
        afterPlugins: liteTapable.SyncHook<[Compiler]>;
        afterResolvers: liteTapable.SyncHook<[Compiler]>;
        make: liteTapable.AsyncParallelHook<[Compilation]>;
        beforeCompile: liteTapable.AsyncSeriesHook<[CompilationParams]>;
        afterCompile: liteTapable.AsyncSeriesHook<[Compilation]>;
        finishMake: liteTapable.AsyncSeriesHook<[Compilation]>;
        entryOption: liteTapable.SyncBailHook<[string, EntryNormalized], any>;
        additionalPass: liteTapable.AsyncSeriesHook<[]>;
    };
    // (undocumented)
    idle: boolean;
    // (undocumented)
    get immutablePaths(): never;
    // (undocumented)
    infrastructureLogger: any;
    // (undocumented)
    inputFileSystem: InputFileSystem | null;
    // (undocumented)
    intermediateFileSystem: IntermediateFileSystem | null;
    // (undocumented)
    isChild(): boolean;
    // (undocumented)
    get _lastCompilation(): Compilation | undefined;
    // (undocumented)
    get managedPaths(): never;
    // (undocumented)
    modifiedFiles?: ReadonlySet<string>;
    // (undocumented)
    name?: string;
    // (undocumented)
    options: RspackOptionsNormalized;
    // (undocumented)
    outputFileSystem: OutputFileSystem | null;
    // (undocumented)
    outputPath: string;
    // (undocumented)
    parentCompilation?: Compilation;
    // (undocumented)
    purgeInputFileSystem(): void;
    // (undocumented)
    records: Record<string, any[]>;
    // (undocumented)
    get recordsInputPath(): never;
    // (undocumented)
    get recordsOutputPath(): never;
    // (undocumented)
    removedFiles?: ReadonlySet<string>;
    // (undocumented)
    resolverFactory: ResolverFactory;
    // (undocumented)
    root: Compiler;
    // (undocumented)
    rspack: typeof rspack;
    // (undocumented)
    run(callback: liteTapable.Callback<Error, Stats>): void;
    // (undocumented)
    runAsChild(callback: (err?: null | Error, entries?: Chunk[], compilation?: Compilation) => any): void;
    // (undocumented)
    running: boolean;
    // (undocumented)
    watch(watchOptions: Watchpack.WatchOptions, handler: liteTapable.Callback<Error, Stats>): Watching;
    // (undocumented)
    watchFileSystem: WatchFileSystem | null;
    // (undocumented)
    watching?: Watching;
    // (undocumented)
    watchMode: boolean;
    // (undocumented)
    webpack: typeof rspack;
}

// @public (undocumented)
type Config = {
    getNormalizedRspackOptions: typeof getNormalizedRspackOptions;
    applyRspackOptionsDefaults: typeof applyRspackOptionsDefaults;
    getNormalizedWebpackOptions: typeof getNormalizedRspackOptions;
    applyWebpackOptionsDefaults: typeof applyRspackOptionsDefaults;
};

// @public (undocumented)
export const config: Config;

// @public
interface Config_2 {
    // (undocumented)
    env?: EnvConfig;
    exclude?: string | string[];
    // (undocumented)
    inlineSourcesContent?: boolean;
    // (undocumented)
    jsc?: JscConfig;
    // (undocumented)
    minify?: boolean;
    // (undocumented)
    module?: ModuleConfig;
    sourceMaps?: boolean | "inline";
    test?: string | string[];
}

// @public
export type Configuration = RspackOptions;

// @public
interface ConstModulesConfig {
    // (undocumented)
    globals?: {
        [module: string]: {
            [name: string]: string;
        };
    };
}

// @public (undocumented)
export type Consumes = (ConsumesItem | ConsumesObject)[] | ConsumesObject;

// @public (undocumented)
export type ConsumesConfig = {
    eager?: boolean;
    import?: false | ConsumesItem;
    packageName?: string;
    requiredVersion?: false | string;
    shareKey?: string;
    shareScope?: string;
    singleton?: boolean;
    strictVersion?: boolean;
};

// @public (undocumented)
class ConsumeSharedPlugin extends RspackBuiltinPlugin {
    constructor(options: ConsumeSharedPluginOptions);
    // (undocumented)
    name: BuiltinPluginName;
    // (undocumented)
    _options: {
        consumes: [string, {
            import: string | undefined;
            shareScope: string;
            shareKey: string;
            requiredVersion: string | false | undefined;
            strictVersion: boolean;
            packageName: string | undefined;
            singleton: boolean;
            eager: boolean;
        }][];
        enhanced: boolean;
    };
    // (undocumented)
    raw(compiler: Compiler): BuiltinPlugin;
}

// @public (undocumented)
export type ConsumeSharedPluginOptions = {
    consumes: Consumes;
    shareScope?: string;
    enhanced?: boolean;
};

// @public (undocumented)
export type ConsumesItem = string;

// @public (undocumented)
export type ConsumesObject = {
    [k: string]: ConsumesConfig | ConsumesItem;
};

// @public (undocumented)
export const container: {
    ContainerPlugin: typeof ContainerPlugin;
    ContainerReferencePlugin: typeof ContainerReferencePlugin;
    ModuleFederationPlugin: typeof ModuleFederationPlugin;
    ModuleFederationPluginV1: typeof ModuleFederationPluginV1;
};

// @public (undocumented)
class ContainerPlugin extends RspackBuiltinPlugin {
    constructor(options: ContainerPluginOptions);
    // (undocumented)
    name: BuiltinPluginName;
    // (undocumented)
    _options: {
        name: string;
        shareScope: string;
        library: LibraryOptions;
        runtime: EntryRuntime | undefined;
        filename: string | undefined;
        exposes: [string, {
            import: string[];
            name: string | undefined;
        }][];
        enhanced: boolean;
    };
    // (undocumented)
    raw(compiler: Compiler): BuiltinPlugin;
}

// @public (undocumented)
export type ContainerPluginOptions = {
    exposes: Exposes;
    filename?: FilenameTemplate;
    library?: LibraryOptions;
    name: string;
    runtime?: EntryRuntime;
    shareScope?: string;
    enhanced?: boolean;
};

// @public (undocumented)
class ContainerReferencePlugin extends RspackBuiltinPlugin {
    constructor(options: ContainerReferencePluginOptions);
    // (undocumented)
    name: BuiltinPluginName;
    // (undocumented)
    _options: {
        remoteType: ExternalsType;
        remotes: [string, {
            external: string[];
            shareScope: string;
        }][];
        enhanced: boolean;
    };
    // (undocumented)
    raw(compiler: Compiler): BuiltinPlugin;
}

// @public (undocumented)
export type ContainerReferencePluginOptions = {
    remoteType: ExternalsType;
    remotes: Remotes;
    shareScope?: string;
    enhanced?: boolean;
};

// @public
export type Context = string;

// @public (undocumented)
type ContextInfo = {
    issuer: string;
    issuerLayer?: string;
};

// @public (undocumented)
class ContextModuleFactory {
    constructor();
    // (undocumented)
    hooks: {
        beforeResolve: liteTapable.AsyncSeriesWaterfallHook<[
        ContextModuleFactoryBeforeResolveResult
        ], ContextModuleFactoryBeforeResolveResult | void>;
        afterResolve: liteTapable.AsyncSeriesWaterfallHook<[
        ContextModuleFactoryAfterResolveResult
        ], ContextModuleFactoryAfterResolveResult | void>;
    };
}

// @public (undocumented)
class ContextModuleFactoryAfterResolveData {
    // (undocumented)
    static __from_binding(binding: JsContextModuleFactoryAfterResolveData): ContextModuleFactoryAfterResolveData;
    // (undocumented)
    static __to_binding(data: ContextModuleFactoryAfterResolveData): JsContextModuleFactoryAfterResolveData;
    // (undocumented)
    context: string;
    // (undocumented)
    readonly dependencies: Dependency[];
    // (undocumented)
    recursive: boolean;
    // (undocumented)
    regExp: RegExp | undefined;
    // (undocumented)
    request: string;
    // (undocumented)
    resource: number;
}

// @public (undocumented)
type ContextModuleFactoryAfterResolveResult = false | ContextModuleFactoryAfterResolveData;

// @public (undocumented)
class ContextModuleFactoryBeforeResolveData {
    // (undocumented)
    static __from_binding(binding: JsContextModuleFactoryBeforeResolveData): ContextModuleFactoryBeforeResolveData;
    // (undocumented)
    static __to_binding(data: ContextModuleFactoryBeforeResolveData): JsContextModuleFactoryBeforeResolveData;
    // (undocumented)
    context: string;
    // (undocumented)
    recursive: boolean;
    // (undocumented)
    regExp: RegExp | undefined;
    // (undocumented)
    request: string;
}

// @public (undocumented)
type ContextModuleFactoryBeforeResolveResult = false | ContextModuleFactoryBeforeResolveData;

// @public (undocumented)
export const ContextReplacementPlugin: {
    new (resourceRegExp: RegExp, newContentResource?: any, newContentRecursive?: any, newContentRegExp?: any): {
        name: BuiltinPluginName;
        _args: [resourceRegExp: RegExp, newContentResource?: any, newContentRecursive?: any, newContentRegExp?: any];
        affectedHooks: "done" | "make" | "environment" | "compile" | "emit" | "afterEmit" | "invalid" | "thisCompilation" | "afterDone" | "compilation" | "normalModuleFactory" | "contextModuleFactory" | "initialize" | "shouldEmit" | "infrastructureLog" | "beforeRun" | "run" | "assetEmitted" | "failed" | "shutdown" | "watchRun" | "watchClose" | "afterEnvironment" | "afterPlugins" | "afterResolvers" | "beforeCompile" | "afterCompile" | "finishMake" | "entryOption" | "additionalPass" | undefined;
        raw(compiler: Compiler_2): BuiltinPlugin;
        apply(compiler: Compiler_2): void;
    };
};

// @public (undocumented)
export const CopyRspackPlugin: {
    new (copy: CopyRspackPluginOptions): {
        name: BuiltinPluginName;
        _args: [copy: CopyRspackPluginOptions];
        affectedHooks: "done" | "make" | "environment" | "compile" | "emit" | "afterEmit" | "invalid" | "thisCompilation" | "afterDone" | "compilation" | "normalModuleFactory" | "contextModuleFactory" | "initialize" | "shouldEmit" | "infrastructureLog" | "beforeRun" | "run" | "assetEmitted" | "failed" | "shutdown" | "watchRun" | "watchClose" | "afterEnvironment" | "afterPlugins" | "afterResolvers" | "beforeCompile" | "afterCompile" | "finishMake" | "entryOption" | "additionalPass" | undefined;
        raw(compiler: Compiler_2): BuiltinPlugin;
        apply(compiler: Compiler_2): void;
    };
};

// @public (undocumented)
export type CopyRspackPluginOptions = {
    patterns: (string | ({
        from: string;
    } & Partial<RawCopyPattern>))[];
};

// @public (undocumented)
type CreateData = Partial<JsCreateData>;

// @public (undocumented)
type CreateStatsOptionsContext = KnownCreateStatsOptionsContext & Record<string, any>;

// @public
export type CrossOriginLoading = false | "anonymous" | "use-credentials";

// @public
export type CssAutoGeneratorOptions = {
    exportsConvention?: CssGeneratorExportsConvention;
    exportsOnly?: CssGeneratorExportsOnly;
    localIdentName?: CssGeneratorLocalIdentName;
    esModule?: CssGeneratorEsModule;
};

// @public
export type CssAutoParserOptions = {
    namedExports?: CssParserNamedExports;
};

// @public
export type CssChunkFilename = Filename;

// @public (undocumented)
export interface CssExtractRspackLoaderOptions {
    // (undocumented)
    defaultExport?: boolean;
    // (undocumented)
    emit?: boolean;
    // (undocumented)
    esModule?: boolean;
    // (undocumented)
    layer?: string;
    // (undocumented)
    publicPath?: string | ((resourcePath: string, context: string) => string);
}

// @public (undocumented)
export class CssExtractRspackPlugin {
    constructor(options?: CssExtractRspackPluginOptions);
    // (undocumented)
    apply(compiler: Compiler): void;
    // (undocumented)
    static loader: string;
    // (undocumented)
    normalizeOptions(options: CssExtractRspackPluginOptions): RawCssExtractPluginOption;
    // (undocumented)
    options: CssExtractRspackPluginOptions;
    // (undocumented)
    static pluginName: string;
}

// @public (undocumented)
export interface CssExtractRspackPluginOptions {
    // (undocumented)
    attributes?: Record<string, string>;
    // (undocumented)
    chunkFilename?: RawCssExtractPluginOption["chunkFilename"];
    // (undocumented)
    filename?: RawCssExtractPluginOption["filename"];
    // (undocumented)
    ignoreOrder?: boolean;
    // (undocumented)
    insert?: string | ((linkTag: HTMLLinkElement) => void);
    // (undocumented)
    linkType?: string | "text/css" | false;
    // (undocumented)
    pathinfo?: boolean;
    // (undocumented)
    runtime?: boolean;
}

// @public
export type CssFilename = Filename;

// @public (undocumented)
export type CssGeneratorEsModule = boolean;

// @public (undocumented)
export type CssGeneratorExportsConvention = "as-is" | "camel-case" | "camel-case-only" | "dashes" | "dashes-only";

// @public (undocumented)
export type CssGeneratorExportsOnly = boolean;

// @public (undocumented)
export type CssGeneratorLocalIdentName = string;

// @public
export type CssGeneratorOptions = {
    exportsOnly?: CssGeneratorExportsOnly;
    esModule?: CssGeneratorEsModule;
};

// @public
export type CssModuleGeneratorOptions = CssAutoGeneratorOptions;

// @public
export type CssModuleParserOptions = {
    namedExports?: CssParserNamedExports;
};

// @public (undocumented)
export type CssParserNamedExports = boolean;

// @public
export type CssParserOptions = {
    namedExports?: CssParserNamedExports;
};

// @public (undocumented)
type CustomErrorParams = Partial<util_2.Omit<ZodCustomIssue, "code">>;

// @public (undocumented)
export const DefinePlugin: {
    new (define: DefinePluginOptions): {
        name: BuiltinPluginName;
        _args: [define: DefinePluginOptions];
        affectedHooks: "done" | "make" | "environment" | "compile" | "emit" | "afterEmit" | "invalid" | "thisCompilation" | "afterDone" | "compilation" | "normalModuleFactory" | "contextModuleFactory" | "initialize" | "shouldEmit" | "infrastructureLog" | "beforeRun" | "run" | "assetEmitted" | "failed" | "shutdown" | "watchRun" | "watchClose" | "afterEnvironment" | "afterPlugins" | "afterResolvers" | "beforeCompile" | "afterCompile" | "finishMake" | "entryOption" | "additionalPass" | undefined;
        raw(compiler: Compiler_2): BuiltinPlugin;
        apply(compiler: Compiler_2): void;
    };
};

// @public (undocumented)
export type DefinePluginOptions = Record<string, CodeValue>;

// @public
export type Dependencies = Name[];

// @public (undocumented)
class DependenciesBlock {
    // (undocumented)
    static __from_binding(binding: JsDependenciesBlock): DependenciesBlock;
    // (undocumented)
    static __to_binding(block: DependenciesBlock): JsDependenciesBlock;
    // (undocumented)
    readonly blocks: DependenciesBlock[];
    // (undocumented)
    readonly dependencies: Dependency[];
}

// @public (undocumented)
class Dependency {
    // (undocumented)
    static __from_binding(binding: JsDependency): Dependency;
    // (undocumented)
    static __to_binding(data: Dependency): JsDependency;
    // (undocumented)
    readonly category: string;
    // (undocumented)
    critical: boolean;
    // (undocumented)
    readonly request: string | undefined;
    // (undocumented)
    readonly type: string;
}

// @public (undocumented)
type DependencyLocation = any;

// @public
export interface DevServer extends webpackDevServer.Configuration {
}

// @public
export type DevTool = false | "eval" | "cheap-source-map" | "cheap-module-source-map" | "source-map" | "inline-cheap-source-map" | "inline-cheap-module-source-map" | "inline-source-map" | "inline-nosources-cheap-source-map" | "inline-nosources-cheap-module-source-map" | "inline-nosources-source-map" | "nosources-cheap-source-map" | "nosources-cheap-module-source-map" | "nosources-source-map" | "hidden-nosources-cheap-source-map" | "hidden-nosources-cheap-module-source-map" | "hidden-nosources-source-map" | "hidden-cheap-source-map" | "hidden-cheap-module-source-map" | "hidden-source-map" | "eval-cheap-source-map" | "eval-cheap-module-source-map" | "eval-source-map" | "eval-nosources-cheap-source-map" | "eval-nosources-cheap-module-source-map" | "eval-nosources-source-map";

// @public
export type DevtoolFallbackModuleFilenameTemplate = DevtoolModuleFilenameTemplate;

// @public
export type DevtoolModuleFilenameTemplate = string | ((info: any) => any);

// @public
export type DevtoolNamespace = string;

// @public (undocumented)
interface Diagnostic {
    // (undocumented)
    file?: string;
    // (undocumented)
    help?: string;
    location?: DiagnosticLocation;
    // (undocumented)
    message: string;
    // (undocumented)
    severity: "error" | "warning";
    // (undocumented)
    sourceCode?: string;
}

// @public (undocumented)
interface DiagnosticLocation {
    column: number;
    length: number;
    line: number;
    text?: string;
}

// @public (undocumented)
class DirectoryWatcher extends EventEmitter {
    constructor(directoryPath: string, options: Watchpack.WatcherOptions);
    // (undocumented)
    close(): void;
    // (undocumented)
    createNestedWatcher(directoryPath: string): void;
    // (undocumented)
    directories: {
        [path: string]: Watcher_2 | true;
    };
    // (undocumented)
    doInitialScan(): void;
    // (undocumented)
    files: {
        [path: string]: [number, number];
    };
    // (undocumented)
    getTimes(): {
        [path: string]: number;
    };
    // (undocumented)
    initialScan: boolean;
    // (undocumented)
    initialScanRemoved: string[];
    // (undocumented)
    nestedWatching: boolean;
    // (undocumented)
    onChange(filePath: string, stat: fs.Stats): void;
    // (undocumented)
    onDirectoryAdded(directoryPath: string): void;
    // (undocumented)
    onDirectoryUnlinked(directoryPath: string): void;
    // (undocumented)
    onFileAdded(filePath: string, stat: fs.Stats): void;
    // (undocumented)
    onFileUnlinked(filePath: string): void;
    // (undocumented)
    onWatcherError(): void;
    // (undocumented)
    options: Watchpack.WatcherOptions;
    // (undocumented)
    path: string;
    // (undocumented)
    refs: number;
    // (undocumented)
    setDirectory(directoryPath: string, exist: boolean, initial: boolean): void;
    // (undocumented)
    setFileTime(filePath: string, mtime: number, initial: boolean, type?: string | boolean): void;
    // (undocumented)
    setNestedWatching(flag: boolean): void;
    // (undocumented)
    watch(filePath: string, startTime: number): Watcher_2;
    // (undocumented)
    watcher: fs.FSWatcher;
    // (undocumented)
    watchers: {
        [path: string]: Watcher_2[];
    };
}

// @public (undocumented)
type DIRTY<T> = {
    status: "dirty";
    value: T;
};

// @public (undocumented)
const DIRTY: <T>(value: T) => DIRTY<T>;

// @public (undocumented)
export class DllPlugin {
    constructor(options: DllPluginOptions);
    // (undocumented)
    apply(compiler: Compiler): void;
}

// @public (undocumented)
export type DllPluginOptions = {
    context?: string;
    entryOnly?: boolean;
    format?: boolean;
    name?: string;
    path: string;
    type?: string;
};

// @public (undocumented)
export class DllReferencePlugin {
    constructor(options: DllReferencePluginOptions);
    // (undocumented)
    apply(compiler: Compiler): void;
}

// @public (undocumented)
export type DllReferencePluginOptions = {
    context?: string;
    extensions?: string[];
    manifest: string | DllReferencePluginOptionsManifest;
    name?: string;
    scope?: string;
    sourceType?: DllReferencePluginOptionsSourceType;
    type?: "require" | "object";
} | {
    content: DllReferencePluginOptionsContent;
    context?: string;
    extensions?: string[];
    name: string;
    scope?: string;
    sourceType?: DllReferencePluginOptionsSourceType;
    type?: "require" | "object";
};

// @public
export interface DllReferencePluginOptionsContent {
    [k: string]: {
        buildMeta?: JsBuildMeta;
        exports?: string[] | true;
        id?: string;
    };
}

// @public
export interface DllReferencePluginOptionsManifest {
    content: DllReferencePluginOptionsContent;
    name?: string;
    type?: DllReferencePluginOptionsSourceType;
}

// @public
export type DllReferencePluginOptionsSourceType = "var" | "assign" | "this" | "window" | "global" | "commonjs" | "commonjs2" | "commonjs-module" | "amd" | "amd-require" | "umd" | "umd2" | "jsonp" | "system";

// @public (undocumented)
interface Drafts {
    customMedia?: boolean;
}

// @public (undocumented)
export class DynamicEntryPlugin extends RspackBuiltinPlugin {
    constructor(context: string, entry: EntryDynamicNormalized);
    // (undocumented)
    affectedHooks: "make";
    // (undocumented)
    name: BuiltinPluginName;
    // (undocumented)
    raw(compiler: Compiler): BuiltinPlugin | undefined;
}

// @public (undocumented)
type Effect<T> = RefinementEffect<T> | TransformEffect<T> | PreprocessEffect<T>;

// @public (undocumented)
interface Electron {
    // (undocumented)
    ElectronTargetPlugin: typeof ElectronTargetPlugin;
}

// @public (undocumented)
export const electron: Electron;

// @public (undocumented)
const ElectronTargetPlugin: {
    new (context?: string | undefined): {
        name: BuiltinPluginName;
        _args: [context?: string | undefined];
        affectedHooks: "done" | "make" | "environment" | "compile" | "emit" | "afterEmit" | "invalid" | "thisCompilation" | "afterDone" | "compilation" | "normalModuleFactory" | "contextModuleFactory" | "initialize" | "shouldEmit" | "infrastructureLog" | "beforeRun" | "run" | "assetEmitted" | "failed" | "shutdown" | "watchRun" | "watchClose" | "afterEnvironment" | "afterPlugins" | "afterResolvers" | "beforeCompile" | "afterCompile" | "finishMake" | "entryOption" | "additionalPass" | undefined;
        raw(compiler: Compiler_2): BuiltinPlugin;
        apply(compiler: Compiler_2): void;
    };
};

// @public (undocumented)
const EnableChunkLoadingPlugin: {
    new (type: string): {
        name: BuiltinPluginName;
        _args: [type: string];
        affectedHooks: "done" | "make" | "environment" | "compile" | "emit" | "afterEmit" | "invalid" | "thisCompilation" | "afterDone" | "compilation" | "normalModuleFactory" | "contextModuleFactory" | "initialize" | "shouldEmit" | "infrastructureLog" | "beforeRun" | "run" | "assetEmitted" | "failed" | "shutdown" | "watchRun" | "watchClose" | "afterEnvironment" | "afterPlugins" | "afterResolvers" | "beforeCompile" | "afterCompile" | "finishMake" | "entryOption" | "additionalPass" | undefined;
        raw(compiler: Compiler_2): BuiltinPlugin;
        apply(compiler: Compiler_2): void;
    };
};

// @public
export type EnabledChunkLoadingTypes = string[];

// @public
export type EnabledLibraryTypes = string[];

// @public
export type EnabledWasmLoadingTypes = string[];

// @public (undocumented)
class EnableLibraryPlugin extends RspackBuiltinPlugin {
    constructor(type: LibraryType);
    // (undocumented)
    static checkEnabled(compiler: Compiler, type: LibraryType): void;
    // (undocumented)
    name: BuiltinPluginName;
    // (undocumented)
    raw(compiler: Compiler): BuiltinPlugin | undefined;
    // (undocumented)
    static setEnabled(compiler: Compiler, type: LibraryType): void;
}

// @public (undocumented)
const EnableWasmLoadingPlugin: {
    new (type: string): {
        name: BuiltinPluginName;
        _args: [type: string];
        affectedHooks: "done" | "make" | "environment" | "compile" | "emit" | "afterEmit" | "invalid" | "thisCompilation" | "afterDone" | "compilation" | "normalModuleFactory" | "contextModuleFactory" | "initialize" | "shouldEmit" | "infrastructureLog" | "beforeRun" | "run" | "assetEmitted" | "failed" | "shutdown" | "watchRun" | "watchClose" | "afterEnvironment" | "afterPlugins" | "afterResolvers" | "beforeCompile" | "afterCompile" | "finishMake" | "entryOption" | "additionalPass" | undefined;
        raw(compiler: Compiler_2): BuiltinPlugin;
        apply(compiler: Compiler_2): void;
    };
};

// @public (undocumented)
type EncodingOption = ObjectEncodingOptions | BufferEncoding | undefined | null;

// @public
export type Entry = EntryStatic | EntryDynamic;

// @public (undocumented)
interface Entry_2 {
    safeTime: number;
    timestamp: number;
}

// @public (undocumented)
class EntryData {
    // (undocumented)
    static __from_binding(binding: binding.JsEntryData): EntryData;
    // (undocumented)
    dependencies: Dependency[];
    // (undocumented)
    includeDependencies: Dependency[];
    // (undocumented)
    options: binding.JsEntryOptions;
}

// @public (undocumented)
interface EntryDependency {
    // (undocumented)
    request: string;
}

// @public
export type EntryDependOn = string | string[];

// @public
export type EntryDescription = {
    import: EntryItem;
    runtime?: EntryRuntime;
    publicPath?: PublicPath;
    baseUri?: BaseUri;
    chunkLoading?: ChunkLoading;
    asyncChunks?: AsyncChunks;
    wasmLoading?: WasmLoading;
    filename?: EntryFilename;
    library?: LibraryOptions;
    dependOn?: EntryDependOn;
    layer?: Layer;
};

// @public (undocumented)
export type EntryDescriptionNormalized = Pick<EntryDescription, "runtime" | "chunkLoading" | "asyncChunks" | "publicPath" | "baseUri" | "filename" | "library" | "layer"> & {
    import?: string[];
    dependOn?: string[];
};

// @public
export type EntryDynamic = () => EntryStatic | Promise<EntryStatic>;

// @public (undocumented)
export type EntryDynamicNormalized = () => Promise<EntryStaticNormalized>;

// @public
export type EntryFilename = Filename;

// @public
export type EntryItem = string | string[];

// @public (undocumented)
export type EntryNormalized = EntryDynamicNormalized | EntryStaticNormalized;

// @public (undocumented)
export type EntryObject = Record<string, EntryItem | EntryDescription>;

// @public (undocumented)
export class EntryOptionPlugin {
    // (undocumented)
    apply(compiler: Compiler): void;
    // (undocumented)
    static applyEntryOption(compiler: Compiler, context: string, entry: EntryNormalized): void;
    // (undocumented)
    static entryDescriptionToOptions(compiler: Compiler, name: string, desc: EntryDescriptionNormalized): EntryOptions;
}

// @public
export type EntryOptions = Omit<EntryDescriptionNormalized, "import"> & {
    name?: string;
};

// @public (undocumented)
export const EntryPlugin: EntryPluginType;

// @public (undocumented)
type EntryPluginType = typeof OriginEntryPlugin & {
    createDependency(entry: string): EntryDependency;
};

// @public (undocumented)
class Entrypoint extends ChunkGroup {
    protected constructor(binding: JsChunkGroup);
    // (undocumented)
    static __from_binding(binding: JsChunkGroup): Entrypoint;
    // (undocumented)
    getRuntimeChunk(): Readonly<Chunk | null>;
}

// @public
export type EntryRuntime = false | string;

// @public
export type EntryStatic = EntryObject | EntryUnnamed;

// @public (undocumented)
export interface EntryStaticNormalized {
    // (undocumented)
    [k: string]: EntryDescriptionNormalized;
}

// @public (undocumented)
export type EntryUnnamed = EntryItem;

// @public
interface EnvConfig {
    bugfixes?: boolean;
    coreJs?: string;
    // (undocumented)
    debug?: boolean;
    // (undocumented)
    dynamicImport?: boolean;
    // (undocumented)
    exclude?: string[];
    forceAllTransforms?: boolean;
    // (undocumented)
    include?: string[];
    // (undocumented)
    loose?: boolean;
    // (undocumented)
    mode?: "usage" | "entry";
    // (undocumented)
    path?: string;
    // (undocumented)
    shippedProposals?: boolean;
    // (undocumented)
    skip?: string[];
    // (undocumented)
    targets?: any;
}

// @public
export type Environment = {
    arrowFunction?: boolean;
    asyncFunction?: boolean;
    bigIntLiteral?: boolean;
    const?: boolean;
    destructuring?: boolean;
    document?: boolean;
    dynamicImport?: boolean;
    dynamicImportInWorker?: boolean;
    forOf?: boolean;
    globalThis?: boolean;
    module?: boolean;
    nodePrefixForCoreModules?: boolean;
    optionalChaining?: boolean;
    templateLiteral?: boolean;
};

// @public (undocumented)
export class EnvironmentPlugin {
    constructor(...keys: string[] | [Record<string, string | undefined | null> | string | string[]]);
    apply(compiler: Compiler): void;
    // (undocumented)
    defaultValues: Record<string, string | undefined | null>;
    // (undocumented)
    keys: string[];
}

// @public (undocumented)
type ErrorMapCtx = {
    defaultError: string;
    data: any;
};

// @public (undocumented)
namespace errorUtil {
    // (undocumented)
    type ErrMessage = string | {
        message?: string;
    };
    const // (undocumented)
    errToObj: (message?: ErrMessage | undefined) => {
        message?: string | undefined;
    };
    const // (undocumented)
    toString: (message?: ErrMessage | undefined) => string | undefined;
}

// @public (undocumented)
type ErrorWithDetails = Error & {
    details?: string;
};

// @public (undocumented)
interface Es6Config extends BaseModuleConfig {
    // (undocumented)
    type: "es6";
}

// @public (undocumented)
interface EsParserConfig {
    allowReturnOutsideFunction?: boolean;
    allowSuperOutsideMethod?: boolean;
    autoAccessors?: boolean;
    // @deprecated (undocumented)
    classPrivateProperty?: boolean;
    // @deprecated (undocumented)
    classProperty?: boolean;
    decorators?: boolean;
    decoratorsBeforeExport?: boolean;
    // @deprecated (undocumented)
    dynamicImport?: boolean;
    explicitResourceManagement?: boolean;
    exportDefaultFrom?: boolean;
    // @deprecated (undocumented)
    exportNamespaceFrom?: boolean;
    functionBind?: boolean;
    // @deprecated (undocumented)
    importAssertions?: boolean;
    importAttributes?: boolean;
    // @deprecated (undocumented)
    importMeta?: boolean;
    jsx?: boolean;
    // @deprecated (undocumented)
    nullishCoalescing?: boolean;
    // @deprecated (undocumented)
    numericSeparator?: boolean;
    // @deprecated (undocumented)
    optionalChaining?: boolean;
    // @deprecated (undocumented)
    privateMethod?: boolean;
    // (undocumented)
    syntax: "ecmascript";
    // @deprecated (undocumented)
    topLevelAwait?: boolean;
}

// @public (undocumented)
interface Etag {
    // (undocumented)
    toString(): string;
}

// @public (undocumented)
export const EvalDevToolModulePlugin: {
    new (options: EvalDevToolModulePluginOptions): {
        name: BuiltinPluginName;
        _args: [options: EvalDevToolModulePluginOptions];
        affectedHooks: "done" | "make" | "environment" | "compile" | "emit" | "afterEmit" | "invalid" | "thisCompilation" | "afterDone" | "compilation" | "normalModuleFactory" | "contextModuleFactory" | "initialize" | "shouldEmit" | "infrastructureLog" | "beforeRun" | "run" | "assetEmitted" | "failed" | "shutdown" | "watchRun" | "watchClose" | "afterEnvironment" | "afterPlugins" | "afterResolvers" | "beforeCompile" | "afterCompile" | "finishMake" | "entryOption" | "additionalPass" | undefined;
        raw(compiler: Compiler_2): BuiltinPlugin;
        apply(compiler: Compiler_2): void;
    };
};

export { EvalDevToolModulePluginOptions }

// @public (undocumented)
export const EvalSourceMapDevToolPlugin: {
    new (options: SourceMapDevToolPluginOptions): {
        name: BuiltinPluginName;
        _args: [options: SourceMapDevToolPluginOptions];
        affectedHooks: "done" | "make" | "environment" | "compile" | "emit" | "afterEmit" | "invalid" | "thisCompilation" | "afterDone" | "compilation" | "normalModuleFactory" | "contextModuleFactory" | "initialize" | "shouldEmit" | "infrastructureLog" | "beforeRun" | "run" | "assetEmitted" | "failed" | "shutdown" | "watchRun" | "watchClose" | "afterEnvironment" | "afterPlugins" | "afterResolvers" | "beforeCompile" | "afterCompile" | "finishMake" | "entryOption" | "additionalPass" | undefined;
        raw(compiler: Compiler_2): BuiltinPlugin;
        apply(compiler: Compiler_2): void;
    };
};

// @public (undocumented)
interface ExecuteModuleArgument {
    // (undocumented)
    codeGenerationResult: CodeGenerationResult;
    // (undocumented)
    moduleObject: {
        id: string;
        exports: any;
        loaded: boolean;
        error?: Error;
    };
}

// @public (undocumented)
interface ExecuteModuleContext {
    // (undocumented)
    __webpack_require__: (id: string) => any;
}

// @public (undocumented)
export type ExperimentCacheNormalized = boolean | {
    type: "memory";
} | {
    type: "persistent";
    buildDependencies: string[];
    version: string;
    snapshot: {
        immutablePaths: Array<string | RegExp>;
        unmanagedPaths: Array<string | RegExp>;
        managedPaths: Array<string | RegExp>;
    };
    storage: {
        type: "filesystem";
        directory: string;
    };
};

// @public
export type ExperimentCacheOptions = boolean | {
    type: "memory";
} | {
    type: "persistent";
    buildDependencies?: string[];
    version?: string;
    snapshot?: {
        immutablePaths?: Array<string | RegExp>;
        unmanagedPaths?: Array<string | RegExp>;
        managedPaths?: Array<string | RegExp>;
    };
    storage?: {
        type: "filesystem";
        directory?: string;
    };
};

// @public
export type Experiments = {
    cache?: ExperimentCacheOptions;
    lazyCompilation?: boolean | LazyCompilationOptions;
    asyncWebAssembly?: boolean;
    outputModule?: boolean;
    topLevelAwait?: boolean;
    css?: boolean;
    layers?: boolean;
    incremental?: boolean | Incremental;
    futureDefaults?: boolean;
    rspackFuture?: RspackFutureOptions;
};

// @public (undocumented)
export const experiments: Experiments_2;

// @public (undocumented)
interface Experiments_2 {
    // (undocumented)
    globalTrace: {
        register: typeof registerGlobalTrace;
        cleanup: typeof cleanupGlobalTrace;
    };
    // (undocumented)
    RemoveDuplicateModulesPlugin: typeof RemoveDuplicateModulesPlugin;
}

// @public (undocumented)
export interface ExperimentsNormalized {
    // (undocumented)
    asyncWebAssembly?: boolean;
    // (undocumented)
    cache?: ExperimentCacheNormalized;
    // (undocumented)
    css?: boolean;
    // (undocumented)
    futureDefaults?: boolean;
    // (undocumented)
    incremental?: false | Incremental;
    // (undocumented)
    layers?: boolean;
    // (undocumented)
    lazyCompilation?: false | LazyCompilationOptions;
    // (undocumented)
    outputModule?: boolean;
    // (undocumented)
    rspackFuture?: RspackFutureOptions;
    // (undocumented)
    topLevelAwait?: boolean;
}

// @public (undocumented)
class ExportsInfo {
    // (undocumented)
    static __from_binding(binding: JsExportsInfo): ExportsInfo;
    // (undocumented)
    getUsed(name: string | string[], runtime: RuntimeSpec): UsageStateType;
    // (undocumented)
    isModuleUsed(runtime: RuntimeSpec): boolean;
    // (undocumented)
    isUsed(runtime: RuntimeSpec): boolean;
    // (undocumented)
    setUsedInUnknownWay(runtime: RuntimeSpec): boolean;
}

// @public (undocumented)
type ExportsPresence = "error" | "warn" | "auto" | false;

// @public (undocumented)
export type Exposes = (ExposesItem | ExposesObject)[] | ExposesObject;

// @public (undocumented)
export type ExposesConfig = {
    import: ExposesItem | ExposesItems;
    name?: string;
};

// @public (undocumented)
export type ExposesItem = string;

// @public (undocumented)
export type ExposesItems = ExposesItem[];

// @public (undocumented)
export type ExposesObject = {
    [k: string]: ExposesConfig | ExposesItem | ExposesItems;
};

// @public
export type ExternalItem = string | RegExp | ExternalItemObjectUnknown | ((data: ExternalItemFunctionData) => ExternalItemValue) | ((data: ExternalItemFunctionData, callback: (err?: Error, result?: ExternalItemValue, type?: ExternalsType) => void) => void) | ((data: ExternalItemFunctionData) => Promise<ExternalItemValue>);

// @public
export type ExternalItemFunctionData = {
    context?: string;
    dependencyType?: string;
    request?: string;
    contextInfo?: {
        issuer: string;
        issuerLayer?: string | null;
    };
    getResolve?: (options?: ResolveOptions) => ((context: string, request: string, callback: (err?: Error, result?: string) => void) => void) | ((context: string, request: string) => Promise<string>);
};

// @public
export type ExternalItemObjectUnknown = {
    [x: string]: ExternalItemValue;
};

// @public
export type ExternalItemObjectValue = Record<string, string | string[]>;

// @public
export type ExternalItemUmdValue = {
    root: string | string[];
    commonjs: string | string[];
    commonjs2: string | string[];
    amd: string | string[];
};

// @public
export type ExternalItemValue = string | boolean | string[] | ExternalItemUmdValue
/**
* when libraryTarget and externalsType is not 'umd'
*/
| ExternalItemObjectValue;

// @public
export type Externals = ExternalItem | ExternalItem[];

// @public (undocumented)
export class ExternalsPlugin extends RspackBuiltinPlugin {
    constructor(type: string, externals: Externals);
    // (undocumented)
    name: BuiltinPluginName;
    // (undocumented)
    raw(compiler: Compiler): BuiltinPlugin | undefined;
}

// @public
export type ExternalsPresets = {
    node?: boolean;
    web?: boolean;
    webAsync?: boolean;
    electron?: boolean;
    electronMain?: boolean;
    electronPreload?: boolean;
    electronRenderer?: boolean;
    nwjs?: boolean;
};

// @public
export type ExternalsType = "var" | "module" | "assign" | "this" | "window" | "self" | "global" | "commonjs" | "commonjs2" | "commonjs-module" | "commonjs-static" | "amd" | "amd-require" | "umd" | "umd2" | "jsonp" | "system" | "promise" | "import" | "module-import" | "script" | "node-commonjs" | "commonjs-import";

// @public (undocumented)
export const externalsType: z.ZodEnum<["var", "module", "assign", "this", "window", "self", "global", "commonjs", "commonjs2", "commonjs-module", "commonjs-static", "amd", "amd-require", "umd", "umd2", "jsonp", "system", "promise", "import", "module-import", "script", "node-commonjs", "commonjs-import"]>;

// @public (undocumented)
type ExtractCommentsBanner = string | boolean;

// @public (undocumented)
type ExtractCommentsCondition = boolean | RegExp;

// @public (undocumented)
type ExtractCommentsObject = {
    condition?: ExtractCommentsCondition | undefined;
    banner?: ExtractCommentsBanner | undefined;
};

// @public (undocumented)
type ExtractCommentsOptions = ExtractCommentsCondition | ExtractCommentsObject;

// @public (undocumented)
type ExtraPluginHookData = {
    plugin: {
        options: HtmlRspackPluginOptions;
    };
};

// @public (undocumented)
export type Falsy = false | "" | 0 | null | undefined;

// @public (undocumented)
const FetchCompileAsyncWasmPlugin: {
    new (): {
        name: BuiltinPluginName;
        _args: [];
        affectedHooks: "done" | "make" | "environment" | "compile" | "emit" | "afterEmit" | "invalid" | "thisCompilation" | "afterDone" | "compilation" | "normalModuleFactory" | "contextModuleFactory" | "initialize" | "shouldEmit" | "infrastructureLog" | "beforeRun" | "run" | "assetEmitted" | "failed" | "shutdown" | "watchRun" | "watchClose" | "afterEnvironment" | "afterPlugins" | "afterResolvers" | "beforeCompile" | "afterCompile" | "finishMake" | "entryOption" | "additionalPass" | undefined;
        raw(compiler: Compiler_2): BuiltinPlugin;
        apply(compiler: Compiler_2): void;
    };
};

// @public (undocumented)
export type Filename = FilenameTemplate | ((pathData: PathData, assetInfo?: JsAssetInfo) => string);

// @public (undocumented)
export type FilenameTemplate = string;

// @public (undocumented)
interface FileSystemInfoEntry {
    // (undocumented)
    safeTime: number;
    // (undocumented)
    timestamp?: number;
}

// @public (undocumented)
interface FileSystemInfoEntry_2 {
    // (undocumented)
    safeTime: number;
    // (undocumented)
    timestamp?: number;
}

// @public
export type FilterItemTypes = RegExp | string | ((value: string) => boolean);

// @public
export type FilterTypes = FilterItemTypes | FilterItemTypes[];

// @public
export type GeneratorOptionsByModuleType = GeneratorOptionsByModuleTypeKnown | GeneratorOptionsByModuleTypeUnknown;

// @public (undocumented)
export type GeneratorOptionsByModuleTypeKnown = {
    asset?: AssetGeneratorOptions;
    "asset/inline"?: AssetInlineGeneratorOptions;
    "asset/resource"?: AssetResourceGeneratorOptions;
    css?: CssGeneratorOptions;
    "css/auto"?: CssAutoGeneratorOptions;
    "css/module"?: CssModuleGeneratorOptions;
};

// @public (undocumented)
export type GeneratorOptionsByModuleTypeUnknown = Record<string, Record<string, any>>;

// @public (undocumented)
type GetChildLogger = (name: string | (() => string)) => Logger;

// @public (undocumented)
export const getNormalizedRspackOptions: (config: RspackOptions) => RspackOptionsNormalized;

// @public (undocumented)
export const getRawOptions: (options: RspackOptionsNormalized, compiler: Compiler) => RawOptions;

// @public (undocumented)
export function getRawResolve(resolve: Resolve): RawOptions["resolve"];

// @public
export type GlobalObject = string;

// @public
interface GlobalPassOption {
    envs?: string[] | Record<string, string>;
    typeofs?: Record<string, string>;
    vars?: Record<string, string>;
}

// @public (undocumented)
type GotHandler<T = any> = (result: any | null, callback: (error: Error | null) => void) => void;

// @public (undocumented)
type GroupConfig<T, R = T> = {
    getKeys: (arg0: any) => string[] | undefined;
    createGroup: (key: string, arg1: (T | R)[], arg2: T[]) => R;
    getOptions?: ((key: string, arg1: T[]) => GroupOptions) | undefined;
};

// @public
type GroupOptions = {
    groupChildren?: boolean | undefined;
    force?: boolean | undefined;
    targetGroupCount?: number | undefined;
};

// @public (undocumented)
class Hash {
    	constructor();

    	digest(encoding?: string): string | Buffer;

    	update(data: string | Buffer, inputEncoding?: string): Hash;
}

// @public (undocumented)
class Hash_2 {
    digest(encoding?: string): string | Buffer;
    update(data: string | Buffer, inputEncoding?: string): this;
}

// @public (undocumented)
interface HashableObject {
    // (undocumented)
    updateHash(hash: Hash_2): void;
}

// @public (undocumented)
type HashConstructor = typeof Hash_2;

// @public
export type HashDigest = string;

// @public
export type HashDigestLength = number;

// @public
export type HashFunction = "md4" | "xxhash64";

// @public
export type HashSalt = string;

// @public (undocumented)
type Hooks = Readonly<{
    extract: HookMap<SyncBailHook<[Object, any, StatsFactoryContext], undefined>>;
    filter: HookMap<SyncBailHook<[any, StatsFactoryContext, number, number], undefined>>;
    filterSorted: HookMap<SyncBailHook<[any, StatsFactoryContext, number, number], undefined>>;
    groupResults: HookMap<SyncBailHook<[GroupConfig<any>[], StatsFactoryContext], undefined>>;
    filterResults: HookMap<SyncBailHook<[any, StatsFactoryContext, number, number], undefined>>;
    sort: HookMap<SyncBailHook<[
    ((arg1: any, arg2: any) => number)[],
    StatsFactoryContext
    ], undefined>>;
    sortResults: HookMap<SyncBailHook<[
    ((arg1: any, arg2: any) => number)[],
    StatsFactoryContext
    ], undefined>>;
    result: HookMap<SyncWaterfallHook<[any[], StatsFactoryContext]>>;
    merge: HookMap<SyncBailHook<[any[], StatsFactoryContext], undefined>>;
    getItemName: HookMap<SyncBailHook<[any, StatsFactoryContext], string | undefined>>;
    getItemFactory: HookMap<SyncBailHook<[any, StatsFactoryContext], undefined>>;
}>;

// @public (undocumented)
export class HotModuleReplacementPlugin extends RspackBuiltinPlugin {
    // (undocumented)
    name: BuiltinPluginName;
    // (undocumented)
    raw(compiler: Compiler): BuiltinPlugin;
}

// @public
export type HotUpdateChunkFilename = FilenameTemplate;

// @public
export type HotUpdateGlobal = string;

// @public
export type HotUpdateMainFilename = FilenameTemplate;

// @public (undocumented)
export const HtmlRspackPlugin: typeof HtmlRspackPluginImpl & {
    getHooks: (compilation: Compilation) => HtmlRspackPluginHooks;
    getCompilationHooks: (compilation: Compilation) => HtmlRspackPluginHooks;
    getCompilationOptions: (compilation: Compilation) => HtmlRspackPluginOptions | void;
    createHtmlTagObject: (tagName: string, attributes?: Record<string, string | boolean>, innerHTML?: string | undefined) => JsHtmlPluginTag;
    version: number;
};

// @public (undocumented)
type HtmlRspackPluginHooks = {
    beforeAssetTagGeneration: liteTapable.AsyncSeriesWaterfallHook<[
    JsBeforeAssetTagGenerationData & ExtraPluginHookData
    ]>;
    alterAssetTags: liteTapable.AsyncSeriesWaterfallHook<[JsAlterAssetTagsData]>;
    alterAssetTagGroups: liteTapable.AsyncSeriesWaterfallHook<[
    JsAlterAssetTagGroupsData & ExtraPluginHookData
    ]>;
    afterTemplateExecution: liteTapable.AsyncSeriesWaterfallHook<[
    JsAfterTemplateExecutionData & ExtraPluginHookData
    ]>;
    beforeEmit: liteTapable.AsyncSeriesWaterfallHook<[
    JsBeforeEmitData & ExtraPluginHookData
    ]>;
    afterEmit: liteTapable.AsyncSeriesWaterfallHook<[
    JsAfterEmitData & ExtraPluginHookData
    ]>;
};

// @public (undocumented)
const HtmlRspackPluginImpl: {
    new (c?: HtmlRspackPluginOptions | undefined): {
        name: BuiltinPluginName;
        _args: [c?: HtmlRspackPluginOptions | undefined];
        affectedHooks: "done" | "make" | "environment" | "compile" | "emit" | "afterEmit" | "invalid" | "thisCompilation" | "afterDone" | "compilation" | "normalModuleFactory" | "contextModuleFactory" | "initialize" | "shouldEmit" | "infrastructureLog" | "beforeRun" | "run" | "assetEmitted" | "failed" | "shutdown" | "watchRun" | "watchClose" | "afterEnvironment" | "afterPlugins" | "afterResolvers" | "beforeCompile" | "afterCompile" | "finishMake" | "entryOption" | "additionalPass" | undefined;
        raw(compiler: Compiler): BuiltinPlugin;
        apply(compiler: Compiler): void;
    };
};

// @public (undocumented)
export type HtmlRspackPluginOptions = {
    title?: string;
    filename?: string | ((entry: string) => string);
    template?: string;
    templateContent?: string | TemplateRenderFunction;
    templateParameters?: Record<string, string> | boolean | TemplateParamFunction;
    inject?: boolean | "head" | "body";
    publicPath?: string;
    base?: string | {
        href?: string;
        target?: "_self" | "_blank" | "_parent" | "_top";
    };
    scriptLoading?: "blocking" | "defer" | "module" | "systemjs-module";
    chunks?: string[];
    excludeChunks?: string[];
    chunksSortMode?: "auto" | "manual";
    sri?: "sha256" | "sha384" | "sha512";
    minify?: boolean;
    favicon?: string;
    meta?: Record<string, string | Record<string, string>>;
    hash?: boolean;
};

// @public (undocumented)
type IBigIntStats = IStatsBase<bigint> & {
    atimeNs: bigint;
    mtimeNs: bigint;
    ctimeNs: bigint;
    birthtimeNs: bigint;
};

// @public (undocumented)
interface IDirent {
    // (undocumented)
    isBlockDevice: () => boolean;
    // (undocumented)
    isCharacterDevice: () => boolean;
    // (undocumented)
    isDirectory: () => boolean;
    // (undocumented)
    isFIFO: () => boolean;
    // (undocumented)
    isFile: () => boolean;
    // (undocumented)
    isSocket: () => boolean;
    // (undocumented)
    isSymbolicLink: () => boolean;
    // (undocumented)
    name: string | Buffer;
}

// @public (undocumented)
export const IgnorePlugin: {
    new (options: IgnorePluginOptions): {
        name: BuiltinPluginName;
        _args: [options: IgnorePluginOptions];
        affectedHooks: "done" | "make" | "environment" | "compile" | "emit" | "afterEmit" | "invalid" | "thisCompilation" | "afterDone" | "compilation" | "normalModuleFactory" | "contextModuleFactory" | "initialize" | "shouldEmit" | "infrastructureLog" | "beforeRun" | "run" | "assetEmitted" | "failed" | "shutdown" | "watchRun" | "watchClose" | "afterEnvironment" | "afterPlugins" | "afterResolvers" | "beforeCompile" | "afterCompile" | "finishMake" | "entryOption" | "additionalPass" | undefined;
        raw(compiler: Compiler_2): BuiltinPlugin;
        apply(compiler: Compiler_2): void;
    };
};

// @public (undocumented)
export type IgnorePluginOptions = {
    resourceRegExp: NonNullable<RawIgnorePluginOptions["resourceRegExp"]>;
    contextRegExp?: RawIgnorePluginOptions["contextRegExp"];
} | {
    checkResource: NonNullable<RawIgnorePluginOptions["checkResource"]>;
};

// @public
export type IgnoreWarnings = (RegExp | ((error: Error, compilation: Compilation) => boolean))[];

// @public (undocumented)
export type IgnoreWarningsNormalized = ((warning: Error, compilation: Compilation) => boolean)[];

// @public
export type Iife = boolean;

// @public
export type ImportFunctionName = string;

// @public
export type ImportMetaName = string;

// @public (undocumented)
interface ImportModuleOptions {
    baseUri?: string;
    layer?: string;
    publicPath?: PublicPath;
}

// @public
export type Incremental = {
    make?: boolean;
    inferAsyncModules?: boolean;
    providedExports?: boolean;
    dependenciesDiagnostics?: boolean;
    sideEffects?: boolean;
    buildChunkGraph?: boolean;
    moduleIds?: boolean;
    chunkIds?: boolean;
    modulesHashes?: boolean;
    modulesCodegen?: boolean;
    modulesRuntimeRequirements?: boolean;
    chunksRuntimeRequirements?: boolean;
    chunksHashes?: boolean;
    chunksRender?: boolean;
    emitAssets?: boolean;
};

// @public
export type InfrastructureLogging = {
    appendOnly?: boolean;
    colors?: boolean;
    console?: Console;
    debug?: boolean | FilterTypes;
    level?: "none" | "error" | "warn" | "info" | "log" | "verbose";
    stream?: NodeJS.WritableStream;
};

// @public (undocumented)
type input<T extends ZodType<any, any, any>> = T["_input"];

// @public (undocumented)
type InputFileSystem = {
    readFile: ReadFile;
    readFileSync?: ReadFileSync;
    readlink: Readlink;
    readlinkSync?: ReadlinkSync;
    readdir: Readdir;
    readdirSync?: ReaddirSync;
    stat: Stat;
    statSync?: StatSync;
    lstat?: LStat;
    lstatSync?: LStatSync;
    realpath?: RealPath;
    realpathSync?: RealPathSync;
    readJson?: ReadJson;
    readJsonSync?: ReadJsonSync;
    purge?: Purge;
    join?: (path1: string, path2: string) => string;
    relative?: (from: string, to: string) => string;
    dirname?: (path: string) => string;
};

// @public (undocumented)
type IntermediateFileSystem = InputFileSystem & OutputFileSystem & IntermediateFileSystemExtras;

// @public (undocumented)
type IntermediateFileSystemExtras = {
    rename: (arg0: PathLike, arg1: PathLike, arg2: (arg0: null | NodeJS.ErrnoException) => void) => void;
    mkdirSync: MkdirSync;
    write: Write<Buffer>;
    open: Open;
    read: Read<Buffer>;
    close: (arg0: number, arg1: (arg0: null | NodeJS.ErrnoException) => void) => void;
};

// @public (undocumented)
type INVALID = {
    status: "aborted";
};

// @public (undocumented)
const INVALID: INVALID;

// @public (undocumented)
type IssueData = stripPath<ZodIssueOptionalMessage> & {
    path?: (string | number)[];
    fatal?: boolean;
};

// @public (undocumented)
type IStats = IStatsBase<number>;

// @public (undocumented)
type IStatsBase<T> = {
    isFile: () => boolean;
    isDirectory: () => boolean;
    isBlockDevice: () => boolean;
    isCharacterDevice: () => boolean;
    isSymbolicLink: () => boolean;
    isFIFO: () => boolean;
    isSocket: () => boolean;
    dev: T;
    ino: T;
    mode: T;
    nlink: T;
    uid: T;
    gid: T;
    rdev: T;
    size: T;
    blksize: T;
    blocks: T;
    atimeMs: T;
    mtimeMs: T;
    ctimeMs: T;
    birthtimeMs: T;
    atime: Date;
    mtime: Date;
    ctime: Date;
    birthtime: Date;
};

// @public (undocumented)
class ItemCacheFacade implements BaseCache {
    constructor(cache: Cache_2, name: string, etag: Etag | null);
    // (undocumented)
    _cache: Cache_2;
    // (undocumented)
    _etag: Etag | null;
    // (undocumented)
    get<T>(callback: CallbackCache<T>): void;
    // (undocumented)
    getPromise<T>(): Promise<T | undefined>;
    // (undocumented)
    _name: string;
    // (undocumented)
    provide<T>(computer: (callback: CallbackNormalErrorCache<T>) => void, callback: CallbackNormalErrorCache<T>): void;
    // (undocumented)
    providePromise<T>(computer: () => Promise<T> | T): Promise<T>;
    // (undocumented)
    store<T>(data: T, callback: CallbackCache<void>): void;
    // (undocumented)
    storePromise<T>(data: T): Promise<void>;
}

// @public (undocumented)
interface JavaScript {
    // (undocumented)
    EnableChunkLoadingPlugin: typeof EnableChunkLoadingPlugin;
    // (undocumented)
    JavascriptModulesPlugin: typeof JavascriptModulesPlugin;
}

// @public (undocumented)
export const javascript: JavaScript;

// @public (undocumented)
class JavascriptModulesPlugin extends RspackBuiltinPlugin {
    // (undocumented)
    affectedHooks: "compilation";
    // (undocumented)
    static getCompilationHooks(compilation: Compilation): CompilationHooks;
    // (undocumented)
    name: BuiltinPluginName;
    // (undocumented)
    raw(): BuiltinPlugin;
}

// @public (undocumented)
export type JavascriptParserOptions = {
    dynamicImportMode?: "eager" | "lazy" | "weak" | "lazy-once";
    dynamicImportPreload?: boolean | number;
    dynamicImportPrefetch?: boolean | number;
    dynamicImportFetchPriority?: "low" | "high" | "auto";
    importMeta?: boolean;
    url?: "relative" | boolean;
    exprContextCritical?: boolean;
    wrappedContextCritical?: boolean;
    wrappedContextRegExp?: RegExp;
    exportsPresence?: ExportsPresence;
    importExportsPresence?: ExportsPresence;
    reexportExportsPresence?: ExportsPresence;
    strictExportPresence?: boolean;
    worker?: string[] | boolean;
    overrideStrict?: "strict" | "non-strict";
    requireAsExpression?: boolean;
    requireDynamic?: boolean;
    requireResolve?: boolean;
    importDynamic?: boolean;
};

// @public (undocumented)
interface JscConfig {
    // (undocumented)
    assumptions?: Assumptions;
    // (undocumented)
    baseUrl?: string;
    experimental?: {
        optimizeHygiene?: boolean;
        keepImportAttributes?: boolean;
        emitAssertForImportAttributes?: boolean;
        cacheRoot?: string;
        plugins?: Array<[string, Record<string, any>]>;
        runPluginFirst?: boolean;
        disableBuiltinTransformsForInternalTesting?: boolean;
        emitIsolatedDts?: boolean;
        disableAllLints?: boolean;
        keepImportAssertions?: boolean;
    };
    externalHelpers?: boolean;
    keepClassNames?: boolean;
    // (undocumented)
    loose?: boolean;
    // (undocumented)
    minify?: JsMinifyOptions;
    parser?: ParserConfig;
    // (undocumented)
    paths?: {
        [from: string]: string[];
    };
    // (undocumented)
    preserveAllComments?: boolean;
    target?: JscTarget;
    // (undocumented)
    transform?: TransformConfig;
}

// @public (undocumented)
type JscTarget = "es3" | "es5" | "es2015" | "es2016" | "es2017" | "es2018" | "es2019" | "es2020" | "es2021" | "es2022" | "es2023" | "es2024" | "esnext";

// @public (undocumented)
interface JsFormatOptions {
    asciiOnly?: boolean;
    beautify?: boolean;
    braces?: boolean;
    comments?: false | "some" | "all";
    ecma?: TerserEcmaVersion;
    indentLevel?: number;
    indentStart?: number;
    // (undocumented)
    inlineScript?: number;
    keepNumbers?: number;
    keepQuotedProps?: boolean;
    maxLineLen?: number | false;
    preamble?: string;
    preserveAnnotations?: boolean;
    quoteKeys?: boolean;
    quoteStyle?: boolean;
    safari10?: boolean;
    semicolons?: boolean;
    shebang?: boolean;
    webkit?: boolean;
    wrapFuncArgs?: boolean;
    wrapIife?: boolean;
}

// @public
interface JsFormatOptions_2 {
    asciiOnly?: boolean;
    beautify?: boolean;
    braces?: boolean;
    comments?: false | "some" | "all";
    ecma?: TerserEcmaVersion_2;
    indentLevel?: number;
    indentStart?: number;
    inlineScript?: boolean;
    keepNumbers?: number;
    keepQuotedProps?: boolean;
    maxLineLen?: number | false;
    preamble?: string;
    preserveAnnotations?: boolean;
    quoteKeys?: boolean;
    quoteStyle?: boolean;
    safari10?: boolean;
    semicolons?: boolean;
    shebang?: boolean;
    webkit?: boolean;
    wrapFuncArgs?: boolean;
    wrapIife?: boolean;
}

// @public (undocumented)
interface JsMinifyOptions {
    // (undocumented)
    compress?: TerserCompressOptions_2 | boolean;
    // (undocumented)
    ecma?: TerserEcmaVersion_2;
    // (undocumented)
    format?: JsFormatOptions_2 & ToSnakeCaseProperties_2<JsFormatOptions_2>;
    // (undocumented)
    inlineSourcesContent?: boolean;
    // (undocumented)
    keep_classnames?: boolean;
    // (undocumented)
    keep_fnames?: boolean;
    // (undocumented)
    mangle?: TerserMangleOptions_2 | boolean;
    // (undocumented)
    module?: boolean | "unknown";
    // (undocumented)
    outputPath?: string;
    // (undocumented)
    safari10?: boolean;
    // (undocumented)
    sourceMap?: boolean;
    // (undocumented)
    toplevel?: boolean;
}

// @public (undocumented)
type JsonArray = JsonValue_2[];

// @public (undocumented)
type JsonObject = { [index: string]: JsonValue } & {
    	[index: string]:
    		| undefined
    		| null
    		| string
    		| number
    		| boolean
    		| JsonObject
    		| JsonValue[];
};

// @public (undocumented)
type JsonObject_2 = {
    [Key in string]: JsonValue_2;
} & {
    [Key in string]?: JsonValue_2 | undefined;
};

// @public (undocumented)
export type JsonParserOptions = {
    exportsDepth?: number;
};

// @public (undocumented)
type JsonPrimitive = string | number | boolean | null;

// @public (undocumented)
type JsonValue = null | string | number | boolean | JsonObject | JsonValue[];

// @public (undocumented)
type JsonValue_2 = JsonPrimitive | JsonObject_2 | JsonArray;

// @public (undocumented)
type KnownAssetInfo = {
    immutable?: boolean;
    minimized?: boolean;
    fullhash?: string | string[];
    chunkhash?: string | string[];
    contenthash?: string | string[];
    sourceFilename?: string;
    copied?: boolean;
    size?: number;
    development?: boolean;
    hotModuleReplacement?: boolean;
    javascriptModule?: boolean;
    related?: Record<string, string | string[]>;
};

// @public (undocumented)
interface KnownCreateStatsOptionsContext {
    // (undocumented)
    forToString?: boolean;
}

// @public (undocumented)
interface KnownNormalizedStatsOptions {
    // (undocumented)
    assets: boolean;
    // (undocumented)
    assetsSort: string;
    // (undocumented)
    assetsSpace: number;
    // (undocumented)
    cachedAssets: boolean;
    // (undocumented)
    cachedModules: boolean;
    // (undocumented)
    chunkGroupAuxiliary: boolean;
    // (undocumented)
    chunkGroupChildren: boolean;
    // (undocumented)
    chunkGroupMaxAssets: number;
    // (undocumented)
    chunkGroups: boolean;
    // (undocumented)
    chunkModules: boolean;
    // (undocumented)
    chunkModulesSort: string;
    // (undocumented)
    chunkModulesSpace: number;
    // (undocumented)
    chunkRelations: boolean;
    // (undocumented)
    chunks: boolean;
    // (undocumented)
    chunksSort: string;
    // (undocumented)
    context: string;
    // (undocumented)
    dependentModules: boolean;
    // (undocumented)
    depth: boolean;
    // (undocumented)
    entrypoints: boolean | "auto";
    // (undocumented)
    errors: boolean;
    // (undocumented)
    errorsCount: boolean;
    // (undocumented)
    excludeAssets: ((value: string, asset: StatsAsset) => boolean)[];
    // (undocumented)
    excludeModules: ((name: string, module: StatsModule, type: "module" | "chunk" | "root-of-chunk" | "nested") => boolean)[];
    // (undocumented)
    groupAssetsByEmitStatus: boolean;
    // (undocumented)
    groupAssetsByExtension: boolean;
    // (undocumented)
    groupAssetsByPath: boolean;
    // (undocumented)
    groupModulesByAttributes: boolean;
    // (undocumented)
    groupModulesByCacheStatus: boolean;
    // (undocumented)
    groupModulesByExtension: boolean;
    // (undocumented)
    groupModulesByLayer: boolean;
    // (undocumented)
    groupModulesByPath: boolean;
    // (undocumented)
    groupModulesByType: boolean;
    // (undocumented)
    hash: boolean;
    // (undocumented)
    ids: boolean;
    // (undocumented)
    logging: false | "none" | "error" | "warn" | "info" | "log" | "verbose";
    // (undocumented)
    loggingDebug: ((value: string) => boolean)[];
    // (undocumented)
    loggingTrace: boolean;
    // (undocumented)
    moduleAssets: boolean;
    // (undocumented)
    modules: boolean;
    // (undocumented)
    modulesSort: string;
    // (undocumented)
    modulesSpace: number;
    // (undocumented)
    nestedModules: boolean;
    // (undocumented)
    nestedModulesSort: string;
    // (undocumented)
    nestedModulesSpace: number;
    // (undocumented)
    optimizationBailout: boolean;
    // (undocumented)
    orphanModules: boolean;
    // (undocumented)
    providedExports: boolean;
    // (undocumented)
    reasons: boolean;
    // (undocumented)
    runtimeModules: boolean;
    // (undocumented)
    source: boolean;
    // (undocumented)
    usedExports: boolean;
    // (undocumented)
    warnings: boolean;
    // (undocumented)
    warningsCount: boolean;
    // (undocumented)
    warningsFilter: ((warning: StatsError, textValue: string) => boolean)[];
}

// @public (undocumented)
type KnownStatsAsset = {
    type: string;
    name: string;
    info: AssetInfo_2;
    size: number;
    emitted: boolean;
    cached: boolean;
    related?: StatsAsset[];
    chunkNames?: (string | number)[];
    chunkIdHints?: (string | number)[];
    chunks?: (string | null | undefined)[];
    auxiliaryChunkNames?: (string | number)[];
    auxiliaryChunks?: (string | null | undefined)[];
    auxiliaryChunkIdHints?: (string | number)[];
    filteredRelated?: number;
    isOverSizeLimit?: boolean;
};

// @public (undocumented)
type KnownStatsChunk = {
    type: string;
    rendered: boolean;
    initial: boolean;
    entry: boolean;
    reason?: string;
    size: number;
    sizes?: Record<string, number>;
    names?: string[];
    idHints?: string[];
    runtime?: string[];
    files?: string[];
    auxiliaryFiles?: string[];
    hash?: string;
    childrenByOrder?: Record<string, (string | number)[]>;
    id?: string | number;
    siblings?: (string | number)[];
    parents?: (string | number)[];
    children?: (string | number)[];
    modules?: StatsModule[];
    filteredModules?: number;
    origins?: StatsChunkOrigin[];
};

// @public (undocumented)
type KnownStatsChunkGroup = {
    name?: string;
    chunks?: (string | number)[];
    assets?: {
        name: string;
        size?: number;
    }[];
    filteredAssets?: number;
    assetsSize?: number;
    auxiliaryAssets?: {
        name: string;
        size?: number;
    }[];
    filteredAuxiliaryAssets?: number;
    auxiliaryAssetsSize?: number;
    children?: {
        preload?: StatsChunkGroup[];
        prefetch?: StatsChunkGroup[];
    };
    childAssets?: {
        preload?: string[];
        prefetch?: string[];
    };
    isOverSizeLimit?: boolean;
};

// @public (undocumented)
type KnownStatsChunkOrigin = {
    module: string;
    moduleIdentifier: string;
    moduleName: string;
    loc: string;
    request: string;
    moduleId?: string;
};

// @public (undocumented)
type KnownStatsCompilation = {
    version?: string;
    rspackVersion?: string;
    name?: string;
    hash?: string;
    time?: number;
    builtAt?: number;
    publicPath?: string;
    outputPath?: string;
    assets?: StatsAsset[];
    assetsByChunkName?: Record<string, string[]>;
    chunks?: StatsChunk[];
    modules?: StatsModule[];
    entrypoints?: Record<string, StatsChunkGroup>;
    namedChunkGroups?: Record<string, StatsChunkGroup>;
    errors?: StatsError[];
    errorsCount?: number;
    warnings?: StatsError[];
    warningsCount?: number;
    filteredModules?: number;
    children?: StatsCompilation[];
    logging?: Record<string, StatsLogging>;
};

// @public (undocumented)
type KnownStatsError = {
    message: string;
    chunkName?: string;
    chunkEntry?: boolean;
    chunkInitial?: boolean;
    file?: string;
    moduleIdentifier?: string;
    moduleName?: string;
    loc?: string;
    chunkId?: string | number;
    moduleId?: string | number;
    moduleTrace?: StatsModuleTraceItem[];
    details?: any;
    stack?: string;
};

// @public (undocumented)
type KnownStatsFactoryContext = {
    type: string;
    makePathsRelative?: ((arg0: string) => string) | undefined;
    compilation?: Compilation | undefined;
    cachedGetErrors?: ((arg0: Compilation) => JsStatsError[]) | undefined;
    cachedGetWarnings?: ((arg0: Compilation) => JsStatsWarning[]) | undefined;
    getStatsCompilation: (compilation: Compilation) => JsStatsCompilation;
    getInner: (compilation: Compilation) => JsStats;
};

// @public (undocumented)
type KnownStatsLogging = {
    entries: StatsLoggingEntry[];
    filteredEntries: number;
    debug: boolean;
};

// @public (undocumented)
type KnownStatsLoggingEntry = {
    type: string;
    message: string;
    trace?: string[] | undefined;
    children?: StatsLoggingEntry[] | undefined;
    args?: any[] | undefined;
    time?: number | undefined;
};

// @public (undocumented)
type KnownStatsModule = {
    type: string;
    moduleType: string;
    layer?: string;
    identifier?: string;
    name?: string;
    nameForCondition?: string;
    index?: number;
    index2?: number;
    preOrderIndex?: number;
    postOrderIndex?: number;
    size: number;
    sizes: Record<string, number>;
    cacheable?: boolean;
    built: boolean;
    codeGenerated: boolean;
    buildTimeExecuted: boolean;
    cached: boolean;
    optional?: boolean;
    orphan?: boolean;
    id?: string;
    issuerId?: string;
    chunks?: string[];
    assets?: string[];
    dependent?: boolean;
    issuer?: string;
    issuerName?: string;
    issuerPath?: StatsModuleIssuer[];
    failed?: boolean;
    errors?: number;
    warnings?: number;
    profile?: StatsProfile;
    reasons?: StatsModuleReason[];
    usedExports?: boolean | string[] | null;
    providedExports?: string[] | null;
    optimizationBailout?: string[] | null;
    depth?: number;
    modules?: StatsModule[];
    filteredModules?: number;
    source?: string | Buffer;
};

// @public (undocumented)
type KnownStatsModuleIssuer = {
    identifier?: string;
    name?: string;
    id?: string | number;
};

// @public (undocumented)
type KnownStatsModuleReason = {
    moduleIdentifier?: string;
    module?: string;
    moduleName?: string;
    resolvedModuleIdentifier?: string;
    resolvedModule?: string;
    type?: string;
    userRequest?: string;
    moduleId?: string | null;
    resolvedModuleId?: string | number | null;
};

// @public (undocumented)
type KnownStatsPrinterContext = {
    type?: string;
    compilation?: StatsCompilation;
    chunkGroup?: StatsChunkGroup;
    asset?: StatsAsset;
    module?: StatsModule;
    chunk?: StatsChunk;
    moduleReason?: StatsModuleReason;
    bold?: (str: string) => string;
    yellow?: (str: string) => string;
    red?: (str: string) => string;
    green?: (str: string) => string;
    magenta?: (str: string) => string;
    cyan?: (str: string) => string;
    formatFilename?: (file: string, oversize?: boolean) => string;
    formatModuleId?: (id: string) => string;
    formatChunkId?: ((id: string, direction?: "parent" | "child" | "sibling") => string) | undefined;
    formatSize?: (size: number) => string;
    formatDateTime?: (dateTime: number) => string;
    formatFlag?: (flag: string) => string;
    formatTime?: (time: number, boldQuantity?: boolean) => string;
    chunkGroupKind?: string;
};

// @public (undocumented)
type KnownStatsProfile = {
    total: number;
    resolving: number;
    building: number;
};

// @public
export type Layer = string | null;

// @public
export type LazyCompilationOptions = {
    backend?: {
        client?: string;
        listen?: number | ListenOptions;
        protocol?: "http" | "https";
    };
    imports?: boolean;
    entries?: boolean;
    test?: RegExp | ((module: any) => boolean);
};

// @public
export type Library = LibraryName | LibraryOptions | undefined;

// @public (undocumented)
export const library: Library_2;

// @public (undocumented)
interface Library_2 {
    // (undocumented)
    EnableLibraryPlugin: typeof EnableLibraryPlugin;
}

// @public (undocumented)
export type LibraryCustomUmdCommentObject = {
    amd?: string;
    commonjs?: string;
    commonjs2?: string;
    root?: string;
};

// @public (undocumented)
export type LibraryCustomUmdObject = {
    amd?: string;
    commonjs?: string;
    root?: string | string[];
};

// @public
export type LibraryExport = string | string[];

// @public
export type LibraryName = string | string[] | LibraryCustomUmdObject;

// @public
export type LibraryOptions = {
    amdContainer?: AmdContainer;
    auxiliaryComment?: AuxiliaryComment;
    export?: LibraryExport;
    name?: LibraryName;
    type: LibraryType;
    umdNamedDefine?: UmdNamedDefine;
};

// @public
export type LibraryType = string | "var" | "module" | "assign" | "assign-properties" | "this" | "window" | "self" | "global" | "commonjs" | "commonjs2" | "commonjs-module" | "commonjs-static" | "amd" | "amd-require" | "umd" | "umd2" | "jsonp" | "system";

// @public (undocumented)
export type LightningcssFeatureOptions = {
    nesting?: boolean;
    notSelectorList?: boolean;
    dirSelector?: boolean;
    langSelectorList?: boolean;
    isSelector?: boolean;
    textDecorationThicknessPercent?: boolean;
    mediaIntervalSyntax?: boolean;
    mediaRangeSyntax?: boolean;
    customMediaQueries?: boolean;
    clampFunction?: boolean;
    colorFunction?: boolean;
    oklabColors?: boolean;
    labColors?: boolean;
    p3Colors?: boolean;
    hexAlphaColors?: boolean;
    spaceSeparatedColorNotation?: boolean;
    fontFamilySystemUi?: boolean;
    doublePositionGradients?: boolean;
    vendorPrefixes?: boolean;
    logicalProperties?: boolean;
    selectors?: boolean;
    mediaQueries?: boolean;
    color?: boolean;
};

// @public (undocumented)
export type LightningcssLoaderOptions = {
    minify?: boolean;
    errorRecovery?: boolean;
    targets?: Targets | string[] | string;
    include?: LightningcssFeatureOptions;
    exclude?: LightningcssFeatureOptions;
    draft?: Drafts;
    drafts?: Drafts;
    nonStandard?: NonStandard;
    pseudoClasses?: PseudoClasses;
    unusedSymbols?: string[];
};

// @public (undocumented)
export const LightningCssMinimizerRspackPlugin: {
    new (options?: LightningCssMinimizerRspackPluginOptions | undefined): {
        name: BuiltinPluginName;
        _args: [options?: LightningCssMinimizerRspackPluginOptions | undefined];
        affectedHooks: "done" | "make" | "environment" | "compile" | "emit" | "afterEmit" | "invalid" | "thisCompilation" | "afterDone" | "compilation" | "normalModuleFactory" | "contextModuleFactory" | "initialize" | "shouldEmit" | "infrastructureLog" | "beforeRun" | "run" | "assetEmitted" | "failed" | "shutdown" | "watchRun" | "watchClose" | "afterEnvironment" | "afterPlugins" | "afterResolvers" | "beforeCompile" | "afterCompile" | "finishMake" | "entryOption" | "additionalPass" | undefined;
        raw(compiler: Compiler_2): BuiltinPlugin;
        apply(compiler: Compiler_2): void;
    };
};

// @public (undocumented)
export type LightningCssMinimizerRspackPluginOptions = {
    test?: AssetConditions;
    include?: AssetConditions;
    exclude?: AssetConditions;
    removeUnusedLocalIdents?: boolean;
    minimizerOptions?: {
        errorRecovery?: boolean;
        targets?: string[] | string;
        include?: LightningcssFeatureOptions;
        exclude?: LightningcssFeatureOptions;
        draft?: Drafts;
        drafts?: Drafts;
        nonStandard?: NonStandard;
        pseudoClasses?: PseudoClasses;
        unusedSymbols?: string[];
    };
};

// @public (undocumented)
type LimitChunkCountOptions = {
    chunkOverhead?: number;
    entryChunkMultiplicator?: number;
    maxChunks: number;
};

// @public (undocumented)
const LimitChunkCountPlugin: {
    new (options: LimitChunkCountOptions): {
        name: BuiltinPluginName;
        _args: [options: LimitChunkCountOptions];
        affectedHooks: "done" | "make" | "environment" | "compile" | "emit" | "afterEmit" | "invalid" | "thisCompilation" | "afterDone" | "compilation" | "normalModuleFactory" | "contextModuleFactory" | "initialize" | "shouldEmit" | "infrastructureLog" | "beforeRun" | "run" | "assetEmitted" | "failed" | "shutdown" | "watchRun" | "watchClose" | "afterEnvironment" | "afterPlugins" | "afterResolvers" | "beforeCompile" | "afterCompile" | "finishMake" | "entryOption" | "additionalPass" | undefined;
        raw(compiler: Compiler_2): BuiltinPlugin;
        apply(compiler: Compiler_2): void;
    };
};

// @public
type ListenOptions = {
    port?: number;
    host?: string;
    backlog?: number;
    path?: string;
    exclusive?: boolean;
    readableAll?: boolean;
    writableAll?: boolean;
    ipv6Only?: boolean;
};

// @public (undocumented)
export type Loader = Record<string, any>;

// @public (undocumented)
export interface LoaderContext<OptionsType = {}> {
    // @internal
    __internal__parseMeta: Record<string, string>;
    // (undocumented)
    addBuildDependency(file: string): void;
    // (undocumented)
    addContextDependency(context: string): void;
    // (undocumented)
    addDependency(file: string): void;
    // (undocumented)
    addMissingDependency(missing: string): void;
    // (undocumented)
    async(): LoaderContextCallback;
    // (undocumented)
    cacheable(cacheable?: boolean): void;
    // (undocumented)
    callback: LoaderContextCallback;
    // (undocumented)
    clearDependencies(): void;
    // (undocumented)
    _compilation: Compilation;
    // (undocumented)
    _compiler: Compiler;
    // (undocumented)
    context: string | null;
    // (undocumented)
    currentRequest: string;
    // (undocumented)
    data: unknown;
    // (undocumented)
    dependency(file: string): void;
    // (undocumented)
    emitError(error: Error): void;
    // (undocumented)
    emitFile(name: string, content: string | Buffer, sourceMap?: string, assetInfo?: JsAssetInfo): void;
    // (undocumented)
    emitWarning(warning: Error): void;
    experiments: LoaderExperiments;
    // (undocumented)
    fs: any;
    // (undocumented)
    getContextDependencies(): string[];
    // (undocumented)
    getDependencies(): string[];
    // (undocumented)
    getLogger(name: string): Logger;
    // (undocumented)
    getMissingDependencies(): string[];
    // (undocumented)
    getOptions(schema?: any): OptionsType;
    // (undocumented)
    getResolve(options: Resolve): ((context: string, request: string, callback: ResolveCallback) => void) | ((context: string, request: string) => Promise<string | false | undefined>);
    // (undocumented)
    hot?: boolean;
    importModule<T = any>(request: string, options: ImportModuleOptions | undefined, callback: (err?: null | Error, exports?: T) => any): void;
    // (undocumented)
    importModule<T = any>(request: string, options?: ImportModuleOptions): Promise<T>;
    // (undocumented)
    loaderIndex: number;
    loaders: LoaderObject[];
    // (undocumented)
    mode?: Mode;
    // (undocumented)
    _module: Module;
    // (undocumented)
    previousRequest: string;
    // (undocumented)
    query: string | OptionsType;
    // (undocumented)
    remainingRequest: string;
    // (undocumented)
    request: string;
    // (undocumented)
    resolve(context: string, request: string, callback: (arg0: null | Error, arg1?: string | false, arg2?: ResolveRequest) => void): void;
    // (undocumented)
    resource: string;
    // (undocumented)
    resourceFragment: string;
    // (undocumented)
    resourcePath: string;
    // (undocumented)
    resourceQuery: string;
    // (undocumented)
    rootContext: string;
    // (undocumented)
    sourceMap: boolean;
    // (undocumented)
    target?: Target;
    // (undocumented)
    utils: {
        absolutify: (context: string, request: string) => string;
        contextify: (context: string, request: string) => string;
        createHash: (algorithm?: string) => Hash_2;
    };
    // (undocumented)
    version: 2;
}

// @public (undocumented)
type LoaderContextCallback = (err?: Error | null, content?: string | Buffer, sourceMap?: string | SourceMap, additionalData?: AdditionalData) => void;

// @public (undocumented)
export type LoaderDefinition<OptionsType = {}, ContextAdditions = {}> = LoaderDefinitionFunction<OptionsType, ContextAdditions> & {
    raw?: false;
    pitch?: PitchLoaderDefinitionFunction;
};

// @public (undocumented)
export type LoaderDefinitionFunction<OptionsType = {}, ContextAdditions = {}> = (this: LoaderContext<OptionsType> & ContextAdditions, content: string, sourceMap?: string | SourceMap, additionalData?: AdditionalData) => string | void | Buffer | Promise<string | Buffer>;

// @public (undocumented)
interface LoaderExperiments {
    // (undocumented)
    emitDiagnostic(diagnostic: Diagnostic): void;
}

// @public (undocumented)
class LoaderObject {
    constructor(loaderItem: JsLoaderItem, compiler: Compiler);
    // (undocumented)
    static __from_binding(loaderItem: JsLoaderItem, compiler: Compiler): LoaderObject;
    // (undocumented)
    static __to_binding(loader: LoaderObject): JsLoaderItem;
    // (undocumented)
    get data(): any;
    set data(data: any);
    // (undocumented)
    fragment: string;
    // (undocumented)
    ident: string;
    // (undocumented)
    normal?: Function;
    // (undocumented)
    get normalExecuted(): boolean;
    set normalExecuted(value: boolean);
    // (undocumented)
    options?: string | object;
    // (undocumented)
    path: string;
    // (undocumented)
    pitch?: Function;
    // (undocumented)
    get pitchExecuted(): boolean;
    set pitchExecuted(value: boolean);
    // (undocumented)
    query: string;
    // (undocumented)
    raw?: boolean;
    // (undocumented)
    request: string;
    // (undocumented)
    shouldYield(): boolean;
    // (undocumented)
    type?: "module" | "commonjs";
}

// @public (undocumented)
export class LoaderOptionsPlugin {
    constructor(options?: LoaderOptionsPluginOptions);
    apply(compiler: Compiler): void;
    // (undocumented)
    options: LoaderOptionsPluginOptions;
}

// @public (undocumented)
type LoaderOptionsPluginOptions = MatchObject & {
    [key: string]: unknown;
};

// @public (undocumented)
export class LoaderTargetPlugin {
    constructor(target: Target);
    apply(compiler: Compiler): void;
    // (undocumented)
    readonly target: Target;
}

// @public (undocumented)
const LOG_SYMBOL: unique symbol;

// @public (undocumented)
export interface LogEntry {
    // (undocumented)
    args: any[];
    // (undocumented)
    time?: number;
    // (undocumented)
    trace?: string[];
    // (undocumented)
    type: string;
}

// @public (undocumented)
type LogFunction = (type: LogTypeEnum, args: any[]) => void;

// @public (undocumented)
class Logger {
    // (undocumented)
    [LOG_SYMBOL]: any;
    // (undocumented)
    [TIMERS_AGGREGATES_SYMBOL]: any;
    // (undocumented)
    [TIMERS_SYMBOL]: any;
    constructor(log: LogFunction, getChildLogger: GetChildLogger);
    // (undocumented)
    assert(assertion: any, ...args: any[]): void;
    // (undocumented)
    clear(): void;
    // (undocumented)
    debug(...args: string[]): void;
    // (undocumented)
    error(...args: any[]): void;
    // (undocumented)
    getChildLogger: GetChildLogger;
    // (undocumented)
    group(...args: any[]): void;
    // (undocumented)
    groupCollapsed(...args: any[]): void;
    // (undocumented)
    groupEnd(...args: any[]): void;
    // (undocumented)
    info(...args: any[]): void;
    // (undocumented)
    log(...args: any[]): void;
    // (undocumented)
    profile(label: any): void;
    // (undocumented)
    profileEnd(label: any): void;
    // (undocumented)
    status(...args: any[]): void;
    // (undocumented)
    time(label: any): void;
    // (undocumented)
    timeAggregate(label: any): void;
    // (undocumented)
    timeAggregateEnd(label: any): void;
    // (undocumented)
    timeEnd(label: any): void;
    // (undocumented)
    timeLog(label: any): void;
    // (undocumented)
    trace(): void;
    // (undocumented)
    warn(...args: any[]): void;
}

// @public
const LogType: Readonly<{
    error: "error";
    warn: "warn";
    info: "info";
    log: "log";
    debug: "debug";
    trace: "trace";
    group: "group";
    groupCollapsed: "groupCollapsed";
    groupEnd: "groupEnd";
    profile: "profile";
    profileEnd: "profileEnd";
    time: "time";
    clear: "clear";
    status: "status";
    cache: "cache";
}>;

// @public (undocumented)
type LogTypeEnum = (typeof LogType)[keyof typeof LogType];

// @public (undocumented)
type LStat = {
    (path: PathLike, callback: StatsCallback): void;
    (path: PathLike, options: (StatOptions & {
        bigint?: false;
    }) | undefined, callback: StatsCallback): void;
    (path: PathLike, options: StatOptions & {
        bigint: true;
    }, callback: BigIntStatsCallback): void;
    (path: PathLike, options: StatOptions | undefined, callback: StatsOrBigIntStatsCallback): void;
};

// @public (undocumented)
type LStatSync = {
    (path: PathLike, options?: undefined): IStats;
    (path: PathLike, options?: StatSyncOptions & {
        bigint?: false;
        throwIfNoEntry: false;
    }): IStats | undefined;
    (path: PathLike, options: StatSyncOptions & {
        bigint: true;
        throwIfNoEntry: false;
    }): IBigIntStats | undefined;
    (path: PathLike, options?: StatSyncOptions & {
        bigint?: false;
    }): IStats;
    (path: PathLike, options: StatSyncOptions & {
        bigint: true;
    }): IBigIntStats;
    (path: PathLike, options: StatSyncOptions & {
        bigint: boolean;
        throwIfNoEntry?: false;
    }): IStats | IBigIntStats;
    (path: PathLike, options?: StatSyncOptions): IStats | IBigIntStats | undefined;
};

// @public (undocumented)
type MakeDirectoryOptions = {
    recursive?: boolean;
    mode?: string | number;
};

// @public (undocumented)
type MakeReadonly<T> = T extends Map<infer K, infer V> ? ReadonlyMap<K, V> : T extends Set<infer V> ? ReadonlySet<V> : T extends [infer Head, ...infer Tail] ? readonly [Head, ...Tail] : T extends Array<infer V> ? ReadonlyArray<V> : T extends BuiltIn ? T : Readonly<T>;

// @public (undocumented)
type MapOptions = { columns?: boolean; module?: boolean };

// @public
type Matcher = string | RegExp | (string | RegExp)[];

// @public (undocumented)
interface MatchObject {
    // (undocumented)
    exclude?: Matcher;
    // (undocumented)
    include?: Matcher;
    // (undocumented)
    test?: Matcher;
}

// @public
const matchObject: (obj: MatchObject, str: string) => boolean;

// @public (undocumented)
const matchPart: (str: string, test: Matcher) => boolean;

// @public (undocumented)
type MkdirSync = (path: PathLike, options: MakeDirectoryOptions) => undefined | string;

// @public
export type Mode = "development" | "production" | "none";

// @public (undocumented)
export class Module {
    constructor(module: JsModule);
    // (undocumented)
    static __from_binding(binding: JsModule): Module;
    // (undocumented)
    static __to_binding(module: Module): JsModule;
    // (undocumented)
    readonly blocks: DependenciesBlock[];
    buildInfo: Record<string, any>;
    buildMeta: Record<string, any>;
    // (undocumented)
    readonly context?: string;
    // (undocumented)
    readonly dependencies: Dependency[];
    // (undocumented)
    readonly factoryMeta?: JsFactoryMeta;
    // (undocumented)
    identifier(): string;
    // (undocumented)
    readonly layer: null | string;
    // (undocumented)
    readonly modules: Module[] | undefined;
    // (undocumented)
    nameForCondition(): string | null;
    // (undocumented)
    originalSource(): Source | null;
    // (undocumented)
    readonly rawRequest?: string;
    // (undocumented)
    readonly request?: string;
    // (undocumented)
    readonly resource?: string;
    // (undocumented)
    size(type?: string): number;
    // (undocumented)
    readonly type: string;
    // (undocumented)
    userRequest?: string;
    // (undocumented)
    readonly useSourceMap: boolean;
}

// @public (undocumented)
type ModuleConfig = Es6Config | CommonJsConfig | UmdConfig | AmdConfig | NodeNextConfig | SystemjsConfig;

// @public (undocumented)
class ModuleFederationPlugin {
    constructor(_options: ModuleFederationPluginOptions);
    // (undocumented)
    apply(compiler: Compiler): void;
}

// @public (undocumented)
export interface ModuleFederationPluginOptions extends Omit<ModuleFederationPluginV1Options, "enhanced"> {
    // (undocumented)
    implementation?: string;
    // (undocumented)
    runtimePlugins?: RuntimePlugins;
    // (undocumented)
    shareStrategy?: "version-first" | "loaded-first";
}

// @public (undocumented)
class ModuleFederationPluginV1 {
    constructor(_options: ModuleFederationPluginV1Options);
    // (undocumented)
    apply(compiler: Compiler): void;
}

// @public (undocumented)
export interface ModuleFederationPluginV1Options {
    // (undocumented)
    enhanced?: boolean;
    // (undocumented)
    exposes?: Exposes;
    // (undocumented)
    filename?: string;
    // (undocumented)
    library?: LibraryOptions;
    // (undocumented)
    name: string;
    // (undocumented)
    remotes?: Remotes;
    // (undocumented)
    remoteType?: ExternalsType;
    // (undocumented)
    runtime?: EntryRuntime;
    // (undocumented)
    shared?: Shared;
    // (undocumented)
    shareScope?: string;
}

declare namespace ModuleFilenameHelpers {
    export {
        asRegExp,
        matchPart,
        MatchObject,
        matchObject
    }
}
export { ModuleFilenameHelpers }

// @public (undocumented)
type ModuleFilterItemTypes = RegExp | string | ((name: string, module: any, type: any) => boolean);

// @public (undocumented)
type ModuleFilterTypes = boolean | ModuleFilterItemTypes | ModuleFilterItemTypes[];

// @public (undocumented)
class ModuleGraph {
    // (undocumented)
    static __from_binding(binding: JsModuleGraph): ModuleGraph;
    // (undocumented)
    getConnection(dependency: Dependency): ModuleGraphConnection | null;
    // (undocumented)
    getExportsInfo(module: Module): ExportsInfo;
    // (undocumented)
    getIssuer(module: Module): Module | null;
    // (undocumented)
    getModule(dependency: Dependency): Module | null;
    // (undocumented)
    getOutgoingConnections(module: Module): ModuleGraphConnection[];
    // (undocumented)
    getResolvedModule(dependency: Dependency): Module | null;
}

// @public (undocumented)
class ModuleGraphConnection {
    // (undocumented)
    static __from_binding(binding: JsModuleGraphConnection): ModuleGraphConnection;
    // (undocumented)
    static __to_binding(data: ModuleGraphConnection): JsModuleGraphConnection;
    // (undocumented)
    readonly dependency: Dependency;
    // (undocumented)
    readonly module: Module | null;
}

// @public (undocumented)
export type ModuleOptions = {
    defaultRules?: RuleSetRules;
    rules?: RuleSetRules;
    parser?: ParserOptionsByModuleType;
    generator?: GeneratorOptionsByModuleType;
    noParse?: NoParseOption;
};

// @public (undocumented)
export interface ModuleOptionsNormalized {
    // (undocumented)
    defaultRules?: RuleSetRules;
    // (undocumented)
    generator: GeneratorOptionsByModuleType;
    // (undocumented)
    noParse?: NoParseOption;
    // (undocumented)
    parser: ParserOptionsByModuleType;
    // (undocumented)
    rules: RuleSetRules;
}

// @public (undocumented)
type ModuleReplacer = (createData: ResolveData) => void;

// @public (undocumented)
export class MultiCompiler {
    constructor(compilers: Compiler[] | Record<string, Compiler>, options?: MultiCompilerOptions);
    // (undocumented)
    close(callback: liteTapable.Callback<Error, void>): void;
    // (undocumented)
    compilers: Compiler[];
    // (undocumented)
    dependencies: WeakMap<Compiler, string[]>;
    // (undocumented)
    getInfrastructureLogger(name: string): Logger_2;
    // (undocumented)
    hooks: {
        done: liteTapable.SyncHook<MultiStats>;
        invalid: liteTapable.MultiHook<liteTapable.SyncHook<[string | null, number]>>;
        run: liteTapable.MultiHook<liteTapable.AsyncSeriesHook<[Compiler]>>;
        watchClose: liteTapable.SyncHook<[]>;
        watchRun: liteTapable.MultiHook<liteTapable.AsyncSeriesHook<[Compiler]>>;
        infrastructureLog: liteTapable.MultiHook<liteTapable.SyncBailHook<[string, string, any[]], true>>;
    };
    // (undocumented)
    get inputFileSystem(): InputFileSystem;
    set inputFileSystem(value: InputFileSystem);
    // (undocumented)
    get intermediateFileSystem(): IntermediateFileSystem;
    set intermediateFileSystem(value: IntermediateFileSystem);
    // (undocumented)
    get options(): RspackOptionsNormalized_2[] & MultiCompilerOptions;
    // (undocumented)
    _options: MultiCompilerOptions;
    // (undocumented)
    get outputFileSystem(): fs_2;
    set outputFileSystem(value: fs_2);
    // (undocumented)
    get outputPath(): string;
    // (undocumented)
    purgeInputFileSystem(): void;
    // (undocumented)
    run(callback: liteTapable.Callback<Error, MultiStats>): void;
    // (undocumented)
    running: boolean;
    // (undocumented)
    setDependencies(compiler: Compiler, dependencies: string[]): void;
    // (undocumented)
    validateDependencies(callback: liteTapable.Callback<Error, MultiStats>): boolean;
    // (undocumented)
    watch(watchOptions: WatchOptions, handler: liteTapable.Callback<Error, MultiStats>): MultiWatching;
    // (undocumented)
    get watchFileSystem(): WatchFileSystem;
    set watchFileSystem(value: WatchFileSystem);
}

// @public (undocumented)
export interface MultiCompilerOptions {
    parallelism?: number;
}

// @public (undocumented)
export type MultiRspackOptions = ReadonlyArray<RspackOptions> & MultiCompilerOptions;

// @public (undocumented)
export class MultiStats {
    constructor(stats: Stats[]);
    // (undocumented)
    hasErrors(): boolean;
    // (undocumented)
    get hash(): string;
    // (undocumented)
    hasWarnings(): boolean;
    // (undocumented)
    stats: Stats[];
    // (undocumented)
    toJson(options: any): StatsCompilation;
    // (undocumented)
    toString(options: any): string;
}

// @public (undocumented)
class MultiWatching {
    constructor(watchings: Watching[], compiler: MultiCompiler);
    // (undocumented)
    close(callback: Callback<Error, void>): void;
    // (undocumented)
    compiler: MultiCompiler;
    // (undocumented)
    invalidate(callback: Callback<Error, void>): void;
    // (undocumented)
    resume(): void;
    // (undocumented)
    suspend(): void;
    // (undocumented)
    watchings: Watching[];
}

// @public
export type Name = string;

// @public (undocumented)
export const node: Node_3;

// @public
type Node_2 = false | NodeOptions;
export { Node_2 as Node }

// @public (undocumented)
interface Node_3 {
    // (undocumented)
    NodeEnvironmentPlugin: typeof NodeEnvironmentPlugin;
    // (undocumented)
    NodeTargetPlugin: typeof NodeTargetPlugin;
    // (undocumented)
    NodeTemplatePlugin: typeof NodeTemplatePlugin;
}

// @public (undocumented)
class NodeEnvironmentPlugin {
    constructor(options: NodeEnvironmentPluginOptions);
    // (undocumented)
    apply(compiler: Compiler): void;
    // (undocumented)
    options: NodeEnvironmentPluginOptions;
}

// @public (undocumented)
interface NodeEnvironmentPluginOptions {
    // (undocumented)
    infrastructureLogging: InfrastructureLogging;
}

// @public (undocumented)
interface NodeNextConfig extends BaseModuleConfig {
    // (undocumented)
    type: "nodenext";
}

// @public
export type NodeOptions = {
    __dirname?: boolean | "warn-mock" | "mock" | "eval-only" | "node-module";
    __filename?: boolean | "warn-mock" | "mock" | "eval-only" | "node-module";
    global?: boolean | "warn";
};

// @public (undocumented)
const NodeTargetPlugin: {
    new (): {
        name: BuiltinPluginName;
        _args: [];
        affectedHooks: "done" | "make" | "environment" | "compile" | "emit" | "afterEmit" | "invalid" | "thisCompilation" | "afterDone" | "compilation" | "normalModuleFactory" | "contextModuleFactory" | "initialize" | "shouldEmit" | "infrastructureLog" | "beforeRun" | "run" | "assetEmitted" | "failed" | "shutdown" | "watchRun" | "watchClose" | "afterEnvironment" | "afterPlugins" | "afterResolvers" | "beforeCompile" | "afterCompile" | "finishMake" | "entryOption" | "additionalPass" | undefined;
        raw(compiler: Compiler_2): BuiltinPlugin;
        apply(compiler: Compiler_2): void;
    };
};

// @public (undocumented)
class NodeTemplatePlugin {
    constructor(_options?: NodeTemplatePluginOptions);
    // (undocumented)
    apply(compiler: Compiler): void;
}

// @public (undocumented)
type NodeTemplatePluginOptions = {
    asyncChunkLoading?: boolean;
};

// @public (undocumented)
export const NoEmitOnErrorsPlugin: {
    new (): {
        name: BuiltinPluginName;
        _args: [];
        affectedHooks: "done" | "make" | "environment" | "compile" | "emit" | "afterEmit" | "invalid" | "thisCompilation" | "afterDone" | "compilation" | "normalModuleFactory" | "contextModuleFactory" | "initialize" | "shouldEmit" | "infrastructureLog" | "beforeRun" | "run" | "assetEmitted" | "failed" | "shutdown" | "watchRun" | "watchClose" | "afterEnvironment" | "afterPlugins" | "afterResolvers" | "beforeCompile" | "afterCompile" | "finishMake" | "entryOption" | "additionalPass" | undefined;
        raw(compiler: Compiler_2): BuiltinPlugin;
        apply(compiler: Compiler_2): void;
    };
};

// @public (undocumented)
interface NonStandard {
    deepSelectorCombinator?: boolean;
}

// @public
export type NoParseOption = NoParseOptionSingle | NoParseOptionSingle[];

// @public (undocumented)
type NoParseOptionSingle = string | RegExp | ((request: string) => boolean);

// @public (undocumented)
type NormalizedStatsOptions = KnownNormalizedStatsOptions & Omit<StatsOptions, keyof KnownNormalizedStatsOptions> & Record<string, any>;

// @public (undocumented)
export class NormalModule {
    // (undocumented)
    static getCompilationHooks(compilation: Compilation): {
        loader: liteTapable.SyncHook<[LoaderContext, Module]>;
        readResourceForScheme: any;
        readResource: liteTapable.HookMap<liteTapable.AsyncSeriesBailHook<[LoaderContext], string | Buffer>>;
    };
}

// @public (undocumented)
type NormalModuleCreateData = binding.JsNormalModuleFactoryCreateModuleArgs & {
    settings: {};
};

// @public (undocumented)
export class NormalModuleFactory {
    constructor();
    // (undocumented)
    hooks: {
        resolveForScheme: liteTapable.HookMap<liteTapable.AsyncSeriesBailHook<[ResourceDataWithData], true | void>>;
        beforeResolve: liteTapable.AsyncSeriesBailHook<[ResolveData], false | void>;
        factorize: liteTapable.AsyncSeriesBailHook<[ResolveData], void>;
        resolve: liteTapable.AsyncSeriesBailHook<[ResolveData], void>;
        afterResolve: liteTapable.AsyncSeriesBailHook<[ResolveData], false | void>;
        createModule: liteTapable.AsyncSeriesBailHook<[
        NormalModuleCreateData,
            {}
        ], void>;
    };
}

// @public (undocumented)
export class NormalModuleReplacementPlugin {
    constructor(resourceRegExp: RegExp, newResource: string | ModuleReplacer);
    apply(compiler: Compiler): void;
    // (undocumented)
    readonly newResource: string | ModuleReplacer;
    // (undocumented)
    readonly resourceRegExp: RegExp;
}

// @public (undocumented)
type ObjectEncodingOptions = {
    encoding?: BufferEncoding | null;
};

// @public (undocumented)
namespace objectUtil {
    // (undocumented)
    type addQuestionMarks<T extends object, _O = any> = {
        [K in requiredKeys<T>]: T[K];
    } & {
        [K in optionalKeys<T>]?: T[K];
    } & {
        [k in keyof T]?: unknown;
    };
    // (undocumented)
    type extendShape<A extends object, B extends object> = {
        [K in keyof A as K extends keyof B ? never : K]: A[K];
    } & {
        [K in keyof B]: B[K];
    };
    // (undocumented)
    type flatten<T> = identity<{
        [k in keyof T]: T[k];
    }>;
    // (undocumented)
    type identity<T> = T;
    // (undocumented)
    type MergeShapes<U, V> = {
        [k in Exclude<keyof U, keyof V>]: U[k];
    } & V;
    // (undocumented)
    type noNever<T> = identity<{
        [k in noNeverKeys<T>]: k extends keyof T ? T[k] : never;
    }>;
    // (undocumented)
    type noNeverKeys<T> = {
        [k in keyof T]: [T[k]] extends [never] ? never : k;
    }[keyof T];
    // (undocumented)
    type optionalKeys<T extends object> = {
        [k in keyof T]: undefined extends T[k] ? k : never;
    }[keyof T];
    const // (undocumented)
    mergeShapes: <U, T>(first: U, second: T) => T & U;
    // (undocumented)
    type requiredKeys<T extends object> = {
        [k in keyof T]: undefined extends T[k] ? never : k;
    }[keyof T];
        {  };
}

// @public (undocumented)
type OK<T> = {
    status: "valid";
    value: T;
};

// @public (undocumented)
const OK: <T>(value: T) => OK<T>;

// @public (undocumented)
type Open = (file: PathLike, flags: undefined | string | number, callback: (arg0: null | NodeJS.ErrnoException, arg1?: number) => void) => void;

// @public (undocumented)
export type Optimization = {
    moduleIds?: "named" | "natural" | "deterministic";
    chunkIds?: "natural" | "named" | "deterministic" | "size" | "total-size";
    minimize?: boolean;
    minimizer?: Array<"..." | Plugin_2>;
    mergeDuplicateChunks?: boolean;
    splitChunks?: false | OptimizationSplitChunksOptions;
    runtimeChunk?: OptimizationRuntimeChunk;
    removeAvailableModules?: boolean;
    removeEmptyChunks?: boolean;
    realContentHash?: boolean;
    sideEffects?: "flag" | boolean;
    providedExports?: boolean;
    concatenateModules?: boolean;
    innerGraph?: boolean;
    usedExports?: "global" | boolean;
    mangleExports?: "size" | "deterministic" | boolean;
    nodeEnv?: string | false;
    emitOnErrors?: boolean;
    avoidEntryIife?: boolean;
};

// @public
export type OptimizationRuntimeChunk = boolean | "single" | "multiple" | {
    name?: string | ((value: {
        name: string;
    }) => string);
};

// @public (undocumented)
export type OptimizationRuntimeChunkNormalized = false | {
    name: string | ((entrypoint: {
        name: string;
    }) => string);
};

// @public
export type OptimizationSplitChunksCacheGroup = {
    test?: string | RegExp | ((module: Module) => unknown);
    priority?: number;
    enforce?: boolean;
    filename?: Filename;
    reuseExistingChunk?: boolean;
    type?: string | RegExp;
    idHint?: string;
} & SharedOptimizationSplitChunksCacheGroup;

// @public (undocumented)
type OptimizationSplitChunksChunks = "initial" | "async" | "all" | RegExp | ((chunk: Chunk) => boolean);

// @public (undocumented)
type OptimizationSplitChunksName = string | false | OptimizationSplitChunksNameFunction;

// @public (undocumented)
export type OptimizationSplitChunksNameFunction = (module?: Module) => unknown;

// @public
export type OptimizationSplitChunksOptions = {
    cacheGroups?: Record<string, false | OptimizationSplitChunksCacheGroup>;
    fallbackCacheGroup?: {
        chunks?: OptimizationSplitChunksChunks;
        minSize?: number;
        maxSize?: number;
        maxAsyncSize?: number;
        maxInitialSize?: number;
        automaticNameDelimiter?: string;
    };
    hidePathInfo?: boolean;
} & SharedOptimizationSplitChunksCacheGroup;

// @public (undocumented)
type OptimizationSplitChunksSizes = number | Record<string, number>;

// @public (undocumented)
interface Optimize {
    // (undocumented)
    LimitChunkCountPlugin: typeof LimitChunkCountPlugin;
    // (undocumented)
    RuntimeChunkPlugin: typeof RuntimeChunkPlugin;
    // (undocumented)
    SplitChunksPlugin: typeof SplitChunksPlugin;
}

// @public (undocumented)
export const optimize: Optimize;

// @public (undocumented)
interface OptimizerConfig {
    // (undocumented)
    globals?: GlobalPassOption;
    // (undocumented)
    jsonify?: {
        minCost: number;
    };
    // (undocumented)
    simplify?: boolean;
}

// @public
const OriginEntryPlugin: {
    new (context: string, entry: string, options?: string | EntryOptions | undefined): {
        name: BuiltinPluginName;
        _args: [context: string, entry: string, options?: string | EntryOptions | undefined];
        affectedHooks: "done" | "make" | "environment" | "compile" | "emit" | "afterEmit" | "invalid" | "thisCompilation" | "afterDone" | "compilation" | "normalModuleFactory" | "contextModuleFactory" | "initialize" | "shouldEmit" | "infrastructureLog" | "beforeRun" | "run" | "assetEmitted" | "failed" | "shutdown" | "watchRun" | "watchClose" | "afterEnvironment" | "afterPlugins" | "afterResolvers" | "beforeCompile" | "afterCompile" | "finishMake" | "entryOption" | "additionalPass" | undefined;
        raw(compiler: Compiler_2): BuiltinPlugin;
        apply(compiler: Compiler_2): void;
    };
};

// @public (undocumented)
export type Output = {
    path?: Path;
    pathinfo?: Pathinfo;
    clean?: Clean;
    publicPath?: PublicPath;
    filename?: Filename;
    chunkFilename?: ChunkFilename;
    crossOriginLoading?: CrossOriginLoading;
    cssFilename?: CssFilename;
    cssHeadDataCompression?: boolean;
    cssChunkFilename?: CssChunkFilename;
    hotUpdateMainFilename?: HotUpdateMainFilename;
    hotUpdateChunkFilename?: HotUpdateChunkFilename;
    hotUpdateGlobal?: HotUpdateGlobal;
    assetModuleFilename?: AssetModuleFilename;
    uniqueName?: UniqueName;
    chunkLoadingGlobal?: ChunkLoadingGlobal;
    enabledLibraryTypes?: EnabledLibraryTypes;
    library?: Library;
    libraryExport?: LibraryExport;
    libraryTarget?: LibraryType;
    umdNamedDefine?: UmdNamedDefine;
    auxiliaryComment?: AuxiliaryComment;
    module?: OutputModule;
    strictModuleExceptionHandling?: StrictModuleExceptionHandling;
    strictModuleErrorHandling?: StrictModuleErrorHandling;
    globalObject?: GlobalObject;
    importFunctionName?: ImportFunctionName;
    importMetaName?: ImportMetaName;
    iife?: Iife;
    wasmLoading?: WasmLoading;
    enabledWasmLoadingTypes?: EnabledWasmLoadingTypes;
    webassemblyModuleFilename?: WebassemblyModuleFilename;
    chunkFormat?: ChunkFormat;
    chunkLoading?: ChunkLoading;
    enabledChunkLoadingTypes?: EnabledChunkLoadingTypes;
    trustedTypes?: true | string | TrustedTypes;
    sourceMapFilename?: SourceMapFilename;
    hashDigest?: HashDigest;
    hashDigestLength?: HashDigestLength;
    hashFunction?: HashFunction;
    hashSalt?: HashSalt;
    asyncChunks?: AsyncChunks;
    workerChunkLoading?: ChunkLoading;
    workerWasmLoading?: WasmLoading;
    workerPublicPath?: WorkerPublicPath;
    scriptType?: ScriptType;
    devtoolNamespace?: DevtoolNamespace;
    devtoolModuleFilenameTemplate?: DevtoolModuleFilenameTemplate;
    devtoolFallbackModuleFilenameTemplate?: DevtoolFallbackModuleFilenameTemplate;
    chunkLoadTimeout?: number;
    charset?: boolean;
    environment?: Environment;
    compareBeforeEmit?: boolean;
};

// @public (undocumented)
type output<T extends ZodType<any, any, any>> = T["_output"];

// @public (undocumented)
export interface OutputFileSystem {
    // (undocumented)
    dirname?: (arg0: string) => string;
    // (undocumented)
    join?: (arg0: string, arg1: string) => string;
    // (undocumented)
    lstat?: (arg0: string, arg1: (arg0?: null | NodeJS.ErrnoException, arg1?: IStats) => void) => void;
    // (undocumented)
    mkdir: (arg0: string, arg1: (arg0?: null | NodeJS.ErrnoException) => void) => void;
    // (undocumented)
    readdir: (arg0: string, arg1: (arg0?: null | NodeJS.ErrnoException, arg1?: (string | Buffer)[] | IDirent[]) => void) => void;
    // (undocumented)
    readFile: (arg0: string, arg1: (arg0?: null | NodeJS.ErrnoException, arg1?: string | Buffer) => void) => void;
    // (undocumented)
    relative?: (arg0: string, arg1: string) => string;
    // (undocumented)
    rmdir: (arg0: string, arg1: (arg0?: null | NodeJS.ErrnoException) => void) => void;
    // (undocumented)
    stat: (arg0: string, arg1: (arg0?: null | NodeJS.ErrnoException, arg1?: IStats) => void) => void;
    // (undocumented)
    unlink: (arg0: string, arg1: (arg0?: null | NodeJS.ErrnoException) => void) => void;
    // (undocumented)
    writeFile: (arg0: string | number, arg1: string | Buffer, arg2: (arg0?: null | NodeJS.ErrnoException) => void) => void;
}

// @public
export type OutputModule = boolean;

// @public (undocumented)
export interface OutputNormalized {
    // (undocumented)
    assetModuleFilename?: AssetModuleFilename;
    // (undocumented)
    asyncChunks?: boolean;
    // (undocumented)
    charset?: boolean;
    // (undocumented)
    chunkFilename?: ChunkFilename;
    // (undocumented)
    chunkFormat?: string | false;
    // (undocumented)
    chunkLoading?: string | false;
    // (undocumented)
    chunkLoadingGlobal?: ChunkLoadingGlobal;
    // (undocumented)
    chunkLoadTimeout?: number;
    // (undocumented)
    clean?: Clean;
    // (undocumented)
    compareBeforeEmit?: boolean;
    // (undocumented)
    crossOriginLoading?: CrossOriginLoading;
    // (undocumented)
    cssChunkFilename?: CssChunkFilename;
    // (undocumented)
    cssFilename?: CssFilename;
    // (undocumented)
    devtoolFallbackModuleFilenameTemplate?: DevtoolFallbackModuleFilenameTemplate;
    // (undocumented)
    devtoolModuleFilenameTemplate?: DevtoolModuleFilenameTemplate;
    // (undocumented)
    devtoolNamespace?: DevtoolNamespace;
    // (undocumented)
    enabledChunkLoadingTypes?: string[];
    // (undocumented)
    enabledLibraryTypes?: EnabledLibraryTypes;
    // (undocumented)
    enabledWasmLoadingTypes?: EnabledWasmLoadingTypes;
    // (undocumented)
    environment?: Environment;
    // (undocumented)
    filename?: Filename;
    // (undocumented)
    globalObject?: GlobalObject;
    // (undocumented)
    hashDigest?: HashDigest;
    // (undocumented)
    hashDigestLength?: HashDigestLength;
    // (undocumented)
    hashFunction?: HashFunction;
    // (undocumented)
    hashSalt?: HashSalt;
    // (undocumented)
    hotUpdateChunkFilename?: HotUpdateChunkFilename;
    // (undocumented)
    hotUpdateGlobal?: HotUpdateGlobal;
    // (undocumented)
    hotUpdateMainFilename?: HotUpdateMainFilename;
    // (undocumented)
    iife?: Iife;
    // (undocumented)
    importFunctionName?: ImportFunctionName;
    // (undocumented)
    importMetaName?: ImportMetaName;
    // (undocumented)
    library?: LibraryOptions;
    // (undocumented)
    module?: OutputModule;
    // (undocumented)
    path?: Path;
    // (undocumented)
    pathinfo?: boolean | "verbose";
    // (undocumented)
    publicPath?: PublicPath;
    // (undocumented)
    scriptType?: ScriptType;
    // (undocumented)
    sourceMapFilename?: SourceMapFilename;
    // (undocumented)
    strictModuleErrorHandling?: StrictModuleErrorHandling;
    // (undocumented)
    trustedTypes?: TrustedTypes;
    // (undocumented)
    uniqueName?: UniqueName;
    // (undocumented)
    wasmLoading?: WasmLoading;
    // (undocumented)
    webassemblyModuleFilename?: WebassemblyModuleFilename;
    // (undocumented)
    workerChunkLoading?: ChunkLoading;
    // (undocumented)
    workerPublicPath?: WorkerPublicPath;
    // (undocumented)
    workerWasmLoading?: WasmLoading;
}

// @public (undocumented)
interface ParseContext {
    // (undocumented)
    readonly common: {
        readonly issues: ZodIssue[];
        readonly contextualErrorMap?: ZodErrorMap;
        readonly async: boolean;
    };
    // (undocumented)
    readonly data: any;
    // (undocumented)
    readonly parent: ParseContext | null;
    // (undocumented)
    readonly parsedType: ZodParsedType;
    // (undocumented)
    readonly path: ParsePath;
    // (undocumented)
    readonly schemaErrorMap?: ZodErrorMap;
}

// @public (undocumented)
interface ParsedIdentifier {
    	// (undocumented)
    directory: boolean;
    	// (undocumented)
    file: boolean;
    	// (undocumented)
    fragment: string;
    	// (undocumented)
    internal: boolean;
    	// (undocumented)
    module: boolean;
    	// (undocumented)
    query: string;
    	// (undocumented)
    request: string;
}

// @public (undocumented)
type ParseInput = {
    data: any;
    path: (string | number)[];
    parent: ParseContext;
};

// @public (undocumented)
type ParseParams = {
    path: (string | number)[];
    errorMap: ZodErrorMap;
    async: boolean;
};

// @public (undocumented)
type ParsePath = ParsePathComponent[];

// @public (undocumented)
type ParsePathComponent = string | number;

// @public (undocumented)
type ParserConfig = TsParserConfig | EsParserConfig;

// @public (undocumented)
type ParseReturnType<T> = SyncParseReturnType<T> | AsyncParseReturnType<T>;

// @public
export type ParserOptionsByModuleType = ParserOptionsByModuleTypeKnown | ParserOptionsByModuleTypeUnknown;

// @public
export type ParserOptionsByModuleTypeKnown = {
    asset?: AssetParserOptions;
    css?: CssParserOptions;
    "css/auto"?: CssAutoParserOptions;
    "css/module"?: CssModuleParserOptions;
    javascript?: JavascriptParserOptions;
    "javascript/auto"?: JavascriptParserOptions;
    "javascript/dynamic"?: JavascriptParserOptions;
    "javascript/esm"?: JavascriptParserOptions;
    json?: JsonParserOptions;
};

// @public
export type ParserOptionsByModuleTypeUnknown = {
    [x: string]: Record<string, any>;
};

// @public (undocumented)
class ParseStatus {
    // (undocumented)
    abort(): void;
    // (undocumented)
    dirty(): void;
    // (undocumented)
    static mergeArray(status: ParseStatus, results: SyncParseReturnType<any>[]): SyncParseReturnType;
    // (undocumented)
    static mergeObjectAsync(status: ParseStatus, pairs: {
        key: ParseReturnType<any>;
        value: ParseReturnType<any>;
    }[]): Promise<SyncParseReturnType<any>>;
    // (undocumented)
    static mergeObjectSync(status: ParseStatus, pairs: {
        key: SyncParseReturnType<any>;
        value: SyncParseReturnType<any>;
        alwaysSet?: boolean;
    }[]): SyncParseReturnType;
    // (undocumented)
    value: "aborted" | "dirty" | "valid";
}

// @public
export type Path = string;

// @public (undocumented)
type PathData = {
    filename?: string;
    hash?: string;
    contentHash?: string;
    runtime?: string;
    url?: string;
    id?: string;
    chunk?: Chunk | PathDataChunkLike;
    contentHashType?: string;
};

// @public (undocumented)
type PathDataChunkLike = {
    id?: string;
    name?: string;
    hash?: string;
    contentHash?: Record<string, string>;
};

// @public
export type Pathinfo = boolean | "verbose";

// @public (undocumented)
type PathLike = string | Buffer | URL;

// @public (undocumented)
type PathOrFileDescriptor = PathLike | number;

// @public
type Performance_2 = false | {
    assetFilter?: (assetFilename: string) => boolean;
    hints?: false | "warning" | "error";
    maxAssetSize?: number;
    maxEntrypointSize?: number;
};
export { Performance_2 as Performance }

// @public (undocumented)
type PitchLoaderDefinitionFunction<OptionsType = {}, ContextAdditions = {}> = (this: LoaderContext<OptionsType> & ContextAdditions, remainingRequest: string, previousRequest: string, data: object) => string | void | Buffer | Promise<string | Buffer>;

// @public (undocumented)
type Plugin_2 = RspackPluginInstance | RspackPluginFunction | WebpackPluginInstance | WebpackPluginFunction | Falsy;
export { Plugin_2 as Plugin }

// @public (undocumented)
type PluginImportConfig = {
    libraryName: string;
    libraryDirectory?: string;
    customName?: string;
    customStyleName?: string;
    style?: string | boolean;
    styleLibraryDirectory?: string;
    camelToDashComponentName?: boolean;
    transformToDefaultImport?: boolean;
    ignoreEsComponent?: string[];
    ignoreStyleComponent?: string[];
};

// @public (undocumented)
type PluginImportOptions = PluginImportConfig[] | undefined;

// @public (undocumented)
export type Plugins = Plugin_2[];

// @public (undocumented)
type PreprocessEffect<T> = {
    type: "preprocess";
    transform: (arg: T, ctx: RefinementCtx) => any;
};

// @public (undocumented)
type Primitive = string | number | symbol | bigint | boolean | null | undefined;

// @public (undocumented)
type PrintedElement = {
    element: string;
    content: string;
};

// @public
export type Profile = boolean;

// @public (undocumented)
export const ProgressPlugin: {
    new (progress?: ProgressPluginArgument): {
        name: BuiltinPluginName;
        _args: [progress?: ProgressPluginArgument];
        affectedHooks: "done" | "make" | "environment" | "compile" | "emit" | "afterEmit" | "invalid" | "thisCompilation" | "afterDone" | "compilation" | "normalModuleFactory" | "contextModuleFactory" | "initialize" | "shouldEmit" | "infrastructureLog" | "beforeRun" | "run" | "assetEmitted" | "failed" | "shutdown" | "watchRun" | "watchClose" | "afterEnvironment" | "afterPlugins" | "afterResolvers" | "beforeCompile" | "afterCompile" | "finishMake" | "entryOption" | "additionalPass" | undefined;
        raw(compiler: Compiler_2): BuiltinPlugin;
        apply(compiler: Compiler_2): void;
    };
};

// @public (undocumented)
export type ProgressPluginArgument = Partial<Omit<RawProgressPluginOptions, "handler">> | ((percentage: number, msg: string, ...args: string[]) => void) | undefined;

// @public (undocumented)
export const ProvidePlugin: {
    new (provide: ProvidePluginOptions): {
        name: BuiltinPluginName;
        _args: [provide: ProvidePluginOptions];
        affectedHooks: "done" | "make" | "environment" | "compile" | "emit" | "afterEmit" | "invalid" | "thisCompilation" | "afterDone" | "compilation" | "normalModuleFactory" | "contextModuleFactory" | "initialize" | "shouldEmit" | "infrastructureLog" | "beforeRun" | "run" | "assetEmitted" | "failed" | "shutdown" | "watchRun" | "watchClose" | "afterEnvironment" | "afterPlugins" | "afterResolvers" | "beforeCompile" | "afterCompile" | "finishMake" | "entryOption" | "additionalPass" | undefined;
        raw(compiler: Compiler_2): BuiltinPlugin;
        apply(compiler: Compiler_2): void;
    };
};

// @public (undocumented)
export type ProvidePluginOptions = Record<string, string | string[]>;

// @public (undocumented)
export type Provides<Enhanced extends boolean> = (ProvidesItem | ProvidesObject<Enhanced>)[] | ProvidesObject<Enhanced>;

// @public (undocumented)
export type ProvidesConfig<Enhanced extends boolean> = Enhanced extends true ? ProvidesEnhancedConfig : ProvidesV1Config;

// @public (undocumented)
type ProvidesEnhancedConfig = ProvidesV1Config & ProvidesEnhancedExtraConfig;

// @public (undocumented)
type ProvidesEnhancedExtraConfig = {
    singleton?: boolean;
    strictVersion?: boolean;
    requiredVersion?: false | string;
};

// @public (undocumented)
class ProvideSharedPlugin<Enhanced extends boolean = false> extends RspackBuiltinPlugin {
    constructor(options: ProvideSharedPluginOptions<Enhanced>);
    // (undocumented)
    _enhanced?: Enhanced;
    // (undocumented)
    name: BuiltinPluginName;
    // (undocumented)
    _provides: [string, Omit<RawProvideOptions, "key">][];
    // (undocumented)
    raw(compiler: Compiler): BuiltinPlugin;
}

// @public (undocumented)
export type ProvideSharedPluginOptions<Enhanced extends boolean = false> = {
    provides: Provides<Enhanced>;
    shareScope?: string;
    enhanced?: Enhanced;
};

// @public (undocumented)
export type ProvidesItem = string;

// @public (undocumented)
export type ProvidesObject<Enhanced extends boolean> = {
    [k: string]: ProvidesConfig<Enhanced> | ProvidesItem;
};

// @public (undocumented)
type ProvidesV1Config = {
    eager?: boolean;
    shareKey: string;
    shareScope?: string;
    version?: false | string;
};

// @public (undocumented)
interface PseudoClasses {
    // (undocumented)
    active?: string;
    // (undocumented)
    focus?: string;
    // (undocumented)
    focusVisible?: string;
    // (undocumented)
    focusWithin?: string;
    // (undocumented)
    hover?: string;
}

// @public
export type PublicPath = "auto" | Filename;

// @public (undocumented)
type Purge = (files?: string | string[] | Set<string>) => void;

// @public (undocumented)
type RawCreateParams = {
    errorMap?: ZodErrorMap;
    invalid_type_error?: string;
    required_error?: string;
    message?: string;
    description?: string;
} | undefined;

// @public (undocumented)
type RawSourceMap = {
    	version: number;
    	sources: string[];
    	names: string[];
    	sourceRoot?: string;
    	sourcesContent?: string[];
    	mappings: string;
    	file: string;
};

// @public (undocumented)
interface ReactConfig {
    development?: boolean;
    importSource?: string;
    pragma?: string;
    pragmaFrag?: string;
    refresh?: boolean;
    runtime?: "automatic" | "classic";
    throwIfNamespace?: boolean;
    // @deprecated
    useBuiltins?: boolean;
}

// @public (undocumented)
type Read<TBuffer extends ArrayBufferView = Buffer> = (fd: number, options: ReadAsyncOptions<TBuffer>, callback: (err: null | NodeJS.ErrnoException, bytesRead: number, buffer: TBuffer) => void) => void;

// @public (undocumented)
type ReadAsyncOptions<TBuffer extends ArrayBufferView = Buffer> = {
    offset?: number;
    length?: number;
    position?: null | number | bigint;
    buffer?: TBuffer;
};

// @public (undocumented)
type Readdir = {
    (path: PathLike, options: {
        encoding: BufferEncoding | null;
        withFileTypes?: false;
        recursive?: boolean;
    } | BufferEncoding | null | undefined, callback: ReaddirStringCallback): void;
    (path: PathLike, options: {
        encoding: "buffer";
        withFileTypes?: false;
        recursive?: boolean;
    } | "buffer", callback: ReaddirBufferCallback): void;
    (path: PathLike, callback: ReaddirStringCallback): void;
    (path: PathLike, options: (ObjectEncodingOptions & {
        withFileTypes: true;
        recursive?: boolean;
    }) | BufferEncoding | null | undefined, callback: ReaddirStringOrBufferCallback): void;
    (path: PathLike, options: ObjectEncodingOptions & {
        withFileTypes: true;
        recursive?: boolean;
    }, callback: ReaddirDirentCallback): void;
};

// @public (undocumented)
type ReaddirBufferCallback = (err: NodeJS.ErrnoException | null, files?: Buffer[]) => void;

// @public (undocumented)
type ReaddirDirentCallback = (err: NodeJS.ErrnoException | null, files?: IDirent[]) => void;

// @public (undocumented)
type ReaddirStringCallback = (err: NodeJS.ErrnoException | null, files?: string[]) => void;

// @public (undocumented)
type ReaddirStringOrBufferCallback = (err: NodeJS.ErrnoException | null, files?: string[] | Buffer[]) => void;

// @public (undocumented)
type ReaddirSync = {
    (path: PathLike, options: {
        encoding: BufferEncoding | null;
        withFileTypes?: false;
        recursive?: boolean;
    } | BufferEncoding | null): string[];
    (path: PathLike, options: {
        encoding: "buffer";
        withFileTypes?: false;
        recursive?: boolean;
    } | "buffer"): Buffer[];
    (path: PathLike, options: (ObjectEncodingOptions & {
        withFileTypes?: false;
        recursive?: boolean;
    }) | BufferEncoding | null): string[] | Buffer[];
    (path: PathLike, options: ObjectEncodingOptions & {
        withFileTypes: true;
        recursive?: boolean;
    }): IDirent[];
};

// @public (undocumented)
type ReadFile = {
    (path: PathOrFileDescriptor, options: ({
        encoding: null | undefined;
        flag?: string;
    } & Abortable) | null | undefined, callback: BufferCallback): void;
    (path: PathOrFileDescriptor, options: ({
        encoding: BufferEncoding;
        flag?: string;
    } & Abortable) | BufferEncoding, callback: StringCallback): void;
    (path: PathOrFileDescriptor, options: (ObjectEncodingOptions & {
        flag?: string;
    } & Abortable) | BufferEncoding | null | undefined, callback: StringOrBufferCallback): void;
    (path: PathOrFileDescriptor, callback: BufferCallback): void;
};

// @public (undocumented)
type ReadFileSync = {
    (path: PathOrFileDescriptor, options: {
        encoding: null | undefined;
        flag?: string;
    } | null): Buffer;
    (path: PathOrFileDescriptor, options: {
        encoding: BufferEncoding;
        flag?: string;
    } | BufferEncoding): string;
    (path: PathOrFileDescriptor, options: (ObjectEncodingOptions & {
        flag?: string;
    }) | BufferEncoding | null): string | Buffer;
};

// @public (undocumented)
type ReadJson = (path: PathOrFileDescriptor, callback: ReadJsonCallback) => void;

// @public (undocumented)
type ReadJsonCallback = (err: NodeJS.ErrnoException | Error | null, data?: JsonObject_2) => void;

// @public (undocumented)
type ReadJsonSync = (path: PathOrFileDescriptor) => JsonObject_2;

// @public (undocumented)
type Readlink = {
    (path: PathLike, options: EncodingOption, callback: StringCallback): void;
    (path: PathLike, options: BufferEncodingOption, callback: BufferCallback): void;
    (path: PathLike, options: EncodingOption, callback: StringOrBufferCallback): void;
    (path: PathLike, callback: StringCallback): void;
};

// @public (undocumented)
type ReadlinkSync = {
    (path: PathLike, options: EncodingOption): string;
    (path: PathLike, options: BufferEncodingOption): Buffer;
    (path: PathLike, options: EncodingOption): string | Buffer;
};

// @public (undocumented)
type RealPath = {
    (path: PathLike, options: EncodingOption, callback: StringCallback): void;
    (path: PathLike, options: BufferEncodingOption, callback: BufferCallback): void;
    (path: PathLike, options: EncodingOption, callback: StringOrBufferCallback): void;
    (path: PathLike, callback: StringCallback): void;
};

// @public (undocumented)
type RealPathSync = {
    (path: PathLike, options?: EncodingOption): string;
    (path: PathLike, options: BufferEncodingOption): Buffer;
    (path: PathLike, options?: EncodingOption): string | Buffer;
};

// @public (undocumented)
type RecursiveArrayOrRecord<T> = {
    [index: string]: RecursiveArrayOrRecord<T>;
} | Array<RecursiveArrayOrRecord<T>> | T;

// @public (undocumented)
type recursiveZodFormattedError<T> = T extends [any, ...any[]] ? {
    [K in keyof T]?: ZodFormattedError<T[K]>;
} : T extends any[] ? {
    [k: number]: ZodFormattedError<T[number]>;
} : T extends object ? {
    [K in keyof T]?: ZodFormattedError<T[K]>;
} : unknown;

// @public (undocumented)
interface RefinementCtx {
    // (undocumented)
    addIssue: (arg: IssueData) => void;
    // (undocumented)
    path: (string | number)[];
}

// @public (undocumented)
type RefinementEffect<T> = {
    type: "refinement";
    refinement: (arg: T, ctx: RefinementCtx) => any;
};

// @public (undocumented)
export type Remotes = (RemotesItem | RemotesObject)[] | RemotesObject;

// @public (undocumented)
export type RemotesConfig = {
    external: RemotesItem | RemotesItems;
    shareScope?: string;
};

// @public (undocumented)
export type RemotesItem = string;

// @public (undocumented)
export type RemotesItems = RemotesItem[];

// @public (undocumented)
export type RemotesObject = {
    [k: string]: RemotesConfig | RemotesItem | RemotesItems;
};

// @public (undocumented)
const RemoveDuplicateModulesPlugin: {
    new (): {
        name: BuiltinPluginName;
        _args: [];
        affectedHooks: "done" | "make" | "environment" | "compile" | "emit" | "afterEmit" | "invalid" | "thisCompilation" | "afterDone" | "compilation" | "normalModuleFactory" | "contextModuleFactory" | "initialize" | "shouldEmit" | "infrastructureLog" | "beforeRun" | "run" | "assetEmitted" | "failed" | "shutdown" | "watchRun" | "watchClose" | "afterEnvironment" | "afterPlugins" | "afterResolvers" | "beforeCompile" | "afterCompile" | "finishMake" | "entryOption" | "additionalPass" | undefined;
        raw(compiler: Compiler_2): BuiltinPlugin;
        apply(compiler: Compiler_2): void;
    };
};

// @public
export type Resolve = ResolveOptions;

// @public
export type ResolveAlias = {
    [x: string]: string | false | (string | false)[];
};

// @public (undocumented)
type ResolveCallback = (err: null | ErrorWithDetails, res?: string | false, req?: ResolveRequest) => void;

// @public (undocumented)
type ResolveContext = {};

// @public (undocumented)
export type ResolveData = {
    contextInfo: ContextInfo;
    context: string;
    request: string;
    fileDependencies: string[];
    missingDependencies: string[];
    contextDependencies: string[];
    createData?: CreateData;
};

// @public
export type ResolveOptions = {
    alias?: ResolveAlias;
    conditionNames?: string[];
    extensions?: string[];
    fallback?: ResolveAlias;
    mainFields?: string[];
    mainFiles?: string[];
    modules?: string[];
    preferRelative?: boolean;
    preferAbsolute?: boolean;
    symlinks?: boolean;
    enforceExtension?: boolean;
    importsFields?: string[];
    descriptionFiles?: string[];
    tsConfig?: ResolveTsConfig;
    fullySpecified?: boolean;
    exportsFields?: string[];
    extensionAlias?: Record<string, string | string[]>;
    aliasFields?: string[];
    restrictions?: string[];
    roots?: string[];
    byDependency?: Record<string, ResolveOptions>;
};

// @public (undocumented)
type ResolveOptionsWithDependencyType = Resolve & {
    dependencyCategory?: string;
    resolveToContext?: boolean;
};

// @public (undocumented)
type ResolveOptionsWithDependencyType_2 = Resolve & {
    dependencyCategory?: string;
    resolveToContext?: boolean;
};

// @public (undocumented)
class Resolver {
    constructor(binding: binding.JsResolver);
    // (undocumented)
    binding: binding.JsResolver;
    // (undocumented)
    resolve(context: object, path: string, request: string, resolveContext: ResolveContext, callback: ResolveCallback): void;
    // (undocumented)
    resolveSync(context: object, path: string, request: string): string | false;
    // (undocumented)
    withOptions({ dependencyCategory, resolveToContext, ...resolve }: ResolveOptionsWithDependencyType_2): Resolver;
}

// @public (undocumented)
type ResolveRequest = BaseResolveRequest & Partial<ParsedIdentifier>;

// @public (undocumented)
class ResolverFactory {
    constructor();
    // (undocumented)
    static __to_binding(resolver_factory: ResolverFactory): binding.JsResolverFactory;
    // (undocumented)
    get(type: string, resolveOptions?: ResolveOptionsWithDependencyType): Resolver;
}

// @public
export type ResolveTsConfig = string | {
    configFile: string;
    references?: string[] | "auto" | undefined;
};

// @public (undocumented)
type ResourceData = {
    resource: string;
    path: string;
    query?: string;
    fragment?: string;
};

// @public (undocumented)
type ResourceDataWithData = ResourceData & {
    data?: Record<string, any>;
};

// @public (undocumented)
type Rspack = typeof rspack_2 & typeof rspackExports & {
    rspack: Rspack;
    webpack: Rspack;
};

// @public (undocumented)
const rspack: Rspack;
export default rspack;
export { rspack }

// @public (undocumented)
function rspack_2(options: MultiRspackOptions): MultiCompiler;

// @public (undocumented)
function rspack_2(options: RspackOptions): Compiler;

// @public (undocumented)
function rspack_2(options: MultiRspackOptions | RspackOptions): MultiCompiler | Compiler;

// @public (undocumented)
function rspack_2(options: MultiRspackOptions, callback?: Callback<Error, MultiStats>): null | MultiCompiler;

// @public (undocumented)
function rspack_2(options: RspackOptions, callback?: Callback<Error, Stats>): null | Compiler;

// @public (undocumented)
function rspack_2(options: MultiRspackOptions | RspackOptions, callback?: Callback<Error, MultiStats | Stats>): null | MultiCompiler | Compiler;

// @public (undocumented)
abstract class RspackBuiltinPlugin implements RspackPluginInstance {
    // (undocumented)
    affectedHooks?: AffectedHooks;
    // (undocumented)
    apply(compiler: Compiler): void;
    // (undocumented)
    abstract name: binding.BuiltinPluginName;
    // (undocumented)
    abstract raw(compiler: Compiler): binding.BuiltinPlugin | undefined;
}

// @public (undocumented)
type RspackError = binding.JsRspackError;

declare namespace rspackExports {
    export {
        rspackVersion,
        version,
        Asset,
        AssetInfo,
        Assets,
        CompilationParams,
        LogEntry,
        Compilation,
        Compiler,
        MultiCompilerOptions,
        MultiRspackOptions,
        MultiCompiler,
        RspackOptionsApply,
        RspackOptionsApply as WebpackOptionsApply,
        Chunk,
        ChunkGroup,
        Module,
        ResolveData,
        MultiStats,
        NormalModule,
        NormalModuleFactory,
        RuntimeGlobals,
        StatsAsset,
        StatsChunk,
        StatsCompilation,
        StatsError,
        StatsModule,
        Stats,
        RuntimeModule,
        ModuleFilenameHelpers,
        Template,
        WebpackError,
        Watching,
        sources,
        config,
        ValidationError,
        util,
        EntryOptionPlugin,
        OutputFileSystem,
        BannerPluginArgument,
        ProvidePluginOptions,
        DefinePluginOptions,
        ProgressPluginArgument,
        EntryOptions,
        BannerPlugin,
        IgnorePlugin,
        IgnorePluginOptions,
        ProvidePlugin,
        DefinePlugin,
        ProgressPlugin,
        EntryPlugin,
        DynamicEntryPlugin,
        ExternalsPlugin,
        HotModuleReplacementPlugin,
        NoEmitOnErrorsPlugin,
        WarnCaseSensitiveModulesPlugin,
        DllPlugin,
        DllPluginOptions,
        DllReferencePlugin,
        DllReferencePluginOptions,
        DllReferencePluginOptionsSourceType,
        DllReferencePluginOptionsContent,
        DllReferencePluginOptionsManifest,
        EnvironmentPlugin,
        LoaderOptionsPlugin,
        LoaderTargetPlugin,
        NormalModuleReplacementPlugin,
        web,
        node,
        electron,
        library,
        wasm,
        javascript,
        webworker,
        optimize,
        ModuleFederationPluginOptions,
        ModuleFederationPluginV1Options,
        ContainerPluginOptions,
        Exposes,
        ExposesConfig,
        ExposesItem,
        ExposesItems,
        ExposesObject,
        ContainerReferencePluginOptions,
        Remotes,
        RemotesConfig,
        RemotesItem,
        RemotesItems,
        RemotesObject,
        container,
        Consumes,
        ConsumesConfig,
        ConsumeSharedPluginOptions,
        ConsumesItem,
        ConsumesObject,
        Provides,
        ProvidesConfig,
        ProvideSharedPluginOptions,
        ProvidesItem,
        ProvidesObject,
        Shared,
        SharedConfig,
        SharedItem,
        SharedObject,
        SharePluginOptions,
        sharing,
        HtmlRspackPluginOptions,
        SwcJsMinimizerRspackPluginOptions,
        LightningCssMinimizerRspackPluginOptions,
        CopyRspackPluginOptions,
        SourceMapDevToolPluginOptions,
        EvalDevToolModulePluginOptions,
        CssExtractRspackLoaderOptions,
        CssExtractRspackPluginOptions,
        HtmlRspackPlugin,
        SwcJsMinimizerRspackPlugin,
        LightningCssMinimizerRspackPlugin,
        CopyRspackPlugin,
        SourceMapDevToolPlugin,
        EvalSourceMapDevToolPlugin,
        EvalDevToolModulePlugin,
        CssExtractRspackPlugin,
        ContextReplacementPlugin,
        SwcLoaderEnvConfig,
        SwcLoaderEsParserConfig,
        SwcLoaderJscConfig,
        SwcLoaderModuleConfig,
        SwcLoaderOptions,
        SwcLoaderParserConfig,
        SwcLoaderTransformConfig,
        SwcLoaderTsParserConfig,
        LightningcssLoaderOptions,
        LightningcssFeatureOptions,
        experiments,
        getRawResolve,
        LoaderContext,
        LoaderDefinition,
        LoaderDefinitionFunction,
        getRawOptions,
        applyRspackOptionsDefaults,
        applyRspackOptionsBaseDefaults,
        getNormalizedRspackOptions,
        EntryDynamicNormalized,
        EntryNormalized,
        EntryStaticNormalized,
        EntryDescriptionNormalized,
        OutputNormalized,
        ModuleOptionsNormalized,
        ExperimentCacheNormalized,
        ExperimentsNormalized,
        IgnoreWarningsNormalized,
        OptimizationRuntimeChunkNormalized,
        RspackOptionsNormalized,
        externalsType,
        rspackOptions,
        FilenameTemplate,
        Filename,
        Name,
        Dependencies,
        Context,
        Mode,
        Falsy,
        PublicPath,
        BaseUri,
        ChunkLoadingType,
        ChunkLoading,
        AsyncChunks,
        WasmLoadingType,
        WasmLoading,
        ScriptType,
        LibraryCustomUmdObject,
        LibraryName,
        LibraryCustomUmdCommentObject,
        AmdContainer,
        AuxiliaryComment,
        LibraryExport,
        LibraryType,
        UmdNamedDefine,
        LibraryOptions,
        Library,
        Layer,
        EntryFilename,
        EntryRuntime,
        EntryItem,
        EntryDependOn,
        EntryDescription,
        EntryUnnamed,
        EntryObject,
        EntryStatic,
        EntryDynamic,
        Entry,
        Path,
        Pathinfo,
        AssetModuleFilename,
        WebassemblyModuleFilename,
        ChunkFilename,
        CrossOriginLoading,
        CssFilename,
        CssChunkFilename,
        HotUpdateChunkFilename,
        HotUpdateMainFilename,
        HotUpdateGlobal,
        UniqueName,
        ChunkLoadingGlobal,
        EnabledLibraryTypes,
        Clean,
        OutputModule,
        StrictModuleExceptionHandling,
        StrictModuleErrorHandling,
        GlobalObject,
        EnabledWasmLoadingTypes,
        ImportFunctionName,
        ImportMetaName,
        Iife,
        EnabledChunkLoadingTypes,
        ChunkFormat,
        WorkerPublicPath,
        TrustedTypes,
        HashDigest,
        HashDigestLength,
        HashFunction,
        HashSalt,
        SourceMapFilename,
        DevtoolNamespace,
        DevtoolModuleFilenameTemplate,
        DevtoolFallbackModuleFilenameTemplate,
        Environment,
        Output,
        ResolveAlias,
        ResolveTsConfig,
        ResolveOptions,
        Resolve,
        RuleSetCondition,
        RuleSetConditions,
        RuleSetLogicalConditions,
        RuleSetLoader,
        RuleSetLoaderOptions,
        RuleSetLoaderWithOptions,
        RuleSetUseItem,
        RuleSetUse,
        RuleSetRule,
        RuleSetRules,
        AssetParserDataUrlOptions,
        AssetParserDataUrl,
        AssetParserOptions,
        CssParserNamedExports,
        CssParserOptions,
        CssAutoParserOptions,
        CssModuleParserOptions,
        JavascriptParserOptions,
        JsonParserOptions,
        ParserOptionsByModuleTypeKnown,
        ParserOptionsByModuleTypeUnknown,
        ParserOptionsByModuleType,
        AssetGeneratorDataUrlOptions,
        AssetGeneratorDataUrlFunction,
        AssetGeneratorDataUrl,
        AssetInlineGeneratorOptions,
        AssetModuleOutputPath,
        AssetResourceGeneratorOptions,
        AssetGeneratorOptions,
        CssGeneratorExportsConvention,
        CssGeneratorExportsOnly,
        CssGeneratorLocalIdentName,
        CssGeneratorEsModule,
        CssGeneratorOptions,
        CssAutoGeneratorOptions,
        CssModuleGeneratorOptions,
        GeneratorOptionsByModuleTypeKnown,
        GeneratorOptionsByModuleTypeUnknown,
        GeneratorOptionsByModuleType,
        NoParseOption,
        ModuleOptions,
        Target,
        ExternalsType,
        ExternalItemUmdValue,
        ExternalItemObjectValue,
        ExternalItemValue,
        ExternalItemObjectUnknown,
        ExternalItemFunctionData,
        ExternalItem,
        Externals,
        ExternalsPresets,
        FilterItemTypes,
        FilterTypes,
        InfrastructureLogging,
        DevTool,
        NodeOptions,
        Node_2 as Node,
        Loader,
        SnapshotOptions,
        CacheOptions,
        StatsOptions,
        StatsValue,
        RspackPluginInstance,
        RspackPluginFunction,
        WebpackCompiler,
        WebpackPluginInstance,
        WebpackPluginFunction,
        Plugin_2 as Plugin,
        Plugins,
        OptimizationRuntimeChunk,
        OptimizationSplitChunksNameFunction,
        OptimizationSplitChunksCacheGroup,
        OptimizationSplitChunksOptions,
        Optimization,
        ExperimentCacheOptions,
        RspackFutureOptions,
        LazyCompilationOptions,
        Incremental,
        Experiments,
        Watch,
        WatchOptions,
        DevServer,
        IgnoreWarnings,
        Profile,
        Amd,
        Bail,
        Performance_2 as Performance,
        RspackOptions,
        Configuration
    }
}

// @public
export type RspackFutureOptions = {
    bundlerInfo?: {
        version?: string;
        bundler?: string;
        force?: boolean | ("version" | "uniqueId")[];
    };
};

// @public (undocumented)
export type RspackOptions = {
    name?: Name;
    dependencies?: Dependencies;
    entry?: Entry;
    output?: Output;
    target?: Target;
    mode?: Mode;
    experiments?: Experiments;
    externals?: Externals;
    externalsType?: ExternalsType;
    externalsPresets?: ExternalsPresets;
    infrastructureLogging?: InfrastructureLogging;
    cache?: CacheOptions;
    context?: Context;
    devtool?: DevTool;
    node?: Node_2;
    loader?: Loader;
    ignoreWarnings?: IgnoreWarnings;
    watchOptions?: WatchOptions;
    watch?: Watch;
    stats?: StatsValue;
    snapshot?: SnapshotOptions;
    optimization?: Optimization;
    resolve?: ResolveOptions;
    resolveLoader?: ResolveOptions;
    plugins?: Plugins;
    devServer?: DevServer;
    module?: ModuleOptions;
    profile?: Profile;
    amd?: Amd;
    bail?: Bail;
    performance?: Performance_2;
};

// @public (undocumented)
export const rspackOptions: z.ZodObject<{
    name: z.ZodOptional<z.ZodString>;
    dependencies: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    entry: z.ZodOptional<z.ZodUnion<[z.ZodUnion<[z.ZodRecord<z.ZodString, z.ZodUnion<[z.ZodUnion<[z.ZodString, z.ZodArray<z.ZodString, "many">]>, z.ZodObject<{
        import: z.ZodUnion<[z.ZodString, z.ZodArray<z.ZodString, "many">]>;
        runtime: z.ZodOptional<z.ZodUnion<[z.ZodLiteral<false>, z.ZodString]>>;
        publicPath: z.ZodOptional<z.ZodUnion<[z.ZodLiteral<"auto">, z.ZodUnion<[z.ZodString, z.ZodFunction<z.ZodTuple<[z.ZodType<PathData, z.ZodTypeDef, PathData>, z.ZodOptional<z.ZodType<JsAssetInfo, z.ZodTypeDef, JsAssetInfo>>], z.ZodUnknown>, z.ZodString>]>]>>;
        baseUri: z.ZodOptional<z.ZodString>;
        chunkLoading: z.ZodOptional<z.ZodUnion<[z.ZodLiteral<false>, z.ZodUnion<[z.ZodEnum<["jsonp", "import-scripts", "require", "async-node", "import"]>, z.ZodString]>]>>;
        asyncChunks: z.ZodOptional<z.ZodBoolean>;
        wasmLoading: z.ZodOptional<z.ZodUnion<[z.ZodLiteral<false>, z.ZodUnion<[z.ZodEnum<["fetch-streaming", "fetch", "async-node"]>, z.ZodString]>]>>;
        filename: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodFunction<z.ZodTuple<[z.ZodType<PathData, z.ZodTypeDef, PathData>, z.ZodOptional<z.ZodType<JsAssetInfo, z.ZodTypeDef, JsAssetInfo>>], z.ZodUnknown>, z.ZodString>]>>;
        library: z.ZodOptional<z.ZodObject<{
            amdContainer: z.ZodOptional<z.ZodString>;
            auxiliaryComment: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodObject<{
                amd: z.ZodOptional<z.ZodString>;
                commonjs: z.ZodOptional<z.ZodString>;
                commonjs2: z.ZodOptional<z.ZodString>;
                root: z.ZodOptional<z.ZodString>;
            }, "strict", z.ZodTypeAny, {
                commonjs?: string | undefined;
                commonjs2?: string | undefined;
                amd?: string | undefined;
                root?: string | undefined;
            }, {
                commonjs?: string | undefined;
                commonjs2?: string | undefined;
                amd?: string | undefined;
                root?: string | undefined;
            }>]>>;
            export: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodArray<z.ZodString, "many">]>>;
            name: z.ZodOptional<z.ZodUnion<[z.ZodUnion<[z.ZodString, z.ZodArray<z.ZodString, "many">]>, z.ZodObject<{
                amd: z.ZodOptional<z.ZodString>;
                commonjs: z.ZodOptional<z.ZodString>;
                root: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodArray<z.ZodString, "many">]>>;
            }, "strict", z.ZodTypeAny, {
                commonjs?: string | undefined;
                amd?: string | undefined;
                root?: string | string[] | undefined;
            }, {
                commonjs?: string | undefined;
                amd?: string | undefined;
                root?: string | string[] | undefined;
            }>]>>;
            type: z.ZodUnion<[z.ZodEnum<["var", "module", "assign", "assign-properties", "this", "window", "self", "global", "commonjs", "commonjs2", "commonjs-module", "commonjs-static", "amd", "amd-require", "umd", "umd2", "jsonp", "system"]>, z.ZodString]>;
            umdNamedDefine: z.ZodOptional<z.ZodBoolean>;
        }, "strict", z.ZodTypeAny, {
            type: string;
            name?: string | string[] | {
                commonjs?: string | undefined;
                amd?: string | undefined;
                root?: string | string[] | undefined;
            } | undefined;
            amdContainer?: string | undefined;
            auxiliaryComment?: string | {
                commonjs?: string | undefined;
                commonjs2?: string | undefined;
                amd?: string | undefined;
                root?: string | undefined;
            } | undefined;
            export?: string | string[] | undefined;
            umdNamedDefine?: boolean | undefined;
        }, {
            type: string;
            name?: string | string[] | {
                commonjs?: string | undefined;
                amd?: string | undefined;
                root?: string | string[] | undefined;
            } | undefined;
            amdContainer?: string | undefined;
            auxiliaryComment?: string | {
                commonjs?: string | undefined;
                commonjs2?: string | undefined;
                amd?: string | undefined;
                root?: string | undefined;
            } | undefined;
            export?: string | string[] | undefined;
            umdNamedDefine?: boolean | undefined;
        }>>;
        dependOn: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodArray<z.ZodString, "many">]>>;
        layer: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNull]>>;
    }, "strict", z.ZodTypeAny, {
        import: string | string[];
        layer?: string | null | undefined;
        runtime?: string | false | undefined;
        chunkLoading?: string | false | undefined;
        asyncChunks?: boolean | undefined;
        publicPath?: string | ((args_0: PathData, args_1: JsAssetInfo | undefined, ...args: unknown[]) => string) | undefined;
        baseUri?: string | undefined;
        filename?: string | ((args_0: PathData, args_1: JsAssetInfo | undefined, ...args: unknown[]) => string) | undefined;
        library?: {
            type: string;
            name?: string | string[] | {
                commonjs?: string | undefined;
                amd?: string | undefined;
                root?: string | string[] | undefined;
            } | undefined;
            amdContainer?: string | undefined;
            auxiliaryComment?: string | {
                commonjs?: string | undefined;
                commonjs2?: string | undefined;
                amd?: string | undefined;
                root?: string | undefined;
            } | undefined;
            export?: string | string[] | undefined;
            umdNamedDefine?: boolean | undefined;
        } | undefined;
        wasmLoading?: string | false | undefined;
        dependOn?: string | string[] | undefined;
    }, {
        import: string | string[];
        layer?: string | null | undefined;
        runtime?: string | false | undefined;
        chunkLoading?: string | false | undefined;
        asyncChunks?: boolean | undefined;
        publicPath?: string | ((args_0: PathData, args_1: JsAssetInfo | undefined, ...args: unknown[]) => string) | undefined;
        baseUri?: string | undefined;
        filename?: string | ((args_0: PathData, args_1: JsAssetInfo | undefined, ...args: unknown[]) => string) | undefined;
        library?: {
            type: string;
            name?: string | string[] | {
                commonjs?: string | undefined;
                amd?: string | undefined;
                root?: string | string[] | undefined;
            } | undefined;
            amdContainer?: string | undefined;
            auxiliaryComment?: string | {
                commonjs?: string | undefined;
                commonjs2?: string | undefined;
                amd?: string | undefined;
                root?: string | undefined;
            } | undefined;
            export?: string | string[] | undefined;
            umdNamedDefine?: boolean | undefined;
        } | undefined;
        wasmLoading?: string | false | undefined;
        dependOn?: string | string[] | undefined;
    }>]>>, z.ZodUnion<[z.ZodString, z.ZodArray<z.ZodString, "many">]>]>, z.ZodFunction<z.ZodTuple<[], z.ZodUnknown>, z.ZodUnion<[z.ZodUnion<[z.ZodRecord<z.ZodString, z.ZodUnion<[z.ZodUnion<[z.ZodString, z.ZodArray<z.ZodString, "many">]>, z.ZodObject<{
        import: z.ZodUnion<[z.ZodString, z.ZodArray<z.ZodString, "many">]>;
        runtime: z.ZodOptional<z.ZodUnion<[z.ZodLiteral<false>, z.ZodString]>>;
        publicPath: z.ZodOptional<z.ZodUnion<[z.ZodLiteral<"auto">, z.ZodUnion<[z.ZodString, z.ZodFunction<z.ZodTuple<[z.ZodType<PathData, z.ZodTypeDef, PathData>, z.ZodOptional<z.ZodType<JsAssetInfo, z.ZodTypeDef, JsAssetInfo>>], z.ZodUnknown>, z.ZodString>]>]>>;
        baseUri: z.ZodOptional<z.ZodString>;
        chunkLoading: z.ZodOptional<z.ZodUnion<[z.ZodLiteral<false>, z.ZodUnion<[z.ZodEnum<["jsonp", "import-scripts", "require", "async-node", "import"]>, z.ZodString]>]>>;
        asyncChunks: z.ZodOptional<z.ZodBoolean>;
        wasmLoading: z.ZodOptional<z.ZodUnion<[z.ZodLiteral<false>, z.ZodUnion<[z.ZodEnum<["fetch-streaming", "fetch", "async-node"]>, z.ZodString]>]>>;
        filename: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodFunction<z.ZodTuple<[z.ZodType<PathData, z.ZodTypeDef, PathData>, z.ZodOptional<z.ZodType<JsAssetInfo, z.ZodTypeDef, JsAssetInfo>>], z.ZodUnknown>, z.ZodString>]>>;
        library: z.ZodOptional<z.ZodObject<{
            amdContainer: z.ZodOptional<z.ZodString>;
            auxiliaryComment: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodObject<{
                amd: z.ZodOptional<z.ZodString>;
                commonjs: z.ZodOptional<z.ZodString>;
                commonjs2: z.ZodOptional<z.ZodString>;
                root: z.ZodOptional<z.ZodString>;
            }, "strict", z.ZodTypeAny, {
                commonjs?: string | undefined;
                commonjs2?: string | undefined;
                amd?: string | undefined;
                root?: string | undefined;
            }, {
                commonjs?: string | undefined;
                commonjs2?: string | undefined;
                amd?: string | undefined;
                root?: string | undefined;
            }>]>>;
            export: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodArray<z.ZodString, "many">]>>;
            name: z.ZodOptional<z.ZodUnion<[z.ZodUnion<[z.ZodString, z.ZodArray<z.ZodString, "many">]>, z.ZodObject<{
                amd: z.ZodOptional<z.ZodString>;
                commonjs: z.ZodOptional<z.ZodString>;
                root: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodArray<z.ZodString, "many">]>>;
            }, "strict", z.ZodTypeAny, {
                commonjs?: string | undefined;
                amd?: string | undefined;
                root?: string | string[] | undefined;
            }, {
                commonjs?: string | undefined;
                amd?: string | undefined;
                root?: string | string[] | undefined;
            }>]>>;
            type: z.ZodUnion<[z.ZodEnum<["var", "module", "assign", "assign-properties", "this", "window", "self", "global", "commonjs", "commonjs2", "commonjs-module", "commonjs-static", "amd", "amd-require", "umd", "umd2", "jsonp", "system"]>, z.ZodString]>;
            umdNamedDefine: z.ZodOptional<z.ZodBoolean>;
        }, "strict", z.ZodTypeAny, {
            type: string;
            name?: string | string[] | {
                commonjs?: string | undefined;
                amd?: string | undefined;
                root?: string | string[] | undefined;
            } | undefined;
            amdContainer?: string | undefined;
            auxiliaryComment?: string | {
                commonjs?: string | undefined;
                commonjs2?: string | undefined;
                amd?: string | undefined;
                root?: string | undefined;
            } | undefined;
            export?: string | string[] | undefined;
            umdNamedDefine?: boolean | undefined;
        }, {
            type: string;
            name?: string | string[] | {
                commonjs?: string | undefined;
                amd?: string | undefined;
                root?: string | string[] | undefined;
            } | undefined;
            amdContainer?: string | undefined;
            auxiliaryComment?: string | {
                commonjs?: string | undefined;
                commonjs2?: string | undefined;
                amd?: string | undefined;
                root?: string | undefined;
            } | undefined;
            export?: string | string[] | undefined;
            umdNamedDefine?: boolean | undefined;
        }>>;
        dependOn: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodArray<z.ZodString, "many">]>>;
        layer: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNull]>>;
    }, "strict", z.ZodTypeAny, {
        import: string | string[];
        layer?: string | null | undefined;
        runtime?: string | false | undefined;
        chunkLoading?: string | false | undefined;
        asyncChunks?: boolean | undefined;
        publicPath?: string | ((args_0: PathData, args_1: JsAssetInfo | undefined, ...args: unknown[]) => string) | undefined;
        baseUri?: string | undefined;
        filename?: string | ((args_0: PathData, args_1: JsAssetInfo | undefined, ...args: unknown[]) => string) | undefined;
        library?: {
            type: string;
            name?: string | string[] | {
                commonjs?: string | undefined;
                amd?: string | undefined;
                root?: string | string[] | undefined;
            } | undefined;
            amdContainer?: string | undefined;
            auxiliaryComment?: string | {
                commonjs?: string | undefined;
                commonjs2?: string | undefined;
                amd?: string | undefined;
                root?: string | undefined;
            } | undefined;
            export?: string | string[] | undefined;
            umdNamedDefine?: boolean | undefined;
        } | undefined;
        wasmLoading?: string | false | undefined;
        dependOn?: string | string[] | undefined;
    }, {
        import: string | string[];
        layer?: string | null | undefined;
        runtime?: string | false | undefined;
        chunkLoading?: string | false | undefined;
        asyncChunks?: boolean | undefined;
        publicPath?: string | ((args_0: PathData, args_1: JsAssetInfo | undefined, ...args: unknown[]) => string) | undefined;
        baseUri?: string | undefined;
        filename?: string | ((args_0: PathData, args_1: JsAssetInfo | undefined, ...args: unknown[]) => string) | undefined;
        library?: {
            type: string;
            name?: string | string[] | {
                commonjs?: string | undefined;
                amd?: string | undefined;
                root?: string | string[] | undefined;
            } | undefined;
            amdContainer?: string | undefined;
            auxiliaryComment?: string | {
                commonjs?: string | undefined;
                commonjs2?: string | undefined;
                amd?: string | undefined;
                root?: string | undefined;
            } | undefined;
            export?: string | string[] | undefined;
            umdNamedDefine?: boolean | undefined;
        } | undefined;
        wasmLoading?: string | false | undefined;
        dependOn?: string | string[] | undefined;
    }>]>>, z.ZodUnion<[z.ZodString, z.ZodArray<z.ZodString, "many">]>]>, z.ZodPromise<z.ZodUnion<[z.ZodRecord<z.ZodString, z.ZodUnion<[z.ZodUnion<[z.ZodString, z.ZodArray<z.ZodString, "many">]>, z.ZodObject<{
        import: z.ZodUnion<[z.ZodString, z.ZodArray<z.ZodString, "many">]>;
        runtime: z.ZodOptional<z.ZodUnion<[z.ZodLiteral<false>, z.ZodString]>>;
        publicPath: z.ZodOptional<z.ZodUnion<[z.ZodLiteral<"auto">, z.ZodUnion<[z.ZodString, z.ZodFunction<z.ZodTuple<[z.ZodType<PathData, z.ZodTypeDef, PathData>, z.ZodOptional<z.ZodType<JsAssetInfo, z.ZodTypeDef, JsAssetInfo>>], z.ZodUnknown>, z.ZodString>]>]>>;
        baseUri: z.ZodOptional<z.ZodString>;
        chunkLoading: z.ZodOptional<z.ZodUnion<[z.ZodLiteral<false>, z.ZodUnion<[z.ZodEnum<["jsonp", "import-scripts", "require", "async-node", "import"]>, z.ZodString]>]>>;
        asyncChunks: z.ZodOptional<z.ZodBoolean>;
        wasmLoading: z.ZodOptional<z.ZodUnion<[z.ZodLiteral<false>, z.ZodUnion<[z.ZodEnum<["fetch-streaming", "fetch", "async-node"]>, z.ZodString]>]>>;
        filename: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodFunction<z.ZodTuple<[z.ZodType<PathData, z.ZodTypeDef, PathData>, z.ZodOptional<z.ZodType<JsAssetInfo, z.ZodTypeDef, JsAssetInfo>>], z.ZodUnknown>, z.ZodString>]>>;
        library: z.ZodOptional<z.ZodObject<{
            amdContainer: z.ZodOptional<z.ZodString>;
            auxiliaryComment: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodObject<{
                amd: z.ZodOptional<z.ZodString>;
                commonjs: z.ZodOptional<z.ZodString>;
                commonjs2: z.ZodOptional<z.ZodString>;
                root: z.ZodOptional<z.ZodString>;
            }, "strict", z.ZodTypeAny, {
                commonjs?: string | undefined;
                commonjs2?: string | undefined;
                amd?: string | undefined;
                root?: string | undefined;
            }, {
                commonjs?: string | undefined;
                commonjs2?: string | undefined;
                amd?: string | undefined;
                root?: string | undefined;
            }>]>>;
            export: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodArray<z.ZodString, "many">]>>;
            name: z.ZodOptional<z.ZodUnion<[z.ZodUnion<[z.ZodString, z.ZodArray<z.ZodString, "many">]>, z.ZodObject<{
                amd: z.ZodOptional<z.ZodString>;
                commonjs: z.ZodOptional<z.ZodString>;
                root: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodArray<z.ZodString, "many">]>>;
            }, "strict", z.ZodTypeAny, {
                commonjs?: string | undefined;
                amd?: string | undefined;
                root?: string | string[] | undefined;
            }, {
                commonjs?: string | undefined;
                amd?: string | undefined;
                root?: string | string[] | undefined;
            }>]>>;
            type: z.ZodUnion<[z.ZodEnum<["var", "module", "assign", "assign-properties", "this", "window", "self", "global", "commonjs", "commonjs2", "commonjs-module", "commonjs-static", "amd", "amd-require", "umd", "umd2", "jsonp", "system"]>, z.ZodString]>;
            umdNamedDefine: z.ZodOptional<z.ZodBoolean>;
        }, "strict", z.ZodTypeAny, {
            type: string;
            name?: string | string[] | {
                commonjs?: string | undefined;
                amd?: string | undefined;
                root?: string | string[] | undefined;
            } | undefined;
            amdContainer?: string | undefined;
            auxiliaryComment?: string | {
                commonjs?: string | undefined;
                commonjs2?: string | undefined;
                amd?: string | undefined;
                root?: string | undefined;
            } | undefined;
            export?: string | string[] | undefined;
            umdNamedDefine?: boolean | undefined;
        }, {
            type: string;
            name?: string | string[] | {
                commonjs?: string | undefined;
                amd?: string | undefined;
                root?: string | string[] | undefined;
            } | undefined;
            amdContainer?: string | undefined;
            auxiliaryComment?: string | {
                commonjs?: string | undefined;
                commonjs2?: string | undefined;
                amd?: string | undefined;
                root?: string | undefined;
            } | undefined;
            export?: string | string[] | undefined;
            umdNamedDefine?: boolean | undefined;
        }>>;
        dependOn: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodArray<z.ZodString, "many">]>>;
        layer: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNull]>>;
    }, "strict", z.ZodTypeAny, {
        import: string | string[];
        layer?: string | null | undefined;
        runtime?: string | false | undefined;
        chunkLoading?: string | false | undefined;
        asyncChunks?: boolean | undefined;
        publicPath?: string | ((args_0: PathData, args_1: JsAssetInfo | undefined, ...args: unknown[]) => string) | undefined;
        baseUri?: string | undefined;
        filename?: string | ((args_0: PathData, args_1: JsAssetInfo | undefined, ...args: unknown[]) => string) | undefined;
        library?: {
            type: string;
            name?: string | string[] | {
                commonjs?: string | undefined;
                amd?: string | undefined;
                root?: string | string[] | undefined;
            } | undefined;
            amdContainer?: string | undefined;
            auxiliaryComment?: string | {
                commonjs?: string | undefined;
                commonjs2?: string | undefined;
                amd?: string | undefined;
                root?: string | undefined;
            } | undefined;
            export?: string | string[] | undefined;
            umdNamedDefine?: boolean | undefined;
        } | undefined;
        wasmLoading?: string | false | undefined;
        dependOn?: string | string[] | undefined;
    }, {
        import: string | string[];
        layer?: string | null | undefined;
        runtime?: string | false | undefined;
        chunkLoading?: string | false | undefined;
        asyncChunks?: boolean | undefined;
        publicPath?: string | ((args_0: PathData, args_1: JsAssetInfo | undefined, ...args: unknown[]) => string) | undefined;
        baseUri?: string | undefined;
        filename?: string | ((args_0: PathData, args_1: JsAssetInfo | undefined, ...args: unknown[]) => string) | undefined;
        library?: {
            type: string;
            name?: string | string[] | {
                commonjs?: string | undefined;
                amd?: string | undefined;
                root?: string | string[] | undefined;
            } | undefined;
            amdContainer?: string | undefined;
            auxiliaryComment?: string | {
                commonjs?: string | undefined;
                commonjs2?: string | undefined;
                amd?: string | undefined;
                root?: string | undefined;
            } | undefined;
            export?: string | string[] | undefined;
            umdNamedDefine?: boolean | undefined;
        } | undefined;
        wasmLoading?: string | false | undefined;
        dependOn?: string | string[] | undefined;
    }>]>>, z.ZodUnion<[z.ZodString, z.ZodArray<z.ZodString, "many">]>]>>]>>]>>;
    output: z.ZodOptional<z.ZodObject<{
        path: z.ZodOptional<z.ZodString>;
        pathinfo: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodLiteral<"verbose">]>>;
        clean: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodObject<{
            keep: z.ZodOptional<z.ZodString>;
        }, "strict", z.ZodTypeAny, {
            keep?: string | undefined;
        }, {
            keep?: string | undefined;
        }>]>>;
        publicPath: z.ZodOptional<z.ZodUnion<[z.ZodLiteral<"auto">, z.ZodUnion<[z.ZodString, z.ZodFunction<z.ZodTuple<[z.ZodType<PathData, z.ZodTypeDef, PathData>, z.ZodOptional<z.ZodType<JsAssetInfo, z.ZodTypeDef, JsAssetInfo>>], z.ZodUnknown>, z.ZodString>]>]>>;
        filename: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodFunction<z.ZodTuple<[z.ZodType<PathData, z.ZodTypeDef, PathData>, z.ZodOptional<z.ZodType<JsAssetInfo, z.ZodTypeDef, JsAssetInfo>>], z.ZodUnknown>, z.ZodString>]>>;
        chunkFilename: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodFunction<z.ZodTuple<[z.ZodType<PathData, z.ZodTypeDef, PathData>, z.ZodOptional<z.ZodType<JsAssetInfo, z.ZodTypeDef, JsAssetInfo>>], z.ZodUnknown>, z.ZodString>]>>;
        crossOriginLoading: z.ZodOptional<z.ZodUnion<[z.ZodLiteral<false>, z.ZodEnum<["anonymous", "use-credentials"]>]>>;
        cssFilename: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodFunction<z.ZodTuple<[z.ZodType<PathData, z.ZodTypeDef, PathData>, z.ZodOptional<z.ZodType<JsAssetInfo, z.ZodTypeDef, JsAssetInfo>>], z.ZodUnknown>, z.ZodString>]>>;
        cssHeadDataCompression: z.ZodOptional<z.ZodBoolean>;
        cssChunkFilename: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodFunction<z.ZodTuple<[z.ZodType<PathData, z.ZodTypeDef, PathData>, z.ZodOptional<z.ZodType<JsAssetInfo, z.ZodTypeDef, JsAssetInfo>>], z.ZodUnknown>, z.ZodString>]>>;
        hotUpdateMainFilename: z.ZodOptional<z.ZodString>;
        hotUpdateChunkFilename: z.ZodOptional<z.ZodString>;
        hotUpdateGlobal: z.ZodOptional<z.ZodString>;
        assetModuleFilename: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodFunction<z.ZodTuple<[z.ZodType<PathData, z.ZodTypeDef, PathData>, z.ZodOptional<z.ZodType<JsAssetInfo, z.ZodTypeDef, JsAssetInfo>>], z.ZodUnknown>, z.ZodString>]>>;
        uniqueName: z.ZodOptional<z.ZodString>;
        chunkLoadingGlobal: z.ZodOptional<z.ZodString>;
        enabledLibraryTypes: z.ZodOptional<z.ZodArray<z.ZodUnion<[z.ZodEnum<["var", "module", "assign", "assign-properties", "this", "window", "self", "global", "commonjs", "commonjs2", "commonjs-module", "commonjs-static", "amd", "amd-require", "umd", "umd2", "jsonp", "system"]>, z.ZodString]>, "many">>;
        library: z.ZodOptional<z.ZodOptional<z.ZodUnion<[z.ZodUnion<[z.ZodUnion<[z.ZodString, z.ZodArray<z.ZodString, "many">]>, z.ZodObject<{
            amd: z.ZodOptional<z.ZodString>;
            commonjs: z.ZodOptional<z.ZodString>;
            root: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodArray<z.ZodString, "many">]>>;
        }, "strict", z.ZodTypeAny, {
            commonjs?: string | undefined;
            amd?: string | undefined;
            root?: string | string[] | undefined;
        }, {
            commonjs?: string | undefined;
            amd?: string | undefined;
            root?: string | string[] | undefined;
        }>]>, z.ZodObject<{
            amdContainer: z.ZodOptional<z.ZodString>;
            auxiliaryComment: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodObject<{
                amd: z.ZodOptional<z.ZodString>;
                commonjs: z.ZodOptional<z.ZodString>;
                commonjs2: z.ZodOptional<z.ZodString>;
                root: z.ZodOptional<z.ZodString>;
            }, "strict", z.ZodTypeAny, {
                commonjs?: string | undefined;
                commonjs2?: string | undefined;
                amd?: string | undefined;
                root?: string | undefined;
            }, {
                commonjs?: string | undefined;
                commonjs2?: string | undefined;
                amd?: string | undefined;
                root?: string | undefined;
            }>]>>;
            export: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodArray<z.ZodString, "many">]>>;
            name: z.ZodOptional<z.ZodUnion<[z.ZodUnion<[z.ZodString, z.ZodArray<z.ZodString, "many">]>, z.ZodObject<{
                amd: z.ZodOptional<z.ZodString>;
                commonjs: z.ZodOptional<z.ZodString>;
                root: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodArray<z.ZodString, "many">]>>;
            }, "strict", z.ZodTypeAny, {
                commonjs?: string | undefined;
                amd?: string | undefined;
                root?: string | string[] | undefined;
            }, {
                commonjs?: string | undefined;
                amd?: string | undefined;
                root?: string | string[] | undefined;
            }>]>>;
            type: z.ZodUnion<[z.ZodEnum<["var", "module", "assign", "assign-properties", "this", "window", "self", "global", "commonjs", "commonjs2", "commonjs-module", "commonjs-static", "amd", "amd-require", "umd", "umd2", "jsonp", "system"]>, z.ZodString]>;
            umdNamedDefine: z.ZodOptional<z.ZodBoolean>;
        }, "strict", z.ZodTypeAny, {
            type: string;
            name?: string | string[] | {
                commonjs?: string | undefined;
                amd?: string | undefined;
                root?: string | string[] | undefined;
            } | undefined;
            amdContainer?: string | undefined;
            auxiliaryComment?: string | {
                commonjs?: string | undefined;
                commonjs2?: string | undefined;
                amd?: string | undefined;
                root?: string | undefined;
            } | undefined;
            export?: string | string[] | undefined;
            umdNamedDefine?: boolean | undefined;
        }, {
            type: string;
            name?: string | string[] | {
                commonjs?: string | undefined;
                amd?: string | undefined;
                root?: string | string[] | undefined;
            } | undefined;
            amdContainer?: string | undefined;
            auxiliaryComment?: string | {
                commonjs?: string | undefined;
                commonjs2?: string | undefined;
                amd?: string | undefined;
                root?: string | undefined;
            } | undefined;
            export?: string | string[] | undefined;
            umdNamedDefine?: boolean | undefined;
        }>]>>>;
        libraryExport: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodArray<z.ZodString, "many">]>>;
        libraryTarget: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["var", "module", "assign", "assign-properties", "this", "window", "self", "global", "commonjs", "commonjs2", "commonjs-module", "commonjs-static", "amd", "amd-require", "umd", "umd2", "jsonp", "system"]>, z.ZodString]>>;
        umdNamedDefine: z.ZodOptional<z.ZodBoolean>;
        auxiliaryComment: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodObject<{
            amd: z.ZodOptional<z.ZodString>;
            commonjs: z.ZodOptional<z.ZodString>;
            commonjs2: z.ZodOptional<z.ZodString>;
            root: z.ZodOptional<z.ZodString>;
        }, "strict", z.ZodTypeAny, {
            commonjs?: string | undefined;
            commonjs2?: string | undefined;
            amd?: string | undefined;
            root?: string | undefined;
        }, {
            commonjs?: string | undefined;
            commonjs2?: string | undefined;
            amd?: string | undefined;
            root?: string | undefined;
        }>]>>;
        module: z.ZodOptional<z.ZodBoolean>;
        strictModuleExceptionHandling: z.ZodOptional<z.ZodBoolean>;
        strictModuleErrorHandling: z.ZodOptional<z.ZodBoolean>;
        globalObject: z.ZodOptional<z.ZodString>;
        importFunctionName: z.ZodOptional<z.ZodString>;
        importMetaName: z.ZodOptional<z.ZodString>;
        iife: z.ZodOptional<z.ZodBoolean>;
        wasmLoading: z.ZodOptional<z.ZodUnion<[z.ZodLiteral<false>, z.ZodUnion<[z.ZodEnum<["fetch-streaming", "fetch", "async-node"]>, z.ZodString]>]>>;
        enabledWasmLoadingTypes: z.ZodOptional<z.ZodArray<z.ZodUnion<[z.ZodEnum<["fetch-streaming", "fetch", "async-node"]>, z.ZodString]>, "many">>;
        webassemblyModuleFilename: z.ZodOptional<z.ZodString>;
        chunkFormat: z.ZodOptional<z.ZodUnion<[z.ZodLiteral<false>, z.ZodString]>>;
        chunkLoading: z.ZodOptional<z.ZodUnion<[z.ZodLiteral<false>, z.ZodUnion<[z.ZodEnum<["jsonp", "import-scripts", "require", "async-node", "import"]>, z.ZodString]>]>>;
        enabledChunkLoadingTypes: z.ZodOptional<z.ZodArray<z.ZodUnion<[z.ZodEnum<["jsonp", "import-scripts", "require", "async-node", "import"]>, z.ZodString]>, "many">>;
        trustedTypes: z.ZodOptional<z.ZodUnion<[z.ZodUnion<[z.ZodLiteral<true>, z.ZodString]>, z.ZodObject<{
            policyName: z.ZodOptional<z.ZodString>;
            onPolicyCreationFailure: z.ZodOptional<z.ZodEnum<["continue", "stop"]>>;
        }, "strict", z.ZodTypeAny, {
            policyName?: string | undefined;
            onPolicyCreationFailure?: "continue" | "stop" | undefined;
        }, {
            policyName?: string | undefined;
            onPolicyCreationFailure?: "continue" | "stop" | undefined;
        }>]>>;
        sourceMapFilename: z.ZodOptional<z.ZodString>;
        hashDigest: z.ZodOptional<z.ZodString>;
        hashDigestLength: z.ZodOptional<z.ZodNumber>;
        hashFunction: z.ZodOptional<z.ZodEnum<["md4", "xxhash64"]>>;
        hashSalt: z.ZodOptional<z.ZodString>;
        asyncChunks: z.ZodOptional<z.ZodBoolean>;
        workerChunkLoading: z.ZodOptional<z.ZodUnion<[z.ZodLiteral<false>, z.ZodUnion<[z.ZodEnum<["jsonp", "import-scripts", "require", "async-node", "import"]>, z.ZodString]>]>>;
        workerWasmLoading: z.ZodOptional<z.ZodUnion<[z.ZodLiteral<false>, z.ZodUnion<[z.ZodEnum<["fetch-streaming", "fetch", "async-node"]>, z.ZodString]>]>>;
        workerPublicPath: z.ZodOptional<z.ZodString>;
        scriptType: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["text/javascript", "module"]>, z.ZodLiteral<false>]>>;
        devtoolNamespace: z.ZodOptional<z.ZodString>;
        devtoolModuleFilenameTemplate: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodFunction<z.ZodTuple<[z.ZodAny], null>, z.ZodAny>]>>;
        devtoolFallbackModuleFilenameTemplate: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodFunction<z.ZodTuple<[z.ZodAny], null>, z.ZodAny>]>>;
        chunkLoadTimeout: z.ZodOptional<z.ZodNumber>;
        charset: z.ZodOptional<z.ZodBoolean>;
        environment: z.ZodOptional<z.ZodObject<{
            arrowFunction: z.ZodOptional<z.ZodBoolean>;
            asyncFunction: z.ZodOptional<z.ZodBoolean>;
            bigIntLiteral: z.ZodOptional<z.ZodBoolean>;
            const: z.ZodOptional<z.ZodBoolean>;
            destructuring: z.ZodOptional<z.ZodBoolean>;
            document: z.ZodOptional<z.ZodBoolean>;
            dynamicImport: z.ZodOptional<z.ZodBoolean>;
            dynamicImportInWorker: z.ZodOptional<z.ZodBoolean>;
            forOf: z.ZodOptional<z.ZodBoolean>;
            globalThis: z.ZodOptional<z.ZodBoolean>;
            module: z.ZodOptional<z.ZodBoolean>;
            nodePrefixForCoreModules: z.ZodOptional<z.ZodBoolean>;
            optionalChaining: z.ZodOptional<z.ZodBoolean>;
            templateLiteral: z.ZodOptional<z.ZodBoolean>;
        }, "strict", z.ZodTypeAny, {
            module?: boolean | undefined;
            document?: boolean | undefined;
            nodePrefixForCoreModules?: boolean | undefined;
            globalThis?: boolean | undefined;
            bigIntLiteral?: boolean | undefined;
            const?: boolean | undefined;
            arrowFunction?: boolean | undefined;
            forOf?: boolean | undefined;
            destructuring?: boolean | undefined;
            dynamicImport?: boolean | undefined;
            dynamicImportInWorker?: boolean | undefined;
            optionalChaining?: boolean | undefined;
            templateLiteral?: boolean | undefined;
            asyncFunction?: boolean | undefined;
        }, {
            module?: boolean | undefined;
            document?: boolean | undefined;
            nodePrefixForCoreModules?: boolean | undefined;
            globalThis?: boolean | undefined;
            bigIntLiteral?: boolean | undefined;
            const?: boolean | undefined;
            arrowFunction?: boolean | undefined;
            forOf?: boolean | undefined;
            destructuring?: boolean | undefined;
            dynamicImport?: boolean | undefined;
            dynamicImportInWorker?: boolean | undefined;
            optionalChaining?: boolean | undefined;
            templateLiteral?: boolean | undefined;
            asyncFunction?: boolean | undefined;
        }>>;
        compareBeforeEmit: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        module?: boolean | undefined;
        chunkLoading?: string | false | undefined;
        asyncChunks?: boolean | undefined;
        publicPath?: string | ((args_0: PathData, args_1: JsAssetInfo | undefined, ...args: unknown[]) => string) | undefined;
        filename?: string | ((args_0: PathData, args_1: JsAssetInfo | undefined, ...args: unknown[]) => string) | undefined;
        library?: string | string[] | {
            commonjs?: string | undefined;
            amd?: string | undefined;
            root?: string | string[] | undefined;
        } | {
            type: string;
            name?: string | string[] | {
                commonjs?: string | undefined;
                amd?: string | undefined;
                root?: string | string[] | undefined;
            } | undefined;
            amdContainer?: string | undefined;
            auxiliaryComment?: string | {
                commonjs?: string | undefined;
                commonjs2?: string | undefined;
                amd?: string | undefined;
                root?: string | undefined;
            } | undefined;
            export?: string | string[] | undefined;
            umdNamedDefine?: boolean | undefined;
        } | undefined;
        wasmLoading?: string | false | undefined;
        cssHeadDataCompression?: boolean | undefined;
        auxiliaryComment?: string | {
            commonjs?: string | undefined;
            commonjs2?: string | undefined;
            amd?: string | undefined;
            root?: string | undefined;
        } | undefined;
        umdNamedDefine?: boolean | undefined;
        path?: string | undefined;
        pathinfo?: boolean | "verbose" | undefined;
        clean?: boolean | {
            keep?: string | undefined;
        } | undefined;
        chunkFilename?: string | ((args_0: PathData, args_1: JsAssetInfo | undefined, ...args: unknown[]) => string) | undefined;
        crossOriginLoading?: false | "anonymous" | "use-credentials" | undefined;
        cssFilename?: string | ((args_0: PathData, args_1: JsAssetInfo | undefined, ...args: unknown[]) => string) | undefined;
        cssChunkFilename?: string | ((args_0: PathData, args_1: JsAssetInfo | undefined, ...args: unknown[]) => string) | undefined;
        hotUpdateMainFilename?: string | undefined;
        hotUpdateChunkFilename?: string | undefined;
        hotUpdateGlobal?: string | undefined;
        assetModuleFilename?: string | ((args_0: PathData, args_1: JsAssetInfo | undefined, ...args: unknown[]) => string) | undefined;
        uniqueName?: string | undefined;
        chunkLoadingGlobal?: string | undefined;
        enabledLibraryTypes?: string[] | undefined;
        strictModuleErrorHandling?: boolean | undefined;
        globalObject?: string | undefined;
        importFunctionName?: string | undefined;
        importMetaName?: string | undefined;
        iife?: boolean | undefined;
        enabledWasmLoadingTypes?: string[] | undefined;
        webassemblyModuleFilename?: string | undefined;
        chunkFormat?: string | false | undefined;
        enabledChunkLoadingTypes?: string[] | undefined;
        trustedTypes?: string | true | {
            policyName?: string | undefined;
            onPolicyCreationFailure?: "continue" | "stop" | undefined;
        } | undefined;
        sourceMapFilename?: string | undefined;
        hashDigest?: string | undefined;
        hashDigestLength?: number | undefined;
        hashFunction?: "md4" | "xxhash64" | undefined;
        hashSalt?: string | undefined;
        workerChunkLoading?: string | false | undefined;
        workerWasmLoading?: string | false | undefined;
        workerPublicPath?: string | undefined;
        scriptType?: false | "module" | "text/javascript" | undefined;
        devtoolNamespace?: string | undefined;
        devtoolModuleFilenameTemplate?: string | ((args_0: any) => any) | undefined;
        devtoolFallbackModuleFilenameTemplate?: string | ((args_0: any) => any) | undefined;
        environment?: {
            module?: boolean | undefined;
            document?: boolean | undefined;
            nodePrefixForCoreModules?: boolean | undefined;
            globalThis?: boolean | undefined;
            bigIntLiteral?: boolean | undefined;
            const?: boolean | undefined;
            arrowFunction?: boolean | undefined;
            forOf?: boolean | undefined;
            destructuring?: boolean | undefined;
            dynamicImport?: boolean | undefined;
            dynamicImportInWorker?: boolean | undefined;
            optionalChaining?: boolean | undefined;
            templateLiteral?: boolean | undefined;
            asyncFunction?: boolean | undefined;
        } | undefined;
        charset?: boolean | undefined;
        chunkLoadTimeout?: number | undefined;
        compareBeforeEmit?: boolean | undefined;
        libraryExport?: string | string[] | undefined;
        libraryTarget?: string | undefined;
        strictModuleExceptionHandling?: boolean | undefined;
    }, {
        module?: boolean | undefined;
        chunkLoading?: string | false | undefined;
        asyncChunks?: boolean | undefined;
        publicPath?: string | ((args_0: PathData, args_1: JsAssetInfo | undefined, ...args: unknown[]) => string) | undefined;
        filename?: string | ((args_0: PathData, args_1: JsAssetInfo | undefined, ...args: unknown[]) => string) | undefined;
        library?: string | string[] | {
            commonjs?: string | undefined;
            amd?: string | undefined;
            root?: string | string[] | undefined;
        } | {
            type: string;
            name?: string | string[] | {
                commonjs?: string | undefined;
                amd?: string | undefined;
                root?: string | string[] | undefined;
            } | undefined;
            amdContainer?: string | undefined;
            auxiliaryComment?: string | {
                commonjs?: string | undefined;
                commonjs2?: string | undefined;
                amd?: string | undefined;
                root?: string | undefined;
            } | undefined;
            export?: string | string[] | undefined;
            umdNamedDefine?: boolean | undefined;
        } | undefined;
        wasmLoading?: string | false | undefined;
        cssHeadDataCompression?: boolean | undefined;
        auxiliaryComment?: string | {
            commonjs?: string | undefined;
            commonjs2?: string | undefined;
            amd?: string | undefined;
            root?: string | undefined;
        } | undefined;
        umdNamedDefine?: boolean | undefined;
        path?: string | undefined;
        pathinfo?: boolean | "verbose" | undefined;
        clean?: boolean | {
            keep?: string | undefined;
        } | undefined;
        chunkFilename?: string | ((args_0: PathData, args_1: JsAssetInfo | undefined, ...args: unknown[]) => string) | undefined;
        crossOriginLoading?: false | "anonymous" | "use-credentials" | undefined;
        cssFilename?: string | ((args_0: PathData, args_1: JsAssetInfo | undefined, ...args: unknown[]) => string) | undefined;
        cssChunkFilename?: string | ((args_0: PathData, args_1: JsAssetInfo | undefined, ...args: unknown[]) => string) | undefined;
        hotUpdateMainFilename?: string | undefined;
        hotUpdateChunkFilename?: string | undefined;
        hotUpdateGlobal?: string | undefined;
        assetModuleFilename?: string | ((args_0: PathData, args_1: JsAssetInfo | undefined, ...args: unknown[]) => string) | undefined;
        uniqueName?: string | undefined;
        chunkLoadingGlobal?: string | undefined;
        enabledLibraryTypes?: string[] | undefined;
        strictModuleErrorHandling?: boolean | undefined;
        globalObject?: string | undefined;
        importFunctionName?: string | undefined;
        importMetaName?: string | undefined;
        iife?: boolean | undefined;
        enabledWasmLoadingTypes?: string[] | undefined;
        webassemblyModuleFilename?: string | undefined;
        chunkFormat?: string | false | undefined;
        enabledChunkLoadingTypes?: string[] | undefined;
        trustedTypes?: string | true | {
            policyName?: string | undefined;
            onPolicyCreationFailure?: "continue" | "stop" | undefined;
        } | undefined;
        sourceMapFilename?: string | undefined;
        hashDigest?: string | undefined;
        hashDigestLength?: number | undefined;
        hashFunction?: "md4" | "xxhash64" | undefined;
        hashSalt?: string | undefined;
        workerChunkLoading?: string | false | undefined;
        workerWasmLoading?: string | false | undefined;
        workerPublicPath?: string | undefined;
        scriptType?: false | "module" | "text/javascript" | undefined;
        devtoolNamespace?: string | undefined;
        devtoolModuleFilenameTemplate?: string | ((args_0: any) => any) | undefined;
        devtoolFallbackModuleFilenameTemplate?: string | ((args_0: any) => any) | undefined;
        environment?: {
            module?: boolean | undefined;
            document?: boolean | undefined;
            nodePrefixForCoreModules?: boolean | undefined;
            globalThis?: boolean | undefined;
            bigIntLiteral?: boolean | undefined;
            const?: boolean | undefined;
            arrowFunction?: boolean | undefined;
            forOf?: boolean | undefined;
            destructuring?: boolean | undefined;
            dynamicImport?: boolean | undefined;
            dynamicImportInWorker?: boolean | undefined;
            optionalChaining?: boolean | undefined;
            templateLiteral?: boolean | undefined;
            asyncFunction?: boolean | undefined;
        } | undefined;
        charset?: boolean | undefined;
        chunkLoadTimeout?: number | undefined;
        compareBeforeEmit?: boolean | undefined;
        libraryExport?: string | string[] | undefined;
        libraryTarget?: string | undefined;
        strictModuleExceptionHandling?: boolean | undefined;
    }>>;
    target: z.ZodOptional<z.ZodUnion<[z.ZodLiteral<false>, z.ZodUnion<[z.ZodEnum<["web", "webworker", "es3", "es5", "es2015", "es2016", "es2017", "es2018", "es2019", "es2020", "es2021", "es2022"]>, z.ZodLiteral<"node">, z.ZodLiteral<"async-node">, z.ZodType<`node${number}`, z.ZodTypeDef, `node${number}`>, z.ZodType<`async-node${number}`, z.ZodTypeDef, `async-node${number}`>, z.ZodType<`node${number}.${number}`, z.ZodTypeDef, `node${number}.${number}`>, z.ZodType<`async-node${number}.${number}`, z.ZodTypeDef, `async-node${number}.${number}`>, z.ZodLiteral<"electron-main">, z.ZodType<`electron${number}-main`, z.ZodTypeDef, `electron${number}-main`>, z.ZodType<`electron${number}.${number}-main`, z.ZodTypeDef, `electron${number}.${number}-main`>, z.ZodLiteral<"electron-renderer">, z.ZodType<`electron${number}-renderer`, z.ZodTypeDef, `electron${number}-renderer`>, z.ZodType<`electron${number}.${number}-renderer`, z.ZodTypeDef, `electron${number}.${number}-renderer`>, z.ZodLiteral<"electron-preload">, z.ZodType<`electron${number}-preload`, z.ZodTypeDef, `electron${number}-preload`>, z.ZodType<`electron${number}.${number}-preload`, z.ZodTypeDef, `electron${number}.${number}-preload`>, z.ZodLiteral<"nwjs">, z.ZodType<`nwjs${number}`, z.ZodTypeDef, `nwjs${number}`>, z.ZodType<`nwjs${number}.${number}`, z.ZodTypeDef, `nwjs${number}.${number}`>, z.ZodLiteral<"node-webkit">, z.ZodType<`node-webkit${number}`, z.ZodTypeDef, `node-webkit${number}`>, z.ZodType<`node-webkit${number}.${number}`, z.ZodTypeDef, `node-webkit${number}.${number}`>, z.ZodLiteral<"browserslist">, z.ZodType<`browserslist:${string}`, z.ZodTypeDef, `browserslist:${string}`>]>, z.ZodArray<z.ZodUnion<[z.ZodEnum<["web", "webworker", "es3", "es5", "es2015", "es2016", "es2017", "es2018", "es2019", "es2020", "es2021", "es2022"]>, z.ZodLiteral<"node">, z.ZodLiteral<"async-node">, z.ZodType<`node${number}`, z.ZodTypeDef, `node${number}`>, z.ZodType<`async-node${number}`, z.ZodTypeDef, `async-node${number}`>, z.ZodType<`node${number}.${number}`, z.ZodTypeDef, `node${number}.${number}`>, z.ZodType<`async-node${number}.${number}`, z.ZodTypeDef, `async-node${number}.${number}`>, z.ZodLiteral<"electron-main">, z.ZodType<`electron${number}-main`, z.ZodTypeDef, `electron${number}-main`>, z.ZodType<`electron${number}.${number}-main`, z.ZodTypeDef, `electron${number}.${number}-main`>, z.ZodLiteral<"electron-renderer">, z.ZodType<`electron${number}-renderer`, z.ZodTypeDef, `electron${number}-renderer`>, z.ZodType<`electron${number}.${number}-renderer`, z.ZodTypeDef, `electron${number}.${number}-renderer`>, z.ZodLiteral<"electron-preload">, z.ZodType<`electron${number}-preload`, z.ZodTypeDef, `electron${number}-preload`>, z.ZodType<`electron${number}.${number}-preload`, z.ZodTypeDef, `electron${number}.${number}-preload`>, z.ZodLiteral<"nwjs">, z.ZodType<`nwjs${number}`, z.ZodTypeDef, `nwjs${number}`>, z.ZodType<`nwjs${number}.${number}`, z.ZodTypeDef, `nwjs${number}.${number}`>, z.ZodLiteral<"node-webkit">, z.ZodType<`node-webkit${number}`, z.ZodTypeDef, `node-webkit${number}`>, z.ZodType<`node-webkit${number}.${number}`, z.ZodTypeDef, `node-webkit${number}.${number}`>, z.ZodLiteral<"browserslist">, z.ZodType<`browserslist:${string}`, z.ZodTypeDef, `browserslist:${string}`>]>, "many">]>>;
    mode: z.ZodOptional<z.ZodEnum<["development", "production", "none"]>>;
    experiments: z.ZodOptional<z.ZodObject<{
        cache: z.ZodUnion<[z.ZodOptional<z.ZodBoolean>, z.ZodUnion<[z.ZodObject<{
            type: z.ZodEnum<["memory"]>;
        }, "strip", z.ZodTypeAny, {
            type: "memory";
        }, {
            type: "memory";
        }>, z.ZodObject<{
            type: z.ZodEnum<["persistent"]>;
            buildDependencies: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            version: z.ZodOptional<z.ZodString>;
            snapshot: z.ZodOptional<z.ZodObject<{
                immutablePaths: z.ZodOptional<z.ZodArray<z.ZodUnion<[z.ZodString, z.ZodType<RegExp, z.ZodTypeDef, RegExp>]>, "many">>;
                unmanagedPaths: z.ZodOptional<z.ZodArray<z.ZodUnion<[z.ZodString, z.ZodType<RegExp, z.ZodTypeDef, RegExp>]>, "many">>;
                managedPaths: z.ZodOptional<z.ZodArray<z.ZodUnion<[z.ZodString, z.ZodType<RegExp, z.ZodTypeDef, RegExp>]>, "many">>;
            }, "strip", z.ZodTypeAny, {
                immutablePaths?: (string | RegExp)[] | undefined;
                unmanagedPaths?: (string | RegExp)[] | undefined;
                managedPaths?: (string | RegExp)[] | undefined;
            }, {
                immutablePaths?: (string | RegExp)[] | undefined;
                unmanagedPaths?: (string | RegExp)[] | undefined;
                managedPaths?: (string | RegExp)[] | undefined;
            }>>;
            storage: z.ZodOptional<z.ZodObject<{
                type: z.ZodEnum<["filesystem"]>;
                directory: z.ZodOptional<z.ZodString>;
            }, "strip", z.ZodTypeAny, {
                type: "filesystem";
                directory?: string | undefined;
            }, {
                type: "filesystem";
                directory?: string | undefined;
            }>>;
        }, "strip", z.ZodTypeAny, {
            type: "persistent";
            version?: string | undefined;
            snapshot?: {
                immutablePaths?: (string | RegExp)[] | undefined;
                unmanagedPaths?: (string | RegExp)[] | undefined;
                managedPaths?: (string | RegExp)[] | undefined;
            } | undefined;
            buildDependencies?: string[] | undefined;
            storage?: {
                type: "filesystem";
                directory?: string | undefined;
            } | undefined;
        }, {
            type: "persistent";
            version?: string | undefined;
            snapshot?: {
                immutablePaths?: (string | RegExp)[] | undefined;
                unmanagedPaths?: (string | RegExp)[] | undefined;
                managedPaths?: (string | RegExp)[] | undefined;
            } | undefined;
            buildDependencies?: string[] | undefined;
            storage?: {
                type: "filesystem";
                directory?: string | undefined;
            } | undefined;
        }>]>]>;
        lazyCompilation: z.ZodUnion<[z.ZodOptional<z.ZodBoolean>, z.ZodObject<{
            backend: z.ZodOptional<z.ZodObject<{
                client: z.ZodOptional<z.ZodString>;
                listen: z.ZodUnion<[z.ZodOptional<z.ZodNumber>, z.ZodObject<{
                    port: z.ZodOptional<z.ZodNumber>;
                    host: z.ZodOptional<z.ZodString>;
                    backlog: z.ZodOptional<z.ZodNumber>;
                    path: z.ZodOptional<z.ZodString>;
                    exclusive: z.ZodOptional<z.ZodBoolean>;
                    readableAll: z.ZodOptional<z.ZodBoolean>;
                    writableAll: z.ZodOptional<z.ZodBoolean>;
                    ipv6Only: z.ZodOptional<z.ZodBoolean>;
                }, "strip", z.ZodTypeAny, {
                    path?: string | undefined;
                    port?: number | undefined;
                    host?: string | undefined;
                    backlog?: number | undefined;
                    exclusive?: boolean | undefined;
                    readableAll?: boolean | undefined;
                    writableAll?: boolean | undefined;
                    ipv6Only?: boolean | undefined;
                }, {
                    path?: string | undefined;
                    port?: number | undefined;
                    host?: string | undefined;
                    backlog?: number | undefined;
                    exclusive?: boolean | undefined;
                    readableAll?: boolean | undefined;
                    writableAll?: boolean | undefined;
                    ipv6Only?: boolean | undefined;
                }>]>;
                protocol: z.ZodOptional<z.ZodEnum<["http", "https"]>>;
            }, "strip", z.ZodTypeAny, {
                client?: string | undefined;
                listen?: number | {
                    path?: string | undefined;
                    port?: number | undefined;
                    host?: string | undefined;
                    backlog?: number | undefined;
                    exclusive?: boolean | undefined;
                    readableAll?: boolean | undefined;
                    writableAll?: boolean | undefined;
                    ipv6Only?: boolean | undefined;
                } | undefined;
                protocol?: "http" | "https" | undefined;
            }, {
                client?: string | undefined;
                listen?: number | {
                    path?: string | undefined;
                    port?: number | undefined;
                    host?: string | undefined;
                    backlog?: number | undefined;
                    exclusive?: boolean | undefined;
                    readableAll?: boolean | undefined;
                    writableAll?: boolean | undefined;
                    ipv6Only?: boolean | undefined;
                } | undefined;
                protocol?: "http" | "https" | undefined;
            }>>;
            imports: z.ZodOptional<z.ZodBoolean>;
            entries: z.ZodOptional<z.ZodBoolean>;
            test: z.ZodOptional<z.ZodUnion<[z.ZodType<RegExp, z.ZodTypeDef, RegExp>, z.ZodFunction<z.ZodTuple<[z.ZodType<Module, z.ZodTypeDef, Module>], z.ZodUnknown>, z.ZodBoolean>]>>;
        }, "strip", z.ZodTypeAny, {
            entries?: boolean | undefined;
            test?: RegExp | ((args_0: Module, ...args: unknown[]) => boolean) | undefined;
            imports?: boolean | undefined;
            backend?: {
                client?: string | undefined;
                listen?: number | {
                    path?: string | undefined;
                    port?: number | undefined;
                    host?: string | undefined;
                    backlog?: number | undefined;
                    exclusive?: boolean | undefined;
                    readableAll?: boolean | undefined;
                    writableAll?: boolean | undefined;
                    ipv6Only?: boolean | undefined;
                } | undefined;
                protocol?: "http" | "https" | undefined;
            } | undefined;
        }, {
            entries?: boolean | undefined;
            test?: RegExp | ((args_0: Module, ...args: unknown[]) => boolean) | undefined;
            imports?: boolean | undefined;
            backend?: {
                client?: string | undefined;
                listen?: number | {
                    path?: string | undefined;
                    port?: number | undefined;
                    host?: string | undefined;
                    backlog?: number | undefined;
                    exclusive?: boolean | undefined;
                    readableAll?: boolean | undefined;
                    writableAll?: boolean | undefined;
                    ipv6Only?: boolean | undefined;
                } | undefined;
                protocol?: "http" | "https" | undefined;
            } | undefined;
        }>]>;
        asyncWebAssembly: z.ZodOptional<z.ZodBoolean>;
        outputModule: z.ZodOptional<z.ZodBoolean>;
        topLevelAwait: z.ZodOptional<z.ZodBoolean>;
        css: z.ZodOptional<z.ZodBoolean>;
        layers: z.ZodOptional<z.ZodBoolean>;
        incremental: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodObject<{
            make: z.ZodOptional<z.ZodBoolean>;
            inferAsyncModules: z.ZodOptional<z.ZodBoolean>;
            providedExports: z.ZodOptional<z.ZodBoolean>;
            dependenciesDiagnostics: z.ZodOptional<z.ZodBoolean>;
            sideEffects: z.ZodOptional<z.ZodBoolean>;
            buildChunkGraph: z.ZodOptional<z.ZodBoolean>;
            moduleIds: z.ZodOptional<z.ZodBoolean>;
            chunkIds: z.ZodOptional<z.ZodBoolean>;
            modulesHashes: z.ZodOptional<z.ZodBoolean>;
            modulesCodegen: z.ZodOptional<z.ZodBoolean>;
            modulesRuntimeRequirements: z.ZodOptional<z.ZodBoolean>;
            chunksRuntimeRequirements: z.ZodOptional<z.ZodBoolean>;
            chunksHashes: z.ZodOptional<z.ZodBoolean>;
            chunksRender: z.ZodOptional<z.ZodBoolean>;
            emitAssets: z.ZodOptional<z.ZodBoolean>;
        }, "strict", z.ZodTypeAny, {
            providedExports?: boolean | undefined;
            make?: boolean | undefined;
            inferAsyncModules?: boolean | undefined;
            dependenciesDiagnostics?: boolean | undefined;
            sideEffects?: boolean | undefined;
            buildChunkGraph?: boolean | undefined;
            moduleIds?: boolean | undefined;
            chunkIds?: boolean | undefined;
            modulesHashes?: boolean | undefined;
            modulesCodegen?: boolean | undefined;
            modulesRuntimeRequirements?: boolean | undefined;
            chunksRuntimeRequirements?: boolean | undefined;
            chunksHashes?: boolean | undefined;
            chunksRender?: boolean | undefined;
            emitAssets?: boolean | undefined;
        }, {
            providedExports?: boolean | undefined;
            make?: boolean | undefined;
            inferAsyncModules?: boolean | undefined;
            dependenciesDiagnostics?: boolean | undefined;
            sideEffects?: boolean | undefined;
            buildChunkGraph?: boolean | undefined;
            moduleIds?: boolean | undefined;
            chunkIds?: boolean | undefined;
            modulesHashes?: boolean | undefined;
            modulesCodegen?: boolean | undefined;
            modulesRuntimeRequirements?: boolean | undefined;
            chunksRuntimeRequirements?: boolean | undefined;
            chunksHashes?: boolean | undefined;
            chunksRender?: boolean | undefined;
            emitAssets?: boolean | undefined;
        }>]>>;
        futureDefaults: z.ZodOptional<z.ZodBoolean>;
        rspackFuture: z.ZodOptional<z.ZodObject<{
            bundlerInfo: z.ZodOptional<z.ZodObject<{
                version: z.ZodOptional<z.ZodString>;
                bundler: z.ZodOptional<z.ZodString>;
                force: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodArray<z.ZodEnum<["version", "uniqueId"]>, "many">]>>;
            }, "strict", z.ZodTypeAny, {
                version?: string | undefined;
                force?: boolean | ("version" | "uniqueId")[] | undefined;
                bundler?: string | undefined;
            }, {
                version?: string | undefined;
                force?: boolean | ("version" | "uniqueId")[] | undefined;
                bundler?: string | undefined;
            }>>;
        }, "strict", z.ZodTypeAny, {
            bundlerInfo?: {
                version?: string | undefined;
                force?: boolean | ("version" | "uniqueId")[] | undefined;
                bundler?: string | undefined;
            } | undefined;
        }, {
            bundlerInfo?: {
                version?: string | undefined;
                force?: boolean | ("version" | "uniqueId")[] | undefined;
                bundler?: string | undefined;
            } | undefined;
        }>>;
    }, "strict", z.ZodTypeAny, {
        css?: boolean | undefined;
        cache?: boolean | {
            type: "memory";
        } | {
            type: "persistent";
            version?: string | undefined;
            snapshot?: {
                immutablePaths?: (string | RegExp)[] | undefined;
                unmanagedPaths?: (string | RegExp)[] | undefined;
                managedPaths?: (string | RegExp)[] | undefined;
            } | undefined;
            buildDependencies?: string[] | undefined;
            storage?: {
                type: "filesystem";
                directory?: string | undefined;
            } | undefined;
        } | undefined;
        lazyCompilation?: boolean | {
            entries?: boolean | undefined;
            test?: RegExp | ((args_0: Module, ...args: unknown[]) => boolean) | undefined;
            imports?: boolean | undefined;
            backend?: {
                client?: string | undefined;
                listen?: number | {
                    path?: string | undefined;
                    port?: number | undefined;
                    host?: string | undefined;
                    backlog?: number | undefined;
                    exclusive?: boolean | undefined;
                    readableAll?: boolean | undefined;
                    writableAll?: boolean | undefined;
                    ipv6Only?: boolean | undefined;
                } | undefined;
                protocol?: "http" | "https" | undefined;
            } | undefined;
        } | undefined;
        asyncWebAssembly?: boolean | undefined;
        outputModule?: boolean | undefined;
        topLevelAwait?: boolean | undefined;
        layers?: boolean | undefined;
        incremental?: boolean | {
            providedExports?: boolean | undefined;
            make?: boolean | undefined;
            inferAsyncModules?: boolean | undefined;
            dependenciesDiagnostics?: boolean | undefined;
            sideEffects?: boolean | undefined;
            buildChunkGraph?: boolean | undefined;
            moduleIds?: boolean | undefined;
            chunkIds?: boolean | undefined;
            modulesHashes?: boolean | undefined;
            modulesCodegen?: boolean | undefined;
            modulesRuntimeRequirements?: boolean | undefined;
            chunksRuntimeRequirements?: boolean | undefined;
            chunksHashes?: boolean | undefined;
            chunksRender?: boolean | undefined;
            emitAssets?: boolean | undefined;
        } | undefined;
        futureDefaults?: boolean | undefined;
        rspackFuture?: {
            bundlerInfo?: {
                version?: string | undefined;
                force?: boolean | ("version" | "uniqueId")[] | undefined;
                bundler?: string | undefined;
            } | undefined;
        } | undefined;
    }, {
        css?: boolean | undefined;
        cache?: boolean | {
            type: "memory";
        } | {
            type: "persistent";
            version?: string | undefined;
            snapshot?: {
                immutablePaths?: (string | RegExp)[] | undefined;
                unmanagedPaths?: (string | RegExp)[] | undefined;
                managedPaths?: (string | RegExp)[] | undefined;
            } | undefined;
            buildDependencies?: string[] | undefined;
            storage?: {
                type: "filesystem";
                directory?: string | undefined;
            } | undefined;
        } | undefined;
        lazyCompilation?: boolean | {
            entries?: boolean | undefined;
            test?: RegExp | ((args_0: Module, ...args: unknown[]) => boolean) | undefined;
            imports?: boolean | undefined;
            backend?: {
                client?: string | undefined;
                listen?: number | {
                    path?: string | undefined;
                    port?: number | undefined;
                    host?: string | undefined;
                    backlog?: number | undefined;
                    exclusive?: boolean | undefined;
                    readableAll?: boolean | undefined;
                    writableAll?: boolean | undefined;
                    ipv6Only?: boolean | undefined;
                } | undefined;
                protocol?: "http" | "https" | undefined;
            } | undefined;
        } | undefined;
        asyncWebAssembly?: boolean | undefined;
        outputModule?: boolean | undefined;
        topLevelAwait?: boolean | undefined;
        layers?: boolean | undefined;
        incremental?: boolean | {
            providedExports?: boolean | undefined;
            make?: boolean | undefined;
            inferAsyncModules?: boolean | undefined;
            dependenciesDiagnostics?: boolean | undefined;
            sideEffects?: boolean | undefined;
            buildChunkGraph?: boolean | undefined;
            moduleIds?: boolean | undefined;
            chunkIds?: boolean | undefined;
            modulesHashes?: boolean | undefined;
            modulesCodegen?: boolean | undefined;
            modulesRuntimeRequirements?: boolean | undefined;
            chunksRuntimeRequirements?: boolean | undefined;
            chunksHashes?: boolean | undefined;
            chunksRender?: boolean | undefined;
            emitAssets?: boolean | undefined;
        } | undefined;
        futureDefaults?: boolean | undefined;
        rspackFuture?: {
            bundlerInfo?: {
                version?: string | undefined;
                force?: boolean | ("version" | "uniqueId")[] | undefined;
                bundler?: string | undefined;
            } | undefined;
        } | undefined;
    }>>;
    externals: z.ZodOptional<z.ZodUnion<[z.ZodArray<z.ZodUnion<[z.ZodUnion<[z.ZodUnion<[z.ZodUnion<[z.ZodUnion<[z.ZodString, z.ZodType<RegExp, z.ZodTypeDef, RegExp>]>, z.ZodRecord<z.ZodString, z.ZodUnion<[z.ZodUnion<[z.ZodUnion<[z.ZodString, z.ZodBoolean]>, z.ZodArray<z.ZodString, "many">]>, ZodRspackCrossChecker<t.ExternalItemUmdValue | t.ExternalItemObjectValue>]>>]>, z.ZodFunction<z.ZodTuple<[z.ZodType<t.ExternalItemFunctionData, z.ZodTypeDef, t.ExternalItemFunctionData>, z.ZodFunction<z.ZodTuple<[z.ZodOptional<z.ZodType<Error, z.ZodTypeDef, Error>>, z.ZodOptional<z.ZodUnion<[z.ZodUnion<[z.ZodUnion<[z.ZodString, z.ZodBoolean]>, z.ZodArray<z.ZodString, "many">]>, ZodRspackCrossChecker<t.ExternalItemUmdValue | t.ExternalItemObjectValue>]>>, z.ZodOptional<z.ZodEnum<["var", "module", "assign", "this", "window", "self", "global", "commonjs", "commonjs2", "commonjs-module", "commonjs-static", "amd", "amd-require", "umd", "umd2", "jsonp", "system", "promise", "import", "module-import", "script", "node-commonjs", "commonjs-import"]>>], z.ZodUnknown>, z.ZodVoid>], z.ZodUnknown>, z.ZodUnknown>]>, z.ZodFunction<z.ZodTuple<[z.ZodType<t.ExternalItemFunctionData, z.ZodTypeDef, t.ExternalItemFunctionData>], z.ZodUnknown>, z.ZodPromise<z.ZodUnion<[z.ZodUnion<[z.ZodUnion<[z.ZodString, z.ZodBoolean]>, z.ZodArray<z.ZodString, "many">]>, ZodRspackCrossChecker<t.ExternalItemUmdValue | t.ExternalItemObjectValue>]>>>]>, z.ZodFunction<z.ZodTuple<[z.ZodType<t.ExternalItemFunctionData, z.ZodTypeDef, t.ExternalItemFunctionData>], z.ZodUnknown>, z.ZodUnion<[z.ZodUnion<[z.ZodUnion<[z.ZodString, z.ZodBoolean]>, z.ZodArray<z.ZodString, "many">]>, ZodRspackCrossChecker<t.ExternalItemUmdValue | t.ExternalItemObjectValue>]>>]>, "many">, z.ZodUnion<[z.ZodUnion<[z.ZodUnion<[z.ZodUnion<[z.ZodUnion<[z.ZodString, z.ZodType<RegExp, z.ZodTypeDef, RegExp>]>, z.ZodRecord<z.ZodString, z.ZodUnion<[z.ZodUnion<[z.ZodUnion<[z.ZodString, z.ZodBoolean]>, z.ZodArray<z.ZodString, "many">]>, ZodRspackCrossChecker<t.ExternalItemUmdValue | t.ExternalItemObjectValue>]>>]>, z.ZodFunction<z.ZodTuple<[z.ZodType<t.ExternalItemFunctionData, z.ZodTypeDef, t.ExternalItemFunctionData>, z.ZodFunction<z.ZodTuple<[z.ZodOptional<z.ZodType<Error, z.ZodTypeDef, Error>>, z.ZodOptional<z.ZodUnion<[z.ZodUnion<[z.ZodUnion<[z.ZodString, z.ZodBoolean]>, z.ZodArray<z.ZodString, "many">]>, ZodRspackCrossChecker<t.ExternalItemUmdValue | t.ExternalItemObjectValue>]>>, z.ZodOptional<z.ZodEnum<["var", "module", "assign", "this", "window", "self", "global", "commonjs", "commonjs2", "commonjs-module", "commonjs-static", "amd", "amd-require", "umd", "umd2", "jsonp", "system", "promise", "import", "module-import", "script", "node-commonjs", "commonjs-import"]>>], z.ZodUnknown>, z.ZodVoid>], z.ZodUnknown>, z.ZodUnknown>]>, z.ZodFunction<z.ZodTuple<[z.ZodType<t.ExternalItemFunctionData, z.ZodTypeDef, t.ExternalItemFunctionData>], z.ZodUnknown>, z.ZodPromise<z.ZodUnion<[z.ZodUnion<[z.ZodUnion<[z.ZodString, z.ZodBoolean]>, z.ZodArray<z.ZodString, "many">]>, ZodRspackCrossChecker<t.ExternalItemUmdValue | t.ExternalItemObjectValue>]>>>]>, z.ZodFunction<z.ZodTuple<[z.ZodType<t.ExternalItemFunctionData, z.ZodTypeDef, t.ExternalItemFunctionData>], z.ZodUnknown>, z.ZodUnion<[z.ZodUnion<[z.ZodUnion<[z.ZodString, z.ZodBoolean]>, z.ZodArray<z.ZodString, "many">]>, ZodRspackCrossChecker<t.ExternalItemUmdValue | t.ExternalItemObjectValue>]>>]>]>>;
    externalsType: z.ZodOptional<z.ZodEnum<["var", "module", "assign", "this", "window", "self", "global", "commonjs", "commonjs2", "commonjs-module", "commonjs-static", "amd", "amd-require", "umd", "umd2", "jsonp", "system", "promise", "import", "module-import", "script", "node-commonjs", "commonjs-import"]>>;
    externalsPresets: z.ZodOptional<z.ZodObject<{
        node: z.ZodOptional<z.ZodBoolean>;
        web: z.ZodOptional<z.ZodBoolean>;
        webAsync: z.ZodOptional<z.ZodBoolean>;
        electron: z.ZodOptional<z.ZodBoolean>;
        electronMain: z.ZodOptional<z.ZodBoolean>;
        electronPreload: z.ZodOptional<z.ZodBoolean>;
        electronRenderer: z.ZodOptional<z.ZodBoolean>;
        nwjs: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        web?: boolean | undefined;
        node?: boolean | undefined;
        nwjs?: boolean | undefined;
        electron?: boolean | undefined;
        electronMain?: boolean | undefined;
        electronPreload?: boolean | undefined;
        electronRenderer?: boolean | undefined;
        webAsync?: boolean | undefined;
    }, {
        web?: boolean | undefined;
        node?: boolean | undefined;
        nwjs?: boolean | undefined;
        electron?: boolean | undefined;
        electronMain?: boolean | undefined;
        electronPreload?: boolean | undefined;
        electronRenderer?: boolean | undefined;
        webAsync?: boolean | undefined;
    }>>;
    infrastructureLogging: z.ZodOptional<z.ZodObject<{
        appendOnly: z.ZodOptional<z.ZodBoolean>;
        colors: z.ZodOptional<z.ZodBoolean>;
        console: z.ZodOptional<z.ZodType<Console, z.ZodTypeDef, Console>>;
        debug: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodUnion<[z.ZodArray<z.ZodUnion<[z.ZodUnion<[z.ZodType<RegExp, z.ZodTypeDef, RegExp>, z.ZodString]>, z.ZodFunction<z.ZodTuple<[z.ZodString], z.ZodUnknown>, z.ZodBoolean>]>, "many">, z.ZodUnion<[z.ZodUnion<[z.ZodType<RegExp, z.ZodTypeDef, RegExp>, z.ZodString]>, z.ZodFunction<z.ZodTuple<[z.ZodString], z.ZodUnknown>, z.ZodBoolean>]>]>]>>;
        level: z.ZodOptional<z.ZodEnum<["none", "error", "warn", "info", "log", "verbose"]>>;
        stream: z.ZodOptional<z.ZodType<NodeJS.WritableStream, z.ZodTypeDef, NodeJS.WritableStream>>;
    }, "strict", z.ZodTypeAny, {
        debug?: string | boolean | RegExp | ((args_0: string, ...args: unknown[]) => boolean) | (string | RegExp | ((args_0: string, ...args: unknown[]) => boolean))[] | undefined;
        colors?: boolean | undefined;
        stream?: NodeJS.WritableStream | undefined;
        appendOnly?: boolean | undefined;
        console?: Console | undefined;
        level?: "error" | "warn" | "info" | "log" | "none" | "verbose" | undefined;
    }, {
        debug?: string | boolean | RegExp | ((args_0: string, ...args: unknown[]) => boolean) | (string | RegExp | ((args_0: string, ...args: unknown[]) => boolean))[] | undefined;
        colors?: boolean | undefined;
        stream?: NodeJS.WritableStream | undefined;
        appendOnly?: boolean | undefined;
        console?: Console | undefined;
        level?: "error" | "warn" | "info" | "log" | "none" | "verbose" | undefined;
    }>>;
    cache: z.ZodOptional<z.ZodBoolean>;
    context: z.ZodOptional<z.ZodEffects<z.ZodString, string, string>>;
    devtool: z.ZodOptional<z.ZodUnion<[z.ZodLiteral<false>, z.ZodEnum<["eval", "cheap-source-map", "cheap-module-source-map", "source-map", "inline-cheap-source-map", "inline-cheap-module-source-map", "inline-source-map", "inline-nosources-cheap-source-map", "inline-nosources-cheap-module-source-map", "inline-nosources-source-map", "nosources-cheap-source-map", "nosources-cheap-module-source-map", "nosources-source-map", "hidden-nosources-cheap-source-map", "hidden-nosources-cheap-module-source-map", "hidden-nosources-source-map", "hidden-cheap-source-map", "hidden-cheap-module-source-map", "hidden-source-map", "eval-cheap-source-map", "eval-cheap-module-source-map", "eval-source-map", "eval-nosources-cheap-source-map", "eval-nosources-cheap-module-source-map", "eval-nosources-source-map"]>]>>;
    node: z.ZodOptional<z.ZodUnion<[z.ZodLiteral<false>, z.ZodObject<{
        __dirname: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodEnum<["warn-mock", "mock", "eval-only", "node-module"]>]>>;
        __filename: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodEnum<["warn-mock", "mock", "eval-only", "node-module"]>]>>;
        global: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodLiteral<"warn">]>>;
    }, "strict", z.ZodTypeAny, {
        global?: boolean | "warn" | undefined;
        __dirname?: boolean | "warn-mock" | "mock" | "eval-only" | "node-module" | undefined;
        __filename?: boolean | "warn-mock" | "mock" | "eval-only" | "node-module" | undefined;
    }, {
        global?: boolean | "warn" | undefined;
        __dirname?: boolean | "warn-mock" | "mock" | "eval-only" | "node-module" | undefined;
        __filename?: boolean | "warn-mock" | "mock" | "eval-only" | "node-module" | undefined;
    }>]>>;
    loader: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodAny>>;
    ignoreWarnings: z.ZodOptional<z.ZodArray<z.ZodUnion<[z.ZodType<RegExp, z.ZodTypeDef, RegExp>, z.ZodFunction<z.ZodTuple<[z.ZodType<Error, z.ZodTypeDef, Error>, z.ZodType<Compilation, z.ZodTypeDef, Compilation>], z.ZodUnknown>, z.ZodBoolean>]>, "many">>;
    watchOptions: z.ZodOptional<z.ZodObject<{
        aggregateTimeout: z.ZodOptional<z.ZodNumber>;
        followSymlinks: z.ZodOptional<z.ZodBoolean>;
        ignored: z.ZodOptional<z.ZodUnion<[z.ZodUnion<[z.ZodArray<z.ZodString, "many">, z.ZodType<RegExp, z.ZodTypeDef, RegExp>]>, z.ZodString]>>;
        poll: z.ZodOptional<z.ZodUnion<[z.ZodNumber, z.ZodBoolean]>>;
        stdin: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        aggregateTimeout?: number | undefined;
        followSymlinks?: boolean | undefined;
        ignored?: string | RegExp | string[] | undefined;
        poll?: number | boolean | undefined;
        stdin?: boolean | undefined;
    }, {
        aggregateTimeout?: number | undefined;
        followSymlinks?: boolean | undefined;
        ignored?: string | RegExp | string[] | undefined;
        poll?: number | boolean | undefined;
        stdin?: boolean | undefined;
    }>>;
    watch: z.ZodOptional<z.ZodBoolean>;
    stats: z.ZodOptional<z.ZodUnion<[z.ZodUnion<[z.ZodBoolean, z.ZodEnum<["normal", "none", "verbose", "errors-only", "errors-warnings", "minimal", "detailed", "summary"]>]>, z.ZodObject<{
        all: z.ZodOptional<z.ZodBoolean>;
        preset: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodEnum<["normal", "none", "verbose", "errors-only", "errors-warnings", "minimal", "detailed", "summary"]>]>>;
        assets: z.ZodOptional<z.ZodBoolean>;
        chunks: z.ZodOptional<z.ZodBoolean>;
        modules: z.ZodOptional<z.ZodBoolean>;
        entrypoints: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodLiteral<"auto">]>>;
        chunkGroups: z.ZodOptional<z.ZodBoolean>;
        warnings: z.ZodOptional<z.ZodBoolean>;
        warningsCount: z.ZodOptional<z.ZodBoolean>;
        errors: z.ZodOptional<z.ZodBoolean>;
        errorsCount: z.ZodOptional<z.ZodBoolean>;
        colors: z.ZodOptional<z.ZodBoolean>;
        hash: z.ZodOptional<z.ZodBoolean>;
        version: z.ZodOptional<z.ZodBoolean>;
        reasons: z.ZodOptional<z.ZodBoolean>;
        publicPath: z.ZodOptional<z.ZodBoolean>;
        outputPath: z.ZodOptional<z.ZodBoolean>;
        chunkModules: z.ZodOptional<z.ZodBoolean>;
        chunkRelations: z.ZodOptional<z.ZodBoolean>;
        ids: z.ZodOptional<z.ZodBoolean>;
        timings: z.ZodOptional<z.ZodBoolean>;
        builtAt: z.ZodOptional<z.ZodBoolean>;
        moduleAssets: z.ZodOptional<z.ZodBoolean>;
        nestedModules: z.ZodOptional<z.ZodBoolean>;
        source: z.ZodOptional<z.ZodBoolean>;
        logging: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["none", "error", "warn", "info", "log", "verbose"]>, z.ZodBoolean]>>;
        loggingDebug: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodUnion<[z.ZodArray<z.ZodUnion<[z.ZodUnion<[z.ZodType<RegExp, z.ZodTypeDef, RegExp>, z.ZodString]>, z.ZodFunction<z.ZodTuple<[z.ZodString], z.ZodUnknown>, z.ZodBoolean>]>, "many">, z.ZodUnion<[z.ZodUnion<[z.ZodType<RegExp, z.ZodTypeDef, RegExp>, z.ZodString]>, z.ZodFunction<z.ZodTuple<[z.ZodString], z.ZodUnknown>, z.ZodBoolean>]>]>]>>;
        loggingTrace: z.ZodOptional<z.ZodBoolean>;
        runtimeModules: z.ZodOptional<z.ZodBoolean>;
        children: z.ZodOptional<z.ZodBoolean>;
        usedExports: z.ZodOptional<z.ZodBoolean>;
        providedExports: z.ZodOptional<z.ZodBoolean>;
        optimizationBailout: z.ZodOptional<z.ZodBoolean>;
        groupModulesByType: z.ZodOptional<z.ZodBoolean>;
        groupModulesByCacheStatus: z.ZodOptional<z.ZodBoolean>;
        groupModulesByLayer: z.ZodOptional<z.ZodBoolean>;
        groupModulesByAttributes: z.ZodOptional<z.ZodBoolean>;
        groupModulesByPath: z.ZodOptional<z.ZodBoolean>;
        groupModulesByExtension: z.ZodOptional<z.ZodBoolean>;
        modulesSpace: z.ZodOptional<z.ZodNumber>;
        chunkModulesSpace: z.ZodOptional<z.ZodNumber>;
        nestedModulesSpace: z.ZodOptional<z.ZodNumber>;
        relatedAssets: z.ZodOptional<z.ZodBoolean>;
        groupAssetsByEmitStatus: z.ZodOptional<z.ZodBoolean>;
        groupAssetsByInfo: z.ZodOptional<z.ZodBoolean>;
        groupAssetsByPath: z.ZodOptional<z.ZodBoolean>;
        groupAssetsByExtension: z.ZodOptional<z.ZodBoolean>;
        groupAssetsByChunk: z.ZodOptional<z.ZodBoolean>;
        assetsSpace: z.ZodOptional<z.ZodNumber>;
        orphanModules: z.ZodOptional<z.ZodBoolean>;
        excludeModules: z.ZodOptional<z.ZodUnion<[z.ZodUnion<[z.ZodUnion<[z.ZodUnion<[z.ZodArray<z.ZodUnion<[z.ZodUnion<[z.ZodString, z.ZodType<RegExp, z.ZodTypeDef, RegExp>]>, z.ZodFunction<z.ZodTuple<[z.ZodString, z.ZodAny, z.ZodAny], null>, z.ZodBoolean>]>, "many">, z.ZodString]>, z.ZodType<RegExp, z.ZodTypeDef, RegExp>]>, z.ZodFunction<z.ZodTuple<[z.ZodString, z.ZodAny, z.ZodAny], null>, z.ZodBoolean>]>, z.ZodBoolean]>>;
        excludeAssets: z.ZodOptional<z.ZodUnion<[z.ZodUnion<[z.ZodUnion<[z.ZodArray<z.ZodUnion<[z.ZodUnion<[z.ZodString, z.ZodType<RegExp, z.ZodTypeDef, RegExp>]>, z.ZodFunction<z.ZodTuple<[z.ZodString, z.ZodAny], null>, z.ZodBoolean>]>, "many">, z.ZodString]>, z.ZodType<RegExp, z.ZodTypeDef, RegExp>]>, z.ZodFunction<z.ZodTuple<[z.ZodString, z.ZodAny], null>, z.ZodBoolean>]>>;
        modulesSort: z.ZodOptional<z.ZodString>;
        chunkModulesSort: z.ZodOptional<z.ZodString>;
        nestedModulesSort: z.ZodOptional<z.ZodString>;
        chunksSort: z.ZodOptional<z.ZodString>;
        assetsSort: z.ZodOptional<z.ZodString>;
        performance: z.ZodOptional<z.ZodBoolean>;
        env: z.ZodOptional<z.ZodBoolean>;
        chunkGroupAuxiliary: z.ZodOptional<z.ZodBoolean>;
        chunkGroupChildren: z.ZodOptional<z.ZodBoolean>;
        chunkGroupMaxAssets: z.ZodOptional<z.ZodNumber>;
        dependentModules: z.ZodOptional<z.ZodBoolean>;
        chunkOrigins: z.ZodOptional<z.ZodBoolean>;
        runtime: z.ZodOptional<z.ZodBoolean>;
        depth: z.ZodOptional<z.ZodBoolean>;
        reasonsSpace: z.ZodOptional<z.ZodNumber>;
        groupReasonsByOrigin: z.ZodOptional<z.ZodBoolean>;
        errorDetails: z.ZodOptional<z.ZodBoolean>;
        errorStack: z.ZodOptional<z.ZodBoolean>;
        moduleTrace: z.ZodOptional<z.ZodBoolean>;
        cachedModules: z.ZodOptional<z.ZodBoolean>;
        cachedAssets: z.ZodOptional<z.ZodBoolean>;
        cached: z.ZodOptional<z.ZodBoolean>;
        errorsSpace: z.ZodOptional<z.ZodNumber>;
        warningsSpace: z.ZodOptional<z.ZodNumber>;
    }, "strict", z.ZodTypeAny, {
        modules?: boolean | undefined;
        chunks?: boolean | undefined;
        ids?: boolean | undefined;
        runtime?: boolean | undefined;
        hash?: boolean | undefined;
        all?: boolean | undefined;
        version?: boolean | undefined;
        publicPath?: boolean | undefined;
        preset?: boolean | "none" | "verbose" | "normal" | "errors-only" | "errors-warnings" | "minimal" | "detailed" | "summary" | undefined;
        assets?: boolean | undefined;
        entrypoints?: boolean | "auto" | undefined;
        chunkGroups?: boolean | undefined;
        warnings?: boolean | undefined;
        warningsCount?: boolean | undefined;
        errors?: boolean | undefined;
        errorsCount?: boolean | undefined;
        colors?: boolean | undefined;
        reasons?: boolean | undefined;
        outputPath?: boolean | undefined;
        chunkModules?: boolean | undefined;
        chunkRelations?: boolean | undefined;
        timings?: boolean | undefined;
        builtAt?: boolean | undefined;
        moduleAssets?: boolean | undefined;
        nestedModules?: boolean | undefined;
        source?: boolean | undefined;
        logging?: boolean | "error" | "warn" | "info" | "log" | "none" | "verbose" | undefined;
        loggingDebug?: string | boolean | RegExp | ((args_0: string, ...args: unknown[]) => boolean) | (string | RegExp | ((args_0: string, ...args: unknown[]) => boolean))[] | undefined;
        loggingTrace?: boolean | undefined;
        runtimeModules?: boolean | undefined;
        children?: boolean | undefined;
        usedExports?: boolean | undefined;
        providedExports?: boolean | undefined;
        optimizationBailout?: boolean | undefined;
        groupModulesByType?: boolean | undefined;
        groupModulesByCacheStatus?: boolean | undefined;
        groupModulesByLayer?: boolean | undefined;
        groupModulesByAttributes?: boolean | undefined;
        groupModulesByPath?: boolean | undefined;
        groupModulesByExtension?: boolean | undefined;
        modulesSpace?: number | undefined;
        chunkModulesSpace?: number | undefined;
        nestedModulesSpace?: number | undefined;
        relatedAssets?: boolean | undefined;
        groupAssetsByEmitStatus?: boolean | undefined;
        groupAssetsByInfo?: boolean | undefined;
        groupAssetsByPath?: boolean | undefined;
        groupAssetsByExtension?: boolean | undefined;
        groupAssetsByChunk?: boolean | undefined;
        assetsSpace?: number | undefined;
        orphanModules?: boolean | undefined;
        excludeModules?: string | boolean | RegExp | ((args_0: string, args_1: any, args_2: any) => boolean) | (string | RegExp | ((args_0: string, args_1: any, args_2: any) => boolean))[] | undefined;
        excludeAssets?: string | RegExp | ((args_0: string, args_1: any) => boolean) | (string | RegExp | ((args_0: string, args_1: any) => boolean))[] | undefined;
        modulesSort?: string | undefined;
        chunkModulesSort?: string | undefined;
        nestedModulesSort?: string | undefined;
        chunksSort?: string | undefined;
        assetsSort?: string | undefined;
        performance?: boolean | undefined;
        env?: boolean | undefined;
        chunkGroupAuxiliary?: boolean | undefined;
        chunkGroupChildren?: boolean | undefined;
        chunkGroupMaxAssets?: number | undefined;
        dependentModules?: boolean | undefined;
        chunkOrigins?: boolean | undefined;
        depth?: boolean | undefined;
        reasonsSpace?: number | undefined;
        groupReasonsByOrigin?: boolean | undefined;
        errorDetails?: boolean | undefined;
        errorStack?: boolean | undefined;
        moduleTrace?: boolean | undefined;
        cachedModules?: boolean | undefined;
        cachedAssets?: boolean | undefined;
        cached?: boolean | undefined;
        errorsSpace?: number | undefined;
        warningsSpace?: number | undefined;
    }, {
        modules?: boolean | undefined;
        chunks?: boolean | undefined;
        ids?: boolean | undefined;
        runtime?: boolean | undefined;
        hash?: boolean | undefined;
        all?: boolean | undefined;
        version?: boolean | undefined;
        publicPath?: boolean | undefined;
        preset?: boolean | "none" | "verbose" | "normal" | "errors-only" | "errors-warnings" | "minimal" | "detailed" | "summary" | undefined;
        assets?: boolean | undefined;
        entrypoints?: boolean | "auto" | undefined;
        chunkGroups?: boolean | undefined;
        warnings?: boolean | undefined;
        warningsCount?: boolean | undefined;
        errors?: boolean | undefined;
        errorsCount?: boolean | undefined;
        colors?: boolean | undefined;
        reasons?: boolean | undefined;
        outputPath?: boolean | undefined;
        chunkModules?: boolean | undefined;
        chunkRelations?: boolean | undefined;
        timings?: boolean | undefined;
        builtAt?: boolean | undefined;
        moduleAssets?: boolean | undefined;
        nestedModules?: boolean | undefined;
        source?: boolean | undefined;
        logging?: boolean | "error" | "warn" | "info" | "log" | "none" | "verbose" | undefined;
        loggingDebug?: string | boolean | RegExp | ((args_0: string, ...args: unknown[]) => boolean) | (string | RegExp | ((args_0: string, ...args: unknown[]) => boolean))[] | undefined;
        loggingTrace?: boolean | undefined;
        runtimeModules?: boolean | undefined;
        children?: boolean | undefined;
        usedExports?: boolean | undefined;
        providedExports?: boolean | undefined;
        optimizationBailout?: boolean | undefined;
        groupModulesByType?: boolean | undefined;
        groupModulesByCacheStatus?: boolean | undefined;
        groupModulesByLayer?: boolean | undefined;
        groupModulesByAttributes?: boolean | undefined;
        groupModulesByPath?: boolean | undefined;
        groupModulesByExtension?: boolean | undefined;
        modulesSpace?: number | undefined;
        chunkModulesSpace?: number | undefined;
        nestedModulesSpace?: number | undefined;
        relatedAssets?: boolean | undefined;
        groupAssetsByEmitStatus?: boolean | undefined;
        groupAssetsByInfo?: boolean | undefined;
        groupAssetsByPath?: boolean | undefined;
        groupAssetsByExtension?: boolean | undefined;
        groupAssetsByChunk?: boolean | undefined;
        assetsSpace?: number | undefined;
        orphanModules?: boolean | undefined;
        excludeModules?: string | boolean | RegExp | ((args_0: string, args_1: any, args_2: any) => boolean) | (string | RegExp | ((args_0: string, args_1: any, args_2: any) => boolean))[] | undefined;
        excludeAssets?: string | RegExp | ((args_0: string, args_1: any) => boolean) | (string | RegExp | ((args_0: string, args_1: any) => boolean))[] | undefined;
        modulesSort?: string | undefined;
        chunkModulesSort?: string | undefined;
        nestedModulesSort?: string | undefined;
        chunksSort?: string | undefined;
        assetsSort?: string | undefined;
        performance?: boolean | undefined;
        env?: boolean | undefined;
        chunkGroupAuxiliary?: boolean | undefined;
        chunkGroupChildren?: boolean | undefined;
        chunkGroupMaxAssets?: number | undefined;
        dependentModules?: boolean | undefined;
        chunkOrigins?: boolean | undefined;
        depth?: boolean | undefined;
        reasonsSpace?: number | undefined;
        groupReasonsByOrigin?: boolean | undefined;
        errorDetails?: boolean | undefined;
        errorStack?: boolean | undefined;
        moduleTrace?: boolean | undefined;
        cachedModules?: boolean | undefined;
        cachedAssets?: boolean | undefined;
        cached?: boolean | undefined;
        errorsSpace?: number | undefined;
        warningsSpace?: number | undefined;
    }>]>>;
    snapshot: z.ZodOptional<z.ZodObject<{}, "strict", z.ZodTypeAny, {}, {}>>;
    optimization: z.ZodOptional<z.ZodObject<{
        moduleIds: z.ZodOptional<z.ZodEnum<["named", "natural", "deterministic"]>>;
        chunkIds: z.ZodOptional<z.ZodEnum<["natural", "named", "deterministic", "size", "total-size"]>>;
        minimize: z.ZodOptional<z.ZodBoolean>;
        minimizer: z.ZodOptional<z.ZodArray<z.ZodUnion<[z.ZodLiteral<"...">, z.ZodUnion<[z.ZodType<t.RspackPluginInstance | t.WebpackPluginInstance | t.RspackPluginFunction | t.WebpackPluginFunction, z.ZodTypeDef, t.RspackPluginInstance | t.WebpackPluginInstance | t.RspackPluginFunction | t.WebpackPluginFunction>, z.ZodUnion<[z.ZodLiteral<false>, z.ZodLiteral<0>, z.ZodLiteral<"">, z.ZodNull, z.ZodUndefined]>]>]>, "many">>;
        mergeDuplicateChunks: z.ZodOptional<z.ZodBoolean>;
        splitChunks: z.ZodOptional<z.ZodUnion<[z.ZodLiteral<false>, z.ZodObject<{
            chunks: z.ZodOptional<z.ZodUnion<[z.ZodUnion<[z.ZodEnum<["initial", "async", "all"]>, z.ZodType<RegExp, z.ZodTypeDef, RegExp>]>, z.ZodFunction<z.ZodTuple<[z.ZodType<Chunk, z.ZodTypeDef, Chunk>], z.ZodUnknown>, z.ZodBoolean>]>>;
            defaultSizeTypes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            minChunks: z.ZodOptional<z.ZodNumber>;
            usedExports: z.ZodOptional<z.ZodBoolean>;
            name: z.ZodOptional<z.ZodUnion<[z.ZodUnion<[z.ZodString, z.ZodLiteral<false>]>, z.ZodFunction<z.ZodTuple<[z.ZodOptional<z.ZodType<Module, z.ZodTypeDef, Module>>], z.ZodUnknown>, z.ZodUnknown>]>>;
            minSize: z.ZodOptional<z.ZodUnion<[z.ZodNumber, z.ZodRecord<z.ZodString, z.ZodNumber>]>>;
            maxSize: z.ZodOptional<z.ZodUnion<[z.ZodNumber, z.ZodRecord<z.ZodString, z.ZodNumber>]>>;
            maxAsyncSize: z.ZodOptional<z.ZodUnion<[z.ZodNumber, z.ZodRecord<z.ZodString, z.ZodNumber>]>>;
            maxInitialSize: z.ZodOptional<z.ZodUnion<[z.ZodNumber, z.ZodRecord<z.ZodString, z.ZodNumber>]>>;
            maxAsyncRequests: z.ZodOptional<z.ZodNumber>;
            maxInitialRequests: z.ZodOptional<z.ZodNumber>;
            automaticNameDelimiter: z.ZodOptional<z.ZodString>;
            cacheGroups: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnion<[z.ZodLiteral<false>, z.ZodObject<{
                chunks: z.ZodOptional<z.ZodUnion<[z.ZodUnion<[z.ZodEnum<["initial", "async", "all"]>, z.ZodType<RegExp, z.ZodTypeDef, RegExp>]>, z.ZodFunction<z.ZodTuple<[z.ZodType<Chunk, z.ZodTypeDef, Chunk>], z.ZodUnknown>, z.ZodBoolean>]>>;
                defaultSizeTypes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
                minChunks: z.ZodOptional<z.ZodNumber>;
                usedExports: z.ZodOptional<z.ZodBoolean>;
                name: z.ZodOptional<z.ZodUnion<[z.ZodUnion<[z.ZodString, z.ZodLiteral<false>]>, z.ZodFunction<z.ZodTuple<[z.ZodOptional<z.ZodType<Module, z.ZodTypeDef, Module>>], z.ZodUnknown>, z.ZodUnknown>]>>;
                minSize: z.ZodOptional<z.ZodUnion<[z.ZodNumber, z.ZodRecord<z.ZodString, z.ZodNumber>]>>;
                maxSize: z.ZodOptional<z.ZodUnion<[z.ZodNumber, z.ZodRecord<z.ZodString, z.ZodNumber>]>>;
                maxAsyncSize: z.ZodOptional<z.ZodUnion<[z.ZodNumber, z.ZodRecord<z.ZodString, z.ZodNumber>]>>;
                maxInitialSize: z.ZodOptional<z.ZodUnion<[z.ZodNumber, z.ZodRecord<z.ZodString, z.ZodNumber>]>>;
                maxAsyncRequests: z.ZodOptional<z.ZodNumber>;
                maxInitialRequests: z.ZodOptional<z.ZodNumber>;
                automaticNameDelimiter: z.ZodOptional<z.ZodString>;
                test: z.ZodOptional<z.ZodUnion<[z.ZodUnion<[z.ZodString, z.ZodType<RegExp, z.ZodTypeDef, RegExp>]>, z.ZodFunction<z.ZodTuple<[z.ZodType<Module, z.ZodTypeDef, Module>], z.ZodUnknown>, z.ZodUnknown>]>>;
                priority: z.ZodOptional<z.ZodNumber>;
                enforce: z.ZodOptional<z.ZodBoolean>;
                filename: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodFunction<z.ZodTuple<[z.ZodType<PathData, z.ZodTypeDef, PathData>, z.ZodOptional<z.ZodType<JsAssetInfo, z.ZodTypeDef, JsAssetInfo>>], z.ZodUnknown>, z.ZodString>]>>;
                reuseExistingChunk: z.ZodOptional<z.ZodBoolean>;
                type: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodType<RegExp, z.ZodTypeDef, RegExp>]>>;
                idHint: z.ZodOptional<z.ZodString>;
            }, "strict", z.ZodTypeAny, {
                type?: string | RegExp | undefined;
                chunks?: RegExp | "initial" | "async" | "all" | ((args_0: Chunk, ...args: unknown[]) => boolean) | undefined;
                name?: string | false | ((args_0: Module | undefined, ...args: unknown[]) => unknown) | undefined;
                filename?: string | ((args_0: PathData, args_1: JsAssetInfo | undefined, ...args: unknown[]) => string) | undefined;
                usedExports?: boolean | undefined;
                defaultSizeTypes?: string[] | undefined;
                maxSize?: number | Record<string, number> | undefined;
                priority?: number | undefined;
                minSize?: number | Record<string, number> | undefined;
                maxAsyncSize?: number | Record<string, number> | undefined;
                maxInitialSize?: number | Record<string, number> | undefined;
                minChunks?: number | undefined;
                maxAsyncRequests?: number | undefined;
                maxInitialRequests?: number | undefined;
                automaticNameDelimiter?: string | undefined;
                test?: string | RegExp | ((args_0: Module, ...args: unknown[]) => unknown) | undefined;
                enforce?: boolean | undefined;
                reuseExistingChunk?: boolean | undefined;
                idHint?: string | undefined;
            }, {
                type?: string | RegExp | undefined;
                chunks?: RegExp | "initial" | "async" | "all" | ((args_0: Chunk, ...args: unknown[]) => boolean) | undefined;
                name?: string | false | ((args_0: Module | undefined, ...args: unknown[]) => unknown) | undefined;
                filename?: string | ((args_0: PathData, args_1: JsAssetInfo | undefined, ...args: unknown[]) => string) | undefined;
                usedExports?: boolean | undefined;
                defaultSizeTypes?: string[] | undefined;
                maxSize?: number | Record<string, number> | undefined;
                priority?: number | undefined;
                minSize?: number | Record<string, number> | undefined;
                maxAsyncSize?: number | Record<string, number> | undefined;
                maxInitialSize?: number | Record<string, number> | undefined;
                minChunks?: number | undefined;
                maxAsyncRequests?: number | undefined;
                maxInitialRequests?: number | undefined;
                automaticNameDelimiter?: string | undefined;
                test?: string | RegExp | ((args_0: Module, ...args: unknown[]) => unknown) | undefined;
                enforce?: boolean | undefined;
                reuseExistingChunk?: boolean | undefined;
                idHint?: string | undefined;
            }>]>>>;
            fallbackCacheGroup: z.ZodOptional<z.ZodObject<{
                chunks: z.ZodOptional<z.ZodUnion<[z.ZodUnion<[z.ZodEnum<["initial", "async", "all"]>, z.ZodType<RegExp, z.ZodTypeDef, RegExp>]>, z.ZodFunction<z.ZodTuple<[z.ZodType<Chunk, z.ZodTypeDef, Chunk>], z.ZodUnknown>, z.ZodBoolean>]>>;
                minSize: z.ZodOptional<z.ZodNumber>;
                maxSize: z.ZodOptional<z.ZodNumber>;
                maxAsyncSize: z.ZodOptional<z.ZodNumber>;
                maxInitialSize: z.ZodOptional<z.ZodNumber>;
                automaticNameDelimiter: z.ZodOptional<z.ZodString>;
            }, "strict", z.ZodTypeAny, {
                chunks?: RegExp | "initial" | "async" | "all" | ((args_0: Chunk, ...args: unknown[]) => boolean) | undefined;
                maxSize?: number | undefined;
                minSize?: number | undefined;
                maxAsyncSize?: number | undefined;
                maxInitialSize?: number | undefined;
                automaticNameDelimiter?: string | undefined;
            }, {
                chunks?: RegExp | "initial" | "async" | "all" | ((args_0: Chunk, ...args: unknown[]) => boolean) | undefined;
                maxSize?: number | undefined;
                minSize?: number | undefined;
                maxAsyncSize?: number | undefined;
                maxInitialSize?: number | undefined;
                automaticNameDelimiter?: string | undefined;
            }>>;
            hidePathInfo: z.ZodOptional<z.ZodBoolean>;
        }, "strict", z.ZodTypeAny, {
            chunks?: RegExp | "initial" | "async" | "all" | ((args_0: Chunk, ...args: unknown[]) => boolean) | undefined;
            name?: string | false | ((args_0: Module | undefined, ...args: unknown[]) => unknown) | undefined;
            usedExports?: boolean | undefined;
            defaultSizeTypes?: string[] | undefined;
            cacheGroups?: Record<string, false | {
                type?: string | RegExp | undefined;
                chunks?: RegExp | "initial" | "async" | "all" | ((args_0: Chunk, ...args: unknown[]) => boolean) | undefined;
                name?: string | false | ((args_0: Module | undefined, ...args: unknown[]) => unknown) | undefined;
                filename?: string | ((args_0: PathData, args_1: JsAssetInfo | undefined, ...args: unknown[]) => string) | undefined;
                usedExports?: boolean | undefined;
                defaultSizeTypes?: string[] | undefined;
                maxSize?: number | Record<string, number> | undefined;
                priority?: number | undefined;
                minSize?: number | Record<string, number> | undefined;
                maxAsyncSize?: number | Record<string, number> | undefined;
                maxInitialSize?: number | Record<string, number> | undefined;
                minChunks?: number | undefined;
                maxAsyncRequests?: number | undefined;
                maxInitialRequests?: number | undefined;
                automaticNameDelimiter?: string | undefined;
                test?: string | RegExp | ((args_0: Module, ...args: unknown[]) => unknown) | undefined;
                enforce?: boolean | undefined;
                reuseExistingChunk?: boolean | undefined;
                idHint?: string | undefined;
            }> | undefined;
            maxSize?: number | Record<string, number> | undefined;
            fallbackCacheGroup?: {
                chunks?: RegExp | "initial" | "async" | "all" | ((args_0: Chunk, ...args: unknown[]) => boolean) | undefined;
                maxSize?: number | undefined;
                minSize?: number | undefined;
                maxAsyncSize?: number | undefined;
                maxInitialSize?: number | undefined;
                automaticNameDelimiter?: string | undefined;
            } | undefined;
            minSize?: number | Record<string, number> | undefined;
            maxAsyncSize?: number | Record<string, number> | undefined;
            maxInitialSize?: number | Record<string, number> | undefined;
            hidePathInfo?: boolean | undefined;
            minChunks?: number | undefined;
            maxAsyncRequests?: number | undefined;
            maxInitialRequests?: number | undefined;
            automaticNameDelimiter?: string | undefined;
        }, {
            chunks?: RegExp | "initial" | "async" | "all" | ((args_0: Chunk, ...args: unknown[]) => boolean) | undefined;
            name?: string | false | ((args_0: Module | undefined, ...args: unknown[]) => unknown) | undefined;
            usedExports?: boolean | undefined;
            defaultSizeTypes?: string[] | undefined;
            cacheGroups?: Record<string, false | {
                type?: string | RegExp | undefined;
                chunks?: RegExp | "initial" | "async" | "all" | ((args_0: Chunk, ...args: unknown[]) => boolean) | undefined;
                name?: string | false | ((args_0: Module | undefined, ...args: unknown[]) => unknown) | undefined;
                filename?: string | ((args_0: PathData, args_1: JsAssetInfo | undefined, ...args: unknown[]) => string) | undefined;
                usedExports?: boolean | undefined;
                defaultSizeTypes?: string[] | undefined;
                maxSize?: number | Record<string, number> | undefined;
                priority?: number | undefined;
                minSize?: number | Record<string, number> | undefined;
                maxAsyncSize?: number | Record<string, number> | undefined;
                maxInitialSize?: number | Record<string, number> | undefined;
                minChunks?: number | undefined;
                maxAsyncRequests?: number | undefined;
                maxInitialRequests?: number | undefined;
                automaticNameDelimiter?: string | undefined;
                test?: string | RegExp | ((args_0: Module, ...args: unknown[]) => unknown) | undefined;
                enforce?: boolean | undefined;
                reuseExistingChunk?: boolean | undefined;
                idHint?: string | undefined;
            }> | undefined;
            maxSize?: number | Record<string, number> | undefined;
            fallbackCacheGroup?: {
                chunks?: RegExp | "initial" | "async" | "all" | ((args_0: Chunk, ...args: unknown[]) => boolean) | undefined;
                maxSize?: number | undefined;
                minSize?: number | undefined;
                maxAsyncSize?: number | undefined;
                maxInitialSize?: number | undefined;
                automaticNameDelimiter?: string | undefined;
            } | undefined;
            minSize?: number | Record<string, number> | undefined;
            maxAsyncSize?: number | Record<string, number> | undefined;
            maxInitialSize?: number | Record<string, number> | undefined;
            hidePathInfo?: boolean | undefined;
            minChunks?: number | undefined;
            maxAsyncRequests?: number | undefined;
            maxInitialRequests?: number | undefined;
            automaticNameDelimiter?: string | undefined;
        }>]>>;
        runtimeChunk: z.ZodOptional<z.ZodUnion<[z.ZodUnion<[z.ZodEnum<["single", "multiple"]>, z.ZodBoolean]>, z.ZodObject<{
            name: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodFunction<z.ZodTuple<[z.ZodObject<{
                name: z.ZodString;
            }, "strict", z.ZodTypeAny, {
                name: string;
            }, {
                name: string;
            }>], z.ZodUnknown>, z.ZodString>]>>;
        }, "strict", z.ZodTypeAny, {
            name?: string | ((args_0: {
                name: string;
            }, ...args: unknown[]) => string) | undefined;
        }, {
            name?: string | ((args_0: {
                name: string;
            }, ...args: unknown[]) => string) | undefined;
        }>]>>;
        removeAvailableModules: z.ZodOptional<z.ZodBoolean>;
        removeEmptyChunks: z.ZodOptional<z.ZodBoolean>;
        realContentHash: z.ZodOptional<z.ZodBoolean>;
        sideEffects: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["flag"]>, z.ZodBoolean]>>;
        providedExports: z.ZodOptional<z.ZodBoolean>;
        concatenateModules: z.ZodOptional<z.ZodBoolean>;
        innerGraph: z.ZodOptional<z.ZodBoolean>;
        usedExports: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["global"]>, z.ZodBoolean]>>;
        mangleExports: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["size", "deterministic"]>, z.ZodBoolean]>>;
        nodeEnv: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodLiteral<false>]>>;
        emitOnErrors: z.ZodOptional<z.ZodBoolean>;
        avoidEntryIife: z.ZodOptional<z.ZodBoolean>;
    }, "strict", z.ZodTypeAny, {
        usedExports?: boolean | "global" | undefined;
        providedExports?: boolean | undefined;
        sideEffects?: boolean | "flag" | undefined;
        moduleIds?: "named" | "natural" | "deterministic" | undefined;
        chunkIds?: "size" | "named" | "natural" | "deterministic" | "total-size" | undefined;
        minimize?: boolean | undefined;
        minimizer?: (false | "" | 0 | "..." | t.RspackPluginInstance | t.WebpackPluginInstance | t.RspackPluginFunction | t.WebpackPluginFunction | null | undefined)[] | undefined;
        mergeDuplicateChunks?: boolean | undefined;
        splitChunks?: false | {
            chunks?: RegExp | "initial" | "async" | "all" | ((args_0: Chunk, ...args: unknown[]) => boolean) | undefined;
            name?: string | false | ((args_0: Module | undefined, ...args: unknown[]) => unknown) | undefined;
            usedExports?: boolean | undefined;
            defaultSizeTypes?: string[] | undefined;
            cacheGroups?: Record<string, false | {
                type?: string | RegExp | undefined;
                chunks?: RegExp | "initial" | "async" | "all" | ((args_0: Chunk, ...args: unknown[]) => boolean) | undefined;
                name?: string | false | ((args_0: Module | undefined, ...args: unknown[]) => unknown) | undefined;
                filename?: string | ((args_0: PathData, args_1: JsAssetInfo | undefined, ...args: unknown[]) => string) | undefined;
                usedExports?: boolean | undefined;
                defaultSizeTypes?: string[] | undefined;
                maxSize?: number | Record<string, number> | undefined;
                priority?: number | undefined;
                minSize?: number | Record<string, number> | undefined;
                maxAsyncSize?: number | Record<string, number> | undefined;
                maxInitialSize?: number | Record<string, number> | undefined;
                minChunks?: number | undefined;
                maxAsyncRequests?: number | undefined;
                maxInitialRequests?: number | undefined;
                automaticNameDelimiter?: string | undefined;
                test?: string | RegExp | ((args_0: Module, ...args: unknown[]) => unknown) | undefined;
                enforce?: boolean | undefined;
                reuseExistingChunk?: boolean | undefined;
                idHint?: string | undefined;
            }> | undefined;
            maxSize?: number | Record<string, number> | undefined;
            fallbackCacheGroup?: {
                chunks?: RegExp | "initial" | "async" | "all" | ((args_0: Chunk, ...args: unknown[]) => boolean) | undefined;
                maxSize?: number | undefined;
                minSize?: number | undefined;
                maxAsyncSize?: number | undefined;
                maxInitialSize?: number | undefined;
                automaticNameDelimiter?: string | undefined;
            } | undefined;
            minSize?: number | Record<string, number> | undefined;
            maxAsyncSize?: number | Record<string, number> | undefined;
            maxInitialSize?: number | Record<string, number> | undefined;
            hidePathInfo?: boolean | undefined;
            minChunks?: number | undefined;
            maxAsyncRequests?: number | undefined;
            maxInitialRequests?: number | undefined;
            automaticNameDelimiter?: string | undefined;
        } | undefined;
        runtimeChunk?: boolean | "single" | "multiple" | {
            name?: string | ((args_0: {
                name: string;
            }, ...args: unknown[]) => string) | undefined;
        } | undefined;
        removeAvailableModules?: boolean | undefined;
        removeEmptyChunks?: boolean | undefined;
        realContentHash?: boolean | undefined;
        concatenateModules?: boolean | undefined;
        innerGraph?: boolean | undefined;
        mangleExports?: boolean | "size" | "deterministic" | undefined;
        nodeEnv?: string | false | undefined;
        emitOnErrors?: boolean | undefined;
        avoidEntryIife?: boolean | undefined;
    }, {
        usedExports?: boolean | "global" | undefined;
        providedExports?: boolean | undefined;
        sideEffects?: boolean | "flag" | undefined;
        moduleIds?: "named" | "natural" | "deterministic" | undefined;
        chunkIds?: "size" | "named" | "natural" | "deterministic" | "total-size" | undefined;
        minimize?: boolean | undefined;
        minimizer?: (false | "" | 0 | "..." | t.RspackPluginInstance | t.WebpackPluginInstance | t.RspackPluginFunction | t.WebpackPluginFunction | null | undefined)[] | undefined;
        mergeDuplicateChunks?: boolean | undefined;
        splitChunks?: false | {
            chunks?: RegExp | "initial" | "async" | "all" | ((args_0: Chunk, ...args: unknown[]) => boolean) | undefined;
            name?: string | false | ((args_0: Module | undefined, ...args: unknown[]) => unknown) | undefined;
            usedExports?: boolean | undefined;
            defaultSizeTypes?: string[] | undefined;
            cacheGroups?: Record<string, false | {
                type?: string | RegExp | undefined;
                chunks?: RegExp | "initial" | "async" | "all" | ((args_0: Chunk, ...args: unknown[]) => boolean) | undefined;
                name?: string | false | ((args_0: Module | undefined, ...args: unknown[]) => unknown) | undefined;
                filename?: string | ((args_0: PathData, args_1: JsAssetInfo | undefined, ...args: unknown[]) => string) | undefined;
                usedExports?: boolean | undefined;
                defaultSizeTypes?: string[] | undefined;
                maxSize?: number | Record<string, number> | undefined;
                priority?: number | undefined;
                minSize?: number | Record<string, number> | undefined;
                maxAsyncSize?: number | Record<string, number> | undefined;
                maxInitialSize?: number | Record<string, number> | undefined;
                minChunks?: number | undefined;
                maxAsyncRequests?: number | undefined;
                maxInitialRequests?: number | undefined;
                automaticNameDelimiter?: string | undefined;
                test?: string | RegExp | ((args_0: Module, ...args: unknown[]) => unknown) | undefined;
                enforce?: boolean | undefined;
                reuseExistingChunk?: boolean | undefined;
                idHint?: string | undefined;
            }> | undefined;
            maxSize?: number | Record<string, number> | undefined;
            fallbackCacheGroup?: {
                chunks?: RegExp | "initial" | "async" | "all" | ((args_0: Chunk, ...args: unknown[]) => boolean) | undefined;
                maxSize?: number | undefined;
                minSize?: number | undefined;
                maxAsyncSize?: number | undefined;
                maxInitialSize?: number | undefined;
                automaticNameDelimiter?: string | undefined;
            } | undefined;
            minSize?: number | Record<string, number> | undefined;
            maxAsyncSize?: number | Record<string, number> | undefined;
            maxInitialSize?: number | Record<string, number> | undefined;
            hidePathInfo?: boolean | undefined;
            minChunks?: number | undefined;
            maxAsyncRequests?: number | undefined;
            maxInitialRequests?: number | undefined;
            automaticNameDelimiter?: string | undefined;
        } | undefined;
        runtimeChunk?: boolean | "single" | "multiple" | {
            name?: string | ((args_0: {
                name: string;
            }, ...args: unknown[]) => string) | undefined;
        } | undefined;
        removeAvailableModules?: boolean | undefined;
        removeEmptyChunks?: boolean | undefined;
        realContentHash?: boolean | undefined;
        concatenateModules?: boolean | undefined;
        innerGraph?: boolean | undefined;
        mangleExports?: boolean | "size" | "deterministic" | undefined;
        nodeEnv?: string | false | undefined;
        emitOnErrors?: boolean | undefined;
        avoidEntryIife?: boolean | undefined;
    }>>;
    resolve: z.ZodOptional<z.ZodType<t.ResolveOptions, z.ZodTypeDef, t.ResolveOptions>>;
    resolveLoader: z.ZodOptional<z.ZodType<t.ResolveOptions, z.ZodTypeDef, t.ResolveOptions>>;
    plugins: z.ZodOptional<z.ZodArray<z.ZodUnion<[z.ZodType<t.RspackPluginInstance | t.WebpackPluginInstance | t.RspackPluginFunction | t.WebpackPluginFunction, z.ZodTypeDef, t.RspackPluginInstance | t.WebpackPluginInstance | t.RspackPluginFunction | t.WebpackPluginFunction>, z.ZodUnion<[z.ZodLiteral<false>, z.ZodLiteral<0>, z.ZodLiteral<"">, z.ZodNull, z.ZodUndefined]>]>, "many">>;
    devServer: z.ZodOptional<z.ZodType<t.DevServer, z.ZodTypeDef, t.DevServer>>;
    module: z.ZodOptional<z.ZodObject<{
        defaultRules: z.ZodOptional<z.ZodArray<z.ZodUnion<[z.ZodUnion<[z.ZodLiteral<"...">, z.ZodType<t.RuleSetRule, z.ZodTypeDef, t.RuleSetRule>]>, z.ZodUnion<[z.ZodLiteral<false>, z.ZodLiteral<0>, z.ZodLiteral<"">, z.ZodNull, z.ZodUndefined]>]>, "many">>;
        rules: z.ZodOptional<z.ZodArray<z.ZodUnion<[z.ZodUnion<[z.ZodLiteral<"...">, z.ZodType<t.RuleSetRule, z.ZodTypeDef, t.RuleSetRule>]>, z.ZodUnion<[z.ZodLiteral<false>, z.ZodLiteral<0>, z.ZodLiteral<"">, z.ZodNull, z.ZodUndefined]>]>, "many">>;
        parser: z.ZodOptional<z.ZodUnion<[z.ZodObject<{
            asset: z.ZodOptional<z.ZodObject<{
                dataUrlCondition: z.ZodOptional<z.ZodObject<{
                    maxSize: z.ZodOptional<z.ZodNumber>;
                }, "strict", z.ZodTypeAny, {
                    maxSize?: number | undefined;
                }, {
                    maxSize?: number | undefined;
                }>>;
            }, "strict", z.ZodTypeAny, {
                dataUrlCondition?: {
                    maxSize?: number | undefined;
                } | undefined;
            }, {
                dataUrlCondition?: {
                    maxSize?: number | undefined;
                } | undefined;
            }>>;
            css: z.ZodOptional<z.ZodObject<{
                namedExports: z.ZodOptional<z.ZodBoolean>;
            }, "strict", z.ZodTypeAny, {
                namedExports?: boolean | undefined;
            }, {
                namedExports?: boolean | undefined;
            }>>;
            "css/auto": z.ZodOptional<z.ZodObject<{
                namedExports: z.ZodOptional<z.ZodBoolean>;
            }, "strict", z.ZodTypeAny, {
                namedExports?: boolean | undefined;
            }, {
                namedExports?: boolean | undefined;
            }>>;
            "css/module": z.ZodOptional<z.ZodObject<{
                namedExports: z.ZodOptional<z.ZodBoolean>;
            }, "strict", z.ZodTypeAny, {
                namedExports?: boolean | undefined;
            }, {
                namedExports?: boolean | undefined;
            }>>;
            javascript: z.ZodOptional<z.ZodObject<{
                dynamicImportMode: z.ZodOptional<z.ZodEnum<["eager", "lazy", "weak", "lazy-once"]>>;
                dynamicImportPreload: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodNumber]>>;
                dynamicImportPrefetch: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodNumber]>>;
                dynamicImportFetchPriority: z.ZodOptional<z.ZodEnum<["low", "high", "auto"]>>;
                importMeta: z.ZodOptional<z.ZodBoolean>;
                url: z.ZodOptional<z.ZodUnion<[z.ZodLiteral<"relative">, z.ZodBoolean]>>;
                exprContextCritical: z.ZodOptional<z.ZodBoolean>;
                wrappedContextCritical: z.ZodOptional<z.ZodBoolean>;
                wrappedContextRegExp: z.ZodOptional<z.ZodType<RegExp, z.ZodTypeDef, RegExp>>;
                exportsPresence: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["error", "warn", "auto"]>, z.ZodLiteral<false>]>>;
                importExportsPresence: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["error", "warn", "auto"]>, z.ZodLiteral<false>]>>;
                reexportExportsPresence: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["error", "warn", "auto"]>, z.ZodLiteral<false>]>>;
                strictExportPresence: z.ZodOptional<z.ZodBoolean>;
                worker: z.ZodOptional<z.ZodUnion<[z.ZodArray<z.ZodString, "many">, z.ZodBoolean]>>;
                overrideStrict: z.ZodOptional<z.ZodEnum<["strict", "non-strict"]>>;
                requireAsExpression: z.ZodOptional<z.ZodBoolean>;
                requireDynamic: z.ZodOptional<z.ZodBoolean>;
                requireResolve: z.ZodOptional<z.ZodBoolean>;
                importDynamic: z.ZodOptional<z.ZodBoolean>;
            }, "strict", z.ZodTypeAny, {
                dynamicImportMode?: "eager" | "lazy" | "weak" | "lazy-once" | undefined;
                dynamicImportPreload?: number | boolean | undefined;
                dynamicImportPrefetch?: number | boolean | undefined;
                dynamicImportFetchPriority?: "auto" | "low" | "high" | undefined;
                importMeta?: boolean | undefined;
                url?: boolean | "relative" | undefined;
                exprContextCritical?: boolean | undefined;
                wrappedContextCritical?: boolean | undefined;
                wrappedContextRegExp?: RegExp | undefined;
                exportsPresence?: false | "error" | "warn" | "auto" | undefined;
                importExportsPresence?: false | "error" | "warn" | "auto" | undefined;
                reexportExportsPresence?: false | "error" | "warn" | "auto" | undefined;
                strictExportPresence?: boolean | undefined;
                worker?: boolean | string[] | undefined;
                overrideStrict?: "strict" | "non-strict" | undefined;
                requireAsExpression?: boolean | undefined;
                requireDynamic?: boolean | undefined;
                requireResolve?: boolean | undefined;
                importDynamic?: boolean | undefined;
            }, {
                dynamicImportMode?: "eager" | "lazy" | "weak" | "lazy-once" | undefined;
                dynamicImportPreload?: number | boolean | undefined;
                dynamicImportPrefetch?: number | boolean | undefined;
                dynamicImportFetchPriority?: "auto" | "low" | "high" | undefined;
                importMeta?: boolean | undefined;
                url?: boolean | "relative" | undefined;
                exprContextCritical?: boolean | undefined;
                wrappedContextCritical?: boolean | undefined;
                wrappedContextRegExp?: RegExp | undefined;
                exportsPresence?: false | "error" | "warn" | "auto" | undefined;
                importExportsPresence?: false | "error" | "warn" | "auto" | undefined;
                reexportExportsPresence?: false | "error" | "warn" | "auto" | undefined;
                strictExportPresence?: boolean | undefined;
                worker?: boolean | string[] | undefined;
                overrideStrict?: "strict" | "non-strict" | undefined;
                requireAsExpression?: boolean | undefined;
                requireDynamic?: boolean | undefined;
                requireResolve?: boolean | undefined;
                importDynamic?: boolean | undefined;
            }>>;
            "javascript/auto": z.ZodOptional<z.ZodObject<{
                dynamicImportMode: z.ZodOptional<z.ZodEnum<["eager", "lazy", "weak", "lazy-once"]>>;
                dynamicImportPreload: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodNumber]>>;
                dynamicImportPrefetch: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodNumber]>>;
                dynamicImportFetchPriority: z.ZodOptional<z.ZodEnum<["low", "high", "auto"]>>;
                importMeta: z.ZodOptional<z.ZodBoolean>;
                url: z.ZodOptional<z.ZodUnion<[z.ZodLiteral<"relative">, z.ZodBoolean]>>;
                exprContextCritical: z.ZodOptional<z.ZodBoolean>;
                wrappedContextCritical: z.ZodOptional<z.ZodBoolean>;
                wrappedContextRegExp: z.ZodOptional<z.ZodType<RegExp, z.ZodTypeDef, RegExp>>;
                exportsPresence: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["error", "warn", "auto"]>, z.ZodLiteral<false>]>>;
                importExportsPresence: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["error", "warn", "auto"]>, z.ZodLiteral<false>]>>;
                reexportExportsPresence: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["error", "warn", "auto"]>, z.ZodLiteral<false>]>>;
                strictExportPresence: z.ZodOptional<z.ZodBoolean>;
                worker: z.ZodOptional<z.ZodUnion<[z.ZodArray<z.ZodString, "many">, z.ZodBoolean]>>;
                overrideStrict: z.ZodOptional<z.ZodEnum<["strict", "non-strict"]>>;
                requireAsExpression: z.ZodOptional<z.ZodBoolean>;
                requireDynamic: z.ZodOptional<z.ZodBoolean>;
                requireResolve: z.ZodOptional<z.ZodBoolean>;
                importDynamic: z.ZodOptional<z.ZodBoolean>;
            }, "strict", z.ZodTypeAny, {
                dynamicImportMode?: "eager" | "lazy" | "weak" | "lazy-once" | undefined;
                dynamicImportPreload?: number | boolean | undefined;
                dynamicImportPrefetch?: number | boolean | undefined;
                dynamicImportFetchPriority?: "auto" | "low" | "high" | undefined;
                importMeta?: boolean | undefined;
                url?: boolean | "relative" | undefined;
                exprContextCritical?: boolean | undefined;
                wrappedContextCritical?: boolean | undefined;
                wrappedContextRegExp?: RegExp | undefined;
                exportsPresence?: false | "error" | "warn" | "auto" | undefined;
                importExportsPresence?: false | "error" | "warn" | "auto" | undefined;
                reexportExportsPresence?: false | "error" | "warn" | "auto" | undefined;
                strictExportPresence?: boolean | undefined;
                worker?: boolean | string[] | undefined;
                overrideStrict?: "strict" | "non-strict" | undefined;
                requireAsExpression?: boolean | undefined;
                requireDynamic?: boolean | undefined;
                requireResolve?: boolean | undefined;
                importDynamic?: boolean | undefined;
            }, {
                dynamicImportMode?: "eager" | "lazy" | "weak" | "lazy-once" | undefined;
                dynamicImportPreload?: number | boolean | undefined;
                dynamicImportPrefetch?: number | boolean | undefined;
                dynamicImportFetchPriority?: "auto" | "low" | "high" | undefined;
                importMeta?: boolean | undefined;
                url?: boolean | "relative" | undefined;
                exprContextCritical?: boolean | undefined;
                wrappedContextCritical?: boolean | undefined;
                wrappedContextRegExp?: RegExp | undefined;
                exportsPresence?: false | "error" | "warn" | "auto" | undefined;
                importExportsPresence?: false | "error" | "warn" | "auto" | undefined;
                reexportExportsPresence?: false | "error" | "warn" | "auto" | undefined;
                strictExportPresence?: boolean | undefined;
                worker?: boolean | string[] | undefined;
                overrideStrict?: "strict" | "non-strict" | undefined;
                requireAsExpression?: boolean | undefined;
                requireDynamic?: boolean | undefined;
                requireResolve?: boolean | undefined;
                importDynamic?: boolean | undefined;
            }>>;
            "javascript/dynamic": z.ZodOptional<z.ZodObject<{
                dynamicImportMode: z.ZodOptional<z.ZodEnum<["eager", "lazy", "weak", "lazy-once"]>>;
                dynamicImportPreload: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodNumber]>>;
                dynamicImportPrefetch: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodNumber]>>;
                dynamicImportFetchPriority: z.ZodOptional<z.ZodEnum<["low", "high", "auto"]>>;
                importMeta: z.ZodOptional<z.ZodBoolean>;
                url: z.ZodOptional<z.ZodUnion<[z.ZodLiteral<"relative">, z.ZodBoolean]>>;
                exprContextCritical: z.ZodOptional<z.ZodBoolean>;
                wrappedContextCritical: z.ZodOptional<z.ZodBoolean>;
                wrappedContextRegExp: z.ZodOptional<z.ZodType<RegExp, z.ZodTypeDef, RegExp>>;
                exportsPresence: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["error", "warn", "auto"]>, z.ZodLiteral<false>]>>;
                importExportsPresence: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["error", "warn", "auto"]>, z.ZodLiteral<false>]>>;
                reexportExportsPresence: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["error", "warn", "auto"]>, z.ZodLiteral<false>]>>;
                strictExportPresence: z.ZodOptional<z.ZodBoolean>;
                worker: z.ZodOptional<z.ZodUnion<[z.ZodArray<z.ZodString, "many">, z.ZodBoolean]>>;
                overrideStrict: z.ZodOptional<z.ZodEnum<["strict", "non-strict"]>>;
                requireAsExpression: z.ZodOptional<z.ZodBoolean>;
                requireDynamic: z.ZodOptional<z.ZodBoolean>;
                requireResolve: z.ZodOptional<z.ZodBoolean>;
                importDynamic: z.ZodOptional<z.ZodBoolean>;
            }, "strict", z.ZodTypeAny, {
                dynamicImportMode?: "eager" | "lazy" | "weak" | "lazy-once" | undefined;
                dynamicImportPreload?: number | boolean | undefined;
                dynamicImportPrefetch?: number | boolean | undefined;
                dynamicImportFetchPriority?: "auto" | "low" | "high" | undefined;
                importMeta?: boolean | undefined;
                url?: boolean | "relative" | undefined;
                exprContextCritical?: boolean | undefined;
                wrappedContextCritical?: boolean | undefined;
                wrappedContextRegExp?: RegExp | undefined;
                exportsPresence?: false | "error" | "warn" | "auto" | undefined;
                importExportsPresence?: false | "error" | "warn" | "auto" | undefined;
                reexportExportsPresence?: false | "error" | "warn" | "auto" | undefined;
                strictExportPresence?: boolean | undefined;
                worker?: boolean | string[] | undefined;
                overrideStrict?: "strict" | "non-strict" | undefined;
                requireAsExpression?: boolean | undefined;
                requireDynamic?: boolean | undefined;
                requireResolve?: boolean | undefined;
                importDynamic?: boolean | undefined;
            }, {
                dynamicImportMode?: "eager" | "lazy" | "weak" | "lazy-once" | undefined;
                dynamicImportPreload?: number | boolean | undefined;
                dynamicImportPrefetch?: number | boolean | undefined;
                dynamicImportFetchPriority?: "auto" | "low" | "high" | undefined;
                importMeta?: boolean | undefined;
                url?: boolean | "relative" | undefined;
                exprContextCritical?: boolean | undefined;
                wrappedContextCritical?: boolean | undefined;
                wrappedContextRegExp?: RegExp | undefined;
                exportsPresence?: false | "error" | "warn" | "auto" | undefined;
                importExportsPresence?: false | "error" | "warn" | "auto" | undefined;
                reexportExportsPresence?: false | "error" | "warn" | "auto" | undefined;
                strictExportPresence?: boolean | undefined;
                worker?: boolean | string[] | undefined;
                overrideStrict?: "strict" | "non-strict" | undefined;
                requireAsExpression?: boolean | undefined;
                requireDynamic?: boolean | undefined;
                requireResolve?: boolean | undefined;
                importDynamic?: boolean | undefined;
            }>>;
            "javascript/esm": z.ZodOptional<z.ZodObject<{
                dynamicImportMode: z.ZodOptional<z.ZodEnum<["eager", "lazy", "weak", "lazy-once"]>>;
                dynamicImportPreload: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodNumber]>>;
                dynamicImportPrefetch: z.ZodOptional<z.ZodUnion<[z.ZodBoolean, z.ZodNumber]>>;
                dynamicImportFetchPriority: z.ZodOptional<z.ZodEnum<["low", "high", "auto"]>>;
                importMeta: z.ZodOptional<z.ZodBoolean>;
                url: z.ZodOptional<z.ZodUnion<[z.ZodLiteral<"relative">, z.ZodBoolean]>>;
                exprContextCritical: z.ZodOptional<z.ZodBoolean>;
                wrappedContextCritical: z.ZodOptional<z.ZodBoolean>;
                wrappedContextRegExp: z.ZodOptional<z.ZodType<RegExp, z.ZodTypeDef, RegExp>>;
                exportsPresence: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["error", "warn", "auto"]>, z.ZodLiteral<false>]>>;
                importExportsPresence: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["error", "warn", "auto"]>, z.ZodLiteral<false>]>>;
                reexportExportsPresence: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["error", "warn", "auto"]>, z.ZodLiteral<false>]>>;
                strictExportPresence: z.ZodOptional<z.ZodBoolean>;
                worker: z.ZodOptional<z.ZodUnion<[z.ZodArray<z.ZodString, "many">, z.ZodBoolean]>>;
                overrideStrict: z.ZodOptional<z.ZodEnum<["strict", "non-strict"]>>;
                requireAsExpression: z.ZodOptional<z.ZodBoolean>;
                requireDynamic: z.ZodOptional<z.ZodBoolean>;
                requireResolve: z.ZodOptional<z.ZodBoolean>;
                importDynamic: z.ZodOptional<z.ZodBoolean>;
            }, "strict", z.ZodTypeAny, {
                dynamicImportMode?: "eager" | "lazy" | "weak" | "lazy-once" | undefined;
                dynamicImportPreload?: number | boolean | undefined;
                dynamicImportPrefetch?: number | boolean | undefined;
                dynamicImportFetchPriority?: "auto" | "low" | "high" | undefined;
                importMeta?: boolean | undefined;
                url?: boolean | "relative" | undefined;
                exprContextCritical?: boolean | undefined;
                wrappedContextCritical?: boolean | undefined;
                wrappedContextRegExp?: RegExp | undefined;
                exportsPresence?: false | "error" | "warn" | "auto" | undefined;
                importExportsPresence?: false | "error" | "warn" | "auto" | undefined;
                reexportExportsPresence?: false | "error" | "warn" | "auto" | undefined;
                strictExportPresence?: boolean | undefined;
                worker?: boolean | string[] | undefined;
                overrideStrict?: "strict" | "non-strict" | undefined;
                requireAsExpression?: boolean | undefined;
                requireDynamic?: boolean | undefined;
                requireResolve?: boolean | undefined;
                importDynamic?: boolean | undefined;
            }, {
                dynamicImportMode?: "eager" | "lazy" | "weak" | "lazy-once" | undefined;
                dynamicImportPreload?: number | boolean | undefined;
                dynamicImportPrefetch?: number | boolean | undefined;
                dynamicImportFetchPriority?: "auto" | "low" | "high" | undefined;
                importMeta?: boolean | undefined;
                url?: boolean | "relative" | undefined;
                exprContextCritical?: boolean | undefined;
                wrappedContextCritical?: boolean | undefined;
                wrappedContextRegExp?: RegExp | undefined;
                exportsPresence?: false | "error" | "warn" | "auto" | undefined;
                importExportsPresence?: false | "error" | "warn" | "auto" | undefined;
                reexportExportsPresence?: false | "error" | "warn" | "auto" | undefined;
                strictExportPresence?: boolean | undefined;
                worker?: boolean | string[] | undefined;
                overrideStrict?: "strict" | "non-strict" | undefined;
                requireAsExpression?: boolean | undefined;
                requireDynamic?: boolean | undefined;
                requireResolve?: boolean | undefined;
                importDynamic?: boolean | undefined;
            }>>;
        }, "strict", z.ZodTypeAny, {
            css?: {
                namedExports?: boolean | undefined;
            } | undefined;
            asset?: {
                dataUrlCondition?: {
                    maxSize?: number | undefined;
                } | undefined;
            } | undefined;
            "css/auto"?: {
                namedExports?: boolean | undefined;
            } | undefined;
            "css/module"?: {
                namedExports?: boolean | undefined;
            } | undefined;
            javascript?: {
                dynamicImportMode?: "eager" | "lazy" | "weak" | "lazy-once" | undefined;
                dynamicImportPreload?: number | boolean | undefined;
                dynamicImportPrefetch?: number | boolean | undefined;
                dynamicImportFetchPriority?: "auto" | "low" | "high" | undefined;
                importMeta?: boolean | undefined;
                url?: boolean | "relative" | undefined;
                exprContextCritical?: boolean | undefined;
                wrappedContextCritical?: boolean | undefined;
                wrappedContextRegExp?: RegExp | undefined;
                exportsPresence?: false | "error" | "warn" | "auto" | undefined;
                importExportsPresence?: false | "error" | "warn" | "auto" | undefined;
                reexportExportsPresence?: false | "error" | "warn" | "auto" | undefined;
                strictExportPresence?: boolean | undefined;
                worker?: boolean | string[] | undefined;
                overrideStrict?: "strict" | "non-strict" | undefined;
                requireAsExpression?: boolean | undefined;
                requireDynamic?: boolean | undefined;
                requireResolve?: boolean | undefined;
                importDynamic?: boolean | undefined;
            } | undefined;
            "javascript/auto"?: {
                dynamicImportMode?: "eager" | "lazy" | "weak" | "lazy-once" | undefined;
                dynamicImportPreload?: number | boolean | undefined;
                dynamicImportPrefetch?: number | boolean | undefined;
                dynamicImportFetchPriority?: "auto" | "low" | "high" | undefined;
                importMeta?: boolean | undefined;
                url?: boolean | "relative" | undefined;
                exprContextCritical?: boolean | undefined;
                wrappedContextCritical?: boolean | undefined;
                wrappedContextRegExp?: RegExp | undefined;
                exportsPresence?: false | "error" | "warn" | "auto" | undefined;
                importExportsPresence?: false | "error" | "warn" | "auto" | undefined;
                reexportExportsPresence?: false | "error" | "warn" | "auto" | undefined;
                strictExportPresence?: boolean | undefined;
                worker?: boolean | string[] | undefined;
                overrideStrict?: "strict" | "non-strict" | undefined;
                requireAsExpression?: boolean | undefined;
                requireDynamic?: boolean | undefined;
                requireResolve?: boolean | undefined;
                importDynamic?: boolean | undefined;
            } | undefined;
            "javascript/dynamic"?: {
                dynamicImportMode?: "eager" | "lazy" | "weak" | "lazy-once" | undefined;
                dynamicImportPreload?: number | boolean | undefined;
                dynamicImportPrefetch?: number | boolean | undefined;
                dynamicImportFetchPriority?: "auto" | "low" | "high" | undefined;
                importMeta?: boolean | undefined;
                url?: boolean | "relative" | undefined;
                exprContextCritical?: boolean | undefined;
                wrappedContextCritical?: boolean | undefined;
                wrappedContextRegExp?: RegExp | undefined;
                exportsPresence?: false | "error" | "warn" | "auto" | undefined;
                importExportsPresence?: false | "error" | "warn" | "auto" | undefined;
                reexportExportsPresence?: false | "error" | "warn" | "auto" | undefined;
                strictExportPresence?: boolean | undefined;
                worker?: boolean | string[] | undefined;
                overrideStrict?: "strict" | "non-strict" | undefined;
                requireAsExpression?: boolean | undefined;
                requireDynamic?: boolean | undefined;
                requireResolve?: boolean | undefined;
                importDynamic?: boolean | undefined;
            } | undefined;
            "javascript/esm"?: {
                dynamicImportMode?: "eager" | "lazy" | "weak" | "lazy-once" | undefined;
                dynamicImportPreload?: number | boolean | undefined;
                dynamicImportPrefetch?: number | boolean | undefined;
                dynamicImportFetchPriority?: "auto" | "low" | "high" | undefined;
                importMeta?: boolean | undefined;
                url?: boolean | "relative" | undefined;
                exprContextCritical?: boolean | undefined;
                wrappedContextCritical?: boolean | undefined;
                wrappedContextRegExp?: RegExp | undefined;
                exportsPresence?: false | "error" | "warn" | "auto" | undefined;
                importExportsPresence?: false | "error" | "warn" | "auto" | undefined;
                reexportExportsPresence?: false | "error" | "warn" | "auto" | undefined;
                strictExportPresence?: boolean | undefined;
                worker?: boolean | string[] | undefined;
                overrideStrict?: "strict" | "non-strict" | undefined;
                requireAsExpression?: boolean | undefined;
                requireDynamic?: boolean | undefined;
                requireResolve?: boolean | undefined;
                importDynamic?: boolean | undefined;
            } | undefined;
        }, {
            css?: {
                namedExports?: boolean | undefined;
            } | undefined;
            asset?: {
                dataUrlCondition?: {
                    maxSize?: number | undefined;
                } | undefined;
            } | undefined;
            "css/auto"?: {
                namedExports?: boolean | undefined;
            } | undefined;
            "css/module"?: {
                namedExports?: boolean | undefined;
            } | undefined;
            javascript?: {
                dynamicImportMode?: "eager" | "lazy" | "weak" | "lazy-once" | undefined;
                dynamicImportPreload?: number | boolean | undefined;
                dynamicImportPrefetch?: number | boolean | undefined;
                dynamicImportFetchPriority?: "auto" | "low" | "high" | undefined;
                importMeta?: boolean | undefined;
                url?: boolean | "relative" | undefined;
                exprContextCritical?: boolean | undefined;
                wrappedContextCritical?: boolean | undefined;
                wrappedContextRegExp?: RegExp | undefined;
                exportsPresence?: false | "error" | "warn" | "auto" | undefined;
                importExportsPresence?: false | "error" | "warn" | "auto" | undefined;
                reexportExportsPresence?: false | "error" | "warn" | "auto" | undefined;
                strictExportPresence?: boolean | undefined;
                worker?: boolean | string[] | undefined;
                overrideStrict?: "strict" | "non-strict" | undefined;
                requireAsExpression?: boolean | undefined;
                requireDynamic?: boolean | undefined;
                requireResolve?: boolean | undefined;
                importDynamic?: boolean | undefined;
            } | undefined;
            "javascript/auto"?: {
                dynamicImportMode?: "eager" | "lazy" | "weak" | "lazy-once" | undefined;
                dynamicImportPreload?: number | boolean | undefined;
                dynamicImportPrefetch?: number | boolean | undefined;
                dynamicImportFetchPriority?: "auto" | "low" | "high" | undefined;
                importMeta?: boolean | undefined;
                url?: boolean | "relative" | undefined;
                exprContextCritical?: boolean | undefined;
                wrappedContextCritical?: boolean | undefined;
                wrappedContextRegExp?: RegExp | undefined;
                exportsPresence?: false | "error" | "warn" | "auto" | undefined;
                importExportsPresence?: false | "error" | "warn" | "auto" | undefined;
                reexportExportsPresence?: false | "error" | "warn" | "auto" | undefined;
                strictExportPresence?: boolean | undefined;
                worker?: boolean | string[] | undefined;
                overrideStrict?: "strict" | "non-strict" | undefined;
                requireAsExpression?: boolean | undefined;
                requireDynamic?: boolean | undefined;
                requireResolve?: boolean | undefined;
                importDynamic?: boolean | undefined;
            } | undefined;
            "javascript/dynamic"?: {
                dynamicImportMode?: "eager" | "lazy" | "weak" | "lazy-once" | undefined;
                dynamicImportPreload?: number | boolean | undefined;
                dynamicImportPrefetch?: number | boolean | undefined;
                dynamicImportFetchPriority?: "auto" | "low" | "high" | undefined;
                importMeta?: boolean | undefined;
                url?: boolean | "relative" | undefined;
                exprContextCritical?: boolean | undefined;
                wrappedContextCritical?: boolean | undefined;
                wrappedContextRegExp?: RegExp | undefined;
                exportsPresence?: false | "error" | "warn" | "auto" | undefined;
                importExportsPresence?: false | "error" | "warn" | "auto" | undefined;
                reexportExportsPresence?: false | "error" | "warn" | "auto" | undefined;
                strictExportPresence?: boolean | undefined;
                worker?: boolean | string[] | undefined;
                overrideStrict?: "strict" | "non-strict" | undefined;
                requireAsExpression?: boolean | undefined;
                requireDynamic?: boolean | undefined;
                requireResolve?: boolean | undefined;
                importDynamic?: boolean | undefined;
            } | undefined;
            "javascript/esm"?: {
                dynamicImportMode?: "eager" | "lazy" | "weak" | "lazy-once" | undefined;
                dynamicImportPreload?: number | boolean | undefined;
                dynamicImportPrefetch?: number | boolean | undefined;
                dynamicImportFetchPriority?: "auto" | "low" | "high" | undefined;
                importMeta?: boolean | undefined;
                url?: boolean | "relative" | undefined;
                exprContextCritical?: boolean | undefined;
                wrappedContextCritical?: boolean | undefined;
                wrappedContextRegExp?: RegExp | undefined;
                exportsPresence?: false | "error" | "warn" | "auto" | undefined;
                importExportsPresence?: false | "error" | "warn" | "auto" | undefined;
                reexportExportsPresence?: false | "error" | "warn" | "auto" | undefined;
                strictExportPresence?: boolean | undefined;
                worker?: boolean | string[] | undefined;
                overrideStrict?: "strict" | "non-strict" | undefined;
                requireAsExpression?: boolean | undefined;
                requireDynamic?: boolean | undefined;
                requireResolve?: boolean | undefined;
                importDynamic?: boolean | undefined;
            } | undefined;
        }>, z.ZodRecord<z.ZodString, z.ZodRecord<z.ZodString, z.ZodAny>>]>>;
        generator: z.ZodOptional<z.ZodUnion<[z.ZodObject<{
            asset: z.ZodOptional<z.ZodObject<z.objectUtil.extendShape<{
                dataUrl: z.ZodOptional<z.ZodUnion<[z.ZodObject<{
                    encoding: z.ZodOptional<z.ZodUnion<[z.ZodLiteral<false>, z.ZodLiteral<"base64">]>>;
                    mimetype: z.ZodOptional<z.ZodString>;
                }, "strict", z.ZodTypeAny, {
                    encoding?: false | "base64" | undefined;
                    mimetype?: string | undefined;
                }, {
                    encoding?: false | "base64" | undefined;
                    mimetype?: string | undefined;
                }>, z.ZodFunction<z.ZodTuple<[z.ZodType<Buffer<ArrayBuffer>, z.ZodTypeDef, Buffer<ArrayBuffer>>, z.ZodObject<{
                    filename: z.ZodString;
                    module: z.ZodType<Module, z.ZodTypeDef, Module>;
                }, "strict", z.ZodTypeAny, {
                    module: Module;
                    filename: string;
                }, {
                    module: Module;
                    filename: string;
                }>], z.ZodUnknown>, z.ZodString>]>>;
            }, {
                emit: z.ZodOptional<z.ZodBoolean>;
                filename: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodFunction<z.ZodTuple<[z.ZodType<PathData, z.ZodTypeDef, PathData>, z.ZodOptional<z.ZodType<JsAssetInfo, z.ZodTypeDef, JsAssetInfo>>], z.ZodUnknown>, z.ZodString>]>>;
                publicPath: z.ZodOptional<z.ZodUnion<[z.ZodLiteral<"auto">, z.ZodUnion<[z.ZodString, z.ZodFunction<z.ZodTuple<[z.ZodType<PathData, z.ZodTypeDef, PathData>, z.ZodOptional<z.ZodType<JsAssetInfo, z.ZodTypeDef, JsAssetInfo>>], z.ZodUnknown>, z.ZodString>]>]>>;
            }>, "strict", z.ZodTypeAny, {
                publicPath?: string | ((args_0: PathData, args_1: JsAssetInfo | undefined, ...args: unknown[]) => string) | undefined;
                filename?: string | ((args_0: PathData, args_1: JsAssetInfo | undefined, ...args: unknown[]) => string) | undefined;
                dataUrl?: {
                    encoding?: false | "base64" | undefined;
                    mimetype?: string | undefined;
                } | ((args_0: Buffer<ArrayBuffer>, args_1: {
                    module: Module;
                    filename: string;
                }, ...args: unknown[]) => string) | undefined;
                emit?: boolean | undefined;
            }, {
                publicPath?: string | ((args_0: PathData, args_1: JsAssetInfo | undefined, ...args: unknown[]) => string) | undefined;
                filename?: string | ((args_0: PathData, args_1: JsAssetInfo | undefined, ...args: unknown[]) => string) | undefined;
                dataUrl?: {
                    encoding?: false | "base64" | undefined;
                    mimetype?: string | undefined;
                } | ((args_0: Buffer<ArrayBuffer>, args_1: {
                    module: Module;
                    filename: string;
                }, ...args: unknown[]) => string) | undefined;
                emit?: boolean | undefined;
            }>>;
            "asset/inline": z.ZodOptional<z.ZodObject<{
                dataUrl: z.ZodOptional<z.ZodUnion<[z.ZodObject<{
                    encoding: z.ZodOptional<z.ZodUnion<[z.ZodLiteral<false>, z.ZodLiteral<"base64">]>>;
                    mimetype: z.ZodOptional<z.ZodString>;
                }, "strict", z.ZodTypeAny, {
                    encoding?: false | "base64" | undefined;
                    mimetype?: string | undefined;
                }, {
                    encoding?: false | "base64" | undefined;
                    mimetype?: string | undefined;
                }>, z.ZodFunction<z.ZodTuple<[z.ZodType<Buffer<ArrayBuffer>, z.ZodTypeDef, Buffer<ArrayBuffer>>, z.ZodObject<{
                    filename: z.ZodString;
                    module: z.ZodType<Module, z.ZodTypeDef, Module>;
                }, "strict", z.ZodTypeAny, {
                    module: Module;
                    filename: string;
                }, {
                    module: Module;
                    filename: string;
                }>], z.ZodUnknown>, z.ZodString>]>>;
            }, "strict", z.ZodTypeAny, {
                dataUrl?: {
                    encoding?: false | "base64" | undefined;
                    mimetype?: string | undefined;
                } | ((args_0: Buffer<ArrayBuffer>, args_1: {
                    module: Module;
                    filename: string;
                }, ...args: unknown[]) => string) | undefined;
            }, {
                dataUrl?: {
                    encoding?: false | "base64" | undefined;
                    mimetype?: string | undefined;
                } | ((args_0: Buffer<ArrayBuffer>, args_1: {
                    module: Module;
                    filename: string;
                }, ...args: unknown[]) => string) | undefined;
            }>>;
            "asset/resource": z.ZodOptional<z.ZodObject<{
                emit: z.ZodOptional<z.ZodBoolean>;
                filename: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodFunction<z.ZodTuple<[z.ZodType<PathData, z.ZodTypeDef, PathData>, z.ZodOptional<z.ZodType<JsAssetInfo, z.ZodTypeDef, JsAssetInfo>>], z.ZodUnknown>, z.ZodString>]>>;
                publicPath: z.ZodOptional<z.ZodUnion<[z.ZodLiteral<"auto">, z.ZodUnion<[z.ZodString, z.ZodFunction<z.ZodTuple<[z.ZodType<PathData, z.ZodTypeDef, PathData>, z.ZodOptional<z.ZodType<JsAssetInfo, z.ZodTypeDef, JsAssetInfo>>], z.ZodUnknown>, z.ZodString>]>]>>;
            }, "strict", z.ZodTypeAny, {
                publicPath?: string | ((args_0: PathData, args_1: JsAssetInfo | undefined, ...args: unknown[]) => string) | undefined;
                filename?: string | ((args_0: PathData, args_1: JsAssetInfo | undefined, ...args: unknown[]) => string) | undefined;
                emit?: boolean | undefined;
            }, {
                publicPath?: string | ((args_0: PathData, args_1: JsAssetInfo | undefined, ...args: unknown[]) => string) | undefined;
                filename?: string | ((args_0: PathData, args_1: JsAssetInfo | undefined, ...args: unknown[]) => string) | undefined;
                emit?: boolean | undefined;
            }>>;
            css: z.ZodOptional<z.ZodObject<{
                exportsOnly: z.ZodOptional<z.ZodBoolean>;
                esModule: z.ZodOptional<z.ZodBoolean>;
            }, "strict", z.ZodTypeAny, {
                exportsOnly?: boolean | undefined;
                esModule?: boolean | undefined;
            }, {
                exportsOnly?: boolean | undefined;
                esModule?: boolean | undefined;
            }>>;
            "css/auto": z.ZodOptional<z.ZodObject<{
                exportsConvention: z.ZodOptional<z.ZodEnum<["as-is", "camel-case", "camel-case-only", "dashes", "dashes-only"]>>;
                exportsOnly: z.ZodOptional<z.ZodBoolean>;
                localIdentName: z.ZodOptional<z.ZodString>;
                esModule: z.ZodOptional<z.ZodBoolean>;
            }, "strict", z.ZodTypeAny, {
                exportsOnly?: boolean | undefined;
                esModule?: boolean | undefined;
                exportsConvention?: "as-is" | "camel-case" | "camel-case-only" | "dashes" | "dashes-only" | undefined;
                localIdentName?: string | undefined;
            }, {
                exportsOnly?: boolean | undefined;
                esModule?: boolean | undefined;
                exportsConvention?: "as-is" | "camel-case" | "camel-case-only" | "dashes" | "dashes-only" | undefined;
                localIdentName?: string | undefined;
            }>>;
            "css/module": z.ZodOptional<z.ZodObject<{
                exportsConvention: z.ZodOptional<z.ZodEnum<["as-is", "camel-case", "camel-case-only", "dashes", "dashes-only"]>>;
                exportsOnly: z.ZodOptional<z.ZodBoolean>;
                localIdentName: z.ZodOptional<z.ZodString>;
                esModule: z.ZodOptional<z.ZodBoolean>;
            }, "strict", z.ZodTypeAny, {
                exportsOnly?: boolean | undefined;
                esModule?: boolean | undefined;
                exportsConvention?: "as-is" | "camel-case" | "camel-case-only" | "dashes" | "dashes-only" | undefined;
                localIdentName?: string | undefined;
            }, {
                exportsOnly?: boolean | undefined;
                esModule?: boolean | undefined;
                exportsConvention?: "as-is" | "camel-case" | "camel-case-only" | "dashes" | "dashes-only" | undefined;
                localIdentName?: string | undefined;
            }>>;
        }, "strict", z.ZodTypeAny, {
            css?: {
                exportsOnly?: boolean | undefined;
                esModule?: boolean | undefined;
            } | undefined;
            asset?: {
                publicPath?: string | ((args_0: PathData, args_1: JsAssetInfo | undefined, ...args: unknown[]) => string) | undefined;
                filename?: string | ((args_0: PathData, args_1: JsAssetInfo | undefined, ...args: unknown[]) => string) | undefined;
                dataUrl?: {
                    encoding?: false | "base64" | undefined;
                    mimetype?: string | undefined;
                } | ((args_0: Buffer<ArrayBuffer>, args_1: {
                    module: Module;
                    filename: string;
                }, ...args: unknown[]) => string) | undefined;
                emit?: boolean | undefined;
            } | undefined;
            "css/auto"?: {
                exportsOnly?: boolean | undefined;
                esModule?: boolean | undefined;
                exportsConvention?: "as-is" | "camel-case" | "camel-case-only" | "dashes" | "dashes-only" | undefined;
                localIdentName?: string | undefined;
            } | undefined;
            "css/module"?: {
                exportsOnly?: boolean | undefined;
                esModule?: boolean | undefined;
                exportsConvention?: "as-is" | "camel-case" | "camel-case-only" | "dashes" | "dashes-only" | undefined;
                localIdentName?: string | undefined;
            } | undefined;
            "asset/inline"?: {
                dataUrl?: {
                    encoding?: false | "base64" | undefined;
                    mimetype?: string | undefined;
                } | ((args_0: Buffer<ArrayBuffer>, args_1: {
                    module: Module;
                    filename: string;
                }, ...args: unknown[]) => string) | undefined;
            } | undefined;
            "asset/resource"?: {
                publicPath?: string | ((args_0: PathData, args_1: JsAssetInfo | undefined, ...args: unknown[]) => string) | undefined;
                filename?: string | ((args_0: PathData, args_1: JsAssetInfo | undefined, ...args: unknown[]) => string) | undefined;
                emit?: boolean | undefined;
            } | undefined;
        }, {
            css?: {
                exportsOnly?: boolean | undefined;
                esModule?: boolean | undefined;
            } | undefined;
            asset?: {
                publicPath?: string | ((args_0: PathData, args_1: JsAssetInfo | undefined, ...args: unknown[]) => string) | undefined;
                filename?: string | ((args_0: PathData, args_1: JsAssetInfo | undefined, ...args: unknown[]) => string) | undefined;
                dataUrl?: {
                    encoding?: false | "base64" | undefined;
                    mimetype?: string | undefined;
                } | ((args_0: Buffer<ArrayBuffer>, args_1: {
                    module: Module;
                    filename: string;
                }, ...args: unknown[]) => string) | undefined;
                emit?: boolean | undefined;
            } | undefined;
            "css/auto"?: {
                exportsOnly?: boolean | undefined;
                esModule?: boolean | undefined;
                exportsConvention?: "as-is" | "camel-case" | "camel-case-only" | "dashes" | "dashes-only" | undefined;
                localIdentName?: string | undefined;
            } | undefined;
            "css/module"?: {
                exportsOnly?: boolean | undefined;
                esModule?: boolean | undefined;
                exportsConvention?: "as-is" | "camel-case" | "camel-case-only" | "dashes" | "dashes-only" | undefined;
                localIdentName?: string | undefined;
            } | undefined;
            "asset/inline"?: {
                dataUrl?: {
                    encoding?: false | "base64" | undefined;
                    mimetype?: string | undefined;
                } | ((args_0: Buffer<ArrayBuffer>, args_1: {
                    module: Module;
                    filename: string;
                }, ...args: unknown[]) => string) | undefined;
            } | undefined;
            "asset/resource"?: {
                publicPath?: string | ((args_0: PathData, args_1: JsAssetInfo | undefined, ...args: unknown[]) => string) | undefined;
                filename?: string | ((args_0: PathData, args_1: JsAssetInfo | undefined, ...args: unknown[]) => string) | undefined;
                emit?: boolean | undefined;
            } | undefined;
        }>, z.ZodRecord<z.ZodString, z.ZodRecord<z.ZodString, z.ZodAny>>]>>;
        noParse: z.ZodOptional<z.ZodUnion<[z.ZodUnion<[z.ZodUnion<[z.ZodString, z.ZodType<RegExp, z.ZodTypeDef, RegExp>]>, z.ZodFunction<z.ZodTuple<[z.ZodString], z.ZodUnknown>, z.ZodBoolean>]>, z.ZodArray<z.ZodUnion<[z.ZodUnion<[z.ZodString, z.ZodType<RegExp, z.ZodTypeDef, RegExp>]>, z.ZodFunction<z.ZodTuple<[z.ZodString], z.ZodUnknown>, z.ZodBoolean>]>, "many">]>>;
    }, "strict", z.ZodTypeAny, {
        defaultRules?: (false | "" | 0 | t.RuleSetRule | "..." | null | undefined)[] | undefined;
        rules?: (false | "" | 0 | t.RuleSetRule | "..." | null | undefined)[] | undefined;
        parser?: {
            css?: {
                namedExports?: boolean | undefined;
            } | undefined;
            asset?: {
                dataUrlCondition?: {
                    maxSize?: number | undefined;
                } | undefined;
            } | undefined;
            "css/auto"?: {
                namedExports?: boolean | undefined;
            } | undefined;
            "css/module"?: {
                namedExports?: boolean | undefined;
            } | undefined;
            javascript?: {
                dynamicImportMode?: "eager" | "lazy" | "weak" | "lazy-once" | undefined;
                dynamicImportPreload?: number | boolean | undefined;
                dynamicImportPrefetch?: number | boolean | undefined;
                dynamicImportFetchPriority?: "auto" | "low" | "high" | undefined;
                importMeta?: boolean | undefined;
                url?: boolean | "relative" | undefined;
                exprContextCritical?: boolean | undefined;
                wrappedContextCritical?: boolean | undefined;
                wrappedContextRegExp?: RegExp | undefined;
                exportsPresence?: false | "error" | "warn" | "auto" | undefined;
                importExportsPresence?: false | "error" | "warn" | "auto" | undefined;
                reexportExportsPresence?: false | "error" | "warn" | "auto" | undefined;
                strictExportPresence?: boolean | undefined;
                worker?: boolean | string[] | undefined;
                overrideStrict?: "strict" | "non-strict" | undefined;
                requireAsExpression?: boolean | undefined;
                requireDynamic?: boolean | undefined;
                requireResolve?: boolean | undefined;
                importDynamic?: boolean | undefined;
            } | undefined;
            "javascript/auto"?: {
                dynamicImportMode?: "eager" | "lazy" | "weak" | "lazy-once" | undefined;
                dynamicImportPreload?: number | boolean | undefined;
                dynamicImportPrefetch?: number | boolean | undefined;
                dynamicImportFetchPriority?: "auto" | "low" | "high" | undefined;
                importMeta?: boolean | undefined;
                url?: boolean | "relative" | undefined;
                exprContextCritical?: boolean | undefined;
                wrappedContextCritical?: boolean | undefined;
                wrappedContextRegExp?: RegExp | undefined;
                exportsPresence?: false | "error" | "warn" | "auto" | undefined;
                importExportsPresence?: false | "error" | "warn" | "auto" | undefined;
                reexportExportsPresence?: false | "error" | "warn" | "auto" | undefined;
                strictExportPresence?: boolean | undefined;
                worker?: boolean | string[] | undefined;
                overrideStrict?: "strict" | "non-strict" | undefined;
                requireAsExpression?: boolean | undefined;
                requireDynamic?: boolean | undefined;
                requireResolve?: boolean | undefined;
                importDynamic?: boolean | undefined;
            } | undefined;
            "javascript/dynamic"?: {
                dynamicImportMode?: "eager" | "lazy" | "weak" | "lazy-once" | undefined;
                dynamicImportPreload?: number | boolean | undefined;
                dynamicImportPrefetch?: number | boolean | undefined;
                dynamicImportFetchPriority?: "auto" | "low" | "high" | undefined;
                importMeta?: boolean | undefined;
                url?: boolean | "relative" | undefined;
                exprContextCritical?: boolean | undefined;
                wrappedContextCritical?: boolean | undefined;
                wrappedContextRegExp?: RegExp | undefined;
                exportsPresence?: false | "error" | "warn" | "auto" | undefined;
                importExportsPresence?: false | "error" | "warn" | "auto" | undefined;
                reexportExportsPresence?: false | "error" | "warn" | "auto" | undefined;
                strictExportPresence?: boolean | undefined;
                worker?: boolean | string[] | undefined;
                overrideStrict?: "strict" | "non-strict" | undefined;
                requireAsExpression?: boolean | undefined;
                requireDynamic?: boolean | undefined;
                requireResolve?: boolean | undefined;
                importDynamic?: boolean | undefined;
            } | undefined;
            "javascript/esm"?: {
                dynamicImportMode?: "eager" | "lazy" | "weak" | "lazy-once" | undefined;
                dynamicImportPreload?: number | boolean | undefined;
                dynamicImportPrefetch?: number | boolean | undefined;
                dynamicImportFetchPriority?: "auto" | "low" | "high" | undefined;
                importMeta?: boolean | undefined;
                url?: boolean | "relative" | undefined;
                exprContextCritical?: boolean | undefined;
                wrappedContextCritical?: boolean | undefined;
                wrappedContextRegExp?: RegExp | undefined;
                exportsPresence?: false | "error" | "warn" | "auto" | undefined;
                importExportsPresence?: false | "error" | "warn" | "auto" | undefined;
                reexportExportsPresence?: false | "error" | "warn" | "auto" | undefined;
                strictExportPresence?: boolean | undefined;
                worker?: boolean | string[] | undefined;
                overrideStrict?: "strict" | "non-strict" | undefined;
                requireAsExpression?: boolean | undefined;
                requireDynamic?: boolean | undefined;
                requireResolve?: boolean | undefined;
                importDynamic?: boolean | undefined;
            } | undefined;
        } | Record<string, Record<string, any>> | undefined;
        generator?: Record<string, Record<string, any>> | {
            css?: {
                exportsOnly?: boolean | undefined;
                esModule?: boolean | undefined;
            } | undefined;
            asset?: {
                publicPath?: string | ((args_0: PathData, args_1: JsAssetInfo | undefined, ...args: unknown[]) => string) | undefined;
                filename?: string | ((args_0: PathData, args_1: JsAssetInfo | undefined, ...args: unknown[]) => string) | undefined;
                dataUrl?: {
                    encoding?: false | "base64" | undefined;
                    mimetype?: string | undefined;
                } | ((args_0: Buffer<ArrayBuffer>, args_1: {
                    module: Module;
                    filename: string;
                }, ...args: unknown[]) => string) | undefined;
                emit?: boolean | undefined;
            } | undefined;
            "css/auto"?: {
                exportsOnly?: boolean | undefined;
                esModule?: boolean | undefined;
                exportsConvention?: "as-is" | "camel-case" | "camel-case-only" | "dashes" | "dashes-only" | undefined;
                localIdentName?: string | undefined;
            } | undefined;
            "css/module"?: {
                exportsOnly?: boolean | undefined;
                esModule?: boolean | undefined;
                exportsConvention?: "as-is" | "camel-case" | "camel-case-only" | "dashes" | "dashes-only" | undefined;
                localIdentName?: string | undefined;
            } | undefined;
            "asset/inline"?: {
                dataUrl?: {
                    encoding?: false | "base64" | undefined;
                    mimetype?: string | undefined;
                } | ((args_0: Buffer<ArrayBuffer>, args_1: {
                    module: Module;
                    filename: string;
                }, ...args: unknown[]) => string) | undefined;
            } | undefined;
            "asset/resource"?: {
                publicPath?: string | ((args_0: PathData, args_1: JsAssetInfo | undefined, ...args: unknown[]) => string) | undefined;
                filename?: string | ((args_0: PathData, args_1: JsAssetInfo | undefined, ...args: unknown[]) => string) | undefined;
                emit?: boolean | undefined;
            } | undefined;
        } | undefined;
        noParse?: string | RegExp | ((args_0: string, ...args: unknown[]) => boolean) | (string | RegExp | ((args_0: string, ...args: unknown[]) => boolean))[] | undefined;
    }, {
        defaultRules?: (false | "" | 0 | t.RuleSetRule | "..." | null | undefined)[] | undefined;
        rules?: (false | "" | 0 | t.RuleSetRule | "..." | null | undefined)[] | undefined;
        parser?: {
            css?: {
                namedExports?: boolean | undefined;
            } | undefined;
            asset?: {
                dataUrlCondition?: {
                    maxSize?: number | undefined;
                } | undefined;
            } | undefined;
            "css/auto"?: {
                namedExports?: boolean | undefined;
            } | undefined;
            "css/module"?: {
                namedExports?: boolean | undefined;
            } | undefined;
            javascript?: {
                dynamicImportMode?: "eager" | "lazy" | "weak" | "lazy-once" | undefined;
                dynamicImportPreload?: number | boolean | undefined;
                dynamicImportPrefetch?: number | boolean | undefined;
                dynamicImportFetchPriority?: "auto" | "low" | "high" | undefined;
                importMeta?: boolean | undefined;
                url?: boolean | "relative" | undefined;
                exprContextCritical?: boolean | undefined;
                wrappedContextCritical?: boolean | undefined;
                wrappedContextRegExp?: RegExp | undefined;
                exportsPresence?: false | "error" | "warn" | "auto" | undefined;
                importExportsPresence?: false | "error" | "warn" | "auto" | undefined;
                reexportExportsPresence?: false | "error" | "warn" | "auto" | undefined;
                strictExportPresence?: boolean | undefined;
                worker?: boolean | string[] | undefined;
                overrideStrict?: "strict" | "non-strict" | undefined;
                requireAsExpression?: boolean | undefined;
                requireDynamic?: boolean | undefined;
                requireResolve?: boolean | undefined;
                importDynamic?: boolean | undefined;
            } | undefined;
            "javascript/auto"?: {
                dynamicImportMode?: "eager" | "lazy" | "weak" | "lazy-once" | undefined;
                dynamicImportPreload?: number | boolean | undefined;
                dynamicImportPrefetch?: number | boolean | undefined;
                dynamicImportFetchPriority?: "auto" | "low" | "high" | undefined;
                importMeta?: boolean | undefined;
                url?: boolean | "relative" | undefined;
                exprContextCritical?: boolean | undefined;
                wrappedContextCritical?: boolean | undefined;
                wrappedContextRegExp?: RegExp | undefined;
                exportsPresence?: false | "error" | "warn" | "auto" | undefined;
                importExportsPresence?: false | "error" | "warn" | "auto" | undefined;
                reexportExportsPresence?: false | "error" | "warn" | "auto" | undefined;
                strictExportPresence?: boolean | undefined;
                worker?: boolean | string[] | undefined;
                overrideStrict?: "strict" | "non-strict" | undefined;
                requireAsExpression?: boolean | undefined;
                requireDynamic?: boolean | undefined;
                requireResolve?: boolean | undefined;
                importDynamic?: boolean | undefined;
            } | undefined;
            "javascript/dynamic"?: {
                dynamicImportMode?: "eager" | "lazy" | "weak" | "lazy-once" | undefined;
                dynamicImportPreload?: number | boolean | undefined;
                dynamicImportPrefetch?: number | boolean | undefined;
                dynamicImportFetchPriority?: "auto" | "low" | "high" | undefined;
                importMeta?: boolean | undefined;
                url?: boolean | "relative" | undefined;
                exprContextCritical?: boolean | undefined;
                wrappedContextCritical?: boolean | undefined;
                wrappedContextRegExp?: RegExp | undefined;
                exportsPresence?: false | "error" | "warn" | "auto" | undefined;
                importExportsPresence?: false | "error" | "warn" | "auto" | undefined;
                reexportExportsPresence?: false | "error" | "warn" | "auto" | undefined;
                strictExportPresence?: boolean | undefined;
                worker?: boolean | string[] | undefined;
                overrideStrict?: "strict" | "non-strict" | undefined;
                requireAsExpression?: boolean | undefined;
                requireDynamic?: boolean | undefined;
                requireResolve?: boolean | undefined;
                importDynamic?: boolean | undefined;
            } | undefined;
            "javascript/esm"?: {
                dynamicImportMode?: "eager" | "lazy" | "weak" | "lazy-once" | undefined;
                dynamicImportPreload?: number | boolean | undefined;
                dynamicImportPrefetch?: number | boolean | undefined;
                dynamicImportFetchPriority?: "auto" | "low" | "high" | undefined;
                importMeta?: boolean | undefined;
                url?: boolean | "relative" | undefined;
                exprContextCritical?: boolean | undefined;
                wrappedContextCritical?: boolean | undefined;
                wrappedContextRegExp?: RegExp | undefined;
                exportsPresence?: false | "error" | "warn" | "auto" | undefined;
                importExportsPresence?: false | "error" | "warn" | "auto" | undefined;
                reexportExportsPresence?: false | "error" | "warn" | "auto" | undefined;
                strictExportPresence?: boolean | undefined;
                worker?: boolean | string[] | undefined;
                overrideStrict?: "strict" | "non-strict" | undefined;
                requireAsExpression?: boolean | undefined;
                requireDynamic?: boolean | undefined;
                requireResolve?: boolean | undefined;
                importDynamic?: boolean | undefined;
            } | undefined;
        } | Record<string, Record<string, any>> | undefined;
        generator?: Record<string, Record<string, any>> | {
            css?: {
                exportsOnly?: boolean | undefined;
                esModule?: boolean | undefined;
            } | undefined;
            asset?: {
                publicPath?: string | ((args_0: PathData, args_1: JsAssetInfo | undefined, ...args: unknown[]) => string) | undefined;
                filename?: string | ((args_0: PathData, args_1: JsAssetInfo | undefined, ...args: unknown[]) => string) | undefined;
                dataUrl?: {
                    encoding?: false | "base64" | undefined;
                    mimetype?: string | undefined;
                } | ((args_0: Buffer<ArrayBuffer>, args_1: {
                    module: Module;
                    filename: string;
                }, ...args: unknown[]) => string) | undefined;
                emit?: boolean | undefined;
            } | undefined;
            "css/auto"?: {
                exportsOnly?: boolean | undefined;
                esModule?: boolean | undefined;
                exportsConvention?: "as-is" | "camel-case" | "camel-case-only" | "dashes" | "dashes-only" | undefined;
                localIdentName?: string | undefined;
            } | undefined;
            "css/module"?: {
                exportsOnly?: boolean | undefined;
                esModule?: boolean | undefined;
                exportsConvention?: "as-is" | "camel-case" | "camel-case-only" | "dashes" | "dashes-only" | undefined;
                localIdentName?: string | undefined;
            } | undefined;
            "asset/inline"?: {
                dataUrl?: {
                    encoding?: false | "base64" | undefined;
                    mimetype?: string | undefined;
                } | ((args_0: Buffer<ArrayBuffer>, args_1: {
                    module: Module;
                    filename: string;
                }, ...args: unknown[]) => string) | undefined;
            } | undefined;
            "asset/resource"?: {
                publicPath?: string | ((args_0: PathData, args_1: JsAssetInfo | undefined, ...args: unknown[]) => string) | undefined;
                filename?: string | ((args_0: PathData, args_1: JsAssetInfo | undefined, ...args: unknown[]) => string) | undefined;
                emit?: boolean | undefined;
            } | undefined;
        } | undefined;
        noParse?: string | RegExp | ((args_0: string, ...args: unknown[]) => boolean) | (string | RegExp | ((args_0: string, ...args: unknown[]) => boolean))[] | undefined;
    }>>;
    profile: z.ZodOptional<z.ZodBoolean>;
    amd: z.ZodOptional<z.ZodUnion<[z.ZodLiteral<false>, z.ZodRecord<z.ZodString, z.ZodAny>]>>;
    bail: z.ZodOptional<z.ZodBoolean>;
    performance: z.ZodOptional<z.ZodUnion<[z.ZodObject<{
        assetFilter: z.ZodOptional<z.ZodFunction<z.ZodTuple<[z.ZodString], z.ZodUnknown>, z.ZodBoolean>>;
        hints: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["error", "warning"]>, z.ZodLiteral<false>]>>;
        maxAssetSize: z.ZodOptional<z.ZodNumber>;
        maxEntrypointSize: z.ZodOptional<z.ZodNumber>;
    }, "strict", z.ZodTypeAny, {
        maxAssetSize?: number | undefined;
        assetFilter?: ((args_0: string, ...args: unknown[]) => boolean) | undefined;
        hints?: false | "error" | "warning" | undefined;
        maxEntrypointSize?: number | undefined;
    }, {
        maxAssetSize?: number | undefined;
        assetFilter?: ((args_0: string, ...args: unknown[]) => boolean) | undefined;
        hints?: false | "error" | "warning" | undefined;
        maxEntrypointSize?: number | undefined;
    }>, z.ZodLiteral<false>]>>;
}, "strict", z.ZodTypeAny, {
    dependencies?: string[] | undefined;
    context?: string | undefined;
    name?: string | undefined;
    module?: {
        defaultRules?: (false | "" | 0 | t.RuleSetRule | "..." | null | undefined)[] | undefined;
        rules?: (false | "" | 0 | t.RuleSetRule | "..." | null | undefined)[] | undefined;
        parser?: {
            css?: {
                namedExports?: boolean | undefined;
            } | undefined;
            asset?: {
                dataUrlCondition?: {
                    maxSize?: number | undefined;
                } | undefined;
            } | undefined;
            "css/auto"?: {
                namedExports?: boolean | undefined;
            } | undefined;
            "css/module"?: {
                namedExports?: boolean | undefined;
            } | undefined;
            javascript?: {
                dynamicImportMode?: "eager" | "lazy" | "weak" | "lazy-once" | undefined;
                dynamicImportPreload?: number | boolean | undefined;
                dynamicImportPrefetch?: number | boolean | undefined;
                dynamicImportFetchPriority?: "auto" | "low" | "high" | undefined;
                importMeta?: boolean | undefined;
                url?: boolean | "relative" | undefined;
                exprContextCritical?: boolean | undefined;
                wrappedContextCritical?: boolean | undefined;
                wrappedContextRegExp?: RegExp | undefined;
                exportsPresence?: false | "error" | "warn" | "auto" | undefined;
                importExportsPresence?: false | "error" | "warn" | "auto" | undefined;
                reexportExportsPresence?: false | "error" | "warn" | "auto" | undefined;
                strictExportPresence?: boolean | undefined;
                worker?: boolean | string[] | undefined;
                overrideStrict?: "strict" | "non-strict" | undefined;
                requireAsExpression?: boolean | undefined;
                requireDynamic?: boolean | undefined;
                requireResolve?: boolean | undefined;
                importDynamic?: boolean | undefined;
            } | undefined;
            "javascript/auto"?: {
                dynamicImportMode?: "eager" | "lazy" | "weak" | "lazy-once" | undefined;
                dynamicImportPreload?: number | boolean | undefined;
                dynamicImportPrefetch?: number | boolean | undefined;
                dynamicImportFetchPriority?: "auto" | "low" | "high" | undefined;
                importMeta?: boolean | undefined;
                url?: boolean | "relative" | undefined;
                exprContextCritical?: boolean | undefined;
                wrappedContextCritical?: boolean | undefined;
                wrappedContextRegExp?: RegExp | undefined;
                exportsPresence?: false | "error" | "warn" | "auto" | undefined;
                importExportsPresence?: false | "error" | "warn" | "auto" | undefined;
                reexportExportsPresence?: false | "error" | "warn" | "auto" | undefined;
                strictExportPresence?: boolean | undefined;
                worker?: boolean | string[] | undefined;
                overrideStrict?: "strict" | "non-strict" | undefined;
                requireAsExpression?: boolean | undefined;
                requireDynamic?: boolean | undefined;
                requireResolve?: boolean | undefined;
                importDynamic?: boolean | undefined;
            } | undefined;
            "javascript/dynamic"?: {
                dynamicImportMode?: "eager" | "lazy" | "weak" | "lazy-once" | undefined;
                dynamicImportPreload?: number | boolean | undefined;
                dynamicImportPrefetch?: number | boolean | undefined;
                dynamicImportFetchPriority?: "auto" | "low" | "high" | undefined;
                importMeta?: boolean | undefined;
                url?: boolean | "relative" | undefined;
                exprContextCritical?: boolean | undefined;
                wrappedContextCritical?: boolean | undefined;
                wrappedContextRegExp?: RegExp | undefined;
                exportsPresence?: false | "error" | "warn" | "auto" | undefined;
                importExportsPresence?: false | "error" | "warn" | "auto" | undefined;
                reexportExportsPresence?: false | "error" | "warn" | "auto" | undefined;
                strictExportPresence?: boolean | undefined;
                worker?: boolean | string[] | undefined;
                overrideStrict?: "strict" | "non-strict" | undefined;
                requireAsExpression?: boolean | undefined;
                requireDynamic?: boolean | undefined;
                requireResolve?: boolean | undefined;
                importDynamic?: boolean | undefined;
            } | undefined;
            "javascript/esm"?: {
                dynamicImportMode?: "eager" | "lazy" | "weak" | "lazy-once" | undefined;
                dynamicImportPreload?: number | boolean | undefined;
                dynamicImportPrefetch?: number | boolean | undefined;
                dynamicImportFetchPriority?: "auto" | "low" | "high" | undefined;
                importMeta?: boolean | undefined;
                url?: boolean | "relative" | undefined;
                exprContextCritical?: boolean | undefined;
                wrappedContextCritical?: boolean | undefined;
                wrappedContextRegExp?: RegExp | undefined;
                exportsPresence?: false | "error" | "warn" | "auto" | undefined;
                importExportsPresence?: false | "error" | "warn" | "auto" | undefined;
                reexportExportsPresence?: false | "error" | "warn" | "auto" | undefined;
                strictExportPresence?: boolean | undefined;
                worker?: boolean | string[] | undefined;
                overrideStrict?: "strict" | "non-strict" | undefined;
                requireAsExpression?: boolean | undefined;
                requireDynamic?: boolean | undefined;
                requireResolve?: boolean | undefined;
                importDynamic?: boolean | undefined;
            } | undefined;
        } | Record<string, Record<string, any>> | undefined;
        generator?: Record<string, Record<string, any>> | {
            css?: {
                exportsOnly?: boolean | undefined;
                esModule?: boolean | undefined;
            } | undefined;
            asset?: {
                publicPath?: string | ((args_0: PathData, args_1: JsAssetInfo | undefined, ...args: unknown[]) => string) | undefined;
                filename?: string | ((args_0: PathData, args_1: JsAssetInfo | undefined, ...args: unknown[]) => string) | undefined;
                dataUrl?: {
                    encoding?: false | "base64" | undefined;
                    mimetype?: string | undefined;
                } | ((args_0: Buffer<ArrayBuffer>, args_1: {
                    module: Module;
                    filename: string;
                }, ...args: unknown[]) => string) | undefined;
                emit?: boolean | undefined;
            } | undefined;
            "css/auto"?: {
                exportsOnly?: boolean | undefined;
                esModule?: boolean | undefined;
                exportsConvention?: "as-is" | "camel-case" | "camel-case-only" | "dashes" | "dashes-only" | undefined;
                localIdentName?: string | undefined;
            } | undefined;
            "css/module"?: {
                exportsOnly?: boolean | undefined;
                esModule?: boolean | undefined;
                exportsConvention?: "as-is" | "camel-case" | "camel-case-only" | "dashes" | "dashes-only" | undefined;
                localIdentName?: string | undefined;
            } | undefined;
            "asset/inline"?: {
                dataUrl?: {
                    encoding?: false | "base64" | undefined;
                    mimetype?: string | undefined;
                } | ((args_0: Buffer<ArrayBuffer>, args_1: {
                    module: Module;
                    filename: string;
                }, ...args: unknown[]) => string) | undefined;
            } | undefined;
            "asset/resource"?: {
                publicPath?: string | ((args_0: PathData, args_1: JsAssetInfo | undefined, ...args: unknown[]) => string) | undefined;
                filename?: string | ((args_0: PathData, args_1: JsAssetInfo | undefined, ...args: unknown[]) => string) | undefined;
                emit?: boolean | undefined;
            } | undefined;
        } | undefined;
        noParse?: string | RegExp | ((args_0: string, ...args: unknown[]) => boolean) | (string | RegExp | ((args_0: string, ...args: unknown[]) => boolean))[] | undefined;
    } | undefined;
    profile?: boolean | undefined;
    cache?: boolean | undefined;
    amd?: false | Record<string, any> | undefined;
    node?: false | {
        global?: boolean | "warn" | undefined;
        __dirname?: boolean | "warn-mock" | "mock" | "eval-only" | "node-module" | undefined;
        __filename?: boolean | "warn-mock" | "mock" | "eval-only" | "node-module" | undefined;
    } | undefined;
    performance?: false | {
        maxAssetSize?: number | undefined;
        assetFilter?: ((args_0: string, ...args: unknown[]) => boolean) | undefined;
        hints?: false | "error" | "warning" | undefined;
        maxEntrypointSize?: number | undefined;
    } | undefined;
    mode?: "development" | "production" | "none" | undefined;
    experiments?: {
        css?: boolean | undefined;
        cache?: boolean | {
            type: "memory";
        } | {
            type: "persistent";
            version?: string | undefined;
            snapshot?: {
                immutablePaths?: (string | RegExp)[] | undefined;
                unmanagedPaths?: (string | RegExp)[] | undefined;
                managedPaths?: (string | RegExp)[] | undefined;
            } | undefined;
            buildDependencies?: string[] | undefined;
            storage?: {
                type: "filesystem";
                directory?: string | undefined;
            } | undefined;
        } | undefined;
        lazyCompilation?: boolean | {
            entries?: boolean | undefined;
            test?: RegExp | ((args_0: Module, ...args: unknown[]) => boolean) | undefined;
            imports?: boolean | undefined;
            backend?: {
                client?: string | undefined;
                listen?: number | {
                    path?: string | undefined;
                    port?: number | undefined;
                    host?: string | undefined;
                    backlog?: number | undefined;
                    exclusive?: boolean | undefined;
                    readableAll?: boolean | undefined;
                    writableAll?: boolean | undefined;
                    ipv6Only?: boolean | undefined;
                } | undefined;
                protocol?: "http" | "https" | undefined;
            } | undefined;
        } | undefined;
        asyncWebAssembly?: boolean | undefined;
        outputModule?: boolean | undefined;
        topLevelAwait?: boolean | undefined;
        layers?: boolean | undefined;
        incremental?: boolean | {
            providedExports?: boolean | undefined;
            make?: boolean | undefined;
            inferAsyncModules?: boolean | undefined;
            dependenciesDiagnostics?: boolean | undefined;
            sideEffects?: boolean | undefined;
            buildChunkGraph?: boolean | undefined;
            moduleIds?: boolean | undefined;
            chunkIds?: boolean | undefined;
            modulesHashes?: boolean | undefined;
            modulesCodegen?: boolean | undefined;
            modulesRuntimeRequirements?: boolean | undefined;
            chunksRuntimeRequirements?: boolean | undefined;
            chunksHashes?: boolean | undefined;
            chunksRender?: boolean | undefined;
            emitAssets?: boolean | undefined;
        } | undefined;
        futureDefaults?: boolean | undefined;
        rspackFuture?: {
            bundlerInfo?: {
                version?: string | undefined;
                force?: boolean | ("version" | "uniqueId")[] | undefined;
                bundler?: string | undefined;
            } | undefined;
        } | undefined;
    } | undefined;
    devtool?: false | "eval" | "cheap-source-map" | "cheap-module-source-map" | "source-map" | "inline-cheap-source-map" | "inline-cheap-module-source-map" | "inline-source-map" | "inline-nosources-cheap-source-map" | "inline-nosources-cheap-module-source-map" | "inline-nosources-source-map" | "nosources-cheap-source-map" | "nosources-cheap-module-source-map" | "nosources-source-map" | "hidden-nosources-cheap-source-map" | "hidden-nosources-cheap-module-source-map" | "hidden-nosources-source-map" | "hidden-cheap-source-map" | "hidden-cheap-module-source-map" | "hidden-source-map" | "eval-cheap-source-map" | "eval-cheap-module-source-map" | "eval-source-map" | "eval-nosources-cheap-source-map" | "eval-nosources-cheap-module-source-map" | "eval-nosources-source-map" | undefined;
    resolve?: t.ResolveOptions | undefined;
    stats?: boolean | "none" | "verbose" | "normal" | "errors-only" | "errors-warnings" | "minimal" | "detailed" | "summary" | {
        modules?: boolean | undefined;
        chunks?: boolean | undefined;
        ids?: boolean | undefined;
        runtime?: boolean | undefined;
        hash?: boolean | undefined;
        all?: boolean | undefined;
        version?: boolean | undefined;
        publicPath?: boolean | undefined;
        preset?: boolean | "none" | "verbose" | "normal" | "errors-only" | "errors-warnings" | "minimal" | "detailed" | "summary" | undefined;
        assets?: boolean | undefined;
        entrypoints?: boolean | "auto" | undefined;
        chunkGroups?: boolean | undefined;
        warnings?: boolean | undefined;
        warningsCount?: boolean | undefined;
        errors?: boolean | undefined;
        errorsCount?: boolean | undefined;
        colors?: boolean | undefined;
        reasons?: boolean | undefined;
        outputPath?: boolean | undefined;
        chunkModules?: boolean | undefined;
        chunkRelations?: boolean | undefined;
        timings?: boolean | undefined;
        builtAt?: boolean | undefined;
        moduleAssets?: boolean | undefined;
        nestedModules?: boolean | undefined;
        source?: boolean | undefined;
        logging?: boolean | "error" | "warn" | "info" | "log" | "none" | "verbose" | undefined;
        loggingDebug?: string | boolean | RegExp | ((args_0: string, ...args: unknown[]) => boolean) | (string | RegExp | ((args_0: string, ...args: unknown[]) => boolean))[] | undefined;
        loggingTrace?: boolean | undefined;
        runtimeModules?: boolean | undefined;
        children?: boolean | undefined;
        usedExports?: boolean | undefined;
        providedExports?: boolean | undefined;
        optimizationBailout?: boolean | undefined;
        groupModulesByType?: boolean | undefined;
        groupModulesByCacheStatus?: boolean | undefined;
        groupModulesByLayer?: boolean | undefined;
        groupModulesByAttributes?: boolean | undefined;
        groupModulesByPath?: boolean | undefined;
        groupModulesByExtension?: boolean | undefined;
        modulesSpace?: number | undefined;
        chunkModulesSpace?: number | undefined;
        nestedModulesSpace?: number | undefined;
        relatedAssets?: boolean | undefined;
        groupAssetsByEmitStatus?: boolean | undefined;
        groupAssetsByInfo?: boolean | undefined;
        groupAssetsByPath?: boolean | undefined;
        groupAssetsByExtension?: boolean | undefined;
        groupAssetsByChunk?: boolean | undefined;
        assetsSpace?: number | undefined;
        orphanModules?: boolean | undefined;
        excludeModules?: string | boolean | RegExp | ((args_0: string, args_1: any, args_2: any) => boolean) | (string | RegExp | ((args_0: string, args_1: any, args_2: any) => boolean))[] | undefined;
        excludeAssets?: string | RegExp | ((args_0: string, args_1: any) => boolean) | (string | RegExp | ((args_0: string, args_1: any) => boolean))[] | undefined;
        modulesSort?: string | undefined;
        chunkModulesSort?: string | undefined;
        nestedModulesSort?: string | undefined;
        chunksSort?: string | undefined;
        assetsSort?: string | undefined;
        performance?: boolean | undefined;
        env?: boolean | undefined;
        chunkGroupAuxiliary?: boolean | undefined;
        chunkGroupChildren?: boolean | undefined;
        chunkGroupMaxAssets?: number | undefined;
        dependentModules?: boolean | undefined;
        chunkOrigins?: boolean | undefined;
        depth?: boolean | undefined;
        reasonsSpace?: number | undefined;
        groupReasonsByOrigin?: boolean | undefined;
        errorDetails?: boolean | undefined;
        errorStack?: boolean | undefined;
        moduleTrace?: boolean | undefined;
        cachedModules?: boolean | undefined;
        cachedAssets?: boolean | undefined;
        cached?: boolean | undefined;
        errorsSpace?: number | undefined;
        warningsSpace?: number | undefined;
    } | undefined;
    loader?: Record<string, any> | undefined;
    externals?: string | RegExp | Record<string, string | boolean | string[] | t.ExternalItemUmdValue | t.ExternalItemObjectValue> | ((args_0: t.ExternalItemFunctionData, args_1: (args_0: Error | undefined, args_1: string | boolean | string[] | t.ExternalItemUmdValue | t.ExternalItemObjectValue | undefined, args_2: "module" | "jsonp" | "import" | "var" | "assign" | "this" | "window" | "self" | "global" | "commonjs" | "commonjs2" | "commonjs-module" | "commonjs-static" | "amd" | "amd-require" | "umd" | "umd2" | "system" | "promise" | "module-import" | "script" | "node-commonjs" | "commonjs-import" | undefined, ...args: unknown[]) => void, ...args: unknown[]) => unknown) | ((args_0: t.ExternalItemFunctionData, ...args: unknown[]) => Promise<string | boolean | string[] | t.ExternalItemUmdValue | t.ExternalItemObjectValue>) | ((args_0: t.ExternalItemFunctionData, ...args: unknown[]) => string | boolean | string[] | t.ExternalItemUmdValue | t.ExternalItemObjectValue) | (string | RegExp | Record<string, string | boolean | string[] | t.ExternalItemUmdValue | t.ExternalItemObjectValue> | ((args_0: t.ExternalItemFunctionData, args_1: (args_0: Error | undefined, args_1: string | boolean | string[] | t.ExternalItemUmdValue | t.ExternalItemObjectValue | undefined, args_2: "module" | "jsonp" | "import" | "var" | "assign" | "this" | "window" | "self" | "global" | "commonjs" | "commonjs2" | "commonjs-module" | "commonjs-static" | "amd" | "amd-require" | "umd" | "umd2" | "system" | "promise" | "module-import" | "script" | "node-commonjs" | "commonjs-import" | undefined, ...args: unknown[]) => void, ...args: unknown[]) => unknown) | ((args_0: t.ExternalItemFunctionData, ...args: unknown[]) => Promise<string | boolean | string[] | t.ExternalItemUmdValue | t.ExternalItemObjectValue>) | ((args_0: t.ExternalItemFunctionData, ...args: unknown[]) => string | boolean | string[] | t.ExternalItemUmdValue | t.ExternalItemObjectValue))[] | undefined;
    target?: false | "async-node" | `node${number}` | `async-node${number}` | `node${number}.${number}` | `async-node${number}.${number}` | `electron${number}-main` | `electron${number}.${number}-main` | `electron${number}-renderer` | `electron${number}.${number}-renderer` | `electron${number}-preload` | `electron${number}.${number}-preload` | `nwjs${number}` | `nwjs${number}.${number}` | `node-webkit${number}` | `node-webkit${number}.${number}` | `browserslist:${string}` | "web" | "webworker" | "es3" | "es5" | "es2015" | "es2016" | "es2017" | "es2018" | "es2019" | "es2020" | "es2021" | "es2022" | "node" | "electron-main" | "electron-renderer" | "electron-preload" | "nwjs" | "node-webkit" | "browserslist" | ("async-node" | `node${number}` | `async-node${number}` | `node${number}.${number}` | `async-node${number}.${number}` | `electron${number}-main` | `electron${number}.${number}-main` | `electron${number}-renderer` | `electron${number}.${number}-renderer` | `electron${number}-preload` | `electron${number}.${number}-preload` | `nwjs${number}` | `nwjs${number}.${number}` | `node-webkit${number}` | `node-webkit${number}.${number}` | `browserslist:${string}` | "web" | "webworker" | "es3" | "es5" | "es2015" | "es2016" | "es2017" | "es2018" | "es2019" | "es2020" | "es2021" | "es2022" | "node" | "electron-main" | "electron-renderer" | "electron-preload" | "nwjs" | "node-webkit" | "browserslist")[] | undefined;
    entry?: string | string[] | Record<string, string | string[] | {
        import: string | string[];
        layer?: string | null | undefined;
        runtime?: string | false | undefined;
        chunkLoading?: string | false | undefined;
        asyncChunks?: boolean | undefined;
        publicPath?: string | ((args_0: PathData, args_1: JsAssetInfo | undefined, ...args: unknown[]) => string) | undefined;
        baseUri?: string | undefined;
        filename?: string | ((args_0: PathData, args_1: JsAssetInfo | undefined, ...args: unknown[]) => string) | undefined;
        library?: {
            type: string;
            name?: string | string[] | {
                commonjs?: string | undefined;
                amd?: string | undefined;
                root?: string | string[] | undefined;
            } | undefined;
            amdContainer?: string | undefined;
            auxiliaryComment?: string | {
                commonjs?: string | undefined;
                commonjs2?: string | undefined;
                amd?: string | undefined;
                root?: string | undefined;
            } | undefined;
            export?: string | string[] | undefined;
            umdNamedDefine?: boolean | undefined;
        } | undefined;
        wasmLoading?: string | false | undefined;
        dependOn?: string | string[] | undefined;
    }> | ((...args: unknown[]) => string | string[] | Record<string, string | string[] | {
        import: string | string[];
        layer?: string | null | undefined;
        runtime?: string | false | undefined;
        chunkLoading?: string | false | undefined;
        asyncChunks?: boolean | undefined;
        publicPath?: string | ((args_0: PathData, args_1: JsAssetInfo | undefined, ...args: unknown[]) => string) | undefined;
        baseUri?: string | undefined;
        filename?: string | ((args_0: PathData, args_1: JsAssetInfo | undefined, ...args: unknown[]) => string) | undefined;
        library?: {
            type: string;
            name?: string | string[] | {
                commonjs?: string | undefined;
                amd?: string | undefined;
                root?: string | string[] | undefined;
            } | undefined;
            amdContainer?: string | undefined;
            auxiliaryComment?: string | {
                commonjs?: string | undefined;
                commonjs2?: string | undefined;
                amd?: string | undefined;
                root?: string | undefined;
            } | undefined;
            export?: string | string[] | undefined;
            umdNamedDefine?: boolean | undefined;
        } | undefined;
        wasmLoading?: string | false | undefined;
        dependOn?: string | string[] | undefined;
    }> | Promise<string | string[] | Record<string, string | string[] | {
        import: string | string[];
        layer?: string | null | undefined;
        runtime?: string | false | undefined;
        chunkLoading?: string | false | undefined;
        asyncChunks?: boolean | undefined;
        publicPath?: string | ((args_0: PathData, args_1: JsAssetInfo | undefined, ...args: unknown[]) => string) | undefined;
        baseUri?: string | undefined;
        filename?: string | ((args_0: PathData, args_1: JsAssetInfo | undefined, ...args: unknown[]) => string) | undefined;
        library?: {
            type: string;
            name?: string | string[] | {
                commonjs?: string | undefined;
                amd?: string | undefined;
                root?: string | string[] | undefined;
            } | undefined;
            amdContainer?: string | undefined;
            auxiliaryComment?: string | {
                commonjs?: string | undefined;
                commonjs2?: string | undefined;
                amd?: string | undefined;
                root?: string | undefined;
            } | undefined;
            export?: string | string[] | undefined;
            umdNamedDefine?: boolean | undefined;
        } | undefined;
        wasmLoading?: string | false | undefined;
        dependOn?: string | string[] | undefined;
    }>>) | undefined;
    output?: {
        module?: boolean | undefined;
        chunkLoading?: string | false | undefined;
        asyncChunks?: boolean | undefined;
        publicPath?: string | ((args_0: PathData, args_1: JsAssetInfo | undefined, ...args: unknown[]) => string) | undefined;
        filename?: string | ((args_0: PathData, args_1: JsAssetInfo | undefined, ...args: unknown[]) => string) | undefined;
        library?: string | string[] | {
            commonjs?: string | undefined;
            amd?: string | undefined;
            root?: string | string[] | undefined;
        } | {
            type: string;
            name?: string | string[] | {
                commonjs?: string | undefined;
                amd?: string | undefined;
                root?: string | string[] | undefined;
            } | undefined;
            amdContainer?: string | undefined;
            auxiliaryComment?: string | {
                commonjs?: string | undefined;
                commonjs2?: string | undefined;
                amd?: string | undefined;
                root?: string | undefined;
            } | undefined;
            export?: string | string[] | undefined;
            umdNamedDefine?: boolean | undefined;
        } | undefined;
        wasmLoading?: string | false | undefined;
        cssHeadDataCompression?: boolean | undefined;
        auxiliaryComment?: string | {
            commonjs?: string | undefined;
            commonjs2?: string | undefined;
            amd?: string | undefined;
            root?: string | undefined;
        } | undefined;
        umdNamedDefine?: boolean | undefined;
        path?: string | undefined;
        pathinfo?: boolean | "verbose" | undefined;
        clean?: boolean | {
            keep?: string | undefined;
        } | undefined;
        chunkFilename?: string | ((args_0: PathData, args_1: JsAssetInfo | undefined, ...args: unknown[]) => string) | undefined;
        crossOriginLoading?: false | "anonymous" | "use-credentials" | undefined;
        cssFilename?: string | ((args_0: PathData, args_1: JsAssetInfo | undefined, ...args: unknown[]) => string) | undefined;
        cssChunkFilename?: string | ((args_0: PathData, args_1: JsAssetInfo | undefined, ...args: unknown[]) => string) | undefined;
        hotUpdateMainFilename?: string | undefined;
        hotUpdateChunkFilename?: string | undefined;
        hotUpdateGlobal?: string | undefined;
        assetModuleFilename?: string | ((args_0: PathData, args_1: JsAssetInfo | undefined, ...args: unknown[]) => string) | undefined;
        uniqueName?: string | undefined;
        chunkLoadingGlobal?: string | undefined;
        enabledLibraryTypes?: string[] | undefined;
        strictModuleErrorHandling?: boolean | undefined;
        globalObject?: string | undefined;
        importFunctionName?: string | undefined;
        importMetaName?: string | undefined;
        iife?: boolean | undefined;
        enabledWasmLoadingTypes?: string[] | undefined;
        webassemblyModuleFilename?: string | undefined;
        chunkFormat?: string | false | undefined;
        enabledChunkLoadingTypes?: string[] | undefined;
        trustedTypes?: string | true | {
            policyName?: string | undefined;
            onPolicyCreationFailure?: "continue" | "stop" | undefined;
        } | undefined;
        sourceMapFilename?: string | undefined;
        hashDigest?: string | undefined;
        hashDigestLength?: number | undefined;
        hashFunction?: "md4" | "xxhash64" | undefined;
        hashSalt?: string | undefined;
        workerChunkLoading?: string | false | undefined;
        workerWasmLoading?: string | false | undefined;
        workerPublicPath?: string | undefined;
        scriptType?: false | "module" | "text/javascript" | undefined;
        devtoolNamespace?: string | undefined;
        devtoolModuleFilenameTemplate?: string | ((args_0: any) => any) | undefined;
        devtoolFallbackModuleFilenameTemplate?: string | ((args_0: any) => any) | undefined;
        environment?: {
            module?: boolean | undefined;
            document?: boolean | undefined;
            nodePrefixForCoreModules?: boolean | undefined;
            globalThis?: boolean | undefined;
            bigIntLiteral?: boolean | undefined;
            const?: boolean | undefined;
            arrowFunction?: boolean | undefined;
            forOf?: boolean | undefined;
            destructuring?: boolean | undefined;
            dynamicImport?: boolean | undefined;
            dynamicImportInWorker?: boolean | undefined;
            optionalChaining?: boolean | undefined;
            templateLiteral?: boolean | undefined;
            asyncFunction?: boolean | undefined;
        } | undefined;
        charset?: boolean | undefined;
        chunkLoadTimeout?: number | undefined;
        compareBeforeEmit?: boolean | undefined;
        libraryExport?: string | string[] | undefined;
        libraryTarget?: string | undefined;
        strictModuleExceptionHandling?: boolean | undefined;
    } | undefined;
    resolveLoader?: t.ResolveOptions | undefined;
    externalsType?: "module" | "jsonp" | "import" | "var" | "assign" | "this" | "window" | "self" | "global" | "commonjs" | "commonjs2" | "commonjs-module" | "commonjs-static" | "amd" | "amd-require" | "umd" | "umd2" | "system" | "promise" | "module-import" | "script" | "node-commonjs" | "commonjs-import" | undefined;
    externalsPresets?: {
        web?: boolean | undefined;
        node?: boolean | undefined;
        nwjs?: boolean | undefined;
        electron?: boolean | undefined;
        electronMain?: boolean | undefined;
        electronPreload?: boolean | undefined;
        electronRenderer?: boolean | undefined;
        webAsync?: boolean | undefined;
    } | undefined;
    infrastructureLogging?: {
        debug?: string | boolean | RegExp | ((args_0: string, ...args: unknown[]) => boolean) | (string | RegExp | ((args_0: string, ...args: unknown[]) => boolean))[] | undefined;
        colors?: boolean | undefined;
        stream?: NodeJS.WritableStream | undefined;
        appendOnly?: boolean | undefined;
        console?: Console | undefined;
        level?: "error" | "warn" | "info" | "log" | "none" | "verbose" | undefined;
    } | undefined;
    snapshot?: {} | undefined;
    optimization?: {
        usedExports?: boolean | "global" | undefined;
        providedExports?: boolean | undefined;
        sideEffects?: boolean | "flag" | undefined;
        moduleIds?: "named" | "natural" | "deterministic" | undefined;
        chunkIds?: "size" | "named" | "natural" | "deterministic" | "total-size" | undefined;
        minimize?: boolean | undefined;
        minimizer?: (false | "" | 0 | "..." | t.RspackPluginInstance | t.WebpackPluginInstance | t.RspackPluginFunction | t.WebpackPluginFunction | null | undefined)[] | undefined;
        mergeDuplicateChunks?: boolean | undefined;
        splitChunks?: false | {
            chunks?: RegExp | "initial" | "async" | "all" | ((args_0: Chunk, ...args: unknown[]) => boolean) | undefined;
            name?: string | false | ((args_0: Module | undefined, ...args: unknown[]) => unknown) | undefined;
            usedExports?: boolean | undefined;
            defaultSizeTypes?: string[] | undefined;
            cacheGroups?: Record<string, false | {
                type?: string | RegExp | undefined;
                chunks?: RegExp | "initial" | "async" | "all" | ((args_0: Chunk, ...args: unknown[]) => boolean) | undefined;
                name?: string | false | ((args_0: Module | undefined, ...args: unknown[]) => unknown) | undefined;
                filename?: string | ((args_0: PathData, args_1: JsAssetInfo | undefined, ...args: unknown[]) => string) | undefined;
                usedExports?: boolean | undefined;
                defaultSizeTypes?: string[] | undefined;
                maxSize?: number | Record<string, number> | undefined;
                priority?: number | undefined;
                minSize?: number | Record<string, number> | undefined;
                maxAsyncSize?: number | Record<string, number> | undefined;
                maxInitialSize?: number | Record<string, number> | undefined;
                minChunks?: number | undefined;
                maxAsyncRequests?: number | undefined;
                maxInitialRequests?: number | undefined;
                automaticNameDelimiter?: string | undefined;
                test?: string | RegExp | ((args_0: Module, ...args: unknown[]) => unknown) | undefined;
                enforce?: boolean | undefined;
                reuseExistingChunk?: boolean | undefined;
                idHint?: string | undefined;
            }> | undefined;
            maxSize?: number | Record<string, number> | undefined;
            fallbackCacheGroup?: {
                chunks?: RegExp | "initial" | "async" | "all" | ((args_0: Chunk, ...args: unknown[]) => boolean) | undefined;
                maxSize?: number | undefined;
                minSize?: number | undefined;
                maxAsyncSize?: number | undefined;
                maxInitialSize?: number | undefined;
                automaticNameDelimiter?: string | undefined;
            } | undefined;
            minSize?: number | Record<string, number> | undefined;
            maxAsyncSize?: number | Record<string, number> | undefined;
            maxInitialSize?: number | Record<string, number> | undefined;
            hidePathInfo?: boolean | undefined;
            minChunks?: number | undefined;
            maxAsyncRequests?: number | undefined;
            maxInitialRequests?: number | undefined;
            automaticNameDelimiter?: string | undefined;
        } | undefined;
        runtimeChunk?: boolean | "single" | "multiple" | {
            name?: string | ((args_0: {
                name: string;
            }, ...args: unknown[]) => string) | undefined;
        } | undefined;
        removeAvailableModules?: boolean | undefined;
        removeEmptyChunks?: boolean | undefined;
        realContentHash?: boolean | undefined;
        concatenateModules?: boolean | undefined;
        innerGraph?: boolean | undefined;
        mangleExports?: boolean | "size" | "deterministic" | undefined;
        nodeEnv?: string | false | undefined;
        emitOnErrors?: boolean | undefined;
        avoidEntryIife?: boolean | undefined;
    } | undefined;
    plugins?: (false | "" | 0 | t.RspackPluginInstance | t.WebpackPluginInstance | t.RspackPluginFunction | t.WebpackPluginFunction | null | undefined)[] | undefined;
    watch?: boolean | undefined;
    watchOptions?: {
        aggregateTimeout?: number | undefined;
        followSymlinks?: boolean | undefined;
        ignored?: string | RegExp | string[] | undefined;
        poll?: number | boolean | undefined;
        stdin?: boolean | undefined;
    } | undefined;
    devServer?: t.DevServer | undefined;
    ignoreWarnings?: (RegExp | ((args_0: Error, args_1: Compilation, ...args: unknown[]) => boolean))[] | undefined;
    bail?: boolean | undefined;
}, {
    dependencies?: string[] | undefined;
    context?: string | undefined;
    name?: string | undefined;
    module?: {
        defaultRules?: (false | "" | 0 | t.RuleSetRule | "..." | null | undefined)[] | undefined;
        rules?: (false | "" | 0 | t.RuleSetRule | "..." | null | undefined)[] | undefined;
        parser?: {
            css?: {
                namedExports?: boolean | undefined;
            } | undefined;
            asset?: {
                dataUrlCondition?: {
                    maxSize?: number | undefined;
                } | undefined;
            } | undefined;
            "css/auto"?: {
                namedExports?: boolean | undefined;
            } | undefined;
            "css/module"?: {
                namedExports?: boolean | undefined;
            } | undefined;
            javascript?: {
                dynamicImportMode?: "eager" | "lazy" | "weak" | "lazy-once" | undefined;
                dynamicImportPreload?: number | boolean | undefined;
                dynamicImportPrefetch?: number | boolean | undefined;
                dynamicImportFetchPriority?: "auto" | "low" | "high" | undefined;
                importMeta?: boolean | undefined;
                url?: boolean | "relative" | undefined;
                exprContextCritical?: boolean | undefined;
                wrappedContextCritical?: boolean | undefined;
                wrappedContextRegExp?: RegExp | undefined;
                exportsPresence?: false | "error" | "warn" | "auto" | undefined;
                importExportsPresence?: false | "error" | "warn" | "auto" | undefined;
                reexportExportsPresence?: false | "error" | "warn" | "auto" | undefined;
                strictExportPresence?: boolean | undefined;
                worker?: boolean | string[] | undefined;
                overrideStrict?: "strict" | "non-strict" | undefined;
                requireAsExpression?: boolean | undefined;
                requireDynamic?: boolean | undefined;
                requireResolve?: boolean | undefined;
                importDynamic?: boolean | undefined;
            } | undefined;
            "javascript/auto"?: {
                dynamicImportMode?: "eager" | "lazy" | "weak" | "lazy-once" | undefined;
                dynamicImportPreload?: number | boolean | undefined;
                dynamicImportPrefetch?: number | boolean | undefined;
                dynamicImportFetchPriority?: "auto" | "low" | "high" | undefined;
                importMeta?: boolean | undefined;
                url?: boolean | "relative" | undefined;
                exprContextCritical?: boolean | undefined;
                wrappedContextCritical?: boolean | undefined;
                wrappedContextRegExp?: RegExp | undefined;
                exportsPresence?: false | "error" | "warn" | "auto" | undefined;
                importExportsPresence?: false | "error" | "warn" | "auto" | undefined;
                reexportExportsPresence?: false | "error" | "warn" | "auto" | undefined;
                strictExportPresence?: boolean | undefined;
                worker?: boolean | string[] | undefined;
                overrideStrict?: "strict" | "non-strict" | undefined;
                requireAsExpression?: boolean | undefined;
                requireDynamic?: boolean | undefined;
                requireResolve?: boolean | undefined;
                importDynamic?: boolean | undefined;
            } | undefined;
            "javascript/dynamic"?: {
                dynamicImportMode?: "eager" | "lazy" | "weak" | "lazy-once" | undefined;
                dynamicImportPreload?: number | boolean | undefined;
                dynamicImportPrefetch?: number | boolean | undefined;
                dynamicImportFetchPriority?: "auto" | "low" | "high" | undefined;
                importMeta?: boolean | undefined;
                url?: boolean | "relative" | undefined;
                exprContextCritical?: boolean | undefined;
                wrappedContextCritical?: boolean | undefined;
                wrappedContextRegExp?: RegExp | undefined;
                exportsPresence?: false | "error" | "warn" | "auto" | undefined;
                importExportsPresence?: false | "error" | "warn" | "auto" | undefined;
                reexportExportsPresence?: false | "error" | "warn" | "auto" | undefined;
                strictExportPresence?: boolean | undefined;
                worker?: boolean | string[] | undefined;
                overrideStrict?: "strict" | "non-strict" | undefined;
                requireAsExpression?: boolean | undefined;
                requireDynamic?: boolean | undefined;
                requireResolve?: boolean | undefined;
                importDynamic?: boolean | undefined;
            } | undefined;
            "javascript/esm"?: {
                dynamicImportMode?: "eager" | "lazy" | "weak" | "lazy-once" | undefined;
                dynamicImportPreload?: number | boolean | undefined;
                dynamicImportPrefetch?: number | boolean | undefined;
                dynamicImportFetchPriority?: "auto" | "low" | "high" | undefined;
                importMeta?: boolean | undefined;
                url?: boolean | "relative" | undefined;
                exprContextCritical?: boolean | undefined;
                wrappedContextCritical?: boolean | undefined;
                wrappedContextRegExp?: RegExp | undefined;
                exportsPresence?: false | "error" | "warn" | "auto" | undefined;
                importExportsPresence?: false | "error" | "warn" | "auto" | undefined;
                reexportExportsPresence?: false | "error" | "warn" | "auto" | undefined;
                strictExportPresence?: boolean | undefined;
                worker?: boolean | string[] | undefined;
                overrideStrict?: "strict" | "non-strict" | undefined;
                requireAsExpression?: boolean | undefined;
                requireDynamic?: boolean | undefined;
                requireResolve?: boolean | undefined;
                importDynamic?: boolean | undefined;
            } | undefined;
        } | Record<string, Record<string, any>> | undefined;
        generator?: Record<string, Record<string, any>> | {
            css?: {
                exportsOnly?: boolean | undefined;
                esModule?: boolean | undefined;
            } | undefined;
            asset?: {
                publicPath?: string | ((args_0: PathData, args_1: JsAssetInfo | undefined, ...args: unknown[]) => string) | undefined;
                filename?: string | ((args_0: PathData, args_1: JsAssetInfo | undefined, ...args: unknown[]) => string) | undefined;
                dataUrl?: {
                    encoding?: false | "base64" | undefined;
                    mimetype?: string | undefined;
                } | ((args_0: Buffer<ArrayBuffer>, args_1: {
                    module: Module;
                    filename: string;
                }, ...args: unknown[]) => string) | undefined;
                emit?: boolean | undefined;
            } | undefined;
            "css/auto"?: {
                exportsOnly?: boolean | undefined;
                esModule?: boolean | undefined;
                exportsConvention?: "as-is" | "camel-case" | "camel-case-only" | "dashes" | "dashes-only" | undefined;
                localIdentName?: string | undefined;
            } | undefined;
            "css/module"?: {
                exportsOnly?: boolean | undefined;
                esModule?: boolean | undefined;
                exportsConvention?: "as-is" | "camel-case" | "camel-case-only" | "dashes" | "dashes-only" | undefined;
                localIdentName?: string | undefined;
            } | undefined;
            "asset/inline"?: {
                dataUrl?: {
                    encoding?: false | "base64" | undefined;
                    mimetype?: string | undefined;
                } | ((args_0: Buffer<ArrayBuffer>, args_1: {
                    module: Module;
                    filename: string;
                }, ...args: unknown[]) => string) | undefined;
            } | undefined;
            "asset/resource"?: {
                publicPath?: string | ((args_0: PathData, args_1: JsAssetInfo | undefined, ...args: unknown[]) => string) | undefined;
                filename?: string | ((args_0: PathData, args_1: JsAssetInfo | undefined, ...args: unknown[]) => string) | undefined;
                emit?: boolean | undefined;
            } | undefined;
        } | undefined;
        noParse?: string | RegExp | ((args_0: string, ...args: unknown[]) => boolean) | (string | RegExp | ((args_0: string, ...args: unknown[]) => boolean))[] | undefined;
    } | undefined;
    profile?: boolean | undefined;
    cache?: boolean | undefined;
    amd?: false | Record<string, any> | undefined;
    node?: false | {
        global?: boolean | "warn" | undefined;
        __dirname?: boolean | "warn-mock" | "mock" | "eval-only" | "node-module" | undefined;
        __filename?: boolean | "warn-mock" | "mock" | "eval-only" | "node-module" | undefined;
    } | undefined;
    performance?: false | {
        maxAssetSize?: number | undefined;
        assetFilter?: ((args_0: string, ...args: unknown[]) => boolean) | undefined;
        hints?: false | "error" | "warning" | undefined;
        maxEntrypointSize?: number | undefined;
    } | undefined;
    mode?: "development" | "production" | "none" | undefined;
    experiments?: {
        css?: boolean | undefined;
        cache?: boolean | {
            type: "memory";
        } | {
            type: "persistent";
            version?: string | undefined;
            snapshot?: {
                immutablePaths?: (string | RegExp)[] | undefined;
                unmanagedPaths?: (string | RegExp)[] | undefined;
                managedPaths?: (string | RegExp)[] | undefined;
            } | undefined;
            buildDependencies?: string[] | undefined;
            storage?: {
                type: "filesystem";
                directory?: string | undefined;
            } | undefined;
        } | undefined;
        lazyCompilation?: boolean | {
            entries?: boolean | undefined;
            test?: RegExp | ((args_0: Module, ...args: unknown[]) => boolean) | undefined;
            imports?: boolean | undefined;
            backend?: {
                client?: string | undefined;
                listen?: number | {
                    path?: string | undefined;
                    port?: number | undefined;
                    host?: string | undefined;
                    backlog?: number | undefined;
                    exclusive?: boolean | undefined;
                    readableAll?: boolean | undefined;
                    writableAll?: boolean | undefined;
                    ipv6Only?: boolean | undefined;
                } | undefined;
                protocol?: "http" | "https" | undefined;
            } | undefined;
        } | undefined;
        asyncWebAssembly?: boolean | undefined;
        outputModule?: boolean | undefined;
        topLevelAwait?: boolean | undefined;
        layers?: boolean | undefined;
        incremental?: boolean | {
            providedExports?: boolean | undefined;
            make?: boolean | undefined;
            inferAsyncModules?: boolean | undefined;
            dependenciesDiagnostics?: boolean | undefined;
            sideEffects?: boolean | undefined;
            buildChunkGraph?: boolean | undefined;
            moduleIds?: boolean | undefined;
            chunkIds?: boolean | undefined;
            modulesHashes?: boolean | undefined;
            modulesCodegen?: boolean | undefined;
            modulesRuntimeRequirements?: boolean | undefined;
            chunksRuntimeRequirements?: boolean | undefined;
            chunksHashes?: boolean | undefined;
            chunksRender?: boolean | undefined;
            emitAssets?: boolean | undefined;
        } | undefined;
        futureDefaults?: boolean | undefined;
        rspackFuture?: {
            bundlerInfo?: {
                version?: string | undefined;
                force?: boolean | ("version" | "uniqueId")[] | undefined;
                bundler?: string | undefined;
            } | undefined;
        } | undefined;
    } | undefined;
    devtool?: false | "eval" | "cheap-source-map" | "cheap-module-source-map" | "source-map" | "inline-cheap-source-map" | "inline-cheap-module-source-map" | "inline-source-map" | "inline-nosources-cheap-source-map" | "inline-nosources-cheap-module-source-map" | "inline-nosources-source-map" | "nosources-cheap-source-map" | "nosources-cheap-module-source-map" | "nosources-source-map" | "hidden-nosources-cheap-source-map" | "hidden-nosources-cheap-module-source-map" | "hidden-nosources-source-map" | "hidden-cheap-source-map" | "hidden-cheap-module-source-map" | "hidden-source-map" | "eval-cheap-source-map" | "eval-cheap-module-source-map" | "eval-source-map" | "eval-nosources-cheap-source-map" | "eval-nosources-cheap-module-source-map" | "eval-nosources-source-map" | undefined;
    resolve?: t.ResolveOptions | undefined;
    stats?: boolean | "none" | "verbose" | "normal" | "errors-only" | "errors-warnings" | "minimal" | "detailed" | "summary" | {
        modules?: boolean | undefined;
        chunks?: boolean | undefined;
        ids?: boolean | undefined;
        runtime?: boolean | undefined;
        hash?: boolean | undefined;
        all?: boolean | undefined;
        version?: boolean | undefined;
        publicPath?: boolean | undefined;
        preset?: boolean | "none" | "verbose" | "normal" | "errors-only" | "errors-warnings" | "minimal" | "detailed" | "summary" | undefined;
        assets?: boolean | undefined;
        entrypoints?: boolean | "auto" | undefined;
        chunkGroups?: boolean | undefined;
        warnings?: boolean | undefined;
        warningsCount?: boolean | undefined;
        errors?: boolean | undefined;
        errorsCount?: boolean | undefined;
        colors?: boolean | undefined;
        reasons?: boolean | undefined;
        outputPath?: boolean | undefined;
        chunkModules?: boolean | undefined;
        chunkRelations?: boolean | undefined;
        timings?: boolean | undefined;
        builtAt?: boolean | undefined;
        moduleAssets?: boolean | undefined;
        nestedModules?: boolean | undefined;
        source?: boolean | undefined;
        logging?: boolean | "error" | "warn" | "info" | "log" | "none" | "verbose" | undefined;
        loggingDebug?: string | boolean | RegExp | ((args_0: string, ...args: unknown[]) => boolean) | (string | RegExp | ((args_0: string, ...args: unknown[]) => boolean))[] | undefined;
        loggingTrace?: boolean | undefined;
        runtimeModules?: boolean | undefined;
        children?: boolean | undefined;
        usedExports?: boolean | undefined;
        providedExports?: boolean | undefined;
        optimizationBailout?: boolean | undefined;
        groupModulesByType?: boolean | undefined;
        groupModulesByCacheStatus?: boolean | undefined;
        groupModulesByLayer?: boolean | undefined;
        groupModulesByAttributes?: boolean | undefined;
        groupModulesByPath?: boolean | undefined;
        groupModulesByExtension?: boolean | undefined;
        modulesSpace?: number | undefined;
        chunkModulesSpace?: number | undefined;
        nestedModulesSpace?: number | undefined;
        relatedAssets?: boolean | undefined;
        groupAssetsByEmitStatus?: boolean | undefined;
        groupAssetsByInfo?: boolean | undefined;
        groupAssetsByPath?: boolean | undefined;
        groupAssetsByExtension?: boolean | undefined;
        groupAssetsByChunk?: boolean | undefined;
        assetsSpace?: number | undefined;
        orphanModules?: boolean | undefined;
        excludeModules?: string | boolean | RegExp | ((args_0: string, args_1: any, args_2: any) => boolean) | (string | RegExp | ((args_0: string, args_1: any, args_2: any) => boolean))[] | undefined;
        excludeAssets?: string | RegExp | ((args_0: string, args_1: any) => boolean) | (string | RegExp | ((args_0: string, args_1: any) => boolean))[] | undefined;
        modulesSort?: string | undefined;
        chunkModulesSort?: string | undefined;
        nestedModulesSort?: string | undefined;
        chunksSort?: string | undefined;
        assetsSort?: string | undefined;
        performance?: boolean | undefined;
        env?: boolean | undefined;
        chunkGroupAuxiliary?: boolean | undefined;
        chunkGroupChildren?: boolean | undefined;
        chunkGroupMaxAssets?: number | undefined;
        dependentModules?: boolean | undefined;
        chunkOrigins?: boolean | undefined;
        depth?: boolean | undefined;
        reasonsSpace?: number | undefined;
        groupReasonsByOrigin?: boolean | undefined;
        errorDetails?: boolean | undefined;
        errorStack?: boolean | undefined;
        moduleTrace?: boolean | undefined;
        cachedModules?: boolean | undefined;
        cachedAssets?: boolean | undefined;
        cached?: boolean | undefined;
        errorsSpace?: number | undefined;
        warningsSpace?: number | undefined;
    } | undefined;
    loader?: Record<string, any> | undefined;
    externals?: string | RegExp | Record<string, string | boolean | string[] | t.ExternalItemUmdValue | t.ExternalItemObjectValue> | ((args_0: t.ExternalItemFunctionData, args_1: (args_0: Error | undefined, args_1: string | boolean | string[] | t.ExternalItemUmdValue | t.ExternalItemObjectValue | undefined, args_2: "module" | "jsonp" | "import" | "var" | "assign" | "this" | "window" | "self" | "global" | "commonjs" | "commonjs2" | "commonjs-module" | "commonjs-static" | "amd" | "amd-require" | "umd" | "umd2" | "system" | "promise" | "module-import" | "script" | "node-commonjs" | "commonjs-import" | undefined, ...args: unknown[]) => void, ...args: unknown[]) => unknown) | ((args_0: t.ExternalItemFunctionData, ...args: unknown[]) => Promise<string | boolean | string[] | t.ExternalItemUmdValue | t.ExternalItemObjectValue>) | ((args_0: t.ExternalItemFunctionData, ...args: unknown[]) => string | boolean | string[] | t.ExternalItemUmdValue | t.ExternalItemObjectValue) | (string | RegExp | Record<string, string | boolean | string[] | t.ExternalItemUmdValue | t.ExternalItemObjectValue> | ((args_0: t.ExternalItemFunctionData, args_1: (args_0: Error | undefined, args_1: string | boolean | string[] | t.ExternalItemUmdValue | t.ExternalItemObjectValue | undefined, args_2: "module" | "jsonp" | "import" | "var" | "assign" | "this" | "window" | "self" | "global" | "commonjs" | "commonjs2" | "commonjs-module" | "commonjs-static" | "amd" | "amd-require" | "umd" | "umd2" | "system" | "promise" | "module-import" | "script" | "node-commonjs" | "commonjs-import" | undefined, ...args: unknown[]) => void, ...args: unknown[]) => unknown) | ((args_0: t.ExternalItemFunctionData, ...args: unknown[]) => Promise<string | boolean | string[] | t.ExternalItemUmdValue | t.ExternalItemObjectValue>) | ((args_0: t.ExternalItemFunctionData, ...args: unknown[]) => string | boolean | string[] | t.ExternalItemUmdValue | t.ExternalItemObjectValue))[] | undefined;
    target?: false | "async-node" | `node${number}` | `async-node${number}` | `node${number}.${number}` | `async-node${number}.${number}` | `electron${number}-main` | `electron${number}.${number}-main` | `electron${number}-renderer` | `electron${number}.${number}-renderer` | `electron${number}-preload` | `electron${number}.${number}-preload` | `nwjs${number}` | `nwjs${number}.${number}` | `node-webkit${number}` | `node-webkit${number}.${number}` | `browserslist:${string}` | "web" | "webworker" | "es3" | "es5" | "es2015" | "es2016" | "es2017" | "es2018" | "es2019" | "es2020" | "es2021" | "es2022" | "node" | "electron-main" | "electron-renderer" | "electron-preload" | "nwjs" | "node-webkit" | "browserslist" | ("async-node" | `node${number}` | `async-node${number}` | `node${number}.${number}` | `async-node${number}.${number}` | `electron${number}-main` | `electron${number}.${number}-main` | `electron${number}-renderer` | `electron${number}.${number}-renderer` | `electron${number}-preload` | `electron${number}.${number}-preload` | `nwjs${number}` | `nwjs${number}.${number}` | `node-webkit${number}` | `node-webkit${number}.${number}` | `browserslist:${string}` | "web" | "webworker" | "es3" | "es5" | "es2015" | "es2016" | "es2017" | "es2018" | "es2019" | "es2020" | "es2021" | "es2022" | "node" | "electron-main" | "electron-renderer" | "electron-preload" | "nwjs" | "node-webkit" | "browserslist")[] | undefined;
    entry?: string | string[] | Record<string, string | string[] | {
        import: string | string[];
        layer?: string | null | undefined;
        runtime?: string | false | undefined;
        chunkLoading?: string | false | undefined;
        asyncChunks?: boolean | undefined;
        publicPath?: string | ((args_0: PathData, args_1: JsAssetInfo | undefined, ...args: unknown[]) => string) | undefined;
        baseUri?: string | undefined;
        filename?: string | ((args_0: PathData, args_1: JsAssetInfo | undefined, ...args: unknown[]) => string) | undefined;
        library?: {
            type: string;
            name?: string | string[] | {
                commonjs?: string | undefined;
                amd?: string | undefined;
                root?: string | string[] | undefined;
            } | undefined;
            amdContainer?: string | undefined;
            auxiliaryComment?: string | {
                commonjs?: string | undefined;
                commonjs2?: string | undefined;
                amd?: string | undefined;
                root?: string | undefined;
            } | undefined;
            export?: string | string[] | undefined;
            umdNamedDefine?: boolean | undefined;
        } | undefined;
        wasmLoading?: string | false | undefined;
        dependOn?: string | string[] | undefined;
    }> | ((...args: unknown[]) => string | string[] | Record<string, string | string[] | {
        import: string | string[];
        layer?: string | null | undefined;
        runtime?: string | false | undefined;
        chunkLoading?: string | false | undefined;
        asyncChunks?: boolean | undefined;
        publicPath?: string | ((args_0: PathData, args_1: JsAssetInfo | undefined, ...args: unknown[]) => string) | undefined;
        baseUri?: string | undefined;
        filename?: string | ((args_0: PathData, args_1: JsAssetInfo | undefined, ...args: unknown[]) => string) | undefined;
        library?: {
            type: string;
            name?: string | string[] | {
                commonjs?: string | undefined;
                amd?: string | undefined;
                root?: string | string[] | undefined;
            } | undefined;
            amdContainer?: string | undefined;
            auxiliaryComment?: string | {
                commonjs?: string | undefined;
                commonjs2?: string | undefined;
                amd?: string | undefined;
                root?: string | undefined;
            } | undefined;
            export?: string | string[] | undefined;
            umdNamedDefine?: boolean | undefined;
        } | undefined;
        wasmLoading?: string | false | undefined;
        dependOn?: string | string[] | undefined;
    }> | Promise<string | string[] | Record<string, string | string[] | {
        import: string | string[];
        layer?: string | null | undefined;
        runtime?: string | false | undefined;
        chunkLoading?: string | false | undefined;
        asyncChunks?: boolean | undefined;
        publicPath?: string | ((args_0: PathData, args_1: JsAssetInfo | undefined, ...args: unknown[]) => string) | undefined;
        baseUri?: string | undefined;
        filename?: string | ((args_0: PathData, args_1: JsAssetInfo | undefined, ...args: unknown[]) => string) | undefined;
        library?: {
            type: string;
            name?: string | string[] | {
                commonjs?: string | undefined;
                amd?: string | undefined;
                root?: string | string[] | undefined;
            } | undefined;
            amdContainer?: string | undefined;
            auxiliaryComment?: string | {
                commonjs?: string | undefined;
                commonjs2?: string | undefined;
                amd?: string | undefined;
                root?: string | undefined;
            } | undefined;
            export?: string | string[] | undefined;
            umdNamedDefine?: boolean | undefined;
        } | undefined;
        wasmLoading?: string | false | undefined;
        dependOn?: string | string[] | undefined;
    }>>) | undefined;
    output?: {
        module?: boolean | undefined;
        chunkLoading?: string | false | undefined;
        asyncChunks?: boolean | undefined;
        publicPath?: string | ((args_0: PathData, args_1: JsAssetInfo | undefined, ...args: unknown[]) => string) | undefined;
        filename?: string | ((args_0: PathData, args_1: JsAssetInfo | undefined, ...args: unknown[]) => string) | undefined;
        library?: string | string[] | {
            commonjs?: string | undefined;
            amd?: string | undefined;
            root?: string | string[] | undefined;
        } | {
            type: string;
            name?: string | string[] | {
                commonjs?: string | undefined;
                amd?: string | undefined;
                root?: string | string[] | undefined;
            } | undefined;
            amdContainer?: string | undefined;
            auxiliaryComment?: string | {
                commonjs?: string | undefined;
                commonjs2?: string | undefined;
                amd?: string | undefined;
                root?: string | undefined;
            } | undefined;
            export?: string | string[] | undefined;
            umdNamedDefine?: boolean | undefined;
        } | undefined;
        wasmLoading?: string | false | undefined;
        cssHeadDataCompression?: boolean | undefined;
        auxiliaryComment?: string | {
            commonjs?: string | undefined;
            commonjs2?: string | undefined;
            amd?: string | undefined;
            root?: string | undefined;
        } | undefined;
        umdNamedDefine?: boolean | undefined;
        path?: string | undefined;
        pathinfo?: boolean | "verbose" | undefined;
        clean?: boolean | {
            keep?: string | undefined;
        } | undefined;
        chunkFilename?: string | ((args_0: PathData, args_1: JsAssetInfo | undefined, ...args: unknown[]) => string) | undefined;
        crossOriginLoading?: false | "anonymous" | "use-credentials" | undefined;
        cssFilename?: string | ((args_0: PathData, args_1: JsAssetInfo | undefined, ...args: unknown[]) => string) | undefined;
        cssChunkFilename?: string | ((args_0: PathData, args_1: JsAssetInfo | undefined, ...args: unknown[]) => string) | undefined;
        hotUpdateMainFilename?: string | undefined;
        hotUpdateChunkFilename?: string | undefined;
        hotUpdateGlobal?: string | undefined;
        assetModuleFilename?: string | ((args_0: PathData, args_1: JsAssetInfo | undefined, ...args: unknown[]) => string) | undefined;
        uniqueName?: string | undefined;
        chunkLoadingGlobal?: string | undefined;
        enabledLibraryTypes?: string[] | undefined;
        strictModuleErrorHandling?: boolean | undefined;
        globalObject?: string | undefined;
        importFunctionName?: string | undefined;
        importMetaName?: string | undefined;
        iife?: boolean | undefined;
        enabledWasmLoadingTypes?: string[] | undefined;
        webassemblyModuleFilename?: string | undefined;
        chunkFormat?: string | false | undefined;
        enabledChunkLoadingTypes?: string[] | undefined;
        trustedTypes?: string | true | {
            policyName?: string | undefined;
            onPolicyCreationFailure?: "continue" | "stop" | undefined;
        } | undefined;
        sourceMapFilename?: string | undefined;
        hashDigest?: string | undefined;
        hashDigestLength?: number | undefined;
        hashFunction?: "md4" | "xxhash64" | undefined;
        hashSalt?: string | undefined;
        workerChunkLoading?: string | false | undefined;
        workerWasmLoading?: string | false | undefined;
        workerPublicPath?: string | undefined;
        scriptType?: false | "module" | "text/javascript" | undefined;
        devtoolNamespace?: string | undefined;
        devtoolModuleFilenameTemplate?: string | ((args_0: any) => any) | undefined;
        devtoolFallbackModuleFilenameTemplate?: string | ((args_0: any) => any) | undefined;
        environment?: {
            module?: boolean | undefined;
            document?: boolean | undefined;
            nodePrefixForCoreModules?: boolean | undefined;
            globalThis?: boolean | undefined;
            bigIntLiteral?: boolean | undefined;
            const?: boolean | undefined;
            arrowFunction?: boolean | undefined;
            forOf?: boolean | undefined;
            destructuring?: boolean | undefined;
            dynamicImport?: boolean | undefined;
            dynamicImportInWorker?: boolean | undefined;
            optionalChaining?: boolean | undefined;
            templateLiteral?: boolean | undefined;
            asyncFunction?: boolean | undefined;
        } | undefined;
        charset?: boolean | undefined;
        chunkLoadTimeout?: number | undefined;
        compareBeforeEmit?: boolean | undefined;
        libraryExport?: string | string[] | undefined;
        libraryTarget?: string | undefined;
        strictModuleExceptionHandling?: boolean | undefined;
    } | undefined;
    resolveLoader?: t.ResolveOptions | undefined;
    externalsType?: "module" | "jsonp" | "import" | "var" | "assign" | "this" | "window" | "self" | "global" | "commonjs" | "commonjs2" | "commonjs-module" | "commonjs-static" | "amd" | "amd-require" | "umd" | "umd2" | "system" | "promise" | "module-import" | "script" | "node-commonjs" | "commonjs-import" | undefined;
    externalsPresets?: {
        web?: boolean | undefined;
        node?: boolean | undefined;
        nwjs?: boolean | undefined;
        electron?: boolean | undefined;
        electronMain?: boolean | undefined;
        electronPreload?: boolean | undefined;
        electronRenderer?: boolean | undefined;
        webAsync?: boolean | undefined;
    } | undefined;
    infrastructureLogging?: {
        debug?: string | boolean | RegExp | ((args_0: string, ...args: unknown[]) => boolean) | (string | RegExp | ((args_0: string, ...args: unknown[]) => boolean))[] | undefined;
        colors?: boolean | undefined;
        stream?: NodeJS.WritableStream | undefined;
        appendOnly?: boolean | undefined;
        console?: Console | undefined;
        level?: "error" | "warn" | "info" | "log" | "none" | "verbose" | undefined;
    } | undefined;
    snapshot?: {} | undefined;
    optimization?: {
        usedExports?: boolean | "global" | undefined;
        providedExports?: boolean | undefined;
        sideEffects?: boolean | "flag" | undefined;
        moduleIds?: "named" | "natural" | "deterministic" | undefined;
        chunkIds?: "size" | "named" | "natural" | "deterministic" | "total-size" | undefined;
        minimize?: boolean | undefined;
        minimizer?: (false | "" | 0 | "..." | t.RspackPluginInstance | t.WebpackPluginInstance | t.RspackPluginFunction | t.WebpackPluginFunction | null | undefined)[] | undefined;
        mergeDuplicateChunks?: boolean | undefined;
        splitChunks?: false | {
            chunks?: RegExp | "initial" | "async" | "all" | ((args_0: Chunk, ...args: unknown[]) => boolean) | undefined;
            name?: string | false | ((args_0: Module | undefined, ...args: unknown[]) => unknown) | undefined;
            usedExports?: boolean | undefined;
            defaultSizeTypes?: string[] | undefined;
            cacheGroups?: Record<string, false | {
                type?: string | RegExp | undefined;
                chunks?: RegExp | "initial" | "async" | "all" | ((args_0: Chunk, ...args: unknown[]) => boolean) | undefined;
                name?: string | false | ((args_0: Module | undefined, ...args: unknown[]) => unknown) | undefined;
                filename?: string | ((args_0: PathData, args_1: JsAssetInfo | undefined, ...args: unknown[]) => string) | undefined;
                usedExports?: boolean | undefined;
                defaultSizeTypes?: string[] | undefined;
                maxSize?: number | Record<string, number> | undefined;
                priority?: number | undefined;
                minSize?: number | Record<string, number> | undefined;
                maxAsyncSize?: number | Record<string, number> | undefined;
                maxInitialSize?: number | Record<string, number> | undefined;
                minChunks?: number | undefined;
                maxAsyncRequests?: number | undefined;
                maxInitialRequests?: number | undefined;
                automaticNameDelimiter?: string | undefined;
                test?: string | RegExp | ((args_0: Module, ...args: unknown[]) => unknown) | undefined;
                enforce?: boolean | undefined;
                reuseExistingChunk?: boolean | undefined;
                idHint?: string | undefined;
            }> | undefined;
            maxSize?: number | Record<string, number> | undefined;
            fallbackCacheGroup?: {
                chunks?: RegExp | "initial" | "async" | "all" | ((args_0: Chunk, ...args: unknown[]) => boolean) | undefined;
                maxSize?: number | undefined;
                minSize?: number | undefined;
                maxAsyncSize?: number | undefined;
                maxInitialSize?: number | undefined;
                automaticNameDelimiter?: string | undefined;
            } | undefined;
            minSize?: number | Record<string, number> | undefined;
            maxAsyncSize?: number | Record<string, number> | undefined;
            maxInitialSize?: number | Record<string, number> | undefined;
            hidePathInfo?: boolean | undefined;
            minChunks?: number | undefined;
            maxAsyncRequests?: number | undefined;
            maxInitialRequests?: number | undefined;
            automaticNameDelimiter?: string | undefined;
        } | undefined;
        runtimeChunk?: boolean | "single" | "multiple" | {
            name?: string | ((args_0: {
                name: string;
            }, ...args: unknown[]) => string) | undefined;
        } | undefined;
        removeAvailableModules?: boolean | undefined;
        removeEmptyChunks?: boolean | undefined;
        realContentHash?: boolean | undefined;
        concatenateModules?: boolean | undefined;
        innerGraph?: boolean | undefined;
        mangleExports?: boolean | "size" | "deterministic" | undefined;
        nodeEnv?: string | false | undefined;
        emitOnErrors?: boolean | undefined;
        avoidEntryIife?: boolean | undefined;
    } | undefined;
    plugins?: (false | "" | 0 | t.RspackPluginInstance | t.WebpackPluginInstance | t.RspackPluginFunction | t.WebpackPluginFunction | null | undefined)[] | undefined;
    watch?: boolean | undefined;
    watchOptions?: {
        aggregateTimeout?: number | undefined;
        followSymlinks?: boolean | undefined;
        ignored?: string | RegExp | string[] | undefined;
        poll?: number | boolean | undefined;
        stdin?: boolean | undefined;
    } | undefined;
    devServer?: t.DevServer | undefined;
    ignoreWarnings?: (RegExp | ((args_0: Error, args_1: Compilation, ...args: unknown[]) => boolean))[] | undefined;
    bail?: boolean | undefined;
}>;

// @public (undocumented)
class RspackOptionsApply {
    // (undocumented)
    process(options: RspackOptionsNormalized, compiler: Compiler): void;
}
export { RspackOptionsApply }
export { RspackOptionsApply as WebpackOptionsApply }

// @public (undocumented)
export interface RspackOptionsNormalized {
    // (undocumented)
    amd?: string;
    // (undocumented)
    bail?: Bail;
    // (undocumented)
    cache?: CacheOptions;
    // (undocumented)
    context?: Context;
    // (undocumented)
    dependencies?: Dependencies;
    // (undocumented)
    devServer?: DevServer;
    // (undocumented)
    devtool?: DevTool;
    // (undocumented)
    entry: EntryNormalized;
    // (undocumented)
    experiments: ExperimentsNormalized;
    // (undocumented)
    externals?: Externals;
    // (undocumented)
    externalsPresets: ExternalsPresets;
    // (undocumented)
    externalsType?: ExternalsType;
    // (undocumented)
    ignoreWarnings?: IgnoreWarningsNormalized;
    // (undocumented)
    infrastructureLogging: InfrastructureLogging;
    // (undocumented)
    loader: Loader;
    // (undocumented)
    mode?: Mode;
    // (undocumented)
    module: ModuleOptionsNormalized;
    // (undocumented)
    name?: Name;
    // (undocumented)
    node: Node_2;
    // (undocumented)
    optimization: Optimization;
    // (undocumented)
    output: OutputNormalized;
    // (undocumented)
    performance?: Performance_2;
    // (undocumented)
    plugins: Plugins;
    // (undocumented)
    profile?: Profile;
    // (undocumented)
    resolve: Resolve;
    // (undocumented)
    resolveLoader: Resolve;
    // (undocumented)
    snapshot: SnapshotOptions;
    // (undocumented)
    stats: StatsValue;
    // (undocumented)
    target?: Target;
    // (undocumented)
    watch?: Watch;
    // (undocumented)
    watchOptions: WatchOptions;
}

// @public (undocumented)
export type RspackPluginFunction = (this: Compiler, compiler: Compiler) => void;

// @public (undocumented)
export interface RspackPluginInstance {
    // (undocumented)
    [k: string]: any;
    // (undocumented)
    apply: (compiler: Compiler) => void;
}

// @public (undocumented)
export const rspackVersion: string;

// @public (undocumented)
type Rule = string | RegExp;

// @public (undocumented)
type Rules = Rule[] | Rule;

// @public (undocumented)
class RuleSetCompiler {
    constructor();
    builtinReferences: Map<string, any>;
    // (undocumented)
    references: Map<string, any>;
}

// @public (undocumented)
export type RuleSetCondition = string | RegExp | ((value: string) => boolean) | RuleSetConditions | RuleSetLogicalConditions;

// @public (undocumented)
export type RuleSetConditions = RuleSetCondition[];

// @public (undocumented)
export type RuleSetLoader = string;

// @public (undocumented)
export type RuleSetLoaderOptions = string | Record<string, any>;

// @public (undocumented)
export type RuleSetLoaderWithOptions = {
    ident?: string;
    loader: RuleSetLoader;
    options?: RuleSetLoaderOptions;
};

// @public (undocumented)
export type RuleSetLogicalConditions = {
    and?: RuleSetConditions;
    or?: RuleSetConditions;
    not?: RuleSetCondition;
};

// @public
export type RuleSetRule = {
    test?: RuleSetCondition;
    exclude?: RuleSetCondition;
    include?: RuleSetCondition;
    issuer?: RuleSetCondition;
    issuerLayer?: RuleSetCondition;
    dependency?: RuleSetCondition;
    resource?: RuleSetCondition;
    resourceFragment?: RuleSetCondition;
    resourceQuery?: RuleSetCondition;
    mimetype?: RuleSetCondition;
    scheme?: RuleSetCondition;
    descriptionData?: Record<string, RuleSetCondition>;
    with?: Record<string, RuleSetCondition>;
    type?: string;
    layer?: string;
    loader?: RuleSetLoader;
    options?: RuleSetLoaderOptions;
    use?: RuleSetUse;
    parser?: Record<string, any>;
    generator?: Record<string, any>;
    resolve?: ResolveOptions;
    sideEffects?: boolean;
    enforce?: "pre" | "post";
    oneOf?: (RuleSetRule | Falsy)[];
    rules?: (RuleSetRule | Falsy)[];
};

// @public
export type RuleSetRules = ("..." | RuleSetRule | Falsy)[];

// @public (undocumented)
export type RuleSetUse = RuleSetUseItem | RuleSetUseItem[] | ((data: RawFuncUseCtx) => RuleSetUseItem[]);

// @public (undocumented)
export type RuleSetUseItem = RuleSetLoader | RuleSetLoaderWithOptions;

// @public (undocumented)
const RuntimeChunkPlugin: {
    new (options: RawRuntimeChunkOptions): {
        name: BuiltinPluginName;
        _args: [options: RawRuntimeChunkOptions];
        affectedHooks: "done" | "make" | "environment" | "compile" | "emit" | "afterEmit" | "invalid" | "thisCompilation" | "afterDone" | "compilation" | "normalModuleFactory" | "contextModuleFactory" | "initialize" | "shouldEmit" | "infrastructureLog" | "beforeRun" | "run" | "assetEmitted" | "failed" | "shutdown" | "watchRun" | "watchClose" | "afterEnvironment" | "afterPlugins" | "afterResolvers" | "beforeCompile" | "afterCompile" | "finishMake" | "entryOption" | "additionalPass" | undefined;
        raw(compiler: Compiler_2): BuiltinPlugin;
        apply(compiler: Compiler_2): void;
    };
};

// @public (undocumented)
export const RuntimeGlobals: {
    readonly require: "__webpack_require__";
    readonly requireScope: "__webpack_require__.*";
    readonly exports: "__webpack_exports__";
    readonly thisAsExports: "top-level-this-exports";
    readonly returnExportsFromRuntime: "return-exports-from-runtime";
    readonly module: "module";
    readonly moduleId: "module.id";
    readonly moduleLoaded: "module.loaded";
    readonly publicPath: "__webpack_require__.p";
    readonly entryModuleId: "__webpack_require__.s";
    readonly moduleCache: "__webpack_require__.c";
    readonly moduleFactories: "__webpack_require__.m";
    readonly moduleFactoriesAddOnly: "__webpack_require__.m (add only)";
    readonly ensureChunk: "__webpack_require__.e";
    readonly ensureChunkHandlers: "__webpack_require__.f";
    readonly ensureChunkIncludeEntries: "__webpack_require__.f (include entries)";
    readonly prefetchChunk: "__webpack_require__.E";
    readonly prefetchChunkHandlers: "__webpack_require__.F";
    readonly preloadChunk: "__webpack_require__.G";
    readonly preloadChunkHandlers: "__webpack_require__.H";
    readonly definePropertyGetters: "__webpack_require__.d";
    readonly makeNamespaceObject: "__webpack_require__.r";
    readonly createFakeNamespaceObject: "__webpack_require__.t";
    readonly compatGetDefaultExport: "__webpack_require__.n";
    readonly harmonyModuleDecorator: "__webpack_require__.hmd";
    readonly nodeModuleDecorator: "__webpack_require__.nmd";
    readonly getFullHash: "__webpack_require__.h";
    readonly wasmInstances: "__webpack_require__.w";
    readonly instantiateWasm: "__webpack_require__.v";
    readonly uncaughtErrorHandler: "__webpack_require__.oe";
    readonly scriptNonce: "__webpack_require__.nc";
    readonly loadScript: "__webpack_require__.l";
    readonly createScript: "__webpack_require__.ts";
    readonly createScriptUrl: "__webpack_require__.tu";
    readonly getTrustedTypesPolicy: "__webpack_require__.tt";
    readonly hasFetchPriority: "has fetch priority";
    readonly chunkName: "__webpack_require__.cn";
    readonly runtimeId: "__webpack_require__.j";
    readonly getChunkScriptFilename: "__webpack_require__.u";
    readonly getChunkCssFilename: "__webpack_require__.k";
    readonly hasCssModules: "has css modules";
    readonly getChunkUpdateScriptFilename: "__webpack_require__.hu";
    readonly getChunkUpdateCssFilename: "__webpack_require__.hk";
    readonly startup: "__webpack_require__.x";
    readonly startupNoDefault: "__webpack_require__.x (no default handler)";
    readonly startupOnlyAfter: "__webpack_require__.x (only after)";
    readonly startupOnlyBefore: "__webpack_require__.x (only before)";
    readonly chunkCallback: "webpackChunk";
    readonly startupEntrypoint: "__webpack_require__.X";
    readonly onChunksLoaded: "__webpack_require__.O";
    readonly externalInstallChunk: "__webpack_require__.C";
    readonly interceptModuleExecution: "__webpack_require__.i";
    readonly global: "__webpack_require__.g";
    readonly shareScopeMap: "__webpack_require__.S";
    readonly initializeSharing: "__webpack_require__.I";
    readonly currentRemoteGetScope: "__webpack_require__.R";
    readonly getUpdateManifestFilename: "__webpack_require__.hmrF";
    readonly hmrDownloadManifest: "__webpack_require__.hmrM";
    readonly hmrDownloadUpdateHandlers: "__webpack_require__.hmrC";
    readonly hmrModuleData: "__webpack_require__.hmrD";
    readonly hmrInvalidateModuleHandlers: "__webpack_require__.hmrI";
    readonly hmrRuntimeStatePrefix: "__webpack_require__.hmrS";
    readonly amdDefine: "__webpack_require__.amdD";
    readonly amdOptions: "__webpack_require__.amdO";
    readonly system: "__webpack_require__.System";
    readonly hasOwnProperty: "__webpack_require__.o";
    readonly systemContext: "__webpack_require__.y";
    readonly baseURI: "__webpack_require__.b";
    readonly relativeUrl: "__webpack_require__.U";
    readonly asyncModule: "__webpack_require__.a";
};

// @public (undocumented)
export class RuntimeModule {
    constructor(name: string, stage?: RuntimeModuleStage);
    // (undocumented)
    static __to_binding(compilation: Compilation, module: RuntimeModule): JsAddingRuntimeModule;
    // (undocumented)
    attach(compilation: Compilation, chunk: Chunk, chunkGraph: ChunkGraph): void;
    // (undocumented)
    protected chunk: Chunk | null;
    // (undocumented)
    protected chunkGraph: ChunkGraph | null;
    // (undocumented)
    protected compilation: Compilation | null;
    // (undocumented)
    dependentHash: boolean;
    // (undocumented)
    fullHash: boolean;
    // (undocumented)
    generate(): string;
    // (undocumented)
    identifier(): string;
    // (undocumented)
    get name(): string;
    // (undocumented)
    readableIdentifier(): string;
    // (undocumented)
    shouldIsolate(): boolean;
    // (undocumented)
    get stage(): RuntimeModuleStage;
    // (undocumented)
    static STAGE_ATTACH: RuntimeModuleStage;
    // (undocumented)
    static STAGE_BASIC: RuntimeModuleStage;
    // (undocumented)
    static STAGE_NORMAL: RuntimeModuleStage;
    // (undocumented)
    static STAGE_TRIGGER: RuntimeModuleStage;
}

// @public (undocumented)
enum RuntimeModuleStage {
    // (undocumented)
    ATTACH = 10,
    // (undocumented)
    BASIC = 5,
    // (undocumented)
    NORMAL = 0,
    // (undocumented)
    TRIGGER = 20
}

// @public (undocumented)
type RuntimePlugins = string[];

// @public (undocumented)
type RuntimeSpec = string | string[] | undefined;

// @public (undocumented)
type SafeParseError<Input> = {
    success: false;
    error: ZodError<Input>;
    data?: never;
};

// @public (undocumented)
type SafeParseReturnType<Input, Output> = SafeParseSuccess<Output> | SafeParseError<Input>;

// @public (undocumented)
type SafeParseSuccess<Output> = {
    success: true;
    data: Output;
    error?: never;
};

// @public (undocumented)
export type ScriptType = false | "text/javascript" | "module";

// @public (undocumented)
export type Shared = (SharedItem | SharedObject)[] | SharedObject;

// @public (undocumented)
export type SharedConfig = {
    eager?: boolean;
    import?: false | SharedItem;
    packageName?: string;
    requiredVersion?: false | string;
    shareKey?: string;
    shareScope?: string;
    singleton?: boolean;
    strictVersion?: boolean;
    version?: false | string;
};

// @public (undocumented)
export type SharedItem = string;

// @public (undocumented)
export type SharedObject = {
    [k: string]: SharedConfig | SharedItem;
};

// @public (undocumented)
type SharedOptimizationSplitChunksCacheGroup = {
    chunks?: OptimizationSplitChunksChunks;
    defaultSizeTypes?: string[];
    minChunks?: number;
    usedExports?: boolean;
    name?: false | OptimizationSplitChunksName;
    minSize?: OptimizationSplitChunksSizes;
    maxSize?: OptimizationSplitChunksSizes;
    maxAsyncSize?: OptimizationSplitChunksSizes;
    maxInitialSize?: OptimizationSplitChunksSizes;
    maxAsyncRequests?: number;
    maxInitialRequests?: number;
    automaticNameDelimiter?: string;
};

// @public (undocumented)
class SharePlugin {
    constructor(options: SharePluginOptions);
    // (undocumented)
    apply(compiler: Compiler): void;
    // (undocumented)
    _consumes: {
        [x: string]: {
            import: string | false | undefined;
            shareKey: string;
            shareScope: string | undefined;
            requiredVersion: string | false | undefined;
            strictVersion: boolean | undefined;
            singleton: boolean | undefined;
            packageName: string | undefined;
            eager: boolean | undefined;
        };
    }[];
    // (undocumented)
    _enhanced: boolean;
    // (undocumented)
    _provides: {
        [x: string]: {
            shareKey: string;
            shareScope: string | undefined;
            version: string | false | undefined;
            eager: boolean | undefined;
            singleton: boolean | undefined;
            requiredVersion: string | false | undefined;
            strictVersion: boolean | undefined;
        };
    }[];
    // (undocumented)
    _shareScope: string | undefined;
}

// @public (undocumented)
export type SharePluginOptions = {
    shareScope?: string;
    shared: Shared;
    enhanced: boolean;
};

// @public (undocumented)
export const sharing: {
    ProvideSharedPlugin: typeof ProvideSharedPlugin;
    ConsumeSharedPlugin: typeof ConsumeSharedPlugin;
    SharePlugin: typeof SharePlugin;
};

// @public (undocumented)
export type SnapshotOptions = {};

// @public (undocumented)
abstract class Source {
    	// (undocumented)
    buffer(): Buffer;

    	// (undocumented)
    map(options?: MapOptions): RawSourceMap | null;

    	// (undocumented)
    size(): number;

    	// (undocumented)
    source(): string | Buffer;

    	// (undocumented)
    sourceAndMap(options?: MapOptions): {
        		source: string | Buffer;
        		map: Object;
        	};

    	// (undocumented)
    updateHash(hash: Hash): void;
}

// @public (undocumented)
interface SourceMap {
    // (undocumented)
    file?: string;
    // (undocumented)
    mappings: string;
    // (undocumented)
    names?: string[];
    // (undocumented)
    sourceRoot?: string;
    // (undocumented)
    sources: string[];
    // (undocumented)
    sourcesContent?: string[];
    // (undocumented)
    version: number;
}

// @public (undocumented)
export const SourceMapDevToolPlugin: {
    new (options: SourceMapDevToolPluginOptions): {
        name: BuiltinPluginName;
        _args: [options: SourceMapDevToolPluginOptions];
        affectedHooks: "done" | "make" | "environment" | "compile" | "emit" | "afterEmit" | "invalid" | "thisCompilation" | "afterDone" | "compilation" | "normalModuleFactory" | "contextModuleFactory" | "initialize" | "shouldEmit" | "infrastructureLog" | "beforeRun" | "run" | "assetEmitted" | "failed" | "shutdown" | "watchRun" | "watchClose" | "afterEnvironment" | "afterPlugins" | "afterResolvers" | "beforeCompile" | "afterCompile" | "finishMake" | "entryOption" | "additionalPass" | undefined;
        raw(compiler: Compiler_2): BuiltinPlugin;
        apply(compiler: Compiler_2): void;
    };
};

export { SourceMapDevToolPluginOptions }

// @public
export type SourceMapFilename = string;

export { sources }

// @public (undocumented)
class SplitChunksPlugin extends RspackBuiltinPlugin {
    constructor(options: OptimizationSplitChunksOptions);
    // (undocumented)
    affectedHooks: "thisCompilation";
    // (undocumented)
    name: BuiltinPluginName;
    // (undocumented)
    raw(compiler: Compiler): BuiltinPlugin;
}

// @public (undocumented)
type Stat = {
    (path: PathLike, callback: StatsCallback): void;
    (path: PathLike, options: (StatOptions & {
        bigint?: false;
    }) | undefined, callback: StatsCallback): void;
    (path: PathLike, options: StatOptions & {
        bigint: true;
    }, callback: BigIntStatsCallback): void;
    (path: PathLike, options: StatOptions | undefined, callback: StatsOrBigIntStatsCallback): void;
};

// @public (undocumented)
type StatOptions = {
    bigint?: boolean;
};

// @public (undocumented)
export class Stats {
    constructor(compilation: Compilation);
    // (undocumented)
    get compilation(): Compilation;
    // (undocumented)
    get endTime(): number | undefined;
    // (undocumented)
    hasErrors(): boolean;
    // (undocumented)
    get hash(): Readonly<string | null>;
    // (undocumented)
    hasWarnings(): boolean;
    // (undocumented)
    get startTime(): number | undefined;
    // (undocumented)
    toJson(opts?: StatsValue, forToString?: boolean): StatsCompilation;
    // (undocumented)
    toString(opts?: StatsValue): string;
}

// @public (undocumented)
export type StatsAsset = KnownStatsAsset & Record<string, any>;

// @public (undocumented)
type StatsCallback = (err: NodeJS.ErrnoException | null, stats?: IStats) => void;

// @public (undocumented)
export type StatsChunk = KnownStatsChunk & Record<string, any>;

// @public (undocumented)
type StatsChunkGroup = KnownStatsChunkGroup & Record<string, any>;

// @public (undocumented)
type StatsChunkOrigin = KnownStatsChunkOrigin & Record<string, any>;

// @public (undocumented)
export type StatsCompilation = KnownStatsCompilation & Record<string, any>;

// @public (undocumented)
export type StatsError = KnownStatsError & Record<string, any>;

// @public (undocumented)
class StatsFactory {
    constructor();
    // (undocumented)
    create(type: string, data: any, baseContext: Omit<StatsFactoryContext, "type">): any;
    // (undocumented)
    _forEachLevel(hookMap: HookMap<any>, cache: CacheHookMap, type: string, fn: CallFn): any;
    // (undocumented)
    _forEachLevelFilter(hookMap: HookMap<any>, cache: CacheHookMap, type: string, items: any[], fn: CallFn, forceClone: boolean): any[];
    // (undocumented)
    _forEachLevelWaterfall(hookMap: HookMap<any>, cache: CacheHookMap, type: string, data: any, fn: CallFn): any;
    // (undocumented)
    _getAllLevelHooks(hookMap: HookMap<any>, cache: CacheHookMap, type: string): any[];
    // (undocumented)
    hooks: Hooks;
}

// @public (undocumented)
type StatsFactoryContext = KnownStatsFactoryContext & Record<string, any>;

// @public (undocumented)
type StatsLogging = KnownStatsLogging & Record<string, any>;

// @public (undocumented)
type StatsLoggingEntry = KnownStatsLoggingEntry & Record<string, any>;

// @public (undocumented)
export type StatsModule = KnownStatsModule & Record<string, any>;

// @public (undocumented)
type StatsModuleIssuer = KnownStatsModuleIssuer & Record<string, any>;

// @public (undocumented)
type StatsModuleReason = KnownStatsModuleReason & Record<string, any>;

// @public (undocumented)
type StatsModuleTraceItem = {
    originIdentifier?: string;
    originName?: string;
    moduleIdentifier?: string;
    moduleName?: string;
    originId?: string;
    moduleId?: string;
};

// @public
export type StatsOptions = {
    all?: boolean;
    preset?: boolean | StatsPresets;
    assets?: boolean;
    chunks?: boolean;
    modules?: boolean;
    entrypoints?: boolean | "auto";
    chunkGroups?: boolean;
    warnings?: boolean;
    warningsCount?: boolean;
    errors?: boolean;
    errorsCount?: boolean;
    colors?: boolean;
    hash?: boolean;
    version?: boolean;
    reasons?: boolean;
    publicPath?: boolean;
    outputPath?: boolean;
    chunkModules?: boolean;
    chunkRelations?: boolean;
    ids?: boolean;
    timings?: boolean;
    builtAt?: boolean;
    moduleAssets?: boolean;
    nestedModules?: boolean;
    source?: boolean;
    logging?: "none" | "error" | "warn" | "info" | "log" | "verbose" | boolean;
    loggingDebug?: boolean | FilterTypes;
    loggingTrace?: boolean;
    runtimeModules?: boolean;
    children?: boolean;
    usedExports?: boolean;
    providedExports?: boolean;
    optimizationBailout?: boolean;
    groupModulesByType?: boolean;
    groupModulesByCacheStatus?: boolean;
    groupModulesByLayer?: boolean;
    groupModulesByAttributes?: boolean;
    groupModulesByPath?: boolean;
    groupModulesByExtension?: boolean;
    modulesSpace?: number;
    chunkModulesSpace?: number;
    nestedModulesSpace?: number;
    relatedAssets?: boolean;
    groupAssetsByEmitStatus?: boolean;
    groupAssetsByInfo?: boolean;
    groupAssetsByPath?: boolean;
    groupAssetsByExtension?: boolean;
    groupAssetsByChunk?: boolean;
    assetsSpace?: number;
    orphanModules?: boolean;
    excludeModules?: ModuleFilterTypes;
    excludeAssets?: ModuleFilterTypes;
    modulesSort?: string;
    chunkModulesSort?: string;
    nestedModulesSort?: string;
    chunksSort?: string;
    assetsSort?: string;
    performance?: boolean;
    env?: boolean;
    chunkGroupAuxiliary?: boolean;
    chunkGroupChildren?: boolean;
    chunkGroupMaxAssets?: number;
    dependentModules?: boolean;
    chunkOrigins?: boolean;
    runtime?: boolean;
    depth?: boolean;
    reasonsSpace?: number;
    groupReasonsByOrigin?: boolean;
    errorDetails?: boolean;
    errorStack?: boolean;
    moduleTrace?: boolean;
    cachedModules?: boolean;
    cachedAssets?: boolean;
    cached?: boolean;
    errorsSpace?: number;
    warningsSpace?: number;
};

// @public (undocumented)
type StatsOrBigIntStatsCallback = (err: NodeJS.ErrnoException | null, stats?: IStats | IBigIntStats) => void;

// @public (undocumented)
type StatsPresets = "normal" | "none" | "verbose" | "errors-only" | "errors-warnings" | "minimal" | "detailed" | "summary";

// @public (undocumented)
class StatsPrinter {
    constructor();
    // (undocumented)
    hooks: Readonly<{
        sortElements: HookMap<SyncBailHook<[string[], StatsPrinterContext], true | void>>;
        printElements: HookMap<SyncBailHook<[PrintedElement[], StatsPrinterContext], string>>;
        sortItems: HookMap<SyncBailHook<[any[], StatsPrinterContext], true>>;
        getItemName: HookMap<SyncBailHook<[any, StatsPrinterContext], string>>;
        printItems: HookMap<SyncBailHook<[string[], StatsPrinterContext], string>>;
        print: HookMap<SyncBailHook<[{}, StatsPrinterContext], string>>;
        result: HookMap<SyncWaterfallHook<[string, StatsPrinterContext]>>;
    }>;
    // (undocumented)
    print(type: string, object: {
        [key: string]: any;
    }, baseContext?: {
        [key: string]: any;
    }): string;
}

// @public (undocumented)
type StatsPrinterContext = KnownStatsPrinterContext & Record<string, any>;

// @public (undocumented)
type StatsProfile = KnownStatsProfile & Record<string, any>;

// @public
export type StatsValue = boolean | StatsOptions | StatsPresets;

// @public (undocumented)
type StatSync = {
    (path: PathLike, options?: undefined): IStats;
    (path: PathLike, options?: StatSyncOptions & {
        bigint?: false;
        throwIfNoEntry: false;
    }): IStats | undefined;
    (path: PathLike, options: StatSyncOptions & {
        bigint: true;
        throwIfNoEntry: false;
    }): IBigIntStats | undefined;
    (path: PathLike, options?: StatSyncOptions & {
        bigint?: false;
    }): IStats;
    (path: PathLike, options: StatSyncOptions & {
        bigint: true;
    }): IBigIntStats;
    (path: PathLike, options: StatSyncOptions & {
        bigint: boolean;
        throwIfNoEntry?: false;
    }): IStats | IBigIntStats;
    (path: PathLike, options?: StatSyncOptions): IStats | IBigIntStats | undefined;
};

// @public (undocumented)
type StatSyncOptions = {
    bigint?: boolean;
    throwIfNoEntry?: boolean;
};

// @public
export type StrictModuleErrorHandling = boolean;

// @public
export type StrictModuleExceptionHandling = boolean;

// @public (undocumented)
type StringCallback = (err: NodeJS.ErrnoException | null, data?: string) => void;

// @public (undocumented)
type StringOrBufferCallback = (err: NodeJS.ErrnoException | null, data?: string | Buffer) => void;

// @public (undocumented)
type StringValidation = "email" | "url" | "emoji" | "uuid" | "nanoid" | "regex" | "cuid" | "cuid2" | "ulid" | "datetime" | "date" | "time" | "duration" | "ip" | "base64" | {
    includes: string;
    position?: number;
} | {
    startsWith: string;
} | {
    endsWith: string;
};

// @public (undocumented)
type stripPath<T extends object> = T extends any ? util_2.OmitKeys<T, "path"> : never;

// @public (undocumented)
export const SwcJsMinimizerRspackPlugin: {
    new (options?: SwcJsMinimizerRspackPluginOptions | undefined): {
        name: BuiltinPluginName;
        _args: [options?: SwcJsMinimizerRspackPluginOptions | undefined];
        affectedHooks: "done" | "make" | "environment" | "compile" | "emit" | "afterEmit" | "invalid" | "thisCompilation" | "afterDone" | "compilation" | "normalModuleFactory" | "contextModuleFactory" | "initialize" | "shouldEmit" | "infrastructureLog" | "beforeRun" | "run" | "assetEmitted" | "failed" | "shutdown" | "watchRun" | "watchClose" | "afterEnvironment" | "afterPlugins" | "afterResolvers" | "beforeCompile" | "afterCompile" | "finishMake" | "entryOption" | "additionalPass" | undefined;
        raw(compiler: Compiler_2): BuiltinPlugin;
        apply(compiler: Compiler_2): void;
    };
};

// @public (undocumented)
export type SwcJsMinimizerRspackPluginOptions = {
    test?: AssetConditions;
    exclude?: AssetConditions;
    include?: AssetConditions;
    extractComments?: ExtractCommentsOptions | undefined;
    minimizerOptions?: {
        minify?: boolean;
        compress?: TerserCompressOptions | boolean;
        mangle?: TerserMangleOptions | boolean;
        format?: JsFormatOptions & ToSnakeCaseProperties<JsFormatOptions>;
        module?: boolean;
    };
};

// @public (undocumented)
export type SwcLoaderEnvConfig = EnvConfig;

// @public (undocumented)
export type SwcLoaderEsParserConfig = EsParserConfig;

// @public (undocumented)
export type SwcLoaderJscConfig = JscConfig;

// @public (undocumented)
export type SwcLoaderModuleConfig = ModuleConfig;

// @public (undocumented)
export type SwcLoaderOptions = Config_2 & {
    isModule?: boolean | "unknown";
    rspackExperiments?: {
        import?: PluginImportOptions;
    };
};

// @public (undocumented)
export type SwcLoaderParserConfig = ParserConfig;

// @public (undocumented)
export type SwcLoaderTransformConfig = TransformConfig;

// @public (undocumented)
export type SwcLoaderTsParserConfig = TsParserConfig;

// @public (undocumented)
type SyncParseReturnType<T = any> = OK<T> | DIRTY<T> | INVALID;

// @public (undocumented)
interface SystemjsConfig {
    // (undocumented)
    allowTopLevelThis?: boolean;
    // (undocumented)
    type: "systemjs";
}

declare namespace t {
    export {
        FilenameTemplate,
        Filename,
        Name,
        Dependencies,
        Context,
        Mode,
        Falsy,
        PublicPath,
        BaseUri,
        ChunkLoadingType,
        ChunkLoading,
        AsyncChunks,
        WasmLoadingType,
        WasmLoading,
        ScriptType,
        LibraryCustomUmdObject,
        LibraryName,
        LibraryCustomUmdCommentObject,
        AmdContainer,
        AuxiliaryComment,
        LibraryExport,
        LibraryType,
        UmdNamedDefine,
        LibraryOptions,
        Library,
        Layer,
        EntryFilename,
        EntryRuntime,
        EntryItem,
        EntryDependOn,
        EntryDescription,
        EntryUnnamed,
        EntryObject,
        EntryStatic,
        EntryDynamic,
        Entry,
        Path,
        Pathinfo,
        AssetModuleFilename,
        WebassemblyModuleFilename,
        ChunkFilename,
        CrossOriginLoading,
        CssFilename,
        CssChunkFilename,
        HotUpdateChunkFilename,
        HotUpdateMainFilename,
        HotUpdateGlobal,
        UniqueName,
        ChunkLoadingGlobal,
        EnabledLibraryTypes,
        Clean,
        OutputModule,
        StrictModuleExceptionHandling,
        StrictModuleErrorHandling,
        GlobalObject,
        EnabledWasmLoadingTypes,
        ImportFunctionName,
        ImportMetaName,
        Iife,
        EnabledChunkLoadingTypes,
        ChunkFormat,
        WorkerPublicPath,
        TrustedTypes,
        HashDigest,
        HashDigestLength,
        HashFunction,
        HashSalt,
        SourceMapFilename,
        DevtoolNamespace,
        DevtoolModuleFilenameTemplate,
        DevtoolFallbackModuleFilenameTemplate,
        Environment,
        Output,
        ResolveAlias,
        ResolveTsConfig,
        ResolveOptions,
        Resolve,
        RuleSetCondition,
        RuleSetConditions,
        RuleSetLogicalConditions,
        RuleSetLoader,
        RuleSetLoaderOptions,
        RuleSetLoaderWithOptions,
        RuleSetUseItem,
        RuleSetUse,
        RuleSetRule,
        RuleSetRules,
        AssetParserDataUrlOptions,
        AssetParserDataUrl,
        AssetParserOptions,
        CssParserNamedExports,
        CssParserOptions,
        CssAutoParserOptions,
        CssModuleParserOptions,
        JavascriptParserOptions,
        JsonParserOptions,
        ParserOptionsByModuleTypeKnown,
        ParserOptionsByModuleTypeUnknown,
        ParserOptionsByModuleType,
        AssetGeneratorDataUrlOptions,
        AssetGeneratorDataUrlFunction,
        AssetGeneratorDataUrl,
        AssetInlineGeneratorOptions,
        AssetModuleOutputPath,
        AssetResourceGeneratorOptions,
        AssetGeneratorOptions,
        CssGeneratorExportsConvention,
        CssGeneratorExportsOnly,
        CssGeneratorLocalIdentName,
        CssGeneratorEsModule,
        CssGeneratorOptions,
        CssAutoGeneratorOptions,
        CssModuleGeneratorOptions,
        GeneratorOptionsByModuleTypeKnown,
        GeneratorOptionsByModuleTypeUnknown,
        GeneratorOptionsByModuleType,
        NoParseOption,
        ModuleOptions,
        Target,
        ExternalsType,
        ExternalItemUmdValue,
        ExternalItemObjectValue,
        ExternalItemValue,
        ExternalItemObjectUnknown,
        ExternalItemFunctionData,
        ExternalItem,
        Externals,
        ExternalsPresets,
        FilterItemTypes,
        FilterTypes,
        InfrastructureLogging,
        DevTool,
        NodeOptions,
        Node_2 as Node,
        Loader,
        SnapshotOptions,
        CacheOptions,
        StatsOptions,
        StatsValue,
        RspackPluginInstance,
        RspackPluginFunction,
        WebpackCompiler,
        WebpackPluginInstance,
        WebpackPluginFunction,
        Plugin_2 as Plugin,
        Plugins,
        OptimizationRuntimeChunk,
        OptimizationSplitChunksNameFunction,
        OptimizationSplitChunksCacheGroup,
        OptimizationSplitChunksOptions,
        Optimization,
        ExperimentCacheOptions,
        RspackFutureOptions,
        LazyCompilationOptions,
        Incremental,
        Experiments,
        Watch,
        WatchOptions,
        DevServer,
        IgnoreWarnings,
        Profile,
        Amd,
        Bail,
        Performance_2 as Performance,
        RspackOptions,
        Configuration
    }
}

// @public
export type Target = false | AllowTarget | AllowTarget[];

// @public (undocumented)
interface Targets {
    // (undocumented)
    android?: number;
    // (undocumented)
    chrome?: number;
    // (undocumented)
    edge?: number;
    // (undocumented)
    firefox?: number;
    // (undocumented)
    ie?: number;
    // (undocumented)
    ios_saf?: number;
    // (undocumented)
    opera?: number;
    // (undocumented)
    safari?: number;
    // (undocumented)
    samsung?: number;
}

// @public
export class Template {
    // (undocumented)
    static asString(str: string | string[]): string;
    // (undocumented)
    static getFunctionContent(fn: Function): string;
    // (undocumented)
    static getModulesArrayBounds(modules: {
        id: string | number;
    }[]): [number, number] | false;
    // (undocumented)
    static indent(s: string | string[]): string;
    // (undocumented)
    static numberToIdentifier(num: number): string;
    // (undocumented)
    static numberToIdentifierContinuation(num: number): string;
    // (undocumented)
    static prefix(s: string | string[], prefix: string): string;
    // (undocumented)
    static toComment(str: string): string;
    // (undocumented)
    static toIdentifier(str: any): string;
    // (undocumented)
    static toNormalComment(str: string): string;
    // (undocumented)
    static toPath(str: string): string;
}

// @public (undocumented)
type TemplateParamFunction = (params: Record<string, any>) => Record<string, any> | Promise<Record<string, any>>;

// @public (undocumented)
type TemplateRenderFunction = (params: Record<string, any>) => string | Promise<string>;

// @public (undocumented)
interface TerserCompressOptions {
    // (undocumented)
    arguments?: boolean;
    // (undocumented)
    arrows?: boolean;
    // (undocumented)
    booleans?: boolean;
    // (undocumented)
    booleans_as_integers?: boolean;
    // (undocumented)
    collapse_vars?: boolean;
    // (undocumented)
    comparisons?: boolean;
    // (undocumented)
    computed_props?: boolean;
    // (undocumented)
    conditionals?: boolean;
    // (undocumented)
    const_to_let?: boolean;
    // (undocumented)
    dead_code?: boolean;
    // (undocumented)
    defaults?: boolean;
    // (undocumented)
    directives?: boolean;
    // (undocumented)
    drop_console?: boolean;
    // (undocumented)
    drop_debugger?: boolean;
    // (undocumented)
    ecma?: TerserEcmaVersion;
    // (undocumented)
    evaluate?: boolean;
    // (undocumented)
    expression?: boolean;
    // (undocumented)
    global_defs?: any;
    // (undocumented)
    hoist_funs?: boolean;
    // (undocumented)
    hoist_props?: boolean;
    // (undocumented)
    hoist_vars?: boolean;
    // (undocumented)
    ie8?: boolean;
    // (undocumented)
    if_return?: boolean;
    // (undocumented)
    inline?: 0 | 1 | 2 | 3;
    // (undocumented)
    join_vars?: boolean;
    // (undocumented)
    keep_classnames?: boolean;
    // (undocumented)
    keep_fargs?: boolean;
    // (undocumented)
    keep_fnames?: boolean;
    // (undocumented)
    keep_infinity?: boolean;
    // (undocumented)
    loops?: boolean;
    // (undocumented)
    module?: boolean;
    // (undocumented)
    negate_iife?: boolean;
    // (undocumented)
    passes?: number;
    // (undocumented)
    properties?: boolean;
    // (undocumented)
    pure_funcs?: string[];
    // (undocumented)
    pure_getters?: any;
    // (undocumented)
    reduce_funcs?: boolean;
    // (undocumented)
    reduce_vars?: boolean;
    // (undocumented)
    sequences?: any;
    // (undocumented)
    side_effects?: boolean;
    // (undocumented)
    switches?: boolean;
    // (undocumented)
    top_retain?: any;
    // (undocumented)
    toplevel?: any;
    // (undocumented)
    typeofs?: boolean;
    // (undocumented)
    unsafe?: boolean;
    // (undocumented)
    unsafe_arrows?: boolean;
    // (undocumented)
    unsafe_comps?: boolean;
    // (undocumented)
    unsafe_function?: boolean;
    // (undocumented)
    unsafe_math?: boolean;
    // (undocumented)
    unsafe_methods?: boolean;
    // (undocumented)
    unsafe_passes?: boolean;
    // (undocumented)
    unsafe_proto?: boolean;
    // (undocumented)
    unsafe_regexp?: boolean;
    // (undocumented)
    unsafe_symbols?: boolean;
    // (undocumented)
    unsafe_undefined?: boolean;
    // (undocumented)
    unused?: boolean;
}

// @public (undocumented)
interface TerserCompressOptions_2 {
    // (undocumented)
    arguments?: boolean;
    // (undocumented)
    arrows?: boolean;
    // (undocumented)
    booleans?: boolean;
    // (undocumented)
    booleans_as_integers?: boolean;
    // (undocumented)
    collapse_vars?: boolean;
    // (undocumented)
    comparisons?: boolean;
    // (undocumented)
    computed_props?: boolean;
    // (undocumented)
    conditionals?: boolean;
    // (undocumented)
    const_to_let?: boolean;
    // (undocumented)
    dead_code?: boolean;
    // (undocumented)
    defaults?: boolean;
    // (undocumented)
    directives?: boolean;
    // (undocumented)
    drop_console?: boolean;
    // (undocumented)
    drop_debugger?: boolean;
    // (undocumented)
    ecma?: TerserEcmaVersion_2;
    // (undocumented)
    evaluate?: boolean;
    // (undocumented)
    expression?: boolean;
    // (undocumented)
    global_defs?: any;
    // (undocumented)
    hoist_funs?: boolean;
    // (undocumented)
    hoist_props?: boolean;
    // (undocumented)
    hoist_vars?: boolean;
    // (undocumented)
    ie8?: boolean;
    // (undocumented)
    if_return?: boolean;
    // (undocumented)
    inline?: 0 | 1 | 2 | 3;
    // (undocumented)
    join_vars?: boolean;
    // (undocumented)
    keep_classnames?: boolean;
    // (undocumented)
    keep_fargs?: boolean;
    // (undocumented)
    keep_fnames?: boolean;
    // (undocumented)
    keep_infinity?: boolean;
    // (undocumented)
    loops?: boolean;
    // (undocumented)
    module?: boolean;
    // (undocumented)
    negate_iife?: boolean;
    // (undocumented)
    passes?: number;
    // (undocumented)
    properties?: boolean;
    // (undocumented)
    pure_funcs?: string[];
    // (undocumented)
    pure_getters?: any;
    // (undocumented)
    reduce_funcs?: boolean;
    // (undocumented)
    reduce_vars?: boolean;
    // (undocumented)
    sequences?: any;
    // (undocumented)
    side_effects?: boolean;
    // (undocumented)
    switches?: boolean;
    // (undocumented)
    top_retain?: any;
    // (undocumented)
    toplevel?: any;
    // (undocumented)
    typeofs?: boolean;
    // (undocumented)
    unsafe?: boolean;
    // (undocumented)
    unsafe_arrows?: boolean;
    // (undocumented)
    unsafe_comps?: boolean;
    // (undocumented)
    unsafe_function?: boolean;
    // (undocumented)
    unsafe_math?: boolean;
    // (undocumented)
    unsafe_methods?: boolean;
    // (undocumented)
    unsafe_passes?: boolean;
    // (undocumented)
    unsafe_proto?: boolean;
    // (undocumented)
    unsafe_regexp?: boolean;
    // (undocumented)
    unsafe_symbols?: boolean;
    // (undocumented)
    unsafe_undefined?: boolean;
    // (undocumented)
    unused?: boolean;
}

// @public (undocumented)
type TerserEcmaVersion = 5 | 2015 | 2016 | string | number;

// @public (undocumented)
type TerserEcmaVersion_2 = 5 | 2015 | 2016 | string | number;

// @public (undocumented)
interface TerserMangleOptions {
    // (undocumented)
    ie8?: boolean;
    // (undocumented)
    keep_classnames?: boolean;
    // (undocumented)
    keep_fnames?: boolean;
    // (undocumented)
    keep_private_props?: boolean;
    // (undocumented)
    props?: TerserManglePropertiesOptions;
    // (undocumented)
    reserved?: string[];
    // (undocumented)
    safari10?: boolean;
    // (undocumented)
    toplevel?: boolean;
}

// @public (undocumented)
interface TerserMangleOptions_2 {
    // (undocumented)
    ie8?: boolean;
    // @deprecated (undocumented)
    keep_classnames?: boolean;
    // @deprecated (undocumented)
    keep_fnames?: boolean;
    // @deprecated (undocumented)
    keep_private_props?: boolean;
    keepClassNames?: boolean;
    keepFnNames?: boolean;
    keepPrivateProps?: boolean;
    // (undocumented)
    props?: TerserManglePropertiesOptions_2;
    // (undocumented)
    reserved?: string[];
    // (undocumented)
    safari10?: boolean;
    topLevel?: boolean;
    // @deprecated (undocumented)
    toplevel?: boolean;
}

// @public (undocumented)
type TerserManglePropertiesOptions = {};

// @public (undocumented)
interface TerserManglePropertiesOptions_2 {
}

// @public (undocumented)
const TIMERS_AGGREGATES_SYMBOL: unique symbol;

// @public (undocumented)
const TIMERS_SYMBOL: unique symbol;

// @public (undocumented)
type ToSnakeCase<T extends string> = T extends `${infer A}${infer B}` ? `${A extends Lowercase<A> ? A : `_${Lowercase<A>}`}${ToSnakeCase<B>}` : T;

// @public (undocumented)
type ToSnakeCase_2<T extends string> = T extends `${infer A}${infer B}` ? `${A extends Lowercase<A> ? A : `_${Lowercase<A>}`}${ToSnakeCase_2<B>}` : T;

// @public (undocumented)
type ToSnakeCaseProperties<T> = {
    [K in keyof T as K extends string ? ToSnakeCase<K> : K]: T[K];
};

// @public (undocumented)
type ToSnakeCaseProperties_2<T> = {
    [K in keyof T as K extends string ? ToSnakeCase_2<K> : K]: T[K];
};

// @public
interface TransformConfig {
    // (undocumented)
    constModules?: ConstModulesConfig;
    decoratorMetadata?: boolean;
    decoratorVersion?: "2021-12" | "2022-03";
    legacyDecorator?: boolean;
    optimizer?: OptimizerConfig;
    react?: ReactConfig;
    // (undocumented)
    treatConstEnumAsEnum?: boolean;
    // (undocumented)
    useDefineForClassFields?: boolean;
}

// @public (undocumented)
type TransformEffect<T> = {
    type: "transform";
    transform: (arg: T, ctx: RefinementCtx) => any;
};

// @public
export type TrustedTypes = {
    policyName?: string;
    onPolicyCreationFailure?: "continue" | "stop";
};

// @public (undocumented)
interface TsParserConfig {
    decorators?: boolean;
    // @deprecated (undocumented)
    dynamicImport?: boolean;
    // (undocumented)
    syntax: "typescript";
    tsx?: boolean;
}

// @public (undocumented)
type typeToFlattenedError<T, U = string> = {
    formErrors: U[];
    fieldErrors: {
        [P in allKeys<T>]?: U[];
    };
};

// @public (undocumented)
interface UmdConfig extends BaseModuleConfig {
    // (undocumented)
    globals?: {
        [key: string]: string;
    };
    // (undocumented)
    type: "umd";
}

// @public
export type UmdNamedDefine = boolean;

// @public
export type UniqueName = string;

// @public
type UsageStateType = 0 | 1 | 2 | 3 | 4;

// @public (undocumented)
export const util: {
    createHash: (algorithm: "debug" | "xxhash64" | "md4" | "native-md4" | (string & {}) | (new () => default_2)) => default_2;
    cleverMerge: <First, Second>(first: First, second: Second) => First | Second | (First & Second);
};

// @public (undocumented)
namespace util_2 {
    // (undocumented)
    type AssertEqual<T, U> = (<V>() => V extends T ? 1 : 2) extends <V>() => V extends U ? 1 : 2 ? true : false;
    // (undocumented)
    function assertIs<T>(_arg: T): void;
    const // (undocumented)
    assertEqual: <A, B>(val: AssertEqual<A, B>) => AssertEqual<A, B>;
    // (undocumented)
    function assertNever(_x: never): never;
    // (undocumented)
    type Exactly<T, X> = T & Record<Exclude<keyof X, keyof T>, never>;
    // (undocumented)
    type flatten<T> = objectUtil.flatten<T>;
    // (undocumented)
    type identity<T> = objectUtil.identity<T>;
    // (undocumented)
    type isAny<T> = 0 extends 1 & T ? true : false;
    // (undocumented)
    function joinValues<T extends any[]>(array: T, separator?: string): string;
    const // (undocumented)
    arrayToEnum: <T extends string, U extends [T, ...T[]]>(items: U) => { [k in U[number]]: k; };
    const // (undocumented)
    getValidEnumValues: (obj: any) => any[];
    const // (undocumented)
    objectValues: (obj: any) => any[];
    const // (undocumented)
    objectKeys: ObjectConstructor["keys"];
    const // (undocumented)
    find: <T>(arr: T[], checker: (arg: T) => any) => T | undefined;
    // (undocumented)
    type MakePartial<T, K extends keyof T> = Omit<T, K> & Partial<Pick<T, K>>;
    // (undocumented)
    type noUndefined<T> = T extends undefined ? never : T;
    // (undocumented)
    type Omit<T, K extends keyof T> = Pick<T, Exclude<keyof T, K>>;
    const // (undocumented)
    isInteger: NumberConstructor["isInteger"];
    // (undocumented)
    type OmitKeys<T, K extends string> = Pick<T, Exclude<keyof T, K>>;
    const // (undocumented)
    jsonStringifyReplacer: (_: string, value: any) => any;
        {  };
}

// @public (undocumented)
export class ValidationError extends Error {
    constructor(message: string);
}

// @public (undocumented)
export const version: string;

// @public (undocumented)
export const WarnCaseSensitiveModulesPlugin: {
    new (): {
        name: BuiltinPluginName;
        _args: [];
        affectedHooks: "done" | "make" | "environment" | "compile" | "emit" | "afterEmit" | "invalid" | "thisCompilation" | "afterDone" | "compilation" | "normalModuleFactory" | "contextModuleFactory" | "initialize" | "shouldEmit" | "infrastructureLog" | "beforeRun" | "run" | "assetEmitted" | "failed" | "shutdown" | "watchRun" | "watchClose" | "afterEnvironment" | "afterPlugins" | "afterResolvers" | "beforeCompile" | "afterCompile" | "finishMake" | "entryOption" | "additionalPass" | undefined;
        raw(compiler: Compiler_2): BuiltinPlugin;
        apply(compiler: Compiler_2): void;
    };
};

// @public (undocumented)
interface Wasm {
    // (undocumented)
    EnableWasmLoadingPlugin: typeof EnableWasmLoadingPlugin;
}

// @public (undocumented)
export const wasm: Wasm;

// @public
export type WasmLoading = false | WasmLoadingType;

// @public
export type WasmLoadingType = string | "fetch-streaming" | "fetch" | "async-node";

// @public (undocumented)
export type Watch = boolean;

// @public (undocumented)
interface Watcher {
    // (undocumented)
    close(): void;
    // (undocumented)
    getAggregatedChanges?(): Set<string>;
    // (undocumented)
    getAggregatedRemovals?(): Set<string>;
    // (undocumented)
    getContextTimeInfoEntries?(): Map<string, FileSystemInfoEntry | "ignore">;
    // (undocumented)
    getFileTimeInfoEntries?(): Map<string, FileSystemInfoEntry | "ignore">;
    // (undocumented)
    getInfo(): WatcherInfo;
    // (undocumented)
    pause(): void;
}

// @public (undocumented)
class Watcher_2 extends EventEmitter {
    constructor(directoryWatcher: DirectoryWatcher, filePath: string, startTime: number);
    // (undocumented)
    checkStartTime(mtime: number, initial: boolean): boolean;
    // (undocumented)
    close(): void;
    // (undocumented)
    data: number;
    // (undocumented)
    directoryWatcher: DirectoryWatcher;
    // (undocumented)
    path: string;
    // (undocumented)
    startTime: number;
}

// @public (undocumented)
interface WatcherInfo {
    // (undocumented)
    changes: Set<string>;
    // (undocumented)
    contextTimeInfoEntries: Map<string, FileSystemInfoEntry | "ignore">;
    // (undocumented)
    fileTimeInfoEntries: Map<string, FileSystemInfoEntry | "ignore">;
    // (undocumented)
    removals: Set<string>;
}

// @public (undocumented)
interface WatchFileSystem {
    // (undocumented)
    watch(files: Iterable<string>, directories: Iterable<string>, missing: Iterable<string>, startTime: number, options: WatchOptions, callback: (error: Error | null, fileTimeInfoEntries: Map<string, FileSystemInfoEntry | "ignore">, contextTimeInfoEntries: Map<string, FileSystemInfoEntry | "ignore">, changedFiles: Set<string>, removedFiles: Set<string>) => void, callbackUndelayed: (fileName: string, changeTime: number) => void): Watcher;
}

// @public (undocumented)
export class Watching {
    constructor(compiler: Compiler, watchOptions: WatchOptions, handler: Callback<Error, Stats>);
    // (undocumented)
    blocked: boolean;
    // (undocumented)
    callbacks: Callback<Error, void>[];
    // (undocumented)
    close(callback?: () => void): void;
    // (undocumented)
    compiler: Compiler;
    // (undocumented)
    handler: Callback<Error, Stats>;
    // (undocumented)
    invalid: boolean;
    // (undocumented)
    invalidate(callback?: Callback<Error, void>): void;
    // (undocumented)
    isBlocked: () => boolean;
    // (undocumented)
    lastWatcherStartTime: number;
    // (undocumented)
    lazyCompilationInvalidate(files: Set<string>): void;
    // (undocumented)
    onChange: () => void;
    // (undocumented)
    onInvalid: () => void;
    // (undocumented)
    pausedWatcher?: Watcher;
    // (undocumented)
    resume(): void;
    // (undocumented)
    running: boolean;
    // (undocumented)
    startTime?: number;
    // (undocumented)
    suspend(): void;
    // (undocumented)
    suspended: boolean;
    // (undocumented)
    watch(files: Iterable<string>, dirs: Iterable<string>, missing: Iterable<string>): void;
    // (undocumented)
    watcher?: Watcher;
    // (undocumented)
    watchOptions: WatchOptions;
}

// @public
export type WatchOptions = {
    aggregateTimeout?: number;
    followSymlinks?: boolean;
    ignored?: string | RegExp | string[];
    poll?: number | boolean;
    stdin?: boolean;
};

// @public (undocumented)
class Watchpack extends EventEmitter {
    constructor(options: Watchpack.WatchOptions);
    // (undocumented)
    aggregatedChanges: Set<string>;
    // (undocumented)
    aggregatedRemovals: Set<string>;
    // (undocumented)
    aggregateTimeout: NodeJS.Timer;
    close(): void;
    collectTimeInfoEntries(fileInfoEntries: Map<string, Entry_2>, directoryInfoEntries: Map<string, Entry_2>): void;
    // (undocumented)
    _dirWatcher(item: string, watcher: Watcher_2): Watcher_2;
    // (undocumented)
    dirWatchers: Watcher_2[];
    // (undocumented)
    _fileWatcher(file: string, watcher: Watcher_2): Watcher_2;
    // (undocumented)
    fileWatchers: Watcher_2[];
    getAggregated(): {
        changes: Set<string>;
        removals: Set<string>;
    };
    getTimeInfoEntries(): Map<string, Entry_2>;
    // @deprecated
    getTimes(): {
        [path: string]: number;
    };
    mtimes: {
        [path: string]: number;
    };
    // (undocumented)
    on(
    eventName: "change",
    listener: (
    filePath: string,
    modifiedTime: number,
    explanation: string,
    ) => void,
    ): this;
    // (undocumented)
    on(
    eventName: "remove",
    listener: (
    filePath: string,
    explanation: string,
    ) => void,
    ): this;
    // (undocumented)
    on(
    eventName: "aggregated",
    listener: (
    changes: Set<string>,
    removals: Set<string>,
    ) => void,
    ): this;
    // (undocumented)
    _onChange(item: string, mtime: number, file?: string): void;
    // (undocumented)
    _onTimeout(): void;
    // (undocumented)
    options: Watchpack.WatchOptions;
    pause(): void;
    // (undocumented)
    paused: boolean;
    watch(options: {
        files?: Iterable<string>;
        directories?: Iterable<string>;
        missing?: Iterable<string>;
        startTime?: number;
    }): void;
    // (undocumented)
    watcherOptions: Watchpack.WatcherOptions;
}

// @public (undocumented)
namespace Watchpack {
    // (undocumented)
    interface WatcherOptions {
        // (undocumented)
        followSymlinks?: boolean;
        // (undocumented)
        ignored?: string[] | string | RegExp | ((path: string) => boolean) | undefined;
        // (undocumented)
        poll?: boolean | number | undefined;
    }
    // (undocumented)
    interface WatchOptions extends WatcherOptions {
        // (undocumented)
        aggregateTimeout?: number | undefined;
    }
}

// @public (undocumented)
interface Web {
    // (undocumented)
    FetchCompileAsyncWasmPlugin: typeof FetchCompileAsyncWasmPlugin;
}

// @public (undocumented)
export const web: Web;

// @public
export type WebassemblyModuleFilename = string;

// @public (undocumented)
export type WebpackCompiler = any;

// @public (undocumented)
export const WebpackError: ErrorConstructor;

// @public (undocumented)
class WebpackError_2 extends Error {
    // (undocumented)
    [inspect.custom](): string;
    // (undocumented)
    chunk?: Chunk;
    // (undocumented)
    details?: string;
    // (undocumented)
    file?: string;
    // (undocumented)
    hideStack?: boolean;
    // (undocumented)
    loc?: DependencyLocation;
    // (undocumented)
    module?: Module;
}

// @public (undocumented)
export type WebpackPluginFunction = (this: WebpackCompiler, compiler: WebpackCompiler) => void;

// @public (undocumented)
export interface WebpackPluginInstance {
    // (undocumented)
    [k: string]: any;
    // (undocumented)
    apply: (compiler: WebpackCompiler) => void;
}

// @public (undocumented)
interface Webworker {
    // (undocumented)
    WebWorkerTemplatePlugin: typeof WebWorkerTemplatePlugin;
}

// @public (undocumented)
export const webworker: Webworker;

// @public (undocumented)
class WebWorkerTemplatePlugin extends RspackBuiltinPlugin {
    // (undocumented)
    name: BuiltinPluginName;
    // (undocumented)
    raw(compiler: Compiler): BuiltinPlugin | undefined;
}

// @public
export type WorkerPublicPath = string;

// @public (undocumented)
type Write<TBuffer extends ArrayBufferView = Buffer> = (fd: number, content: Buffer, options: WriteAsyncOptions<TBuffer>, callback: (err: null | NodeJS.ErrnoException, bytesWrite: number, buffer: TBuffer) => void) => void;

// @public (undocumented)
type WriteAsyncOptions<TBuffer extends ArrayBufferView = Buffer> = {
    offset?: number;
    length?: number;
    position?: null | number | bigint;
    buffer?: TBuffer;
};

// @public (undocumented)
namespace z {
        { type z_AnyZodObject as AnyZodObject, type z_AnyZodTuple as AnyZodTuple, type z_ArrayCardinality as ArrayCardinality, type z_ArrayKeys as ArrayKeys, type z_AssertArray as AssertArray, type z_AsyncParseReturnType as AsyncParseReturnType, type z_BRAND as BRAND, type z_CatchallInput as CatchallInput, type z_CatchallOutput as CatchallOutput, type z_CustomErrorParams as CustomErrorParams, z_DIRTY as DIRTY, type z_DenormalizedError as DenormalizedError, z_EMPTY_PATH as EMPTY_PATH, type z_Effect as Effect, type z_EnumLike as EnumLike, type z_EnumValues as EnumValues, type z_ErrorMapCtx as ErrorMapCtx, type z_FilterEnum as FilterEnum, z_INVALID as INVALID, type z_Indices as Indices, type z_InnerTypeOfFunction as InnerTypeOfFunction, type z_InputTypeOfTuple as InputTypeOfTuple, type z_InputTypeOfTupleWithRest as InputTypeOfTupleWithRest, type z_IpVersion as IpVersion, type z_IssueData as IssueData, type z_KeySchema as KeySchema, z_NEVER as NEVER, z_OK as OK, type z_ObjectPair as ObjectPair, type z_OuterTypeOfFunction as OuterTypeOfFunction, type z_OutputTypeOfTuple as OutputTypeOfTuple, type z_OutputTypeOfTupleWithRest as OutputTypeOfTupleWithRest, type z_ParseContext as ParseContext, type z_ParseInput as ParseInput, type z_ParseParams as ParseParams, type z_ParsePath as ParsePath, type z_ParsePathComponent as ParsePathComponent, type z_ParseResult as ParseResult, type z_ParseReturnType as ParseReturnType, z_ParseStatus as ParseStatus, type z_PassthroughType as PassthroughType, type z_PreprocessEffect as PreprocessEffect, type z_Primitive as Primitive, type z_ProcessedCreateParams as ProcessedCreateParams, type z_RawCreateParams as RawCreateParams, type z_RecordType as RecordType, type z_Refinement as Refinement, type z_RefinementCtx as RefinementCtx, type z_RefinementEffect as RefinementEffect, type z_SafeParseError as SafeParseError, type z_SafeParseReturnType as SafeParseReturnType, type z_SafeParseSuccess as SafeParseSuccess, type z_Scalars as Scalars, ZodType as Schema, type z_SomeZodObject as SomeZodObject, type z_StringValidation as StringValidation, type z_SuperRefinement as SuperRefinement, type z_SyncParseReturnType as SyncParseReturnType, type z_TransformEffect as TransformEffect, type z_TypeOf as TypeOf, type z_UnknownKeysParam as UnknownKeysParam, type z_Values as Values, type z_Writeable as Writeable, z_ZodAny as ZodAny, type z_ZodAnyDef as ZodAnyDef, z_ZodArray as ZodArray, type z_ZodArrayDef as ZodArrayDef, z_ZodBigInt as ZodBigInt, type z_ZodBigIntCheck as ZodBigIntCheck, type z_ZodBigIntDef as ZodBigIntDef, z_ZodBoolean as ZodBoolean, type z_ZodBooleanDef as ZodBooleanDef, z_ZodBranded as ZodBranded, type z_ZodBrandedDef as ZodBrandedDef, z_ZodCatch as ZodCatch, type z_ZodCatchDef as ZodCatchDef, type z_ZodCustomIssue as ZodCustomIssue, z_ZodDate as ZodDate, type z_ZodDateCheck as ZodDateCheck, type z_ZodDateDef as ZodDateDef, z_ZodDefault as ZodDefault, type z_ZodDefaultDef as ZodDefaultDef, z_ZodDiscriminatedUnion as ZodDiscriminatedUnion, type z_ZodDiscriminatedUnionDef as ZodDiscriminatedUnionDef, type z_ZodDiscriminatedUnionOption as ZodDiscriminatedUnionOption, z_ZodEffects as ZodEffects, type z_ZodEffectsDef as ZodEffectsDef, z_ZodEnum as ZodEnum, type z_ZodEnumDef as ZodEnumDef, z_ZodError as ZodError, type z_ZodErrorMap as ZodErrorMap, type z_ZodFirstPartySchemaTypes as ZodFirstPartySchemaTypes, z_ZodFirstPartyTypeKind as ZodFirstPartyTypeKind, type z_ZodFormattedError as ZodFormattedError, z_ZodFunction as ZodFunction, type z_ZodFunctionDef as ZodFunctionDef, z_ZodIntersection as ZodIntersection, type z_ZodIntersectionDef as ZodIntersectionDef, type z_ZodInvalidArgumentsIssue as ZodInvalidArgumentsIssue, type z_ZodInvalidDateIssue as ZodInvalidDateIssue, type z_ZodInvalidEnumValueIssue as ZodInvalidEnumValueIssue, type z_ZodInvalidIntersectionTypesIssue as ZodInvalidIntersectionTypesIssue, type z_ZodInvalidLiteralIssue as ZodInvalidLiteralIssue, type z_ZodInvalidReturnTypeIssue as ZodInvalidReturnTypeIssue, type z_ZodInvalidStringIssue as ZodInvalidStringIssue, type z_ZodInvalidTypeIssue as ZodInvalidTypeIssue, type z_ZodInvalidUnionDiscriminatorIssue as ZodInvalidUnionDiscriminatorIssue, type z_ZodInvalidUnionIssue as ZodInvalidUnionIssue, type z_ZodIssue as ZodIssue, type z_ZodIssueBase as ZodIssueBase, type z_ZodIssueCode as ZodIssueCode, type z_ZodIssueOptionalMessage as ZodIssueOptionalMessage, z_ZodLazy as ZodLazy, type z_ZodLazyDef as ZodLazyDef, z_ZodLiteral as ZodLiteral, type z_ZodLiteralDef as ZodLiteralDef, z_ZodMap as ZodMap, type z_ZodMapDef as ZodMapDef, z_ZodNaN as ZodNaN, type z_ZodNaNDef as ZodNaNDef, z_ZodNativeEnum as ZodNativeEnum, type z_ZodNativeEnumDef as ZodNativeEnumDef, z_ZodNever as ZodNever, type z_ZodNeverDef as ZodNeverDef, type z_ZodNonEmptyArray as ZodNonEmptyArray, type z_ZodNotFiniteIssue as ZodNotFiniteIssue, type z_ZodNotMultipleOfIssue as ZodNotMultipleOfIssue, z_ZodNull as ZodNull, type z_ZodNullDef as ZodNullDef, z_ZodNullable as ZodNullable, type z_ZodNullableDef as ZodNullableDef, type z_ZodNullableType as ZodNullableType, z_ZodNumber as ZodNumber, type z_ZodNumberCheck as ZodNumberCheck, type z_ZodNumberDef as ZodNumberDef, z_ZodObject as ZodObject, type z_ZodObjectDef as ZodObjectDef, z_ZodOptional as ZodOptional, type z_ZodOptionalDef as ZodOptionalDef, type z_ZodOptionalType as ZodOptionalType, type z_ZodParsedType as ZodParsedType, z_ZodPipeline as ZodPipeline, type z_ZodPipelineDef as ZodPipelineDef, z_ZodPromise as ZodPromise, type z_ZodPromiseDef as ZodPromiseDef, type z_ZodRawShape as ZodRawShape, z_ZodReadonly as ZodReadonly, type z_ZodReadonlyDef as ZodReadonlyDef, z_ZodRecord as ZodRecord, type z_ZodRecordDef as ZodRecordDef, ZodType as ZodSchema, z_ZodSet as ZodSet, type z_ZodSetDef as ZodSetDef, z_ZodString as ZodString, type z_ZodStringCheck as ZodStringCheck, type z_ZodStringDef as ZodStringDef, z_ZodSymbol as ZodSymbol, type z_ZodSymbolDef as ZodSymbolDef, type z_ZodTooBigIssue as ZodTooBigIssue, type z_ZodTooSmallIssue as ZodTooSmallIssue, ZodEffects as ZodTransformer, z_ZodTuple as ZodTuple, type z_ZodTupleDef as ZodTupleDef, type z_ZodTupleItems as ZodTupleItems, z_ZodType as ZodType, type z_ZodTypeAny as ZodTypeAny, type z_ZodTypeDef as ZodTypeDef, z_ZodUndefined as ZodUndefined, type z_ZodUndefinedDef as ZodUndefinedDef, z_ZodUnion as ZodUnion, type z_ZodUnionDef as ZodUnionDef, type z_ZodUnionOptions as ZodUnionOptions, z_ZodUnknown as ZodUnknown, type z_ZodUnknownDef as ZodUnknownDef, type z_ZodUnrecognizedKeysIssue as ZodUnrecognizedKeysIssue, z_ZodVoid as ZodVoid, type z_ZodVoidDef as ZodVoidDef, z_addIssueToContext as addIssueToContext, anyType as any, arrayType as array, type z_arrayOutputType as arrayOutputType, type z_baseObjectInputType as baseObjectInputType, type z_baseObjectOutputType as baseObjectOutputType, bigIntType as bigint, booleanType as boolean, z_coerce as coerce, z_custom as custom, dateType as date, z_datetimeRegex as datetimeRegex, errorMap as defaultErrorMap, type z_deoptional as deoptional, discriminatedUnionType as discriminatedUnion, effectsType as effect, enumType as enum, functionType as function, z_getErrorMap as getErrorMap, z_getParsedType as getParsedType, type TypeOf as infer, type z_inferFlattenedErrors as inferFlattenedErrors, type z_inferFormattedError as inferFormattedError, type z_input as input, instanceOfType as instanceof, intersectionType as intersection, z_isAborted as isAborted, z_isAsync as isAsync, z_isDirty as isDirty, z_isValid as isValid, z_late as late, lazyType as lazy, literalType as literal, z_makeIssue as makeIssue, mapType as map, type z_mergeTypes as mergeTypes, nanType as nan, nativeEnumType as nativeEnum, neverType as never, type z_noUnrecognized as noUnrecognized, nullType as null, nullableType as nullable, numberType as number, objectType as object, type z_objectInputType as objectInputType, type z_objectOutputType as objectOutputType, z_objectUtil as objectUtil, z_oboolean as oboolean, z_onumber as onumber, optionalType as optional, z_ostring as ostring, type z_output as output, pipelineType as pipeline, preprocessType as preprocess, promiseType as promise, z_quotelessJson as quotelessJson, recordType as record, setType as set, z_setErrorMap as setErrorMap, strictObjectType as strictObject, stringType as string, symbolType as symbol, effectsType as transformer, tupleType as tuple, type z_typeToFlattenedError as typeToFlattenedError, type z_typecast as typecast, undefinedType as undefined, unionType as union, unknownType as unknown, z_util as util, voidType as void };
}

// @public (undocumented)
class ZodArray<T extends ZodTypeAny, Cardinality extends ArrayCardinality = "many"> extends ZodType<arrayOutputType<T, Cardinality>, ZodArrayDef<T>, Cardinality extends "atleastone" ? [T["_input"], ...T["_input"][]] : T["_input"][]> {
    // (undocumented)
    static create: <T_1 extends ZodTypeAny>(schema: T_1, params?: RawCreateParams) => ZodArray<T_1, "many">;
    // (undocumented)
    get element(): T;
    // (undocumented)
    length(len: number, message?: errorUtil.ErrMessage): this;
    // (undocumented)
    max(maxLength: number, message?: errorUtil.ErrMessage): this;
    // (undocumented)
    min(minLength: number, message?: errorUtil.ErrMessage): this;
    // (undocumented)
    nonempty(message?: errorUtil.ErrMessage): ZodArray<T, "atleastone">;
    // (undocumented)
    _parse(input: ParseInput): ParseReturnType<this["_output"]>;
}

// @public (undocumented)
interface ZodArrayDef<T extends ZodTypeAny = ZodTypeAny> extends ZodTypeDef {
    // (undocumented)
    exactLength: {
        value: number;
        message?: string;
    } | null;
    // (undocumented)
    maxLength: {
        value: number;
        message?: string;
    } | null;
    // (undocumented)
    minLength: {
        value: number;
        message?: string;
    } | null;
    // (undocumented)
    type: T;
    // (undocumented)
    typeName: ZodFirstPartyTypeKind.ZodArray;
}

// @public (undocumented)
class ZodBranded<T extends ZodTypeAny, B extends string | number | symbol> extends ZodType<T["_output"] & BRAND<B>, ZodBrandedDef<T>, T["_input"]> {
    // (undocumented)
    _parse(input: ParseInput): ParseReturnType<any>;
    // (undocumented)
    unwrap(): T;
}

// @public (undocumented)
interface ZodBrandedDef<T extends ZodTypeAny> extends ZodTypeDef {
    // (undocumented)
    type: T;
    // (undocumented)
    typeName: ZodFirstPartyTypeKind.ZodBranded;
}

// @public (undocumented)
class ZodCatch<T extends ZodTypeAny> extends ZodType<T["_output"], ZodCatchDef<T>, unknown> {
    // (undocumented)
    static create: <T_1 extends ZodTypeAny>(type: T_1, params: {
        errorMap?: ZodErrorMap | undefined;
        invalid_type_error?: string | undefined;
        required_error?: string | undefined;
        message?: string | undefined;
        description?: string | undefined;
    } & {
        catch: T_1["_output"] | (() => T_1["_output"]);
    }) => ZodCatch<T_1>;
    // (undocumented)
    _parse(input: ParseInput): ParseReturnType<this["_output"]>;
    // (undocumented)
    removeCatch(): T;
}

// @public (undocumented)
interface ZodCatchDef<T extends ZodTypeAny = ZodTypeAny> extends ZodTypeDef {
    // (undocumented)
    catchValue: (ctx: {
        error: ZodError;
        input: unknown;
    }) => T["_input"];
    // (undocumented)
    innerType: T;
    // (undocumented)
    typeName: ZodFirstPartyTypeKind.ZodCatch;
}

// @public (undocumented)
type ZodCrossFieldsOptions = ZodTypeDef & {
    patterns: Array<{
        test: (root: RspackOptions) => boolean;
        type: ZodType;
        issue?: (res: ParseReturnType<any>) => Array<IssueData>;
    }>;
    default: ZodType;
};

// @public (undocumented)
interface ZodCustomIssue extends ZodIssueBase {
    // (undocumented)
    code: typeof ZodIssueCode.custom;
    // (undocumented)
    params?: {
        [k: string]: any;
    };
}

// @public (undocumented)
class ZodDefault<T extends ZodTypeAny> extends ZodType<util_2.noUndefined<T["_output"]>, ZodDefaultDef<T>, T["_input"] | undefined> {
    // (undocumented)
    static create: <T_1 extends ZodTypeAny>(type: T_1, params: {
        errorMap?: ZodErrorMap | undefined;
        invalid_type_error?: string | undefined;
        required_error?: string | undefined;
        message?: string | undefined;
        description?: string | undefined;
    } & {
        default: T_1["_input"] | (() => util_2.noUndefined<T_1["_input"]>);
    }) => ZodDefault<T_1>;
    // (undocumented)
    _parse(input: ParseInput): ParseReturnType<this["_output"]>;
    // (undocumented)
    removeDefault(): T;
}

// @public (undocumented)
interface ZodDefaultDef<T extends ZodTypeAny = ZodTypeAny> extends ZodTypeDef {
    // (undocumented)
    defaultValue: () => util_2.noUndefined<T["_input"]>;
    // (undocumented)
    innerType: T;
    // (undocumented)
    typeName: ZodFirstPartyTypeKind.ZodDefault;
}

// @public (undocumented)
class ZodEffects<T extends ZodTypeAny, Output = output<T>, Input = input<T>> extends ZodType<Output, ZodEffectsDef<T>, Input> {
    // (undocumented)
    static create: <I extends ZodTypeAny>(schema: I, effect: Effect<I["_output"]>, params?: RawCreateParams) => ZodEffects<I, I["_output"], input<I>>;
    // (undocumented)
    static createWithPreprocess: <I extends ZodTypeAny>(preprocess: (arg: unknown, ctx: RefinementCtx) => unknown, schema: I, params?: RawCreateParams) => ZodEffects<I, I["_output"], unknown>;
    // (undocumented)
    innerType(): T;
    // (undocumented)
    _parse(input: ParseInput): ParseReturnType<this["_output"]>;
    // (undocumented)
    sourceType(): T;
}

// @public (undocumented)
interface ZodEffectsDef<T extends ZodTypeAny = ZodTypeAny> extends ZodTypeDef {
    // (undocumented)
    effect: Effect<any>;
    // (undocumented)
    schema: T;
    // (undocumented)
    typeName: ZodFirstPartyTypeKind.ZodEffects;
}

// @public (undocumented)
class ZodError<T = any> extends Error {
    constructor(issues: ZodIssue[]);
    // (undocumented)
    addIssue: (sub: ZodIssue) => void;
    // (undocumented)
    addIssues: (subs?: ZodIssue[]) => void;
    // (undocumented)
    static assert(value: unknown): asserts value is ZodError;
    // (undocumented)
    static create: (issues: ZodIssue[]) => ZodError<any>;
    // (undocumented)
    get errors(): ZodIssue[];
    // (undocumented)
    flatten(): typeToFlattenedError<T>;
    // (undocumented)
    flatten<U>(mapper?: (issue: ZodIssue) => U): typeToFlattenedError<T, U>;
    // (undocumented)
    format(): ZodFormattedError<T>;
    // (undocumented)
    format<U>(mapper: (issue: ZodIssue) => U): ZodFormattedError<T, U>;
    // (undocumented)
    get formErrors(): typeToFlattenedError<T, string>;
    // (undocumented)
    get isEmpty(): boolean;
    // (undocumented)
    issues: ZodIssue[];
    // (undocumented)
    get message(): string;
    // (undocumented)
    toString(): string;
}

// @public (undocumented)
type ZodErrorMap = (issue: ZodIssueOptionalMessage, _ctx: ErrorMapCtx) => {
    message: string;
};

// @public (undocumented)
enum ZodFirstPartyTypeKind {
    // (undocumented)
    ZodAny = "ZodAny",
    // (undocumented)
    ZodArray = "ZodArray",
    // (undocumented)
    ZodBigInt = "ZodBigInt",
    // (undocumented)
    ZodBoolean = "ZodBoolean",
    // (undocumented)
    ZodBranded = "ZodBranded",
    // (undocumented)
    ZodCatch = "ZodCatch",
    // (undocumented)
    ZodDate = "ZodDate",
    // (undocumented)
    ZodDefault = "ZodDefault",
    // (undocumented)
    ZodDiscriminatedUnion = "ZodDiscriminatedUnion",
    // (undocumented)
    ZodEffects = "ZodEffects",
    // (undocumented)
    ZodEnum = "ZodEnum",
    // (undocumented)
    ZodFunction = "ZodFunction",
    // (undocumented)
    ZodIntersection = "ZodIntersection",
    // (undocumented)
    ZodLazy = "ZodLazy",
    // (undocumented)
    ZodLiteral = "ZodLiteral",
    // (undocumented)
    ZodMap = "ZodMap",
    // (undocumented)
    ZodNaN = "ZodNaN",
    // (undocumented)
    ZodNativeEnum = "ZodNativeEnum",
    // (undocumented)
    ZodNever = "ZodNever",
    // (undocumented)
    ZodNull = "ZodNull",
    // (undocumented)
    ZodNullable = "ZodNullable",
    // (undocumented)
    ZodNumber = "ZodNumber",
    // (undocumented)
    ZodObject = "ZodObject",
    // (undocumented)
    ZodOptional = "ZodOptional",
    // (undocumented)
    ZodPipeline = "ZodPipeline",
    // (undocumented)
    ZodPromise = "ZodPromise",
    // (undocumented)
    ZodReadonly = "ZodReadonly",
    // (undocumented)
    ZodRecord = "ZodRecord",
    // (undocumented)
    ZodSet = "ZodSet",
    // (undocumented)
    ZodString = "ZodString",
    // (undocumented)
    ZodSymbol = "ZodSymbol",
    // (undocumented)
    ZodTuple = "ZodTuple",
    // (undocumented)
    ZodUndefined = "ZodUndefined",
    // (undocumented)
    ZodUnion = "ZodUnion",
    // (undocumented)
    ZodUnknown = "ZodUnknown",
    // (undocumented)
    ZodVoid = "ZodVoid"
}

// @public (undocumented)
type ZodFormattedError<T, U = string> = {
    _errors: U[];
} & recursiveZodFormattedError<NonNullable<T>>;

// @public (undocumented)
class ZodIntersection<T extends ZodTypeAny, U extends ZodTypeAny> extends ZodType<T["_output"] & U["_output"], ZodIntersectionDef<T, U>, T["_input"] & U["_input"]> {
    // (undocumented)
    static create: <T_1 extends ZodTypeAny, U_1 extends ZodTypeAny>(left: T_1, right: U_1, params?: RawCreateParams) => ZodIntersection<T_1, U_1>;
    // (undocumented)
    _parse(input: ParseInput): ParseReturnType<this["_output"]>;
}

// @public (undocumented)
interface ZodIntersectionDef<T extends ZodTypeAny = ZodTypeAny, U extends ZodTypeAny = ZodTypeAny> extends ZodTypeDef {
    // (undocumented)
    left: T;
    // (undocumented)
    right: U;
    // (undocumented)
    typeName: ZodFirstPartyTypeKind.ZodIntersection;
}

// @public (undocumented)
interface ZodInvalidArgumentsIssue extends ZodIssueBase {
    // (undocumented)
    argumentsError: ZodError;
    // (undocumented)
    code: typeof ZodIssueCode.invalid_arguments;
}

// @public (undocumented)
interface ZodInvalidDateIssue extends ZodIssueBase {
    // (undocumented)
    code: typeof ZodIssueCode.invalid_date;
}

// @public (undocumented)
interface ZodInvalidEnumValueIssue extends ZodIssueBase {
    // (undocumented)
    code: typeof ZodIssueCode.invalid_enum_value;
    // (undocumented)
    options: (string | number)[];
    // (undocumented)
    received: string | number;
}

// @public (undocumented)
interface ZodInvalidIntersectionTypesIssue extends ZodIssueBase {
    // (undocumented)
    code: typeof ZodIssueCode.invalid_intersection_types;
}

// @public (undocumented)
interface ZodInvalidLiteralIssue extends ZodIssueBase {
    // (undocumented)
    code: typeof ZodIssueCode.invalid_literal;
    // (undocumented)
    expected: unknown;
    // (undocumented)
    received: unknown;
}

// @public (undocumented)
interface ZodInvalidReturnTypeIssue extends ZodIssueBase {
    // (undocumented)
    code: typeof ZodIssueCode.invalid_return_type;
    // (undocumented)
    returnTypeError: ZodError;
}

// @public (undocumented)
interface ZodInvalidStringIssue extends ZodIssueBase {
    // (undocumented)
    code: typeof ZodIssueCode.invalid_string;
    // (undocumented)
    validation: StringValidation;
}

// @public (undocumented)
interface ZodInvalidTypeIssue extends ZodIssueBase {
    // (undocumented)
    code: typeof ZodIssueCode.invalid_type;
    // (undocumented)
    expected: ZodParsedType;
    // (undocumented)
    received: ZodParsedType;
}

// @public (undocumented)
interface ZodInvalidUnionDiscriminatorIssue extends ZodIssueBase {
    // (undocumented)
    code: typeof ZodIssueCode.invalid_union_discriminator;
    // (undocumented)
    options: Primitive[];
}

// @public (undocumented)
interface ZodInvalidUnionIssue extends ZodIssueBase {
    // (undocumented)
    code: typeof ZodIssueCode.invalid_union;
    // (undocumented)
    unionErrors: ZodError[];
}

// @public (undocumented)
type ZodIssue = ZodIssueOptionalMessage & {
    fatal?: boolean;
    message: string;
};

// @public (undocumented)
type ZodIssueBase = {
    path: (string | number)[];
    message?: string;
};

// @public (undocumented)
const ZodIssueCode: {
    invalid_type: "invalid_type";
    invalid_literal: "invalid_literal";
    custom: "custom";
    invalid_union: "invalid_union";
    invalid_union_discriminator: "invalid_union_discriminator";
    invalid_enum_value: "invalid_enum_value";
    unrecognized_keys: "unrecognized_keys";
    invalid_arguments: "invalid_arguments";
    invalid_return_type: "invalid_return_type";
    invalid_date: "invalid_date";
    invalid_string: "invalid_string";
    too_small: "too_small";
    too_big: "too_big";
    invalid_intersection_types: "invalid_intersection_types";
    not_multiple_of: "not_multiple_of";
    not_finite: "not_finite";
};

// @public (undocumented)
type ZodIssueCode = keyof typeof ZodIssueCode;

// @public (undocumented)
type ZodIssueOptionalMessage = ZodInvalidTypeIssue | ZodInvalidLiteralIssue | ZodUnrecognizedKeysIssue | ZodInvalidUnionIssue | ZodInvalidUnionDiscriminatorIssue | ZodInvalidEnumValueIssue | ZodInvalidArgumentsIssue | ZodInvalidReturnTypeIssue | ZodInvalidDateIssue | ZodInvalidStringIssue | ZodTooSmallIssue | ZodTooBigIssue | ZodInvalidIntersectionTypesIssue | ZodNotMultipleOfIssue | ZodNotFiniteIssue | ZodCustomIssue;

// @public (undocumented)
interface ZodNotFiniteIssue extends ZodIssueBase {
    // (undocumented)
    code: typeof ZodIssueCode.not_finite;
}

// @public (undocumented)
interface ZodNotMultipleOfIssue extends ZodIssueBase {
    // (undocumented)
    code: typeof ZodIssueCode.not_multiple_of;
    // (undocumented)
    multipleOf: number | bigint;
}

// @public (undocumented)
class ZodNullable<T extends ZodTypeAny> extends ZodType<T["_output"] | null, ZodNullableDef<T>, T["_input"] | null> {
    // (undocumented)
    static create: <T_1 extends ZodTypeAny>(type: T_1, params?: RawCreateParams) => ZodNullable<T_1>;
    // (undocumented)
    _parse(input: ParseInput): ParseReturnType<this["_output"]>;
    // (undocumented)
    unwrap(): T;
}

// @public (undocumented)
interface ZodNullableDef<T extends ZodTypeAny = ZodTypeAny> extends ZodTypeDef {
    // (undocumented)
    innerType: T;
    // (undocumented)
    typeName: ZodFirstPartyTypeKind.ZodNullable;
}

// @public (undocumented)
class ZodOptional<T extends ZodTypeAny> extends ZodType<T["_output"] | undefined, ZodOptionalDef<T>, T["_input"] | undefined> {
    // (undocumented)
    static create: <T_1 extends ZodTypeAny>(type: T_1, params?: RawCreateParams) => ZodOptional<T_1>;
    // (undocumented)
    _parse(input: ParseInput): ParseReturnType<this["_output"]>;
    // (undocumented)
    unwrap(): T;
}

// @public (undocumented)
interface ZodOptionalDef<T extends ZodTypeAny = ZodTypeAny> extends ZodTypeDef {
    // (undocumented)
    innerType: T;
    // (undocumented)
    typeName: ZodFirstPartyTypeKind.ZodOptional;
}

// @public (undocumented)
const ZodParsedType: {
    function: "function";
    number: "number";
    string: "string";
    nan: "nan";
    integer: "integer";
    float: "float";
    boolean: "boolean";
    date: "date";
    bigint: "bigint";
    symbol: "symbol";
    undefined: "undefined";
    null: "null";
    array: "array";
    object: "object";
    unknown: "unknown";
    promise: "promise";
    void: "void";
    never: "never";
    map: "map";
    set: "set";
};

// @public (undocumented)
type ZodParsedType = keyof typeof ZodParsedType;

// @public (undocumented)
class ZodPipeline<A extends ZodTypeAny, B extends ZodTypeAny> extends ZodType<B["_output"], ZodPipelineDef<A, B>, A["_input"]> {
    // (undocumented)
    static create<A extends ZodTypeAny, B extends ZodTypeAny>(a: A, b: B): ZodPipeline<A, B>;
    // (undocumented)
    _parse(input: ParseInput): ParseReturnType<any>;
}

// @public (undocumented)
interface ZodPipelineDef<A extends ZodTypeAny, B extends ZodTypeAny> extends ZodTypeDef {
    // (undocumented)
    in: A;
    // (undocumented)
    out: B;
    // (undocumented)
    typeName: ZodFirstPartyTypeKind.ZodPipeline;
}

// @public (undocumented)
class ZodPromise<T extends ZodTypeAny> extends ZodType<Promise<T["_output"]>, ZodPromiseDef<T>, Promise<T["_input"]>> {
    // (undocumented)
    static create: <T_1 extends ZodTypeAny>(schema: T_1, params?: RawCreateParams) => ZodPromise<T_1>;
    // (undocumented)
    _parse(input: ParseInput): ParseReturnType<this["_output"]>;
    // (undocumented)
    unwrap(): T;
}

// @public (undocumented)
interface ZodPromiseDef<T extends ZodTypeAny = ZodTypeAny> extends ZodTypeDef {
    // (undocumented)
    type: T;
    // (undocumented)
    typeName: ZodFirstPartyTypeKind.ZodPromise;
}

// @public (undocumented)
class ZodReadonly<T extends ZodTypeAny> extends ZodType<MakeReadonly<T["_output"]>, ZodReadonlyDef<T>, MakeReadonly<T["_input"]>> {
    // (undocumented)
    static create: <T_1 extends ZodTypeAny>(type: T_1, params?: RawCreateParams) => ZodReadonly<T_1>;
    // (undocumented)
    _parse(input: ParseInput): ParseReturnType<this["_output"]>;
    // (undocumented)
    unwrap(): T;
}

// @public (undocumented)
interface ZodReadonlyDef<T extends ZodTypeAny = ZodTypeAny> extends ZodTypeDef {
    // (undocumented)
    innerType: T;
    // (undocumented)
    typeName: ZodFirstPartyTypeKind.ZodReadonly;
}

// @public (undocumented)
class ZodRspackCrossChecker<T> extends ZodType<T> {
    constructor(params: ZodCrossFieldsOptions);
    // (undocumented)
    _getRootData(ctx: z.ParseContext): any;
    // (undocumented)
    _parse(input: z.ParseInput): z.ParseReturnType<T>;
}

// @public (undocumented)
interface ZodTooBigIssue extends ZodIssueBase {
    // (undocumented)
    code: typeof ZodIssueCode.too_big;
    // (undocumented)
    exact?: boolean;
    // (undocumented)
    inclusive: boolean;
    // (undocumented)
    maximum: number | bigint;
    // (undocumented)
    type: "array" | "string" | "number" | "set" | "date" | "bigint";
}

// @public (undocumented)
interface ZodTooSmallIssue extends ZodIssueBase {
    // (undocumented)
    code: typeof ZodIssueCode.too_small;
    // (undocumented)
    exact?: boolean;
    // (undocumented)
    inclusive: boolean;
    // (undocumented)
    minimum: number | bigint;
    // (undocumented)
    type: "array" | "string" | "number" | "set" | "date" | "bigint";
}

// @public (undocumented)
abstract class ZodType<Output = any, Def extends ZodTypeDef = ZodTypeDef, Input = Output> {
    constructor(def: Def);
    // (undocumented)
    and<T extends ZodTypeAny>(incoming: T): ZodIntersection<this, T>;
    // (undocumented)
    array(): ZodArray<this>;
    // (undocumented)
    brand<B extends string | number | symbol>(brand?: B): ZodBranded<this, B>;
    // (undocumented)
    catch(def: Output): ZodCatch<this>;
    // (undocumented)
    catch(def: (ctx: {
        error: ZodError;
        input: Input;
    }) => Output): ZodCatch<this>;
    // (undocumented)
    readonly _def: Def;
    // (undocumented)
    default(def: util_2.noUndefined<Input>): ZodDefault<this>;
    // (undocumented)
    default(def: () => util_2.noUndefined<Input>): ZodDefault<this>;
    // (undocumented)
    describe(description: string): this;
    // (undocumented)
    get description(): string | undefined;
    // (undocumented)
    _getOrReturnCtx(input: ParseInput, ctx?: ParseContext | undefined): ParseContext;
    // (undocumented)
    _getType(input: ParseInput): string;
    // (undocumented)
    readonly _input: Input;
    // (undocumented)
    isNullable(): boolean;
    // (undocumented)
    isOptional(): boolean;
    // (undocumented)
    nullable(): ZodNullable<this>;
    // (undocumented)
    nullish(): ZodOptional<ZodNullable<this>>;
    // (undocumented)
    optional(): ZodOptional<this>;
    // (undocumented)
    or<T extends ZodTypeAny>(option: T): ZodUnion<[this, T]>;
    // (undocumented)
    readonly _output: Output;
    // (undocumented)
    parse(data: unknown, params?: Partial<ParseParams>): Output;
    // (undocumented)
    abstract _parse(input: ParseInput): ParseReturnType<Output>;
    // (undocumented)
    parseAsync(data: unknown, params?: Partial<ParseParams>): Promise<Output>;
    // (undocumented)
    _parseAsync(input: ParseInput): AsyncParseReturnType<Output>;
    // (undocumented)
    _parseSync(input: ParseInput): SyncParseReturnType<Output>;
    // (undocumented)
    pipe<T extends ZodTypeAny>(target: T): ZodPipeline<this, T>;
    // (undocumented)
    _processInputParams(input: ParseInput): {
        status: ParseStatus;
        ctx: ParseContext;
    };
    // (undocumented)
    promise(): ZodPromise<this>;
    // (undocumented)
    readonly(): ZodReadonly<this>;
    // (undocumented)
    refine<RefinedOutput extends Output>(check: (arg: Output) => arg is RefinedOutput, message?: string | CustomErrorParams | ((arg: Output) => CustomErrorParams)): ZodEffects<this, RefinedOutput, Input>;
    // (undocumented)
    refine(check: (arg: Output) => unknown | Promise<unknown>, message?: string | CustomErrorParams | ((arg: Output) => CustomErrorParams)): ZodEffects<this, Output, Input>;
    // (undocumented)
    refinement<RefinedOutput extends Output>(check: (arg: Output) => arg is RefinedOutput, refinementData: IssueData | ((arg: Output, ctx: RefinementCtx) => IssueData)): ZodEffects<this, RefinedOutput, Input>;
    // (undocumented)
    refinement(check: (arg: Output) => boolean, refinementData: IssueData | ((arg: Output, ctx: RefinementCtx) => IssueData)): ZodEffects<this, Output, Input>;
    // (undocumented)
    _refinement(refinement: RefinementEffect<Output>["refinement"]): ZodEffects<this, Output, Input>;
    // (undocumented)
    safeParse(data: unknown, params?: Partial<ParseParams>): SafeParseReturnType<Input, Output>;
    // (undocumented)
    safeParseAsync(data: unknown, params?: Partial<ParseParams>): Promise<SafeParseReturnType<Input, Output>>;
    spa: (data: unknown, params?: Partial<ParseParams> | undefined) => Promise<SafeParseReturnType<Input, Output>>;
    // (undocumented)
    superRefine<RefinedOutput extends Output>(refinement: (arg: Output, ctx: RefinementCtx) => arg is RefinedOutput): ZodEffects<this, RefinedOutput, Input>;
    // (undocumented)
    superRefine(refinement: (arg: Output, ctx: RefinementCtx) => void): ZodEffects<this, Output, Input>;
    // (undocumented)
    superRefine(refinement: (arg: Output, ctx: RefinementCtx) => Promise<void>): ZodEffects<this, Output, Input>;
    // (undocumented)
    transform<NewOut>(transform: (arg: Output, ctx: RefinementCtx) => NewOut | Promise<NewOut>): ZodEffects<this, NewOut>;
    // (undocumented)
    readonly _type: Output;
}

// @public (undocumented)
type ZodTypeAny = ZodType<any, any, any>;

// @public (undocumented)
interface ZodTypeDef {
    // (undocumented)
    description?: string;
    // (undocumented)
    errorMap?: ZodErrorMap;
}

// @public (undocumented)
class ZodUnion<T extends ZodUnionOptions> extends ZodType<T[number]["_output"], ZodUnionDef<T>, T[number]["_input"]> {
    // (undocumented)
    static create: <T_1 extends readonly [ZodTypeAny, ZodTypeAny, ...ZodTypeAny[]]>(types: T_1, params?: RawCreateParams) => ZodUnion<T_1>;
    // (undocumented)
    get options(): T;
    // (undocumented)
    _parse(input: ParseInput): ParseReturnType<this["_output"]>;
}

// @public (undocumented)
interface ZodUnionDef<T extends ZodUnionOptions = Readonly<[
ZodTypeAny,
ZodTypeAny,
...ZodTypeAny[]
]>> extends ZodTypeDef {
    // (undocumented)
    options: T;
    // (undocumented)
    typeName: ZodFirstPartyTypeKind.ZodUnion;
}

// @public (undocumented)
type ZodUnionOptions = Readonly<[ZodTypeAny, ...ZodTypeAny[]]>;

// @public (undocumented)
interface ZodUnrecognizedKeysIssue extends ZodIssueBase {
    // (undocumented)
    code: typeof ZodIssueCode.unrecognized_keys;
    // (undocumented)
    keys: string[];
}

// (No @packageDocumentation comment for this package)

```
