/** @type {import("@rspack/core").Configuration} */
module.exports = {
	target: 'web',
	node: false,
	module: {
		rules: [
			{
				test: /\.less$/,
				use: [
					{
						loader: "less-loader",
						options: {
							additionalData: async (content, loaderContext) => {
								const { resourcePath, rootContext } = loaderContext;
								const relativePath = require("path").relative(
									rootContext,
									resourcePath
								);

								return `
										@background: coral;
										${content};
										.custom-class {
											color: red;
											relative-path: '${relativePath}';
										};
									`;
							}
						}
					}
				],
				type: "css",
				generator: {
					exportsOnly: false,
				}
			}
		]
	}
};
