## API Report File for "@rspack/test-tools"

> Do not edit this file. It is a report generated by [API Extractor](https://api-extractor.com/).

```ts

import type { Compiler } from '@rspack/core';
import type { Compiler as Compiler_2 } from 'webpack';
import type { Configuration } from 'webpack';
import type EventEmitter from 'node:events';
import { IBasicGlobalContext as IBasicGlobalContext_2 } from '../../type';
import { IBasicModuleScope as IBasicModuleScope_2 } from '../../type';
import { ITestCompilerManager as ITestCompilerManager_2 } from '../type';
import type { RspackOptions } from '@rspack/core';
import type { RspackOptionsNormalized } from '@rspack/core';
import type { RspackPluginInstance } from '@rspack/core';
import type { Stats } from '@rspack/core';
import type { Stats as Stats_2 } from 'webpack';
import type { StatsCompilation } from '@rspack/core';
import type { StatsCompilation as StatsCompilation_2 } from 'webpack';
import type { StatsError } from '@rspack/core';
import { TRunnerRequirer as TRunnerRequirer_2 } from '..';
import type { WebpackOptionsNormalized } from 'webpack';

// @public (undocumented)
export class BasicProcessor<T extends ECompilerType> implements ITestProcessor {
    constructor(_options: IBasicProcessorOptions<T>);
    // (undocumented)
    after(context: ITestContext): Promise<void>;
    // (undocumented)
    afterAll(context: ITestContext): Promise<void>;
    // (undocumented)
    before(context: ITestContext): Promise<void>;
    // (undocumented)
    beforeAll(context: ITestContext): Promise<void>;
    // (undocumented)
    build(context: ITestContext): Promise<void>;
    // (undocumented)
    check(env: ITestEnv, context: ITestContext): Promise<void>;
    // (undocumented)
    compiler(context: ITestContext): Promise<void>;
    // (undocumented)
    config(context: ITestContext): Promise<void>;
    // (undocumented)
    protected getCompiler(context: ITestContext): ITestCompilerManager_2<T>;
    // (undocumented)
    protected _options: IBasicProcessorOptions<T>;
    // (undocumented)
    run(env: ITestEnv, context: ITestContext): Promise<void>;
}

// @public (undocumented)
export abstract class BasicRunner<T extends ECompilerType = ECompilerType.Rspack> implements ITestRunner {
    constructor(_options: IBasicRunnerOptions<T>);
    // (undocumented)
    protected baseModuleScope: IBasicModuleScope | null;
    // (undocumented)
    protected abstract createBaseModuleScope(): IBasicModuleScope;
    // (undocumented)
    protected abstract createGlobalContext(): IBasicGlobalContext;
    // (undocumented)
    protected abstract createModuleScope(requireFn: TRunnerRequirer, m: TModuleObject, file: TBasicRunnerFile): IBasicModuleScope;
    // (undocumented)
    protected createRunner(): void;
    // (undocumented)
    protected getFile(modulePath: string[] | string, currentDirectory: string): TBasicRunnerFile | null;
    // (undocumented)
    getGlobal(name: string): unknown;
    // (undocumented)
    getRequire(): TRunnerRequirer;
    // (undocumented)
    protected globalContext: IBasicGlobalContext | null;
    // (undocumented)
    protected _options: IBasicRunnerOptions<T>;
    // (undocumented)
    protected postExecute(m: Object, file: TBasicRunnerFile): void;
    // (undocumented)
    protected preExecute(code: string, file: TBasicRunnerFile): void;
    // (undocumented)
    protected requirers: Map<string, TRunnerRequirer>;
    // (undocumented)
    run(file: string): Promise<unknown>;
}

// @public (undocumented)
export class BasicRunnerFactory<T extends ECompilerType> implements TRunnerFactory<T> {
    constructor(name: string, context: ITestContext);
    // (undocumented)
    protected context: ITestContext;
    // (undocumented)
    create(file: string, compilerOptions: TCompilerOptions<T>, env: ITestEnv): ITestRunner;
    // (undocumented)
    protected createRunner(file: string, stats: TCompilerStatsCompilation<T>, compilerOptions: TCompilerOptions<T>, env: ITestEnv): ITestRunner;
    // (undocumented)
    protected getRunnerKey(file: string): string;
    // (undocumented)
    protected name: string;
}

// @public (undocumented)
export class BuiltinProcessor<T extends ECompilerType> extends SnapshotProcessor<T> {
    constructor(_builtinOptions: IBuiltinProcessorOptions<T>);
    // (undocumented)
    protected _builtinOptions: IBuiltinProcessorOptions<T>;
    // (undocumented)
    static defaultOptions<T extends ECompilerType>(this: BuiltinProcessor<T>, context: ITestContext): TCompilerOptions<T>;
}

// @public (undocumented)
export class CacheProcessor<T extends ECompilerType> extends BasicProcessor<T> {
    constructor(_cacheOptions: ICacheProcessorOptions<T>);
    // (undocumented)
    afterAll(context: ITestContext): Promise<void>;
    // (undocumented)
    build(context: ITestContext): Promise<void>;
    // (undocumented)
    protected _cacheOptions: ICacheProcessorOptions<T>;
    // (undocumented)
    static defaultOptions<T extends ECompilerType>(this: CacheProcessor<T>, context: ITestContext): TCompilerOptions<T>;
    // (undocumented)
    static findBundle<T extends ECompilerType>(this: CacheProcessor<T>, context: ITestContext): string[];
    // (undocumented)
    static overrideOptions<T extends ECompilerType>(this: CacheProcessor<T>, context: ITestContext, options: TCompilerOptions<T>): void;
    // (undocumented)
    run(env: ITestEnv, context: ITestContext): Promise<void>;
    // (undocumented)
    protected runner: ITestRunner | null;
    // (undocumented)
    protected updateOptions: TUpdateOptions;
}

// @public (undocumented)
export class CacheRunnerFactory<T extends ECompilerType> extends BasicRunnerFactory<T> {
    // (undocumented)
    protected createRunner(file: string, stats: TCompilerStatsCompilation<T>, compilerOptions: TCompilerOptions<T>, env: ITestEnv): ITestRunner;
}

// @public (undocumented)
export function checkChunkModules(statsJson: any, chunkModulesMap: any, strict?: boolean): boolean;

// @public (undocumented)
export function checkChunkRuntime(statsJson: any, chunkModulesMap: any, strict?: boolean): boolean;

// @public (undocumented)
export class CommonJsRunner<T extends ECompilerType = ECompilerType.Rspack> extends BasicRunner<T> {
    // (undocumented)
    protected createBaseModuleScope(): IBasicModuleScope;
    // (undocumented)
    protected createCjsRequirer(): TRunnerRequirer;
    // (undocumented)
    protected createGlobalContext(): IBasicGlobalContext;
    // (undocumented)
    protected createMissRequirer(): TRunnerRequirer;
    // (undocumented)
    protected createModuleScope(requireFn: TRunnerRequirer, m: TModuleObject, file: TBasicRunnerFile): IBasicModuleScope;
    // (undocumented)
    protected createRunner(): void;
}

// @public (undocumented)
export function compareContent(sourceContent: string | false, distContent: string | false, compareOptions: ICompareOptions): TCompareResult;

// @public (undocumented)
export function compareFile(sourceFile: string, distFile: string, compareOptions: ICompareOptions): TFileCompareResult;

// @public (undocumented)
export function compareModules(modules: string[], sourceModules: Map<string, string>, distModules: Map<string, string>, compareOptions: ICompareOptions): TModuleCompareResult[];

// @public (undocumented)
export class ConfigProcessor<T extends ECompilerType> extends MultiTaskProcessor<T> {
    constructor(_configOptions: IConfigProcessorOptions<T>);
    // (undocumented)
    protected _configOptions: IConfigProcessorOptions<T>;
    // (undocumented)
    static defaultOptions<T extends ECompilerType>(index: number, context: ITestContext): TCompilerOptions<T>;
    // (undocumented)
    static findBundle<T extends ECompilerType>(index: number, context: ITestContext, options: TCompilerOptions<T>): string | string[];
    // (undocumented)
    static overrideOptions<T extends ECompilerType>(index: number, context: ITestContext, options: TCompilerOptions<T>): void;
}

// @public (undocumented)
export function createBuiltinCase(name: string, src: string, dist: string): void;

// @public (undocumented)
export function createCacheCase(name: string, src: string, dist: string, target: TCompilerOptions<ECompilerType.Rspack>["target"]): void;

// @public (undocumented)
export function createCompilerCase(name: string, src: string, dist: string, testConfig: string): void;

// @public (undocumented)
export function createConfigCase(name: string, src: string, dist: string): void;

// @public (undocumented)
export function createDefaultsCase(name: string, src: string): void;

// @public (undocumented)
export function createDiagnosticCase(name: string, src: string, dist: string): void;

// @public (undocumented)
export function createDiffCase(name: string, src: string, dist: string): void;

// @public (undocumented)
export function createErrorCase(name: string, src: string, dist: string, testConfig: string): void;

// @public (undocumented)
export function createHashCase(name: string, src: string, dist: string): void;

// @public (undocumented)
export function createHookCase(name: string, src: string, dist: string, source: string): void;

// @public (undocumented)
export function createHotCase(name: string, src: string, dist: string, target: TCompilerOptions<ECompilerType.Rspack>["target"]): void;

// @public (undocumented)
export function createHotNewIncrementalCase(name: string, src: string, dist: string, target: TCompilerOptions<ECompilerType.Rspack>["target"], documentType: EDocumentType): void;

// @public (undocumented)
export function createHotStepCase(name: string, src: string, dist: string, target: TCompilerOptions<ECompilerType.Rspack>["target"]): void;

// @public (undocumented)
export function createNormalCase(name: string, src: string, dist: string): void;

// @public (undocumented)
export function createStatsAPICase(name: string, src: string, dist: string, testConfig: string): void;

// @public (undocumented)
export function createStatsOutputCase(name: string, src: string, dist: string): void;

// @public (undocumented)
export function createTreeShakingCase(name: string, src: string, dist: string): void;

// @public (undocumented)
export function createWatchCase(name: string, src: string, dist: string, temp: string): void;

// @public (undocumented)
export function createWatchNewIncrementalCase(name: string, src: string, dist: string, temp: string): void;

// @public (undocumented)
export class DefaultsConfigProcessor<T extends ECompilerType> extends SimpleTaskProcessor<T> {
    constructor(_defaultsConfigOptions: IDefaultsConfigProcessorOptions<T>);
    // (undocumented)
    after(context: ITestContext): Promise<void>;
    // (undocumented)
    afterAll(context: ITestContext): Promise<void>;
    // (undocumented)
    before(context: ITestContext): Promise<void>;
    // (undocumented)
    beforeAll(context: ITestContext): Promise<void>;
    // (undocumented)
    build(context: ITestContext): Promise<void>;
    // (undocumented)
    check(env: ITestEnv, context: ITestContext): Promise<void>;
    // (undocumented)
    compiler(context: ITestContext): Promise<void>;
    // (undocumented)
    protected _defaultsConfigOptions: IDefaultsConfigProcessorOptions<T>;
    // (undocumented)
    protected getCompiler(context: ITestContext): ITestCompilerManager_2<T>;
    // (undocumented)
    static getDefaultConfig(cwd: string, config: TCompilerOptions<ECompilerType>): TCompilerOptions<ECompilerType>;
    // (undocumented)
    run(env: ITestEnv, context: ITestContext): Promise<void>;
}

// @public (undocumented)
export function describeByWalk(testFile: string, createCase: (name: string, src: string, dist: string) => void, options?: {
    type?: "file" | "directory";
    level?: number;
    source?: string;
    dist?: string;
    absoluteDist?: boolean;
    describe?: jest.Describe;
    exclude?: RegExp[];
}): void;

// @public (undocumented)
export class DiagnosticProcessor<T extends ECompilerType> extends BasicProcessor<T> {
    constructor(_diagnosticOptions: IDiagnosticProcessorOptions<T>);
    // (undocumented)
    check(env: ITestEnv, context: ITestContext): Promise<void>;
    // (undocumented)
    static defaultOptions<T extends ECompilerType>(context: ITestContext): TCompilerOptions<T>;
    // (undocumented)
    protected _diagnosticOptions: IDiagnosticProcessorOptions<T>;
}

// @public (undocumented)
export class DiffComparator {
    constructor(options: IDiffComparatorOptions);
    // (undocumented)
    compare(): Promise<void>;
}

// @public (undocumented)
export class DiffHtmlReporter implements ITestReporter<TModuleCompareResult[]> {
    constructor(options: IDiffHtmlReporterOptions);
    // (undocumented)
    failure(id: string): Promise<void>;
    // (undocumented)
    increment(id: string, data: TModuleCompareResult[]): Promise<void>;
    // (undocumented)
    init(data?: TModuleCompareResult[]): Promise<void>;
    // (undocumented)
    output(): Promise<void>;
}

// @public (undocumented)
export class DiffProcessor implements ITestProcessor {
    constructor(options: IDiffProcessorOptions);
    // (undocumented)
    build(context: ITestContext): Promise<void>;
    // (undocumented)
    check(env: ITestEnv, context: ITestContext): Promise<void>;
    // (undocumented)
    compiler(context: ITestContext): Promise<void>;
    // (undocumented)
    config(context: ITestContext): Promise<void>;
}

// @public (undocumented)
export class DiffStatsReporter implements ITestReporter<TModuleCompareResult[]> {
    constructor(options: IDiffStatsReporterOptions);
    // (undocumented)
    failure(id: string): Promise<void>;
    // (undocumented)
    increment(id: string, data: TModuleCompareResult[]): Promise<void>;
    // (undocumented)
    init(data?: TModuleCompareResult[]): Promise<void>;
    // (undocumented)
    output(): Promise<void>;
}

// @public (undocumented)
export enum ECompareResultType {
    // (undocumented)
    Different = "different",
    // (undocumented)
    Missing = "missing",
    // (undocumented)
    OnlyDist = "only-dist",
    // (undocumented)
    OnlySource = "only-source",
    // (undocumented)
    Same = "same"
}

// @public (undocumented)
export enum ECompilerType {
    // (undocumented)
    Rspack = "rspack",
    // (undocumented)
    Webpack = "webpack"
}

// @public (undocumented)
export enum EDocumentType {
    // (undocumented)
    Fake = "fake",
    // (undocumented)
    JSDOM = "jsdom"
}

// @public (undocumented)
export enum EEsmMode {
    // (undocumented)
    Evaluated = 1,
    // (undocumented)
    Unknown = 0,
    // (undocumented)
    Unlinked = 2
}

// @public (undocumented)
export class ErrorProcessor<T extends ECompilerType> extends SimpleTaskProcessor<T> {
    constructor(_errorOptions: IErrorProcessorOptions<T>);
    // (undocumented)
    check(env: ITestEnv, context: ITestContext): Promise<void>;
    // (undocumented)
    compiler(context: ITestContext): Promise<void>;
    // (undocumented)
    protected _errorOptions: IErrorProcessorOptions<T>;
    // (undocumented)
    run(env: ITestEnv, context: ITestContext): Promise<void>;
}

// @public (undocumented)
export function escapeSep(str: string): string;

// @public (undocumented)
export class EsmRunner<T extends ECompilerType = ECompilerType.Rspack> extends CommonJsRunner<T> {
    // (undocumented)
    protected createEsmRequirer(): TRunnerRequirer;
    // (undocumented)
    protected createRunner(): void;
}

// @public (undocumented)
export class FakeDocumentWebRunner<T extends ECompilerType = ECompilerType.Rspack> extends CommonJsRunner<T> {
    constructor(_webOptions: IBasicRunnerOptions<T>);
    // (undocumented)
    protected createBaseModuleScope(): IBasicModuleScope_2;
    // (undocumented)
    protected createGlobalContext(): IBasicGlobalContext_2;
    // (undocumented)
    protected createJsonRequirer(): TRunnerRequirer;
    // (undocumented)
    protected createModuleScope(requireFn: TRunnerRequirer, m: any, file: TBasicRunnerFile): IBasicModuleScope_2;
    // (undocumented)
    protected createRunner(): void;
    // (undocumented)
    protected postExecute(_: Object, file: TBasicRunnerFile): void;
    // (undocumented)
    protected preExecute(_: string, file: TBasicRunnerFile): void;
    // (undocumented)
    run(file: string): Promise<unknown>;
    // (undocumented)
    protected _webOptions: IBasicRunnerOptions<T>;
}

// @public (undocumented)
export function formatCode(name: string, raw: string, options: IFormatCodeOptions): string;

// @public (undocumented)
export function getSimpleProcessorRunner(src: string, dist: string, options?: {
    env?: () => ITestEnv;
    context?: (src: string, dist: string) => ITestContext;
}): (name: string, processor: ITestProcessor) => Promise<void>;

// @public (undocumented)
export class HashProcessor<T extends ECompilerType> extends MultiTaskProcessor<T> {
    constructor(_hashOptions: IHashProcessorOptions<T>);
    // (undocumented)
    check(env: ITestEnv, context: ITestContext): Promise<void>;
    // (undocumented)
    static defaultOptions<T extends ECompilerType>(index: number, context: ITestContext): TCompilerOptions<T>;
    // (undocumented)
    static overrideOptions<T extends ECompilerType>(index: number, context: ITestContext, options: TCompilerOptions<T>): void;
}

// @public (undocumented)
export class HookCasesContext extends TestContext {
    constructor(src: string, testName: string, options: TTestContextOptions);
    // @internal (undocumented)
    _addSnapshot(content: unknown, name: string, group: string | number): void;
    // @internal (undocumented)
    collectSnapshots(env: ITestEnv, options?: {
        diff: {};
    }): Promise<void>;
    // (undocumented)
    protected count: number;
    // (undocumented)
    protected options: TTestContextOptions;
    // (undocumented)
    protected promises: Promise<void>[];
    snapped(cb: (...args: unknown[]) => Promise<unknown>, prefix?: string): (this: any, ...args: unknown[]) => Promise<unknown>;
    // (undocumented)
    protected snapshots: Record<string | number, Array<[string | Buffer, string]>>;
    // (undocumented)
    protected snapshotsList: Array<string | number>;
    // (undocumented)
    protected src: string;
    // (undocumented)
    protected testName: string;
}

// @public (undocumented)
export class HookTaskProcessor<T extends ECompilerType> extends SnapshotProcessor<T> {
    constructor(_hookOptions: IHookProcessorOptions<T>);
    // (undocumented)
    check(env: ITestEnv, context: HookCasesContext): Promise<void>;
    // (undocumented)
    compiler(context: ITestContext): Promise<void>;
    // (undocumented)
    config(context: ITestContext): Promise<void>;
    // (undocumented)
    static defaultOptions<T extends ECompilerType>(context: ITestContext): TCompilerOptions<T>;
    // (undocumented)
    protected _hookOptions: IHookProcessorOptions<T>;
}

// @public (undocumented)
export class HotNewIncrementalProcessor<T extends ECompilerType> extends HotProcessor<T> {
    constructor(_hotOptions: IHotNewIncrementalProcessorOptions<T>);
    // (undocumented)
    afterAll(context: ITestContext): Promise<void>;
    // (undocumented)
    static defaultOptions<T extends ECompilerType>(this: HotNewIncrementalProcessor<T>, context: ITestContext): TCompilerOptions<T>;
    // (undocumented)
    protected _hotOptions: IHotNewIncrementalProcessorOptions<T>;
    // (undocumented)
    run(env: ITestEnv, context: ITestContext): Promise<void>;
}

// @public (undocumented)
export class HotProcessor<T extends ECompilerType> extends BasicProcessor<T> {
    constructor(_hotOptions: IHotProcessorOptions<T>);
    // (undocumented)
    afterAll(context: ITestContext): Promise<void>;
    // (undocumented)
    static defaultOptions<T extends ECompilerType>(this: HotProcessor<T>, context: ITestContext): TCompilerOptions<T>;
    // (undocumented)
    static findBundle<T extends ECompilerType>(this: HotProcessor<T>, context: ITestContext): string[];
    // (undocumented)
    protected _hotOptions: IHotProcessorOptions<T>;
    // (undocumented)
    static overrideOptions<T extends ECompilerType>(this: HotProcessor<T>, context: ITestContext, options: TCompilerOptions<T>): void;
    // (undocumented)
    run(env: ITestEnv, context: ITestContext): Promise<void>;
    // (undocumented)
    protected runner: ITestRunner | null;
    // (undocumented)
    protected updateOptions: TUpdateOptions;
}

// @public (undocumented)
export class HotRunnerFactory<T extends ECompilerType> extends BasicRunnerFactory<T> {
    // (undocumented)
    protected createRunner(file: string, stats: TCompilerStatsCompilation<T>, compilerOptions: TCompilerOptions<T>, env: ITestEnv): ITestRunner;
}

// @public (undocumented)
export class HotSnapshotProcessor<T extends ECompilerType> extends HotProcessor<T> {
    constructor(_hotOptions: IHotSnapshotProcessorOptions<T>);
    // (undocumented)
    check(env: ITestEnv, context: ITestContext): Promise<void>;
    // (undocumented)
    protected _hotOptions: IHotSnapshotProcessorOptions<T>;
    // (undocumented)
    protected matchStepSnapshot(env: ITestEnv, context: ITestContext, step: number, stats: TCompilerStatsCompilation<T>, runtime?: THotStepRuntimeData): void;
    // (undocumented)
    run(env: ITestEnv, context: ITestContext): Promise<void>;
}

// @public (undocumented)
export class HotStepRunnerFactory<T extends ECompilerType> extends HotRunnerFactory<T> {
    // (undocumented)
    protected createRunner(file: string, stats: TCompilerStatsCompilation<T>, compilerOptions: TCompilerOptions<T>, env: ITestEnv): ITestRunner;
}

// @public (undocumented)
export interface IBasicGlobalContext {
    // (undocumented)
    [key: string]: any;
    // (undocumented)
    clearTimeout: typeof clearTimeout;
    // (undocumented)
    console: Console;
    // (undocumented)
    setTimeout: typeof setTimeout;
}

// @public (undocumented)
export interface IBasicModuleScope extends ITestEnv {
    // (undocumented)
    [key: string]: any;
    // (undocumented)
    console: Console;
    // (undocumented)
    expect: jest.Expect;
}

// @public (undocumented)
export interface IBasicProcessorOptions<T extends ECompilerType> {
    // (undocumented)
    compilerType: T;
    // (undocumented)
    configFiles?: string[];
    // (undocumented)
    defaultOptions?: (context: ITestContext) => TCompilerOptions<T>;
    // (undocumented)
    findBundle?: (context: ITestContext, options: TCompilerOptions<T>) => string[] | string | void;
    // (undocumented)
    name: string;
    // (undocumented)
    overrideOptions?: (context: ITestContext, options: TCompilerOptions<T>) => void;
    // (undocumented)
    runable: boolean;
}

// @public (undocumented)
export interface IBasicRunnerOptions<T extends ECompilerType> {
    // (undocumented)
    compilerOptions: TCompilerOptions<T>;
    // (undocumented)
    dist: string;
    // (undocumented)
    env: ITestEnv;
    // (undocumented)
    name: string;
    // (undocumented)
    runInNewContext?: boolean;
    // (undocumented)
    source: string;
    // (undocumented)
    stats?: TCompilerStatsCompilation<T>;
    // (undocumented)
    testConfig: TTestConfig<T>;
}

// @public (undocumented)
export interface IBuiltinProcessorOptions<T extends ECompilerType> extends Omit<ISnapshotProcessorOptions<T>, "runable"> {
}

// @public (undocumented)
export interface ICacheProcessorOptions<T extends ECompilerType> extends Omit<IBasicProcessorOptions<T>, "runable"> {
    // (undocumented)
    target: TCompilerOptions<T>["target"];
}

// @public (undocumented)
export interface ICompareOptions {
    // (undocumented)
    bootstrap?: boolean;
    // (undocumented)
    detail?: boolean;
    // (undocumented)
    format: IFormatCodeOptions;
    // (undocumented)
    modules?: TCompareModules;
    // (undocumented)
    renameModule?: (name: string) => string;
    // (undocumented)
    runtimeModules?: TCompareModules;
}

// @public (undocumented)
export interface IConfigProcessorOptions<T extends ECompilerType> extends IMultiTaskProcessorOptions<T> {
}

// @public (undocumented)
export interface IDefaultsConfigProcessorOptions<T extends ECompilerType> {
    // (undocumented)
    compilerType: T;
    // (undocumented)
    cwd?: string;
    // (undocumented)
    diff: (diff: jest.JestMatchers<RspackTestDiff>, defaults: jest.JestMatchers<TCompilerOptions<T>>) => Promise<void>;
    // (undocumented)
    name: string;
    // (undocumented)
    options?: (context: ITestContext) => TCompilerOptions<T>;
}

// @public (undocumented)
export interface IDiagnosticProcessorOptions<T extends ECompilerType> extends Omit<IBasicProcessorOptions<T>, "runable"> {
    // (undocumented)
    format?: (output: string) => string;
    // (undocumented)
    snapshot: string;
}

// @public (undocumented)
export interface IDiffComparatorOptions {
    // (undocumented)
    bootstrap?: boolean;
    // (undocumented)
    files: string[];
    // (undocumented)
    formatOptions?: IFormatCodeOptions;
    // (undocumented)
    modules?: TCompareModules;
    // (undocumented)
    reporters: ITestReporter<unknown>[];
    // (undocumented)
    rspackDist: string;
    // (undocumented)
    runtimeModules?: TCompareModules;
    // (undocumented)
    webpackDist: string;
}

// @public (undocumented)
export interface IDiffHtmlReporterOptions {
    // (undocumented)
    dist: string;
    // (undocumented)
    ignore?: RegExp;
}

// @public (undocumented)
export interface IDiffProcessorOptions extends IFormatCodeOptions {
    // (undocumented)
    bootstrap?: boolean;
    // (undocumented)
    detail?: boolean;
    // (undocumented)
    errors?: boolean;
    // (undocumented)
    files?: string[];
    // (undocumented)
    modules?: TCompareModules;
    // (undocumented)
    onCompareFile?: (file: string, result: TFileCompareResult) => void;
    // (undocumented)
    onCompareModules?: (file: string, results: TModuleCompareResult[]) => void;
    // (undocumented)
    onCompareRuntimeModules?: (file: string, results: TModuleCompareResult[]) => void;
    // (undocumented)
    renameModule?: (file: string) => string;
    // (undocumented)
    replacements?: IFormatCodeReplacement[];
    // (undocumented)
    rspackPath: string;
    // (undocumented)
    runtimeModules?: TCompareModules;
    // (undocumented)
    webpackPath: string;
}

// @public (undocumented)
export interface IDiffStatsReporterOptions {
    // (undocumented)
    file: string;
    // (undocumented)
    footer?: string[];
    // (undocumented)
    header?: string[];
    // (undocumented)
    report?: boolean;
}

// @public (undocumented)
export interface IErrorProcessorOptions<T extends ECompilerType> {
    // (undocumented)
    build?: (context: ITestContext, compiler: TCompiler<T>) => Promise<void>;
    // (undocumented)
    check?: (stats: RspackStatsDiagnostics) => Promise<void>;
    // (undocumented)
    compilerType: T;
    // (undocumented)
    name: string;
    // (undocumented)
    options?: (options: TCompilerOptions<T>, context: ITestContext) => TCompilerOptions<T>;
}

// @public (undocumented)
export interface IFormatCodeOptions {
    // (undocumented)
    ignoreBlockOnlyStatement: boolean;
    // (undocumented)
    ignoreCssFilePath: boolean;
    // (undocumented)
    ignoreIfCertainCondition: boolean;
    // (undocumented)
    ignoreModuleArguments: boolean;
    // (undocumented)
    ignoreModuleId: boolean;
    // (undocumented)
    ignoreObjectPropertySequence: boolean;
    // (undocumented)
    ignorePropertyQuotationMark: boolean;
    // (undocumented)
    ignoreSwcHelpersPath: boolean;
    // (undocumented)
    replacements?: IFormatCodeReplacement[];
}

// @public (undocumented)
export interface IFormatCodeReplacement {
    // (undocumented)
    from: string | RegExp;
    // (undocumented)
    to: string;
}

// @public (undocumented)
export interface IHashProcessorOptions<T extends ECompilerType> extends Omit<IMultiTaskProcessorOptions<T>, "runable"> {
}

// @public (undocumented)
export interface IHookProcessorOptions<T extends ECompilerType> extends ISnapshotProcessorOptions<T> {
    // (undocumented)
    check?: (context: ITestContext) => Promise<void>;
    // (undocumented)
    compiler?: (context: ITestContext, compiler: TCompiler<T>) => Promise<void>;
    // (undocumented)
    options?: (context: ITestContext) => TCompilerOptions<T>;
}

// @public (undocumented)
export interface IHotNewIncrementalProcessorOptions<T extends ECompilerType> extends Omit<IBasicProcessorOptions<T>, "runable"> {
    // (undocumented)
    documentType?: EDocumentType;
    // (undocumented)
    target: TCompilerOptions<T>["target"];
}

// @public (undocumented)
export interface IHotProcessorOptions<T extends ECompilerType> extends Omit<IBasicProcessorOptions<T>, "runable"> {
    // (undocumented)
    target: TCompilerOptions<T>["target"];
}

// @public (undocumented)
export interface IHotSnapshotProcessorOptions<T extends ECompilerType> extends IHotProcessorOptions<T> {
    // (undocumented)
    getModuleHandler?: TModuleGetHandler;
    // (undocumented)
    snapshot?: string;
}

// @public (undocumented)
export interface IMultiTaskProcessorOptions<T extends ECompilerType> {
    // (undocumented)
    compilerType: T;
    // (undocumented)
    configFiles?: string[];
    // (undocumented)
    defaultOptions?: (index: number, context: ITestContext) => TCompilerOptions<T>;
    // (undocumented)
    findBundle?: (index: number, context: ITestContext, options: TCompilerOptions<T>) => string[] | string | void;
    // (undocumented)
    name: string;
    // (undocumented)
    overrideOptions?: (index: number, context: ITestContext, options: TCompilerOptions<T>) => void;
    // (undocumented)
    runable: boolean;
}

// @public (undocumented)
export interface INormalProcessorOptions<T extends ECompilerType> extends IBasicProcessorOptions<T> {
    // (undocumented)
    compilerOptions?: TCompilerOptions<T>;
    // (undocumented)
    root: string;
}

// @public (undocumented)
export const isDirectory: (p: string) => boolean;

// @public (undocumented)
export const isFile: (p: string) => boolean;

// @public (undocumented)
export interface ISimpleProcessorOptions<T extends ECompilerType> {
    // (undocumented)
    build?: (context: ITestContext, compiler: TCompiler<T>) => Promise<void>;
    // (undocumented)
    check?: (context: ITestContext, compiler: TCompiler<T>, stats: TCompilerStats<T>) => Promise<void>;
    // (undocumented)
    compiler?: (context: ITestContext, compiler: TCompiler<T>) => Promise<void>;
    // (undocumented)
    compilerType: T;
    // (undocumented)
    name: string;
    // (undocumented)
    options?: (context: ITestContext) => TCompilerOptions<T>;
}

// @public (undocumented)
export interface ISnapshotProcessorOptions<T extends ECompilerType> extends IBasicProcessorOptions<T> {
    // (undocumented)
    snapshot: string;
    // (undocumented)
    snapshotFileFilter?: (file: string) => boolean;
}

// @public (undocumented)
export interface IStatsAPIProcessorOptions<T extends ECompilerType> {
    // (undocumented)
    build?: (context: ITestContext, compiler: TCompiler<T>) => Promise<void>;
    // (undocumented)
    check?: (stats: TCompilerStats<T>, compiler: TCompiler<T>) => Promise<void>;
    // (undocumented)
    compiler?: (context: ITestContext, compiler: TCompiler<T>) => Promise<void>;
    // (undocumented)
    compilerType: T;
    // (undocumented)
    name: string;
    // (undocumented)
    options?: (context: ITestContext) => TCompilerOptions<T>;
}

// @public (undocumented)
export interface IStatsProcessorOptions<T extends ECompilerType> extends Omit<IMultiTaskProcessorOptions<T>, "runable"> {
}

// @public (undocumented)
export function isUpdateSnapshot(): boolean;

// @public (undocumented)
export const isValidCaseDirectory: (name: string) => boolean;

// @public (undocumented)
export interface ITestCompilerManager<T extends ECompilerType> {
    // (undocumented)
    build(): Promise<TCompilerStats<T>>;
    // (undocumented)
    close(): Promise<void>;
    // (undocumented)
    createCompiler(): TCompiler<T>;
    // (undocumented)
    getCompiler(): TCompiler<T> | null;
    // (undocumented)
    getEmitter(): EventEmitter;
    // (undocumented)
    getOptions(): TCompilerOptions<T>;
    // (undocumented)
    getStats(): TCompilerStats<T> | null;
    // (undocumented)
    mergeOptions(newOptions: TCompilerOptions<T>): TCompilerOptions<T>;
    // (undocumented)
    setOptions(newOptions: TCompilerOptions<T>): TCompilerOptions<T>;
    // (undocumented)
    watch(timeout?: number): void;
}

// @public (undocumented)
export interface ITestContext {
    // (undocumented)
    clearError(name?: string): void;
    // (undocumented)
    emitError(name: string, err: Error | string): void;
    // (undocumented)
    getCompiler<T extends ECompilerType>(name: string, type: T | void): ITestCompilerManager<T>;
    // (undocumented)
    getDist(sub?: string): string;
    // (undocumented)
    getError(name?: string): Error[];
    // (undocumented)
    getNames(): string[];
    // (undocumented)
    getRunner(key: string): ITestRunner | null;
    // (undocumented)
    getRunnerFactory<T extends ECompilerType>(name: string): TRunnerFactory<T> | null;
    // (undocumented)
    getSource(sub?: string): string;
    // (undocumented)
    getTemp(sub?: string): string | null;
    // (undocumented)
    getTestConfig<T extends ECompilerType>(): TTestConfig<T>;
    // (undocumented)
    getValue<T>(name: string, key: string): T | void;
    // (undocumented)
    hasError(name?: string): boolean;
    // (undocumented)
    setRunner(key: string, runner: ITestRunner): void;
    // (undocumented)
    setValue<T>(name: string, key: string, value: T): void;
}

// @public (undocumented)
export interface ITestEnv {
    // (undocumented)
    [key: string]: unknown;
    // (undocumented)
    afterEach: (...args: any[]) => void;
    // (undocumented)
    beforeEach: (...args: any[]) => void;
    // (undocumented)
    expect: jest.Expect;
    // (undocumented)
    it: (...args: any[]) => void;
}

// @public (undocumented)
export interface ITester {
    // (undocumented)
    check(env: ITestEnv): Promise<void>;
    // (undocumented)
    compile(): Promise<void>;
    // (undocumented)
    getContext(): ITestContext;
    // (undocumented)
    next(): boolean;
    // (undocumented)
    prepare(): Promise<void>;
    // (undocumented)
    resume(): Promise<void>;
    // (undocumented)
    step: number;
    // (undocumented)
    total: number;
}

// @public (undocumented)
export interface ITesterConfig {
    // (undocumented)
    compilerFactories?: TCompilerFactories;
    // (undocumented)
    contextValue?: Record<string, unknown>;
    // (undocumented)
    dist: string;
    // (undocumented)
    name: string;
    // (undocumented)
    runnerFactory?: new (name: string, context: ITestContext) => TRunnerFactory<ECompilerType>;
    // (undocumented)
    src: string;
    // (undocumented)
    steps?: ITestProcessor[];
    // (undocumented)
    temp?: string;
    // (undocumented)
    testConfig?: TTestConfig<ECompilerType>;
}

// @public (undocumented)
export interface ITestLoader {
    // (undocumented)
    walk(): Promise<void>;
}

// @public (undocumented)
export interface ITestProcessor {
    // (undocumented)
    after?(context: ITestContext): Promise<void>;
    // (undocumented)
    afterAll?(context: ITestContext): Promise<void>;
    // (undocumented)
    before?(context: ITestContext): Promise<void>;
    // (undocumented)
    beforeAll?(context: ITestContext): Promise<void>;
    // (undocumented)
    build?(context: ITestContext): Promise<void>;
    // (undocumented)
    check?(env: ITestEnv, context: ITestContext): Promise<unknown>;
    // (undocumented)
    compiler?(context: ITestContext): Promise<void>;
    // (undocumented)
    config?(context: ITestContext): Promise<void>;
    // (undocumented)
    run?(env: ITestEnv, context: ITestContext): Promise<void>;
}

// @public (undocumented)
export interface ITestReporter<T> {
    // (undocumented)
    failure(id: string): Promise<void>;
    // (undocumented)
    increment(id: string, data: T): Promise<void>;
    // (undocumented)
    init(data?: T): Promise<void>;
    // (undocumented)
    output(): Promise<void>;
}

// @public (undocumented)
export interface ITestRunner {
    // (undocumented)
    getGlobal(name: string): unknown;
    // (undocumented)
    getRequire(): TRunnerRequirer;
    // (undocumented)
    run(file: string): Promise<unknown>;
}

// @public (undocumented)
export interface IWatchProcessorOptions<T extends ECompilerType> extends IMultiTaskProcessorOptions<T> {
    // (undocumented)
    experiments?: TRspackExperiments;
    // (undocumented)
    optimization?: TRspackOptimization;
    // (undocumented)
    stepName: string;
    // (undocumented)
    tempDir: string;
}

// @public (undocumented)
interface IWatchRunnerOptions<T extends ECompilerType = ECompilerType.Rspack> extends IBasicRunnerOptions<T> {
    // (undocumented)
    isWeb: boolean;
    // (undocumented)
    stepName: string;
}

// @public (undocumented)
export interface IWatchStepProcessorOptions<T extends ECompilerType> extends Omit<IWatchProcessorOptions<T>, "experiments" | "optimization"> {
}

// @public (undocumented)
export interface IWebRunnerOptions<T extends ECompilerType = ECompilerType.Rspack> extends IBasicRunnerOptions<T> {
    // (undocumented)
    dom: EDocumentType;
}

// @public (undocumented)
export class JSDOMWebRunner<T extends ECompilerType = ECompilerType.Rspack> extends CommonJsRunner<T> {
    constructor(_webOptions: IBasicRunnerOptions<T>);
    // (undocumented)
    protected createBaseModuleScope(): IBasicModuleScope_2;
    // (undocumented)
    protected createJSDOMRequirer(): TRunnerRequirer;
    // (undocumented)
    protected createResourceLoader(): {
        fetch(url: string, _: {
            element: HTMLScriptElement;
        }): any;
    };
    // (undocumented)
    protected createRunner(): void;
    // (undocumented)
    getGlobal(name: string): unknown;
    // (undocumented)
    run(file: string): Promise<unknown>;
    // (undocumented)
    protected _webOptions: IBasicRunnerOptions<T>;
}

// @public (undocumented)
export class MultipleRunnerFactory<T extends ECompilerType> extends BasicRunnerFactory<T> {
    // (undocumented)
    protected createRunner(file: string, stats: TCompilerStatsCompilation<T>, compilerOptions: TCompilerOptions<T>, env: ITestEnv): ITestRunner;
    // (undocumented)
    protected getFileIndexHandler(file: string): {
        getIndex: () => number[];
        flagIndex: () => Set<string>;
    };
    // (undocumented)
    protected getRunnerKey(file: string): string;
    // (undocumented)
    protected runned: Set<string>;
}

// @public (undocumented)
export class MultiTaskProcessor<T extends ECompilerType> extends BasicProcessor<T> implements ITestProcessor {
    constructor(_multiOptions: IMultiTaskProcessorOptions<T>);
    // (undocumented)
    config(context: ITestContext): Promise<void>;
    // (undocumented)
    protected multiCompilerOptions: TCompilerOptions<T>[];
    // (undocumented)
    protected _multiOptions: IMultiTaskProcessorOptions<T>;
}

// @public (undocumented)
export class NormalProcessor<T extends ECompilerType> extends BasicProcessor<T> {
    constructor(_normalOptions: INormalProcessorOptions<T>);
    // (undocumented)
    static defaultOptions<T extends ECompilerType>(this: NormalProcessor<T>, context: ITestContext): TCompilerOptions<T>;
    // (undocumented)
    protected _normalOptions: INormalProcessorOptions<T>;
}

// @public (undocumented)
export class NormalRunner<T extends ECompilerType = ECompilerType.Rspack> extends EsmRunner<T> {
    // (undocumented)
    protected createBaseModuleScope(): IBasicModuleScope;
    // (undocumented)
    protected createModuleScope(requireFn: TRunnerRequirer, m: {
        exports: unknown;
    }, file: TBasicRunnerFile): IBasicModuleScope;
}

// @public (undocumented)
export class NormalRunnerFactory<T extends ECompilerType> extends BasicRunnerFactory<T> {
    // (undocumented)
    protected createRunner(file: string, stats: TCompilerStatsCompilation<T>, compilerOptions: TCompilerOptions<T>, env: ITestEnv): ITestRunner;
}

// @public (undocumented)
export function parseModules(content: string, options?: {
    bootstrap?: boolean;
    renameModule?: (name: string) => string;
}): {
    modules: Map<string, string>;
    runtimeModules: Map<string, string>;
};

// @public (undocumented)
export function readConfigFile<T extends ECompilerType>(files: string[], functionApply?: (config: (TCompilerOptions<T> | ((...args: unknown[]) => TCompilerOptions<T>))[]) => TCompilerOptions<T>[]): TCompilerOptions<T>[];

// @public (undocumented)
export function replaceModuleArgument(raw: string): string;

// @public (undocumented)
export function replaceRuntimeModuleName(name: string): string;

// @public (undocumented)
export class RspackDiffConfigPlugin implements RspackPluginInstance {
    constructor(modifier?: ((options: RspackOptionsNormalized) => RspackOptionsNormalized) | undefined);
    // (undocumented)
    apply(compiler: Compiler): void;
    // (undocumented)
    name: string;
}

// @public (undocumented)
class RspackStatsDiagnostics {
    constructor(errors: StatsError[], warnings: StatsError[]);
    // (undocumented)
    errors: StatsError[];
    // (undocumented)
    warnings: StatsError[];
}

// @public (undocumented)
class RspackTestDiff {
    constructor(value: string);
    // (undocumented)
    value: string;
}

// @public (undocumented)
export class SimpleTaskProcessor<T extends ECompilerType> implements ITestProcessor {
    constructor(_options: ISimpleProcessorOptions<T>);
    // (undocumented)
    after(context: ITestContext): Promise<void>;
    // (undocumented)
    afterAll(context: ITestContext): Promise<void>;
    // (undocumented)
    before(context: ITestContext): Promise<void>;
    // (undocumented)
    beforeAll(context: ITestContext): Promise<void>;
    // (undocumented)
    build(context: ITestContext): Promise<void>;
    // (undocumented)
    check(env: ITestEnv, context: ITestContext): Promise<void>;
    // (undocumented)
    compiler(context: ITestContext): Promise<void>;
    // (undocumented)
    config(context: ITestContext): Promise<void>;
    // (undocumented)
    protected getCompiler(context: ITestContext): ITestCompilerManager_2<T>;
    // (undocumented)
    protected _options: ISimpleProcessorOptions<T>;
    // (undocumented)
    run(env: ITestEnv, context: ITestContext): Promise<void>;
}

// @public (undocumented)
export class SnapshotProcessor<T extends ECompilerType> extends BasicProcessor<T> {
    constructor(_snapshotOptions: ISnapshotProcessorOptions<T>);
    // (undocumented)
    check(env: ITestEnv, context: ITestContext): Promise<void>;
    // (undocumented)
    serializeEachFile(content: string): string;
    // (undocumented)
    protected _snapshotOptions: ISnapshotProcessorOptions<T>;
}

// @public (undocumented)
export class StatsAPIProcessor<T extends ECompilerType> extends SimpleTaskProcessor<T> {
    constructor(_statsAPIOptions: IStatsAPIProcessorOptions<T>);
    // (undocumented)
    check(env: ITestEnv, context: ITestContext): Promise<void>;
    // (undocumented)
    compiler(context: ITestContext): Promise<void>;
    // (undocumented)
    run(env: ITestEnv, context: ITestContext): Promise<void>;
    // (undocumented)
    protected _statsAPIOptions: IStatsAPIProcessorOptions<T>;
}

// @public (undocumented)
export class StatsProcessor<T extends ECompilerType> extends MultiTaskProcessor<T> {
    constructor(_statsOptions: IStatsProcessorOptions<T>);
    // (undocumented)
    after(context: ITestContext): Promise<void>;
    // (undocumented)
    before(context: ITestContext): Promise<void>;
    // (undocumented)
    check(env: ITestEnv, context: ITestContext): Promise<void>;
    // (undocumented)
    compiler(context: ITestContext): Promise<void>;
    // (undocumented)
    static defaultOptions<T extends ECompilerType>(index: number, context: ITestContext): TCompilerOptions<T>;
    // (undocumented)
    static overrideOptions<T extends ECompilerType>(index: number, context: ITestContext, options: TCompilerOptions<T>): void;
}

// @public (undocumented)
export type TBasicRunnerFile = {
    path: string;
    content: string;
    subPath: string;
};

// @public (undocumented)
export type TCaseSummary = Record<TCaseSummaryId, number>;

// @public (undocumented)
export type TCaseSummaryId = `${TCompilerTypeId}|${TModuleTypeId}|${TDimenTypeId}`;

// @public (undocumented)
export type TCompareModules = string[] | true;

// @public (undocumented)
export type TCompareResult = {
    type: ECompareResultType;
    detail?: unknown;
    source?: string;
    dist?: string;
    lines?: {
        common: number;
        source: number;
        dist: number;
    };
};

// @public (undocumented)
export type TCompiler<T> = T extends ECompilerType.Rspack ? Compiler : Compiler_2;

// @public (undocumented)
export type TCompilerCaseConfig = Omit<ISimpleProcessorOptions<ECompilerType.Rspack>, "name" | "compilerType"> & {
    description: string;
};

// @public (undocumented)
export type TCompilerFactories = Record<ECompilerType, TCompilerFactory<ECompilerType>>;

// @public (undocumented)
export type TCompilerFactory<T extends ECompilerType> = (options: TCompilerOptions<T> | TCompilerOptions<T>[]) => TCompiler<T>;

// @public (undocumented)
export type TCompilerOptions<T> = T extends ECompilerType.Rspack ? RspackOptions : Configuration;

// @public (undocumented)
export type TCompilerStats<T> = T extends ECompilerType.Rspack ? Stats : Stats_2;

// @public (undocumented)
export type TCompilerStatsCompilation<T> = T extends ECompilerType.Rspack ? StatsCompilation : StatsCompilation_2;

// @public (undocumented)
export type TCompilerTypeId = ECompilerType.Rspack | ECompilerType.Webpack | "common";

// @public (undocumented)
export type TConfigCaseConfig = Omit<TTestConfig<ECompilerType.Rspack>, "validate">;

// @public (undocumented)
export type TDefaultsCaseConfig = Omit<IDefaultsConfigProcessorOptions<ECompilerType.Rspack>, "name" | "compilerType"> & {
    description: string;
};

// @public (undocumented)
export type TDiffCaseConfig = IDiffProcessorOptions;

// @public (undocumented)
export type TDiffStats = {
    root: string;
    data: Array<TDiffStatsItem>;
};

// @public (undocumented)
export type TDiffStatsItem = {
    name: string;
    source: string;
    dist: string;
    type: ECompareResultType;
};

// @public (undocumented)
export type TDimenTypeId = "modules" | "lines" | "lines-in-common";

// @public (undocumented)
export type TErrorCaseConfig = Omit<IErrorProcessorOptions<ECompilerType.Rspack>, "name" | "compilerType"> & {
    description: string;
};

// @public (undocumented)
export class TestContext implements ITestContext {
    constructor(config: TTestContextOptions);
    // (undocumented)
    clearError(name?: string): void;
    // (undocumented)
    protected compilers: Map<string, ITestCompilerManager<ECompilerType>>;
    // (undocumented)
    emitError(name: string, err: Error | string): void;
    // (undocumented)
    protected errors: Map<string, Error[]>;
    // (undocumented)
    getCompiler<T extends ECompilerType>(name: string, type: T | void): ITestCompilerManager<T>;
    // (undocumented)
    getDist(sub?: string): string;
    // (undocumented)
    getError(name?: string): Error[];
    // (undocumented)
    getNames(): string[];
    // (undocumented)
    getRunner(key: string): ITestRunner | null;
    // (undocumented)
    getRunnerFactory<T extends ECompilerType>(name: string): TRunnerFactory<T> | null;
    // (undocumented)
    getSource(sub?: string): string;
    // (undocumented)
    getTemp(sub?: string): string | null;
    // (undocumented)
    getTestConfig<T extends ECompilerType>(): TTestConfig<T>;
    // (undocumented)
    getValue<T>(name: string, key: string): T | void;
    // (undocumented)
    hasError(name?: string): boolean;
    // (undocumented)
    protected runnerFactory: TRunnerFactory<ECompilerType> | null;
    // (undocumented)
    protected runners: Map<string, ITestRunner>;
    // (undocumented)
    setRunner(key: string, runner: ITestRunner): void;
    // (undocumented)
    setValue<T>(name: string, key: string, value: T): void;
    // (undocumented)
    protected store: Map<string, Record<string, unknown>>;
}

// @public (undocumented)
export class Tester implements ITester {
    constructor(config: ITesterConfig);
    // (undocumented)
    check(env: ITestEnv): Promise<void>;
    // (undocumented)
    compile(): Promise<void>;
    // (undocumented)
    getContext(): ITestContext;
    // (undocumented)
    next(): boolean;
    // (undocumented)
    prepare(): Promise<void>;
    // (undocumented)
    resume(): Promise<void>;
    // (undocumented)
    step: number;
    // (undocumented)
    total: number;
}

// @public (undocumented)
export type TFileCompareResult = TCompareResult & {
    file: {
        source: string;
        dist: string;
    };
    modules: Partial<Record<"modules" | "runtimeModules", TModuleCompareResult[]>>;
};

// @public (undocumented)
export type THashCaseConfig = Pick<TTestConfig<ECompilerType.Rspack>, "validate">;

// @public (undocumented)
export type THookCaseConfig = Omit<IHookProcessorOptions<ECompilerType.Rspack>, "name" | "compilerType" | "runable"> & {
    description: string;
};

// @public (undocumented)
export type THotStepRuntimeData = {
    javascript: THotStepRuntimeLangData;
    css: THotStepRuntimeLangData;
    statusPath: string[];
};

// @public (undocumented)
export type THotStepRuntimeLangData = {
    outdatedModules: string[];
    outdatedDependencies: Record<string, string[]>;
    updatedModules: string[];
    updatedRuntime: string[];
    acceptedModules: string[];
    disposedModules: string[];
};

// @public (undocumented)
export type TModuleCompareResult = TCompareResult & {
    name: string;
};

// @public (undocumented)
type TModuleGetHandler = (file: string, options: TCompilerOptions<ECompilerType>) => string[];

// @public (undocumented)
export type TModuleObject = {
    exports: unknown;
};

// @public (undocumented)
export type TModuleTypeId = "normal" | "runtime";

// @public (undocumented)
type TRspackExperiments = TCompilerOptions<ECompilerType>["experiments"];

// @public (undocumented)
type TRspackOptimization = TCompilerOptions<ECompilerType>["optimization"];

// @public (undocumented)
export interface TRunnerFactory<T extends ECompilerType> {
    // (undocumented)
    create(file: string, compilerOptions: TCompilerOptions<T>, env: ITestEnv): ITestRunner;
}

// @public (undocumented)
export type TRunnerRequirer = (currentDirectory: string, modulePath: string[] | string, context?: {
    file?: TBasicRunnerFile;
    esmMode?: EEsmMode;
}) => Object | Promise<Object>;

// @public (undocumented)
export type TStatsAPICaseConfig = Omit<IStatsAPIProcessorOptions<ECompilerType.Rspack>, "name" | "compilerType"> & {
    description: string;
};

// @public (undocumented)
export type TTestConfig<T extends ECompilerType> = {
    documentType?: EDocumentType;
    validate?: (stats: TCompilerStats<T>, stderr?: string) => void;
    noTest?: boolean;
    beforeExecute?: () => void;
    afterExecute?: () => void;
    moduleScope?: (ms: IBasicModuleScope, stats?: TCompilerStatsCompilation<T>) => IBasicModuleScope;
    checkStats?: (stepName: string, stats: TCompilerStatsCompilation<T>) => boolean;
    findBundle?: (index: number, options: TCompilerOptions<T>, stepName?: string) => string | string[];
    bundlePath?: string[];
    nonEsmThis?: (p: string | string[]) => Object;
    modules?: Record<string, Object>;
    timeout?: number;
};

// @public (undocumented)
export type TTestContextOptions = Omit<ITesterConfig, "name" | "steps">;

// @public (undocumented)
export type TTestFilter<T extends ECompilerType> = (creatorConfig: Record<string, unknown>, testConfig: TTestConfig<T>) => boolean | string;

// @public (undocumented)
export type TTestRunResult = Record<string, any>;

// @public (undocumented)
export type TUpdateOptions = {
    updateIndex: number;
    totalUpdates: number;
    changedFiles: string[];
};

// @public (undocumented)
export class WatchProcessor<T extends ECompilerType> extends MultiTaskProcessor<T> {
    constructor(_watchOptions: IWatchProcessorOptions<T>);
    // (undocumented)
    build(context: ITestContext): Promise<void>;
    // (undocumented)
    check(env: ITestEnv, context: ITestContext): Promise<void>;
    // (undocumented)
    compiler(context: ITestContext): Promise<void>;
    // (undocumented)
    config(context: ITestContext): Promise<void>;
    // (undocumented)
    protected currentTriggerFilename: string | null;
    // (undocumented)
    static findBundle<T extends ECompilerType>(this: IWatchProcessorOptions<T>, index: number, context: ITestContext, options: TCompilerOptions<T>): string | string[];
    // (undocumented)
    protected lastHash: string | null;
    // (undocumented)
    static overrideOptions<T extends ECompilerType>({ tempDir, name, experiments, optimization }: IWatchProcessorOptions<T>): (index: number, context: ITestContext, options: TCompilerOptions<ECompilerType>) => void;
    // (undocumented)
    run(env: ITestEnv, context: ITestContext): Promise<void>;
    // (undocumented)
    protected _watchOptions: IWatchProcessorOptions<T>;
}

// @public (undocumented)
export class WatchRunner<T extends ECompilerType = ECompilerType.Rspack> extends FakeDocumentWebRunner<T> {
    constructor(_watchOptions: IWatchRunnerOptions<T>);
    // (undocumented)
    protected createModuleScope(requireFn: TRunnerRequirer, m: any, file: TBasicRunnerFile): IBasicModuleScope;
    // (undocumented)
    run(file: string): Promise<unknown>;
    // (undocumented)
    protected _watchOptions: IWatchRunnerOptions<T>;
}

// @public (undocumented)
export class WatchRunnerFactory<T extends ECompilerType> extends BasicRunnerFactory<T> {
    // (undocumented)
    protected createRunner(file: string, stats: TCompilerStatsCompilation<T>, compilerOptions: TCompilerOptions<T>, env: ITestEnv): ITestRunner;
    // (undocumented)
    protected getRunnerKey(file: string): string;
}

// @public (undocumented)
export class WatchStepProcessor<T extends ECompilerType> extends WatchProcessor<T> {
    constructor(_watchOptions: IWatchStepProcessorOptions<T>);
    // (undocumented)
    build(context: ITestContext): Promise<void>;
    // (undocumented)
    compiler(context: ITestContext): Promise<void>;
    // (undocumented)
    protected _watchOptions: IWatchStepProcessorOptions<T>;
}

// @public (undocumented)
export class WebpackDiffConfigPlugin {
    constructor(modifier?: ((options: WebpackOptionsNormalized) => WebpackOptionsNormalized) | undefined);
    // (undocumented)
    apply(compiler: Compiler_2): void;
    // (undocumented)
    name: string;
}

// @public (undocumented)
export class WebpackModulePlaceholderPlugin {
    // (undocumented)
    apply(compiler: any): void;
}

// @public (undocumented)
export class WebRunner<T extends ECompilerType = ECompilerType.Rspack> implements ITestRunner {
    constructor(_webOptions: IWebRunnerOptions<T>);
    // (undocumented)
    getGlobal(name: string): unknown;
    // (undocumented)
    getRequire(): TRunnerRequirer_2;
    // (undocumented)
    protected originMethods: Partial<CommonJsRunner>;
    // (undocumented)
    run(file: string): Promise<unknown>;
    // (undocumented)
    protected _webOptions: IWebRunnerOptions<T>;
}

// (No @packageDocumentation comment for this package)

```
