use rspack_cacheable::{cacheable, with::AsPreset};
use rspack_util::atom::Atom;

#[cacheable]
#[derive(Debug, Clone)]
pub struct LocalModule {
  #[cacheable(with=AsPreset)]
  name: Atom,
  idx: usize,
  used: bool,
}

impl LocalModule {
  pub fn new(name: Atom, idx: usize) -> Self {
    Self {
      name,
      idx,
      used: false,
    }
  }

  pub fn flag_used(&mut self) {
    self.used = true;
  }

  pub fn variable_name(&self) -> String {
    format!("__WEBPACK_LOCAL_MODULE_{}__", self.idx)
  }

  pub fn is_used(&self) -> bool {
    self.used
  }

  pub fn get_name(&self) -> &Atom {
    &self.name
  }

  pub fn get_idx(&self) -> usize {
    self.idx
  }
}
