__webpack_require__.f.css = function (chunkId, promises, fetchPriority) {
	// css chunk loading
	var installedChunkData = __webpack_require__.o(installedChunks, chunkId)
		? installedChunks[chunkId]
		: undefined;
	if (installedChunkData !== 0) {
		// 0 means "already installed".

		// a Promise means "currently loading".
		if (installedChunkData) {
			promises.push(installedChunkData[2]);
		} else {
			if (CSS_MATCHER) {
				// setup Promise in chunk cache
				var promise = new Promise(function (resolve, reject) {
					installedChunkData = installedChunks[chunkId] = [resolve, reject];
				});
				promises.push((installedChunkData[2] = promise));

				// start chunk loading
				var url = __webpack_require__.p + __webpack_require__.k(chunkId);
				// create error before stack unwound to get useful stacktrace later
				var error = new Error();
				var loadingEnded = function (event) {
					if (__webpack_require__.o(installedChunks, chunkId)) {
						installedChunkData = installedChunks[chunkId];
						if (installedChunkData !== 0) installedChunks[chunkId] = undefined;
						if (installedChunkData) {
							if (event.type !== "load") {
								var errorType = event && event.type;
								var realSrc = event && event.target && event.target.src;
								error.message =
									"Loading css chunk " +
									chunkId +
									" failed.\n(" +
									errorType +
									": " +
									realSrc +
									")";
								error.name = "ChunkLoadError";
								error.type = errorType;
								error.request = realSrc;
								installedChunkData[1](error);
							} else {
								loadCssChunkData(__webpack_require__.m, chunkId);
								installedChunkData[0]();
							}
						}
					}
				};
				var link = loadStylesheet(chunkId, url, loadingEnded, undefined, fetchPriority);
			} else installedChunks[chunkId] = 0;
		}
	}
};
