/* auto-generated by NAPI-RS */
/* eslint-disable */

/* -- banner.d.ts -- */
export type JsFilename =
	| string
	| ((pathData: JsPathData, assetInfo?: JsAssetInfo) => string);

export type LocalJsFilename = JsFilename;

export type RawLazyCompilationTest = RegExp | ((m: JsModule) => boolean);
/* -- banner.d.ts end -- */

/* -- napi-rs generated below -- */

export declare class ExternalObject<T> {
  readonly '': {
    readonly '': unique symbol
    [K: symbol]: T
  }
}
export declare class EntryDataDto {
  get dependencies(): JsDependency[]
  get includeDependencies(): JsDependency[]
  get options(): EntryOptionsDto
}
export type EntryDataDTO = EntryDataDto

export declare class EntryOptionsDto {
  get name(): string | undefined
  set name(name: string | undefined)
  get runtime(): false | string | undefined
  set runtime(chunkLoading: boolean | string | undefined)
  get chunkLoading(): string | undefined
  set chunkLoading(chunkLoading: string | false | undefined)
  get asyncChunks(): boolean | undefined
  set asyncChunks(asyncChunks: boolean | undefined)
  get baseUri(): string | undefined
  set baseUri(baseUri: string | undefined)
  get library(): JsLibraryOptions | undefined
  set library(library: JsLibraryOptions | undefined)
  get dependOn(): Array<string> | undefined
  set dependOn(dependOn: Array<string> | undefined)
  get layer(): string | undefined
  set layer(layer: string | undefined)
}
export type EntryOptionsDTO = EntryOptionsDto

export declare class JsChunk {
  get name(): string | undefined
  get id(): string | undefined
  get ids(): Array<string>
  get idNameHints(): Array<string>
  get filenameTemplate(): string | undefined
  get cssFilenameTemplate(): string | undefined
  get files(): Array<string>
  get runtime(): Array<string>
  get hash(): string | undefined
  get contentHash(): Record<string, string>
  get renderedHash(): string | undefined
  get chunkReason(): string | undefined
  get auxiliaryFiles(): Array<string>
  isOnlyInitial(): boolean
  canBeInitial(): boolean
  hasRuntime(): boolean
  getAllAsyncChunks(): JsChunk[]
  getAllInitialChunks(): JsChunk[]
  getAllReferencedChunks(): JsChunk[]
  groups(): JsChunkGroup[]
}

export declare class JsChunkGraph {
  getChunkModules(chunk: JsChunk): JsModule[]
  getChunkEntryModules(chunk: JsChunk): JsModule[]
  getChunkEntryDependentChunksIterable(chunk: JsChunk): JsChunk[]
  getChunkModulesIterableBySourceType(chunk: JsChunk, sourceType: string): JsModule[]
  getModuleChunks(module: JsModule): JsChunk[]
  getModuleId(jsModule: JsModule): string | null
}

export declare class JsChunkGroup {
  get chunks(): JsChunk[]
  get index(): number | undefined
  get name(): string | undefined
  get origins(): Array<JsChunkGroupOrigin>
  isInitial(): boolean
  getParents(): JsChunkGroup[]
  getRuntimeChunk(): JsChunk
  getFiles(): Array<string>
}

export declare class JsCompilation {
  updateAsset(filename: string, newSourceOrFunction: JsCompatSource | ((source: JsCompatSourceOwned) => JsCompatSourceOwned), assetInfoUpdateOrFunction?: JsAssetInfo | ((assetInfo: JsAssetInfo) => JsAssetInfo)): void
  getAssets(): Readonly<JsAsset>[]
  getAsset(name: string): JsAsset | null
  getAssetSource(name: string): JsCompatSource | null
  get modules(): Array<JsModule>
  get builtModules(): Array<JsModule>
  getOptimizationBailout(): Array<JsStatsOptimizationBailout>
  getChunks(): JsChunk[]
  getNamedChunkKeys(): Array<string>
  getNamedChunk(name: string): JsChunk
  getNamedChunkGroupKeys(): Array<string>
  getNamedChunkGroup(name: string): JsChunkGroup
  setAssetSource(name: string, source: JsCompatSource): void
  deleteAssetSource(name: string): void
  getAssetFilenames(): Array<string>
  hasAsset(name: string): boolean
  emitAssetFromLoader(filename: string, source: JsCompatSource, assetInfo: JsAssetInfo, module: string): void
  emitAsset(filename: string, source: JsCompatSource, assetInfo: JsAssetInfo): void
  deleteAsset(filename: string): void
  renameAsset(filename: string, newName: string): void
  get entrypoints(): Record<string, JsChunkGroup>
  get chunkGroups(): JsChunkGroup[]
  get hash(): string | null
  dependencies(): JsDependencies
  pushDiagnostic(diagnostic: JsRspackDiagnostic): void
  spliceDiagnostic(start: number, end: number, replaceWith: Array<JsRspackDiagnostic>): void
  pushNativeDiagnostic(diagnostic: ExternalObject<'Diagnostic'>): void
  pushNativeDiagnostics(diagnostics: ExternalObject<'Diagnostic[]'>): void
  getErrors(): Array<JsRspackError>
  getWarnings(): Array<JsRspackError>
  getStats(): JsStats
  getAssetPath(filename: LocalJsFilename, data: JsPathData): string
  getAssetPathWithInfo(filename: LocalJsFilename, data: JsPathData): PathWithInfo
  getPath(filename: LocalJsFilename, data: JsPathData): string
  getPathWithInfo(filename: LocalJsFilename, data: JsPathData): PathWithInfo
  addFileDependencies(deps: Array<string>): void
  addContextDependencies(deps: Array<string>): void
  addMissingDependencies(deps: Array<string>): void
  addBuildDependencies(deps: Array<string>): void
  /**
   * This is a very unsafe function.
   * Please don't use this at the moment.
   * Using async and mutable reference to `Compilation` at the same time would likely to cause data races.
   */
  rebuildModule(moduleIdentifiers: Array<string>, f: any): void
  importModule(request: string, layer: string | undefined | null, publicPath: JsFilename | undefined | null, baseUri: string | undefined | null, originalModule: string | undefined | null, originalModuleContext: string | undefined | null, callback: any): void
  get entries(): JsEntries
  addRuntimeModule(chunk: JsChunk, runtimeModule: JsAddingRuntimeModule): void
  get moduleGraph(): JsModuleGraph
  get chunkGraph(): JsChunkGraph
  addInclude(args: [string, RawDependency, JsEntryOptions | undefined][], callback: (errMsg: Error | null, results: [string | null, JsModule][]) => void): void
}

export declare class JsContextModuleFactoryAfterResolveData {
  get resource(): string
  set resource(resource: string)
  get context(): string
  set context(context: string)
  get request(): string
  set request(request: string)
  get regExp(): RegExp | undefined
  set regExp(rawRegExp: RegExp | undefined)
  get recursive(): boolean
  set recursive(recursive: boolean)
  get dependencies(): JsDependency[]
}

export declare class JsContextModuleFactoryBeforeResolveData {
  get context(): string
  set context(context: string)
  get request(): string
  set request(request: string)
  get regExp(): RegExp | undefined
  set regExp(rawRegExp: RegExp | undefined)
  get recursive(): boolean
  set recursive(recursive: boolean)
}

export declare class JsDependencies {
  get fileDependencies(): Array<string>
  get addedFileDependencies(): Array<string>
  get removedFileDependencies(): Array<string>
  get contextDependencies(): Array<string>
  get addedContextDependencies(): Array<string>
  get removedContextDependencies(): Array<string>
  get missingDependencies(): Array<string>
  get addedMissingDependencies(): Array<string>
  get removedMissingDependencies(): Array<string>
  get buildDependencies(): Array<string>
  get addedBuildDependencies(): Array<string>
  get removedBuildDependencies(): Array<string>
}

export declare class JsDependenciesBlock {
  get dependencies(): JsDependency[]
  get blocks(): JsDependenciesBlock[]
}

export declare class JsDependency {
  get type(): string
  get category(): string
  get request(): string | undefined
  get critical(): boolean
  set critical(val: boolean)
}

export declare class JsEntries {
  clear(): void
  get size(): number
  has(key: string): boolean
  set(key: string, value: JsEntryData | EntryDataDto): void
  delete(key: string): boolean
  get(key: string): EntryDataDto | undefined
  keys(): Array<string>
  values(): Array<EntryDataDto>
}

export declare class JsExportsInfo {
  isUsed(runtime: string | string[] | undefined): boolean
  isModuleUsed(runtime: string | string[] | undefined): boolean
  setUsedInUnknownWay(runtime: string | string[] | undefined): boolean
  getUsed(name: string | string[], runtime: string | string[] | undefined):  0 | 1 | 2 | 3 | 4
}

export declare class JsModule {
  get context(): string | undefined
  get originalSource(): JsCompatSource | undefined
  get resource(): string | undefined
  get moduleIdentifier(): string
  get nameForCondition(): string | undefined
  get request(): string | undefined
  get userRequest(): string | undefined
  set userRequest(val: string)
  get rawRequest(): string | undefined
  get factoryMeta(): JsFactoryMeta | undefined
  get type(): string
  get layer(): string | undefined
  get blocks(): JsDependenciesBlock[]
  get dependencies(): JsDependency[]
  size(ty?: string | undefined | null): number
  get modules(): JsModule[] | undefined
  get useSourceMap(): boolean
}

export declare class JsModuleGraph {
  getModule(jsDependency: JsDependency): JsModule | null
  getResolvedModule(jsDependency: JsDependency): JsModule | null
  getUsedExports(jsModule: JsModule, jsRuntime: string | Array<string>): boolean | Array<string> | null
  getIssuer(module: JsModule): JsModule | null
  getExportsInfo(module: JsModule): JsExportsInfo
  getConnection(dependency: JsDependency): JsModuleGraphConnection | null
  getOutgoingConnections(module: JsModule): JsModuleGraphConnection[]
  getIncomingConnections(module: JsModule): JsModuleGraphConnection[]
}

export declare class JsModuleGraphConnection {
  get dependency(): JsDependency
  get module(): JsModule | null
}

export declare class JsResolver {
  resolveSync(path: string, request: string): string | false
  withOptions(raw?: RawResolveOptionsWithDependencyType | undefined | null): JsResolver
}

export declare class JsResolverFactory {
  constructor()
  get(type: string, options?: RawResolveOptionsWithDependencyType): JsResolver
}

export declare class JsStats {
  toJson(jsOptions: JsStatsOptions): JsStatsCompilation
  hasWarnings(): boolean
  hasErrors(): boolean
  getLogging(acceptedTypes: number): Array<JsStatsLogging>
}

export declare class RawExternalItemFnCtx {
  data(): RawExternalItemFnCtxData
  getResolver(): JsResolver
}

export declare class Rspack {
  constructor(compilerPath: string, options: RawOptions, builtinPlugins: Array<BuiltinPlugin>, registerJsTaps: RegisterJsTaps, outputFilesystem: ThreadsafeNodeFS, intermediateFilesystem: ThreadsafeNodeFS | undefined | null, resolverFactoryReference: JsResolverFactory)
  setNonSkippableRegisters(kinds: Array<RegisterJsTapKind>): void
  /** Build with the given option passed to the constructor */
  build(callback: (err: null | Error) => void): void
  /** Rebuild with the given option passed to the constructor */
  rebuild(changed_files: string[], removed_files: string[], callback: (err: null | Error) => void): void
}

export interface BuiltinPlugin {
  name: BuiltinPluginName
  options: unknown
  canInherentFromParent?: boolean
}

export declare enum BuiltinPluginName {
  DefinePlugin = 'DefinePlugin',
  ProvidePlugin = 'ProvidePlugin',
  BannerPlugin = 'BannerPlugin',
  IgnorePlugin = 'IgnorePlugin',
  ProgressPlugin = 'ProgressPlugin',
  EntryPlugin = 'EntryPlugin',
  DynamicEntryPlugin = 'DynamicEntryPlugin',
  ExternalsPlugin = 'ExternalsPlugin',
  NodeTargetPlugin = 'NodeTargetPlugin',
  ElectronTargetPlugin = 'ElectronTargetPlugin',
  EnableChunkLoadingPlugin = 'EnableChunkLoadingPlugin',
  EnableLibraryPlugin = 'EnableLibraryPlugin',
  EnableWasmLoadingPlugin = 'EnableWasmLoadingPlugin',
  FetchCompileAsyncWasmPlugin = 'FetchCompileAsyncWasmPlugin',
  ChunkPrefetchPreloadPlugin = 'ChunkPrefetchPreloadPlugin',
  CommonJsChunkFormatPlugin = 'CommonJsChunkFormatPlugin',
  ArrayPushCallbackChunkFormatPlugin = 'ArrayPushCallbackChunkFormatPlugin',
  ModuleChunkFormatPlugin = 'ModuleChunkFormatPlugin',
  HotModuleReplacementPlugin = 'HotModuleReplacementPlugin',
  LimitChunkCountPlugin = 'LimitChunkCountPlugin',
  WorkerPlugin = 'WorkerPlugin',
  WebWorkerTemplatePlugin = 'WebWorkerTemplatePlugin',
  MergeDuplicateChunksPlugin = 'MergeDuplicateChunksPlugin',
  SplitChunksPlugin = 'SplitChunksPlugin',
  RemoveDuplicateModulesPlugin = 'RemoveDuplicateModulesPlugin',
  ShareRuntimePlugin = 'ShareRuntimePlugin',
  ContainerPlugin = 'ContainerPlugin',
  ContainerReferencePlugin = 'ContainerReferencePlugin',
  ProvideSharedPlugin = 'ProvideSharedPlugin',
  ConsumeSharedPlugin = 'ConsumeSharedPlugin',
  ModuleFederationRuntimePlugin = 'ModuleFederationRuntimePlugin',
  NamedModuleIdsPlugin = 'NamedModuleIdsPlugin',
  NaturalModuleIdsPlugin = 'NaturalModuleIdsPlugin',
  DeterministicModuleIdsPlugin = 'DeterministicModuleIdsPlugin',
  NaturalChunkIdsPlugin = 'NaturalChunkIdsPlugin',
  NamedChunkIdsPlugin = 'NamedChunkIdsPlugin',
  DeterministicChunkIdsPlugin = 'DeterministicChunkIdsPlugin',
  OccurrenceChunkIdsPlugin = 'OccurrenceChunkIdsPlugin',
  RealContentHashPlugin = 'RealContentHashPlugin',
  RemoveEmptyChunksPlugin = 'RemoveEmptyChunksPlugin',
  EnsureChunkConditionsPlugin = 'EnsureChunkConditionsPlugin',
  WarnCaseSensitiveModulesPlugin = 'WarnCaseSensitiveModulesPlugin',
  DataUriPlugin = 'DataUriPlugin',
  FileUriPlugin = 'FileUriPlugin',
  RuntimePlugin = 'RuntimePlugin',
  JsonModulesPlugin = 'JsonModulesPlugin',
  InferAsyncModulesPlugin = 'InferAsyncModulesPlugin',
  JavascriptModulesPlugin = 'JavascriptModulesPlugin',
  AsyncWebAssemblyModulesPlugin = 'AsyncWebAssemblyModulesPlugin',
  AssetModulesPlugin = 'AssetModulesPlugin',
  SourceMapDevToolPlugin = 'SourceMapDevToolPlugin',
  EvalSourceMapDevToolPlugin = 'EvalSourceMapDevToolPlugin',
  EvalDevToolModulePlugin = 'EvalDevToolModulePlugin',
  SideEffectsFlagPlugin = 'SideEffectsFlagPlugin',
  FlagDependencyExportsPlugin = 'FlagDependencyExportsPlugin',
  FlagDependencyUsagePlugin = 'FlagDependencyUsagePlugin',
  MangleExportsPlugin = 'MangleExportsPlugin',
  ModuleConcatenationPlugin = 'ModuleConcatenationPlugin',
  CssModulesPlugin = 'CssModulesPlugin',
  APIPlugin = 'APIPlugin',
  RuntimeChunkPlugin = 'RuntimeChunkPlugin',
  SizeLimitsPlugin = 'SizeLimitsPlugin',
  NoEmitOnErrorsPlugin = 'NoEmitOnErrorsPlugin',
  ContextReplacementPlugin = 'ContextReplacementPlugin',
  DllEntryPlugin = 'DllEntryPlugin',
  DllReferenceAgencyPlugin = 'DllReferenceAgencyPlugin',
  LibManifestPlugin = 'LibManifestPlugin',
  FlagAllModulesAsUsedPlugin = 'FlagAllModulesAsUsedPlugin',
  HttpExternalsRspackPlugin = 'HttpExternalsRspackPlugin',
  CopyRspackPlugin = 'CopyRspackPlugin',
  HtmlRspackPlugin = 'HtmlRspackPlugin',
  SwcJsMinimizerRspackPlugin = 'SwcJsMinimizerRspackPlugin',
  LightningCssMinimizerRspackPlugin = 'LightningCssMinimizerRspackPlugin',
  BundlerInfoRspackPlugin = 'BundlerInfoRspackPlugin',
  CssExtractRspackPlugin = 'CssExtractRspackPlugin',
  JsLoaderRspackPlugin = 'JsLoaderRspackPlugin',
  LazyCompilationPlugin = 'LazyCompilationPlugin'
}

export declare function cleanupGlobalTrace(): void

export interface ContextInfo {
  issuer: string
  issuerLayer?: string
}

export declare function formatDiagnostic(diagnostic: JsDiagnostic): ExternalObject<'Diagnostic'>

export interface JsAddingRuntimeModule {
  name: string
  generator: () => String
  dependentHash: boolean
  fullHash: boolean
  isolate: boolean
  stage: number
}

export interface JsAdditionalTreeRuntimeRequirementsArg {
  chunk: JsChunk
  runtimeRequirements: JsRuntimeGlobals
}

export interface JsAdditionalTreeRuntimeRequirementsResult {
  runtimeRequirements: JsRuntimeGlobals
}

export interface JsAfterEmitData {
  outputName: string
}

export interface JsAfterResolveData {
  request: string
  context: string
  issuer: string
  fileDependencies: Array<string>
  contextDependencies: Array<string>
  missingDependencies: Array<string>
  createData?: JsCreateData
}

export interface JsAfterTemplateExecutionData {
  html: string
  headTags: Array<JsHtmlPluginTag>
  bodyTags: Array<JsHtmlPluginTag>
  outputName: string
}

export interface JsAlterAssetTagGroupsData {
  headTags: Array<JsHtmlPluginTag>
  bodyTags: Array<JsHtmlPluginTag>
  publicPath: string
  outputName: string
}

export interface JsAlterAssetTagsData {
  assetTags: JsHtmlPluginAssetTags
  outputName: string
  publicPath: string
}

export interface JsAsset {
  name: string
  info: JsAssetInfo
}

export interface JsAssetEmittedArgs {
  filename: string
  outputPath: string
  targetPath: string
}

export interface JsAssetInfo {
  /** if the asset can be long term cached forever (contains a hash) */
  immutable?: boolean
  /** whether the asset is minimized */
  minimized?: boolean
  /** the value(s) of the full hash used for this asset */
  fullhash: Array<string>
  /** the value(s) of the chunk hash used for this asset */
  chunkhash: Array<string>
  /**
   * the value(s) of the module hash used for this asset
   * the value(s) of the content hash used for this asset
   */
  contenthash: Array<string>
  sourceFilename?: string
  /** when asset was created from a source file (potentially transformed), it should be flagged as copied */
  copied?: boolean
  /**
   * size in bytes, only set after asset has been emitted
   * when asset is only used for development and doesn't count towards user-facing assets
   */
  development?: boolean
  /** when asset ships data for updating an existing application (HMR) */
  hotModuleReplacement?: boolean
  /** when asset is javascript and an ESM */
  javascriptModule?: boolean
  /** related object to other assets, keyed by type of relation (only points from parent to child) */
  related: JsAssetInfoRelated
  /** unused css local ident for the css chunk */
  cssUnusedIdents?: Array<string>
  /**
   * Webpack: AssetInfo = KnownAssetInfo & Record<string, any>
   * But Napi.rs does not support Intersectiont types. This is a hack to store the additional fields
   * in the rust struct and have the Js side to reshape and align with webpack
   * Related: packages/rspack/src/Compilation.ts
   */
  extras: Record<string, any>
  /** whether this asset is over the size limit */
  isOverSizeLimit?: boolean
}

export interface JsAssetInfoRelated {
  sourceMap?: string
}

export interface JsBannerContentFnCtx {
  hash: string
  chunk: JsChunk
  filename: string
}

export interface JsBeforeAssetTagGenerationData {
  assets: JsHtmlPluginAssets
  outputName: string
}

export interface JsBeforeEmitData {
  html: string
  outputName: string
}

export interface JsBeforeResolveArgs {
  request: string
  context: string
  issuer: string
}

export interface JsBuildMeta {
  strictEsmModule: boolean
  hasTopLevelAwait: boolean
  esm: boolean
  exportsType: 'unset' | 'default' | 'namespace' | 'flagged' | 'dynamic'
  defaultObject: 'false' | 'redirect' | JsBuildMetaDefaultObjectRedirectWarn
  moduleArgument: 'module' | 'webpackModule'
  exportsArgument: 'exports' | 'webpackExports'
  sideEffectFree?: boolean
  exportsFinalName?: Array<[string, string]> | undefined
}

export interface JsBuildMetaDefaultObjectRedirectWarn {
  redirectWarn: JsDefaultObjectRedirectWarnObject
}

export interface JsBuildTimeExecutionOption {
  publicPath?: string
  baseUri?: string
}

export interface JsCacheGroupTestCtx {
  module: JsModule
}

export interface JsChunkAssetArgs {
  chunk: JsChunk
  filename: string
}

export interface JsChunkGroupOrigin {
  module?: JsModule | undefined
  request?: string
}

export interface JsChunkOptionNameCtx {
  module: JsModule
  chunks: JsChunk[]
  cacheGroupKey: string
}

/**
 * File clean options
 *
 * This matches with:
 * - keep:
 *   - If a string, keep the files under this path
 */
export interface JsCleanOptions {
  keep?: string
}

export interface JsCodegenerationResult {
  sources: Record<string, string>
}

export interface JsCodegenerationResults {
  map: Record<string, Record<string, JsCodegenerationResult>>
}

/**
 * Zero copy `JsCompatSource` slice shared between Rust and Node.js if buffer is used.
 *
 * It can only be used in non-async context and the lifetime is bound to the fn closure.
 *
 * If you want to use Node.js Buffer in async context or want to extend the lifetime, use `JsCompatSourceOwned` instead.
 */
export interface JsCompatSource {
  source: string | Buffer
  map?: string
}

export interface JsCompatSourceOwned {
  source: string | Buffer
  map?: string
}

export interface JsCreateData {
  request: string
  userRequest: string
  resource: string
}

export interface JsDefaultObjectRedirectWarnObject {
  ignore: boolean
}

export interface JsDiagnostic {
  message: string
  help?: string
  sourceCode?: string
  location?: JsDiagnosticLocation
  file?: string
  severity: "error" | "warning"
  moduleIdentifier?: string
}

export interface JsDiagnosticLocation {
  text?: string
  /** 1-based */
  line: number
  /** 0-based in bytes */
  column: number
  /** Length in bytes */
  length: number
}

export interface JsEntryData {
  dependencies: Array<JsDependency>
  includeDependencies: Array<JsDependency>
  options: JsEntryOptions
}

export interface JsEntryOptions {
  name?: string
  runtime?: false | string
  chunkLoading?: false | string
  asyncChunks?: boolean
  publicPath?: "auto" | JsFilename
  baseUri?: string
  filename?: JsFilename
  library?: JsLibraryOptions
  dependOn?: Array<string>
  layer?: string
}

export interface JsEntryPluginOptions {
  context: string
  entry: string
  options: JsEntryOptions
}

export interface JsExecuteModuleArg {
  entry: string
  runtimeModules: Array<string>
  codegenResults: JsCodegenerationResults
  id: number
}

export interface JsExecuteModuleResult {
  fileDependencies: Array<string>
  contextDependencies: Array<string>
  buildDependencies: Array<string>
  missingDependencies: Array<string>
  cacheable: boolean
  assets: Array<string>
  id: number
  error?: string
}

export interface JsFactorizeArgs {
  request: string
  context: string
  issuer: string
}

export interface JsFactoryMeta {
  sideEffectFree?: boolean
}

export interface JsHtmlPluginAssets {
  publicPath: string
  js: Array<string>
  css: Array<string>
  favicon?: string
}

export interface JsHtmlPluginAssetTags {
  scripts: Array<JsHtmlPluginTag>
  styles: Array<JsHtmlPluginTag>
  meta: Array<JsHtmlPluginTag>
}

export interface JsHtmlPluginTag {
  tagName: string
  attributes: Record<string, string | boolean | undefined | null>
  voidTag: boolean
  innerHTML?: string
  asset?: string
}

export interface JsLibraryAuxiliaryComment {
  root?: string
  commonjs?: string
  commonjs2?: string
  amd?: string
}

export interface JsLibraryCustomUmdObject {
  amd?: string
  commonjs?: string
  root?: Array<string> | string
}

export interface JsLibraryName {
  type: "string" | "array" | "umdObject"
  stringPayload?: string
  arrayPayload?: Array<string>
  umdObjectPayload?: JsLibraryCustomUmdObject
}

export interface JsLibraryOptions {
  name?: string | Array<string> | JsLibraryCustomUmdObject
  export?: Array<string> | string
  type: string
  umdNamedDefine?: boolean
  auxiliaryComment?: string | JsLibraryAuxiliaryComment
  amdContainer?: string
}

export interface JsLoaderContext {
  resourceData: Readonly<JsResourceData>
  /** Will be deprecated. Use module.module_identifier instead */
  _moduleIdentifier: Readonly<string>
  _module: JsModule
  hot: Readonly<boolean>
  /** Content maybe empty in pitching stage */
  content: null | Buffer
  additionalData?: any
  __internal__parseMeta: Record<string, string>
  sourceMap?: Buffer
  cacheable: boolean
  fileDependencies: Array<string>
  contextDependencies: Array<string>
  missingDependencies: Array<string>
  buildDependencies: Array<string>
  loaderItems: Array<JsLoaderItem>
  loaderIndex: number
  loaderState: Readonly<JsLoaderState>
  __internal__error?: JsRspackError
}

export interface JsLoaderItem {
  request: string
  type: string
  data: any
  normalExecuted: boolean
  pitchExecuted: boolean
}

export declare enum JsLoaderState {
  Pitching = 'Pitching',
  Normal = 'Normal'
}

export interface JsModuleDescriptor {
  identifier: string
  name: string
  id?: string
}

export interface JsNormalModuleFactoryCreateModuleArgs {
  dependencyType: string
  rawRequest: string
  resourceResolveData: JsResourceData
  context: string
  matchResource?: string
}

export interface JsOriginRecord {
  moduleDescriptor?: JsModuleDescriptor
  loc: string
  request: string
}

export interface JsPathData {
  filename?: string
  hash?: string
  contentHash?: string
  runtime?: string
  url?: string
  id?: string
  chunk?: JsPathDataChunkLike
}

export interface JsPathDataChunkLike {
  name?: string
  hash?: string
  id?: string
}

export interface JsResolveArgs {
  request: string
  context: string
  issuer: string
}

export interface JsResolveForSchemeArgs {
  resourceData: JsResourceData
  scheme: string
}

export interface JsResourceData {
  /** Resource with absolute path, query and fragment */
  resource: string
  /** Absolute resource path only */
  path?: string
  /** Resource query with `?` prefix */
  query?: string
  /** Resource fragment with `#` prefix */
  fragment?: string
}

export interface JsRspackDiagnostic {
  severity: JsRspackSeverity
  error: JsRspackError
}

export interface JsRspackError {
  name: string
  message: string
  moduleIdentifier?: string
  loc?: string
  file?: string
  stack?: string
  hideStack?: boolean
}

export declare enum JsRspackSeverity {
  Error = 'Error',
  Warn = 'Warn'
}

export interface JsRuntimeGlobals {
  value: Array<string>
}

export interface JsRuntimeModule {
  source?: JsCompatSourceOwned
  moduleIdentifier: string
  constructorName: string
  name: string
}

export interface JsRuntimeModuleArg {
  module: JsRuntimeModule
  chunk: JsChunk
}

export interface JsRuntimeRequirementInTreeArg {
  chunk: JsChunk
  runtimeRequirements: JsRuntimeGlobals
}

export interface JsRuntimeRequirementInTreeResult {
  runtimeRequirements: JsRuntimeGlobals
}

export interface JsStatsAsset {
  type: string
  name: string
  info: JsStatsAssetInfo
  size: number
  emitted: boolean
  chunkNames: Array<string>
  chunkIdHints: Array<string>
  chunks: Array<string | undefined | null>
  auxiliaryChunkNames: Array<string>
  auxiliaryChunkIdHints: Array<string>
  auxiliaryChunks: Array<string | undefined | null>
}

export interface JsStatsAssetInfo {
  minimized?: boolean
  development?: boolean
  hotModuleReplacement?: boolean
  sourceFilename?: string
  copied?: boolean
  immutable?: boolean
  javascriptModule?: boolean
  chunkhash: Array<string>
  contenthash: Array<string>
  fullhash: Array<string>
  related: Array<JsStatsAssetInfoRelated>
  isOverSizeLimit?: boolean
}

export interface JsStatsAssetInfoRelated {
  name: string
  value: Array<string>
}

export interface JsStatsAssetsByChunkName {
  name: string
  files: Array<string>
}

export interface JsStatsChildGroupChildAssets {
  preload?: Array<string>
  prefetch?: Array<string>
}

export interface JsStatsChunk {
  type: string
  files: Array<string>
  auxiliaryFiles: Array<string>
  id?: string
  idHints: Array<string>
  hash?: string
  entry: boolean
  initial: boolean
  names: Array<string>
  size: number
  parents?: Array<string>
  children?: Array<string>
  siblings?: Array<string>
  childrenByOrder: Record<string, Array<string>>
  runtime: Array<string>
  reason?: string
  rendered: boolean
  sizes: Array<JsStatsSize>
  origins: Array<JsOriginRecord>
  modules?: Array<JsStatsModule>
}

export interface JsStatsChunkGroup {
  name: string
  chunks: Array<string>
  assets: Array<JsStatsChunkGroupAsset>
  assetsSize: number
  auxiliaryAssets?: Array<JsStatsChunkGroupAsset>
  auxiliaryAssetsSize?: number
  isOverSizeLimit?: boolean
  children?: JsStatsChunkGroupChildren
  childAssets?: JsStatsChildGroupChildAssets
}

export interface JsStatsChunkGroupAsset {
  name: string
  size: number
}

export interface JsStatsChunkGroupChildren {
  preload?: Array<JsStatsChunkGroup>
  prefetch?: Array<JsStatsChunkGroup>
}

export interface JsStatsCompilation {
  assets?: Array<JsStatsAsset>
  assetsByChunkName?: Array<JsStatsAssetsByChunkName>
  chunks?: Array<JsStatsChunk>
  entrypoints?: Array<JsStatsChunkGroup>
  errors: Array<JsStatsError>
  hash?: string
  modules?: Array<JsStatsModule>
  namedChunkGroups?: Array<JsStatsChunkGroup>
  warnings: Array<JsStatsWarning>
}

export interface JsStatsError {
  moduleDescriptor?: JsModuleDescriptor
  message: string
  chunkName?: string
  chunkEntry?: boolean
  chunkInitial?: boolean
  loc?: string
  file?: string
  chunkId?: string
  details?: string
  stack?: string
  moduleTrace: Array<JsStatsModuleTrace>
}

export interface JsStatsGetAssets {
  assets: Array<JsStatsAsset>
  assetsByChunkName: Array<JsStatsAssetsByChunkName>
}

export interface JsStatsLogging {
  name: string
  type: string
  args?: Array<string>
  trace?: Array<string>
}

export interface JsStatsMillisecond {
  secs: number
  subsecMillis: number
}

export interface JsStatsModule {
  commonAttributes: JsStatsModuleCommonAttributes
  dependent?: boolean
  issuerDescriptor?: JsModuleDescriptor
  issuerPath?: Array<JsStatsModuleIssuer>
  usedExports?: string | Array<string>
  modules?: Array<JsStatsModule>
}

export interface JsStatsModuleCommonAttributes {
  type: string
  moduleType: string
  layer?: string
  size: number
  sizes: Array<JsStatsSize>
  built: boolean
  codeGenerated: boolean
  buildTimeExecuted: boolean
  cached: boolean
  moduleDescriptor?: JsModuleDescriptor
  nameForCondition?: string
  preOrderIndex?: number
  postOrderIndex?: number
  cacheable?: boolean
  optional?: boolean
  orphan?: boolean
  failed?: boolean
  errors?: number
  warnings?: number
  profile?: JsStatsModuleProfile
  chunks?: Array<string>
  assets?: Array<string>
  reasons?: Array<JsStatsModuleReason>
  providedExports?: Array<string>
  optimizationBailout?: Array<string>
  depth?: number
  source?: string | Buffer
}

export interface JsStatsModuleIssuer {
  moduleDescriptor: JsModuleDescriptor
}

export interface JsStatsModuleProfile {
  factory: JsStatsMillisecond
  building: JsStatsMillisecond
}

export interface JsStatsModuleReason {
  moduleDescriptor?: JsModuleDescriptor
  resolvedModuleDescriptor?: JsModuleDescriptor
  moduleChunks?: number
  type?: string
  userRequest?: string
}

export interface JsStatsModuleTrace {
  origin: JsStatsModuleTraceModule
  module: JsStatsModuleTraceModule
}

export interface JsStatsModuleTraceModule {
  moduleDescriptor: JsModuleDescriptor
}

export interface JsStatsOptimizationBailout {
  inner: string
}

export interface JsStatsOptions {
  assets: boolean
  cachedModules: boolean
  chunks: boolean
  chunkGroupAuxiliary: boolean
  chunkGroupChildren: boolean
  chunkGroups: boolean
  chunkModules: boolean
  chunkRelations: boolean
  depth: boolean
  entrypoints: boolean | string
  errors: boolean
  hash: boolean
  ids: boolean
  modules: boolean
  moduleAssets: boolean
  nestedModules: boolean
  optimizationBailout: boolean
  providedExports: boolean
  reasons: boolean
  source: boolean
  usedExports: boolean
  warnings: boolean
}

export interface JsStatsSize {
  sourceType: string
  size: number
}

export interface JsStatsWarning {
  moduleDescriptor?: JsModuleDescriptor
  message: string
  chunkName?: string
  chunkEntry?: boolean
  chunkInitial?: boolean
  file?: string
  chunkId?: string
  details?: string
  stack?: string
  moduleTrace: Array<JsStatsModuleTrace>
}

export interface JsTap {
  function: any
  stage: number
}

export interface NodeFsStats {
  isFile: boolean
  isDirectory: boolean
  isSymlink: boolean
  atimeMs: number
  mtimeMs: number
  ctimeMs: number
  birthtimeMs: number
  size: number
}

export interface PathWithInfo {
  path: string
  info: JsAssetInfo
}

export interface RawAliasOptionItem {
  path: string
  redirect: Array<string | false>
}

export interface RawAssetGeneratorDataUrlFnCtx {
  filename: string
  module: JsModule
}

export interface RawAssetGeneratorDataUrlOptions {
  encoding?: "base64" | "false" | undefined
  mimetype?: string
}

export interface RawAssetGeneratorOptions {
  emit?: boolean
  filename?: JsFilename
  outputPath?: JsFilename
  publicPath?: "auto" | JsFilename
  dataUrl?: RawAssetGeneratorDataUrlOptions | ((source: Buffer, context: RawAssetGeneratorDataUrlFnCtx) => string)
}

export interface RawAssetInlineGeneratorOptions {
  dataUrl?: RawAssetGeneratorDataUrlOptions | ((source: Buffer, context: RawAssetGeneratorDataUrlFnCtx) => string)
}

export interface RawAssetParserDataUrl {
  type: "options"
  options?: RawAssetParserDataUrlOptions
}

export interface RawAssetParserDataUrlOptions {
  maxSize?: number
}

export interface RawAssetParserOptions {
  dataUrlCondition?: RawAssetParserDataUrl
}

export interface RawAssetResourceGeneratorOptions {
  emit?: boolean
  filename?: JsFilename
  outputPath?: JsFilename
  publicPath?: "auto" | JsFilename
}

export interface RawBannerPluginOptions {
  banner: string | ((...args: any[]) => any)
  entryOnly?: boolean
  footer?: boolean
  raw?: boolean
  stage?: number
  test?: string | RegExp | (string | RegExp)[]
  include?: string | RegExp | (string | RegExp)[]
  exclude?: string | RegExp | (string | RegExp)[]
}

export interface RawBundlerInfoPluginOptions {
  version: string
  bundler: string
  force: boolean | string[]
}

export interface RawCacheGroupOptions {
  key: string
  priority?: number
  test?: RegExp | string | Function
  filename?: JsFilename
  idHint?: string
  /** What kind of chunks should be selected. */
  chunks?: RegExp | 'async' | 'initial' | 'all'
  type?: RegExp | string
  layer?: RegExp | string
  automaticNameDelimiter?: string
  minChunks?: number
  minSize?: number | RawSplitChunkSizes
  maxSize?: number | RawSplitChunkSizes
  maxAsyncSize?: number | RawSplitChunkSizes
  maxInitialSize?: number | RawSplitChunkSizes
  maxAsyncRequests?: number
  maxInitialRequests?: number
  name?: string | false | Function
  reuseExistingChunk?: boolean
  enforce?: boolean
  usedExports?: boolean
}

export interface RawCacheOptions {
  type: string
}

export interface RawConsumeOptions {
  key: string
  import?: string
  importResolved?: string
  shareKey: string
  shareScope: string
  requiredVersion?: string | false | undefined
  packageName?: string
  strictVersion: boolean
  singleton: boolean
  eager: boolean
}

export interface RawConsumeSharedPluginOptions {
  consumes: Array<RawConsumeOptions>
  enhanced: boolean
}

export interface RawContainerPluginOptions {
  name: string
  shareScope: string
  library: JsLibraryOptions
  runtime?: false | string
  filename?: string
  exposes: Array<RawExposeOptions>
  enhanced: boolean
}

export interface RawContainerReferencePluginOptions {
  remoteType: string
  remotes: Array<RawRemoteOptions>
  shareScope?: string
  enhanced: boolean
}

export interface RawContextReplacementPluginOptions {
  resourceRegExp: RegExp
  newContentResource?: string
  newContentRecursive?: boolean
  newContentRegExp?: RegExp
  newContentCreateContextMap?: Record<string, string>
}

export interface RawCopyGlobOptions {
  caseSensitiveMatch?: boolean
  dot?: boolean
  ignore?: Array<string>
}

export interface RawCopyPattern {
  from: string
  to?: string | ((pathData: { context: string; absoluteFilename?: string }) => string | Promise<string>)
  context?: string
  toType?: string
  noErrorOnMissing: boolean
  force: boolean
  priority: number
  globOptions: RawCopyGlobOptions
  info?: RawInfo
  transform?: (input: Buffer, absoluteFilename: string) => string | Buffer | Promise<string> | Promise<Buffer>
}

export interface RawCopyRspackPluginOptions {
  patterns: Array<RawCopyPattern>
}

export interface RawCssAutoGeneratorOptions {
  exportsConvention?: "as-is" | "camel-case" | "camel-case-only" | "dashes" | "dashes-only"
  exportsOnly?: boolean
  localIdentName?: string
  esModule?: boolean
}

export interface RawCssAutoParserOptions {
  namedExports?: boolean
}

export interface RawCssExtractPluginOption {
  filename: JsFilename
  chunkFilename: JsFilename
  ignoreOrder: boolean
  insert?: string
  attributes: Record<string, string>
  linkType?: string
  runtime: boolean
  pathinfo: boolean
}

export interface RawCssGeneratorOptions {
  exportsOnly?: boolean
  esModule?: boolean
}

export interface RawCssModuleGeneratorOptions {
  exportsConvention?: "as-is" | "camel-case" | "camel-case-only" | "dashes" | "dashes-only"
  exportsOnly?: boolean
  localIdentName?: string
  esModule?: boolean
}

export interface RawCssModuleParserOptions {
  namedExports?: boolean
}

export interface RawCssParserOptions {
  namedExports?: boolean
}

export interface RawDependency {
  request: string
}

export interface RawDllEntryPluginOptions {
  context: string
  entries: Array<string>
  name: string
}

export interface RawDllManifest {
  content: Record<string, RawDllManifestContentItem>
  name?: string
  type?: string
}

export interface RawDllManifestContentItem {
  buildMeta?: JsBuildMeta
  exports?: string[] | true
  id?: string
}

export interface RawDllReferenceAgencyPluginOptions {
  context?: string
  name?: string
  extensions: Array<string>
  scope?: string
  sourceType?: string
  type: string
  content?: Record<string, RawDllManifestContentItem>
  manifest?: RawDllManifest
}

export interface RawDraft {
  customMedia: boolean
}

export interface RawDynamicEntryPluginOptions {
  context: string
  entry: () => Promise<RawEntryDynamicResult[]>
}

export interface RawEntryDynamicResult {
  import: Array<string>
  options: JsEntryOptions
}

export interface RawEnvironment {
  const?: boolean
  arrowFunction?: boolean
  nodePrefixForCoreModules?: boolean
}

export interface RawEvalDevToolModulePluginOptions {
  namespace?: string
  moduleFilenameTemplate?: string | ((info: RawModuleFilenameTemplateFnCtx) => string)
  sourceUrlComment?: string
}

export interface RawExperimentCacheOptionsPersistent {
  buildDependencies?: Array<string>
  version?: string
  snapshot?: RawExperimentSnapshotOptions
  storage?: RawStorageOptions
}

export interface RawExperiments {
  layers: boolean
  topLevelAwait: boolean
incremental?: false | { [key: string]: boolean }
rspackFuture?: RawRspackFuture
cache: boolean | { type: "persistent" } & RawExperimentCacheOptionsPersistent | { type: "memory" }
}

export interface RawExperimentSnapshotOptions {
  immutablePaths: Array<string|RegExp>
  unmanagedPaths: Array<string|RegExp>
  managedPaths: Array<string|RegExp>
}

export interface RawExposeOptions {
  key: string
  name?: string
  import: Array<string>
}

export interface RawExternalItemFnCtxData {
  request: string
  context: string
  dependencyType: string
  contextInfo: ContextInfo
}

export interface RawExternalItemFnResult {
  externalType?: string
  result?: string | boolean | string[] | Record<string, string[]>
}

export interface RawExternalsPluginOptions {
  type: string
  externals: (string | RegExp | Record<string, string | boolean | string[] | Record<string, string[]>> | ((...args: any[]) => any))[]
}

export interface RawExternalsPresets {
  node: boolean
  web: boolean
  electron: boolean
  electronMain: boolean
  electronPreload: boolean
  electronRenderer: boolean
}

export interface RawExtractComments {
  banner?: string | boolean
  condition?: string
}

export interface RawFallbackCacheGroupOptions {
  chunks?: RegExp | 'async' | 'initial' | 'all'
  minSize?: number | RawSplitChunkSizes
  maxSize?: number | RawSplitChunkSizes
  maxAsyncSize?: number | RawSplitChunkSizes
  maxInitialSize?: number | RawSplitChunkSizes
  automaticNameDelimiter?: string
}

export interface RawFlagAllModulesAsUsedPluginOptions {
  explanation: string
}

export interface RawFuncUseCtx {
  resource?: string
  realResource?: string
  resourceQuery?: string
  issuer?: string
}

export interface RawGeneratorOptions {
  type: "asset" | "asset/inline" | "asset/resource" | "css" | "css/auto" | "css/module"
  asset?: RawAssetGeneratorOptions
  assetInline?: RawAssetInlineGeneratorOptions
  assetResource?: RawAssetResourceGeneratorOptions
  css?: RawCssGeneratorOptions
  cssAuto?: RawCssAutoGeneratorOptions
  cssModule?: RawCssModuleGeneratorOptions
}

export interface RawHtmlRspackPluginBaseOptions {
  href?: string
  target?: "_self" | "_blank" | "_parent" | "_top"
}

export interface RawHtmlRspackPluginOptions {
  /** emitted file name in output path */
  filename?: string[]
  /** template html file */
  template?: string
  templateFn?: (data: string) => Promise<string>
  templateContent?: string
  templateParameters?: boolean | Record<string, any> | ((params: string) => Promise<string>)
  /** "head", "body" or "false" */
  inject: "head" | "body" | "false"
  /** path or `auto` */
  publicPath?: string
  /** `blocking`, `defer`, `module` or `systemjs-module` */
  scriptLoading: "blocking" | "defer" | "module" | "systemjs-module"
  /** entry_chunk_name (only entry chunks are supported) */
  chunks?: Array<string>
  excludeChunks?: Array<string>
  chunksSortMode: "auto" | "manual"
  sri?: "sha256" | "sha384" | "sha512"
  minify?: boolean
  title?: string
  favicon?: string
  meta?: Record<string, Record<string, string>>
  hash?: boolean
  base?: RawHtmlRspackPluginBaseOptions
}

export interface RawHttpExternalsRspackPluginOptions {
  css: boolean
  webAsync: boolean
}

export interface RawIgnorePluginOptions {
  resourceRegExp?: RegExp
  contextRegExp?: RegExp
  checkResource?: (resource: string, context: string) => boolean
}

export interface RawIncremental {
  make: boolean
  inferAsyncModules: boolean
  providedExports: boolean
  dependenciesDiagnostics: boolean
  sideEffects: boolean
  buildChunkGraph: boolean
  moduleIds: boolean
  chunkIds: boolean
  modulesHashes: boolean
  modulesCodegen: boolean
  modulesRuntimeRequirements: boolean
  chunksRuntimeRequirements: boolean
  chunksHashes: boolean
  chunksRender: boolean
  emitAssets: boolean
}

export interface RawInfo {
  immutable?: boolean
  minimized?: boolean
  chunkHash?: Array<string>
  contentHash?: Array<string>
  development?: boolean
  hotModuleReplacement?: boolean
  related?: RawRelated
  version?: string
}

export interface RawJavascriptParserOptions {
  dynamicImportMode?: string
  dynamicImportPreload?: string
  dynamicImportPrefetch?: string
  dynamicImportFetchPriority?: string
  url?: string
  exprContextCritical?: boolean
  wrappedContextCritical?: boolean
  wrappedContextRegExp?: RegExp
  exportsPresence?: string
  importExportsPresence?: string
  reexportExportsPresence?: string
  strictExportPresence?: boolean
  worker?: Array<string>
  overrideStrict?: string
  importMeta?: boolean
  /**
   * This option is experimental in Rspack only and subject to change or be removed anytime.
   * @experimental
   */
  requireAsExpression?: boolean
  /**
   * This option is experimental in Rspack only and subject to change or be removed anytime.
   * @experimental
   */
  requireDynamic?: boolean
  /**
   * This option is experimental in Rspack only and subject to change or be removed anytime.
   * @experimental
   */
  requireResolve?: boolean
  /**
   * This option is experimental in Rspack only and subject to change or be removed anytime.
   * @experimental
   */
  importDynamic?: boolean
}

export interface RawJsonParserOptions {
  exportsDepth?: number
}

export interface RawLazyCompilationOption {
  module: ((err: Error | null, arg: RawModuleArg) => RawModuleInfo)
  test?: RawLazyCompilationTest
  entries: boolean
  imports: boolean
  cacheable: boolean
}

export interface RawLibManifestPluginOptions {
  context?: string
  entryOnly?: boolean
  name?: JsFilename
  path: JsFilename
  format?: boolean
  type?: string
}

export interface RawLightningCssBrowsers {
  android?: number
  chrome?: number
  edge?: number
  firefox?: number
  ie?: number
  ios_saf?: number
  opera?: number
  safari?: number
  samsung?: number
}

export interface RawLightningCssMinimizerOptions {
  errorRecovery: boolean
  targets?: Array<string>
  include?: number
  exclude?: number
  draft?: RawDraft
  drafts?: RawDraft
  nonStandard?: RawNonStandard
  pseudoClasses?: RawLightningCssPseudoClasses
  unusedSymbols: Array<string>
}

export interface RawLightningCssMinimizerRspackPluginOptions {
  test?: string | RegExp | (string | RegExp)[]
  include?: string | RegExp | (string | RegExp)[]
  exclude?: string | RegExp | (string | RegExp)[]
  removeUnusedLocalIdents: boolean
  minimizerOptions: RawLightningCssMinimizerOptions
}

export interface RawLightningCssPseudoClasses {
  hover?: string
  active?: string
  focus?: string
  focusVisible?: string
  focusWithin?: string
}

export interface RawLimitChunkCountPluginOptions {
  chunkOverhead?: number
  entryChunkMultiplicator?: number
  maxChunks: number
}

export interface RawModuleArg {
  module: string
  path: string
}

export interface RawModuleFilenameTemplateFnCtx {
  identifier: string
  shortIdentifier: string
  resource: string
  resourcePath: string
  absoluteResourcePath: string
  loaders: string
  allLoaders: string
  query: string
  moduleId: string
  hash: string
  namespace: string
}

export interface RawModuleInfo {
  active: boolean
  client: string
  data: string
}

export interface RawModuleOptions {
  rules: Array<RawModuleRule>
  parser?: Record<string, RawParserOptions>
  generator?: Record<string, RawGeneratorOptions>
  noParse?: string | RegExp | ((request: string) => boolean) | (string | RegExp | ((request: string) => boolean))[]
}

export interface RawModuleRule {
  /**
   * A conditional match matching an absolute path + query + fragment.
   * Note:
   *   This is a custom matching rule not initially designed by webpack.
   *   Only for single-threaded environment interoperation purpose.
   */
  rspackResource?: RawRuleSetCondition
  /** A condition matcher matching an absolute path. */
  test?: RawRuleSetCondition
  include?: RawRuleSetCondition
  exclude?: RawRuleSetCondition
  /** A condition matcher matching an absolute path. */
  resource?: RawRuleSetCondition
  /** A condition matcher against the resource query. */
  resourceQuery?: RawRuleSetCondition
  resourceFragment?: RawRuleSetCondition
  descriptionData?: Record<string, RawRuleSetCondition>
  with?: Record<string, RawRuleSetCondition>
  sideEffects?: boolean
  use?: RawModuleRuleUse[] | ((arg: RawFuncUseCtx) => RawModuleRuleUse[])
  type?: string
  layer?: string
  parser?: RawParserOptions
  generator?: RawGeneratorOptions
  resolve?: RawResolveOptions
  issuer?: RawRuleSetCondition
  issuerLayer?: RawRuleSetCondition
  dependency?: RawRuleSetCondition
  scheme?: RawRuleSetCondition
  mimetype?: RawRuleSetCondition
  oneOf?: Array<RawModuleRule>
  rules?: Array<RawModuleRule>
  /** Specifies the category of the loader. No value means normal loader. */
  enforce?: 'pre' | 'post'
}

/**
 * `loader` is for both JS and Rust loaders.
 * `options` is
 *   - a `None` on rust side and handled by js side `getOptions` when
 * using with `loader`.
 *   - a `Some(string)` on rust side, deserialized by `serde_json::from_str`
 * and passed to rust side loader in [get_builtin_loader] when using with
 * `builtin_loader`.
 */
export interface RawModuleRuleUse {
  loader: string
  options?: string
}

export interface RawNodeOption {
  dirname: string
  filename: string
  global: string
}

export interface RawNonStandard {
  deepSelectorCombinator: boolean
}

export interface RawOccurrenceChunkIdsPluginOptions {
  prioritiseInitial?: boolean
}

export interface RawOptimizationOptions {
  removeAvailableModules: boolean
  sideEffects: boolean | string
  usedExports: boolean | string
  providedExports: boolean
  innerGraph: boolean
  mangleExports: boolean | string
  concatenateModules: boolean
  avoidEntryIife: boolean
}

export interface RawOptions {
  name?: string
  mode?: undefined | 'production' | 'development' | 'none'
  context: string
  output: RawOutputOptions
  resolve: RawResolveOptions
  resolveLoader: RawResolveOptions
  module: RawModuleOptions
  optimization: RawOptimizationOptions
  stats: RawStatsOptions
  cache: RawCacheOptions
  experiments: RawExperiments
  node?: RawNodeOption
  profile: boolean
  amd?: string
  bail: boolean
  __references: Record<string, any>
}

export interface RawOutputOptions {
  path: string
  pathinfo: boolean | "verbose"
  clean: boolean | JsCleanOptions
  publicPath: "auto" | JsFilename
  assetModuleFilename: JsFilename
  wasmLoading: string | false
  enabledWasmLoadingTypes: Array<string>
  webassemblyModuleFilename: string
  filename: JsFilename
  chunkFilename: JsFilename
  crossOriginLoading: string | false
  cssFilename: JsFilename
  cssChunkFilename: JsFilename
  hotUpdateMainFilename: string
  hotUpdateChunkFilename: string
  hotUpdateGlobal: string
  uniqueName: string
  chunkLoadingGlobal: string
  library?: JsLibraryOptions
  strictModuleErrorHandling: boolean
  enabledLibraryTypes?: Array<string>
  globalObject: string
  importFunctionName: string
  importMetaName: string
  iife: boolean
  module: boolean
  chunkLoading: string | false
  chunkLoadTimeout: number
  charset: boolean
  enabledChunkLoadingTypes?: Array<string>
  trustedTypes?: RawTrustedTypes
  sourceMapFilename: string
  hashFunction: string
  hashDigest: string
  hashDigestLength: number
  hashSalt?: string
  asyncChunks: boolean
  workerChunkLoading: string | false
  workerWasmLoading: string | false
  workerPublicPath: string
  scriptType: "module" | "text/javascript" | false
  environment: RawEnvironment
  compareBeforeEmit: boolean
}

export interface RawParserOptions {
  type: "asset" | "css" | "css/auto" | "css/module" | "javascript" | "javascript/auto" | "javascript/dynamic" | "javascript/esm" | "json"
  asset?: RawAssetParserOptions
  css?: RawCssParserOptions
  cssAuto?: RawCssAutoParserOptions
  cssModule?: RawCssModuleParserOptions
  javascript?: RawJavascriptParserOptions
  json?: RawJsonParserOptions
}

export interface RawPathData {
  filename?: string
  contentHash?: string
  url?: string
}

export interface RawProgressPluginOptions {
  prefix?: string
  profile?: boolean
  template?: string
  tick?: string | Array<string>
  progressChars?: string
  handler?: (percent: number, msg: string, items: string[]) => void
}

export interface RawProvideOptions {
  key: string
  shareKey: string
  shareScope: string
  version?: string | false | undefined
  eager: boolean
  singleton?: boolean
  requiredVersion?: string | false | undefined
  strictVersion?: boolean
}

export interface RawRelated {
  sourceMap?: string
}

export interface RawRemoteOptions {
  key: string
  external: Array<string>
  shareScope: string
}

export interface RawResolveOptions {
  preferRelative?: boolean
  preferAbsolute?: boolean
  extensions?: Array<string>
  mainFiles?: Array<string>
  mainFields?: Array<string>
  conditionNames?: Array<string>
  alias?: Array<RawAliasOptionItem>
  fallback?: Array<RawAliasOptionItem>
  symlinks?: boolean
  tsconfig?: RawResolveTsconfigOptions
  modules?: Array<string>
  byDependency?: Record<string, RawResolveOptions>
  fullySpecified?: boolean
  exportsFields?: Array<string>
  descriptionFiles?: Array<string>
  enforceExtension?: boolean
  importsFields?: Array<string>
  extensionAlias?: Record<string, Array<string>>
  aliasFields?: Array<string>
  restrictions?: Array<string>
  roots?: Array<string>
}

export interface RawResolveOptionsWithDependencyType {
  preferRelative?: boolean
  preferAbsolute?: boolean
  extensions?: Array<string>
  mainFiles?: Array<string>
  mainFields?: Array<string>
  conditionNames?: Array<string>
  alias?: Array<RawAliasOptionItem>
  fallback?: Array<RawAliasOptionItem>
  symlinks?: boolean
  tsconfig?: RawResolveTsconfigOptions
  modules?: Array<string>
  byDependency?: Record<string, RawResolveOptions>
  fullySpecified?: boolean
  exportsFields?: Array<string>
  descriptionFiles?: Array<string>
  enforceExtension?: boolean
  importsFields?: Array<string>
  extensionAlias?: Record<string, Array<string>>
  aliasFields?: Array<string>
  restrictions?: Array<string>
  roots?: Array<string>
  dependencyCategory?: string
  resolveToContext?: boolean
}

export interface RawResolveTsconfigOptions {
  configFile: string
  referencesType: "auto" | "manual" | "disabled"
  references?: Array<string>
}

export interface RawRspackFuture {

}

export interface RawRuleSetCondition {
  type: RawRuleSetConditionType
  string?: string
  regexp?: RegExp
  logical?: Array<RawRuleSetLogicalConditions>
  array?: Array<RawRuleSetCondition>
  func?: (value: string) => boolean
}

export declare enum RawRuleSetConditionType {
  string = 'string',
  regexp = 'regexp',
  logical = 'logical',
  array = 'array',
  func = 'func'
}

export interface RawRuleSetLogicalConditions {
  and?: Array<RawRuleSetCondition>
  or?: Array<RawRuleSetCondition>
  not?: RawRuleSetCondition
}

export interface RawRuntimeChunkNameFnCtx {
  name: string
}

export interface RawRuntimeChunkOptions {
  name: string | ((entrypoint: { name: string }) => string)
}

export interface RawSizeLimitsPluginOptions {
  assetFilter?: (assetFilename: string) => boolean
  hints?: "error" | "warning"
  maxAssetSize?: number
  maxEntrypointSize?: number
}

export interface RawSourceMapDevToolPluginOptions {
  append?: (false | null) | string | Function
  columns?: boolean
  fallbackModuleFilenameTemplate?: string | ((info: RawModuleFilenameTemplateFnCtx) => string)
  fileContext?: string
  filename?: (false | null) | string
  module?: boolean
  moduleFilenameTemplate?: string | ((info: RawModuleFilenameTemplateFnCtx) => string)
  namespace?: string
  noSources?: boolean
  publicPath?: string
  sourceRoot?: string
  test?: string | RegExp | (string | RegExp)[]
  include?: string | RegExp | (string | RegExp)[]
  exclude?: string | RegExp | (string | RegExp)[]
}

export interface RawSplitChunkSizes {
  sizes: Record<string, number>
}

export interface RawSplitChunksOptions {
  fallbackCacheGroup?: RawFallbackCacheGroupOptions
  name?: string | false | Function
  cacheGroups?: Array<RawCacheGroupOptions>
  /** What kind of chunks should be selected. */
  chunks?: RegExp | 'async' | 'initial' | 'all' | Function
  usedExports?: boolean
  automaticNameDelimiter?: string
  maxAsyncRequests?: number
  maxInitialRequests?: number
  defaultSizeTypes: Array<string>
  minChunks?: number
  hidePathInfo?: boolean
  minSize?: number | RawSplitChunkSizes
  enforceSizeThreshold?: number
  minRemainingSize?: number | RawSplitChunkSizes
  maxSize?: number | RawSplitChunkSizes
  maxAsyncSize?: number | RawSplitChunkSizes
  maxInitialSize?: number | RawSplitChunkSizes
}

export interface RawStatsOptions {
  colors: boolean
}

export interface RawStorageOptions {
  type: "filesystem"
  directory: string
}

export interface RawSwcJsMinimizerOptions {
  compress: any
  mangle: any
  format: any
  module?: boolean
  minify?: boolean
}

export interface RawSwcJsMinimizerRspackPluginOptions {
  test?: string | RegExp | (string | RegExp)[]
  include?: string | RegExp | (string | RegExp)[]
  exclude?: string | RegExp | (string | RegExp)[]
  extractComments?: RawExtractComments
  minimizerOptions: RawSwcJsMinimizerOptions
}

export interface RawToOptions {
  context: string
  absoluteFilename: string
}

export interface RawTrustedTypes {
  policyName?: string
  onPolicyCreationFailure?: string
}

/**
 * Some code is modified based on
 * https://github.com/swc-project/swc/blob/d1d0607158ab40463d1b123fed52cc526eba8385/bindings/binding_core_node/src/util.rs#L29-L58
 * Apache-2.0 licensed
 * Author Donny/강동윤
 * Copyright (c)
 */
export declare function registerGlobalTrace(filter: string, layer: "chrome" | "logger", output: string): void

export declare enum RegisterJsTapKind {
  CompilerThisCompilation = 0,
  CompilerCompilation = 1,
  CompilerMake = 2,
  CompilerFinishMake = 3,
  CompilerShouldEmit = 4,
  CompilerEmit = 5,
  CompilerAfterEmit = 6,
  CompilerAssetEmitted = 7,
  CompilationBuildModule = 8,
  CompilationStillValidModule = 9,
  CompilationSucceedModule = 10,
  CompilationExecuteModule = 11,
  CompilationFinishModules = 12,
  CompilationOptimizeModules = 13,
  CompilationAfterOptimizeModules = 14,
  CompilationOptimizeTree = 15,
  CompilationOptimizeChunkModules = 16,
  CompilationAdditionalTreeRuntimeRequirements = 17,
  CompilationRuntimeRequirementInTree = 18,
  CompilationRuntimeModule = 19,
  CompilationChunkHash = 20,
  CompilationChunkAsset = 21,
  CompilationProcessAssets = 22,
  CompilationAfterProcessAssets = 23,
  CompilationSeal = 24,
  CompilationAfterSeal = 25,
  NormalModuleFactoryBeforeResolve = 26,
  NormalModuleFactoryFactorize = 27,
  NormalModuleFactoryResolve = 28,
  NormalModuleFactoryAfterResolve = 29,
  NormalModuleFactoryCreateModule = 30,
  NormalModuleFactoryResolveForScheme = 31,
  ContextModuleFactoryBeforeResolve = 32,
  ContextModuleFactoryAfterResolve = 33,
  JavascriptModulesChunkHash = 34,
  HtmlPluginBeforeAssetTagGeneration = 35,
  HtmlPluginAlterAssetTags = 36,
  HtmlPluginAlterAssetTagGroups = 37,
  HtmlPluginAfterTemplateExecution = 38,
  HtmlPluginBeforeEmit = 39,
  HtmlPluginAfterEmit = 40
}

export interface RegisterJsTaps {
  registerCompilerThisCompilationTaps: (stages: Array<number>) => Array<{ function: ((arg: JsCompilation) => void); stage: number; }>
  registerCompilerCompilationTaps: (stages: Array<number>) => Array<{ function: ((arg: JsCompilation) => void); stage: number; }>
  registerCompilerMakeTaps: (stages: Array<number>) => Array<{ function: ((arg: JsCompilation) => Promise<void>); stage: number; }>
  registerCompilerFinishMakeTaps: (stages: Array<number>) => Array<{ function: ((arg: JsCompilation) => void); stage: number; }>
  registerCompilerShouldEmitTaps: (stages: Array<number>) => Array<{ function: ((arg: JsCompilation) => boolean | undefined); stage: number; }>
  registerCompilerEmitTaps: (stages: Array<number>) => Array<{ function: (() => Promise<void>); stage: number; }>
  registerCompilerAfterEmitTaps: (stages: Array<number>) => Array<{ function: (() => Promise<void>); stage: number; }>
  registerCompilerAssetEmittedTaps: (stages: Array<number>) => Array<{ function: ((arg: JsAssetEmittedArgs) => Promise<void>); stage: number; }>
  registerCompilationBuildModuleTaps: (stages: Array<number>) => Array<{ function: ((arg: JsModule) => void); stage: number; }>
  registerCompilationStillValidModuleTaps: (stages: Array<number>) => Array<{ function: ((arg: JsModule) => void); stage: number; }>
  registerCompilationSucceedModuleTaps: (stages: Array<number>) => Array<{ function: ((arg: JsModule) => void); stage: number; }>
  registerCompilationExecuteModuleTaps: (stages: Array<number>) => Array<{ function: ((arg: JsExecuteModuleArg) => void); stage: number; }>
  registerCompilationAdditionalTreeRuntimeRequirements: (stages: Array<number>) => Array<{ function: ((arg: JsAdditionalTreeRuntimeRequirementsArg) => JsAdditionalTreeRuntimeRequirementsResult | undefined); stage: number; }>
  registerCompilationRuntimeRequirementInTree: (stages: Array<number>) => Array<{ function: ((arg: JsRuntimeRequirementInTreeArg) => JsRuntimeRequirementInTreeResult | undefined); stage: number; }>
  registerCompilationRuntimeModuleTaps: (stages: Array<number>) => Array<{ function: ((arg: JsRuntimeModuleArg) => JsRuntimeModule | undefined); stage: number; }>
  registerCompilationFinishModulesTaps: (stages: Array<number>) => Array<{ function: ((arg: JsCompilation) => Promise<void>); stage: number; }>
  registerCompilationOptimizeModulesTaps: (stages: Array<number>) => Array<{ function: (() => boolean | undefined); stage: number; }>
  registerCompilationAfterOptimizeModulesTaps: (stages: Array<number>) => Array<{ function: (() => void); stage: number; }>
  registerCompilationOptimizeTreeTaps: (stages: Array<number>) => Array<{ function: (() => Promise<void>); stage: number; }>
  registerCompilationOptimizeChunkModulesTaps: (stages: Array<number>) => Array<{ function: (() => Promise<boolean | undefined>); stage: number; }>
  registerCompilationChunkHashTaps: (stages: Array<number>) => Array<{ function: ((arg: JsChunk) => Buffer); stage: number; }>
  registerCompilationChunkAssetTaps: (stages: Array<number>) => Array<{ function: ((arg: JsChunkAssetArgs) => void); stage: number; }>
  registerCompilationProcessAssetsTaps: (stages: Array<number>) => Array<{ function: ((arg: JsCompilation) => Promise<void>); stage: number; }>
  registerCompilationAfterProcessAssetsTaps: (stages: Array<number>) => Array<{ function: ((arg: JsCompilation) => void); stage: number; }>
  registerCompilationSealTaps: (stages: Array<number>) => Array<{ function: (() => void); stage: number; }>
  registerCompilationAfterSealTaps: (stages: Array<number>) => Array<{ function: (() => Promise<void>); stage: number; }>
  registerNormalModuleFactoryBeforeResolveTaps: (stages: Array<number>) => Array<{ function: ((arg: JsBeforeResolveArgs) => Promise<[boolean | undefined, JsBeforeResolveArgs]>); stage: number; }>
  registerNormalModuleFactoryFactorizeTaps: (stages: Array<number>) => Array<{ function: ((arg: JsFactorizeArgs) => Promise<JsFactorizeArgs>); stage: number; }>
  registerNormalModuleFactoryResolveTaps: (stages: Array<number>) => Array<{ function: ((arg: JsResolveArgs) => Promise<JsResolveArgs>); stage: number; }>
  registerNormalModuleFactoryResolveForSchemeTaps: (stages: Array<number>) => Array<{ function: ((arg: JsResolveForSchemeArgs) => Promise<[boolean | undefined, JsResolveForSchemeArgs]>); stage: number; }>
  registerNormalModuleFactoryAfterResolveTaps: (stages: Array<number>) => Array<{ function: ((arg: JsAfterResolveData) => Promise<[boolean | undefined, JsCreateData | undefined]>); stage: number; }>
  registerNormalModuleFactoryCreateModuleTaps: (stages: Array<number>) => Array<{ function: ((arg: JsNormalModuleFactoryCreateModuleArgs) => Promise<void>); stage: number; }>
  registerContextModuleFactoryBeforeResolveTaps: (stages: Array<number>) => Array<{ function: ((arg: false | JsContextModuleFactoryBeforeResolveData) => Promise<false | JsContextModuleFactoryBeforeResolveData>); stage: number; }>
  registerContextModuleFactoryAfterResolveTaps: (stages: Array<number>) => Array<{ function: ((arg: false | JsContextModuleFactoryAfterResolveData) => Promise<false | JsContextModuleFactoryAfterResolveData>); stage: number; }>
  registerJavascriptModulesChunkHashTaps: (stages: Array<number>) => Array<{ function: ((arg: JsChunk) => Buffer); stage: number; }>
  registerHtmlPluginBeforeAssetTagGenerationTaps: (stages: Array<number>) => Array<{ function: ((arg: JsBeforeAssetTagGenerationData) => JsBeforeAssetTagGenerationData); stage: number; }>
  registerHtmlPluginAlterAssetTagsTaps: (stages: Array<number>) => Array<{ function: ((arg: JsAlterAssetTagsData) => JsAlterAssetTagsData); stage: number; }>
  registerHtmlPluginAlterAssetTagGroupsTaps: (stages: Array<number>) => Array<{ function: ((arg: JsAlterAssetTagGroupsData) => JsAlterAssetTagGroupsData); stage: number; }>
  registerHtmlPluginAfterTemplateExecutionTaps: (stages: Array<number>) => Array<{ function: ((arg: JsAfterTemplateExecutionData) => JsAfterTemplateExecutionData); stage: number; }>
  registerHtmlPluginBeforeEmitTaps: (stages: Array<number>) => Array<{ function: ((arg: JsBeforeEmitData) => JsBeforeEmitData); stage: number; }>
  registerHtmlPluginAfterEmitTaps: (stages: Array<number>) => Array<{ function: ((arg: JsAfterEmitData) => JsAfterEmitData); stage: number; }>
}

export interface ThreadsafeNodeFS {
  writeFile: (name: string, content: Buffer) => Promise<void>
  removeFile: (name: string) => Promise<void>
  mkdir: (name: string) => Promise<void>
  mkdirp: (name: string) => Promise<string | void>
  removeDirAll: (name: string) => Promise<string | void>
  readDir: (name: string) => Promise<string[] | void>
  readFile: (name: string) => Promise<Buffer | string | void>
  stat: (name: string) => Promise<NodeFsStats | void>
  lstat: (name: string) => Promise<NodeFsStats | void>
  open: (name: string, flags: string) => Promise<number | void>
  rename: (from: string, to: string) => Promise<void>
  close: (fd: number) => Promise<void>
  write: (fd: number, content: Buffer, position: number) => Promise<number | void>
  writeAll: (fd: number, content: Buffer) => Promise<number | void>
  read: (fd: number, length: number, position: number) => Promise<Buffer | void>
  readUntil: (fd: number, code: number, position: number) => Promise<Buffer | void>
  readToEnd: (fd: number, position: number) => Promise<Buffer | void>
}
