import path from 'path';
import { fs } from '@modern-js/utils';
import { initBeforeTest, runCli } from '../../utils';

initBeforeTest();

describe('autoExternal usage', () => {
  const fixtureDir = __dirname;
  it('build success', async () => {
    const configFile = path.join(fixtureDir, './config.ts');
    const { success } = await runCli({
      argv: ['build'],
      configFile,
      appDirectory: fixtureDir,
    });
    expect(success).toBeTruthy();
  });

  it('autoExternal is false', async () => {
    const distFilePath = path.join(fixtureDir, './dist/1/index.js');
    const content = await fs.readFile(distFilePath, 'utf-8');
    expect(await fs.pathExists(distFilePath)).toBeTruthy();
    expect(content.includes(`require("react")`)).toBeFalsy();
    expect(content.includes(`require("postcss")`)).toBeFalsy();
    expect(content.includes(`require("path-browserify")`)).toBeFalsy();
  });

  it('autoExternal is false with externals', async () => {
    const distFilePath = path.join(fixtureDir, './dist/2/index.js');
    const content = await fs.readFile(distFilePath, 'utf-8');
    expect(await fs.pathExists(distFilePath)).toBeTruthy();
    expect(content.includes(`require("postcss")`)).toBeFalsy();
    expect(content.includes(`require("path-browserify")`)).toBeFalsy();
  });

  it('autoExternal: { dependencies: true }', async () => {
    const distFilePath = path.join(fixtureDir, './dist/3/index.js');
    const content = await fs.readFile(distFilePath, 'utf-8');
    expect(await fs.pathExists(distFilePath)).toBeTruthy();
    expect(content.includes(`require("react")`)).toBeFalsy();
    expect(content.includes(`require("postcss")`)).toBeFalsy();
    expect(content.includes(`require("path-browserify")`)).toBeTruthy();
  });

  it('autoExternal: { peerDependencies: true }', async () => {
    const distFilePath = path.join(fixtureDir, './dist/5/index.js');
    const content = await fs.readFile(distFilePath, 'utf-8');
    expect(await fs.pathExists(distFilePath)).toBeTruthy();
    expect(content.includes(`require("react")`)).toBeFalsy();
    expect(content.includes(`require("postcss")`)).toBeTruthy();
    expect(content.includes(`require("path-browserify")`)).toBeFalsy();
  });

  it('autoExternal is false, and format is umd', async () => {
    const distFilePath = path.join(fixtureDir, './dist/6/umd.js');
    const content = await fs.readFile(distFilePath, 'utf-8');
    expect(await fs.pathExists(distFilePath)).toBeTruthy();
    expect(content.includes(`function(global, factory)`)).toBeTruthy();
  });
});
