import { getLocaleLanguage } from '@modern-js/plugin-i18n/language-detector';
import { Command } from 'commander';
import { cleanCacheAction } from './cleanCacheAction';
import { createAction } from './createAction';
import { i18n, localeKeys } from './locale';

export default function () {
  // initial cli language
  i18n.changeLanguage({ locale: getLocaleLanguage() });

  const program = new Command();

  program
    .command('clean-cache')
    .description(i18n.t(localeKeys.command.cleanCache))
    .action(cleanCacheAction);

  program
    .usage('[projectDir]')
    .description(i18n.t(localeKeys.command.description))
    .argument('[projectDir]')
    .option('--version', i18n.t(localeKeys.command.version))
    .option('--lang <lang>', i18n.t(localeKeys.command.lang))
    .option('-c, --config <config>', i18n.t(localeKeys.command.config), '{}')
    .option('-d,--debug', i18n.t(localeKeys.command.debug), false)
    .option('--dist-tag <distTag>', i18n.t(localeKeys.command.distTag), '')
    .option('--packages <packages>', i18n.t(localeKeys.command.packages), '{}')
    .option('--registry <registry>', i18n.t(localeKeys.command.registry), '')
    .option('--no-need-install', i18n.t(localeKeys.command.noNeedInstall))
    .option('--time', i18n.t(localeKeys.command.time), false)
    .action(createAction);

  program.parse(process.argv);
}
