import type { PluginAPI } from '@modern-js/core';
import type { Command } from '@modern-js/utils';
import { deploy } from '../commands';
import type { IDeployCommandOption } from '../commands';
import type { MonorepoTools } from '../type';

export const deployCli = (program: Command, api: PluginAPI<MonorepoTools>) => {
  program
    .command('deploy [project...]')
    .usage('[options]')
    .option(
      '-p, --path [path]',
      'Specify the path of the output files',
      'output',
    )
    .description('deploy project')
    .action(
      async (deployProjectNames: string[], option: IDeployCommandOption) => {
        // 在查找 workspace 下项目时，默认忽略 output 下面的项目
        const ignoreMatchs = ['**/output/**'];
        await deploy(api, deployProjectNames, option, ignoreMatchs);
      },
    );
};
