import path from 'path';
import { cli } from '@modern-js/core';
import { version } from '../package.json';

export type { CliPlugin } from '../src';

export const runCli = async (options: {
  argv: string[];
  configFile: string;
  appDirectory?: string;
  addonPlugins: Record<string, any>;
}) => {
  const plugins: Record<string, any> = {
    '@modern-js/app-tools': {
      path: path.join(__dirname, '../src/old'),
      forced: true,
    } as any,
    ...(options.addonPlugins || {}),
  };

  try {
    await cli.test(
      ['node', path.join(__dirname, '../bin/modern.js'), ...options.argv],
      {
        coreOptions: {
          cwd: options.appDirectory,
          version,
          configFile: options.configFile,
          internalPlugins: {
            cli: plugins,
          },
          forceAutoLoadPlugins: true,
        },
        disableWatcher: true,
      },
    );
    return { code: 0, success: true, error: null };
  } catch (e) {
    console.error(e);
    return { code: 1, success: false, error: e as Error };
  }
};

export const initBeforeTest = () => {
  // @ts-expect-error
  global.setImmediate = setTimeout;
  // @ts-expect-error
  global.clearImmediate = clearTimeout;
  jest.setTimeout(50000);
};
