export type UnwrapBuilderConfig<
  Config,
  Key extends keyof Config,
> = Required<Config>[Key];

export type Bundler = 'rspack' | 'webpack' | 'shared';

export type FromConfig<
  B extends Bundler,
  Config extends {
    rspack: Rspack;
    webpack: Webpack;
    shared: Shared;
  },
  Rspack = {},
  Webpack = {},
  Shared = {},
> = B extends 'shared'
  ? Config['shared']
  : B extends 'rspack'
    ? Config['rspack']
    : Config['webpack'];
