import path from 'path';
import { API_DIR, ApiRouter } from '@modern-js/bff-core';
import {
  PluginManager,
  type ServerPlugin,
  createContext,
} from '@modern-js/server-core';

export function createPluginManager() {
  const appContext = createContext<any>({});

  const pluginManager = new PluginManager({
    cliConfig: {
      dev: {},
      output: {},
      source: {},
      tools: {},
      server: {},
      html: {},
      runtime: {},
      bff: {},
      security: {},
    },
    appContext,
  });

  return pluginManager;
}

export const APIPlugin: ServerPlugin = {
  name: 'api-plugin',

  setup(api) {
    return {
      async prepareApiServer(props, next) {
        const { pwd, prefix, httpMethodDecider } = props;
        const apiDir = path.resolve(pwd, API_DIR);
        const appContext = api.useAppContext();
        const apiRouter = new ApiRouter({
          appDir: pwd,
          apiDir,
          prefix,
          httpMethodDecider,
        });
        const apiMode = apiRouter.getApiMode();
        const apiHandlerInfos = await apiRouter.getApiHandlers();
        const middleware = props.config?.middleware;

        api.setAppContext({
          ...appContext,
          apiMiddlewares: middleware,
          apiRouter,
          apiHandlerInfos,
          apiMode,
        });

        return next(props);
      },
    };
  },
};
