import path from 'path';
import { compiler } from '@modern-js/babel-compiler';
import type { PluginAPI } from '@modern-js/core';
import { runTest } from '../base';
import type { UserConfig } from '../base/config';
import type { Hooks } from '../base/hook';

const test = async (
  api: PluginAPI<{
    hooks: Hooks;
    userConfig: UserConfig;
    normalizedConfig: Required<UserConfig>;
  }>,
) => {
  const userConfig = api.useResolvedConfigContext();
  const appContext = api.useAppContext();

  const runner = api.useHookRunners();

  const { plugins = [] } =
    (await (runner as any)._internalServerPlugins?.({
      plugins: [],
    })) || {};

  // filter plugins by metaName
  const filtedPlugins = plugins?.filter((plugin: any) =>
    plugin.name.includes(appContext.metaName || 'modern-js'),
  );

  api.setAppContext({
    ...api.useAppContext(),
    serverPlugins: filtedPlugins,
  });

  userConfig.testing = userConfig.testing || {};

  const jest = userConfig.testing.jest || userConfig?.tools?.jest;

  if (Array.isArray(jest)) {
    userConfig.testing.jest = jest[0];
  }

  userConfig.testing.jest = userConfig.testing.jest || userConfig?.tools?.jest;

  const runtimeExportsPath = path.join(
    appContext.internalDirectory,
    '.runtime-exports',
  );

  await compiler(
    {
      sourceDir: runtimeExportsPath,
      rootDir: runtimeExportsPath,
      distDir: runtimeExportsPath,
      quiet: true,
    },
    {
      presets: [
        [
          require.resolve('@babel/preset-env'),
          {
            modules: 'cjs',
          },
        ],
      ],
    },
  );

  await runTest(api, userConfig.testing);
};

export default test;
