---
sidebar_position: 2
---

# 为什么需要 Modern.js Module

大家可能都经历过：从零开始开发一个组件库或者工具库的过程中，我们不仅要考虑项目本身的代码逻辑如何编写，还要考虑项目的构建、调试、测试、代码格式化等等和代码逻辑无关的事情。

比如说，当我们考虑构建模块项目的代码是使用什么构建工具的时候，在之前我们可能会考虑使用 [webpack](https://webpack.js.org/) 还是 [Rollup](https://rollupjs.org/guide/en/)，然而现在的话，也许还会考虑是使用 [esbuild](https://esbuild.github.io/) 还是 [SWC](https://swc.rs/)。

无论选择哪个构建工具，这对于没有熟练掌握这些构建工具使用方式的开发者来说，是需要一定的成本去学习的。即使想要快速使用，也会需要花费大量的时间和精力。

而除了构建这件事情以外，像为项目提供调试工具、支持测试能力、增加代码格式校验等等，对于一个新手来说都有可能需要花费很长的时间和精力了解或者掌握它们，并且真正的服务于当前的项目中。

而为了保证代码质量以及项目的完整性，我们往往是需要做这些与代码逻辑实现无关的事情。然而这些事情很有可能会影响整体的项目开发进度，降低开发者的开发体验，会让开发者感觉模块项目的开发门槛很高。

如果说每次开发一个模块类型的项目都需要经历一遍这些工作准备的话，那么基本上刚开始开发的时间会大部分花费在这些与代码实现无关的事情上。如果能够提供一个模块工程解决方案，它能够帮助开发者解决项目工程上的事情，让开发者可以更专注于代码的实现上，那么这将会大大提升模块类型项目的开发体验。

![没有使用工程方案对比使用工程方案](https://lf3-static.bytednsdoc.com/obj/eden-cn/uhbfnupenuhf/module-tools/why-module-solution.png)

Modern.js 为了让开发模块类型的项目更简单、解决上述提到的问题，提供了模块工程解决方案，并且通过 Modern.js Module 提供了主要的功能。**Modern.js Module 可以理解为是一个专门用于模块类型项目开发的工具**。
