---
sidebar_position: 2
---

# CLI Commands

CLI Commands available for Modern.js Module projects are as follows:

## `modern build`

```bash
Usage: modern build [options]

Build module command

Options:
  -w, --watch Enable watch mode to listen for changes on the fs and automatically rebuild
  --tsconfig [tsconfig] Specify the path to the tsconfig.json file (default:
                         ". /tsconfig.json")
  --platform [platform] Build artifacts for all or specified platforms
  --no-dts disables DTS type file generation and type checking
  --no-clear disables automatic clearing of output directories
  -c, --config <config>  Specify the path to the config file (default: "modern.config.j(t)s")
  -h, --help Show information about the current command
```

Modern.js Module supports the `platform` build mode, which can be used to execute build tasks of other tools. Currently, the official support includes [Rspress](https://rspress.dev/). For example, you can start the doc build task to generate doc products by executing the `modern build --platform` commands.

## `modern new`

```bash
Usage: modern new [options]

Execute the generator in a modular project scenario

Options:
  -d, --debug Enable Debug mode, print debug log messages (default: false)
  -c, --config <config> Generators run default configuration (JSON string)
  --dist-tag <tag> Generator uses a special version of npm Tag
  --registry customize npm Registry during generator runtime
  -h, --help display help for command
```

The `modern new` command is used to start the microgenerator functionality, which enables features for the project that are not provided by default.

The following features can currently be enabled.

- Storybook V7
- Tailwind CSS support

You can learn more about these features in the [Using the micro generator](/guide/basic/use-micro-generator) section.

## `modern dev`

```bash
Usage: modern dev [options]

Local development commands

Options:
  -h, --help display help for command

Commands:
[dev-tools-subCommand]
```

The Modern.js Module provides the ability to use debugging tools, which can be started with the `modern dev` command. Note, however, that no debugging-related plugins are provided by default, so executing `modern dev` will prompt: _"No dev tools found available "_.

The officially supported debugging tool is [Rspress](https://rspress.dev/), so you can run `modern dev` or `modern dev doc` to execute it after you run `modern new` to enable it.

## `modern change`

```bash
Usage: modern change [options]

Create a changeset

Options:
  --empty Create an empty changeset (default: false)
  --open Open the created changeset in the editor (default: false)
  -h, --help display help for command
```

The `modern change` command is used to generate the required Markdown file for [changesets](https://github.com/changesets/changesets).

## `modern pre`

```bash
Usage: modern pre [options] <enter|exit> [tag]

Entering and exiting pre-publishing mode

Options:
  -h, --help display help for command
```

You can use the `modern pre` command to [pre-release](https://github.com/atlassian/changesets/blob/main/docs/prereleases.md) a version before the official release.

## `modern bump`

```bash
Usage: modern bump [options]

Use changesets to automatically update releases and changelogs

Options:
  --canary Create a pre-release for testing (default: false)
  --preid <tag> Specify an identifier when versioning a pre-release (default: "next")
  --snapshot Create a special version for testing (default: false)
  -h, --help display help for command
```

Modify the version number in `package.json` according to the Markdown file of the changelog generated by [changesets](https://github.com/changesets/changesets), and generate the `CHANGELOG.md` file.

## `modern release`

```bash
Usage: modern release [options]

Release npm packages

Options:
  --tag <tag> Release npm packages with a specific tag (default: "")
  --ignore-scripts release ignores the scripts command in package.json, only supported in pnpm monorepo
                    (default: "")
  -h, --help display help for command
```

The `-modern release` command releases the module to the [npm Registry](https://www.npmjs.com/).

- The `-tag` argument specifies the specific [dist tags](https://docs.npmjs.com/adding-dist-tags-to-packages) to be used for the release.

## `modern gen-release-note`

```bash
Usage: modern gen-release-note [options]

Generate Release Note based on current repository changeset information

Options:
  --repo <repo> The name of the repository to generate the Pull Request link, e.g.: web-infra-dev/modern.js
  --custom <cumtom> Custom Release Note generation function
  -h, --help display help for command
```

Automatically generate [Release Note](https://en.wikipedia.org/wiki/Release_notes) based on the changeset information of the current repository.

:::tip
needs to be executed before the `bump` command.
:::

## `modern upgrade`

```bash
Usage: modern upgrade [options]

Upgrade Modern.js to the latest version

Options:
  --registry <registry> customize npm registry (default: "")
  -d,--debug Enable Debug mode to print debug log messages (default: false)
  --cwd <cwd> project path (default: "")
  -h, --help display help for command
```

The `modern upgrade` command is used to upgrade the project Modern.js related dependencies to the latest version.

Executing the command `npx modern upgrade` in the project root directory will update the Modern.js dependencies in `package.json` of the currently executing project to the latest version by default.
