---
sidebar_position: 98
---

# 2022 年 9 ~ 10 月更新内容

> 发表于 2022.11.01

Modern.js 9 ~ 10 月的最新版本为 v1.21.0，本双月的主要更新有：

- **支持 pnpm v7**：完成框架对 pnpm v7 的支持。
- **服务端增加 Typescript 作为 ts 文件编译器**。

## 支持 pnpm v7

Modern.js 框架完成了对 pnpm v7 的变更适配。

使用 `npx @modern-js/create@modern-1` 创建项目时会根据用户当前环境的 pnpm 版本进行安装依赖操作，并且在初始化项目中会在 `.npmrc` 中添加
`strict-peer-dependencies=false` 配置，避免安装时由于 `peerDependencies` 缺失导致安装依赖失败问题。
同时适配 `release`、`deploy` 命令对 pnpm v7 的支持。

pnpm v7 在命令传参方面姿势发生了变化，需注意：

在使用 pnpm 调用 `package.json` 中的命令时，如果需要传递参数至 pnpm，需要将参数放到命令前。

例如使用 pnpm `--filter` 参数执行 prepare 命令：

```bash
pnpm run --filter "./packages/**" prepare
```

如果需要传递参数至命令，需要将参数放到命令后。

例如，在如下 `package.json` 配置中：

```json
{
  "scripts": {
    "command": "modern command"
  }
}
```

执行 command 命令时携带参数方式为：

```bash
pnpm run command --options
```

## 服务端增加 Typescript 作为 ts 文件编译器

在 Modernjs 之前的版本中，我们为了保证前后端编译器的统一，使用了 Babel 作为前后端默认的编译器，并保持相同的编译逻辑，但随着使用的项目增多，我们发现在一些服务端常用的语法场景下，Babel 编译 ts 有一些问题。

因此，我们将服务端编译 ts 的编译器由 Babel 改为了 Typescript，在别名解析逻辑上与 Babel 版本保持一致，同样支持使用 `tsconfig.json` 或者插件设置别名。

在执行 build 命令时，已默认使用 Typescript 编译，并默认开启了类型校验，很多项目在 9、10 双月已经在使用。

执行 dev 命令时，如果希望使用 Typescript 编译，需要安装 `ts-node`，`tsconfig-paths` 到 `devDependencies`，否则默认仍然使用 Babel 编译。在 Modern.js 2.0 中，我们将使用 ts-node 作为默认的编译器。

## 其他更新

### 配置更新

- 支持在 `tools.webpackChain` 中获取 `HtmlWebpackPlugin` 对象，使用方式请参考[文档](https://modernjs.dev/v1/docs/apis/app/config/tools/webpack-chain#htmlwebpackplugin)。

### 底层依赖升级

- husky 升级至 v8

使用 `npx @modern-js/create@modern-1` 创建项目时，husky 会默认安装 v8 版本，并移除 `package.json` 中 husky 的配置，使用 `.husky` 文件夹的形式管理 husky 配置。

在初次安装依赖时需要执行 `npx husky install` 进行 husky 初始化，默认项目会在 prepare 命令中完成，如果 husky 配置未生效，可通过手动执行完成 husky 配置。

## 功能预告

Modern.js 团队目前除了正常开发维护 Modern 1.0 外，正在全力打造 Modern.js 2.0。

Modern.js 2.0 将带来新的构建体系，除了支持使用稳定的 webpack 进行构建，还即将支持将底层构建工具切换为自研的 Rust bundler，提供更流畅的编译速度。

Modern.js 2.0 将基于 [React-Router v6](https://reactrouter.com) 推荐嵌套路由作为新的路由方式；将默认支持 React 18 并提供 Streaming SSR 的支持，使用户体验更加流畅。
