---
sidebar_position: 99
---

# 2022 年 7 ~ 8 月更新内容

> 发表于 2022.09.05

Modern.js 7 ~ 8 月的最新版本为 v1.17.0，本双月的主要更新有：

- **支持 React 18**：完成框架和插件对 React 18 的适配。
- **包版本统一**：Modern.js 所有组成包的版本号进行统一，提供升级命令。
- **Modern.js Module 支持 bundle 构建**：Modern.js Module 项目，支持对产物做 bundle 构建。
- **Reduck v1.1**：发布 Reduck v1.1，使用文档全面更新。

## 支持 React 18

Modern.js 框架和相关插件完成对 React 18 的适配。现在，只需要将项目中的 `react`、`react-dom` 两个包的版本，升级到最新的 React 18 大版本，就可以使用 React 18 的新功能。

注意，使用 `@modern-js/create` 命令默认创建的项目，安装的依赖 `react`、`react-dom` 的版本仍然为 17，如果希望使用 React 18，请手动升级这两个包的版本。

另外，SSR 流式渲染功能，目前尚在开发中，暂不支持。

## Modern.js 包版本统一

之前，组成 Modern.js 的各个包的版本号并不统一，Modern.js 自身的版本和这些包的版本缺少明确的对应关系。这不仅增加了我们的维护成本，而且给用户的使用和升级带来了很多困扰。

从 v1.15.0 版本开始，Modern.js 自身的版本号和所有组成包的版本号，进行了统一。例如，Modern.js v1.15.0，意味着所有组成包的版本号也是 v1.15.0。 每次发布新版本，Modern.js 所有包都会使用统一的版本号执行发布。 Github 上仓库的 [tag](https://github.com/modern-js-dev/modern.js/tags) 编号和 Modern.js 所有组成包的版本号是一一对应的。

我们提供了专门的升级工具： `@modern-js/upgrade`，可以自动升级 Modern.js 到当前的最新版本。使用方式为，在项目根路径下执行：

```bash
npx @modern-js/upgrade
```

## Modern.js Module 支持 bundle 构建

Modern.js Module 对底层实现进行重构，新增 [`output.buildConfig`](https://modernjs.dev/v1/docs/apis/module/config/output/build-config/) 配置，用于提供更加丰富的构建功能。

新的 Modern.js Module 项目，不仅支持对产物做 bundless 构建，也支持 bundle 构建。通过配置 `buildConfig` 下的 [`buildType`](https://modernjs.dev/v1/docs/apis/module/config/output/build-config/build-type) ，即可进行 bundle 构建：

```ts title="modern.config.ts"
import { defineConfig } from '@modern-js/module-tools';

export default defineConfig({
  output: {
    buildConfig: {
      buildType: 'bundle', // 采用 bundle 构建
    },
  },
});
```

`buildConfig` 下还支持 [`bundleOptions`](https://modernjs.dev/v1/docs/apis/module/config/output/build-config/bundle-options) 配置，可以对构建行为做更多的自定义：如设置产物文件名、是否进行代码分片、设置代码压缩方式等。

## Reduck v1.1

Reduck 作为 Modern.js 的第一方状态管理方案，发布 v1.1 版本，增加对 React 18 Concurrent Rendering 的支持，并对开发体验和功能稳定性做了大量优化。

新增 API：

- [`useStore`](https://modernjs.dev/v1/docs/apis/app/runtime/model/use-store) ：可以在组件内获取当前组件树共享的 Store，满足在组件外访问 Model 的场景需求。
- [`handleEffect`](https://modernjs.dev/v1/docs/apis/app/runtime/model/handle-effect)：一个工具函数，可以极大地简化异步数据获取的逻辑代码。
- [`connect`](https://modernjs.dev/v1/docs/apis/app/runtime/model/connect)： HOC 风格的 API，用于访问 Model。

开发体验方面，优化 Reduck 组成包的组织结构，减少用户侧依赖数量，现在只需要引入 `@modern-js-reduck/react` 一个包（Modern.js 中 Reduck 功能已内置，无需手动引入包）；优化 API 的 TS 类型定义，改进类型信息的自动推导，整体达到 TS 支持开箱即用。

此外，对 Reduck [使用文档](https://modernjs.dev/v1/docs/guides/features/model/quick-start) 和 [API 文档](https://modernjs.dev/v1/docs/apis/app/runtime/model/model_) 做了全面更新，提供了更加丰富和详尽的内容。

## 其他更新

### 命令和配置

**新增命令**

- [`upgrade`](https://modernjs.dev/v1/docs/apis/app/commands/upgrade)：自动升级 Modern.js 版本。功能同执行 `npx @modern-js/upgrade` 命令。
- [`inspect`](https://modernjs.dev/v1/docs/apis/app/commands/inspect)：通过该命令可以输出当前项目使用的完整 webpack 配置。
- [`gen-release-note`](https://modernjs.dev/v1/docs/apis/module/commands/gen-release-note)：自动根据当前仓库的 [changesets](https://github.com/changesets/changesets) 信息生成发布日志。此外，我们提供了[包版本管理专题文档](https://modernjs.dev/v1/docs/guides/features/changesets/introduce)，方便大家更好的认识和使用 changesets 及相关功能。

**新增配置**

- [`source.preEntry`](https://modernjs.dev/v1/docs/apis/app/config/source/pre-entry)：用于配置全局脚本，这段脚本会早于页面的代码执行。

### BFF

- 新增 [`afterLambdaRegisted`](https://modernjs.dev/v1/docs/apis/app/runtime/bff-server/after-lambda-registed) hook。用于使用 Express 框架时，在 BFF 函数注册路由之后执行。可以用来添加错误处理逻辑，新增路由等。
- 优化使用 Express 框架开发场景下的热更新性能。在比较大的项目中，BFF 函数更改，热更新也可以在几十毫秒内完成。

### SSR

- SSR 产物添加 Sourcemap，优化服务端调试 SSR 代码的体验。

### Web Server

- 支持按入口设置响应头，使用方式请参考[文档](https://modernjs.dev/v1/docs/apis/app/config/server/routes#自定义响应头)。
