import path from 'path';
import { fs, logger } from '@modern-js/utils';
// FIXME: import DevProxyOptions from somewhere
// import type { DevProxyOptions } from '@modern-js/core';

interface ProxyRule {
  pattern: string;
  target: string;
}

const createWhistleProxyRule = (ruleDirectory: string, rules: ProxyRule[]) => {
  const dest = path.resolve(ruleDirectory, 'proxy.rule.js');

  let code = `/.*/ enable://intercept\n`;

  for (const rule of rules) {
    const { pattern, target } = rule;
    code += `${pattern} ${target}\n`;
  }

  fs.outputFileSync(
    dest,
    `exports.name = 'modernjs proxy rule';\nexports.rules = \`${code}\`;`,
  );
  return dest;
};

export const createProxyRule = (appDirectory: string, proxyOptions: any) => {
  const rules = [];

  if (proxyOptions && typeof proxyOptions === 'string') {
    return proxyOptions;
  }

  if (typeof proxyOptions === 'object') {
    for (const pattern of Object.keys(proxyOptions)) {
      const target = proxyOptions[pattern];
      if (!target || typeof target !== 'string') {
        logger.error(`dev.proxy.${pattern} value should be string type`);
        process.exit(1);
      }
      rules.push({ pattern, target });
    }
  }

  return createWhistleProxyRule(appDirectory, rules);
};
