import path from 'path';
import { Volume, createFsFromVolume } from 'memfs';
import webpack from 'webpack';

export const compiler = (entryFile: string, target: string) => {
  const compiler = webpack({
    context: __dirname,
    entry: entryFile,
    target,
    output: {
      path: path.resolve(__dirname),
      filename: 'bundle.js',
    },
    module: {
      rules: [
        {
          test: /createRequest/,
          use: {
            loader: path.resolve(__dirname, './mockTsLoader.ts'),
          },
        },
      ],
    },
    resolve: { extensions: ['.ts', '...'] },
  });

  compiler.outputFileSystem = createFsFromVolume(new Volume());
  compiler.outputFileSystem.join = path.join.bind(path);

  return new Promise<webpack.Stats | undefined>((resolve, reject) => {
    compiler.run((err, stats) => {
      if (err) {
        reject(err);
      }
      if (stats?.hasErrors()) {
        reject(stats.toJson().errors);
      }

      resolve(stats);
    });
  });
};
