import axios from 'axios'
import { Message, Notification } from 'element-ui'
import store from '@/store'
import { getToken } from '@/utils/auth'

// create an axios instance
const service = axios.create({
  baseURL: process.env.VUE_APP_BASE_API, // url = base url + request url
  // withCredentials: true, // send cookies when cross-domain requests
  timeout: 10000 // request timeout
})

// request interceptor
service.interceptors.request.use(
  config => {
    // do something before request is sent

    if (store.getters.token) {
      // let each request carry token
      // ['X-Token'] is a custom headers key
      // please modify it according to the actual situation
      config.headers['Authorization'] = 'Bearer ' + getToken()
    }
    return config
  },
  error => {
    // do something with request error
    console.log(error) // for debug
    return Promise.reject(error)
  }
)

// 响应拦截器
service.interceptors.response.use(res => {
  if (res.data instanceof Blob) {
    return res
  }
  const code = res.data.code
  // if (code === 401) {
  //   MessageBox.alert(
  //     '登录状态已过期，请重新登录',
  //     '系统提示',
  //     {
  //       confirmButtonText: '确定'
  //     }
  //   ).then(() => {
  //     store.dispatch('user/logout').then(() => {
  //       location.reload() // 为了重新实例化vue-router对象 避免bug
  //     })
  //   }).catch(() => { })
  // } else
  if (code !== 200) {
    Notification.error({
      title: res.data.msg
    })
    return Promise.reject('error')
  } else {
    return res.data
  }
}, error => {
  console.log('err' + error)
  Message({
    message: error.message,
    type: 'error',
    duration: 5 * 1000
  })
  return Promise.reject(error)
}
)

export default service
