import request from '@/utils/request'

export function listRole(data) {
  return request({
    url: '/system/role/list',
    method: 'get',
    params: data
  })
}

// 查询角色详细
export function getRole(roleId) {
  return request({
    url: '/system/role/' + roleId,
    method: 'get'
  })
}

// 新增角色
export function addRole(data) {
  return request({
    url: '/system/role',
    method: 'post',
    data: data
  })
}

// 修改角色
export function updateRole(data) {
  return request({
    url: '/system/role',
    method: 'put',
    data: data
  })
}

// 角色状态修改
export function changeRoleStatus(roleId, roleStatus) {
  const data = {
    roleId,
    roleStatus
  }
  return request({
    url: '/system/role/changeStatus',
    method: 'put',
    data: data
  })
}

// 删除角色
export function delRole(roleId) {
  return request({
    url: '/system/role/' + roleId,
    method: 'delete'
  })
}

// 导出角色
export function exportRole(query, progress) {
  return request({
    url: '/system/role/export',
    method: 'get',
    params: query,
    responseType: 'blob',
    // `onDownloadProgress` 允许为下载处理进度事件
    // 浏览器专属
    onDownloadProgress: progress
  })
}
