pub const ERR_OK: u32 = 0;
pub const ERR_EPERM: u32 = 1; /* Operation not permitted */
pub const ERR_ENOENT: u32 = 2;
pub const ERR_ESRCH: u32 = 3; /* No such process */
pub const ERR_EINTR: u32 = 4; /* Interrupted system call */
pub const ERR_EIO: u32 = 5; /* I/O error */
pub const ERR_ENXIO: u32 = 6; /* No such device or address */
pub const ERR_E2BIG: u32 = 7; /* Arg list too long */
pub const ERR_ENOEXEC: u32 = 8; /* Exec format error */
pub const ERR_EBADF: u32 = 9; /* Bad file number */
pub const ERR_ECHILD: u32 = 10; /* No child processes */
pub const ERR_EAGAIN: u32 = 11; /* Try again */
pub const ERR_ENOMEM: u32 = 12; /* Out of memory */
pub const ERR_EACCES: u32 = 13; /* Permission denied */
pub const ERR_EFAULT: u32 = 14; /* Bad address */
pub const ERR_ENOTBLK: u32 = 15; /* Block device required */
pub const ERR_EBUSY: u32 = 16; /* Device or resource busy */
pub const ERR_EEXIST: u32 = 17; /* File exists */
pub const ERR_EXDEV: u32 = 18; /* Cross-device link */
pub const ERR_ENODEV: u32 = 19; /* No such device */
pub const ERR_ENOTDIR: u32 = 20; /* Not a directory */
pub const ERR_EISDIR: u32 = 21; /* Is a directory */
pub const ERR_EINVAL: u32 = 22; /* Invalid argument */
pub const ERR_ENFILE: u32 = 23; /* File table overflow */
pub const ERR_EMFILE: u32 = 24; /* Too many open files */
pub const ERR_ENOTTY: u32 = 25; /* Not a typewriter */
pub const ERR_ETXTBSY: u32 = 26; /* Text file busy */
pub const ERR_EFBIG: u32 = 27; /* File too large */
pub const ERR_ENOSPC: u32 = 28; /* No space left on device */
pub const ERR_ESPIPE: u32 = 29; /* Illegal seek */
pub const ERR_EROFS: u32 = 30; /* Read-only file system */
pub const ERR_EMLINK: u32 = 31; /* Too many links */
pub const ERR_EPIPE: u32 = 32; /* Broken pipe */
pub const ERR_EDOM: u32 = 33; /* Math argument out of domain of func */
pub const ERR_ERANGE: u32 = 34; /* Math result not representable */
pub const ERR_EDEADLK: u32 = 35; /* Resource deadlock would occur */
pub const ERR_ENAMETOOLONG: u32 = 36; /* File name too long */
pub const ERR_ENOLCK: u32 = 37; /* No record locks available */
pub const ERR_ENOSYS: u32 = 38; /* Function not implemented */
pub const ERR_ENOTEMPTY: u32 = 39; /* Directory not empty */
pub const ERR_ELOOP: u32 = 40; /* Too many symbolic links encountered */
pub const ERR_EWOULDBLOCK: u32 = ERR_EAGAIN; /* Operation would block */
pub const ERR_ENOMSG: u32 = 42; /* No message of desired type */
pub const ERR_EIDRM: u32 = 43; /* Identifier removed */
pub const ERR_ECHRNG: u32 = 44; /* Channel number out of range */
pub const ERR_EL2NSYNC: u32 = 45; /* Level 2 not synchronized */
pub const ERR_EL3HLT: u32 = 46; /* Level 3 halted */
pub const ERR_EL3RST: u32 = 47; /* Level 3 reset */
pub const ERR_ELNRNG: u32 = 48; /* Link number out of range */
pub const ERR_EUNATCH: u32 = 49; /* Protocol driver not attached */
pub const ERR_ENOCSI: u32 = 50; /* No CSI structure available */
pub const ERR_EL2HLT: u32 = 51; /* Level 2 halted */
pub const ERR_EBADE: u32 = 52; /* Invalid exchange */
pub const ERR_EBADR: u32 = 53; /* Invalid request descriptor */
pub const ERR_EXFULL: u32 = 54; /* Exchange full */
pub const ERR_ENOANO: u32 = 55; /* No anode */
pub const ERR_EBADRQC: u32 = 56; /* Invalid request code */
pub const ERR_EBADSLT: u32 = 57; /* Invalid slot */

pub const ERR_EDEADLOCK: u32 = ERR_EDEADLK;

pub const ERR_EBFONT: u32 = 59; /* Bad font file format */
pub const ERR_ENOSTR: u32 = 60; /* Device not a stream */
pub const ERR_ENODATA: u32 = 61; /* No data available */
pub const ERR_ETIME: u32 = 62; /* Timer expired */
pub const ERR_ENOSR: u32 = 63; /* Out of streams resources */
pub const ERR_ENONET: u32 = 64; /* Machine is not on the network */
pub const ERR_ENOPKG: u32 = 65; /* Package not installed */
pub const ERR_EREMOTE: u32 = 66; /* Object is remote */
pub const ERR_ENOLINK: u32 = 67; /* Link has been severed */
pub const ERR_EADV: u32 = 68; /* Advertise error */
pub const ERR_ESRMNT: u32 = 69; /* Srmount error */
pub const ERR_ECOMM: u32 = 70; /* Communication error on send */
pub const ERR_EPROTO: u32 = 71; /* Protocol error */
pub const ERR_EMULTIHOP: u32 = 72; /* Multihop attempted */
pub const ERR_EDOTDOT: u32 = 73; /* RFS specific error */
pub const ERR_EBADMSG: u32 = 74; /* Not a data message */
pub const ERR_EOVERFLOW: u32 = 75; /* Value too large for defined data type */
pub const ERR_ENOTUNIQ: u32 = 76; /* Name not unique on network */
pub const ERR_EBADFD: u32 = 77; /* File descriptor in bad state */
pub const ERR_EREMCHG: u32 = 78; /* Remote address changed */
pub const ERR_ELIBACC: u32 = 79; /* Can not access a needed shared library */
pub const ERR_ELIBBAD: u32 = 80; /* Accessing a corrupted shared library */
pub const ERR_ELIBSCN: u32 = 81; /* .lib section in a.out corrupted */
pub const ERR_ELIBMAX: u32 = 82; /* Attempting to link in too many shared libraries */
pub const ERR_ELIBEXEC: u32 = 83; /* Cannot exec a shared library directly */
pub const ERR_EILSEQ: u32 = 84; /* Illegal byte sequence */
pub const ERR_ERESTART: u32 = 85; /* Interrupted system call should be restarted */
pub const ERR_ESTRPIPE: u32 = 86; /* Streams pipe error */
pub const ERR_EUSERS: u32 = 87; /* Too many users */
pub const ERR_ENOTSOCK: u32 = 88; /* Socket operation on non-socket */
pub const ERR_EDESTADDRREQ: u32 = 89; /* Destination address required */
pub const ERR_EMSGSIZE: u32 = 90; /* Message too long */
pub const ERR_EPROTOTYPE: u32 = 91; /* Protocol wrong type for socket */
pub const ERR_ENOPROTOOPT: u32 = 92; /* Protocol not available */
pub const ERR_EPROTONOSUPPORT: u32 = 93; /* Protocol not supported */
pub const ERR_ESOCKTNOSUPPORT: u32 = 94; /* Socket type not supported */
pub const ERR_EOPNOTSUPP: u32 = 95; /* Operation not supported on transport endpoint */
pub const ERR_EPFNOSUPPORT: u32 = 96; /* Protocol family not supported */
pub const ERR_EAFNOSUPPORT: u32 = 97; /* Address family not supported by protocol */
pub const ERR_EADDRINUSE: u32 = 98; /* Address already in use */
pub const ERR_EADDRNOTAVAIL: u32 = 99; /* Cannot assign requested address */
pub const ERR_ENETDOWN: u32 = 100; /* Network is down */
pub const ERR_ENETUNREACH: u32 = 101; /* Network is unreachable */
pub const ERR_ENETRESET: u32 = 102; /* Network dropped connection because of reset */
pub const ERR_ECONNABORTED: u32 = 103; /* Software caused connection abort */
pub const ERR_ECONNRESET: u32 = 104; /* Connection reset by peer */
pub const ERR_ENOBUFS: u32 = 105; /* No buffer space available */
pub const ERR_EISCONN: u32 = 106; /* Transport endpoint is already connected */
pub const ERR_ENOTCONN: u32 = 107; /* Transport endpoint is not connected */
pub const ERR_ESHUTDOWN: u32 = 108; /* Cannot send after transport endpoint shutdown */
pub const ERR_ETOOMANYREFS: u32 = 109; /* Too many references: cannot splice */
pub const ERR_ETIMEDOUT: u32 = 110; /* Connection timed out */
pub const ERR_ECONNREFUSED: u32 = 111; /* Connection refused */
pub const ERR_EHOSTDOWN: u32 = 112; /* Host is down */
pub const ERR_EHOSTUNREACH: u32 = 113; /* No route to host */
pub const ERR_EALREADY: u32 = 114; /* Operation already in progress */
pub const ERR_EINPROGRESS: u32 = 115; /* Operation now in progress */
pub const ERR_ESTALE: u32 = 116; /* Stale NFS file handle */
pub const ERR_EUCLEAN: u32 = 117; /* Structure needs cleaning */
pub const ERR_ENOTNAM: u32 = 118; /* Not a XENIX named type file */
pub const ERR_ENAVAIL: u32 = 119; /* No XENIX semaphores available */
pub const ERR_EISNAM: u32 = 120; /* Is a named type file */
pub const ERR_EREMOTEIO: u32 = 121; /* Remote I/O error */
pub const ERR_EDQUOT: u32 = 122; /* Quota exceeded */

pub const ERR_ENOMEDIUM: u32 = 123; /* No medium found */
pub const ERR_EMEDIUMTYPE: u32 = 124; /* Wrong medium type */

pub const ERR_TERMINATED: u32 = 130; /* Process was terminated */
pub const ERR_PANIC: u32 = 99999; /* Process has panicked */

pub fn exit_code_to_message(code: u32) -> &'static str {
    match code {
        ERR_OK => "Ok",
        ERR_EPERM => "Operation not permitted",
        ERR_ENOENT => "No such file or directory",
        ERR_ESRCH => "No such process",
        ERR_EINTR => "Interrupted system call",
        ERR_EIO => "I/O error",
        ERR_ENXIO => "No such device or address",
        ERR_E2BIG => "Arg list too long",
        ERR_ENOEXEC => "Exec format error",
        ERR_EBADF => "Bad file number",
        ERR_ECHILD => "No child processes",
        ERR_EAGAIN => "Try again",
        ERR_ENOMEM => "Out of memory",
        ERR_EACCES => "Permission denied",
        ERR_EFAULT => "Bad address",
        ERR_ENOTBLK => "Block device required",
        ERR_EBUSY => "Device or resource busy",
        ERR_EEXIST => "File exists",
        ERR_EXDEV => "Cross-device link",
        ERR_ENODEV => "No such device",
        ERR_ENOTDIR => "Not a directory",
        ERR_EISDIR => "Is a directory",
        ERR_EINVAL => "Invalid argument",
        ERR_ENFILE => "File table overflow",
        ERR_EMFILE => "Too many open files",
        ERR_ENOTTY => "Not a typewriter",
        ERR_ETXTBSY => "Text file busy",
        ERR_EFBIG => "File too large",
        ERR_ENOSPC => "No space left on device",
        ERR_ESPIPE => "Illegal seek",
        ERR_EROFS => "Read-only file system",
        ERR_EMLINK => "Too many links",
        ERR_EPIPE => "Broken pipe",
        ERR_EDOM => "Math argument out of domain of func",
        ERR_ERANGE => "Math result not representable",
        ERR_EDEADLK => "Resource deadlock would occur",
        ERR_ENAMETOOLONG => "File name too long",
        ERR_ENOLCK => "No record locks available",
        ERR_ENOSYS => "Function not implemented",
        ERR_ENOTEMPTY => "Directory not empty",
        ERR_ELOOP => "Too many symbolic links encountered",
        ERR_ENOMSG => "No message of desired type",
        ERR_EIDRM => "Identifier removed",
        ERR_ECHRNG => "Channel number out of range",
        ERR_EL2NSYNC => "Level 2 not synchronized",
        ERR_EL3HLT => "Level 3 halted",
        ERR_EL3RST => "Level 3 reset",
        ERR_ELNRNG => "Link number out of range",
        ERR_EUNATCH => "Protocol driver not attached",
        ERR_ENOCSI => "No CSI structure available",
        ERR_EL2HLT => "Level 2 halted",
        ERR_EBADE => "Invalid exchange",
        ERR_EBADR => "Invalid request descriptor",
        ERR_EXFULL => "Exchange full",
        ERR_ENOANO => "No anode",
        ERR_EBADRQC => "Invalid request code",
        ERR_EBADSLT => "Invalid slot",
        ERR_EBFONT => "Bad font file format",
        ERR_ENOSTR => "Device not a stream",
        ERR_ENODATA => "No data available",
        ERR_ETIME => "Timer expired",
        ERR_ENOSR => "Out of streams resources",
        ERR_ENONET => "Machine is not on the network",
        ERR_ENOPKG => "Package not installed",
        ERR_EREMOTE => "Object is remote",
        ERR_ENOLINK => "Link has been severed",
        ERR_EADV => "Advertise error",
        ERR_ESRMNT => "Srmount error",
        ERR_ECOMM => "Communication error on send",
        ERR_EPROTO => "Protocol error",
        ERR_EMULTIHOP => "Multihop attempted",
        ERR_EDOTDOT => "RFS specific error",
        ERR_EBADMSG => "Not a data message",
        ERR_EOVERFLOW => "Value too large for defined data type",
        ERR_ENOTUNIQ => "Name not unique on network",
        ERR_EBADFD => "File descriptor in bad state",
        ERR_EREMCHG => "Remote address changed",
        ERR_ELIBACC => "Can not access a needed shared library",
        ERR_ELIBBAD => "Accessing a corrupted shared library",
        ERR_ELIBSCN => ".lib section in a.out corrupted",
        ERR_ELIBMAX => "Attempting to link in too many shared libraries",
        ERR_ELIBEXEC => "Cannot exec a shared library directly",
        ERR_EILSEQ => "Illegal byte sequence",
        ERR_ERESTART => "Interrupted system call should be restarted",
        ERR_ESTRPIPE => "Streams pipe error",
        ERR_EUSERS => "Too many users",
        ERR_ENOTSOCK => "Socket operation on non-socket",
        ERR_EDESTADDRREQ => "Destination address required",
        ERR_EMSGSIZE => "Message too long",
        ERR_EPROTOTYPE => "Protocol wrong type for socket",
        ERR_ENOPROTOOPT => "Protocol not available",
        ERR_EPROTONOSUPPORT => "Protocol not supported",
        ERR_ESOCKTNOSUPPORT => "Socket type not supported",
        ERR_EOPNOTSUPP => "Operation not supported on transport endpoint",
        ERR_EPFNOSUPPORT => "Protocol family not supported",
        ERR_EAFNOSUPPORT => "Address family not supported by protocol",
        ERR_EADDRINUSE => "Address already in use",
        ERR_EADDRNOTAVAIL => "Cannot assign requested address",
        ERR_ENETDOWN => "Network is down",
        ERR_ENETUNREACH => "Network is unreachable",
        ERR_ENETRESET => "Network dropped connection because of reset",
        ERR_ECONNABORTED => "Software caused connection abort",
        ERR_ECONNRESET => "Connection reset by peer",
        ERR_ENOBUFS => "No buffer space available",
        ERR_EISCONN => "Transport endpoint is already connected",
        ERR_ENOTCONN => "Transport endpoint is not connected",
        ERR_ESHUTDOWN => "Cannot send after transport endpoint shutdown",
        ERR_ETOOMANYREFS => "Too many references: cannot splice",
        ERR_ETIMEDOUT => "Connection timed out",
        ERR_ECONNREFUSED => "Connection refused",
        ERR_EHOSTDOWN => "Host is down",
        ERR_EHOSTUNREACH => "No route to host",
        ERR_EALREADY => "Operation already in progress",
        ERR_EINPROGRESS => "Operation now in progress",
        ERR_ESTALE => "Stale NFS file handle",
        ERR_EUCLEAN => "Structure needs cleaning",
        ERR_ENOTNAM => "Not a XENIX named type file",
        ERR_ENAVAIL => "No XENIX semaphores available",
        ERR_EISNAM => "Is a named type file",
        ERR_EREMOTEIO => "Remote I/O error",
        ERR_EDQUOT => "Quota exceeded",
        ERR_ENOMEDIUM => "No medium found",
        ERR_EMEDIUMTYPE => "Wrong medium type",
        ERR_PANIC => "Process has panicked",
        ERR_TERMINATED => "Process was terminated",
        _ => "Unknown error",
    }
}
