//  Copyright 2019 root.ext@gmail.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.

import 'dart:ffi';

//GL_VERSION_1_0
const int GL_VERSION_1_0 = 1;
const int GL_DEPTH_BUFFER_BIT = 0x00000100;
const int GL_STENCIL_BUFFER_BIT = 0x00000400;
const int GL_COLOR_BUFFER_BIT = 0x00004000;
const int GL_FALSE = 0;
const int GL_TRUE = 1;
const int GL_POINTS = 0x0000;
const int GL_LINES = 0x0001;
const int GL_LINE_LOOP = 0x0002;
const int GL_LINE_STRIP = 0x0003;
const int GL_TRIANGLES = 0x0004;
const int GL_TRIANGLE_STRIP = 0x0005;
const int GL_TRIANGLE_FAN = 0x0006;
const int GL_QUADS = 0x0007;
const int GL_NEVER = 0x0200;
const int GL_LESS = 0x0201;
const int GL_EQUAL = 0x0202;
const int GL_LEQUAL = 0x0203;
const int GL_GREATER = 0x0204;
const int GL_NOTEQUAL = 0x0205;
const int GL_GEQUAL = 0x0206;
const int GL_ALWAYS = 0x0207;
const int GL_ZERO = 0;
const int GL_ONE = 1;
const int GL_SRC_COLOR = 0x0300;
const int GL_ONE_MINUS_SRC_COLOR = 0x0301;
const int GL_SRC_ALPHA = 0x0302;
const int GL_ONE_MINUS_SRC_ALPHA = 0x0303;
const int GL_DST_ALPHA = 0x0304;
const int GL_ONE_MINUS_DST_ALPHA = 0x0305;
const int GL_DST_COLOR = 0x0306;
const int GL_ONE_MINUS_DST_COLOR = 0x0307;
const int GL_SRC_ALPHA_SATURATE = 0x0308;
const int GL_NONE = 0;
const int GL_FRONT_LEFT = 0x0400;
const int GL_FRONT_RIGHT = 0x0401;
const int GL_BACK_LEFT = 0x0402;
const int GL_BACK_RIGHT = 0x0403;
const int GL_FRONT = 0x0404;
const int GL_BACK = 0x0405;
const int GL_LEFT = 0x0406;
const int GL_RIGHT = 0x0407;
const int GL_FRONT_AND_BACK = 0x0408;
const int GL_NO_ERROR = 0;
const int GL_INVALID_ENUM = 0x0500;
const int GL_INVALID_VALUE = 0x0501;
const int GL_INVALID_OPERATION = 0x0502;
const int GL_OUT_OF_MEMORY = 0x0505;
const int GL_CW = 0x0900;
const int GL_CCW = 0x0901;
const int GL_POINT_SIZE = 0x0B11;
const int GL_POINT_SIZE_RANGE = 0x0B12;
const int GL_POINT_SIZE_GRANULARITY = 0x0B13;
const int GL_LINE_SMOOTH = 0x0B20;
const int GL_LINE_WIDTH = 0x0B21;
const int GL_LINE_WIDTH_RANGE = 0x0B22;
const int GL_LINE_WIDTH_GRANULARITY = 0x0B23;
const int GL_POLYGON_MODE = 0x0B40;
const int GL_POLYGON_SMOOTH = 0x0B41;
const int GL_CULL_FACE = 0x0B44;
const int GL_CULL_FACE_MODE = 0x0B45;
const int GL_FRONT_FACE = 0x0B46;
const int GL_DEPTH_RANGE = 0x0B70;
const int GL_DEPTH_TEST = 0x0B71;
const int GL_DEPTH_WRITEMASK = 0x0B72;
const int GL_DEPTH_CLEAR_VALUE = 0x0B73;
const int GL_DEPTH_FUNC = 0x0B74;
const int GL_STENCIL_TEST = 0x0B90;
const int GL_STENCIL_CLEAR_VALUE = 0x0B91;
const int GL_STENCIL_FUNC = 0x0B92;
const int GL_STENCIL_VALUE_MASK = 0x0B93;
const int GL_STENCIL_FAIL = 0x0B94;
const int GL_STENCIL_PASS_DEPTH_FAIL = 0x0B95;
const int GL_STENCIL_PASS_DEPTH_PASS = 0x0B96;
const int GL_STENCIL_REF = 0x0B97;
const int GL_STENCIL_WRITEMASK = 0x0B98;
const int GL_VIEWPORT = 0x0BA2;
const int GL_DITHER = 0x0BD0;
const int GL_BLEND_DST = 0x0BE0;
const int GL_BLEND_SRC = 0x0BE1;
const int GL_BLEND = 0x0BE2;
const int GL_LOGIC_OP_MODE = 0x0BF0;
const int GL_DRAW_BUFFER = 0x0C01;
const int GL_READ_BUFFER = 0x0C02;
const int GL_SCISSOR_BOX = 0x0C10;
const int GL_SCISSOR_TEST = 0x0C11;
const int GL_COLOR_CLEAR_VALUE = 0x0C22;
const int GL_COLOR_WRITEMASK = 0x0C23;
const int GL_DOUBLEBUFFER = 0x0C32;
const int GL_STEREO = 0x0C33;
const int GL_LINE_SMOOTH_HINT = 0x0C52;
const int GL_POLYGON_SMOOTH_HINT = 0x0C53;
const int GL_UNPACK_SWAP_BYTES = 0x0CF0;
const int GL_UNPACK_LSB_FIRST = 0x0CF1;
const int GL_UNPACK_ROW_LENGTH = 0x0CF2;
const int GL_UNPACK_SKIP_ROWS = 0x0CF3;
const int GL_UNPACK_SKIP_PIXELS = 0x0CF4;
const int GL_UNPACK_ALIGNMENT = 0x0CF5;
const int GL_PACK_SWAP_BYTES = 0x0D00;
const int GL_PACK_LSB_FIRST = 0x0D01;
const int GL_PACK_ROW_LENGTH = 0x0D02;
const int GL_PACK_SKIP_ROWS = 0x0D03;
const int GL_PACK_SKIP_PIXELS = 0x0D04;
const int GL_PACK_ALIGNMENT = 0x0D05;
const int GL_MAX_TEXTURE_SIZE = 0x0D33;
const int GL_MAX_VIEWPORT_DIMS = 0x0D3A;
const int GL_SUBPIXEL_BITS = 0x0D50;
const int GL_TEXTURE_1D = 0x0DE0;
const int GL_TEXTURE_2D = 0x0DE1;
const int GL_TEXTURE_WIDTH = 0x1000;
const int GL_TEXTURE_HEIGHT = 0x1001;
const int GL_TEXTURE_BORDER_COLOR = 0x1004;
const int GL_DONT_CARE = 0x1100;
const int GL_FASTEST = 0x1101;
const int GL_NICEST = 0x1102;
const int GL_BYTE = 0x1400;
const int GL_UNSIGNED_BYTE = 0x1401;
const int GL_SHORT = 0x1402;
const int GL_UNSIGNED_SHORT = 0x1403;
const int GL_INT = 0x1404;
const int GL_UNSIGNED_INT = 0x1405;
const int GL_FLOAT = 0x1406;
const int GL_STACK_OVERFLOW = 0x0503;
const int GL_STACK_UNDERFLOW = 0x0504;
const int GL_CLEAR = 0x1500;
const int GL_AND = 0x1501;
const int GL_AND_REVERSE = 0x1502;
const int GL_COPY = 0x1503;
const int GL_AND_INVERTED = 0x1504;
const int GL_NOOP = 0x1505;
const int GL_XOR = 0x1506;
const int GL_OR = 0x1507;
const int GL_NOR = 0x1508;
const int GL_EQUIV = 0x1509;
const int GL_INVERT = 0x150A;
const int GL_OR_REVERSE = 0x150B;
const int GL_COPY_INVERTED = 0x150C;
const int GL_OR_INVERTED = 0x150D;
const int GL_NAND = 0x150E;
const int GL_SET = 0x150F;
const int GL_TEXTURE = 0x1702;
const int GL_COLOR = 0x1800;
const int GL_DEPTH = 0x1801;
const int GL_STENCIL = 0x1802;
const int GL_STENCIL_INDEX = 0x1901;
const int GL_DEPTH_COMPONENT = 0x1902;
const int GL_RED = 0x1903;
const int GL_GREEN = 0x1904;
const int GL_BLUE = 0x1905;
const int GL_ALPHA = 0x1906;
const int GL_RGB = 0x1907;
const int GL_RGBA = 0x1908;
const int GL_POINT = 0x1B00;
const int GL_LINE = 0x1B01;
const int GL_FILL = 0x1B02;
const int GL_KEEP = 0x1E00;
const int GL_REPLACE = 0x1E01;
const int GL_INCR = 0x1E02;
const int GL_DECR = 0x1E03;
const int GL_VENDOR = 0x1F00;
const int GL_RENDERER = 0x1F01;
const int GL_VERSION = 0x1F02;
const int GL_EXTENSIONS = 0x1F03;
const int GL_NEAREST = 0x2600;
const int GL_LINEAR = 0x2601;
const int GL_NEAREST_MIPMAP_NEAREST = 0x2700;
const int GL_LINEAR_MIPMAP_NEAREST = 0x2701;
const int GL_NEAREST_MIPMAP_LINEAR = 0x2702;
const int GL_LINEAR_MIPMAP_LINEAR = 0x2703;
const int GL_TEXTURE_MAG_FILTER = 0x2800;
const int GL_TEXTURE_MIN_FILTER = 0x2801;
const int GL_TEXTURE_WRAP_S = 0x2802;
const int GL_TEXTURE_WRAP_T = 0x2803;
const int GL_REPEAT = 0x2901;
//GL_VERSION_1_1
const int GL_VERSION_1_1 = 1;
const int GL_COLOR_LOGIC_OP = 0x0BF2;
const int GL_POLYGON_OFFSET_UNITS = 0x2A00;
const int GL_POLYGON_OFFSET_POINT = 0x2A01;
const int GL_POLYGON_OFFSET_LINE = 0x2A02;
const int GL_POLYGON_OFFSET_FILL = 0x8037;
const int GL_POLYGON_OFFSET_FACTOR = 0x8038;
const int GL_TEXTURE_BINDING_1D = 0x8068;
const int GL_TEXTURE_BINDING_2D = 0x8069;
const int GL_TEXTURE_INTERNAL_FORMAT = 0x1003;
const int GL_TEXTURE_RED_SIZE = 0x805C;
const int GL_TEXTURE_GREEN_SIZE = 0x805D;
const int GL_TEXTURE_BLUE_SIZE = 0x805E;
const int GL_TEXTURE_ALPHA_SIZE = 0x805F;
const int GL_DOUBLE = 0x140A;
const int GL_PROXY_TEXTURE_1D = 0x8063;
const int GL_PROXY_TEXTURE_2D = 0x8064;
const int GL_R3_G3_B2 = 0x2A10;
const int GL_RGB4 = 0x804F;
const int GL_RGB5 = 0x8050;
const int GL_RGB8 = 0x8051;
const int GL_RGB10 = 0x8052;
const int GL_RGB12 = 0x8053;
const int GL_RGB16 = 0x8054;
const int GL_RGBA2 = 0x8055;
const int GL_RGBA4 = 0x8056;
const int GL_RGB5_A1 = 0x8057;
const int GL_RGBA8 = 0x8058;
const int GL_RGB10_A2 = 0x8059;
const int GL_RGBA12 = 0x805A;
const int GL_RGBA16 = 0x805B;
const int GL_VERTEX_ARRAY = 0x8074;
//GL_VERSION_1_2
const int GL_VERSION_1_2 = 1;
const int GL_UNSIGNED_BYTE_3_3_2 = 0x8032;
const int GL_UNSIGNED_SHORT_4_4_4_4 = 0x8033;
const int GL_UNSIGNED_SHORT_5_5_5_1 = 0x8034;
const int GL_UNSIGNED_INT_8_8_8_8 = 0x8035;
const int GL_UNSIGNED_INT_10_10_10_2 = 0x8036;
const int GL_TEXTURE_BINDING_3D = 0x806A;
const int GL_PACK_SKIP_IMAGES = 0x806B;
const int GL_PACK_IMAGE_HEIGHT = 0x806C;
const int GL_UNPACK_SKIP_IMAGES = 0x806D;
const int GL_UNPACK_IMAGE_HEIGHT = 0x806E;
const int GL_TEXTURE_3D = 0x806F;
const int GL_PROXY_TEXTURE_3D = 0x8070;
const int GL_TEXTURE_DEPTH = 0x8071;
const int GL_TEXTURE_WRAP_R = 0x8072;
const int GL_MAX_3D_TEXTURE_SIZE = 0x8073;
const int GL_UNSIGNED_BYTE_2_3_3_REV = 0x8362;
const int GL_UNSIGNED_SHORT_5_6_5 = 0x8363;
const int GL_UNSIGNED_SHORT_5_6_5_REV = 0x8364;
const int GL_UNSIGNED_SHORT_4_4_4_4_REV = 0x8365;
const int GL_UNSIGNED_SHORT_1_5_5_5_REV = 0x8366;
const int GL_UNSIGNED_INT_8_8_8_8_REV = 0x8367;
const int GL_UNSIGNED_INT_2_10_10_10_REV = 0x8368;
const int GL_BGR = 0x80E0;
const int GL_BGRA = 0x80E1;
const int GL_MAX_ELEMENTS_VERTICES = 0x80E8;
const int GL_MAX_ELEMENTS_INDICES = 0x80E9;
const int GL_CLAMP_TO_EDGE = 0x812F;
const int GL_TEXTURE_MIN_LOD = 0x813A;
const int GL_TEXTURE_MAX_LOD = 0x813B;
const int GL_TEXTURE_BASE_LEVEL = 0x813C;
const int GL_TEXTURE_MAX_LEVEL = 0x813D;
const int GL_SMOOTH_POINT_SIZE_RANGE = 0x0B12;
const int GL_SMOOTH_POINT_SIZE_GRANULARITY = 0x0B13;
const int GL_SMOOTH_LINE_WIDTH_RANGE = 0x0B22;
const int GL_SMOOTH_LINE_WIDTH_GRANULARITY = 0x0B23;
const int GL_ALIASED_LINE_WIDTH_RANGE = 0x846E;
//GL_VERSION_1_3
const int GL_VERSION_1_3 = 1;
const int GL_TEXTURE0 = 0x84C0;
const int GL_TEXTURE1 = 0x84C1;
const int GL_TEXTURE2 = 0x84C2;
const int GL_TEXTURE3 = 0x84C3;
const int GL_TEXTURE4 = 0x84C4;
const int GL_TEXTURE5 = 0x84C5;
const int GL_TEXTURE6 = 0x84C6;
const int GL_TEXTURE7 = 0x84C7;
const int GL_TEXTURE8 = 0x84C8;
const int GL_TEXTURE9 = 0x84C9;
const int GL_TEXTURE10 = 0x84CA;
const int GL_TEXTURE11 = 0x84CB;
const int GL_TEXTURE12 = 0x84CC;
const int GL_TEXTURE13 = 0x84CD;
const int GL_TEXTURE14 = 0x84CE;
const int GL_TEXTURE15 = 0x84CF;
const int GL_TEXTURE16 = 0x84D0;
const int GL_TEXTURE17 = 0x84D1;
const int GL_TEXTURE18 = 0x84D2;
const int GL_TEXTURE19 = 0x84D3;
const int GL_TEXTURE20 = 0x84D4;
const int GL_TEXTURE21 = 0x84D5;
const int GL_TEXTURE22 = 0x84D6;
const int GL_TEXTURE23 = 0x84D7;
const int GL_TEXTURE24 = 0x84D8;
const int GL_TEXTURE25 = 0x84D9;
const int GL_TEXTURE26 = 0x84DA;
const int GL_TEXTURE27 = 0x84DB;
const int GL_TEXTURE28 = 0x84DC;
const int GL_TEXTURE29 = 0x84DD;
const int GL_TEXTURE30 = 0x84DE;
const int GL_TEXTURE31 = 0x84DF;
const int GL_ACTIVE_TEXTURE = 0x84E0;
const int GL_MULTISAMPLE = 0x809D;
const int GL_SAMPLE_ALPHA_TO_COVERAGE = 0x809E;
const int GL_SAMPLE_ALPHA_TO_ONE = 0x809F;
const int GL_SAMPLE_COVERAGE = 0x80A0;
const int GL_SAMPLE_BUFFERS = 0x80A8;
const int GL_SAMPLES = 0x80A9;
const int GL_SAMPLE_COVERAGE_VALUE = 0x80AA;
const int GL_SAMPLE_COVERAGE_INVERT = 0x80AB;
const int GL_TEXTURE_CUBE_MAP = 0x8513;
const int GL_TEXTURE_BINDING_CUBE_MAP = 0x8514;
const int GL_TEXTURE_CUBE_MAP_POSITIVE_X = 0x8515;
const int GL_TEXTURE_CUBE_MAP_NEGATIVE_X = 0x8516;
const int GL_TEXTURE_CUBE_MAP_POSITIVE_Y = 0x8517;
const int GL_TEXTURE_CUBE_MAP_NEGATIVE_Y = 0x8518;
const int GL_TEXTURE_CUBE_MAP_POSITIVE_Z = 0x8519;
const int GL_TEXTURE_CUBE_MAP_NEGATIVE_Z = 0x851A;
const int GL_PROXY_TEXTURE_CUBE_MAP = 0x851B;
const int GL_MAX_CUBE_MAP_TEXTURE_SIZE = 0x851C;
const int GL_COMPRESSED_RGB = 0x84ED;
const int GL_COMPRESSED_RGBA = 0x84EE;
const int GL_TEXTURE_COMPRESSION_HINT = 0x84EF;
const int GL_TEXTURE_COMPRESSED_IMAGE_SIZE = 0x86A0;
const int GL_TEXTURE_COMPRESSED = 0x86A1;
const int GL_NUM_COMPRESSED_TEXTURE_FORMATS = 0x86A2;
const int GL_COMPRESSED_TEXTURE_FORMATS = 0x86A3;
const int GL_CLAMP_TO_BORDER = 0x812D;
//GL_VERSION_1_4
const int GL_VERSION_1_4 = 1;
const int GL_BLEND_DST_RGB = 0x80C8;
const int GL_BLEND_SRC_RGB = 0x80C9;
const int GL_BLEND_DST_ALPHA = 0x80CA;
const int GL_BLEND_SRC_ALPHA = 0x80CB;
const int GL_POINT_FADE_THRESHOLD_SIZE = 0x8128;
const int GL_DEPTH_COMPONENT16 = 0x81A5;
const int GL_DEPTH_COMPONENT24 = 0x81A6;
const int GL_DEPTH_COMPONENT32 = 0x81A7;
const int GL_MIRRORED_REPEAT = 0x8370;
const int GL_MAX_TEXTURE_LOD_BIAS = 0x84FD;
const int GL_TEXTURE_LOD_BIAS = 0x8501;
const int GL_INCR_WRAP = 0x8507;
const int GL_DECR_WRAP = 0x8508;
const int GL_TEXTURE_DEPTH_SIZE = 0x884A;
const int GL_TEXTURE_COMPARE_MODE = 0x884C;
const int GL_TEXTURE_COMPARE_FUNC = 0x884D;
const int GL_BLEND_COLOR = 0x8005;
const int GL_BLEND_EQUATION = 0x8009;
const int GL_CONSTANT_COLOR = 0x8001;
const int GL_ONE_MINUS_CONSTANT_COLOR = 0x8002;
const int GL_CONSTANT_ALPHA = 0x8003;
const int GL_ONE_MINUS_CONSTANT_ALPHA = 0x8004;
const int GL_FUNC_ADD = 0x8006;
const int GL_FUNC_REVERSE_SUBTRACT = 0x800B;
const int GL_FUNC_SUBTRACT = 0x800A;
const int GL_MIN = 0x8007;
const int GL_MAX = 0x8008;
//GL_VERSION_1_5
const int GL_VERSION_1_5 = 1;
const int GL_BUFFER_SIZE = 0x8764;
const int GL_BUFFER_USAGE = 0x8765;
const int GL_QUERY_COUNTER_BITS = 0x8864;
const int GL_CURRENT_QUERY = 0x8865;
const int GL_QUERY_RESULT = 0x8866;
const int GL_QUERY_RESULT_AVAILABLE = 0x8867;
const int GL_ARRAY_BUFFER = 0x8892;
const int GL_ELEMENT_ARRAY_BUFFER = 0x8893;
const int GL_ARRAY_BUFFER_BINDING = 0x8894;
const int GL_ELEMENT_ARRAY_BUFFER_BINDING = 0x8895;
const int GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING = 0x889F;
const int GL_READ_ONLY = 0x88B8;
const int GL_WRITE_ONLY = 0x88B9;
const int GL_READ_WRITE = 0x88BA;
const int GL_BUFFER_ACCESS = 0x88BB;
const int GL_BUFFER_MAPPED = 0x88BC;
const int GL_BUFFER_MAP_POINTER = 0x88BD;
const int GL_STREAM_DRAW = 0x88E0;
const int GL_STREAM_READ = 0x88E1;
const int GL_STREAM_COPY = 0x88E2;
const int GL_STATIC_DRAW = 0x88E4;
const int GL_STATIC_READ = 0x88E5;
const int GL_STATIC_COPY = 0x88E6;
const int GL_DYNAMIC_DRAW = 0x88E8;
const int GL_DYNAMIC_READ = 0x88E9;
const int GL_DYNAMIC_COPY = 0x88EA;
const int GL_SAMPLES_PASSED = 0x8914;
const int GL_SRC1_ALPHA = 0x8589;
//GL_VERSION_2_0
const int GL_VERSION_2_0 = 1;
const int GL_BLEND_EQUATION_RGB = 0x8009;
const int GL_VERTEX_ATTRIB_ARRAY_ENABLED = 0x8622;
const int GL_VERTEX_ATTRIB_ARRAY_SIZE = 0x8623;
const int GL_VERTEX_ATTRIB_ARRAY_STRIDE = 0x8624;
const int GL_VERTEX_ATTRIB_ARRAY_TYPE = 0x8625;
const int GL_CURRENT_VERTEX_ATTRIB = 0x8626;
const int GL_VERTEX_PROGRAM_POINT_SIZE = 0x8642;
const int GL_VERTEX_ATTRIB_ARRAY_POINTER = 0x8645;
const int GL_STENCIL_BACK_FUNC = 0x8800;
const int GL_STENCIL_BACK_FAIL = 0x8801;
const int GL_STENCIL_BACK_PASS_DEPTH_FAIL = 0x8802;
const int GL_STENCIL_BACK_PASS_DEPTH_PASS = 0x8803;
const int GL_MAX_DRAW_BUFFERS = 0x8824;
const int GL_DRAW_BUFFER0 = 0x8825;
const int GL_DRAW_BUFFER1 = 0x8826;
const int GL_DRAW_BUFFER2 = 0x8827;
const int GL_DRAW_BUFFER3 = 0x8828;
const int GL_DRAW_BUFFER4 = 0x8829;
const int GL_DRAW_BUFFER5 = 0x882A;
const int GL_DRAW_BUFFER6 = 0x882B;
const int GL_DRAW_BUFFER7 = 0x882C;
const int GL_DRAW_BUFFER8 = 0x882D;
const int GL_DRAW_BUFFER9 = 0x882E;
const int GL_DRAW_BUFFER10 = 0x882F;
const int GL_DRAW_BUFFER11 = 0x8830;
const int GL_DRAW_BUFFER12 = 0x8831;
const int GL_DRAW_BUFFER13 = 0x8832;
const int GL_DRAW_BUFFER14 = 0x8833;
const int GL_DRAW_BUFFER15 = 0x8834;
const int GL_BLEND_EQUATION_ALPHA = 0x883D;
const int GL_MAX_VERTEX_ATTRIBS = 0x8869;
const int GL_VERTEX_ATTRIB_ARRAY_NORMALIZED = 0x886A;
const int GL_MAX_TEXTURE_IMAGE_UNITS = 0x8872;
const int GL_FRAGMENT_SHADER = 0x8B30;
const int GL_VERTEX_SHADER = 0x8B31;
const int GL_MAX_FRAGMENT_UNIFORM_COMPONENTS = 0x8B49;
const int GL_MAX_VERTEX_UNIFORM_COMPONENTS = 0x8B4A;
const int GL_MAX_VARYING_FLOATS = 0x8B4B;
const int GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS = 0x8B4C;
const int GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS = 0x8B4D;
const int GL_SHADER_TYPE = 0x8B4F;
const int GL_FLOAT_VEC2 = 0x8B50;
const int GL_FLOAT_VEC3 = 0x8B51;
const int GL_FLOAT_VEC4 = 0x8B52;
const int GL_INT_VEC2 = 0x8B53;
const int GL_INT_VEC3 = 0x8B54;
const int GL_INT_VEC4 = 0x8B55;
const int GL_BOOL = 0x8B56;
const int GL_BOOL_VEC2 = 0x8B57;
const int GL_BOOL_VEC3 = 0x8B58;
const int GL_BOOL_VEC4 = 0x8B59;
const int GL_FLOAT_MAT2 = 0x8B5A;
const int GL_FLOAT_MAT3 = 0x8B5B;
const int GL_FLOAT_MAT4 = 0x8B5C;
const int GL_SAMPLER_1D = 0x8B5D;
const int GL_SAMPLER_2D = 0x8B5E;
const int GL_SAMPLER_3D = 0x8B5F;
const int GL_SAMPLER_CUBE = 0x8B60;
const int GL_SAMPLER_1D_SHADOW = 0x8B61;
const int GL_SAMPLER_2D_SHADOW = 0x8B62;
const int GL_DELETE_STATUS = 0x8B80;
const int GL_COMPILE_STATUS = 0x8B81;
const int GL_LINK_STATUS = 0x8B82;
const int GL_VALIDATE_STATUS = 0x8B83;
const int GL_INFO_LOG_LENGTH = 0x8B84;
const int GL_ATTACHED_SHADERS = 0x8B85;
const int GL_ACTIVE_UNIFORMS = 0x8B86;
const int GL_ACTIVE_UNIFORM_MAX_LENGTH = 0x8B87;
const int GL_SHADER_SOURCE_LENGTH = 0x8B88;
const int GL_ACTIVE_ATTRIBUTES = 0x8B89;
const int GL_ACTIVE_ATTRIBUTE_MAX_LENGTH = 0x8B8A;
const int GL_FRAGMENT_SHADER_DERIVATIVE_HINT = 0x8B8B;
const int GL_SHADING_LANGUAGE_VERSION = 0x8B8C;
const int GL_CURRENT_PROGRAM = 0x8B8D;
const int GL_POINT_SPRITE_COORD_ORIGIN = 0x8CA0;
const int GL_LOWER_LEFT = 0x8CA1;
const int GL_UPPER_LEFT = 0x8CA2;
const int GL_STENCIL_BACK_REF = 0x8CA3;
const int GL_STENCIL_BACK_VALUE_MASK = 0x8CA4;
const int GL_STENCIL_BACK_WRITEMASK = 0x8CA5;
//GL_VERSION_2_1
const int GL_VERSION_2_1 = 1;
const int GL_PIXEL_PACK_BUFFER = 0x88EB;
const int GL_PIXEL_UNPACK_BUFFER = 0x88EC;
const int GL_PIXEL_PACK_BUFFER_BINDING = 0x88ED;
const int GL_PIXEL_UNPACK_BUFFER_BINDING = 0x88EF;
const int GL_FLOAT_MAT2x3 = 0x8B65;
const int GL_FLOAT_MAT2x4 = 0x8B66;
const int GL_FLOAT_MAT3x2 = 0x8B67;
const int GL_FLOAT_MAT3x4 = 0x8B68;
const int GL_FLOAT_MAT4x2 = 0x8B69;
const int GL_FLOAT_MAT4x3 = 0x8B6A;
const int GL_SRGB = 0x8C40;
const int GL_SRGB8 = 0x8C41;
const int GL_SRGB_ALPHA = 0x8C42;
const int GL_SRGB8_ALPHA8 = 0x8C43;
const int GL_COMPRESSED_SRGB = 0x8C48;
const int GL_COMPRESSED_SRGB_ALPHA = 0x8C49;
//GL_VERSION_3_0
const int GL_VERSION_3_0 = 1;
const int GL_COMPARE_REF_TO_TEXTURE = 0x884E;
const int GL_CLIP_DISTANCE0 = 0x3000;
const int GL_CLIP_DISTANCE1 = 0x3001;
const int GL_CLIP_DISTANCE2 = 0x3002;
const int GL_CLIP_DISTANCE3 = 0x3003;
const int GL_CLIP_DISTANCE4 = 0x3004;
const int GL_CLIP_DISTANCE5 = 0x3005;
const int GL_CLIP_DISTANCE6 = 0x3006;
const int GL_CLIP_DISTANCE7 = 0x3007;
const int GL_MAX_CLIP_DISTANCES = 0x0D32;
const int GL_MAJOR_VERSION = 0x821B;
const int GL_MINOR_VERSION = 0x821C;
const int GL_NUM_EXTENSIONS = 0x821D;
const int GL_CONTEXT_FLAGS = 0x821E;
const int GL_COMPRESSED_RED = 0x8225;
const int GL_COMPRESSED_RG = 0x8226;
const int GL_CONTEXT_FLAG_FORWARD_COMPATIBLE_BIT = 0x00000001;
const int GL_RGBA32F = 0x8814;
const int GL_RGB32F = 0x8815;
const int GL_RGBA16F = 0x881A;
const int GL_RGB16F = 0x881B;
const int GL_VERTEX_ATTRIB_ARRAY_INTEGER = 0x88FD;
const int GL_MAX_ARRAY_TEXTURE_LAYERS = 0x88FF;
const int GL_MIN_PROGRAM_TEXEL_OFFSET = 0x8904;
const int GL_MAX_PROGRAM_TEXEL_OFFSET = 0x8905;
const int GL_CLAMP_READ_COLOR = 0x891C;
const int GL_FIXED_ONLY = 0x891D;
const int GL_MAX_VARYING_COMPONENTS = 0x8B4B;
const int GL_TEXTURE_1D_ARRAY = 0x8C18;
const int GL_PROXY_TEXTURE_1D_ARRAY = 0x8C19;
const int GL_TEXTURE_2D_ARRAY = 0x8C1A;
const int GL_PROXY_TEXTURE_2D_ARRAY = 0x8C1B;
const int GL_TEXTURE_BINDING_1D_ARRAY = 0x8C1C;
const int GL_TEXTURE_BINDING_2D_ARRAY = 0x8C1D;
const int GL_R11F_G11F_B10F = 0x8C3A;
const int GL_UNSIGNED_INT_10F_11F_11F_REV = 0x8C3B;
const int GL_RGB9_E5 = 0x8C3D;
const int GL_UNSIGNED_INT_5_9_9_9_REV = 0x8C3E;
const int GL_TEXTURE_SHARED_SIZE = 0x8C3F;
const int GL_TRANSFORM_FEEDBACK_VARYING_MAX_LENGTH = 0x8C76;
const int GL_TRANSFORM_FEEDBACK_BUFFER_MODE = 0x8C7F;
const int GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS = 0x8C80;
const int GL_TRANSFORM_FEEDBACK_VARYINGS = 0x8C83;
const int GL_TRANSFORM_FEEDBACK_BUFFER_START = 0x8C84;
const int GL_TRANSFORM_FEEDBACK_BUFFER_SIZE = 0x8C85;
const int GL_PRIMITIVES_GENERATED = 0x8C87;
const int GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN = 0x8C88;
const int GL_RASTERIZER_DISCARD = 0x8C89;
const int GL_MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS = 0x8C8A;
const int GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS = 0x8C8B;
const int GL_INTERLEAVED_ATTRIBS = 0x8C8C;
const int GL_SEPARATE_ATTRIBS = 0x8C8D;
const int GL_TRANSFORM_FEEDBACK_BUFFER = 0x8C8E;
const int GL_TRANSFORM_FEEDBACK_BUFFER_BINDING = 0x8C8F;
const int GL_RGBA32UI = 0x8D70;
const int GL_RGB32UI = 0x8D71;
const int GL_RGBA16UI = 0x8D76;
const int GL_RGB16UI = 0x8D77;
const int GL_RGBA8UI = 0x8D7C;
const int GL_RGB8UI = 0x8D7D;
const int GL_RGBA32I = 0x8D82;
const int GL_RGB32I = 0x8D83;
const int GL_RGBA16I = 0x8D88;
const int GL_RGB16I = 0x8D89;
const int GL_RGBA8I = 0x8D8E;
const int GL_RGB8I = 0x8D8F;
const int GL_RED_INTEGER = 0x8D94;
const int GL_GREEN_INTEGER = 0x8D95;
const int GL_BLUE_INTEGER = 0x8D96;
const int GL_RGB_INTEGER = 0x8D98;
const int GL_RGBA_INTEGER = 0x8D99;
const int GL_BGR_INTEGER = 0x8D9A;
const int GL_BGRA_INTEGER = 0x8D9B;
const int GL_SAMPLER_1D_ARRAY = 0x8DC0;
const int GL_SAMPLER_2D_ARRAY = 0x8DC1;
const int GL_SAMPLER_1D_ARRAY_SHADOW = 0x8DC3;
const int GL_SAMPLER_2D_ARRAY_SHADOW = 0x8DC4;
const int GL_SAMPLER_CUBE_SHADOW = 0x8DC5;
const int GL_UNSIGNED_INT_VEC2 = 0x8DC6;
const int GL_UNSIGNED_INT_VEC3 = 0x8DC7;
const int GL_UNSIGNED_INT_VEC4 = 0x8DC8;
const int GL_INT_SAMPLER_1D = 0x8DC9;
const int GL_INT_SAMPLER_2D = 0x8DCA;
const int GL_INT_SAMPLER_3D = 0x8DCB;
const int GL_INT_SAMPLER_CUBE = 0x8DCC;
const int GL_INT_SAMPLER_1D_ARRAY = 0x8DCE;
const int GL_INT_SAMPLER_2D_ARRAY = 0x8DCF;
const int GL_UNSIGNED_INT_SAMPLER_1D = 0x8DD1;
const int GL_UNSIGNED_INT_SAMPLER_2D = 0x8DD2;
const int GL_UNSIGNED_INT_SAMPLER_3D = 0x8DD3;
const int GL_UNSIGNED_INT_SAMPLER_CUBE = 0x8DD4;
const int GL_UNSIGNED_INT_SAMPLER_1D_ARRAY = 0x8DD6;
const int GL_UNSIGNED_INT_SAMPLER_2D_ARRAY = 0x8DD7;
const int GL_QUERY_WAIT = 0x8E13;
const int GL_QUERY_NO_WAIT = 0x8E14;
const int GL_QUERY_BY_REGION_WAIT = 0x8E15;
const int GL_QUERY_BY_REGION_NO_WAIT = 0x8E16;
const int GL_BUFFER_ACCESS_FLAGS = 0x911F;
const int GL_BUFFER_MAP_LENGTH = 0x9120;
const int GL_BUFFER_MAP_OFFSET = 0x9121;
const int GL_DEPTH_COMPONENT32F = 0x8CAC;
const int GL_DEPTH32F_STENCIL8 = 0x8CAD;
const int GL_FLOAT_32_UNSIGNED_INT_24_8_REV = 0x8DAD;
const int GL_INVALID_FRAMEBUFFER_OPERATION = 0x0506;
const int GL_FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING = 0x8210;
const int GL_FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE = 0x8211;
const int GL_FRAMEBUFFER_ATTACHMENT_RED_SIZE = 0x8212;
const int GL_FRAMEBUFFER_ATTACHMENT_GREEN_SIZE = 0x8213;
const int GL_FRAMEBUFFER_ATTACHMENT_BLUE_SIZE = 0x8214;
const int GL_FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE = 0x8215;
const int GL_FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE = 0x8216;
const int GL_FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE = 0x8217;
const int GL_FRAMEBUFFER_DEFAULT = 0x8218;
const int GL_FRAMEBUFFER_UNDEFINED = 0x8219;
const int GL_DEPTH_STENCIL_ATTACHMENT = 0x821A;
const int GL_MAX_RENDERBUFFER_SIZE = 0x84E8;
const int GL_DEPTH_STENCIL = 0x84F9;
const int GL_UNSIGNED_INT_24_8 = 0x84FA;
const int GL_DEPTH24_STENCIL8 = 0x88F0;
const int GL_TEXTURE_STENCIL_SIZE = 0x88F1;
const int GL_TEXTURE_RED_TYPE = 0x8C10;
const int GL_TEXTURE_GREEN_TYPE = 0x8C11;
const int GL_TEXTURE_BLUE_TYPE = 0x8C12;
const int GL_TEXTURE_ALPHA_TYPE = 0x8C13;
const int GL_TEXTURE_DEPTH_TYPE = 0x8C16;
const int GL_UNSIGNED_NORMALIZED = 0x8C17;
const int GL_FRAMEBUFFER_BINDING = 0x8CA6;
const int GL_DRAW_FRAMEBUFFER_BINDING = 0x8CA6;
const int GL_RENDERBUFFER_BINDING = 0x8CA7;
const int GL_READ_FRAMEBUFFER = 0x8CA8;
const int GL_DRAW_FRAMEBUFFER = 0x8CA9;
const int GL_READ_FRAMEBUFFER_BINDING = 0x8CAA;
const int GL_RENDERBUFFER_SAMPLES = 0x8CAB;
const int GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE = 0x8CD0;
const int GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME = 0x8CD1;
const int GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL = 0x8CD2;
const int GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE = 0x8CD3;
const int GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER = 0x8CD4;
const int GL_FRAMEBUFFER_COMPLETE = 0x8CD5;
const int GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT = 0x8CD6;
const int GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT = 0x8CD7;
const int GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER = 0x8CDB;
const int GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER = 0x8CDC;
const int GL_FRAMEBUFFER_UNSUPPORTED = 0x8CDD;
const int GL_MAX_COLOR_ATTACHMENTS = 0x8CDF;
const int GL_COLOR_ATTACHMENT0 = 0x8CE0;
const int GL_COLOR_ATTACHMENT1 = 0x8CE1;
const int GL_COLOR_ATTACHMENT2 = 0x8CE2;
const int GL_COLOR_ATTACHMENT3 = 0x8CE3;
const int GL_COLOR_ATTACHMENT4 = 0x8CE4;
const int GL_COLOR_ATTACHMENT5 = 0x8CE5;
const int GL_COLOR_ATTACHMENT6 = 0x8CE6;
const int GL_COLOR_ATTACHMENT7 = 0x8CE7;
const int GL_COLOR_ATTACHMENT8 = 0x8CE8;
const int GL_COLOR_ATTACHMENT9 = 0x8CE9;
const int GL_COLOR_ATTACHMENT10 = 0x8CEA;
const int GL_COLOR_ATTACHMENT11 = 0x8CEB;
const int GL_COLOR_ATTACHMENT12 = 0x8CEC;
const int GL_COLOR_ATTACHMENT13 = 0x8CED;
const int GL_COLOR_ATTACHMENT14 = 0x8CEE;
const int GL_COLOR_ATTACHMENT15 = 0x8CEF;
const int GL_COLOR_ATTACHMENT16 = 0x8CF0;
const int GL_COLOR_ATTACHMENT17 = 0x8CF1;
const int GL_COLOR_ATTACHMENT18 = 0x8CF2;
const int GL_COLOR_ATTACHMENT19 = 0x8CF3;
const int GL_COLOR_ATTACHMENT20 = 0x8CF4;
const int GL_COLOR_ATTACHMENT21 = 0x8CF5;
const int GL_COLOR_ATTACHMENT22 = 0x8CF6;
const int GL_COLOR_ATTACHMENT23 = 0x8CF7;
const int GL_COLOR_ATTACHMENT24 = 0x8CF8;
const int GL_COLOR_ATTACHMENT25 = 0x8CF9;
const int GL_COLOR_ATTACHMENT26 = 0x8CFA;
const int GL_COLOR_ATTACHMENT27 = 0x8CFB;
const int GL_COLOR_ATTACHMENT28 = 0x8CFC;
const int GL_COLOR_ATTACHMENT29 = 0x8CFD;
const int GL_COLOR_ATTACHMENT30 = 0x8CFE;
const int GL_COLOR_ATTACHMENT31 = 0x8CFF;
const int GL_DEPTH_ATTACHMENT = 0x8D00;
const int GL_STENCIL_ATTACHMENT = 0x8D20;
const int GL_FRAMEBUFFER = 0x8D40;
const int GL_RENDERBUFFER = 0x8D41;
const int GL_RENDERBUFFER_WIDTH = 0x8D42;
const int GL_RENDERBUFFER_HEIGHT = 0x8D43;
const int GL_RENDERBUFFER_INTERNAL_FORMAT = 0x8D44;
const int GL_STENCIL_INDEX1 = 0x8D46;
const int GL_STENCIL_INDEX4 = 0x8D47;
const int GL_STENCIL_INDEX8 = 0x8D48;
const int GL_STENCIL_INDEX16 = 0x8D49;
const int GL_RENDERBUFFER_RED_SIZE = 0x8D50;
const int GL_RENDERBUFFER_GREEN_SIZE = 0x8D51;
const int GL_RENDERBUFFER_BLUE_SIZE = 0x8D52;
const int GL_RENDERBUFFER_ALPHA_SIZE = 0x8D53;
const int GL_RENDERBUFFER_DEPTH_SIZE = 0x8D54;
const int GL_RENDERBUFFER_STENCIL_SIZE = 0x8D55;
const int GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE = 0x8D56;
const int GL_MAX_SAMPLES = 0x8D57;
const int GL_FRAMEBUFFER_SRGB = 0x8DB9;
const int GL_HALF_FLOAT = 0x140B;
const int GL_MAP_READ_BIT = 0x0001;
const int GL_MAP_WRITE_BIT = 0x0002;
const int GL_MAP_INVALIDATE_RANGE_BIT = 0x0004;
const int GL_MAP_INVALIDATE_BUFFER_BIT = 0x0008;
const int GL_MAP_FLUSH_EXPLICIT_BIT = 0x0010;
const int GL_MAP_UNSYNCHRONIZED_BIT = 0x0020;
const int GL_COMPRESSED_RED_RGTC1 = 0x8DBB;
const int GL_COMPRESSED_SIGNED_RED_RGTC1 = 0x8DBC;
const int GL_COMPRESSED_RG_RGTC2 = 0x8DBD;
const int GL_COMPRESSED_SIGNED_RG_RGTC2 = 0x8DBE;
const int GL_RG = 0x8227;
const int GL_RG_INTEGER = 0x8228;
const int GL_R8 = 0x8229;
const int GL_R16 = 0x822A;
const int GL_RG8 = 0x822B;
const int GL_RG16 = 0x822C;
const int GL_R16F = 0x822D;
const int GL_R32F = 0x822E;
const int GL_RG16F = 0x822F;
const int GL_RG32F = 0x8230;
const int GL_R8I = 0x8231;
const int GL_R8UI = 0x8232;
const int GL_R16I = 0x8233;
const int GL_R16UI = 0x8234;
const int GL_R32I = 0x8235;
const int GL_R32UI = 0x8236;
const int GL_RG8I = 0x8237;
const int GL_RG8UI = 0x8238;
const int GL_RG16I = 0x8239;
const int GL_RG16UI = 0x823A;
const int GL_RG32I = 0x823B;
const int GL_RG32UI = 0x823C;
const int GL_VERTEX_ARRAY_BINDING = 0x85B5;
//GL_VERSION_3_1
const int GL_VERSION_3_1 = 1;
const int GL_SAMPLER_2D_RECT = 0x8B63;
const int GL_SAMPLER_2D_RECT_SHADOW = 0x8B64;
const int GL_SAMPLER_BUFFER = 0x8DC2;
const int GL_INT_SAMPLER_2D_RECT = 0x8DCD;
const int GL_INT_SAMPLER_BUFFER = 0x8DD0;
const int GL_UNSIGNED_INT_SAMPLER_2D_RECT = 0x8DD5;
const int GL_UNSIGNED_INT_SAMPLER_BUFFER = 0x8DD8;
const int GL_TEXTURE_BUFFER = 0x8C2A;
const int GL_MAX_TEXTURE_BUFFER_SIZE = 0x8C2B;
const int GL_TEXTURE_BINDING_BUFFER = 0x8C2C;
const int GL_TEXTURE_BUFFER_DATA_STORE_BINDING = 0x8C2D;
const int GL_TEXTURE_RECTANGLE = 0x84F5;
const int GL_TEXTURE_BINDING_RECTANGLE = 0x84F6;
const int GL_PROXY_TEXTURE_RECTANGLE = 0x84F7;
const int GL_MAX_RECTANGLE_TEXTURE_SIZE = 0x84F8;
const int GL_R8_SNORM = 0x8F94;
const int GL_RG8_SNORM = 0x8F95;
const int GL_RGB8_SNORM = 0x8F96;
const int GL_RGBA8_SNORM = 0x8F97;
const int GL_R16_SNORM = 0x8F98;
const int GL_RG16_SNORM = 0x8F99;
const int GL_RGB16_SNORM = 0x8F9A;
const int GL_RGBA16_SNORM = 0x8F9B;
const int GL_SIGNED_NORMALIZED = 0x8F9C;
const int GL_PRIMITIVE_RESTART = 0x8F9D;
const int GL_PRIMITIVE_RESTART_INDEX = 0x8F9E;
const int GL_COPY_READ_BUFFER = 0x8F36;
const int GL_COPY_WRITE_BUFFER = 0x8F37;
const int GL_UNIFORM_BUFFER = 0x8A11;
const int GL_UNIFORM_BUFFER_BINDING = 0x8A28;
const int GL_UNIFORM_BUFFER_START = 0x8A29;
const int GL_UNIFORM_BUFFER_SIZE = 0x8A2A;
const int GL_MAX_VERTEX_UNIFORM_BLOCKS = 0x8A2B;
const int GL_MAX_GEOMETRY_UNIFORM_BLOCKS = 0x8A2C;
const int GL_MAX_FRAGMENT_UNIFORM_BLOCKS = 0x8A2D;
const int GL_MAX_COMBINED_UNIFORM_BLOCKS = 0x8A2E;
const int GL_MAX_UNIFORM_BUFFER_BINDINGS = 0x8A2F;
const int GL_MAX_UNIFORM_BLOCK_SIZE = 0x8A30;
const int GL_MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS = 0x8A31;
const int GL_MAX_COMBINED_GEOMETRY_UNIFORM_COMPONENTS = 0x8A32;
const int GL_MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS = 0x8A33;
const int GL_UNIFORM_BUFFER_OFFSET_ALIGNMENT = 0x8A34;
const int GL_ACTIVE_UNIFORM_BLOCK_MAX_NAME_LENGTH = 0x8A35;
const int GL_ACTIVE_UNIFORM_BLOCKS = 0x8A36;
const int GL_UNIFORM_TYPE = 0x8A37;
const int GL_UNIFORM_SIZE = 0x8A38;
const int GL_UNIFORM_NAME_LENGTH = 0x8A39;
const int GL_UNIFORM_BLOCK_INDEX = 0x8A3A;
const int GL_UNIFORM_OFFSET = 0x8A3B;
const int GL_UNIFORM_ARRAY_STRIDE = 0x8A3C;
const int GL_UNIFORM_MATRIX_STRIDE = 0x8A3D;
const int GL_UNIFORM_IS_ROW_MAJOR = 0x8A3E;
const int GL_UNIFORM_BLOCK_BINDING = 0x8A3F;
const int GL_UNIFORM_BLOCK_DATA_SIZE = 0x8A40;
const int GL_UNIFORM_BLOCK_NAME_LENGTH = 0x8A41;
const int GL_UNIFORM_BLOCK_ACTIVE_UNIFORMS = 0x8A42;
const int GL_UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES = 0x8A43;
const int GL_UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER = 0x8A44;
const int GL_UNIFORM_BLOCK_REFERENCED_BY_GEOMETRY_SHADER = 0x8A45;
const int GL_UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER = 0x8A46;
const int GL_INVALID_INDEX = 0xFFFFFFFF;
//GL_VERSION_3_2
const int GL_VERSION_3_2 = 1;
const int GL_CONTEXT_CORE_PROFILE_BIT = 0x00000001;
const int GL_CONTEXT_COMPATIBILITY_PROFILE_BIT = 0x00000002;
const int GL_LINES_ADJACENCY = 0x000A;
const int GL_LINE_STRIP_ADJACENCY = 0x000B;
const int GL_TRIANGLES_ADJACENCY = 0x000C;
const int GL_TRIANGLE_STRIP_ADJACENCY = 0x000D;
const int GL_PROGRAM_POINT_SIZE = 0x8642;
const int GL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS = 0x8C29;
const int GL_FRAMEBUFFER_ATTACHMENT_LAYERED = 0x8DA7;
const int GL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS = 0x8DA8;
const int GL_GEOMETRY_SHADER = 0x8DD9;
const int GL_GEOMETRY_VERTICES_OUT = 0x8916;
const int GL_GEOMETRY_INPUT_TYPE = 0x8917;
const int GL_GEOMETRY_OUTPUT_TYPE = 0x8918;
const int GL_MAX_GEOMETRY_UNIFORM_COMPONENTS = 0x8DDF;
const int GL_MAX_GEOMETRY_OUTPUT_VERTICES = 0x8DE0;
const int GL_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS = 0x8DE1;
const int GL_MAX_VERTEX_OUTPUT_COMPONENTS = 0x9122;
const int GL_MAX_GEOMETRY_INPUT_COMPONENTS = 0x9123;
const int GL_MAX_GEOMETRY_OUTPUT_COMPONENTS = 0x9124;
const int GL_MAX_FRAGMENT_INPUT_COMPONENTS = 0x9125;
const int GL_CONTEXT_PROFILE_MASK = 0x9126;
const int GL_DEPTH_CLAMP = 0x864F;
const int GL_QUADS_FOLLOW_PROVOKING_VERTEX_CONVENTION = 0x8E4C;
const int GL_FIRST_VERTEX_CONVENTION = 0x8E4D;
const int GL_LAST_VERTEX_CONVENTION = 0x8E4E;
const int GL_PROVOKING_VERTEX = 0x8E4F;
const int GL_TEXTURE_CUBE_MAP_SEAMLESS = 0x884F;
const int GL_MAX_SERVER_WAIT_TIMEOUT = 0x9111;
const int GL_OBJECT_TYPE = 0x9112;
const int GL_SYNC_CONDITION = 0x9113;
const int GL_SYNC_STATUS = 0x9114;
const int GL_SYNC_FLAGS = 0x9115;
const int GL_SYNC_FENCE = 0x9116;
const int GL_SYNC_GPU_COMMANDS_COMPLETE = 0x9117;
const int GL_UNSIGNALED = 0x9118;
const int GL_SIGNALED = 0x9119;
const int GL_ALREADY_SIGNALED = 0x911A;
const int GL_TIMEOUT_EXPIRED = 0x911B;
const int GL_CONDITION_SATISFIED = 0x911C;
const int GL_WAIT_FAILED = 0x911D;
const int GL_TIMEOUT_IGNORED = 0xFFFFFFFFFFFFFFFF;
const int GL_SYNC_FLUSH_COMMANDS_BIT = 0x00000001;
const int GL_SAMPLE_POSITION = 0x8E50;
const int GL_SAMPLE_MASK = 0x8E51;
const int GL_SAMPLE_MASK_VALUE = 0x8E52;
const int GL_MAX_SAMPLE_MASK_WORDS = 0x8E59;
const int GL_TEXTURE_2D_MULTISAMPLE = 0x9100;
const int GL_PROXY_TEXTURE_2D_MULTISAMPLE = 0x9101;
const int GL_TEXTURE_2D_MULTISAMPLE_ARRAY = 0x9102;
const int GL_PROXY_TEXTURE_2D_MULTISAMPLE_ARRAY = 0x9103;
const int GL_TEXTURE_BINDING_2D_MULTISAMPLE = 0x9104;
const int GL_TEXTURE_BINDING_2D_MULTISAMPLE_ARRAY = 0x9105;
const int GL_TEXTURE_SAMPLES = 0x9106;
const int GL_TEXTURE_FIXED_SAMPLE_LOCATIONS = 0x9107;
const int GL_SAMPLER_2D_MULTISAMPLE = 0x9108;
const int GL_INT_SAMPLER_2D_MULTISAMPLE = 0x9109;
const int GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE = 0x910A;
const int GL_SAMPLER_2D_MULTISAMPLE_ARRAY = 0x910B;
const int GL_INT_SAMPLER_2D_MULTISAMPLE_ARRAY = 0x910C;
const int GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE_ARRAY = 0x910D;
const int GL_MAX_COLOR_TEXTURE_SAMPLES = 0x910E;
const int GL_MAX_DEPTH_TEXTURE_SAMPLES = 0x910F;
const int GL_MAX_INTEGER_SAMPLES = 0x9110;
//GL_VERSION_3_3
const int GL_VERSION_3_3 = 1;
const int GL_VERTEX_ATTRIB_ARRAY_DIVISOR = 0x88FE;
const int GL_SRC1_COLOR = 0x88F9;
const int GL_ONE_MINUS_SRC1_COLOR = 0x88FA;
const int GL_ONE_MINUS_SRC1_ALPHA = 0x88FB;
const int GL_MAX_DUAL_SOURCE_DRAW_BUFFERS = 0x88FC;
const int GL_ANY_SAMPLES_PASSED = 0x8C2F;
const int GL_SAMPLER_BINDING = 0x8919;
const int GL_RGB10_A2UI = 0x906F;
const int GL_TEXTURE_SWIZZLE_R = 0x8E42;
const int GL_TEXTURE_SWIZZLE_G = 0x8E43;
const int GL_TEXTURE_SWIZZLE_B = 0x8E44;
const int GL_TEXTURE_SWIZZLE_A = 0x8E45;
const int GL_TEXTURE_SWIZZLE_RGBA = 0x8E46;
const int GL_TIME_ELAPSED = 0x88BF;
const int GL_TIMESTAMP = 0x8E28;
const int GL_INT_2_10_10_10_REV = 0x8D9F;
//GL_VERSION_4_0
const int GL_VERSION_4_0 = 1;
const int GL_SAMPLE_SHADING = 0x8C36;
const int GL_MIN_SAMPLE_SHADING_VALUE = 0x8C37;
const int GL_MIN_PROGRAM_TEXTURE_GATHER_OFFSET = 0x8E5E;
const int GL_MAX_PROGRAM_TEXTURE_GATHER_OFFSET = 0x8E5F;
const int GL_TEXTURE_CUBE_MAP_ARRAY = 0x9009;
const int GL_TEXTURE_BINDING_CUBE_MAP_ARRAY = 0x900A;
const int GL_PROXY_TEXTURE_CUBE_MAP_ARRAY = 0x900B;
const int GL_SAMPLER_CUBE_MAP_ARRAY = 0x900C;
const int GL_SAMPLER_CUBE_MAP_ARRAY_SHADOW = 0x900D;
const int GL_INT_SAMPLER_CUBE_MAP_ARRAY = 0x900E;
const int GL_UNSIGNED_INT_SAMPLER_CUBE_MAP_ARRAY = 0x900F;
const int GL_DRAW_INDIRECT_BUFFER = 0x8F3F;
const int GL_DRAW_INDIRECT_BUFFER_BINDING = 0x8F43;
const int GL_GEOMETRY_SHADER_INVOCATIONS = 0x887F;
const int GL_MAX_GEOMETRY_SHADER_INVOCATIONS = 0x8E5A;
const int GL_MIN_FRAGMENT_INTERPOLATION_OFFSET = 0x8E5B;
const int GL_MAX_FRAGMENT_INTERPOLATION_OFFSET = 0x8E5C;
const int GL_FRAGMENT_INTERPOLATION_OFFSET_BITS = 0x8E5D;
const int GL_MAX_VERTEX_STREAMS = 0x8E71;
const int GL_DOUBLE_VEC2 = 0x8FFC;
const int GL_DOUBLE_VEC3 = 0x8FFD;
const int GL_DOUBLE_VEC4 = 0x8FFE;
const int GL_DOUBLE_MAT2 = 0x8F46;
const int GL_DOUBLE_MAT3 = 0x8F47;
const int GL_DOUBLE_MAT4 = 0x8F48;
const int GL_DOUBLE_MAT2x3 = 0x8F49;
const int GL_DOUBLE_MAT2x4 = 0x8F4A;
const int GL_DOUBLE_MAT3x2 = 0x8F4B;
const int GL_DOUBLE_MAT3x4 = 0x8F4C;
const int GL_DOUBLE_MAT4x2 = 0x8F4D;
const int GL_DOUBLE_MAT4x3 = 0x8F4E;
const int GL_ACTIVE_SUBROUTINES = 0x8DE5;
const int GL_ACTIVE_SUBROUTINE_UNIFORMS = 0x8DE6;
const int GL_ACTIVE_SUBROUTINE_UNIFORM_LOCATIONS = 0x8E47;
const int GL_ACTIVE_SUBROUTINE_MAX_LENGTH = 0x8E48;
const int GL_ACTIVE_SUBROUTINE_UNIFORM_MAX_LENGTH = 0x8E49;
const int GL_MAX_SUBROUTINES = 0x8DE7;
const int GL_MAX_SUBROUTINE_UNIFORM_LOCATIONS = 0x8DE8;
const int GL_NUM_COMPATIBLE_SUBROUTINES = 0x8E4A;
const int GL_COMPATIBLE_SUBROUTINES = 0x8E4B;
const int GL_PATCHES = 0x000E;
const int GL_PATCH_VERTICES = 0x8E72;
const int GL_PATCH_DEFAULT_INNER_LEVEL = 0x8E73;
const int GL_PATCH_DEFAULT_OUTER_LEVEL = 0x8E74;
const int GL_TESS_CONTROL_OUTPUT_VERTICES = 0x8E75;
const int GL_TESS_GEN_MODE = 0x8E76;
const int GL_TESS_GEN_SPACING = 0x8E77;
const int GL_TESS_GEN_VERTEX_ORDER = 0x8E78;
const int GL_TESS_GEN_POINT_MODE = 0x8E79;
const int GL_ISOLINES = 0x8E7A;
const int GL_FRACTIONAL_ODD = 0x8E7B;
const int GL_FRACTIONAL_EVEN = 0x8E7C;
const int GL_MAX_PATCH_VERTICES = 0x8E7D;
const int GL_MAX_TESS_GEN_LEVEL = 0x8E7E;
const int GL_MAX_TESS_CONTROL_UNIFORM_COMPONENTS = 0x8E7F;
const int GL_MAX_TESS_EVALUATION_UNIFORM_COMPONENTS = 0x8E80;
const int GL_MAX_TESS_CONTROL_TEXTURE_IMAGE_UNITS = 0x8E81;
const int GL_MAX_TESS_EVALUATION_TEXTURE_IMAGE_UNITS = 0x8E82;
const int GL_MAX_TESS_CONTROL_OUTPUT_COMPONENTS = 0x8E83;
const int GL_MAX_TESS_PATCH_COMPONENTS = 0x8E84;
const int GL_MAX_TESS_CONTROL_TOTAL_OUTPUT_COMPONENTS = 0x8E85;
const int GL_MAX_TESS_EVALUATION_OUTPUT_COMPONENTS = 0x8E86;
const int GL_MAX_TESS_CONTROL_UNIFORM_BLOCKS = 0x8E89;
const int GL_MAX_TESS_EVALUATION_UNIFORM_BLOCKS = 0x8E8A;
const int GL_MAX_TESS_CONTROL_INPUT_COMPONENTS = 0x886C;
const int GL_MAX_TESS_EVALUATION_INPUT_COMPONENTS = 0x886D;
const int GL_MAX_COMBINED_TESS_CONTROL_UNIFORM_COMPONENTS = 0x8E1E;
const int GL_MAX_COMBINED_TESS_EVALUATION_UNIFORM_COMPONENTS = 0x8E1F;
const int GL_UNIFORM_BLOCK_REFERENCED_BY_TESS_CONTROL_SHADER = 0x84F0;
const int GL_UNIFORM_BLOCK_REFERENCED_BY_TESS_EVALUATION_SHADER = 0x84F1;
const int GL_TESS_EVALUATION_SHADER = 0x8E87;
const int GL_TESS_CONTROL_SHADER = 0x8E88;
const int GL_TRANSFORM_FEEDBACK = 0x8E22;
const int GL_TRANSFORM_FEEDBACK_BUFFER_PAUSED = 0x8E23;
const int GL_TRANSFORM_FEEDBACK_BUFFER_ACTIVE = 0x8E24;
const int GL_TRANSFORM_FEEDBACK_BINDING = 0x8E25;
const int GL_MAX_TRANSFORM_FEEDBACK_BUFFERS = 0x8E70;
//GL_VERSION_4_1
const int GL_VERSION_4_1 = 1;
const int GL_FIXED = 0x140C;
const int GL_IMPLEMENTATION_COLOR_READ_TYPE = 0x8B9A;
const int GL_IMPLEMENTATION_COLOR_READ_FORMAT = 0x8B9B;
const int GL_LOW_FLOAT = 0x8DF0;
const int GL_MEDIUM_FLOAT = 0x8DF1;
const int GL_HIGH_FLOAT = 0x8DF2;
const int GL_LOW_INT = 0x8DF3;
const int GL_MEDIUM_INT = 0x8DF4;
const int GL_HIGH_INT = 0x8DF5;
const int GL_SHADER_COMPILER = 0x8DFA;
const int GL_SHADER_BINARY_FORMATS = 0x8DF8;
const int GL_NUM_SHADER_BINARY_FORMATS = 0x8DF9;
const int GL_MAX_VERTEX_UNIFORM_VECTORS = 0x8DFB;
const int GL_MAX_VARYING_VECTORS = 0x8DFC;
const int GL_MAX_FRAGMENT_UNIFORM_VECTORS = 0x8DFD;
const int GL_RGB565 = 0x8D62;
const int GL_PROGRAM_BINARY_RETRIEVABLE_HINT = 0x8257;
const int GL_PROGRAM_BINARY_LENGTH = 0x8741;
const int GL_NUM_PROGRAM_BINARY_FORMATS = 0x87FE;
const int GL_PROGRAM_BINARY_FORMATS = 0x87FF;
const int GL_VERTEX_SHADER_BIT = 0x00000001;
const int GL_FRAGMENT_SHADER_BIT = 0x00000002;
const int GL_GEOMETRY_SHADER_BIT = 0x00000004;
const int GL_TESS_CONTROL_SHADER_BIT = 0x00000008;
const int GL_TESS_EVALUATION_SHADER_BIT = 0x00000010;
const int GL_ALL_SHADER_BITS = 0xFFFFFFFF;
const int GL_PROGRAM_SEPARABLE = 0x8258;
const int GL_ACTIVE_PROGRAM = 0x8259;
const int GL_PROGRAM_PIPELINE_BINDING = 0x825A;
const int GL_MAX_VIEWPORTS = 0x825B;
const int GL_VIEWPORT_SUBPIXEL_BITS = 0x825C;
const int GL_VIEWPORT_BOUNDS_RANGE = 0x825D;
const int GL_LAYER_PROVOKING_VERTEX = 0x825E;
const int GL_VIEWPORT_INDEX_PROVOKING_VERTEX = 0x825F;
const int GL_UNDEFINED_VERTEX = 0x8260;
//GL_VERSION_4_2
const int GL_VERSION_4_2 = 1;
const int GL_COPY_READ_BUFFER_BINDING = 0x8F36;
const int GL_COPY_WRITE_BUFFER_BINDING = 0x8F37;
const int GL_TRANSFORM_FEEDBACK_ACTIVE = 0x8E24;
const int GL_TRANSFORM_FEEDBACK_PAUSED = 0x8E23;
const int GL_UNPACK_COMPRESSED_BLOCK_WIDTH = 0x9127;
const int GL_UNPACK_COMPRESSED_BLOCK_HEIGHT = 0x9128;
const int GL_UNPACK_COMPRESSED_BLOCK_DEPTH = 0x9129;
const int GL_UNPACK_COMPRESSED_BLOCK_SIZE = 0x912A;
const int GL_PACK_COMPRESSED_BLOCK_WIDTH = 0x912B;
const int GL_PACK_COMPRESSED_BLOCK_HEIGHT = 0x912C;
const int GL_PACK_COMPRESSED_BLOCK_DEPTH = 0x912D;
const int GL_PACK_COMPRESSED_BLOCK_SIZE = 0x912E;
const int GL_NUM_SAMPLE_COUNTS = 0x9380;
const int GL_MIN_MAP_BUFFER_ALIGNMENT = 0x90BC;
const int GL_ATOMIC_COUNTER_BUFFER = 0x92C0;
const int GL_ATOMIC_COUNTER_BUFFER_BINDING = 0x92C1;
const int GL_ATOMIC_COUNTER_BUFFER_START = 0x92C2;
const int GL_ATOMIC_COUNTER_BUFFER_SIZE = 0x92C3;
const int GL_ATOMIC_COUNTER_BUFFER_DATA_SIZE = 0x92C4;
const int GL_ATOMIC_COUNTER_BUFFER_ACTIVE_ATOMIC_COUNTERS = 0x92C5;
const int GL_ATOMIC_COUNTER_BUFFER_ACTIVE_ATOMIC_COUNTER_INDICES = 0x92C6;
const int GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_VERTEX_SHADER = 0x92C7;
const int GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_TESS_CONTROL_SHADER = 0x92C8;
const int GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_TESS_EVALUATION_SHADER =
    0x92C9;
const int GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_GEOMETRY_SHADER = 0x92CA;
const int GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_FRAGMENT_SHADER = 0x92CB;
const int GL_MAX_VERTEX_ATOMIC_COUNTER_BUFFERS = 0x92CC;
const int GL_MAX_TESS_CONTROL_ATOMIC_COUNTER_BUFFERS = 0x92CD;
const int GL_MAX_TESS_EVALUATION_ATOMIC_COUNTER_BUFFERS = 0x92CE;
const int GL_MAX_GEOMETRY_ATOMIC_COUNTER_BUFFERS = 0x92CF;
const int GL_MAX_FRAGMENT_ATOMIC_COUNTER_BUFFERS = 0x92D0;
const int GL_MAX_COMBINED_ATOMIC_COUNTER_BUFFERS = 0x92D1;
const int GL_MAX_VERTEX_ATOMIC_COUNTERS = 0x92D2;
const int GL_MAX_TESS_CONTROL_ATOMIC_COUNTERS = 0x92D3;
const int GL_MAX_TESS_EVALUATION_ATOMIC_COUNTERS = 0x92D4;
const int GL_MAX_GEOMETRY_ATOMIC_COUNTERS = 0x92D5;
const int GL_MAX_FRAGMENT_ATOMIC_COUNTERS = 0x92D6;
const int GL_MAX_COMBINED_ATOMIC_COUNTERS = 0x92D7;
const int GL_MAX_ATOMIC_COUNTER_BUFFER_SIZE = 0x92D8;
const int GL_MAX_ATOMIC_COUNTER_BUFFER_BINDINGS = 0x92DC;
const int GL_ACTIVE_ATOMIC_COUNTER_BUFFERS = 0x92D9;
const int GL_UNIFORM_ATOMIC_COUNTER_BUFFER_INDEX = 0x92DA;
const int GL_UNSIGNED_INT_ATOMIC_COUNTER = 0x92DB;
const int GL_VERTEX_ATTRIB_ARRAY_BARRIER_BIT = 0x00000001;
const int GL_ELEMENT_ARRAY_BARRIER_BIT = 0x00000002;
const int GL_UNIFORM_BARRIER_BIT = 0x00000004;
const int GL_TEXTURE_FETCH_BARRIER_BIT = 0x00000008;
const int GL_SHADER_IMAGE_ACCESS_BARRIER_BIT = 0x00000020;
const int GL_COMMAND_BARRIER_BIT = 0x00000040;
const int GL_PIXEL_BUFFER_BARRIER_BIT = 0x00000080;
const int GL_TEXTURE_UPDATE_BARRIER_BIT = 0x00000100;
const int GL_BUFFER_UPDATE_BARRIER_BIT = 0x00000200;
const int GL_FRAMEBUFFER_BARRIER_BIT = 0x00000400;
const int GL_TRANSFORM_FEEDBACK_BARRIER_BIT = 0x00000800;
const int GL_ATOMIC_COUNTER_BARRIER_BIT = 0x00001000;
const int GL_ALL_BARRIER_BITS = 0xFFFFFFFF;
const int GL_MAX_IMAGE_UNITS = 0x8F38;
const int GL_MAX_COMBINED_IMAGE_UNITS_AND_FRAGMENT_OUTPUTS = 0x8F39;
const int GL_IMAGE_BINDING_NAME = 0x8F3A;
const int GL_IMAGE_BINDING_LEVEL = 0x8F3B;
const int GL_IMAGE_BINDING_LAYERED = 0x8F3C;
const int GL_IMAGE_BINDING_LAYER = 0x8F3D;
const int GL_IMAGE_BINDING_ACCESS = 0x8F3E;
const int GL_IMAGE_1D = 0x904C;
const int GL_IMAGE_2D = 0x904D;
const int GL_IMAGE_3D = 0x904E;
const int GL_IMAGE_2D_RECT = 0x904F;
const int GL_IMAGE_CUBE = 0x9050;
const int GL_IMAGE_BUFFER = 0x9051;
const int GL_IMAGE_1D_ARRAY = 0x9052;
const int GL_IMAGE_2D_ARRAY = 0x9053;
const int GL_IMAGE_CUBE_MAP_ARRAY = 0x9054;
const int GL_IMAGE_2D_MULTISAMPLE = 0x9055;
const int GL_IMAGE_2D_MULTISAMPLE_ARRAY = 0x9056;
const int GL_INT_IMAGE_1D = 0x9057;
const int GL_INT_IMAGE_2D = 0x9058;
const int GL_INT_IMAGE_3D = 0x9059;
const int GL_INT_IMAGE_2D_RECT = 0x905A;
const int GL_INT_IMAGE_CUBE = 0x905B;
const int GL_INT_IMAGE_BUFFER = 0x905C;
const int GL_INT_IMAGE_1D_ARRAY = 0x905D;
const int GL_INT_IMAGE_2D_ARRAY = 0x905E;
const int GL_INT_IMAGE_CUBE_MAP_ARRAY = 0x905F;
const int GL_INT_IMAGE_2D_MULTISAMPLE = 0x9060;
const int GL_INT_IMAGE_2D_MULTISAMPLE_ARRAY = 0x9061;
const int GL_UNSIGNED_INT_IMAGE_1D = 0x9062;
const int GL_UNSIGNED_INT_IMAGE_2D = 0x9063;
const int GL_UNSIGNED_INT_IMAGE_3D = 0x9064;
const int GL_UNSIGNED_INT_IMAGE_2D_RECT = 0x9065;
const int GL_UNSIGNED_INT_IMAGE_CUBE = 0x9066;
const int GL_UNSIGNED_INT_IMAGE_BUFFER = 0x9067;
const int GL_UNSIGNED_INT_IMAGE_1D_ARRAY = 0x9068;
const int GL_UNSIGNED_INT_IMAGE_2D_ARRAY = 0x9069;
const int GL_UNSIGNED_INT_IMAGE_CUBE_MAP_ARRAY = 0x906A;
const int GL_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE = 0x906B;
const int GL_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE_ARRAY = 0x906C;
const int GL_MAX_IMAGE_SAMPLES = 0x906D;
const int GL_IMAGE_BINDING_FORMAT = 0x906E;
const int GL_IMAGE_FORMAT_COMPATIBILITY_TYPE = 0x90C7;
const int GL_IMAGE_FORMAT_COMPATIBILITY_BY_SIZE = 0x90C8;
const int GL_IMAGE_FORMAT_COMPATIBILITY_BY_CLASS = 0x90C9;
const int GL_MAX_VERTEX_IMAGE_UNIFORMS = 0x90CA;
const int GL_MAX_TESS_CONTROL_IMAGE_UNIFORMS = 0x90CB;
const int GL_MAX_TESS_EVALUATION_IMAGE_UNIFORMS = 0x90CC;
const int GL_MAX_GEOMETRY_IMAGE_UNIFORMS = 0x90CD;
const int GL_MAX_FRAGMENT_IMAGE_UNIFORMS = 0x90CE;
const int GL_MAX_COMBINED_IMAGE_UNIFORMS = 0x90CF;
const int GL_COMPRESSED_RGBA_BPTC_UNORM = 0x8E8C;
const int GL_COMPRESSED_SRGB_ALPHA_BPTC_UNORM = 0x8E8D;
const int GL_COMPRESSED_RGB_BPTC_SIGNED_FLOAT = 0x8E8E;
const int GL_COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT = 0x8E8F;
const int GL_TEXTURE_IMMUTABLE_FORMAT = 0x912F;
//GL_VERSION_4_3
const int GL_VERSION_4_3 = 1;
const int GL_NUM_SHADING_LANGUAGE_VERSIONS = 0x82E9;
const int GL_VERTEX_ATTRIB_ARRAY_LONG = 0x874E;
const int GL_COMPRESSED_RGB8_ETC2 = 0x9274;
const int GL_COMPRESSED_SRGB8_ETC2 = 0x9275;
const int GL_COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2 = 0x9276;
const int GL_COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2 = 0x9277;
const int GL_COMPRESSED_RGBA8_ETC2_EAC = 0x9278;
const int GL_COMPRESSED_SRGB8_ALPHA8_ETC2_EAC = 0x9279;
const int GL_COMPRESSED_R11_EAC = 0x9270;
const int GL_COMPRESSED_SIGNED_R11_EAC = 0x9271;
const int GL_COMPRESSED_RG11_EAC = 0x9272;
const int GL_COMPRESSED_SIGNED_RG11_EAC = 0x9273;
const int GL_PRIMITIVE_RESTART_FIXED_INDEX = 0x8D69;
const int GL_ANY_SAMPLES_PASSED_CONSERVATIVE = 0x8D6A;
const int GL_MAX_ELEMENT_INDEX = 0x8D6B;
const int GL_COMPUTE_SHADER = 0x91B9;
const int GL_MAX_COMPUTE_UNIFORM_BLOCKS = 0x91BB;
const int GL_MAX_COMPUTE_TEXTURE_IMAGE_UNITS = 0x91BC;
const int GL_MAX_COMPUTE_IMAGE_UNIFORMS = 0x91BD;
const int GL_MAX_COMPUTE_SHARED_MEMORY_SIZE = 0x8262;
const int GL_MAX_COMPUTE_UNIFORM_COMPONENTS = 0x8263;
const int GL_MAX_COMPUTE_ATOMIC_COUNTER_BUFFERS = 0x8264;
const int GL_MAX_COMPUTE_ATOMIC_COUNTERS = 0x8265;
const int GL_MAX_COMBINED_COMPUTE_UNIFORM_COMPONENTS = 0x8266;
const int GL_MAX_COMPUTE_WORK_GROUP_INVOCATIONS = 0x90EB;
const int GL_MAX_COMPUTE_WORK_GROUP_COUNT = 0x91BE;
const int GL_MAX_COMPUTE_WORK_GROUP_SIZE = 0x91BF;
const int GL_COMPUTE_WORK_GROUP_SIZE = 0x8267;
const int GL_UNIFORM_BLOCK_REFERENCED_BY_COMPUTE_SHADER = 0x90EC;
const int GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_COMPUTE_SHADER = 0x90ED;
const int GL_DISPATCH_INDIRECT_BUFFER = 0x90EE;
const int GL_DISPATCH_INDIRECT_BUFFER_BINDING = 0x90EF;
const int GL_COMPUTE_SHADER_BIT = 0x00000020;
const int GL_DEBUG_OUTPUT_SYNCHRONOUS = 0x8242;
const int GL_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH = 0x8243;
const int GL_DEBUG_CALLBACK_FUNCTION = 0x8244;
const int GL_DEBUG_CALLBACK_USER_PARAM = 0x8245;
const int GL_DEBUG_SOURCE_API = 0x8246;
const int GL_DEBUG_SOURCE_WINDOW_SYSTEM = 0x8247;
const int GL_DEBUG_SOURCE_SHADER_COMPILER = 0x8248;
const int GL_DEBUG_SOURCE_THIRD_PARTY = 0x8249;
const int GL_DEBUG_SOURCE_APPLICATION = 0x824A;
const int GL_DEBUG_SOURCE_OTHER = 0x824B;
const int GL_DEBUG_TYPE_ERROR = 0x824C;
const int GL_DEBUG_TYPE_DEPRECATED_BEHAVIOR = 0x824D;
const int GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR = 0x824E;
const int GL_DEBUG_TYPE_PORTABILITY = 0x824F;
const int GL_DEBUG_TYPE_PERFORMANCE = 0x8250;
const int GL_DEBUG_TYPE_OTHER = 0x8251;
const int GL_MAX_DEBUG_MESSAGE_LENGTH = 0x9143;
const int GL_MAX_DEBUG_LOGGED_MESSAGES = 0x9144;
const int GL_DEBUG_LOGGED_MESSAGES = 0x9145;
const int GL_DEBUG_SEVERITY_HIGH = 0x9146;
const int GL_DEBUG_SEVERITY_MEDIUM = 0x9147;
const int GL_DEBUG_SEVERITY_LOW = 0x9148;
const int GL_DEBUG_TYPE_MARKER = 0x8268;
const int GL_DEBUG_TYPE_PUSH_GROUP = 0x8269;
const int GL_DEBUG_TYPE_POP_GROUP = 0x826A;
const int GL_DEBUG_SEVERITY_NOTIFICATION = 0x826B;
const int GL_MAX_DEBUG_GROUP_STACK_DEPTH = 0x826C;
const int GL_DEBUG_GROUP_STACK_DEPTH = 0x826D;
const int GL_BUFFER = 0x82E0;
const int GL_SHADER = 0x82E1;
const int GL_PROGRAM = 0x82E2;
const int GL_QUERY = 0x82E3;
const int GL_PROGRAM_PIPELINE = 0x82E4;
const int GL_SAMPLER = 0x82E6;
const int GL_MAX_LABEL_LENGTH = 0x82E8;
const int GL_DEBUG_OUTPUT = 0x92E0;
const int GL_CONTEXT_FLAG_DEBUG_BIT = 0x00000002;
const int GL_MAX_UNIFORM_LOCATIONS = 0x826E;
const int GL_FRAMEBUFFER_DEFAULT_WIDTH = 0x9310;
const int GL_FRAMEBUFFER_DEFAULT_HEIGHT = 0x9311;
const int GL_FRAMEBUFFER_DEFAULT_LAYERS = 0x9312;
const int GL_FRAMEBUFFER_DEFAULT_SAMPLES = 0x9313;
const int GL_FRAMEBUFFER_DEFAULT_FIXED_SAMPLE_LOCATIONS = 0x9314;
const int GL_MAX_FRAMEBUFFER_WIDTH = 0x9315;
const int GL_MAX_FRAMEBUFFER_HEIGHT = 0x9316;
const int GL_MAX_FRAMEBUFFER_LAYERS = 0x9317;
const int GL_MAX_FRAMEBUFFER_SAMPLES = 0x9318;
const int GL_INTERNALFORMAT_SUPPORTED = 0x826F;
const int GL_INTERNALFORMAT_PREFERRED = 0x8270;
const int GL_INTERNALFORMAT_RED_SIZE = 0x8271;
const int GL_INTERNALFORMAT_GREEN_SIZE = 0x8272;
const int GL_INTERNALFORMAT_BLUE_SIZE = 0x8273;
const int GL_INTERNALFORMAT_ALPHA_SIZE = 0x8274;
const int GL_INTERNALFORMAT_DEPTH_SIZE = 0x8275;
const int GL_INTERNALFORMAT_STENCIL_SIZE = 0x8276;
const int GL_INTERNALFORMAT_SHARED_SIZE = 0x8277;
const int GL_INTERNALFORMAT_RED_TYPE = 0x8278;
const int GL_INTERNALFORMAT_GREEN_TYPE = 0x8279;
const int GL_INTERNALFORMAT_BLUE_TYPE = 0x827A;
const int GL_INTERNALFORMAT_ALPHA_TYPE = 0x827B;
const int GL_INTERNALFORMAT_DEPTH_TYPE = 0x827C;
const int GL_INTERNALFORMAT_STENCIL_TYPE = 0x827D;
const int GL_MAX_WIDTH = 0x827E;
const int GL_MAX_HEIGHT = 0x827F;
const int GL_MAX_DEPTH = 0x8280;
const int GL_MAX_LAYERS = 0x8281;
const int GL_MAX_COMBINED_DIMENSIONS = 0x8282;
const int GL_COLOR_COMPONENTS = 0x8283;
const int GL_DEPTH_COMPONENTS = 0x8284;
const int GL_STENCIL_COMPONENTS = 0x8285;
const int GL_COLOR_RENDERABLE = 0x8286;
const int GL_DEPTH_RENDERABLE = 0x8287;
const int GL_STENCIL_RENDERABLE = 0x8288;
const int GL_FRAMEBUFFER_RENDERABLE = 0x8289;
const int GL_FRAMEBUFFER_RENDERABLE_LAYERED = 0x828A;
const int GL_FRAMEBUFFER_BLEND = 0x828B;
const int GL_READ_PIXELS = 0x828C;
const int GL_READ_PIXELS_FORMAT = 0x828D;
const int GL_READ_PIXELS_TYPE = 0x828E;
const int GL_TEXTURE_IMAGE_FORMAT = 0x828F;
const int GL_TEXTURE_IMAGE_TYPE = 0x8290;
const int GL_GET_TEXTURE_IMAGE_FORMAT = 0x8291;
const int GL_GET_TEXTURE_IMAGE_TYPE = 0x8292;
const int GL_MIPMAP = 0x8293;
const int GL_MANUAL_GENERATE_MIPMAP = 0x8294;
const int GL_AUTO_GENERATE_MIPMAP = 0x8295;
const int GL_COLOR_ENCODING = 0x8296;
const int GL_SRGB_READ = 0x8297;
const int GL_SRGB_WRITE = 0x8298;
const int GL_FILTER = 0x829A;
const int GL_VERTEX_TEXTURE = 0x829B;
const int GL_TESS_CONTROL_TEXTURE = 0x829C;
const int GL_TESS_EVALUATION_TEXTURE = 0x829D;
const int GL_GEOMETRY_TEXTURE = 0x829E;
const int GL_FRAGMENT_TEXTURE = 0x829F;
const int GL_COMPUTE_TEXTURE = 0x82A0;
const int GL_TEXTURE_SHADOW = 0x82A1;
const int GL_TEXTURE_GATHER = 0x82A2;
const int GL_TEXTURE_GATHER_SHADOW = 0x82A3;
const int GL_SHADER_IMAGE_LOAD = 0x82A4;
const int GL_SHADER_IMAGE_STORE = 0x82A5;
const int GL_SHADER_IMAGE_ATOMIC = 0x82A6;
const int GL_IMAGE_TEXEL_SIZE = 0x82A7;
const int GL_IMAGE_COMPATIBILITY_CLASS = 0x82A8;
const int GL_IMAGE_PIXEL_FORMAT = 0x82A9;
const int GL_IMAGE_PIXEL_TYPE = 0x82AA;
const int GL_SIMULTANEOUS_TEXTURE_AND_DEPTH_TEST = 0x82AC;
const int GL_SIMULTANEOUS_TEXTURE_AND_STENCIL_TEST = 0x82AD;
const int GL_SIMULTANEOUS_TEXTURE_AND_DEPTH_WRITE = 0x82AE;
const int GL_SIMULTANEOUS_TEXTURE_AND_STENCIL_WRITE = 0x82AF;
const int GL_TEXTURE_COMPRESSED_BLOCK_WIDTH = 0x82B1;
const int GL_TEXTURE_COMPRESSED_BLOCK_HEIGHT = 0x82B2;
const int GL_TEXTURE_COMPRESSED_BLOCK_SIZE = 0x82B3;
const int GL_CLEAR_BUFFER = 0x82B4;
const int GL_TEXTURE_VIEW = 0x82B5;
const int GL_VIEW_COMPATIBILITY_CLASS = 0x82B6;
const int GL_FULL_SUPPORT = 0x82B7;
const int GL_CAVEAT_SUPPORT = 0x82B8;
const int GL_IMAGE_CLASS_4_X_32 = 0x82B9;
const int GL_IMAGE_CLASS_2_X_32 = 0x82BA;
const int GL_IMAGE_CLASS_1_X_32 = 0x82BB;
const int GL_IMAGE_CLASS_4_X_16 = 0x82BC;
const int GL_IMAGE_CLASS_2_X_16 = 0x82BD;
const int GL_IMAGE_CLASS_1_X_16 = 0x82BE;
const int GL_IMAGE_CLASS_4_X_8 = 0x82BF;
const int GL_IMAGE_CLASS_2_X_8 = 0x82C0;
const int GL_IMAGE_CLASS_1_X_8 = 0x82C1;
const int GL_IMAGE_CLASS_11_11_10 = 0x82C2;
const int GL_IMAGE_CLASS_10_10_10_2 = 0x82C3;
const int GL_VIEW_CLASS_128_BITS = 0x82C4;
const int GL_VIEW_CLASS_96_BITS = 0x82C5;
const int GL_VIEW_CLASS_64_BITS = 0x82C6;
const int GL_VIEW_CLASS_48_BITS = 0x82C7;
const int GL_VIEW_CLASS_32_BITS = 0x82C8;
const int GL_VIEW_CLASS_24_BITS = 0x82C9;
const int GL_VIEW_CLASS_16_BITS = 0x82CA;
const int GL_VIEW_CLASS_8_BITS = 0x82CB;
const int GL_VIEW_CLASS_S3TC_DXT1_RGB = 0x82CC;
const int GL_VIEW_CLASS_S3TC_DXT1_RGBA = 0x82CD;
const int GL_VIEW_CLASS_S3TC_DXT3_RGBA = 0x82CE;
const int GL_VIEW_CLASS_S3TC_DXT5_RGBA = 0x82CF;
const int GL_VIEW_CLASS_RGTC1_RED = 0x82D0;
const int GL_VIEW_CLASS_RGTC2_RG = 0x82D1;
const int GL_VIEW_CLASS_BPTC_UNORM = 0x82D2;
const int GL_VIEW_CLASS_BPTC_FLOAT = 0x82D3;
const int GL_UNIFORM = 0x92E1;
const int GL_UNIFORM_BLOCK = 0x92E2;
const int GL_PROGRAM_INPUT = 0x92E3;
const int GL_PROGRAM_OUTPUT = 0x92E4;
const int GL_BUFFER_VARIABLE = 0x92E5;
const int GL_SHADER_STORAGE_BLOCK = 0x92E6;
const int GL_VERTEX_SUBROUTINE = 0x92E8;
const int GL_TESS_CONTROL_SUBROUTINE = 0x92E9;
const int GL_TESS_EVALUATION_SUBROUTINE = 0x92EA;
const int GL_GEOMETRY_SUBROUTINE = 0x92EB;
const int GL_FRAGMENT_SUBROUTINE = 0x92EC;
const int GL_COMPUTE_SUBROUTINE = 0x92ED;
const int GL_VERTEX_SUBROUTINE_UNIFORM = 0x92EE;
const int GL_TESS_CONTROL_SUBROUTINE_UNIFORM = 0x92EF;
const int GL_TESS_EVALUATION_SUBROUTINE_UNIFORM = 0x92F0;
const int GL_GEOMETRY_SUBROUTINE_UNIFORM = 0x92F1;
const int GL_FRAGMENT_SUBROUTINE_UNIFORM = 0x92F2;
const int GL_COMPUTE_SUBROUTINE_UNIFORM = 0x92F3;
const int GL_TRANSFORM_FEEDBACK_VARYING = 0x92F4;
const int GL_ACTIVE_RESOURCES = 0x92F5;
const int GL_MAX_NAME_LENGTH = 0x92F6;
const int GL_MAX_NUM_ACTIVE_VARIABLES = 0x92F7;
const int GL_MAX_NUM_COMPATIBLE_SUBROUTINES = 0x92F8;
const int GL_NAME_LENGTH = 0x92F9;
const int GL_TYPE = 0x92FA;
const int GL_ARRAY_SIZE = 0x92FB;
const int GL_OFFSET = 0x92FC;
const int GL_BLOCK_INDEX = 0x92FD;
const int GL_ARRAY_STRIDE = 0x92FE;
const int GL_MATRIX_STRIDE = 0x92FF;
const int GL_IS_ROW_MAJOR = 0x9300;
const int GL_ATOMIC_COUNTER_BUFFER_INDEX = 0x9301;
const int GL_BUFFER_BINDING = 0x9302;
const int GL_BUFFER_DATA_SIZE = 0x9303;
const int GL_NUM_ACTIVE_VARIABLES = 0x9304;
const int GL_ACTIVE_VARIABLES = 0x9305;
const int GL_REFERENCED_BY_VERTEX_SHADER = 0x9306;
const int GL_REFERENCED_BY_TESS_CONTROL_SHADER = 0x9307;
const int GL_REFERENCED_BY_TESS_EVALUATION_SHADER = 0x9308;
const int GL_REFERENCED_BY_GEOMETRY_SHADER = 0x9309;
const int GL_REFERENCED_BY_FRAGMENT_SHADER = 0x930A;
const int GL_REFERENCED_BY_COMPUTE_SHADER = 0x930B;
const int GL_TOP_LEVEL_ARRAY_SIZE = 0x930C;
const int GL_TOP_LEVEL_ARRAY_STRIDE = 0x930D;
const int GL_LOCATION = 0x930E;
const int GL_LOCATION_INDEX = 0x930F;
const int GL_IS_PER_PATCH = 0x92E7;
const int GL_SHADER_STORAGE_BUFFER = 0x90D2;
const int GL_SHADER_STORAGE_BUFFER_BINDING = 0x90D3;
const int GL_SHADER_STORAGE_BUFFER_START = 0x90D4;
const int GL_SHADER_STORAGE_BUFFER_SIZE = 0x90D5;
const int GL_MAX_VERTEX_SHADER_STORAGE_BLOCKS = 0x90D6;
const int GL_MAX_GEOMETRY_SHADER_STORAGE_BLOCKS = 0x90D7;
const int GL_MAX_TESS_CONTROL_SHADER_STORAGE_BLOCKS = 0x90D8;
const int GL_MAX_TESS_EVALUATION_SHADER_STORAGE_BLOCKS = 0x90D9;
const int GL_MAX_FRAGMENT_SHADER_STORAGE_BLOCKS = 0x90DA;
const int GL_MAX_COMPUTE_SHADER_STORAGE_BLOCKS = 0x90DB;
const int GL_MAX_COMBINED_SHADER_STORAGE_BLOCKS = 0x90DC;
const int GL_MAX_SHADER_STORAGE_BUFFER_BINDINGS = 0x90DD;
const int GL_MAX_SHADER_STORAGE_BLOCK_SIZE = 0x90DE;
const int GL_SHADER_STORAGE_BUFFER_OFFSET_ALIGNMENT = 0x90DF;
const int GL_SHADER_STORAGE_BARRIER_BIT = 0x00002000;
const int GL_MAX_COMBINED_SHADER_OUTPUT_RESOURCES = 0x8F39;
const int GL_DEPTH_STENCIL_TEXTURE_MODE = 0x90EA;
const int GL_TEXTURE_BUFFER_OFFSET = 0x919D;
const int GL_TEXTURE_BUFFER_SIZE = 0x919E;
const int GL_TEXTURE_BUFFER_OFFSET_ALIGNMENT = 0x919F;
const int GL_TEXTURE_VIEW_MIN_LEVEL = 0x82DB;
const int GL_TEXTURE_VIEW_NUM_LEVELS = 0x82DC;
const int GL_TEXTURE_VIEW_MIN_LAYER = 0x82DD;
const int GL_TEXTURE_VIEW_NUM_LAYERS = 0x82DE;
const int GL_TEXTURE_IMMUTABLE_LEVELS = 0x82DF;
const int GL_VERTEX_ATTRIB_BINDING = 0x82D4;
const int GL_VERTEX_ATTRIB_RELATIVE_OFFSET = 0x82D5;
const int GL_VERTEX_BINDING_DIVISOR = 0x82D6;
const int GL_VERTEX_BINDING_OFFSET = 0x82D7;
const int GL_VERTEX_BINDING_STRIDE = 0x82D8;
const int GL_MAX_VERTEX_ATTRIB_RELATIVE_OFFSET = 0x82D9;
const int GL_MAX_VERTEX_ATTRIB_BINDINGS = 0x82DA;
const int GL_VERTEX_BINDING_BUFFER = 0x8F4F;
//GL_VERSION_4_4
const int GL_VERSION_4_4 = 1;
const int GL_MAX_VERTEX_ATTRIB_STRIDE = 0x82E5;
const int GL_PRIMITIVE_RESTART_FOR_PATCHES_SUPPORTED = 0x8221;
const int GL_TEXTURE_BUFFER_BINDING = 0x8C2A;
const int GL_MAP_PERSISTENT_BIT = 0x0040;
const int GL_MAP_COHERENT_BIT = 0x0080;
const int GL_DYNAMIC_STORAGE_BIT = 0x0100;
const int GL_CLIENT_STORAGE_BIT = 0x0200;
const int GL_CLIENT_MAPPED_BUFFER_BARRIER_BIT = 0x00004000;
const int GL_BUFFER_IMMUTABLE_STORAGE = 0x821F;
const int GL_BUFFER_STORAGE_FLAGS = 0x8220;
const int GL_CLEAR_TEXTURE = 0x9365;
const int GL_LOCATION_COMPONENT = 0x934A;
const int GL_TRANSFORM_FEEDBACK_BUFFER_INDEX = 0x934B;
const int GL_TRANSFORM_FEEDBACK_BUFFER_STRIDE = 0x934C;
const int GL_QUERY_BUFFER = 0x9192;
const int GL_QUERY_BUFFER_BARRIER_BIT = 0x00008000;
const int GL_QUERY_BUFFER_BINDING = 0x9193;
const int GL_QUERY_RESULT_NO_WAIT = 0x9194;
const int GL_MIRROR_CLAMP_TO_EDGE = 0x8743;
//GL_VERSION_4_5
const int GL_VERSION_4_5 = 1;
const int GL_CONTEXT_LOST = 0x0507;
const int GL_NEGATIVE_ONE_TO_ONE = 0x935E;
const int GL_ZERO_TO_ONE = 0x935F;
const int GL_CLIP_ORIGIN = 0x935C;
const int GL_CLIP_DEPTH_MODE = 0x935D;
const int GL_QUERY_WAIT_INVERTED = 0x8E17;
const int GL_QUERY_NO_WAIT_INVERTED = 0x8E18;
const int GL_QUERY_BY_REGION_WAIT_INVERTED = 0x8E19;
const int GL_QUERY_BY_REGION_NO_WAIT_INVERTED = 0x8E1A;
const int GL_MAX_CULL_DISTANCES = 0x82F9;
const int GL_MAX_COMBINED_CLIP_AND_CULL_DISTANCES = 0x82FA;
const int GL_TEXTURE_TARGET = 0x1006;
const int GL_QUERY_TARGET = 0x82EA;
const int GL_GUILTY_CONTEXT_RESET = 0x8253;
const int GL_INNOCENT_CONTEXT_RESET = 0x8254;
const int GL_UNKNOWN_CONTEXT_RESET = 0x8255;
const int GL_RESET_NOTIFICATION_STRATEGY = 0x8256;
const int GL_LOSE_CONTEXT_ON_RESET = 0x8252;
const int GL_NO_RESET_NOTIFICATION = 0x8261;
const int GL_CONTEXT_FLAG_ROBUST_ACCESS_BIT = 0x00000004;
const int GL_CONTEXT_RELEASE_BEHAVIOR = 0x82FB;
const int GL_CONTEXT_RELEASE_BEHAVIOR_FLUSH = 0x82FC;
//GL_VERSION_4_6
const int GL_VERSION_4_6 = 1;
const int GL_SHADER_BINARY_FORMAT_SPIR_V = 0x9551;
const int GL_SPIR_V_BINARY = 0x9552;
const int GL_PARAMETER_BUFFER = 0x80EE;
const int GL_PARAMETER_BUFFER_BINDING = 0x80EF;
const int GL_CONTEXT_FLAG_NO_ERROR_BIT = 0x00000008;
const int GL_VERTICES_SUBMITTED = 0x82EE;
const int GL_PRIMITIVES_SUBMITTED = 0x82EF;
const int GL_VERTEX_SHADER_INVOCATIONS = 0x82F0;
const int GL_TESS_CONTROL_SHADER_PATCHES = 0x82F1;
const int GL_TESS_EVALUATION_SHADER_INVOCATIONS = 0x82F2;
const int GL_GEOMETRY_SHADER_PRIMITIVES_EMITTED = 0x82F3;
const int GL_FRAGMENT_SHADER_INVOCATIONS = 0x82F4;
const int GL_COMPUTE_SHADER_INVOCATIONS = 0x82F5;
const int GL_CLIPPING_INPUT_PRIMITIVES = 0x82F6;
const int GL_CLIPPING_OUTPUT_PRIMITIVES = 0x82F7;
const int GL_POLYGON_OFFSET_CLAMP = 0x8E1B;
const int GL_SPIR_V_EXTENSIONS = 0x9553;
const int GL_NUM_SPIR_V_EXTENSIONS = 0x9554;
const int GL_TEXTURE_MAX_ANISOTROPY = 0x84FE;
const int GL_MAX_TEXTURE_MAX_ANISOTROPY = 0x84FF;
const int GL_TRANSFORM_FEEDBACK_OVERFLOW = 0x82EC;
const int GL_TRANSFORM_FEEDBACK_STREAM_OVERFLOW = 0x82ED;
//GL_ARB_ES2_compatibility
const int GL_ARB_ES2_compatibility = 1;
//GL_ARB_ES3_1_compatibility
const int GL_ARB_ES3_1_compatibility = 1;
//GL_ARB_ES3_2_compatibility
const int GL_ARB_ES3_2_compatibility = 1;
const int GL_PRIMITIVE_BOUNDING_BOX_ARB = 0x92BE;
const int GL_MULTISAMPLE_LINE_WIDTH_RANGE_ARB = 0x9381;
const int GL_MULTISAMPLE_LINE_WIDTH_GRANULARITY_ARB = 0x9382;
//GL_ARB_ES3_compatibility
const int GL_ARB_ES3_compatibility = 1;
//GL_ARB_arrays_of_arrays
const int GL_ARB_arrays_of_arrays = 1;
//GL_ARB_base_instance
const int GL_ARB_base_instance = 1;
//GL_ARB_bindless_texture
const int GL_ARB_bindless_texture = 1;
const int GL_UNSIGNED_INT64_ARB = 0x140F;
//GL_ARB_blend_func_extended
const int GL_ARB_blend_func_extended = 1;
//GL_ARB_buffer_storage
const int GL_ARB_buffer_storage = 1;
//GL_ARB_cl_event
const int GL_ARB_cl_event = 1;
const int GL_SYNC_CL_EVENT_ARB = 0x8240;
const int GL_SYNC_CL_EVENT_COMPLETE_ARB = 0x8241;
//GL_ARB_clear_buffer_object
const int GL_ARB_clear_buffer_object = 1;
//GL_ARB_clear_texture
const int GL_ARB_clear_texture = 1;
//GL_ARB_clip_control
const int GL_ARB_clip_control = 1;
//GL_ARB_compressed_texture_pixel_storage
const int GL_ARB_compressed_texture_pixel_storage = 1;
//GL_ARB_compute_shader
const int GL_ARB_compute_shader = 1;
//GL_ARB_compute_variable_group_size
const int GL_ARB_compute_variable_group_size = 1;
const int GL_MAX_COMPUTE_VARIABLE_GROUP_INVOCATIONS_ARB = 0x9344;
const int GL_MAX_COMPUTE_FIXED_GROUP_INVOCATIONS_ARB = 0x90EB;
const int GL_MAX_COMPUTE_VARIABLE_GROUP_SIZE_ARB = 0x9345;
const int GL_MAX_COMPUTE_FIXED_GROUP_SIZE_ARB = 0x91BF;
//GL_ARB_conditional_render_inverted
const int GL_ARB_conditional_render_inverted = 1;
//GL_ARB_conservative_depth
const int GL_ARB_conservative_depth = 1;
//GL_ARB_copy_buffer
const int GL_ARB_copy_buffer = 1;
//GL_ARB_copy_image
const int GL_ARB_copy_image = 1;
//GL_ARB_cull_distance
const int GL_ARB_cull_distance = 1;
//GL_ARB_debug_output
const int GL_ARB_debug_output = 1;
const int GL_DEBUG_OUTPUT_SYNCHRONOUS_ARB = 0x8242;
const int GL_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH_ARB = 0x8243;
const int GL_DEBUG_CALLBACK_FUNCTION_ARB = 0x8244;
const int GL_DEBUG_CALLBACK_USER_PARAM_ARB = 0x8245;
const int GL_DEBUG_SOURCE_API_ARB = 0x8246;
const int GL_DEBUG_SOURCE_WINDOW_SYSTEM_ARB = 0x8247;
const int GL_DEBUG_SOURCE_SHADER_COMPILER_ARB = 0x8248;
const int GL_DEBUG_SOURCE_THIRD_PARTY_ARB = 0x8249;
const int GL_DEBUG_SOURCE_APPLICATION_ARB = 0x824A;
const int GL_DEBUG_SOURCE_OTHER_ARB = 0x824B;
const int GL_DEBUG_TYPE_ERROR_ARB = 0x824C;
const int GL_DEBUG_TYPE_DEPRECATED_BEHAVIOR_ARB = 0x824D;
const int GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR_ARB = 0x824E;
const int GL_DEBUG_TYPE_PORTABILITY_ARB = 0x824F;
const int GL_DEBUG_TYPE_PERFORMANCE_ARB = 0x8250;
const int GL_DEBUG_TYPE_OTHER_ARB = 0x8251;
const int GL_MAX_DEBUG_MESSAGE_LENGTH_ARB = 0x9143;
const int GL_MAX_DEBUG_LOGGED_MESSAGES_ARB = 0x9144;
const int GL_DEBUG_LOGGED_MESSAGES_ARB = 0x9145;
const int GL_DEBUG_SEVERITY_HIGH_ARB = 0x9146;
const int GL_DEBUG_SEVERITY_MEDIUM_ARB = 0x9147;
const int GL_DEBUG_SEVERITY_LOW_ARB = 0x9148;
//GL_ARB_depth_buffer_float
const int GL_ARB_depth_buffer_float = 1;
//GL_ARB_depth_clamp
const int GL_ARB_depth_clamp = 1;
//GL_ARB_derivative_control
const int GL_ARB_derivative_control = 1;
//GL_ARB_direct_state_access
const int GL_ARB_direct_state_access = 1;
//GL_ARB_draw_buffers_blend
const int GL_ARB_draw_buffers_blend = 1;
//GL_ARB_draw_elements_base_vertex
const int GL_ARB_draw_elements_base_vertex = 1;
//GL_ARB_draw_indirect
const int GL_ARB_draw_indirect = 1;
//GL_ARB_draw_instanced
const int GL_ARB_draw_instanced = 1;
//GL_ARB_enhanced_layouts
const int GL_ARB_enhanced_layouts = 1;
//GL_ARB_explicit_attrib_location
const int GL_ARB_explicit_attrib_location = 1;
//GL_ARB_explicit_uniform_location
const int GL_ARB_explicit_uniform_location = 1;
//GL_ARB_fragment_coord_conventions
const int GL_ARB_fragment_coord_conventions = 1;
//GL_ARB_fragment_layer_viewport
const int GL_ARB_fragment_layer_viewport = 1;
//GL_ARB_fragment_shader_interlock
const int GL_ARB_fragment_shader_interlock = 1;
//GL_ARB_framebuffer_no_attachments
const int GL_ARB_framebuffer_no_attachments = 1;
//GL_ARB_framebuffer_object
const int GL_ARB_framebuffer_object = 1;
//GL_ARB_framebuffer_sRGB
const int GL_ARB_framebuffer_sRGB = 1;
//GL_ARB_geometry_shader4
const int GL_ARB_geometry_shader4 = 1;
const int GL_LINES_ADJACENCY_ARB = 0x000A;
const int GL_LINE_STRIP_ADJACENCY_ARB = 0x000B;
const int GL_TRIANGLES_ADJACENCY_ARB = 0x000C;
const int GL_TRIANGLE_STRIP_ADJACENCY_ARB = 0x000D;
const int GL_PROGRAM_POINT_SIZE_ARB = 0x8642;
const int GL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS_ARB = 0x8C29;
const int GL_FRAMEBUFFER_ATTACHMENT_LAYERED_ARB = 0x8DA7;
const int GL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS_ARB = 0x8DA8;
const int GL_FRAMEBUFFER_INCOMPLETE_LAYER_COUNT_ARB = 0x8DA9;
const int GL_GEOMETRY_SHADER_ARB = 0x8DD9;
const int GL_GEOMETRY_VERTICES_OUT_ARB = 0x8DDA;
const int GL_GEOMETRY_INPUT_TYPE_ARB = 0x8DDB;
const int GL_GEOMETRY_OUTPUT_TYPE_ARB = 0x8DDC;
const int GL_MAX_GEOMETRY_VARYING_COMPONENTS_ARB = 0x8DDD;
const int GL_MAX_VERTEX_VARYING_COMPONENTS_ARB = 0x8DDE;
const int GL_MAX_GEOMETRY_UNIFORM_COMPONENTS_ARB = 0x8DDF;
const int GL_MAX_GEOMETRY_OUTPUT_VERTICES_ARB = 0x8DE0;
const int GL_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS_ARB = 0x8DE1;
//GL_ARB_get_program_binary
const int GL_ARB_get_program_binary = 1;
//GL_ARB_get_texture_sub_image
const int GL_ARB_get_texture_sub_image = 1;
//GL_ARB_gl_spirv
const int GL_ARB_gl_spirv = 1;
const int GL_SHADER_BINARY_FORMAT_SPIR_V_ARB = 0x9551;
const int GL_SPIR_V_BINARY_ARB = 0x9552;
//GL_ARB_gpu_shader5
const int GL_ARB_gpu_shader5 = 1;
//GL_ARB_gpu_shader_fp64
const int GL_ARB_gpu_shader_fp64 = 1;
//GL_ARB_gpu_shader_int64
const int GL_ARB_gpu_shader_int64 = 1;
const int GL_INT64_ARB = 0x140E;
const int GL_INT64_VEC2_ARB = 0x8FE9;
const int GL_INT64_VEC3_ARB = 0x8FEA;
const int GL_INT64_VEC4_ARB = 0x8FEB;
const int GL_UNSIGNED_INT64_VEC2_ARB = 0x8FF5;
const int GL_UNSIGNED_INT64_VEC3_ARB = 0x8FF6;
const int GL_UNSIGNED_INT64_VEC4_ARB = 0x8FF7;
//GL_ARB_half_float_vertex
const int GL_ARB_half_float_vertex = 1;
//GL_ARB_imaging
const int GL_ARB_imaging = 1;
//GL_ARB_indirect_parameters
const int GL_ARB_indirect_parameters = 1;
const int GL_PARAMETER_BUFFER_ARB = 0x80EE;
const int GL_PARAMETER_BUFFER_BINDING_ARB = 0x80EF;
//GL_ARB_instanced_arrays
const int GL_ARB_instanced_arrays = 1;
const int GL_VERTEX_ATTRIB_ARRAY_DIVISOR_ARB = 0x88FE;
//GL_ARB_internalformat_query
const int GL_ARB_internalformat_query = 1;
//GL_ARB_internalformat_query2
const int GL_ARB_internalformat_query2 = 1;
const int GL_SRGB_DECODE_ARB = 0x8299;
const int GL_VIEW_CLASS_EAC_R11 = 0x9383;
const int GL_VIEW_CLASS_EAC_RG11 = 0x9384;
const int GL_VIEW_CLASS_ETC2_RGB = 0x9385;
const int GL_VIEW_CLASS_ETC2_RGBA = 0x9386;
const int GL_VIEW_CLASS_ETC2_EAC_RGBA = 0x9387;
const int GL_VIEW_CLASS_ASTC_4x4_RGBA = 0x9388;
const int GL_VIEW_CLASS_ASTC_5x4_RGBA = 0x9389;
const int GL_VIEW_CLASS_ASTC_5x5_RGBA = 0x938A;
const int GL_VIEW_CLASS_ASTC_6x5_RGBA = 0x938B;
const int GL_VIEW_CLASS_ASTC_6x6_RGBA = 0x938C;
const int GL_VIEW_CLASS_ASTC_8x5_RGBA = 0x938D;
const int GL_VIEW_CLASS_ASTC_8x6_RGBA = 0x938E;
const int GL_VIEW_CLASS_ASTC_8x8_RGBA = 0x938F;
const int GL_VIEW_CLASS_ASTC_10x5_RGBA = 0x9390;
const int GL_VIEW_CLASS_ASTC_10x6_RGBA = 0x9391;
const int GL_VIEW_CLASS_ASTC_10x8_RGBA = 0x9392;
const int GL_VIEW_CLASS_ASTC_10x10_RGBA = 0x9393;
const int GL_VIEW_CLASS_ASTC_12x10_RGBA = 0x9394;
const int GL_VIEW_CLASS_ASTC_12x12_RGBA = 0x9395;
//GL_ARB_invalidate_subdata
const int GL_ARB_invalidate_subdata = 1;
//GL_ARB_map_buffer_alignment
const int GL_ARB_map_buffer_alignment = 1;
//GL_ARB_map_buffer_range
const int GL_ARB_map_buffer_range = 1;
//GL_ARB_multi_bind
const int GL_ARB_multi_bind = 1;
//GL_ARB_multi_draw_indirect
const int GL_ARB_multi_draw_indirect = 1;
//GL_ARB_occlusion_query2
const int GL_ARB_occlusion_query2 = 1;
//GL_ARB_parallel_shader_compile
const int GL_ARB_parallel_shader_compile = 1;
const int GL_MAX_SHADER_COMPILER_THREADS_ARB = 0x91B0;
const int GL_COMPLETION_STATUS_ARB = 0x91B1;
//GL_ARB_pipeline_statistics_query
const int GL_ARB_pipeline_statistics_query = 1;
const int GL_VERTICES_SUBMITTED_ARB = 0x82EE;
const int GL_PRIMITIVES_SUBMITTED_ARB = 0x82EF;
const int GL_VERTEX_SHADER_INVOCATIONS_ARB = 0x82F0;
const int GL_TESS_CONTROL_SHADER_PATCHES_ARB = 0x82F1;
const int GL_TESS_EVALUATION_SHADER_INVOCATIONS_ARB = 0x82F2;
const int GL_GEOMETRY_SHADER_PRIMITIVES_EMITTED_ARB = 0x82F3;
const int GL_FRAGMENT_SHADER_INVOCATIONS_ARB = 0x82F4;
const int GL_COMPUTE_SHADER_INVOCATIONS_ARB = 0x82F5;
const int GL_CLIPPING_INPUT_PRIMITIVES_ARB = 0x82F6;
const int GL_CLIPPING_OUTPUT_PRIMITIVES_ARB = 0x82F7;
//GL_ARB_pixel_buffer_object
const int GL_ARB_pixel_buffer_object = 1;
const int GL_PIXEL_PACK_BUFFER_ARB = 0x88EB;
const int GL_PIXEL_UNPACK_BUFFER_ARB = 0x88EC;
const int GL_PIXEL_PACK_BUFFER_BINDING_ARB = 0x88ED;
const int GL_PIXEL_UNPACK_BUFFER_BINDING_ARB = 0x88EF;
//GL_ARB_polygon_offset_clamp
const int GL_ARB_polygon_offset_clamp = 1;
//GL_ARB_post_depth_coverage
const int GL_ARB_post_depth_coverage = 1;
//GL_ARB_program_interface_query
const int GL_ARB_program_interface_query = 1;
//GL_ARB_provoking_vertex
const int GL_ARB_provoking_vertex = 1;
//GL_ARB_query_buffer_object
const int GL_ARB_query_buffer_object = 1;
//GL_ARB_robust_buffer_access_behavior
const int GL_ARB_robust_buffer_access_behavior = 1;
//GL_ARB_robustness
const int GL_ARB_robustness = 1;
const int GL_CONTEXT_FLAG_ROBUST_ACCESS_BIT_ARB = 0x00000004;
const int GL_LOSE_CONTEXT_ON_RESET_ARB = 0x8252;
const int GL_GUILTY_CONTEXT_RESET_ARB = 0x8253;
const int GL_INNOCENT_CONTEXT_RESET_ARB = 0x8254;
const int GL_UNKNOWN_CONTEXT_RESET_ARB = 0x8255;
const int GL_RESET_NOTIFICATION_STRATEGY_ARB = 0x8256;
const int GL_NO_RESET_NOTIFICATION_ARB = 0x8261;
//GL_ARB_robustness_isolation
const int GL_ARB_robustness_isolation = 1;
//GL_ARB_sample_locations
const int GL_ARB_sample_locations = 1;
const int GL_SAMPLE_LOCATION_SUBPIXEL_BITS_ARB = 0x933D;
const int GL_SAMPLE_LOCATION_PIXEL_GRID_WIDTH_ARB = 0x933E;
const int GL_SAMPLE_LOCATION_PIXEL_GRID_HEIGHT_ARB = 0x933F;
const int GL_PROGRAMMABLE_SAMPLE_LOCATION_TABLE_SIZE_ARB = 0x9340;
const int GL_SAMPLE_LOCATION_ARB = 0x8E50;
const int GL_PROGRAMMABLE_SAMPLE_LOCATION_ARB = 0x9341;
const int GL_FRAMEBUFFER_PROGRAMMABLE_SAMPLE_LOCATIONS_ARB = 0x9342;
const int GL_FRAMEBUFFER_SAMPLE_LOCATION_PIXEL_GRID_ARB = 0x9343;
//GL_ARB_sample_shading
const int GL_ARB_sample_shading = 1;
const int GL_SAMPLE_SHADING_ARB = 0x8C36;
const int GL_MIN_SAMPLE_SHADING_VALUE_ARB = 0x8C37;
//GL_ARB_sampler_objects
const int GL_ARB_sampler_objects = 1;
//GL_ARB_seamless_cube_map
const int GL_ARB_seamless_cube_map = 1;
//GL_ARB_seamless_cubemap_per_texture
const int GL_ARB_seamless_cubemap_per_texture = 1;
//GL_ARB_separate_shader_objects
const int GL_ARB_separate_shader_objects = 1;
//GL_ARB_shader_atomic_counter_ops
const int GL_ARB_shader_atomic_counter_ops = 1;
//GL_ARB_shader_atomic_counters
const int GL_ARB_shader_atomic_counters = 1;
//GL_ARB_shader_ballot
const int GL_ARB_shader_ballot = 1;
//GL_ARB_shader_bit_encoding
const int GL_ARB_shader_bit_encoding = 1;
//GL_ARB_shader_clock
const int GL_ARB_shader_clock = 1;
//GL_ARB_shader_draw_parameters
const int GL_ARB_shader_draw_parameters = 1;
//GL_ARB_shader_group_vote
const int GL_ARB_shader_group_vote = 1;
//GL_ARB_shader_image_load_store
const int GL_ARB_shader_image_load_store = 1;
//GL_ARB_shader_image_size
const int GL_ARB_shader_image_size = 1;
//GL_ARB_shader_precision
const int GL_ARB_shader_precision = 1;
//GL_ARB_shader_stencil_export
const int GL_ARB_shader_stencil_export = 1;
//GL_ARB_shader_storage_buffer_object
const int GL_ARB_shader_storage_buffer_object = 1;
//GL_ARB_shader_subroutine
const int GL_ARB_shader_subroutine = 1;
//GL_ARB_shader_texture_image_samples
const int GL_ARB_shader_texture_image_samples = 1;
//GL_ARB_shader_viewport_layer_array
const int GL_ARB_shader_viewport_layer_array = 1;
//GL_ARB_shading_language_420pack
const int GL_ARB_shading_language_420pack = 1;
//GL_ARB_shading_language_include
const int GL_ARB_shading_language_include = 1;
const int GL_SHADER_INCLUDE_ARB = 0x8DAE;
const int GL_NAMED_STRING_LENGTH_ARB = 0x8DE9;
const int GL_NAMED_STRING_TYPE_ARB = 0x8DEA;
//GL_ARB_shading_language_packing
const int GL_ARB_shading_language_packing = 1;
//GL_ARB_sparse_buffer
const int GL_ARB_sparse_buffer = 1;
const int GL_SPARSE_STORAGE_BIT_ARB = 0x0400;
const int GL_SPARSE_BUFFER_PAGE_SIZE_ARB = 0x82F8;
//GL_ARB_sparse_texture
const int GL_ARB_sparse_texture = 1;
const int GL_TEXTURE_SPARSE_ARB = 0x91A6;
const int GL_VIRTUAL_PAGE_SIZE_INDEX_ARB = 0x91A7;
const int GL_NUM_SPARSE_LEVELS_ARB = 0x91AA;
const int GL_NUM_VIRTUAL_PAGE_SIZES_ARB = 0x91A8;
const int GL_VIRTUAL_PAGE_SIZE_X_ARB = 0x9195;
const int GL_VIRTUAL_PAGE_SIZE_Y_ARB = 0x9196;
const int GL_VIRTUAL_PAGE_SIZE_Z_ARB = 0x9197;
const int GL_MAX_SPARSE_TEXTURE_SIZE_ARB = 0x9198;
const int GL_MAX_SPARSE_3D_TEXTURE_SIZE_ARB = 0x9199;
const int GL_MAX_SPARSE_ARRAY_TEXTURE_LAYERS_ARB = 0x919A;
const int GL_SPARSE_TEXTURE_FULL_ARRAY_CUBE_MIPMAPS_ARB = 0x91A9;
//GL_ARB_sparse_texture2
const int GL_ARB_sparse_texture2 = 1;
//GL_ARB_sparse_texture_clamp
const int GL_ARB_sparse_texture_clamp = 1;
//GL_ARB_spirv_extensions
const int GL_ARB_spirv_extensions = 1;
//GL_ARB_stencil_texturing
const int GL_ARB_stencil_texturing = 1;
//GL_ARB_sync
const int GL_ARB_sync = 1;
//GL_ARB_tessellation_shader
const int GL_ARB_tessellation_shader = 1;
//GL_ARB_texture_barrier
const int GL_ARB_texture_barrier = 1;
//GL_ARB_texture_border_clamp
const int GL_ARB_texture_border_clamp = 1;
const int GL_CLAMP_TO_BORDER_ARB = 0x812D;
//GL_ARB_texture_buffer_object
const int GL_ARB_texture_buffer_object = 1;
const int GL_TEXTURE_BUFFER_ARB = 0x8C2A;
const int GL_MAX_TEXTURE_BUFFER_SIZE_ARB = 0x8C2B;
const int GL_TEXTURE_BINDING_BUFFER_ARB = 0x8C2C;
const int GL_TEXTURE_BUFFER_DATA_STORE_BINDING_ARB = 0x8C2D;
const int GL_TEXTURE_BUFFER_FORMAT_ARB = 0x8C2E;
//GL_ARB_texture_buffer_object_rgb32
const int GL_ARB_texture_buffer_object_rgb32 = 1;
//GL_ARB_texture_buffer_range
const int GL_ARB_texture_buffer_range = 1;
//GL_ARB_texture_compression_bptc
const int GL_ARB_texture_compression_bptc = 1;
const int GL_COMPRESSED_RGBA_BPTC_UNORM_ARB = 0x8E8C;
const int GL_COMPRESSED_SRGB_ALPHA_BPTC_UNORM_ARB = 0x8E8D;
const int GL_COMPRESSED_RGB_BPTC_SIGNED_FLOAT_ARB = 0x8E8E;
const int GL_COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT_ARB = 0x8E8F;
//GL_ARB_texture_compression_rgtc
const int GL_ARB_texture_compression_rgtc = 1;
//GL_ARB_texture_cube_map_array
const int GL_ARB_texture_cube_map_array = 1;
const int GL_TEXTURE_CUBE_MAP_ARRAY_ARB = 0x9009;
const int GL_TEXTURE_BINDING_CUBE_MAP_ARRAY_ARB = 0x900A;
const int GL_PROXY_TEXTURE_CUBE_MAP_ARRAY_ARB = 0x900B;
const int GL_SAMPLER_CUBE_MAP_ARRAY_ARB = 0x900C;
const int GL_SAMPLER_CUBE_MAP_ARRAY_SHADOW_ARB = 0x900D;
const int GL_INT_SAMPLER_CUBE_MAP_ARRAY_ARB = 0x900E;
const int GL_UNSIGNED_INT_SAMPLER_CUBE_MAP_ARRAY_ARB = 0x900F;
//GL_ARB_texture_filter_anisotropic
const int GL_ARB_texture_filter_anisotropic = 1;
//GL_ARB_texture_filter_minmax
const int GL_ARB_texture_filter_minmax = 1;
const int GL_TEXTURE_REDUCTION_MODE_ARB = 0x9366;
const int GL_WEIGHTED_AVERAGE_ARB = 0x9367;
//GL_ARB_texture_gather
const int GL_ARB_texture_gather = 1;
const int GL_MIN_PROGRAM_TEXTURE_GATHER_OFFSET_ARB = 0x8E5E;
const int GL_MAX_PROGRAM_TEXTURE_GATHER_OFFSET_ARB = 0x8E5F;
const int GL_MAX_PROGRAM_TEXTURE_GATHER_COMPONENTS_ARB = 0x8F9F;
//GL_ARB_texture_mirror_clamp_to_edge
const int GL_ARB_texture_mirror_clamp_to_edge = 1;
//GL_ARB_texture_mirrored_repeat
const int GL_ARB_texture_mirrored_repeat = 1;
const int GL_MIRRORED_REPEAT_ARB = 0x8370;
//GL_ARB_texture_multisample
const int GL_ARB_texture_multisample = 1;
//GL_ARB_texture_non_power_of_two
const int GL_ARB_texture_non_power_of_two = 1;
//GL_ARB_texture_query_levels
const int GL_ARB_texture_query_levels = 1;
//GL_ARB_texture_query_lod
const int GL_ARB_texture_query_lod = 1;
//GL_ARB_texture_rg
const int GL_ARB_texture_rg = 1;
//GL_ARB_texture_rgb10_a2ui
const int GL_ARB_texture_rgb10_a2ui = 1;
//GL_ARB_texture_stencil8
const int GL_ARB_texture_stencil8 = 1;
//GL_ARB_texture_storage
const int GL_ARB_texture_storage = 1;
//GL_ARB_texture_storage_multisample
const int GL_ARB_texture_storage_multisample = 1;
//GL_ARB_texture_swizzle
const int GL_ARB_texture_swizzle = 1;
//GL_ARB_texture_view
const int GL_ARB_texture_view = 1;
//GL_ARB_timer_query
const int GL_ARB_timer_query = 1;
//GL_ARB_transform_feedback2
const int GL_ARB_transform_feedback2 = 1;
//GL_ARB_transform_feedback3
const int GL_ARB_transform_feedback3 = 1;
//GL_ARB_transform_feedback_instanced
const int GL_ARB_transform_feedback_instanced = 1;
//GL_ARB_transform_feedback_overflow_query
const int GL_ARB_transform_feedback_overflow_query = 1;
const int GL_TRANSFORM_FEEDBACK_OVERFLOW_ARB = 0x82EC;
const int GL_TRANSFORM_FEEDBACK_STREAM_OVERFLOW_ARB = 0x82ED;
//GL_ARB_uniform_buffer_object
const int GL_ARB_uniform_buffer_object = 1;
//GL_ARB_vertex_array_bgra
const int GL_ARB_vertex_array_bgra = 1;
//GL_ARB_vertex_array_object
const int GL_ARB_vertex_array_object = 1;
//GL_ARB_vertex_attrib_64bit
const int GL_ARB_vertex_attrib_64bit = 1;
//GL_ARB_vertex_attrib_binding
const int GL_ARB_vertex_attrib_binding = 1;
//GL_ARB_vertex_type_10f_11f_11f_rev
const int GL_ARB_vertex_type_10f_11f_11f_rev = 1;
//GL_ARB_vertex_type_2_10_10_10_rev
const int GL_ARB_vertex_type_2_10_10_10_rev = 1;
//GL_ARB_viewport_array
const int GL_ARB_viewport_array = 1;
//GL_KHR_blend_equation_advanced
const int GL_KHR_blend_equation_advanced = 1;
const int GL_MULTIPLY_KHR = 0x9294;
const int GL_SCREEN_KHR = 0x9295;
const int GL_OVERLAY_KHR = 0x9296;
const int GL_DARKEN_KHR = 0x9297;
const int GL_LIGHTEN_KHR = 0x9298;
const int GL_COLORDODGE_KHR = 0x9299;
const int GL_COLORBURN_KHR = 0x929A;
const int GL_HARDLIGHT_KHR = 0x929B;
const int GL_SOFTLIGHT_KHR = 0x929C;
const int GL_DIFFERENCE_KHR = 0x929E;
const int GL_EXCLUSION_KHR = 0x92A0;
const int GL_HSL_HUE_KHR = 0x92AD;
const int GL_HSL_SATURATION_KHR = 0x92AE;
const int GL_HSL_COLOR_KHR = 0x92AF;
const int GL_HSL_LUMINOSITY_KHR = 0x92B0;
//GL_KHR_blend_equation_advanced_coherent
const int GL_KHR_blend_equation_advanced_coherent = 1;
const int GL_BLEND_ADVANCED_COHERENT_KHR = 0x9285;
//GL_KHR_context_flush_control
const int GL_KHR_context_flush_control = 1;
//GL_KHR_debug
const int GL_KHR_debug = 1;
//GL_KHR_no_error
const int GL_KHR_no_error = 1;
const int GL_CONTEXT_FLAG_NO_ERROR_BIT_KHR = 0x00000008;
//GL_KHR_parallel_shader_compile
const int GL_KHR_parallel_shader_compile = 1;
const int GL_MAX_SHADER_COMPILER_THREADS_KHR = 0x91B0;
const int GL_COMPLETION_STATUS_KHR = 0x91B1;
//GL_KHR_robust_buffer_access_behavior
const int GL_KHR_robust_buffer_access_behavior = 1;
//GL_KHR_robustness
const int GL_KHR_robustness = 1;
const int GL_CONTEXT_ROBUST_ACCESS = 0x90F3;
//GL_KHR_shader_subgroup
const int GL_KHR_shader_subgroup = 1;
const int GL_SUBGROUP_SIZE_KHR = 0x9532;
const int GL_SUBGROUP_SUPPORTED_STAGES_KHR = 0x9533;
const int GL_SUBGROUP_SUPPORTED_FEATURES_KHR = 0x9534;
const int GL_SUBGROUP_QUAD_ALL_STAGES_KHR = 0x9535;
const int GL_SUBGROUP_FEATURE_BASIC_BIT_KHR = 0x00000001;
const int GL_SUBGROUP_FEATURE_VOTE_BIT_KHR = 0x00000002;
const int GL_SUBGROUP_FEATURE_ARITHMETIC_BIT_KHR = 0x00000004;
const int GL_SUBGROUP_FEATURE_BALLOT_BIT_KHR = 0x00000008;
const int GL_SUBGROUP_FEATURE_SHUFFLE_BIT_KHR = 0x00000010;
const int GL_SUBGROUP_FEATURE_SHUFFLE_RELATIVE_BIT_KHR = 0x00000020;
const int GL_SUBGROUP_FEATURE_CLUSTERED_BIT_KHR = 0x00000040;
const int GL_SUBGROUP_FEATURE_QUAD_BIT_KHR = 0x00000080;
//GL_KHR_texture_compression_astc_hdr
const int GL_KHR_texture_compression_astc_hdr = 1;
const int GL_COMPRESSED_RGBA_ASTC_4x4_KHR = 0x93B0;
const int GL_COMPRESSED_RGBA_ASTC_5x4_KHR = 0x93B1;
const int GL_COMPRESSED_RGBA_ASTC_5x5_KHR = 0x93B2;
const int GL_COMPRESSED_RGBA_ASTC_6x5_KHR = 0x93B3;
const int GL_COMPRESSED_RGBA_ASTC_6x6_KHR = 0x93B4;
const int GL_COMPRESSED_RGBA_ASTC_8x5_KHR = 0x93B5;
const int GL_COMPRESSED_RGBA_ASTC_8x6_KHR = 0x93B6;
const int GL_COMPRESSED_RGBA_ASTC_8x8_KHR = 0x93B7;
const int GL_COMPRESSED_RGBA_ASTC_10x5_KHR = 0x93B8;
const int GL_COMPRESSED_RGBA_ASTC_10x6_KHR = 0x93B9;
const int GL_COMPRESSED_RGBA_ASTC_10x8_KHR = 0x93BA;
const int GL_COMPRESSED_RGBA_ASTC_10x10_KHR = 0x93BB;
const int GL_COMPRESSED_RGBA_ASTC_12x10_KHR = 0x93BC;
const int GL_COMPRESSED_RGBA_ASTC_12x12_KHR = 0x93BD;
const int GL_COMPRESSED_SRGB8_ALPHA8_ASTC_4x4_KHR = 0x93D0;
const int GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x4_KHR = 0x93D1;
const int GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x5_KHR = 0x93D2;
const int GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x5_KHR = 0x93D3;
const int GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x6_KHR = 0x93D4;
const int GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x5_KHR = 0x93D5;
const int GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x6_KHR = 0x93D6;
const int GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x8_KHR = 0x93D7;
const int GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x5_KHR = 0x93D8;
const int GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x6_KHR = 0x93D9;
const int GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x8_KHR = 0x93DA;
const int GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x10_KHR = 0x93DB;
const int GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x10_KHR = 0x93DC;
const int GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x12_KHR = 0x93DD;
//GL_KHR_texture_compression_astc_ldr
const int GL_KHR_texture_compression_astc_ldr = 1;
//GL_KHR_texture_compression_astc_sliced_3d
const int GL_KHR_texture_compression_astc_sliced_3d = 1;
//GL_AMD_framebuffer_multisample_advanced
const int GL_AMD_framebuffer_multisample_advanced = 1;
const int GL_RENDERBUFFER_STORAGE_SAMPLES_AMD = 0x91B2;
const int GL_MAX_COLOR_FRAMEBUFFER_SAMPLES_AMD = 0x91B3;
const int GL_MAX_COLOR_FRAMEBUFFER_STORAGE_SAMPLES_AMD = 0x91B4;
const int GL_MAX_DEPTH_STENCIL_FRAMEBUFFER_SAMPLES_AMD = 0x91B5;
const int GL_NUM_SUPPORTED_MULTISAMPLE_MODES_AMD = 0x91B6;
const int GL_SUPPORTED_MULTISAMPLE_MODES_AMD = 0x91B7;
//GL_AMD_performance_monitor
const int GL_AMD_performance_monitor = 1;
const int GL_COUNTER_TYPE_AMD = 0x8BC0;
const int GL_COUNTER_RANGE_AMD = 0x8BC1;
const int GL_UNSIGNED_INT64_AMD = 0x8BC2;
const int GL_PERCENTAGE_AMD = 0x8BC3;
const int GL_PERFMON_RESULT_AVAILABLE_AMD = 0x8BC4;
const int GL_PERFMON_RESULT_SIZE_AMD = 0x8BC5;
const int GL_PERFMON_RESULT_AMD = 0x8BC6;
//GL_APPLE_rgb_422
const int GL_APPLE_rgb_422 = 1;
const int GL_RGB_422_APPLE = 0x8A1F;
const int GL_UNSIGNED_SHORT_8_8_APPLE = 0x85BA;
const int GL_UNSIGNED_SHORT_8_8_REV_APPLE = 0x85BB;
const int GL_RGB_RAW_422_APPLE = 0x8A51;
//GL_EXT_EGL_image_storage
const int GL_EXT_EGL_image_storage = 1;
//GL_EXT_EGL_sync
const int GL_EXT_EGL_sync = 1;
//GL_EXT_debug_label
const int GL_EXT_debug_label = 1;
const int GL_PROGRAM_PIPELINE_OBJECT_EXT = 0x8A4F;
const int GL_PROGRAM_OBJECT_EXT = 0x8B40;
const int GL_SHADER_OBJECT_EXT = 0x8B48;
const int GL_BUFFER_OBJECT_EXT = 0x9151;
const int GL_QUERY_OBJECT_EXT = 0x9153;
const int GL_VERTEX_ARRAY_OBJECT_EXT = 0x9154;
//GL_EXT_debug_marker
const int GL_EXT_debug_marker = 1;
//GL_EXT_direct_state_access
const int GL_EXT_direct_state_access = 1;
const int GL_PROGRAM_MATRIX_EXT = 0x8E2D;
const int GL_TRANSPOSE_PROGRAM_MATRIX_EXT = 0x8E2E;
const int GL_PROGRAM_MATRIX_STACK_DEPTH_EXT = 0x8E2F;
//GL_EXT_draw_instanced
const int GL_EXT_draw_instanced = 1;
//GL_EXT_multiview_tessellation_geometry_shader
const int GL_EXT_multiview_tessellation_geometry_shader = 1;
//GL_EXT_multiview_texture_multisample
const int GL_EXT_multiview_texture_multisample = 1;
//GL_EXT_multiview_timer_query
const int GL_EXT_multiview_timer_query = 1;
//GL_EXT_polygon_offset_clamp
const int GL_EXT_polygon_offset_clamp = 1;
const int GL_POLYGON_OFFSET_CLAMP_EXT = 0x8E1B;
//GL_EXT_post_depth_coverage
const int GL_EXT_post_depth_coverage = 1;
//GL_EXT_raster_multisample
const int GL_EXT_raster_multisample = 1;
const int GL_RASTER_MULTISAMPLE_EXT = 0x9327;
const int GL_RASTER_SAMPLES_EXT = 0x9328;
const int GL_MAX_RASTER_SAMPLES_EXT = 0x9329;
const int GL_RASTER_FIXED_SAMPLE_LOCATIONS_EXT = 0x932A;
const int GL_MULTISAMPLE_RASTERIZATION_ALLOWED_EXT = 0x932B;
const int GL_EFFECTIVE_RASTER_SAMPLES_EXT = 0x932C;
//GL_EXT_separate_shader_objects
const int GL_EXT_separate_shader_objects = 1;
const int GL_ACTIVE_PROGRAM_EXT = 0x8B8D;
//GL_EXT_shader_framebuffer_fetch
const int GL_EXT_shader_framebuffer_fetch = 1;
const int GL_FRAGMENT_SHADER_DISCARDS_SAMPLES_EXT = 0x8A52;
//GL_EXT_shader_framebuffer_fetch_non_coherent
const int GL_EXT_shader_framebuffer_fetch_non_coherent = 1;
//GL_EXT_shader_integer_mix
const int GL_EXT_shader_integer_mix = 1;
//GL_EXT_texture_compression_s3tc
const int GL_EXT_texture_compression_s3tc = 1;
const int GL_COMPRESSED_RGB_S3TC_DXT1_EXT = 0x83F0;
const int GL_COMPRESSED_RGBA_S3TC_DXT1_EXT = 0x83F1;
const int GL_COMPRESSED_RGBA_S3TC_DXT3_EXT = 0x83F2;
const int GL_COMPRESSED_RGBA_S3TC_DXT5_EXT = 0x83F3;
//GL_EXT_texture_filter_minmax
const int GL_EXT_texture_filter_minmax = 1;
const int GL_TEXTURE_REDUCTION_MODE_EXT = 0x9366;
const int GL_WEIGHTED_AVERAGE_EXT = 0x9367;
//GL_EXT_texture_sRGB_R8
const int GL_EXT_texture_sRGB_R8 = 1;
const int GL_SR8_EXT = 0x8FBD;
//GL_EXT_texture_sRGB_RG8
const int GL_EXT_texture_sRGB_RG8 = 1;
const int GL_SRG8_EXT = 0x8FBE;
//GL_EXT_texture_sRGB_decode
const int GL_EXT_texture_sRGB_decode = 1;
const int GL_TEXTURE_SRGB_DECODE_EXT = 0x8A48;
const int GL_DECODE_EXT = 0x8A49;
const int GL_SKIP_DECODE_EXT = 0x8A4A;
//GL_EXT_texture_shadow_lod
const int GL_EXT_texture_shadow_lod = 1;
//GL_EXT_window_rectangles
const int GL_EXT_window_rectangles = 1;
const int GL_INCLUSIVE_EXT = 0x8F10;
const int GL_EXCLUSIVE_EXT = 0x8F11;
const int GL_WINDOW_RECTANGLE_EXT = 0x8F12;
const int GL_WINDOW_RECTANGLE_MODE_EXT = 0x8F13;
const int GL_MAX_WINDOW_RECTANGLES_EXT = 0x8F14;
const int GL_NUM_WINDOW_RECTANGLES_EXT = 0x8F15;
//GL_INTEL_blackhole_render
const int GL_INTEL_blackhole_render = 1;
const int GL_BLACKHOLE_RENDER_INTEL = 0x83FC;
//GL_INTEL_conservative_rasterization
const int GL_INTEL_conservative_rasterization = 1;
const int GL_CONSERVATIVE_RASTERIZATION_INTEL = 0x83FE;
//GL_INTEL_framebuffer_CMAA
const int GL_INTEL_framebuffer_CMAA = 1;
//GL_INTEL_performance_query
const int GL_INTEL_performance_query = 1;
const int GL_PERFQUERY_SINGLE_CONTEXT_INTEL = 0x00000000;
const int GL_PERFQUERY_GLOBAL_CONTEXT_INTEL = 0x00000001;
const int GL_PERFQUERY_WAIT_INTEL = 0x83FB;
const int GL_PERFQUERY_FLUSH_INTEL = 0x83FA;
const int GL_PERFQUERY_DONOT_FLUSH_INTEL = 0x83F9;
const int GL_PERFQUERY_COUNTER_EVENT_INTEL = 0x94F0;
const int GL_PERFQUERY_COUNTER_DURATION_NORM_INTEL = 0x94F1;
const int GL_PERFQUERY_COUNTER_DURATION_RAW_INTEL = 0x94F2;
const int GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL = 0x94F3;
const int GL_PERFQUERY_COUNTER_RAW_INTEL = 0x94F4;
const int GL_PERFQUERY_COUNTER_TIMESTAMP_INTEL = 0x94F5;
const int GL_PERFQUERY_COUNTER_DATA_UINT32_INTEL = 0x94F8;
const int GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL = 0x94F9;
const int GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL = 0x94FA;
const int GL_PERFQUERY_COUNTER_DATA_DOUBLE_INTEL = 0x94FB;
const int GL_PERFQUERY_COUNTER_DATA_BOOL32_INTEL = 0x94FC;
const int GL_PERFQUERY_QUERY_NAME_LENGTH_MAX_INTEL = 0x94FD;
const int GL_PERFQUERY_COUNTER_NAME_LENGTH_MAX_INTEL = 0x94FE;
const int GL_PERFQUERY_COUNTER_DESC_LENGTH_MAX_INTEL = 0x94FF;
const int GL_PERFQUERY_GPA_EXTENDED_COUNTERS_INTEL = 0x9500;
//GL_MESA_framebuffer_flip_x
const int GL_MESA_framebuffer_flip_x = 1;
const int GL_FRAMEBUFFER_FLIP_X_MESA = 0x8BBC;
//GL_MESA_framebuffer_flip_y
const int GL_MESA_framebuffer_flip_y = 1;
const int GL_FRAMEBUFFER_FLIP_Y_MESA = 0x8BBB;
//GL_MESA_framebuffer_swap_xy
const int GL_MESA_framebuffer_swap_xy = 1;
const int GL_FRAMEBUFFER_SWAP_XY_MESA = 0x8BBD;
//GL_NV_bindless_multi_draw_indirect
const int GL_NV_bindless_multi_draw_indirect = 1;
//GL_NV_bindless_multi_draw_indirect_count
const int GL_NV_bindless_multi_draw_indirect_count = 1;
//GL_NV_bindless_texture
const int GL_NV_bindless_texture = 1;
//GL_NV_blend_equation_advanced
const int GL_NV_blend_equation_advanced = 1;
const int GL_BLEND_OVERLAP_NV = 0x9281;
const int GL_BLEND_PREMULTIPLIED_SRC_NV = 0x9280;
const int GL_BLUE_NV = 0x1905;
const int GL_COLORBURN_NV = 0x929A;
const int GL_COLORDODGE_NV = 0x9299;
const int GL_CONJOINT_NV = 0x9284;
const int GL_CONTRAST_NV = 0x92A1;
const int GL_DARKEN_NV = 0x9297;
const int GL_DIFFERENCE_NV = 0x929E;
const int GL_DISJOINT_NV = 0x9283;
const int GL_DST_ATOP_NV = 0x928F;
const int GL_DST_IN_NV = 0x928B;
const int GL_DST_NV = 0x9287;
const int GL_DST_OUT_NV = 0x928D;
const int GL_DST_OVER_NV = 0x9289;
const int GL_EXCLUSION_NV = 0x92A0;
const int GL_GREEN_NV = 0x1904;
const int GL_HARDLIGHT_NV = 0x929B;
const int GL_HARDMIX_NV = 0x92A9;
const int GL_HSL_COLOR_NV = 0x92AF;
const int GL_HSL_HUE_NV = 0x92AD;
const int GL_HSL_LUMINOSITY_NV = 0x92B0;
const int GL_HSL_SATURATION_NV = 0x92AE;
const int GL_INVERT_OVG_NV = 0x92B4;
const int GL_INVERT_RGB_NV = 0x92A3;
const int GL_LIGHTEN_NV = 0x9298;
const int GL_LINEARBURN_NV = 0x92A5;
const int GL_LINEARDODGE_NV = 0x92A4;
const int GL_LINEARLIGHT_NV = 0x92A7;
const int GL_MINUS_CLAMPED_NV = 0x92B3;
const int GL_MINUS_NV = 0x929F;
const int GL_MULTIPLY_NV = 0x9294;
const int GL_OVERLAY_NV = 0x9296;
const int GL_PINLIGHT_NV = 0x92A8;
const int GL_PLUS_CLAMPED_ALPHA_NV = 0x92B2;
const int GL_PLUS_CLAMPED_NV = 0x92B1;
const int GL_PLUS_DARKER_NV = 0x9292;
const int GL_PLUS_NV = 0x9291;
const int GL_RED_NV = 0x1903;
const int GL_SCREEN_NV = 0x9295;
const int GL_SOFTLIGHT_NV = 0x929C;
const int GL_SRC_ATOP_NV = 0x928E;
const int GL_SRC_IN_NV = 0x928A;
const int GL_SRC_NV = 0x9286;
const int GL_SRC_OUT_NV = 0x928C;
const int GL_SRC_OVER_NV = 0x9288;
const int GL_UNCORRELATED_NV = 0x9282;
const int GL_VIVIDLIGHT_NV = 0x92A6;
const int GL_XOR_NV = 0x1506;
//GL_NV_blend_equation_advanced_coherent
const int GL_NV_blend_equation_advanced_coherent = 1;
const int GL_BLEND_ADVANCED_COHERENT_NV = 0x9285;
//GL_NV_blend_minmax_factor
const int GL_NV_blend_minmax_factor = 1;
const int GL_FACTOR_MIN_AMD = 0x901C;
const int GL_FACTOR_MAX_AMD = 0x901D;
//GL_NV_clip_space_w_scaling
const int GL_NV_clip_space_w_scaling = 1;
const int GL_VIEWPORT_POSITION_W_SCALE_NV = 0x937C;
const int GL_VIEWPORT_POSITION_W_SCALE_X_COEFF_NV = 0x937D;
const int GL_VIEWPORT_POSITION_W_SCALE_Y_COEFF_NV = 0x937E;
//GL_NV_command_list
const int GL_NV_command_list = 1;
const int GL_TERMINATE_SEQUENCE_COMMAND_NV = 0x0000;
const int GL_NOP_COMMAND_NV = 0x0001;
const int GL_DRAW_ELEMENTS_COMMAND_NV = 0x0002;
const int GL_DRAW_ARRAYS_COMMAND_NV = 0x0003;
const int GL_DRAW_ELEMENTS_STRIP_COMMAND_NV = 0x0004;
const int GL_DRAW_ARRAYS_STRIP_COMMAND_NV = 0x0005;
const int GL_DRAW_ELEMENTS_INSTANCED_COMMAND_NV = 0x0006;
const int GL_DRAW_ARRAYS_INSTANCED_COMMAND_NV = 0x0007;
const int GL_ELEMENT_ADDRESS_COMMAND_NV = 0x0008;
const int GL_ATTRIBUTE_ADDRESS_COMMAND_NV = 0x0009;
const int GL_UNIFORM_ADDRESS_COMMAND_NV = 0x000A;
const int GL_BLEND_COLOR_COMMAND_NV = 0x000B;
const int GL_STENCIL_REF_COMMAND_NV = 0x000C;
const int GL_LINE_WIDTH_COMMAND_NV = 0x000D;
const int GL_POLYGON_OFFSET_COMMAND_NV = 0x000E;
const int GL_ALPHA_REF_COMMAND_NV = 0x000F;
const int GL_VIEWPORT_COMMAND_NV = 0x0010;
const int GL_SCISSOR_COMMAND_NV = 0x0011;
const int GL_FRONT_FACE_COMMAND_NV = 0x0012;
//GL_NV_compute_shader_derivatives
const int GL_NV_compute_shader_derivatives = 1;
//GL_NV_conditional_render
const int GL_NV_conditional_render = 1;
const int GL_QUERY_WAIT_NV = 0x8E13;
const int GL_QUERY_NO_WAIT_NV = 0x8E14;
const int GL_QUERY_BY_REGION_WAIT_NV = 0x8E15;
const int GL_QUERY_BY_REGION_NO_WAIT_NV = 0x8E16;
//GL_NV_conservative_raster
const int GL_NV_conservative_raster = 1;
const int GL_CONSERVATIVE_RASTERIZATION_NV = 0x9346;
const int GL_SUBPIXEL_PRECISION_BIAS_X_BITS_NV = 0x9347;
const int GL_SUBPIXEL_PRECISION_BIAS_Y_BITS_NV = 0x9348;
const int GL_MAX_SUBPIXEL_PRECISION_BIAS_BITS_NV = 0x9349;
//GL_NV_conservative_raster_dilate
const int GL_NV_conservative_raster_dilate = 1;
const int GL_CONSERVATIVE_RASTER_DILATE_NV = 0x9379;
const int GL_CONSERVATIVE_RASTER_DILATE_RANGE_NV = 0x937A;
const int GL_CONSERVATIVE_RASTER_DILATE_GRANULARITY_NV = 0x937B;
//GL_NV_conservative_raster_pre_snap
const int GL_NV_conservative_raster_pre_snap = 1;
const int GL_CONSERVATIVE_RASTER_MODE_PRE_SNAP_NV = 0x9550;
//GL_NV_conservative_raster_pre_snap_triangles
const int GL_NV_conservative_raster_pre_snap_triangles = 1;
const int GL_CONSERVATIVE_RASTER_MODE_NV = 0x954D;
const int GL_CONSERVATIVE_RASTER_MODE_POST_SNAP_NV = 0x954E;
const int GL_CONSERVATIVE_RASTER_MODE_PRE_SNAP_TRIANGLES_NV = 0x954F;
//GL_NV_conservative_raster_underestimation
const int GL_NV_conservative_raster_underestimation = 1;
//GL_NV_depth_buffer_float
const int GL_NV_depth_buffer_float = 1;
const int GL_DEPTH_COMPONENT32F_NV = 0x8DAB;
const int GL_DEPTH32F_STENCIL8_NV = 0x8DAC;
const int GL_FLOAT_32_UNSIGNED_INT_24_8_REV_NV = 0x8DAD;
const int GL_DEPTH_BUFFER_FLOAT_MODE_NV = 0x8DAF;
//GL_NV_draw_vulkan_image
const int GL_NV_draw_vulkan_image = 1;
//GL_NV_fill_rectangle
const int GL_NV_fill_rectangle = 1;
const int GL_FILL_RECTANGLE_NV = 0x933C;
//GL_NV_fragment_coverage_to_color
const int GL_NV_fragment_coverage_to_color = 1;
const int GL_FRAGMENT_COVERAGE_TO_COLOR_NV = 0x92DD;
const int GL_FRAGMENT_COVERAGE_COLOR_NV = 0x92DE;
//GL_NV_fragment_shader_barycentric
const int GL_NV_fragment_shader_barycentric = 1;
//GL_NV_fragment_shader_interlock
const int GL_NV_fragment_shader_interlock = 1;
//GL_NV_framebuffer_mixed_samples
const int GL_NV_framebuffer_mixed_samples = 1;
const int GL_COVERAGE_MODULATION_TABLE_NV = 0x9331;
const int GL_COLOR_SAMPLES_NV = 0x8E20;
const int GL_DEPTH_SAMPLES_NV = 0x932D;
const int GL_STENCIL_SAMPLES_NV = 0x932E;
const int GL_MIXED_DEPTH_SAMPLES_SUPPORTED_NV = 0x932F;
const int GL_MIXED_STENCIL_SAMPLES_SUPPORTED_NV = 0x9330;
const int GL_COVERAGE_MODULATION_NV = 0x9332;
const int GL_COVERAGE_MODULATION_TABLE_SIZE_NV = 0x9333;
//GL_NV_framebuffer_multisample_coverage
const int GL_NV_framebuffer_multisample_coverage = 1;
const int GL_RENDERBUFFER_COVERAGE_SAMPLES_NV = 0x8CAB;
const int GL_RENDERBUFFER_COLOR_SAMPLES_NV = 0x8E10;
const int GL_MAX_MULTISAMPLE_COVERAGE_MODES_NV = 0x8E11;
const int GL_MULTISAMPLE_COVERAGE_MODES_NV = 0x8E12;
//GL_NV_geometry_shader_passthrough
const int GL_NV_geometry_shader_passthrough = 1;
//GL_NV_gpu_shader5
const int GL_NV_gpu_shader5 = 1;
const int GL_INT64_NV = 0x140E;
const int GL_UNSIGNED_INT64_NV = 0x140F;
const int GL_INT8_NV = 0x8FE0;
const int GL_INT8_VEC2_NV = 0x8FE1;
const int GL_INT8_VEC3_NV = 0x8FE2;
const int GL_INT8_VEC4_NV = 0x8FE3;
const int GL_INT16_NV = 0x8FE4;
const int GL_INT16_VEC2_NV = 0x8FE5;
const int GL_INT16_VEC3_NV = 0x8FE6;
const int GL_INT16_VEC4_NV = 0x8FE7;
const int GL_INT64_VEC2_NV = 0x8FE9;
const int GL_INT64_VEC3_NV = 0x8FEA;
const int GL_INT64_VEC4_NV = 0x8FEB;
const int GL_UNSIGNED_INT8_NV = 0x8FEC;
const int GL_UNSIGNED_INT8_VEC2_NV = 0x8FED;
const int GL_UNSIGNED_INT8_VEC3_NV = 0x8FEE;
const int GL_UNSIGNED_INT8_VEC4_NV = 0x8FEF;
const int GL_UNSIGNED_INT16_NV = 0x8FF0;
const int GL_UNSIGNED_INT16_VEC2_NV = 0x8FF1;
const int GL_UNSIGNED_INT16_VEC3_NV = 0x8FF2;
const int GL_UNSIGNED_INT16_VEC4_NV = 0x8FF3;
const int GL_UNSIGNED_INT64_VEC2_NV = 0x8FF5;
const int GL_UNSIGNED_INT64_VEC3_NV = 0x8FF6;
const int GL_UNSIGNED_INT64_VEC4_NV = 0x8FF7;
const int GL_FLOAT16_NV = 0x8FF8;
const int GL_FLOAT16_VEC2_NV = 0x8FF9;
const int GL_FLOAT16_VEC3_NV = 0x8FFA;
const int GL_FLOAT16_VEC4_NV = 0x8FFB;
//GL_NV_internalformat_sample_query
const int GL_NV_internalformat_sample_query = 1;
const int GL_MULTISAMPLES_NV = 0x9371;
const int GL_SUPERSAMPLE_SCALE_X_NV = 0x9372;
const int GL_SUPERSAMPLE_SCALE_Y_NV = 0x9373;
const int GL_CONFORMANT_NV = 0x9374;
//GL_NV_memory_attachment
const int GL_NV_memory_attachment = 1;
const int GL_ATTACHED_MEMORY_OBJECT_NV = 0x95A4;
const int GL_ATTACHED_MEMORY_OFFSET_NV = 0x95A5;
const int GL_MEMORY_ATTACHABLE_ALIGNMENT_NV = 0x95A6;
const int GL_MEMORY_ATTACHABLE_SIZE_NV = 0x95A7;
const int GL_MEMORY_ATTACHABLE_NV = 0x95A8;
const int GL_DETACHED_MEMORY_INCARNATION_NV = 0x95A9;
const int GL_DETACHED_TEXTURES_NV = 0x95AA;
const int GL_DETACHED_BUFFERS_NV = 0x95AB;
const int GL_MAX_DETACHED_TEXTURES_NV = 0x95AC;
const int GL_MAX_DETACHED_BUFFERS_NV = 0x95AD;
//GL_NV_memory_object_sparse
const int GL_NV_memory_object_sparse = 1;
//GL_NV_mesh_shader
const int GL_NV_mesh_shader = 1;
const int GL_MESH_SHADER_NV = 0x9559;
const int GL_TASK_SHADER_NV = 0x955A;
const int GL_MAX_MESH_UNIFORM_BLOCKS_NV = 0x8E60;
const int GL_MAX_MESH_TEXTURE_IMAGE_UNITS_NV = 0x8E61;
const int GL_MAX_MESH_IMAGE_UNIFORMS_NV = 0x8E62;
const int GL_MAX_MESH_UNIFORM_COMPONENTS_NV = 0x8E63;
const int GL_MAX_MESH_ATOMIC_COUNTER_BUFFERS_NV = 0x8E64;
const int GL_MAX_MESH_ATOMIC_COUNTERS_NV = 0x8E65;
const int GL_MAX_MESH_SHADER_STORAGE_BLOCKS_NV = 0x8E66;
const int GL_MAX_COMBINED_MESH_UNIFORM_COMPONENTS_NV = 0x8E67;
const int GL_MAX_TASK_UNIFORM_BLOCKS_NV = 0x8E68;
const int GL_MAX_TASK_TEXTURE_IMAGE_UNITS_NV = 0x8E69;
const int GL_MAX_TASK_IMAGE_UNIFORMS_NV = 0x8E6A;
const int GL_MAX_TASK_UNIFORM_COMPONENTS_NV = 0x8E6B;
const int GL_MAX_TASK_ATOMIC_COUNTER_BUFFERS_NV = 0x8E6C;
const int GL_MAX_TASK_ATOMIC_COUNTERS_NV = 0x8E6D;
const int GL_MAX_TASK_SHADER_STORAGE_BLOCKS_NV = 0x8E6E;
const int GL_MAX_COMBINED_TASK_UNIFORM_COMPONENTS_NV = 0x8E6F;
const int GL_MAX_MESH_WORK_GROUP_INVOCATIONS_NV = 0x95A2;
const int GL_MAX_TASK_WORK_GROUP_INVOCATIONS_NV = 0x95A3;
const int GL_MAX_MESH_TOTAL_MEMORY_SIZE_NV = 0x9536;
const int GL_MAX_TASK_TOTAL_MEMORY_SIZE_NV = 0x9537;
const int GL_MAX_MESH_OUTPUT_VERTICES_NV = 0x9538;
const int GL_MAX_MESH_OUTPUT_PRIMITIVES_NV = 0x9539;
const int GL_MAX_TASK_OUTPUT_COUNT_NV = 0x953A;
const int GL_MAX_DRAW_MESH_TASKS_COUNT_NV = 0x953D;
const int GL_MAX_MESH_VIEWS_NV = 0x9557;
const int GL_MESH_OUTPUT_PER_VERTEX_GRANULARITY_NV = 0x92DF;
const int GL_MESH_OUTPUT_PER_PRIMITIVE_GRANULARITY_NV = 0x9543;
const int GL_MAX_MESH_WORK_GROUP_SIZE_NV = 0x953B;
const int GL_MAX_TASK_WORK_GROUP_SIZE_NV = 0x953C;
const int GL_MESH_WORK_GROUP_SIZE_NV = 0x953E;
const int GL_TASK_WORK_GROUP_SIZE_NV = 0x953F;
const int GL_MESH_VERTICES_OUT_NV = 0x9579;
const int GL_MESH_PRIMITIVES_OUT_NV = 0x957A;
const int GL_MESH_OUTPUT_TYPE_NV = 0x957B;
const int GL_UNIFORM_BLOCK_REFERENCED_BY_MESH_SHADER_NV = 0x959C;
const int GL_UNIFORM_BLOCK_REFERENCED_BY_TASK_SHADER_NV = 0x959D;
const int GL_REFERENCED_BY_MESH_SHADER_NV = 0x95A0;
const int GL_REFERENCED_BY_TASK_SHADER_NV = 0x95A1;
const int GL_MESH_SHADER_BIT_NV = 0x00000040;
const int GL_TASK_SHADER_BIT_NV = 0x00000080;
const int GL_MESH_SUBROUTINE_NV = 0x957C;
const int GL_TASK_SUBROUTINE_NV = 0x957D;
const int GL_MESH_SUBROUTINE_UNIFORM_NV = 0x957E;
const int GL_TASK_SUBROUTINE_UNIFORM_NV = 0x957F;
const int GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_MESH_SHADER_NV = 0x959E;
const int GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_TASK_SHADER_NV = 0x959F;
//GL_NV_path_rendering
const int GL_NV_path_rendering = 1;
const int GL_PATH_FORMAT_SVG_NV = 0x9070;
const int GL_PATH_FORMAT_PS_NV = 0x9071;
const int GL_STANDARD_FONT_NAME_NV = 0x9072;
const int GL_SYSTEM_FONT_NAME_NV = 0x9073;
const int GL_FILE_NAME_NV = 0x9074;
const int GL_PATH_STROKE_WIDTH_NV = 0x9075;
const int GL_PATH_END_CAPS_NV = 0x9076;
const int GL_PATH_INITIAL_END_CAP_NV = 0x9077;
const int GL_PATH_TERMINAL_END_CAP_NV = 0x9078;
const int GL_PATH_JOIN_STYLE_NV = 0x9079;
const int GL_PATH_MITER_LIMIT_NV = 0x907A;
const int GL_PATH_DASH_CAPS_NV = 0x907B;
const int GL_PATH_INITIAL_DASH_CAP_NV = 0x907C;
const int GL_PATH_TERMINAL_DASH_CAP_NV = 0x907D;
const int GL_PATH_DASH_OFFSET_NV = 0x907E;
const int GL_PATH_CLIENT_LENGTH_NV = 0x907F;
const int GL_PATH_FILL_MODE_NV = 0x9080;
const int GL_PATH_FILL_MASK_NV = 0x9081;
const int GL_PATH_FILL_COVER_MODE_NV = 0x9082;
const int GL_PATH_STROKE_COVER_MODE_NV = 0x9083;
const int GL_PATH_STROKE_MASK_NV = 0x9084;
const int GL_COUNT_UP_NV = 0x9088;
const int GL_COUNT_DOWN_NV = 0x9089;
const int GL_PATH_OBJECT_BOUNDING_BOX_NV = 0x908A;
const int GL_CONVEX_HULL_NV = 0x908B;
const int GL_BOUNDING_BOX_NV = 0x908D;
const int GL_TRANSLATE_X_NV = 0x908E;
const int GL_TRANSLATE_Y_NV = 0x908F;
const int GL_TRANSLATE_2D_NV = 0x9090;
const int GL_TRANSLATE_3D_NV = 0x9091;
const int GL_AFFINE_2D_NV = 0x9092;
const int GL_AFFINE_3D_NV = 0x9094;
const int GL_TRANSPOSE_AFFINE_2D_NV = 0x9096;
const int GL_TRANSPOSE_AFFINE_3D_NV = 0x9098;
const int GL_UTF8_NV = 0x909A;
const int GL_UTF16_NV = 0x909B;
const int GL_BOUNDING_BOX_OF_BOUNDING_BOXES_NV = 0x909C;
const int GL_PATH_COMMAND_COUNT_NV = 0x909D;
const int GL_PATH_COORD_COUNT_NV = 0x909E;
const int GL_PATH_DASH_ARRAY_COUNT_NV = 0x909F;
const int GL_PATH_COMPUTED_LENGTH_NV = 0x90A0;
const int GL_PATH_FILL_BOUNDING_BOX_NV = 0x90A1;
const int GL_PATH_STROKE_BOUNDING_BOX_NV = 0x90A2;
const int GL_SQUARE_NV = 0x90A3;
const int GL_ROUND_NV = 0x90A4;
const int GL_TRIANGULAR_NV = 0x90A5;
const int GL_BEVEL_NV = 0x90A6;
const int GL_MITER_REVERT_NV = 0x90A7;
const int GL_MITER_TRUNCATE_NV = 0x90A8;
const int GL_SKIP_MISSING_GLYPH_NV = 0x90A9;
const int GL_USE_MISSING_GLYPH_NV = 0x90AA;
const int GL_PATH_ERROR_POSITION_NV = 0x90AB;
const int GL_ACCUM_ADJACENT_PAIRS_NV = 0x90AD;
const int GL_ADJACENT_PAIRS_NV = 0x90AE;
const int GL_FIRST_TO_REST_NV = 0x90AF;
const int GL_PATH_GEN_MODE_NV = 0x90B0;
const int GL_PATH_GEN_COEFF_NV = 0x90B1;
const int GL_PATH_GEN_COMPONENTS_NV = 0x90B3;
const int GL_PATH_STENCIL_FUNC_NV = 0x90B7;
const int GL_PATH_STENCIL_REF_NV = 0x90B8;
const int GL_PATH_STENCIL_VALUE_MASK_NV = 0x90B9;
const int GL_PATH_STENCIL_DEPTH_OFFSET_FACTOR_NV = 0x90BD;
const int GL_PATH_STENCIL_DEPTH_OFFSET_UNITS_NV = 0x90BE;
const int GL_PATH_COVER_DEPTH_FUNC_NV = 0x90BF;
const int GL_PATH_DASH_OFFSET_RESET_NV = 0x90B4;
const int GL_MOVE_TO_RESETS_NV = 0x90B5;
const int GL_MOVE_TO_CONTINUES_NV = 0x90B6;
const int GL_CLOSE_PATH_NV = 0x00;
const int GL_MOVE_TO_NV = 0x02;
const int GL_RELATIVE_MOVE_TO_NV = 0x03;
const int GL_LINE_TO_NV = 0x04;
const int GL_RELATIVE_LINE_TO_NV = 0x05;
const int GL_HORIZONTAL_LINE_TO_NV = 0x06;
const int GL_RELATIVE_HORIZONTAL_LINE_TO_NV = 0x07;
const int GL_VERTICAL_LINE_TO_NV = 0x08;
const int GL_RELATIVE_VERTICAL_LINE_TO_NV = 0x09;
const int GL_QUADRATIC_CURVE_TO_NV = 0x0A;
const int GL_RELATIVE_QUADRATIC_CURVE_TO_NV = 0x0B;
const int GL_CUBIC_CURVE_TO_NV = 0x0C;
const int GL_RELATIVE_CUBIC_CURVE_TO_NV = 0x0D;
const int GL_SMOOTH_QUADRATIC_CURVE_TO_NV = 0x0E;
const int GL_RELATIVE_SMOOTH_QUADRATIC_CURVE_TO_NV = 0x0F;
const int GL_SMOOTH_CUBIC_CURVE_TO_NV = 0x10;
const int GL_RELATIVE_SMOOTH_CUBIC_CURVE_TO_NV = 0x11;
const int GL_SMALL_CCW_ARC_TO_NV = 0x12;
const int GL_RELATIVE_SMALL_CCW_ARC_TO_NV = 0x13;
const int GL_SMALL_CW_ARC_TO_NV = 0x14;
const int GL_RELATIVE_SMALL_CW_ARC_TO_NV = 0x15;
const int GL_LARGE_CCW_ARC_TO_NV = 0x16;
const int GL_RELATIVE_LARGE_CCW_ARC_TO_NV = 0x17;
const int GL_LARGE_CW_ARC_TO_NV = 0x18;
const int GL_RELATIVE_LARGE_CW_ARC_TO_NV = 0x19;
const int GL_RESTART_PATH_NV = 0xF0;
const int GL_DUP_FIRST_CUBIC_CURVE_TO_NV = 0xF2;
const int GL_DUP_LAST_CUBIC_CURVE_TO_NV = 0xF4;
const int GL_RECT_NV = 0xF6;
const int GL_CIRCULAR_CCW_ARC_TO_NV = 0xF8;
const int GL_CIRCULAR_CW_ARC_TO_NV = 0xFA;
const int GL_CIRCULAR_TANGENT_ARC_TO_NV = 0xFC;
const int GL_ARC_TO_NV = 0xFE;
const int GL_RELATIVE_ARC_TO_NV = 0xFF;
const int GL_BOLD_BIT_NV = 0x01;
const int GL_ITALIC_BIT_NV = 0x02;
const int GL_GLYPH_WIDTH_BIT_NV = 0x01;
const int GL_GLYPH_HEIGHT_BIT_NV = 0x02;
const int GL_GLYPH_HORIZONTAL_BEARING_X_BIT_NV = 0x04;
const int GL_GLYPH_HORIZONTAL_BEARING_Y_BIT_NV = 0x08;
const int GL_GLYPH_HORIZONTAL_BEARING_ADVANCE_BIT_NV = 0x10;
const int GL_GLYPH_VERTICAL_BEARING_X_BIT_NV = 0x20;
const int GL_GLYPH_VERTICAL_BEARING_Y_BIT_NV = 0x40;
const int GL_GLYPH_VERTICAL_BEARING_ADVANCE_BIT_NV = 0x80;
const int GL_GLYPH_HAS_KERNING_BIT_NV = 0x100;
const int GL_FONT_X_MIN_BOUNDS_BIT_NV = 0x00010000;
const int GL_FONT_Y_MIN_BOUNDS_BIT_NV = 0x00020000;
const int GL_FONT_X_MAX_BOUNDS_BIT_NV = 0x00040000;
const int GL_FONT_Y_MAX_BOUNDS_BIT_NV = 0x00080000;
const int GL_FONT_UNITS_PER_EM_BIT_NV = 0x00100000;
const int GL_FONT_ASCENDER_BIT_NV = 0x00200000;
const int GL_FONT_DESCENDER_BIT_NV = 0x00400000;
const int GL_FONT_HEIGHT_BIT_NV = 0x00800000;
const int GL_FONT_MAX_ADVANCE_WIDTH_BIT_NV = 0x01000000;
const int GL_FONT_MAX_ADVANCE_HEIGHT_BIT_NV = 0x02000000;
const int GL_FONT_UNDERLINE_POSITION_BIT_NV = 0x04000000;
const int GL_FONT_UNDERLINE_THICKNESS_BIT_NV = 0x08000000;
const int GL_FONT_HAS_KERNING_BIT_NV = 0x10000000;
const int GL_ROUNDED_RECT_NV = 0xE8;
const int GL_RELATIVE_ROUNDED_RECT_NV = 0xE9;
const int GL_ROUNDED_RECT2_NV = 0xEA;
const int GL_RELATIVE_ROUNDED_RECT2_NV = 0xEB;
const int GL_ROUNDED_RECT4_NV = 0xEC;
const int GL_RELATIVE_ROUNDED_RECT4_NV = 0xED;
const int GL_ROUNDED_RECT8_NV = 0xEE;
const int GL_RELATIVE_ROUNDED_RECT8_NV = 0xEF;
const int GL_RELATIVE_RECT_NV = 0xF7;
const int GL_FONT_GLYPHS_AVAILABLE_NV = 0x9368;
const int GL_FONT_TARGET_UNAVAILABLE_NV = 0x9369;
const int GL_FONT_UNAVAILABLE_NV = 0x936A;
const int GL_FONT_UNINTELLIGIBLE_NV = 0x936B;
const int GL_CONIC_CURVE_TO_NV = 0x1A;
const int GL_RELATIVE_CONIC_CURVE_TO_NV = 0x1B;
const int GL_FONT_NUM_GLYPH_INDICES_BIT_NV = 0x20000000;
const int GL_STANDARD_FONT_FORMAT_NV = 0x936C;
const int GL_PATH_PROJECTION_NV = 0x1701;
const int GL_PATH_MODELVIEW_NV = 0x1700;
const int GL_PATH_MODELVIEW_STACK_DEPTH_NV = 0x0BA3;
const int GL_PATH_MODELVIEW_MATRIX_NV = 0x0BA6;
const int GL_PATH_MAX_MODELVIEW_STACK_DEPTH_NV = 0x0D36;
const int GL_PATH_TRANSPOSE_MODELVIEW_MATRIX_NV = 0x84E3;
const int GL_PATH_PROJECTION_STACK_DEPTH_NV = 0x0BA4;
const int GL_PATH_PROJECTION_MATRIX_NV = 0x0BA7;
const int GL_PATH_MAX_PROJECTION_STACK_DEPTH_NV = 0x0D38;
const int GL_PATH_TRANSPOSE_PROJECTION_MATRIX_NV = 0x84E4;
const int GL_FRAGMENT_INPUT_NV = 0x936D;
//GL_NV_path_rendering_shared_edge
const int GL_NV_path_rendering_shared_edge = 1;
const int GL_SHARED_EDGE_NV = 0xC0;
//GL_NV_primitive_shading_rate
const int GL_NV_primitive_shading_rate = 1;
const int GL_SHADING_RATE_IMAGE_PER_PRIMITIVE_NV = 0x95B1;
const int GL_SHADING_RATE_IMAGE_PALETTE_COUNT_NV = 0x95B2;
//GL_NV_representative_fragment_test
const int GL_NV_representative_fragment_test = 1;
const int GL_REPRESENTATIVE_FRAGMENT_TEST_NV = 0x937F;
//GL_NV_sample_locations
const int GL_NV_sample_locations = 1;
const int GL_SAMPLE_LOCATION_SUBPIXEL_BITS_NV = 0x933D;
const int GL_SAMPLE_LOCATION_PIXEL_GRID_WIDTH_NV = 0x933E;
const int GL_SAMPLE_LOCATION_PIXEL_GRID_HEIGHT_NV = 0x933F;
const int GL_PROGRAMMABLE_SAMPLE_LOCATION_TABLE_SIZE_NV = 0x9340;
const int GL_SAMPLE_LOCATION_NV = 0x8E50;
const int GL_PROGRAMMABLE_SAMPLE_LOCATION_NV = 0x9341;
const int GL_FRAMEBUFFER_PROGRAMMABLE_SAMPLE_LOCATIONS_NV = 0x9342;
const int GL_FRAMEBUFFER_SAMPLE_LOCATION_PIXEL_GRID_NV = 0x9343;
//GL_NV_sample_mask_override_coverage
const int GL_NV_sample_mask_override_coverage = 1;
//GL_NV_scissor_exclusive
const int GL_NV_scissor_exclusive = 1;
const int GL_SCISSOR_TEST_EXCLUSIVE_NV = 0x9555;
const int GL_SCISSOR_BOX_EXCLUSIVE_NV = 0x9556;
//GL_NV_shader_atomic_counters
const int GL_NV_shader_atomic_counters = 1;
//GL_NV_shader_atomic_float
const int GL_NV_shader_atomic_float = 1;
//GL_NV_shader_atomic_float64
const int GL_NV_shader_atomic_float64 = 1;
//GL_NV_shader_atomic_fp16_vector
const int GL_NV_shader_atomic_fp16_vector = 1;
//GL_NV_shader_atomic_int64
const int GL_NV_shader_atomic_int64 = 1;
//GL_NV_shader_buffer_load
const int GL_NV_shader_buffer_load = 1;
const int GL_BUFFER_GPU_ADDRESS_NV = 0x8F1D;
const int GL_GPU_ADDRESS_NV = 0x8F34;
const int GL_MAX_SHADER_BUFFER_ADDRESS_NV = 0x8F35;
//GL_NV_shader_buffer_store
const int GL_NV_shader_buffer_store = 1;
const int GL_SHADER_GLOBAL_ACCESS_BARRIER_BIT_NV = 0x00000010;
//GL_NV_shader_subgroup_partitioned
const int GL_NV_shader_subgroup_partitioned = 1;
const int GL_SUBGROUP_FEATURE_PARTITIONED_BIT_NV = 0x00000100;
//GL_NV_shader_texture_footprint
const int GL_NV_shader_texture_footprint = 1;
//GL_NV_shader_thread_group
const int GL_NV_shader_thread_group = 1;
const int GL_WARP_SIZE_NV = 0x9339;
const int GL_WARPS_PER_SM_NV = 0x933A;
const int GL_SM_COUNT_NV = 0x933B;
//GL_NV_shader_thread_shuffle
const int GL_NV_shader_thread_shuffle = 1;
//GL_NV_shading_rate_image
const int GL_NV_shading_rate_image = 1;
const int GL_SHADING_RATE_IMAGE_NV = 0x9563;
const int GL_SHADING_RATE_NO_INVOCATIONS_NV = 0x9564;
const int GL_SHADING_RATE_1_INVOCATION_PER_PIXEL_NV = 0x9565;
const int GL_SHADING_RATE_1_INVOCATION_PER_1X2_PIXELS_NV = 0x9566;
const int GL_SHADING_RATE_1_INVOCATION_PER_2X1_PIXELS_NV = 0x9567;
const int GL_SHADING_RATE_1_INVOCATION_PER_2X2_PIXELS_NV = 0x9568;
const int GL_SHADING_RATE_1_INVOCATION_PER_2X4_PIXELS_NV = 0x9569;
const int GL_SHADING_RATE_1_INVOCATION_PER_4X2_PIXELS_NV = 0x956A;
const int GL_SHADING_RATE_1_INVOCATION_PER_4X4_PIXELS_NV = 0x956B;
const int GL_SHADING_RATE_2_INVOCATIONS_PER_PIXEL_NV = 0x956C;
const int GL_SHADING_RATE_4_INVOCATIONS_PER_PIXEL_NV = 0x956D;
const int GL_SHADING_RATE_8_INVOCATIONS_PER_PIXEL_NV = 0x956E;
const int GL_SHADING_RATE_16_INVOCATIONS_PER_PIXEL_NV = 0x956F;
const int GL_SHADING_RATE_IMAGE_BINDING_NV = 0x955B;
const int GL_SHADING_RATE_IMAGE_TEXEL_WIDTH_NV = 0x955C;
const int GL_SHADING_RATE_IMAGE_TEXEL_HEIGHT_NV = 0x955D;
const int GL_SHADING_RATE_IMAGE_PALETTE_SIZE_NV = 0x955E;
const int GL_MAX_COARSE_FRAGMENT_SAMPLES_NV = 0x955F;
const int GL_SHADING_RATE_SAMPLE_ORDER_DEFAULT_NV = 0x95AE;
const int GL_SHADING_RATE_SAMPLE_ORDER_PIXEL_MAJOR_NV = 0x95AF;
const int GL_SHADING_RATE_SAMPLE_ORDER_SAMPLE_MAJOR_NV = 0x95B0;
//GL_NV_stereo_view_rendering
const int GL_NV_stereo_view_rendering = 1;
//GL_NV_texture_barrier
const int GL_NV_texture_barrier = 1;
//GL_NV_texture_rectangle_compressed
const int GL_NV_texture_rectangle_compressed = 1;
//GL_NV_uniform_buffer_unified_memory
const int GL_NV_uniform_buffer_unified_memory = 1;
const int GL_UNIFORM_BUFFER_UNIFIED_NV = 0x936E;
const int GL_UNIFORM_BUFFER_ADDRESS_NV = 0x936F;
const int GL_UNIFORM_BUFFER_LENGTH_NV = 0x9370;
//GL_NV_vertex_attrib_integer_64bit
const int GL_NV_vertex_attrib_integer_64bit = 1;
//GL_NV_vertex_buffer_unified_memory
const int GL_NV_vertex_buffer_unified_memory = 1;
const int GL_VERTEX_ATTRIB_ARRAY_UNIFIED_NV = 0x8F1E;
const int GL_ELEMENT_ARRAY_UNIFIED_NV = 0x8F1F;
const int GL_VERTEX_ATTRIB_ARRAY_ADDRESS_NV = 0x8F20;
const int GL_VERTEX_ARRAY_ADDRESS_NV = 0x8F21;
const int GL_NORMAL_ARRAY_ADDRESS_NV = 0x8F22;
const int GL_COLOR_ARRAY_ADDRESS_NV = 0x8F23;
const int GL_INDEX_ARRAY_ADDRESS_NV = 0x8F24;
const int GL_TEXTURE_COORD_ARRAY_ADDRESS_NV = 0x8F25;
const int GL_EDGE_FLAG_ARRAY_ADDRESS_NV = 0x8F26;
const int GL_SECONDARY_COLOR_ARRAY_ADDRESS_NV = 0x8F27;
const int GL_FOG_COORD_ARRAY_ADDRESS_NV = 0x8F28;
const int GL_ELEMENT_ARRAY_ADDRESS_NV = 0x8F29;
const int GL_VERTEX_ATTRIB_ARRAY_LENGTH_NV = 0x8F2A;
const int GL_VERTEX_ARRAY_LENGTH_NV = 0x8F2B;
const int GL_NORMAL_ARRAY_LENGTH_NV = 0x8F2C;
const int GL_COLOR_ARRAY_LENGTH_NV = 0x8F2D;
const int GL_INDEX_ARRAY_LENGTH_NV = 0x8F2E;
const int GL_TEXTURE_COORD_ARRAY_LENGTH_NV = 0x8F2F;
const int GL_EDGE_FLAG_ARRAY_LENGTH_NV = 0x8F30;
const int GL_SECONDARY_COLOR_ARRAY_LENGTH_NV = 0x8F31;
const int GL_FOG_COORD_ARRAY_LENGTH_NV = 0x8F32;
const int GL_ELEMENT_ARRAY_LENGTH_NV = 0x8F33;
const int GL_DRAW_INDIRECT_UNIFIED_NV = 0x8F40;
const int GL_DRAW_INDIRECT_ADDRESS_NV = 0x8F41;
const int GL_DRAW_INDIRECT_LENGTH_NV = 0x8F42;
//GL_NV_viewport_array2
const int GL_NV_viewport_array2 = 1;
//GL_NV_viewport_swizzle
const int GL_NV_viewport_swizzle = 1;
const int GL_VIEWPORT_SWIZZLE_POSITIVE_X_NV = 0x9350;
const int GL_VIEWPORT_SWIZZLE_NEGATIVE_X_NV = 0x9351;
const int GL_VIEWPORT_SWIZZLE_POSITIVE_Y_NV = 0x9352;
const int GL_VIEWPORT_SWIZZLE_NEGATIVE_Y_NV = 0x9353;
const int GL_VIEWPORT_SWIZZLE_POSITIVE_Z_NV = 0x9354;
const int GL_VIEWPORT_SWIZZLE_NEGATIVE_Z_NV = 0x9355;
const int GL_VIEWPORT_SWIZZLE_POSITIVE_W_NV = 0x9356;
const int GL_VIEWPORT_SWIZZLE_NEGATIVE_W_NV = 0x9357;
const int GL_VIEWPORT_SWIZZLE_X_NV = 0x9358;
const int GL_VIEWPORT_SWIZZLE_Y_NV = 0x9359;
const int GL_VIEWPORT_SWIZZLE_Z_NV = 0x935A;
const int GL_VIEWPORT_SWIZZLE_W_NV = 0x935B;
//GL_OVR_multiview
const int GL_OVR_multiview = 1;
const int GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_NUM_VIEWS_OVR = 0x9630;
const int GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_BASE_VIEW_INDEX_OVR = 0x9632;
const int GL_MAX_VIEWS_OVR = 0x9631;
const int GL_FRAMEBUFFER_INCOMPLETE_VIEW_TARGETS_OVR = 0x9633;
//GL_OVR_multiview2
const int GL_OVR_multiview2 = 1;

//GL_VERSION_1_0
typedef GlCullFaceNative = Void Function(Uint32 mode);
typedef GlCullFace = void Function(int mode);

typedef GlFrontFaceNative = Void Function(Uint32 mode);
typedef GlFrontFace = void Function(int mode);

typedef GlHintNative = Void Function(Uint32 target, Uint32 mode);
typedef GlHint = void Function(int target, int mode);

typedef GlLineWidthNative = Void Function(Float width);
typedef GlLineWidth = void Function(double width);

typedef GlPointSizeNative = Void Function(Float size);
typedef GlPointSize = void Function(double size);

typedef GlPolygonModeNative = Void Function(Uint32 face, Uint32 mode);
typedef GlPolygonMode = void Function(int face, int mode);

typedef GlScissorNative = Void Function(
    Int32 x, Int32 y, Int32 width, Int32 height);
typedef GlScissor = void Function(int x, int y, int width, int height);

typedef GlTexParameterfNative = Void Function(
    Uint32 target, Uint32 pname, Float param);
typedef GlTexParameterf = void Function(int target, int pname, double param);

typedef GlTexParameterfvNative = Void Function(
    Uint32 target, Uint32 pname, Pointer<Float> params);
typedef GlTexParameterfv = void Function(
    int target, int pname, Pointer<Float> params);

typedef GlTexParameteriNative = Void Function(
    Uint32 target, Uint32 pname, Int32 param);
typedef GlTexParameteri = void Function(int target, int pname, int param);

typedef GlTexParameterivNative = Void Function(
    Uint32 target, Uint32 pname, Pointer<Int32> params);
typedef GlTexParameteriv = void Function(
    int target, int pname, Pointer<Int32> params);

typedef GlTexImage1DNative = Void Function(
    Uint32 target,
    Int32 level,
    Int32 internalformat,
    Int32 width,
    Int32 border,
    Uint32 format,
    Uint32 type,
    Pointer pixels);
typedef GlTexImage1D = void Function(int target, int level, int internalformat,
    int width, int border, int format, int type, Pointer pixels);

typedef GlTexImage2DNative = Void Function(
    Uint32 target,
    Int32 level,
    Int32 internalformat,
    Int32 width,
    Int32 height,
    Int32 border,
    Uint32 format,
    Uint32 type,
    Pointer pixels);
typedef GlTexImage2D = void Function(int target, int level, int internalformat,
    int width, int height, int border, int format, int type, Pointer pixels);

typedef GlDrawBufferNative = Void Function(Uint32 buf);
typedef GlDrawBuffer = void Function(int buf);

typedef GlClearNative = Void Function(Uint32 mask);
typedef GlClear = void Function(int mask);

typedef GlClearColorNative = Void Function(
    Float red, Float green, Float blue, Float alpha);
typedef GlClearColor = void Function(
    double red, double green, double blue, double alpha);

typedef GlClearStencilNative = Void Function(Int32 s);
typedef GlClearStencil = void Function(int s);

typedef GlClearDepthNative = Void Function(Double depth);
typedef GlClearDepth = void Function(double depth);

typedef GlStencilMaskNative = Void Function(Uint32 mask);
typedef GlStencilMask = void Function(int mask);

typedef GlColorMaskNative = Void Function(
    Uint8 red, Uint8 green, Uint8 blue, Uint8 alpha);
typedef GlColorMask = void Function(int red, int green, int blue, int alpha);

typedef GlDepthMaskNative = Void Function(Uint8 flag);
typedef GlDepthMask = void Function(int flag);

typedef GlDisableNative = Void Function(Uint32 cap);
typedef GlDisable = void Function(int cap);

typedef GlEnableNative = Void Function(Uint32 cap);
typedef GlEnable = void Function(int cap);

typedef GlFinishNative = Void Function();
typedef GlFinish = void Function();

typedef GlFlushNative = Void Function();
typedef GlFlush = void Function();

typedef GlBlendFuncNative = Void Function(Uint32 sfactor, Uint32 dfactor);
typedef GlBlendFunc = void Function(int sfactor, int dfactor);

typedef GlLogicOpNative = Void Function(Uint32 opcode);
typedef GlLogicOp = void Function(int opcode);

typedef GlStencilFuncNative = Void Function(
    Uint32 func, Int32 ref, Uint32 mask);
typedef GlStencilFunc = void Function(int func, int ref, int mask);

typedef GlStencilOpNative = Void Function(
    Uint32 fail, Uint32 zfail, Uint32 zpass);
typedef GlStencilOp = void Function(int fail, int zfail, int zpass);

typedef GlDepthFuncNative = Void Function(Uint32 func);
typedef GlDepthFunc = void Function(int func);

typedef GlPixelStorefNative = Void Function(Uint32 pname, Float param);
typedef GlPixelStoref = void Function(int pname, double param);

typedef GlPixelStoreiNative = Void Function(Uint32 pname, Int32 param);
typedef GlPixelStorei = void Function(int pname, int param);

typedef GlReadBufferNative = Void Function(Uint32 src);
typedef GlReadBuffer = void Function(int src);

typedef GlReadPixelsNative = Void Function(Int32 x, Int32 y, Int32 width,
    Int32 height, Uint32 format, Uint32 type, Pointer pixels);
typedef GlReadPixels = void Function(
    int x, int y, int width, int height, int format, int type, Pointer pixels);

typedef GlGetBooleanvNative = Void Function(Uint32 pname, Pointer data);
typedef GlGetBooleanv = void Function(int pname, Pointer data);

typedef GlGetDoublevNative = Void Function(Uint32 pname, Pointer<Double> data);
typedef GlGetDoublev = void Function(int pname, Pointer<Double> data);

typedef GlGetErrorNative = Uint32 Function();
typedef GlGetError = int Function();

typedef GlGetFloatvNative = Void Function(Uint32 pname, Pointer<Float> data);
typedef GlGetFloatv = void Function(int pname, Pointer<Float> data);

typedef GlGetIntegervNative = Void Function(Uint32 pname, Pointer<Int32> data);
typedef GlGetIntegerv = void Function(int pname, Pointer<Int32> data);

typedef GlGetStringNative = Pointer Function(Uint32 name);
typedef GlGetString = /*String*/ Pointer Function(int name);

typedef GlGetTexImageNative = Void Function(
    Uint32 target, Int32 level, Uint32 format, Uint32 type, Pointer pixels);
typedef GlGetTexImage = void Function(
    int target, int level, int format, int type, Pointer pixels);

typedef GlGetTexParameterfvNative = Void Function(
    Uint32 target, Uint32 pname, Pointer<Float> params);
typedef GlGetTexParameterfv = void Function(
    int target, int pname, Pointer<Float> params);

typedef GlGetTexParameterivNative = Void Function(
    Uint32 target, Uint32 pname, Pointer<Int32> params);
typedef GlGetTexParameteriv = void Function(
    int target, int pname, Pointer<Int32> params);

typedef GlGetTexLevelParameterfvNative = Void Function(
    Uint32 target, Int32 level, Uint32 pname, Pointer<Float> params);
typedef GlGetTexLevelParameterfv = void Function(
    int target, int level, int pname, Pointer<Float> params);

typedef GlGetTexLevelParameterivNative = Void Function(
    Uint32 target, Int32 level, Uint32 pname, Pointer<Int32> params);
typedef GlGetTexLevelParameteriv = void Function(
    int target, int level, int pname, Pointer<Int32> params);

typedef GlIsEnabledNative = Uint8 Function(Uint32 cap);
typedef GlIsEnabled = int Function(int cap);

typedef GlDepthRangeNative = Void Function(Double n, Double f);
typedef GlDepthRange = void Function(double n, double f);

typedef GlViewportNative = Void Function(
    Int32 x, Int32 y, Int32 width, Int32 height);
typedef GlViewport = void Function(int x, int y, int width, int height);

//GL_VERSION_1_1
typedef GlDrawArraysNative = Void Function(
    Uint32 mode, Int32 first, Int32 count);
typedef GlDrawArrays = void Function(int mode, int first, int count);

typedef GlDrawElementsNative = Void Function(
    Uint32 mode, Int32 count, Uint32 type, Pointer indices);
typedef GlDrawElements = void Function(
    int mode, int count, int type, Pointer indices);

typedef GlGetPointervNative = Void Function(Uint32 pname, Pointer params);
typedef GlGetPointerv = void Function(int pname, Pointer params);

typedef GlPolygonOffsetNative = Void Function(Float factor, Float units);
typedef GlPolygonOffset = void Function(double factor, double units);

typedef GlCopyTexImage1DNative = Void Function(Uint32 target, Int32 level,
    Uint32 internalformat, Int32 x, Int32 y, Int32 width, Int32 border);
typedef GlCopyTexImage1D = void Function(int target, int level,
    int internalformat, int x, int y, int width, int border);

typedef GlCopyTexImage2DNative = Void Function(
    Uint32 target,
    Int32 level,
    Uint32 internalformat,
    Int32 x,
    Int32 y,
    Int32 width,
    Int32 height,
    Int32 border);
typedef GlCopyTexImage2D = void Function(int target, int level,
    int internalformat, int x, int y, int width, int height, int border);

typedef GlCopyTexSubImage1DNative = Void Function(
    Uint32 target, Int32 level, Int32 xoffset, Int32 x, Int32 y, Int32 width);
typedef GlCopyTexSubImage1D = void Function(
    int target, int level, int xoffset, int x, int y, int width);

typedef GlCopyTexSubImage2DNative = Void Function(Uint32 target, Int32 level,
    Int32 xoffset, Int32 yoffset, Int32 x, Int32 y, Int32 width, Int32 height);
typedef GlCopyTexSubImage2D = void Function(int target, int level, int xoffset,
    int yoffset, int x, int y, int width, int height);

typedef GlTexSubImage1DNative = Void Function(Uint32 target, Int32 level,
    Int32 xoffset, Int32 width, Uint32 format, Uint32 type, Pointer pixels);
typedef GlTexSubImage1D = void Function(int target, int level, int xoffset,
    int width, int format, int type, Pointer pixels);

typedef GlTexSubImage2DNative = Void Function(
    Uint32 target,
    Int32 level,
    Int32 xoffset,
    Int32 yoffset,
    Int32 width,
    Int32 height,
    Uint32 format,
    Uint32 type,
    Pointer pixels);
typedef GlTexSubImage2D = void Function(int target, int level, int xoffset,
    int yoffset, int width, int height, int format, int type, Pointer pixels);

typedef GlBindTextureNative = Void Function(Uint32 target, Uint32 texture);
typedef GlBindTexture = void Function(int target, int texture);

typedef GlDeleteTexturesNative = Void Function(
    Int32 n, Pointer<Uint32> textures);
typedef GlDeleteTextures = void Function(int n, Pointer<Uint32> textures);

typedef GlGenTexturesNative = Void Function(Int32 n, Pointer<Uint32> textures);
typedef GlGenTextures = void Function(int n, Pointer<Uint32> textures);

typedef GlIsTextureNative = Uint8 Function(Uint32 texture);
typedef GlIsTexture = int Function(int texture);

//GL_VERSION_1_2
typedef GlDrawRangeElementsNative = Void Function(Uint32 mode, Uint32 start,
    Uint32 end, Int32 count, Uint32 type, Pointer indices);
typedef GlDrawRangeElements = void Function(
    int mode, int start, int end, int count, int type, Pointer indices);

typedef GlTexImage3DNative = Void Function(
    Uint32 target,
    Int32 level,
    Int32 internalformat,
    Int32 width,
    Int32 height,
    Int32 depth,
    Int32 border,
    Uint32 format,
    Uint32 type,
    Pointer pixels);
typedef GlTexImage3D = void Function(
    int target,
    int level,
    int internalformat,
    int width,
    int height,
    int depth,
    int border,
    int format,
    int type,
    Pointer pixels);

typedef GlTexSubImage3DNative = Void Function(
    Uint32 target,
    Int32 level,
    Int32 xoffset,
    Int32 yoffset,
    Int32 zoffset,
    Int32 width,
    Int32 height,
    Int32 depth,
    Uint32 format,
    Uint32 type,
    Pointer pixels);
typedef GlTexSubImage3D = void Function(
    int target,
    int level,
    int xoffset,
    int yoffset,
    int zoffset,
    int width,
    int height,
    int depth,
    int format,
    int type,
    Pointer pixels);

typedef GlCopyTexSubImage3DNative = Void Function(
    Uint32 target,
    Int32 level,
    Int32 xoffset,
    Int32 yoffset,
    Int32 zoffset,
    Int32 x,
    Int32 y,
    Int32 width,
    Int32 height);
typedef GlCopyTexSubImage3D = void Function(int target, int level, int xoffset,
    int yoffset, int zoffset, int x, int y, int width, int height);

//GL_VERSION_1_3
typedef GlActiveTextureNative = Void Function(Uint32 texture);
typedef GlActiveTexture = void Function(int texture);

typedef GlSampleCoverageNative = Void Function(Float value, Uint8 invert);
typedef GlSampleCoverage = void Function(double value, int invert);

typedef GlCompressedTexImage3DNative = Void Function(
    Uint32 target,
    Int32 level,
    Uint32 internalformat,
    Int32 width,
    Int32 height,
    Int32 depth,
    Int32 border,
    Int32 imageSize,
    Pointer data);
typedef GlCompressedTexImage3D = void Function(
    int target,
    int level,
    int internalformat,
    int width,
    int height,
    int depth,
    int border,
    int imageSize,
    Pointer data);

typedef GlCompressedTexImage2DNative = Void Function(
    Uint32 target,
    Int32 level,
    Uint32 internalformat,
    Int32 width,
    Int32 height,
    Int32 border,
    Int32 imageSize,
    Pointer data);
typedef GlCompressedTexImage2D = void Function(
    int target,
    int level,
    int internalformat,
    int width,
    int height,
    int border,
    int imageSize,
    Pointer data);

typedef GlCompressedTexImage1DNative = Void Function(
    Uint32 target,
    Int32 level,
    Uint32 internalformat,
    Int32 width,
    Int32 border,
    Int32 imageSize,
    Pointer data);
typedef GlCompressedTexImage1D = void Function(int target, int level,
    int internalformat, int width, int border, int imageSize, Pointer data);

typedef GlCompressedTexSubImage3DNative = Void Function(
    Uint32 target,
    Int32 level,
    Int32 xoffset,
    Int32 yoffset,
    Int32 zoffset,
    Int32 width,
    Int32 height,
    Int32 depth,
    Uint32 format,
    Int32 imageSize,
    Pointer data);
typedef GlCompressedTexSubImage3D = void Function(
    int target,
    int level,
    int xoffset,
    int yoffset,
    int zoffset,
    int width,
    int height,
    int depth,
    int format,
    int imageSize,
    Pointer data);

typedef GlCompressedTexSubImage2DNative = Void Function(
    Uint32 target,
    Int32 level,
    Int32 xoffset,
    Int32 yoffset,
    Int32 width,
    Int32 height,
    Uint32 format,
    Int32 imageSize,
    Pointer data);
typedef GlCompressedTexSubImage2D = void Function(
    int target,
    int level,
    int xoffset,
    int yoffset,
    int width,
    int height,
    int format,
    int imageSize,
    Pointer data);

typedef GlCompressedTexSubImage1DNative = Void Function(
    Uint32 target,
    Int32 level,
    Int32 xoffset,
    Int32 width,
    Uint32 format,
    Int32 imageSize,
    Pointer data);
typedef GlCompressedTexSubImage1D = void Function(int target, int level,
    int xoffset, int width, int format, int imageSize, Pointer data);

typedef GlGetCompressedTexImageNative = Void Function(
    Uint32 target, Int32 level, Pointer img);
typedef GlGetCompressedTexImage = void Function(
    int target, int level, Pointer img);

//GL_VERSION_1_4
typedef GlBlendFuncSeparateNative = Void Function(Uint32 sfactorRGB,
    Uint32 dfactorRGB, Uint32 sfactorAlpha, Uint32 dfactorAlpha);
typedef GlBlendFuncSeparate = void Function(
    int sfactorRGB, int dfactorRGB, int sfactorAlpha, int dfactorAlpha);

typedef GlMultiDrawArraysNative = Void Function(
    Uint32 mode, Pointer<Int32> first, Pointer<Int32> count, Int32 drawcount);
typedef GlMultiDrawArrays = void Function(
    int mode, Pointer<Int32> first, Pointer<Int32> count, int drawcount);

typedef GlMultiDrawElementsNative = Void Function(Uint32 mode,
    Pointer<Int32> count, Uint32 type, Pointer indices, Int32 drawcount);
typedef GlMultiDrawElements = void Function(
    int mode, Pointer<Int32> count, int type, Pointer indices, int drawcount);

typedef GlPointParameterfNative = Void Function(Uint32 pname, Float param);
typedef GlPointParameterf = void Function(int pname, double param);

typedef GlPointParameterfvNative = Void Function(
    Uint32 pname, Pointer<Float> params);
typedef GlPointParameterfv = void Function(int pname, Pointer<Float> params);

typedef GlPointParameteriNative = Void Function(Uint32 pname, Int32 param);
typedef GlPointParameteri = void Function(int pname, int param);

typedef GlPointParameterivNative = Void Function(
    Uint32 pname, Pointer<Int32> params);
typedef GlPointParameteriv = void Function(int pname, Pointer<Int32> params);

typedef GlBlendColorNative = Void Function(
    Float red, Float green, Float blue, Float alpha);
typedef GlBlendColor = void Function(
    double red, double green, double blue, double alpha);

typedef GlBlendEquationNative = Void Function(Uint32 mode);
typedef GlBlendEquation = void Function(int mode);

//GL_VERSION_1_5
typedef GlGenQueriesNative = Void Function(Int32 n, Pointer<Uint32> ids);
typedef GlGenQueries = void Function(int n, Pointer<Uint32> ids);

typedef GlDeleteQueriesNative = Void Function(Int32 n, Pointer<Uint32> ids);
typedef GlDeleteQueries = void Function(int n, Pointer<Uint32> ids);

typedef GlIsQueryNative = Uint8 Function(Uint32 id);
typedef GlIsQuery = int Function(int id);

typedef GlBeginQueryNative = Void Function(Uint32 target, Uint32 id);
typedef GlBeginQuery = void Function(int target, int id);

typedef GlEndQueryNative = Void Function(Uint32 target);
typedef GlEndQuery = void Function(int target);

typedef GlGetQueryivNative = Void Function(
    Uint32 target, Uint32 pname, Pointer<Int32> params);
typedef GlGetQueryiv = void Function(
    int target, int pname, Pointer<Int32> params);

typedef GlGetQueryObjectivNative = Void Function(
    Uint32 id, Uint32 pname, Pointer<Int32> params);
typedef GlGetQueryObjectiv = void Function(
    int id, int pname, Pointer<Int32> params);

typedef GlGetQueryObjectuivNative = Void Function(
    Uint32 id, Uint32 pname, Pointer<Uint32> params);
typedef GlGetQueryObjectuiv = void Function(
    int id, int pname, Pointer<Uint32> params);

typedef GlBindBufferNative = Void Function(Uint32 target, Uint32 buffer);
typedef GlBindBuffer = void Function(int target, int buffer);

typedef GlDeleteBuffersNative = Void Function(Int32 n, Pointer<Uint32> buffers);
typedef GlDeleteBuffers = void Function(int n, Pointer<Uint32> buffers);

typedef GlGenBuffersNative = Void Function(Int32 n, Pointer<Uint32> buffers);
typedef GlGenBuffers = void Function(int n, Pointer<Uint32> buffers);

typedef GlIsBufferNative = Uint8 Function(Uint32 buffer);
typedef GlIsBuffer = int Function(int buffer);

typedef GlBufferDataNative = Void Function(
    Uint32 target, Int64 size, Pointer data, Uint32 usage);
typedef GlBufferData = void Function(
    int target, int size, Pointer data, int usage);

typedef GlBufferSubDataNative = Void Function(
    Uint32 target, Int64 offset, Int64 size, Pointer data);
typedef GlBufferSubData = void Function(
    int target, int offset, int size, Pointer data);

typedef GlGetBufferSubDataNative = Void Function(
    Uint32 target, Int64 offset, Int64 size, Pointer data);
typedef GlGetBufferSubData = void Function(
    int target, int offset, int size, Pointer data);

typedef GlMapBufferNative = Pointer Function(Uint32 target, Uint32 access);
typedef GlMapBuffer = Pointer Function(int target, int access);

typedef GlUnmapBufferNative = Uint8 Function(Uint32 target);
typedef GlUnmapBuffer = int Function(int target);

typedef GlGetBufferParameterivNative = Void Function(
    Uint32 target, Uint32 pname, Pointer<Int32> params);
typedef GlGetBufferParameteriv = void Function(
    int target, int pname, Pointer<Int32> params);

typedef GlGetBufferPointervNative = Void Function(
    Uint32 target, Uint32 pname, Pointer params);
typedef GlGetBufferPointerv = void Function(
    int target, int pname, Pointer params);

//GL_VERSION_2_0
typedef GlBlendEquationSeparateNative = Void Function(
    Uint32 modeRGB, Uint32 modeAlpha);
typedef GlBlendEquationSeparate = void Function(int modeRGB, int modeAlpha);

typedef GlDrawBuffersNative = Void Function(Int32 n, Pointer<Uint32> bufs);
typedef GlDrawBuffers = void Function(int n, Pointer<Uint32> bufs);

typedef GlStencilOpSeparateNative = Void Function(
    Uint32 face, Uint32 sfail, Uint32 dpfail, Uint32 dppass);
typedef GlStencilOpSeparate = void Function(
    int face, int sfail, int dpfail, int dppass);

typedef GlStencilFuncSeparateNative = Void Function(
    Uint32 face, Uint32 func, Int32 ref, Uint32 mask);
typedef GlStencilFuncSeparate = void Function(
    int face, int func, int ref, int mask);

typedef GlStencilMaskSeparateNative = Void Function(Uint32 face, Uint32 mask);
typedef GlStencilMaskSeparate = void Function(int face, int mask);

typedef GlAttachShaderNative = Void Function(Uint32 program, Uint32 shader);
typedef GlAttachShader = void Function(int program, int shader);

typedef GlBindAttribLocationNative = Void Function(
    Uint32 program, Uint32 index, Pointer name);
typedef GlBindAttribLocation = void Function(
    int program, int index, /*String*/ Pointer name);

typedef GlCompileShaderNative = Void Function(Uint32 shader);
typedef GlCompileShader = void Function(int shader);

typedef GlCreateProgramNative = Uint32 Function();
typedef GlCreateProgram = int Function();

typedef GlCreateShaderNative = Uint32 Function(Uint32 type);
typedef GlCreateShader = int Function(int type);

typedef GlDeleteProgramNative = Void Function(Uint32 program);
typedef GlDeleteProgram = void Function(int program);

typedef GlDeleteShaderNative = Void Function(Uint32 shader);
typedef GlDeleteShader = void Function(int shader);

typedef GlDetachShaderNative = Void Function(Uint32 program, Uint32 shader);
typedef GlDetachShader = void Function(int program, int shader);

typedef GlDisableVertexAttribArrayNative = Void Function(Uint32 index);
typedef GlDisableVertexAttribArray = void Function(int index);

typedef GlEnableVertexAttribArrayNative = Void Function(Uint32 index);
typedef GlEnableVertexAttribArray = void Function(int index);

typedef GlGetActiveAttribNative = Void Function(
    Uint32 program,
    Uint32 index,
    Int32 bufSize,
    Pointer<Int32> length,
    Pointer<Int32> size,
    Pointer<Uint32> type,
    Pointer name);
typedef GlGetActiveAttrib = void Function(
    int program,
    int index,
    int bufSize,
    Pointer<Int32> length,
    Pointer<Int32> size,
    Pointer<Uint32> type,
    Pointer name);

typedef GlGetActiveUniformNative = Void Function(
    Uint32 program,
    Uint32 index,
    Int32 bufSize,
    Pointer<Int32> length,
    Pointer<Int32> size,
    Pointer<Uint32> type,
    Pointer name);
typedef GlGetActiveUniform = void Function(
    int program,
    int index,
    int bufSize,
    Pointer<Int32> length,
    Pointer<Int32> size,
    Pointer<Uint32> type,
    Pointer name);

typedef GlGetAttachedShadersNative = Void Function(Uint32 program,
    Int32 maxCount, Pointer<Int32> count, Pointer<Uint32> shaders);
typedef GlGetAttachedShaders = void Function(
    int program, int maxCount, Pointer<Int32> count, Pointer<Uint32> shaders);

typedef GlGetAttribLocationNative = Int32 Function(
    Uint32 program, Pointer name);
typedef GlGetAttribLocation = int Function(
    int program, /*String*/ Pointer name);

typedef GlGetProgramivNative = Void Function(
    Uint32 program, Uint32 pname, Pointer<Int32> params);
typedef GlGetProgramiv = void Function(
    int program, int pname, Pointer<Int32> params);

typedef GlGetProgramInfoLogNative = Void Function(
    Uint32 program, Int32 bufSize, Pointer<Int32> length, Pointer infoLog);
typedef GlGetProgramInfoLog = void Function(
    int program, int bufSize, Pointer<Int32> length, Pointer infoLog);

typedef GlGetShaderivNative = Void Function(
    Uint32 shader, Uint32 pname, Pointer<Int32> params);
typedef GlGetShaderiv = void Function(
    int shader, int pname, Pointer<Int32> params);

typedef GlGetShaderInfoLogNative = Void Function(
    Uint32 shader, Int32 bufSize, Pointer<Int32> length, Pointer infoLog);
typedef GlGetShaderInfoLog = void Function(
    int shader, int bufSize, Pointer<Int32> length, Pointer infoLog);

typedef GlGetShaderSourceNative = Void Function(
    Uint32 shader, Int32 bufSize, Pointer<Int32> length, Pointer source);
typedef GlGetShaderSource = void Function(
    int shader, int bufSize, Pointer<Int32> length, Pointer source);

typedef GlGetUniformLocationNative = Int32 Function(
    Uint32 program, Pointer name);
typedef GlGetUniformLocation = int Function(
    int program, /*String*/ Pointer name);

typedef GlGetUniformfvNative = Void Function(
    Uint32 program, Int32 location, Pointer<Float> params);
typedef GlGetUniformfv = void Function(
    int program, int location, Pointer<Float> params);

typedef GlGetUniformivNative = Void Function(
    Uint32 program, Int32 location, Pointer<Int32> params);
typedef GlGetUniformiv = void Function(
    int program, int location, Pointer<Int32> params);

typedef GlGetVertexAttribdvNative = Void Function(
    Uint32 index, Uint32 pname, Pointer<Double> params);
typedef GlGetVertexAttribdv = void Function(
    int index, int pname, Pointer<Double> params);

typedef GlGetVertexAttribfvNative = Void Function(
    Uint32 index, Uint32 pname, Pointer<Float> params);
typedef GlGetVertexAttribfv = void Function(
    int index, int pname, Pointer<Float> params);

typedef GlGetVertexAttribivNative = Void Function(
    Uint32 index, Uint32 pname, Pointer<Int32> params);
typedef GlGetVertexAttribiv = void Function(
    int index, int pname, Pointer<Int32> params);

typedef GlGetVertexAttribPointervNative = Void Function(
    Uint32 index, Uint32 pname, Pointer pointer);
typedef GlGetVertexAttribPointerv = void Function(
    int index, int pname, Pointer pointer);

typedef GlIsProgramNative = Uint8 Function(Uint32 program);
typedef GlIsProgram = int Function(int program);

typedef GlIsShaderNative = Uint8 Function(Uint32 shader);
typedef GlIsShader = int Function(int shader);

typedef GlLinkProgramNative = Void Function(Uint32 program);
typedef GlLinkProgram = void Function(int program);

typedef GlShaderSourceNative = Void Function(
    Uint32 shader, Int32 count, Pointer string, Pointer<Int32> length);
typedef GlShaderSource = void Function(int shader, int count,
    /*List<String>*/ Pointer string, Pointer<Int32> length);

typedef GlUseProgramNative = Void Function(Uint32 program);
typedef GlUseProgram = void Function(int program);

typedef GlUniform1fNative = Void Function(Int32 location, Float v0);
typedef GlUniform1f = void Function(int location, double v0);

typedef GlUniform2fNative = Void Function(Int32 location, Float v0, Float v1);
typedef GlUniform2f = void Function(int location, double v0, double v1);

typedef GlUniform3fNative = Void Function(
    Int32 location, Float v0, Float v1, Float v2);
typedef GlUniform3f = void Function(
    int location, double v0, double v1, double v2);

typedef GlUniform4fNative = Void Function(
    Int32 location, Float v0, Float v1, Float v2, Float v3);
typedef GlUniform4f = void Function(
    int location, double v0, double v1, double v2, double v3);

typedef GlUniform1iNative = Void Function(Int32 location, Int32 v0);
typedef GlUniform1i = void Function(int location, int v0);

typedef GlUniform2iNative = Void Function(Int32 location, Int32 v0, Int32 v1);
typedef GlUniform2i = void Function(int location, int v0, int v1);

typedef GlUniform3iNative = Void Function(
    Int32 location, Int32 v0, Int32 v1, Int32 v2);
typedef GlUniform3i = void Function(int location, int v0, int v1, int v2);

typedef GlUniform4iNative = Void Function(
    Int32 location, Int32 v0, Int32 v1, Int32 v2, Int32 v3);
typedef GlUniform4i = void Function(
    int location, int v0, int v1, int v2, int v3);

typedef GlUniform1fvNative = Void Function(
    Int32 location, Int32 count, Pointer<Float> value);
typedef GlUniform1fv = void Function(
    int location, int count, Pointer<Float> value);

typedef GlUniform2fvNative = Void Function(
    Int32 location, Int32 count, Pointer<Float> value);
typedef GlUniform2fv = void Function(
    int location, int count, Pointer<Float> value);

typedef GlUniform3fvNative = Void Function(
    Int32 location, Int32 count, Pointer<Float> value);
typedef GlUniform3fv = void Function(
    int location, int count, Pointer<Float> value);

typedef GlUniform4fvNative = Void Function(
    Int32 location, Int32 count, Pointer<Float> value);
typedef GlUniform4fv = void Function(
    int location, int count, Pointer<Float> value);

typedef GlUniform1ivNative = Void Function(
    Int32 location, Int32 count, Pointer<Int32> value);
typedef GlUniform1iv = void Function(
    int location, int count, Pointer<Int32> value);

typedef GlUniform2ivNative = Void Function(
    Int32 location, Int32 count, Pointer<Int32> value);
typedef GlUniform2iv = void Function(
    int location, int count, Pointer<Int32> value);

typedef GlUniform3ivNative = Void Function(
    Int32 location, Int32 count, Pointer<Int32> value);
typedef GlUniform3iv = void Function(
    int location, int count, Pointer<Int32> value);

typedef GlUniform4ivNative = Void Function(
    Int32 location, Int32 count, Pointer<Int32> value);
typedef GlUniform4iv = void Function(
    int location, int count, Pointer<Int32> value);

typedef GlUniformMatrix2fvNative = Void Function(
    Int32 location, Int32 count, Uint8 transpose, Pointer<Float> value);
typedef GlUniformMatrix2fv = void Function(
    int location, int count, int transpose, Pointer<Float> value);

typedef GlUniformMatrix3fvNative = Void Function(
    Int32 location, Int32 count, Uint8 transpose, Pointer<Float> value);
typedef GlUniformMatrix3fv = void Function(
    int location, int count, int transpose, Pointer<Float> value);

typedef GlUniformMatrix4fvNative = Void Function(
    Int32 location, Int32 count, Uint8 transpose, Pointer<Float> value);
typedef GlUniformMatrix4fv = void Function(
    int location, int count, int transpose, Pointer<Float> value);

typedef GlValidateProgramNative = Void Function(Uint32 program);
typedef GlValidateProgram = void Function(int program);

typedef GlVertexAttrib1dNative = Void Function(Uint32 index, Double x);
typedef GlVertexAttrib1d = void Function(int index, double x);

typedef GlVertexAttrib1dvNative = Void Function(
    Uint32 index, Pointer<Double> v);
typedef GlVertexAttrib1dv = void Function(int index, Pointer<Double> v);

typedef GlVertexAttrib1fNative = Void Function(Uint32 index, Float x);
typedef GlVertexAttrib1f = void Function(int index, double x);

typedef GlVertexAttrib1fvNative = Void Function(Uint32 index, Pointer<Float> v);
typedef GlVertexAttrib1fv = void Function(int index, Pointer<Float> v);

typedef GlVertexAttrib1sNative = Void Function(Uint32 index, Int16 x);
typedef GlVertexAttrib1s = void Function(int index, int x);

typedef GlVertexAttrib1svNative = Void Function(Uint32 index, Pointer<Int16> v);
typedef GlVertexAttrib1sv = void Function(int index, Pointer<Int16> v);

typedef GlVertexAttrib2dNative = Void Function(
    Uint32 index, Double x, Double y);
typedef GlVertexAttrib2d = void Function(int index, double x, double y);

typedef GlVertexAttrib2dvNative = Void Function(
    Uint32 index, Pointer<Double> v);
typedef GlVertexAttrib2dv = void Function(int index, Pointer<Double> v);

typedef GlVertexAttrib2fNative = Void Function(Uint32 index, Float x, Float y);
typedef GlVertexAttrib2f = void Function(int index, double x, double y);

typedef GlVertexAttrib2fvNative = Void Function(Uint32 index, Pointer<Float> v);
typedef GlVertexAttrib2fv = void Function(int index, Pointer<Float> v);

typedef GlVertexAttrib2sNative = Void Function(Uint32 index, Int16 x, Int16 y);
typedef GlVertexAttrib2s = void Function(int index, int x, int y);

typedef GlVertexAttrib2svNative = Void Function(Uint32 index, Pointer<Int16> v);
typedef GlVertexAttrib2sv = void Function(int index, Pointer<Int16> v);

typedef GlVertexAttrib3dNative = Void Function(
    Uint32 index, Double x, Double y, Double z);
typedef GlVertexAttrib3d = void Function(
    int index, double x, double y, double z);

typedef GlVertexAttrib3dvNative = Void Function(
    Uint32 index, Pointer<Double> v);
typedef GlVertexAttrib3dv = void Function(int index, Pointer<Double> v);

typedef GlVertexAttrib3fNative = Void Function(
    Uint32 index, Float x, Float y, Float z);
typedef GlVertexAttrib3f = void Function(
    int index, double x, double y, double z);

typedef GlVertexAttrib3fvNative = Void Function(Uint32 index, Pointer<Float> v);
typedef GlVertexAttrib3fv = void Function(int index, Pointer<Float> v);

typedef GlVertexAttrib3sNative = Void Function(
    Uint32 index, Int16 x, Int16 y, Int16 z);
typedef GlVertexAttrib3s = void Function(int index, int x, int y, int z);

typedef GlVertexAttrib3svNative = Void Function(Uint32 index, Pointer<Int16> v);
typedef GlVertexAttrib3sv = void Function(int index, Pointer<Int16> v);

typedef GlVertexAttrib4NbvNative = Void Function(Uint32 index, Pointer<Int8> v);
typedef GlVertexAttrib4Nbv = void Function(int index, Pointer<Int8> v);

typedef GlVertexAttrib4NivNative = Void Function(
    Uint32 index, Pointer<Int32> v);
typedef GlVertexAttrib4Niv = void Function(int index, Pointer<Int32> v);

typedef GlVertexAttrib4NsvNative = Void Function(
    Uint32 index, Pointer<Int16> v);
typedef GlVertexAttrib4Nsv = void Function(int index, Pointer<Int16> v);

typedef GlVertexAttrib4NubNative = Void Function(
    Uint32 index, Uint8 x, Uint8 y, Uint8 z, Uint8 w);
typedef GlVertexAttrib4Nub = void Function(
    int index, int x, int y, int z, int w);

typedef GlVertexAttrib4NubvNative = Void Function(Uint32 index, Pointer v);
typedef GlVertexAttrib4Nubv = void Function(int index, /*String*/ Pointer v);

typedef GlVertexAttrib4NuivNative = Void Function(
    Uint32 index, Pointer<Uint32> v);
typedef GlVertexAttrib4Nuiv = void Function(int index, Pointer<Uint32> v);

typedef GlVertexAttrib4NusvNative = Void Function(
    Uint32 index, Pointer<Uint16> v);
typedef GlVertexAttrib4Nusv = void Function(int index, Pointer<Uint16> v);

typedef GlVertexAttrib4bvNative = Void Function(Uint32 index, Pointer<Int8> v);
typedef GlVertexAttrib4bv = void Function(int index, Pointer<Int8> v);

typedef GlVertexAttrib4dNative = Void Function(
    Uint32 index, Double x, Double y, Double z, Double w);
typedef GlVertexAttrib4d = void Function(
    int index, double x, double y, double z, double w);

typedef GlVertexAttrib4dvNative = Void Function(
    Uint32 index, Pointer<Double> v);
typedef GlVertexAttrib4dv = void Function(int index, Pointer<Double> v);

typedef GlVertexAttrib4fNative = Void Function(
    Uint32 index, Float x, Float y, Float z, Float w);
typedef GlVertexAttrib4f = void Function(
    int index, double x, double y, double z, double w);

typedef GlVertexAttrib4fvNative = Void Function(Uint32 index, Pointer<Float> v);
typedef GlVertexAttrib4fv = void Function(int index, Pointer<Float> v);

typedef GlVertexAttrib4ivNative = Void Function(Uint32 index, Pointer<Int32> v);
typedef GlVertexAttrib4iv = void Function(int index, Pointer<Int32> v);

typedef GlVertexAttrib4sNative = Void Function(
    Uint32 index, Int16 x, Int16 y, Int16 z, Int16 w);
typedef GlVertexAttrib4s = void Function(int index, int x, int y, int z, int w);

typedef GlVertexAttrib4svNative = Void Function(Uint32 index, Pointer<Int16> v);
typedef GlVertexAttrib4sv = void Function(int index, Pointer<Int16> v);

typedef GlVertexAttrib4ubvNative = Void Function(Uint32 index, Pointer v);
typedef GlVertexAttrib4ubv = void Function(int index, /*String*/ Pointer v);

typedef GlVertexAttrib4uivNative = Void Function(
    Uint32 index, Pointer<Uint32> v);
typedef GlVertexAttrib4uiv = void Function(int index, Pointer<Uint32> v);

typedef GlVertexAttrib4usvNative = Void Function(
    Uint32 index, Pointer<Uint16> v);
typedef GlVertexAttrib4usv = void Function(int index, Pointer<Uint16> v);

typedef GlVertexAttribPointerNative = Void Function(Uint32 index, Int32 size,
    Uint32 type, Uint8 normalized, Int32 stride, Uint32 pointer);
typedef GlVertexAttribPointer = void Function(
    int index, int size, int type, int normalized, int stride, int pointer);

//GL_VERSION_2_1
typedef GlUniformMatrix2x3fvNative = Void Function(
    Int32 location, Int32 count, Uint8 transpose, Pointer<Float> value);
typedef GlUniformMatrix2x3fv = void Function(
    int location, int count, int transpose, Pointer<Float> value);

typedef GlUniformMatrix3x2fvNative = Void Function(
    Int32 location, Int32 count, Uint8 transpose, Pointer<Float> value);
typedef GlUniformMatrix3x2fv = void Function(
    int location, int count, int transpose, Pointer<Float> value);

typedef GlUniformMatrix2x4fvNative = Void Function(
    Int32 location, Int32 count, Uint8 transpose, Pointer<Float> value);
typedef GlUniformMatrix2x4fv = void Function(
    int location, int count, int transpose, Pointer<Float> value);

typedef GlUniformMatrix4x2fvNative = Void Function(
    Int32 location, Int32 count, Uint8 transpose, Pointer<Float> value);
typedef GlUniformMatrix4x2fv = void Function(
    int location, int count, int transpose, Pointer<Float> value);

typedef GlUniformMatrix3x4fvNative = Void Function(
    Int32 location, Int32 count, Uint8 transpose, Pointer<Float> value);
typedef GlUniformMatrix3x4fv = void Function(
    int location, int count, int transpose, Pointer<Float> value);

typedef GlUniformMatrix4x3fvNative = Void Function(
    Int32 location, Int32 count, Uint8 transpose, Pointer<Float> value);
typedef GlUniformMatrix4x3fv = void Function(
    int location, int count, int transpose, Pointer<Float> value);

//GL_VERSION_3_0
typedef GlColorMaskiNative = Void Function(
    Uint32 index, Uint8 r, Uint8 g, Uint8 b, Uint8 a);
typedef GlColorMaski = void Function(int index, int r, int g, int b, int a);

typedef GlGetBooleani_vNative = Void Function(
    Uint32 target, Uint32 index, Pointer data);
typedef GlGetBooleani_v = void Function(int target, int index, Pointer data);

typedef GlGetIntegeri_vNative = Void Function(
    Uint32 target, Uint32 index, Pointer<Int32> data);
typedef GlGetIntegeri_v = void Function(
    int target, int index, Pointer<Int32> data);

typedef GlEnableiNative = Void Function(Uint32 target, Uint32 index);
typedef GlEnablei = void Function(int target, int index);

typedef GlDisableiNative = Void Function(Uint32 target, Uint32 index);
typedef GlDisablei = void Function(int target, int index);

typedef GlIsEnablediNative = Uint8 Function(Uint32 target, Uint32 index);
typedef GlIsEnabledi = int Function(int target, int index);

typedef GlBeginTransformFeedbackNative = Void Function(Uint32 primitiveMode);
typedef GlBeginTransformFeedback = void Function(int primitiveMode);

typedef GlEndTransformFeedbackNative = Void Function();
typedef GlEndTransformFeedback = void Function();

typedef GlBindBufferRangeNative = Void Function(
    Uint32 target, Uint32 index, Uint32 buffer, Int64 offset, Int64 size);
typedef GlBindBufferRange = void Function(
    int target, int index, int buffer, int offset, int size);

typedef GlBindBufferBaseNative = Void Function(
    Uint32 target, Uint32 index, Uint32 buffer);
typedef GlBindBufferBase = void Function(int target, int index, int buffer);

typedef GlTransformFeedbackVaryingsNative = Void Function(
    Uint32 program, Int32 count, Pointer varyings, Uint32 bufferMode);
typedef GlTransformFeedbackVaryings = void Function(
    int program, int count, /*List<String>*/ Pointer varyings, int bufferMode);

typedef GlGetTransformFeedbackVaryingNative = Void Function(
    Uint32 program,
    Uint32 index,
    Int32 bufSize,
    Pointer<Int32> length,
    Pointer<Int32> size,
    Pointer<Uint32> type,
    Pointer name);
typedef GlGetTransformFeedbackVarying = void Function(
    int program,
    int index,
    int bufSize,
    Pointer<Int32> length,
    Pointer<Int32> size,
    Pointer<Uint32> type,
    Pointer name);

typedef GlClampColorNative = Void Function(Uint32 target, Uint32 clamp);
typedef GlClampColor = void Function(int target, int clamp);

typedef GlBeginConditionalRenderNative = Void Function(Uint32 id, Uint32 mode);
typedef GlBeginConditionalRender = void Function(int id, int mode);

typedef GlEndConditionalRenderNative = Void Function();
typedef GlEndConditionalRender = void Function();

typedef GlVertexAttribIPointerNative = Void Function(
    Uint32 index, Int32 size, Uint32 type, Int32 stride, Uint32 pointer);
typedef GlVertexAttribIPointer = void Function(
    int index, int size, int type, int stride, int pointer);

typedef GlGetVertexAttribIivNative = Void Function(
    Uint32 index, Uint32 pname, Pointer<Int32> params);
typedef GlGetVertexAttribIiv = void Function(
    int index, int pname, Pointer<Int32> params);

typedef GlGetVertexAttribIuivNative = Void Function(
    Uint32 index, Uint32 pname, Pointer<Uint32> params);
typedef GlGetVertexAttribIuiv = void Function(
    int index, int pname, Pointer<Uint32> params);

typedef GlVertexAttribI1iNative = Void Function(Uint32 index, Int32 x);
typedef GlVertexAttribI1i = void Function(int index, int x);

typedef GlVertexAttribI2iNative = Void Function(Uint32 index, Int32 x, Int32 y);
typedef GlVertexAttribI2i = void Function(int index, int x, int y);

typedef GlVertexAttribI3iNative = Void Function(
    Uint32 index, Int32 x, Int32 y, Int32 z);
typedef GlVertexAttribI3i = void Function(int index, int x, int y, int z);

typedef GlVertexAttribI4iNative = Void Function(
    Uint32 index, Int32 x, Int32 y, Int32 z, Int32 w);
typedef GlVertexAttribI4i = void Function(
    int index, int x, int y, int z, int w);

typedef GlVertexAttribI1uiNative = Void Function(Uint32 index, Uint32 x);
typedef GlVertexAttribI1ui = void Function(int index, int x);

typedef GlVertexAttribI2uiNative = Void Function(
    Uint32 index, Uint32 x, Uint32 y);
typedef GlVertexAttribI2ui = void Function(int index, int x, int y);

typedef GlVertexAttribI3uiNative = Void Function(
    Uint32 index, Uint32 x, Uint32 y, Uint32 z);
typedef GlVertexAttribI3ui = void Function(int index, int x, int y, int z);

typedef GlVertexAttribI4uiNative = Void Function(
    Uint32 index, Uint32 x, Uint32 y, Uint32 z, Uint32 w);
typedef GlVertexAttribI4ui = void Function(
    int index, int x, int y, int z, int w);

typedef GlVertexAttribI1ivNative = Void Function(
    Uint32 index, Pointer<Int32> v);
typedef GlVertexAttribI1iv = void Function(int index, Pointer<Int32> v);

typedef GlVertexAttribI2ivNative = Void Function(
    Uint32 index, Pointer<Int32> v);
typedef GlVertexAttribI2iv = void Function(int index, Pointer<Int32> v);

typedef GlVertexAttribI3ivNative = Void Function(
    Uint32 index, Pointer<Int32> v);
typedef GlVertexAttribI3iv = void Function(int index, Pointer<Int32> v);

typedef GlVertexAttribI4ivNative = Void Function(
    Uint32 index, Pointer<Int32> v);
typedef GlVertexAttribI4iv = void Function(int index, Pointer<Int32> v);

typedef GlVertexAttribI1uivNative = Void Function(
    Uint32 index, Pointer<Uint32> v);
typedef GlVertexAttribI1uiv = void Function(int index, Pointer<Uint32> v);

typedef GlVertexAttribI2uivNative = Void Function(
    Uint32 index, Pointer<Uint32> v);
typedef GlVertexAttribI2uiv = void Function(int index, Pointer<Uint32> v);

typedef GlVertexAttribI3uivNative = Void Function(
    Uint32 index, Pointer<Uint32> v);
typedef GlVertexAttribI3uiv = void Function(int index, Pointer<Uint32> v);

typedef GlVertexAttribI4uivNative = Void Function(
    Uint32 index, Pointer<Uint32> v);
typedef GlVertexAttribI4uiv = void Function(int index, Pointer<Uint32> v);

typedef GlVertexAttribI4bvNative = Void Function(Uint32 index, Pointer<Int8> v);
typedef GlVertexAttribI4bv = void Function(int index, Pointer<Int8> v);

typedef GlVertexAttribI4svNative = Void Function(
    Uint32 index, Pointer<Int16> v);
typedef GlVertexAttribI4sv = void Function(int index, Pointer<Int16> v);

typedef GlVertexAttribI4ubvNative = Void Function(Uint32 index, Pointer v);
typedef GlVertexAttribI4ubv = void Function(int index, /*String*/ Pointer v);

typedef GlVertexAttribI4usvNative = Void Function(
    Uint32 index, Pointer<Uint16> v);
typedef GlVertexAttribI4usv = void Function(int index, Pointer<Uint16> v);

typedef GlGetUniformuivNative = Void Function(
    Uint32 program, Int32 location, Pointer<Uint32> params);
typedef GlGetUniformuiv = void Function(
    int program, int location, Pointer<Uint32> params);

typedef GlBindFragDataLocationNative = Void Function(
    Uint32 program, Uint32 color, Pointer name);
typedef GlBindFragDataLocation = void Function(
    int program, int color, /*String*/ Pointer name);

typedef GlGetFragDataLocationNative = Int32 Function(
    Uint32 program, Pointer name);
typedef GlGetFragDataLocation = int Function(
    int program, /*String*/ Pointer name);

typedef GlUniform1uiNative = Void Function(Int32 location, Uint32 v0);
typedef GlUniform1ui = void Function(int location, int v0);

typedef GlUniform2uiNative = Void Function(
    Int32 location, Uint32 v0, Uint32 v1);
typedef GlUniform2ui = void Function(int location, int v0, int v1);

typedef GlUniform3uiNative = Void Function(
    Int32 location, Uint32 v0, Uint32 v1, Uint32 v2);
typedef GlUniform3ui = void Function(int location, int v0, int v1, int v2);

typedef GlUniform4uiNative = Void Function(
    Int32 location, Uint32 v0, Uint32 v1, Uint32 v2, Uint32 v3);
typedef GlUniform4ui = void Function(
    int location, int v0, int v1, int v2, int v3);

typedef GlUniform1uivNative = Void Function(
    Int32 location, Int32 count, Pointer<Uint32> value);
typedef GlUniform1uiv = void Function(
    int location, int count, Pointer<Uint32> value);

typedef GlUniform2uivNative = Void Function(
    Int32 location, Int32 count, Pointer<Uint32> value);
typedef GlUniform2uiv = void Function(
    int location, int count, Pointer<Uint32> value);

typedef GlUniform3uivNative = Void Function(
    Int32 location, Int32 count, Pointer<Uint32> value);
typedef GlUniform3uiv = void Function(
    int location, int count, Pointer<Uint32> value);

typedef GlUniform4uivNative = Void Function(
    Int32 location, Int32 count, Pointer<Uint32> value);
typedef GlUniform4uiv = void Function(
    int location, int count, Pointer<Uint32> value);

typedef GlTexParameterIivNative = Void Function(
    Uint32 target, Uint32 pname, Pointer<Int32> params);
typedef GlTexParameterIiv = void Function(
    int target, int pname, Pointer<Int32> params);

typedef GlTexParameterIuivNative = Void Function(
    Uint32 target, Uint32 pname, Pointer<Uint32> params);
typedef GlTexParameterIuiv = void Function(
    int target, int pname, Pointer<Uint32> params);

typedef GlGetTexParameterIivNative = Void Function(
    Uint32 target, Uint32 pname, Pointer<Int32> params);
typedef GlGetTexParameterIiv = void Function(
    int target, int pname, Pointer<Int32> params);

typedef GlGetTexParameterIuivNative = Void Function(
    Uint32 target, Uint32 pname, Pointer<Uint32> params);
typedef GlGetTexParameterIuiv = void Function(
    int target, int pname, Pointer<Uint32> params);

typedef GlClearBufferivNative = Void Function(
    Uint32 buffer, Int32 drawbuffer, Pointer<Int32> value);
typedef GlClearBufferiv = void Function(
    int buffer, int drawbuffer, Pointer<Int32> value);

typedef GlClearBufferuivNative = Void Function(
    Uint32 buffer, Int32 drawbuffer, Pointer<Uint32> value);
typedef GlClearBufferuiv = void Function(
    int buffer, int drawbuffer, Pointer<Uint32> value);

typedef GlClearBufferfvNative = Void Function(
    Uint32 buffer, Int32 drawbuffer, Pointer<Float> value);
typedef GlClearBufferfv = void Function(
    int buffer, int drawbuffer, Pointer<Float> value);

typedef GlClearBufferfiNative = Void Function(
    Uint32 buffer, Int32 drawbuffer, Float depth, Int32 stencil);
typedef GlClearBufferfi = void Function(
    int buffer, int drawbuffer, double depth, int stencil);

typedef GlGetStringiNative = Pointer Function(Uint32 name, Uint32 index);
typedef GlGetStringi = /*String*/ Pointer Function(int name, int index);

typedef GlIsRenderbufferNative = Uint8 Function(Uint32 renderbuffer);
typedef GlIsRenderbuffer = int Function(int renderbuffer);

typedef GlBindRenderbufferNative = Void Function(
    Uint32 target, Uint32 renderbuffer);
typedef GlBindRenderbuffer = void Function(int target, int renderbuffer);

typedef GlDeleteRenderbuffersNative = Void Function(
    Int32 n, Pointer<Uint32> renderbuffers);
typedef GlDeleteRenderbuffers = void Function(
    int n, Pointer<Uint32> renderbuffers);

typedef GlGenRenderbuffersNative = Void Function(
    Int32 n, Pointer<Uint32> renderbuffers);
typedef GlGenRenderbuffers = void Function(
    int n, Pointer<Uint32> renderbuffers);

typedef GlRenderbufferStorageNative = Void Function(
    Uint32 target, Uint32 internalformat, Int32 width, Int32 height);
typedef GlRenderbufferStorage = void Function(
    int target, int internalformat, int width, int height);

typedef GlGetRenderbufferParameterivNative = Void Function(
    Uint32 target, Uint32 pname, Pointer<Int32> params);
typedef GlGetRenderbufferParameteriv = void Function(
    int target, int pname, Pointer<Int32> params);

typedef GlIsFramebufferNative = Uint8 Function(Uint32 framebuffer);
typedef GlIsFramebuffer = int Function(int framebuffer);

typedef GlBindFramebufferNative = Void Function(
    Uint32 target, Uint32 framebuffer);
typedef GlBindFramebuffer = void Function(int target, int framebuffer);

typedef GlDeleteFramebuffersNative = Void Function(
    Int32 n, Pointer<Uint32> framebuffers);
typedef GlDeleteFramebuffers = void Function(
    int n, Pointer<Uint32> framebuffers);

typedef GlGenFramebuffersNative = Void Function(
    Int32 n, Pointer<Uint32> framebuffers);
typedef GlGenFramebuffers = void Function(int n, Pointer<Uint32> framebuffers);

typedef GlCheckFramebufferStatusNative = Uint32 Function(Uint32 target);
typedef GlCheckFramebufferStatus = int Function(int target);

typedef GlFramebufferTexture1DNative = Void Function(Uint32 target,
    Uint32 attachment, Uint32 textarget, Uint32 texture, Int32 level);
typedef GlFramebufferTexture1D = void Function(
    int target, int attachment, int textarget, int texture, int level);

typedef GlFramebufferTexture2DNative = Void Function(Uint32 target,
    Uint32 attachment, Uint32 textarget, Uint32 texture, Int32 level);
typedef GlFramebufferTexture2D = void Function(
    int target, int attachment, int textarget, int texture, int level);

typedef GlFramebufferTexture3DNative = Void Function(
    Uint32 target,
    Uint32 attachment,
    Uint32 textarget,
    Uint32 texture,
    Int32 level,
    Int32 zoffset);
typedef GlFramebufferTexture3D = void Function(int target, int attachment,
    int textarget, int texture, int level, int zoffset);

typedef GlFramebufferRenderbufferNative = Void Function(Uint32 target,
    Uint32 attachment, Uint32 renderbuffertarget, Uint32 renderbuffer);
typedef GlFramebufferRenderbuffer = void Function(
    int target, int attachment, int renderbuffertarget, int renderbuffer);

typedef GlGetFramebufferAttachmentParameterivNative = Void Function(
    Uint32 target, Uint32 attachment, Uint32 pname, Pointer<Int32> params);
typedef GlGetFramebufferAttachmentParameteriv = void Function(
    int target, int attachment, int pname, Pointer<Int32> params);

typedef GlGenerateMipmapNative = Void Function(Uint32 target);
typedef GlGenerateMipmap = void Function(int target);

typedef GlBlitFramebufferNative = Void Function(
    Int32 srcX0,
    Int32 srcY0,
    Int32 srcX1,
    Int32 srcY1,
    Int32 dstX0,
    Int32 dstY0,
    Int32 dstX1,
    Int32 dstY1,
    Uint32 mask,
    Uint32 filter);
typedef GlBlitFramebuffer = void Function(
    int srcX0,
    int srcY0,
    int srcX1,
    int srcY1,
    int dstX0,
    int dstY0,
    int dstX1,
    int dstY1,
    int mask,
    int filter);

typedef GlRenderbufferStorageMultisampleNative = Void Function(Uint32 target,
    Int32 samples, Uint32 internalformat, Int32 width, Int32 height);
typedef GlRenderbufferStorageMultisample = void Function(
    int target, int samples, int internalformat, int width, int height);

typedef GlFramebufferTextureLayerNative = Void Function(
    Uint32 target, Uint32 attachment, Uint32 texture, Int32 level, Int32 layer);
typedef GlFramebufferTextureLayer = void Function(
    int target, int attachment, int texture, int level, int layer);

typedef GlMapBufferRangeNative = Pointer Function(
    Uint32 target, Int64 offset, Int64 length, Uint32 access);
typedef GlMapBufferRange = Pointer Function(
    int target, int offset, int length, int access);

typedef GlFlushMappedBufferRangeNative = Void Function(
    Uint32 target, Int64 offset, Int64 length);
typedef GlFlushMappedBufferRange = void Function(
    int target, int offset, int length);

typedef GlBindVertexArrayNative = Void Function(Uint32 array);
typedef GlBindVertexArray = void Function(int array);

typedef GlDeleteVertexArraysNative = Void Function(
    Int32 n, Pointer<Uint32> arrays);
typedef GlDeleteVertexArrays = void Function(int n, Pointer<Uint32> arrays);

typedef GlGenVertexArraysNative = Void Function(
    Int32 n, Pointer<Uint32> arrays);
typedef GlGenVertexArrays = void Function(int n, Pointer<Uint32> arrays);

typedef GlIsVertexArrayNative = Uint8 Function(Uint32 array);
typedef GlIsVertexArray = int Function(int array);

//GL_VERSION_3_1
typedef GlDrawArraysInstancedNative = Void Function(
    Uint32 mode, Int32 first, Int32 count, Int32 instancecount);
typedef GlDrawArraysInstanced = void Function(
    int mode, int first, int count, int instancecount);

typedef GlDrawElementsInstancedNative = Void Function(Uint32 mode, Int32 count,
    Uint32 type, Pointer indices, Int32 instancecount);
typedef GlDrawElementsInstanced = void Function(
    int mode, int count, int type, Pointer indices, int instancecount);

typedef GlTexBufferNative = Void Function(
    Uint32 target, Uint32 internalformat, Uint32 buffer);
typedef GlTexBuffer = void Function(int target, int internalformat, int buffer);

typedef GlPrimitiveRestartIndexNative = Void Function(Uint32 index);
typedef GlPrimitiveRestartIndex = void Function(int index);

typedef GlCopyBufferSubDataNative = Void Function(Uint32 readTarget,
    Uint32 writeTarget, Int64 readOffset, Int64 writeOffset, Int64 size);
typedef GlCopyBufferSubData = void Function(
    int readTarget, int writeTarget, int readOffset, int writeOffset, int size);

typedef GlGetUniformIndicesNative = Void Function(Uint32 program,
    Int32 uniformCount, Pointer uniformNames, Pointer<Uint32> uniformIndices);
typedef GlGetUniformIndices = void Function(int program, int uniformCount,
    /*List<String>*/ Pointer uniformNames, Pointer<Uint32> uniformIndices);

typedef GlGetActiveUniformsivNative = Void Function(
    Uint32 program,
    Int32 uniformCount,
    Pointer<Uint32> uniformIndices,
    Uint32 pname,
    Pointer<Int32> params);
typedef GlGetActiveUniformsiv = void Function(int program, int uniformCount,
    Pointer<Uint32> uniformIndices, int pname, Pointer<Int32> params);

typedef GlGetActiveUniformNameNative = Void Function(
    Uint32 program,
    Uint32 uniformIndex,
    Int32 bufSize,
    Pointer<Int32> length,
    Pointer uniformName);
typedef GlGetActiveUniformName = void Function(int program, int uniformIndex,
    int bufSize, Pointer<Int32> length, Pointer uniformName);

typedef GlGetUniformBlockIndexNative = Uint32 Function(
    Uint32 program, Pointer uniformBlockName);
typedef GlGetUniformBlockIndex = int Function(
    int program, /*String*/ Pointer uniformBlockName);

typedef GlGetActiveUniformBlockivNative = Void Function(Uint32 program,
    Uint32 uniformBlockIndex, Uint32 pname, Pointer<Int32> params);
typedef GlGetActiveUniformBlockiv = void Function(
    int program, int uniformBlockIndex, int pname, Pointer<Int32> params);

typedef GlGetActiveUniformBlockNameNative = Void Function(
    Uint32 program,
    Uint32 uniformBlockIndex,
    Int32 bufSize,
    Pointer<Int32> length,
    Pointer uniformBlockName);
typedef GlGetActiveUniformBlockName = void Function(
    int program,
    int uniformBlockIndex,
    int bufSize,
    Pointer<Int32> length,
    Pointer uniformBlockName);

typedef GlUniformBlockBindingNative = Void Function(
    Uint32 program, Uint32 uniformBlockIndex, Uint32 uniformBlockBinding);
typedef GlUniformBlockBinding = void Function(
    int program, int uniformBlockIndex, int uniformBlockBinding);

//GL_VERSION_3_2
typedef GlDrawElementsBaseVertexNative = Void Function(
    Uint32 mode, Int32 count, Uint32 type, Pointer indices, Int32 basevertex);
typedef GlDrawElementsBaseVertex = void Function(
    int mode, int count, int type, Pointer indices, int basevertex);

typedef GlDrawRangeElementsBaseVertexNative = Void Function(
    Uint32 mode,
    Uint32 start,
    Uint32 end,
    Int32 count,
    Uint32 type,
    Pointer indices,
    Int32 basevertex);
typedef GlDrawRangeElementsBaseVertex = void Function(int mode, int start,
    int end, int count, int type, Pointer indices, int basevertex);

typedef GlDrawElementsInstancedBaseVertexNative = Void Function(
    Uint32 mode,
    Int32 count,
    Uint32 type,
    Pointer indices,
    Int32 instancecount,
    Int32 basevertex);
typedef GlDrawElementsInstancedBaseVertex = void Function(int mode, int count,
    int type, Pointer indices, int instancecount, int basevertex);

typedef GlMultiDrawElementsBaseVertexNative = Void Function(
    Uint32 mode,
    Pointer<Int32> count,
    Uint32 type,
    Pointer indices,
    Int32 drawcount,
    Pointer<Int32> basevertex);
typedef GlMultiDrawElementsBaseVertex = void Function(
    int mode,
    Pointer<Int32> count,
    int type,
    Pointer indices,
    int drawcount,
    Pointer<Int32> basevertex);

typedef GlProvokingVertexNative = Void Function(Uint32 mode);
typedef GlProvokingVertex = void Function(int mode);

typedef GlFenceSyncNative = Pointer Function(Uint32 condition, Uint32 flags);
typedef GlFenceSync = Pointer Function(int condition, int flags);

typedef GlIsSyncNative = Uint8 Function(Pointer sync);
typedef GlIsSync = int Function(Pointer sync);

typedef GlDeleteSyncNative = Void Function(Pointer sync);
typedef GlDeleteSync = void Function(Pointer sync);

typedef GlClientWaitSyncNative = Uint32 Function(
    Pointer sync, Uint32 flags, Uint64 timeout);
typedef GlClientWaitSync = int Function(Pointer sync, int flags, int timeout);

typedef GlWaitSyncNative = Void Function(
    Pointer sync, Uint32 flags, Uint64 timeout);
typedef GlWaitSync = void Function(Pointer sync, int flags, int timeout);

typedef GlGetInteger64vNative = Void Function(
    Uint32 pname, Pointer<Int64> data);
typedef GlGetInteger64v = void Function(int pname, Pointer<Int64> data);

typedef GlGetSyncivNative = Void Function(Pointer sync, Uint32 pname,
    Int32 count, Pointer<Int32> length, Pointer<Int32> values);
typedef GlGetSynciv = void Function(Pointer sync, int pname, int count,
    Pointer<Int32> length, Pointer<Int32> values);

typedef GlGetInteger64i_vNative = Void Function(
    Uint32 target, Uint32 index, Pointer<Int64> data);
typedef GlGetInteger64i_v = void Function(
    int target, int index, Pointer<Int64> data);

typedef GlGetBufferParameteri64vNative = Void Function(
    Uint32 target, Uint32 pname, Pointer<Int64> params);
typedef GlGetBufferParameteri64v = void Function(
    int target, int pname, Pointer<Int64> params);

typedef GlFramebufferTextureNative = Void Function(
    Uint32 target, Uint32 attachment, Uint32 texture, Int32 level);
typedef GlFramebufferTexture = void Function(
    int target, int attachment, int texture, int level);

typedef GlTexImage2DMultisampleNative = Void Function(
    Uint32 target,
    Int32 samples,
    Uint32 internalformat,
    Int32 width,
    Int32 height,
    Uint8 fixedsamplelocations);
typedef GlTexImage2DMultisample = void Function(int target, int samples,
    int internalformat, int width, int height, int fixedsamplelocations);

typedef GlTexImage3DMultisampleNative = Void Function(
    Uint32 target,
    Int32 samples,
    Uint32 internalformat,
    Int32 width,
    Int32 height,
    Int32 depth,
    Uint8 fixedsamplelocations);
typedef GlTexImage3DMultisample = void Function(
    int target,
    int samples,
    int internalformat,
    int width,
    int height,
    int depth,
    int fixedsamplelocations);

typedef GlGetMultisamplefvNative = Void Function(
    Uint32 pname, Uint32 index, Pointer<Float> val);
typedef GlGetMultisamplefv = void Function(
    int pname, int index, Pointer<Float> val);

typedef GlSampleMaskiNative = Void Function(Uint32 maskNumber, Uint32 mask);
typedef GlSampleMaski = void Function(int maskNumber, int mask);

//GL_VERSION_3_3
typedef GlBindFragDataLocationIndexedNative = Void Function(
    Uint32 program, Uint32 colorNumber, Uint32 index, Pointer name);
typedef GlBindFragDataLocationIndexed = void Function(
    int program, int colorNumber, int index, /*String*/ Pointer name);

typedef GlGetFragDataIndexNative = Int32 Function(Uint32 program, Pointer name);
typedef GlGetFragDataIndex = int Function(int program, /*String*/ Pointer name);

typedef GlGenSamplersNative = Void Function(
    Int32 count, Pointer<Uint32> samplers);
typedef GlGenSamplers = void Function(int count, Pointer<Uint32> samplers);

typedef GlDeleteSamplersNative = Void Function(
    Int32 count, Pointer<Uint32> samplers);
typedef GlDeleteSamplers = void Function(int count, Pointer<Uint32> samplers);

typedef GlIsSamplerNative = Uint8 Function(Uint32 sampler);
typedef GlIsSampler = int Function(int sampler);

typedef GlBindSamplerNative = Void Function(Uint32 unit, Uint32 sampler);
typedef GlBindSampler = void Function(int unit, int sampler);

typedef GlSamplerParameteriNative = Void Function(
    Uint32 sampler, Uint32 pname, Int32 param);
typedef GlSamplerParameteri = void Function(int sampler, int pname, int param);

typedef GlSamplerParameterivNative = Void Function(
    Uint32 sampler, Uint32 pname, Pointer<Int32> param);
typedef GlSamplerParameteriv = void Function(
    int sampler, int pname, Pointer<Int32> param);

typedef GlSamplerParameterfNative = Void Function(
    Uint32 sampler, Uint32 pname, Float param);
typedef GlSamplerParameterf = void Function(
    int sampler, int pname, double param);

typedef GlSamplerParameterfvNative = Void Function(
    Uint32 sampler, Uint32 pname, Pointer<Float> param);
typedef GlSamplerParameterfv = void Function(
    int sampler, int pname, Pointer<Float> param);

typedef GlSamplerParameterIivNative = Void Function(
    Uint32 sampler, Uint32 pname, Pointer<Int32> param);
typedef GlSamplerParameterIiv = void Function(
    int sampler, int pname, Pointer<Int32> param);

typedef GlSamplerParameterIuivNative = Void Function(
    Uint32 sampler, Uint32 pname, Pointer<Uint32> param);
typedef GlSamplerParameterIuiv = void Function(
    int sampler, int pname, Pointer<Uint32> param);

typedef GlGetSamplerParameterivNative = Void Function(
    Uint32 sampler, Uint32 pname, Pointer<Int32> params);
typedef GlGetSamplerParameteriv = void Function(
    int sampler, int pname, Pointer<Int32> params);

typedef GlGetSamplerParameterIivNative = Void Function(
    Uint32 sampler, Uint32 pname, Pointer<Int32> params);
typedef GlGetSamplerParameterIiv = void Function(
    int sampler, int pname, Pointer<Int32> params);

typedef GlGetSamplerParameterfvNative = Void Function(
    Uint32 sampler, Uint32 pname, Pointer<Float> params);
typedef GlGetSamplerParameterfv = void Function(
    int sampler, int pname, Pointer<Float> params);

typedef GlGetSamplerParameterIuivNative = Void Function(
    Uint32 sampler, Uint32 pname, Pointer<Uint32> params);
typedef GlGetSamplerParameterIuiv = void Function(
    int sampler, int pname, Pointer<Uint32> params);

typedef GlQueryCounterNative = Void Function(Uint32 id, Uint32 target);
typedef GlQueryCounter = void Function(int id, int target);

typedef GlGetQueryObjecti64vNative = Void Function(
    Uint32 id, Uint32 pname, Pointer<Int64> params);
typedef GlGetQueryObjecti64v = void Function(
    int id, int pname, Pointer<Int64> params);

typedef GlGetQueryObjectui64vNative = Void Function(
    Uint32 id, Uint32 pname, Pointer<Uint64> params);
typedef GlGetQueryObjectui64v = void Function(
    int id, int pname, Pointer<Uint64> params);

typedef GlVertexAttribDivisorNative = Void Function(
    Uint32 index, Uint32 divisor);
typedef GlVertexAttribDivisor = void Function(int index, int divisor);

typedef GlVertexAttribP1uiNative = Void Function(
    Uint32 index, Uint32 type, Uint8 normalized, Uint32 value);
typedef GlVertexAttribP1ui = void Function(
    int index, int type, int normalized, int value);

typedef GlVertexAttribP1uivNative = Void Function(
    Uint32 index, Uint32 type, Uint8 normalized, Pointer<Uint32> value);
typedef GlVertexAttribP1uiv = void Function(
    int index, int type, int normalized, Pointer<Uint32> value);

typedef GlVertexAttribP2uiNative = Void Function(
    Uint32 index, Uint32 type, Uint8 normalized, Uint32 value);
typedef GlVertexAttribP2ui = void Function(
    int index, int type, int normalized, int value);

typedef GlVertexAttribP2uivNative = Void Function(
    Uint32 index, Uint32 type, Uint8 normalized, Pointer<Uint32> value);
typedef GlVertexAttribP2uiv = void Function(
    int index, int type, int normalized, Pointer<Uint32> value);

typedef GlVertexAttribP3uiNative = Void Function(
    Uint32 index, Uint32 type, Uint8 normalized, Uint32 value);
typedef GlVertexAttribP3ui = void Function(
    int index, int type, int normalized, int value);

typedef GlVertexAttribP3uivNative = Void Function(
    Uint32 index, Uint32 type, Uint8 normalized, Pointer<Uint32> value);
typedef GlVertexAttribP3uiv = void Function(
    int index, int type, int normalized, Pointer<Uint32> value);

typedef GlVertexAttribP4uiNative = Void Function(
    Uint32 index, Uint32 type, Uint8 normalized, Uint32 value);
typedef GlVertexAttribP4ui = void Function(
    int index, int type, int normalized, int value);

typedef GlVertexAttribP4uivNative = Void Function(
    Uint32 index, Uint32 type, Uint8 normalized, Pointer<Uint32> value);
typedef GlVertexAttribP4uiv = void Function(
    int index, int type, int normalized, Pointer<Uint32> value);

//GL_VERSION_4_0
typedef GlMinSampleShadingNative = Void Function(Float value);
typedef GlMinSampleShading = void Function(double value);

typedef GlBlendEquationiNative = Void Function(Uint32 buf, Uint32 mode);
typedef GlBlendEquationi = void Function(int buf, int mode);

typedef GlBlendEquationSeparateiNative = Void Function(
    Uint32 buf, Uint32 modeRGB, Uint32 modeAlpha);
typedef GlBlendEquationSeparatei = void Function(
    int buf, int modeRGB, int modeAlpha);

typedef GlBlendFunciNative = Void Function(Uint32 buf, Uint32 src, Uint32 dst);
typedef GlBlendFunci = void Function(int buf, int src, int dst);

typedef GlBlendFuncSeparateiNative = Void Function(
    Uint32 buf, Uint32 srcRGB, Uint32 dstRGB, Uint32 srcAlpha, Uint32 dstAlpha);
typedef GlBlendFuncSeparatei = void Function(
    int buf, int srcRGB, int dstRGB, int srcAlpha, int dstAlpha);

typedef GlDrawArraysIndirectNative = Void Function(
    Uint32 mode, Pointer indirect);
typedef GlDrawArraysIndirect = void Function(int mode, Pointer indirect);

typedef GlDrawElementsIndirectNative = Void Function(
    Uint32 mode, Uint32 type, Pointer indirect);
typedef GlDrawElementsIndirect = void Function(
    int mode, int type, Pointer indirect);

typedef GlUniform1dNative = Void Function(Int32 location, Double x);
typedef GlUniform1d = void Function(int location, double x);

typedef GlUniform2dNative = Void Function(Int32 location, Double x, Double y);
typedef GlUniform2d = void Function(int location, double x, double y);

typedef GlUniform3dNative = Void Function(
    Int32 location, Double x, Double y, Double z);
typedef GlUniform3d = void Function(int location, double x, double y, double z);

typedef GlUniform4dNative = Void Function(
    Int32 location, Double x, Double y, Double z, Double w);
typedef GlUniform4d = void Function(
    int location, double x, double y, double z, double w);

typedef GlUniform1dvNative = Void Function(
    Int32 location, Int32 count, Pointer<Double> value);
typedef GlUniform1dv = void Function(
    int location, int count, Pointer<Double> value);

typedef GlUniform2dvNative = Void Function(
    Int32 location, Int32 count, Pointer<Double> value);
typedef GlUniform2dv = void Function(
    int location, int count, Pointer<Double> value);

typedef GlUniform3dvNative = Void Function(
    Int32 location, Int32 count, Pointer<Double> value);
typedef GlUniform3dv = void Function(
    int location, int count, Pointer<Double> value);

typedef GlUniform4dvNative = Void Function(
    Int32 location, Int32 count, Pointer<Double> value);
typedef GlUniform4dv = void Function(
    int location, int count, Pointer<Double> value);

typedef GlUniformMatrix2dvNative = Void Function(
    Int32 location, Int32 count, Uint8 transpose, Pointer<Double> value);
typedef GlUniformMatrix2dv = void Function(
    int location, int count, int transpose, Pointer<Double> value);

typedef GlUniformMatrix3dvNative = Void Function(
    Int32 location, Int32 count, Uint8 transpose, Pointer<Double> value);
typedef GlUniformMatrix3dv = void Function(
    int location, int count, int transpose, Pointer<Double> value);

typedef GlUniformMatrix4dvNative = Void Function(
    Int32 location, Int32 count, Uint8 transpose, Pointer<Double> value);
typedef GlUniformMatrix4dv = void Function(
    int location, int count, int transpose, Pointer<Double> value);

typedef GlUniformMatrix2x3dvNative = Void Function(
    Int32 location, Int32 count, Uint8 transpose, Pointer<Double> value);
typedef GlUniformMatrix2x3dv = void Function(
    int location, int count, int transpose, Pointer<Double> value);

typedef GlUniformMatrix2x4dvNative = Void Function(
    Int32 location, Int32 count, Uint8 transpose, Pointer<Double> value);
typedef GlUniformMatrix2x4dv = void Function(
    int location, int count, int transpose, Pointer<Double> value);

typedef GlUniformMatrix3x2dvNative = Void Function(
    Int32 location, Int32 count, Uint8 transpose, Pointer<Double> value);
typedef GlUniformMatrix3x2dv = void Function(
    int location, int count, int transpose, Pointer<Double> value);

typedef GlUniformMatrix3x4dvNative = Void Function(
    Int32 location, Int32 count, Uint8 transpose, Pointer<Double> value);
typedef GlUniformMatrix3x4dv = void Function(
    int location, int count, int transpose, Pointer<Double> value);

typedef GlUniformMatrix4x2dvNative = Void Function(
    Int32 location, Int32 count, Uint8 transpose, Pointer<Double> value);
typedef GlUniformMatrix4x2dv = void Function(
    int location, int count, int transpose, Pointer<Double> value);

typedef GlUniformMatrix4x3dvNative = Void Function(
    Int32 location, Int32 count, Uint8 transpose, Pointer<Double> value);
typedef GlUniformMatrix4x3dv = void Function(
    int location, int count, int transpose, Pointer<Double> value);

typedef GlGetUniformdvNative = Void Function(
    Uint32 program, Int32 location, Pointer<Double> params);
typedef GlGetUniformdv = void Function(
    int program, int location, Pointer<Double> params);

typedef GlGetSubroutineUniformLocationNative = Int32 Function(
    Uint32 program, Uint32 shadertype, Pointer name);
typedef GlGetSubroutineUniformLocation = int Function(
    int program, int shadertype, /*String*/ Pointer name);

typedef GlGetSubroutineIndexNative = Uint32 Function(
    Uint32 program, Uint32 shadertype, Pointer name);
typedef GlGetSubroutineIndex = int Function(
    int program, int shadertype, /*String*/ Pointer name);

typedef GlGetActiveSubroutineUniformivNative = Void Function(Uint32 program,
    Uint32 shadertype, Uint32 index, Uint32 pname, Pointer<Int32> values);
typedef GlGetActiveSubroutineUniformiv = void Function(
    int program, int shadertype, int index, int pname, Pointer<Int32> values);

typedef GlGetActiveSubroutineUniformNameNative = Void Function(
    Uint32 program,
    Uint32 shadertype,
    Uint32 index,
    Int32 bufSize,
    Pointer<Int32> length,
    Pointer name);
typedef GlGetActiveSubroutineUniformName = void Function(
    int program,
    int shadertype,
    int index,
    int bufSize,
    Pointer<Int32> length,
    Pointer name);

typedef GlGetActiveSubroutineNameNative = Void Function(
    Uint32 program,
    Uint32 shadertype,
    Uint32 index,
    Int32 bufSize,
    Pointer<Int32> length,
    Pointer name);
typedef GlGetActiveSubroutineName = void Function(int program, int shadertype,
    int index, int bufSize, Pointer<Int32> length, Pointer name);

typedef GlUniformSubroutinesuivNative = Void Function(
    Uint32 shadertype, Int32 count, Pointer<Uint32> indices);
typedef GlUniformSubroutinesuiv = void Function(
    int shadertype, int count, Pointer<Uint32> indices);

typedef GlGetUniformSubroutineuivNative = Void Function(
    Uint32 shadertype, Int32 location, Pointer<Uint32> params);
typedef GlGetUniformSubroutineuiv = void Function(
    int shadertype, int location, Pointer<Uint32> params);

typedef GlGetProgramStageivNative = Void Function(
    Uint32 program, Uint32 shadertype, Uint32 pname, Pointer<Int32> values);
typedef GlGetProgramStageiv = void Function(
    int program, int shadertype, int pname, Pointer<Int32> values);

typedef GlPatchParameteriNative = Void Function(Uint32 pname, Int32 value);
typedef GlPatchParameteri = void Function(int pname, int value);

typedef GlPatchParameterfvNative = Void Function(
    Uint32 pname, Pointer<Float> values);
typedef GlPatchParameterfv = void Function(int pname, Pointer<Float> values);

typedef GlBindTransformFeedbackNative = Void Function(Uint32 target, Uint32 id);
typedef GlBindTransformFeedback = void Function(int target, int id);

typedef GlDeleteTransformFeedbacksNative = Void Function(
    Int32 n, Pointer<Uint32> ids);
typedef GlDeleteTransformFeedbacks = void Function(int n, Pointer<Uint32> ids);

typedef GlGenTransformFeedbacksNative = Void Function(
    Int32 n, Pointer<Uint32> ids);
typedef GlGenTransformFeedbacks = void Function(int n, Pointer<Uint32> ids);

typedef GlIsTransformFeedbackNative = Uint8 Function(Uint32 id);
typedef GlIsTransformFeedback = int Function(int id);

typedef GlPauseTransformFeedbackNative = Void Function();
typedef GlPauseTransformFeedback = void Function();

typedef GlResumeTransformFeedbackNative = Void Function();
typedef GlResumeTransformFeedback = void Function();

typedef GlDrawTransformFeedbackNative = Void Function(Uint32 mode, Uint32 id);
typedef GlDrawTransformFeedback = void Function(int mode, int id);

typedef GlDrawTransformFeedbackStreamNative = Void Function(
    Uint32 mode, Uint32 id, Uint32 stream);
typedef GlDrawTransformFeedbackStream = void Function(
    int mode, int id, int stream);

typedef GlBeginQueryIndexedNative = Void Function(
    Uint32 target, Uint32 index, Uint32 id);
typedef GlBeginQueryIndexed = void Function(int target, int index, int id);

typedef GlEndQueryIndexedNative = Void Function(Uint32 target, Uint32 index);
typedef GlEndQueryIndexed = void Function(int target, int index);

typedef GlGetQueryIndexedivNative = Void Function(
    Uint32 target, Uint32 index, Uint32 pname, Pointer<Int32> params);
typedef GlGetQueryIndexediv = void Function(
    int target, int index, int pname, Pointer<Int32> params);

//GL_VERSION_4_1
typedef GlReleaseShaderCompilerNative = Void Function();
typedef GlReleaseShaderCompiler = void Function();

typedef GlShaderBinaryNative = Void Function(Int32 count,
    Pointer<Uint32> shaders, Uint32 binaryFormat, Pointer binary, Int32 length);
typedef GlShaderBinary = void Function(int count, Pointer<Uint32> shaders,
    int binaryFormat, Pointer binary, int length);

typedef GlGetShaderPrecisionFormatNative = Void Function(Uint32 shadertype,
    Uint32 precisiontype, Pointer<Int32> range, Pointer<Int32> precision);
typedef GlGetShaderPrecisionFormat = void Function(int shadertype,
    int precisiontype, Pointer<Int32> range, Pointer<Int32> precision);

typedef GlDepthRangefNative = Void Function(Float n, Float f);
typedef GlDepthRangef = void Function(double n, double f);

typedef GlClearDepthfNative = Void Function(Float d);
typedef GlClearDepthf = void Function(double d);

typedef GlGetProgramBinaryNative = Void Function(Uint32 program, Int32 bufSize,
    Pointer<Int32> length, Pointer<Uint32> binaryFormat, Pointer binary);
typedef GlGetProgramBinary = void Function(int program, int bufSize,
    Pointer<Int32> length, Pointer<Uint32> binaryFormat, Pointer binary);

typedef GlProgramBinaryNative = Void Function(
    Uint32 program, Uint32 binaryFormat, Pointer binary, Int32 length);
typedef GlProgramBinary = void Function(
    int program, int binaryFormat, Pointer binary, int length);

typedef GlProgramParameteriNative = Void Function(
    Uint32 program, Uint32 pname, Int32 value);
typedef GlProgramParameteri = void Function(int program, int pname, int value);

typedef GlUseProgramStagesNative = Void Function(
    Uint32 pipeline, Uint32 stages, Uint32 program);
typedef GlUseProgramStages = void Function(
    int pipeline, int stages, int program);

typedef GlActiveShaderProgramNative = Void Function(
    Uint32 pipeline, Uint32 program);
typedef GlActiveShaderProgram = void Function(int pipeline, int program);

typedef GlCreateShaderProgramvNative = Uint32 Function(
    Uint32 type, Int32 count, Pointer strings);
typedef GlCreateShaderProgramv = int Function(
    int type, int count, /*List<String>*/ Pointer strings);

typedef GlBindProgramPipelineNative = Void Function(Uint32 pipeline);
typedef GlBindProgramPipeline = void Function(int pipeline);

typedef GlDeleteProgramPipelinesNative = Void Function(
    Int32 n, Pointer<Uint32> pipelines);
typedef GlDeleteProgramPipelines = void Function(
    int n, Pointer<Uint32> pipelines);

typedef GlGenProgramPipelinesNative = Void Function(
    Int32 n, Pointer<Uint32> pipelines);
typedef GlGenProgramPipelines = void Function(int n, Pointer<Uint32> pipelines);

typedef GlIsProgramPipelineNative = Uint8 Function(Uint32 pipeline);
typedef GlIsProgramPipeline = int Function(int pipeline);

typedef GlGetProgramPipelineivNative = Void Function(
    Uint32 pipeline, Uint32 pname, Pointer<Int32> params);
typedef GlGetProgramPipelineiv = void Function(
    int pipeline, int pname, Pointer<Int32> params);

typedef GlProgramUniform1iNative = Void Function(
    Uint32 program, Int32 location, Int32 v0);
typedef GlProgramUniform1i = void Function(int program, int location, int v0);

typedef GlProgramUniform1ivNative = Void Function(
    Uint32 program, Int32 location, Int32 count, Pointer<Int32> value);
typedef GlProgramUniform1iv = void Function(
    int program, int location, int count, Pointer<Int32> value);

typedef GlProgramUniform1fNative = Void Function(
    Uint32 program, Int32 location, Float v0);
typedef GlProgramUniform1f = void Function(
    int program, int location, double v0);

typedef GlProgramUniform1fvNative = Void Function(
    Uint32 program, Int32 location, Int32 count, Pointer<Float> value);
typedef GlProgramUniform1fv = void Function(
    int program, int location, int count, Pointer<Float> value);

typedef GlProgramUniform1dNative = Void Function(
    Uint32 program, Int32 location, Double v0);
typedef GlProgramUniform1d = void Function(
    int program, int location, double v0);

typedef GlProgramUniform1dvNative = Void Function(
    Uint32 program, Int32 location, Int32 count, Pointer<Double> value);
typedef GlProgramUniform1dv = void Function(
    int program, int location, int count, Pointer<Double> value);

typedef GlProgramUniform1uiNative = Void Function(
    Uint32 program, Int32 location, Uint32 v0);
typedef GlProgramUniform1ui = void Function(int program, int location, int v0);

typedef GlProgramUniform1uivNative = Void Function(
    Uint32 program, Int32 location, Int32 count, Pointer<Uint32> value);
typedef GlProgramUniform1uiv = void Function(
    int program, int location, int count, Pointer<Uint32> value);

typedef GlProgramUniform2iNative = Void Function(
    Uint32 program, Int32 location, Int32 v0, Int32 v1);
typedef GlProgramUniform2i = void Function(
    int program, int location, int v0, int v1);

typedef GlProgramUniform2ivNative = Void Function(
    Uint32 program, Int32 location, Int32 count, Pointer<Int32> value);
typedef GlProgramUniform2iv = void Function(
    int program, int location, int count, Pointer<Int32> value);

typedef GlProgramUniform2fNative = Void Function(
    Uint32 program, Int32 location, Float v0, Float v1);
typedef GlProgramUniform2f = void Function(
    int program, int location, double v0, double v1);

typedef GlProgramUniform2fvNative = Void Function(
    Uint32 program, Int32 location, Int32 count, Pointer<Float> value);
typedef GlProgramUniform2fv = void Function(
    int program, int location, int count, Pointer<Float> value);

typedef GlProgramUniform2dNative = Void Function(
    Uint32 program, Int32 location, Double v0, Double v1);
typedef GlProgramUniform2d = void Function(
    int program, int location, double v0, double v1);

typedef GlProgramUniform2dvNative = Void Function(
    Uint32 program, Int32 location, Int32 count, Pointer<Double> value);
typedef GlProgramUniform2dv = void Function(
    int program, int location, int count, Pointer<Double> value);

typedef GlProgramUniform2uiNative = Void Function(
    Uint32 program, Int32 location, Uint32 v0, Uint32 v1);
typedef GlProgramUniform2ui = void Function(
    int program, int location, int v0, int v1);

typedef GlProgramUniform2uivNative = Void Function(
    Uint32 program, Int32 location, Int32 count, Pointer<Uint32> value);
typedef GlProgramUniform2uiv = void Function(
    int program, int location, int count, Pointer<Uint32> value);

typedef GlProgramUniform3iNative = Void Function(
    Uint32 program, Int32 location, Int32 v0, Int32 v1, Int32 v2);
typedef GlProgramUniform3i = void Function(
    int program, int location, int v0, int v1, int v2);

typedef GlProgramUniform3ivNative = Void Function(
    Uint32 program, Int32 location, Int32 count, Pointer<Int32> value);
typedef GlProgramUniform3iv = void Function(
    int program, int location, int count, Pointer<Int32> value);

typedef GlProgramUniform3fNative = Void Function(
    Uint32 program, Int32 location, Float v0, Float v1, Float v2);
typedef GlProgramUniform3f = void Function(
    int program, int location, double v0, double v1, double v2);

typedef GlProgramUniform3fvNative = Void Function(
    Uint32 program, Int32 location, Int32 count, Pointer<Float> value);
typedef GlProgramUniform3fv = void Function(
    int program, int location, int count, Pointer<Float> value);

typedef GlProgramUniform3dNative = Void Function(
    Uint32 program, Int32 location, Double v0, Double v1, Double v2);
typedef GlProgramUniform3d = void Function(
    int program, int location, double v0, double v1, double v2);

typedef GlProgramUniform3dvNative = Void Function(
    Uint32 program, Int32 location, Int32 count, Pointer<Double> value);
typedef GlProgramUniform3dv = void Function(
    int program, int location, int count, Pointer<Double> value);

typedef GlProgramUniform3uiNative = Void Function(
    Uint32 program, Int32 location, Uint32 v0, Uint32 v1, Uint32 v2);
typedef GlProgramUniform3ui = void Function(
    int program, int location, int v0, int v1, int v2);

typedef GlProgramUniform3uivNative = Void Function(
    Uint32 program, Int32 location, Int32 count, Pointer<Uint32> value);
typedef GlProgramUniform3uiv = void Function(
    int program, int location, int count, Pointer<Uint32> value);

typedef GlProgramUniform4iNative = Void Function(
    Uint32 program, Int32 location, Int32 v0, Int32 v1, Int32 v2, Int32 v3);
typedef GlProgramUniform4i = void Function(
    int program, int location, int v0, int v1, int v2, int v3);

typedef GlProgramUniform4ivNative = Void Function(
    Uint32 program, Int32 location, Int32 count, Pointer<Int32> value);
typedef GlProgramUniform4iv = void Function(
    int program, int location, int count, Pointer<Int32> value);

typedef GlProgramUniform4fNative = Void Function(
    Uint32 program, Int32 location, Float v0, Float v1, Float v2, Float v3);
typedef GlProgramUniform4f = void Function(
    int program, int location, double v0, double v1, double v2, double v3);

typedef GlProgramUniform4fvNative = Void Function(
    Uint32 program, Int32 location, Int32 count, Pointer<Float> value);
typedef GlProgramUniform4fv = void Function(
    int program, int location, int count, Pointer<Float> value);

typedef GlProgramUniform4dNative = Void Function(
    Uint32 program, Int32 location, Double v0, Double v1, Double v2, Double v3);
typedef GlProgramUniform4d = void Function(
    int program, int location, double v0, double v1, double v2, double v3);

typedef GlProgramUniform4dvNative = Void Function(
    Uint32 program, Int32 location, Int32 count, Pointer<Double> value);
typedef GlProgramUniform4dv = void Function(
    int program, int location, int count, Pointer<Double> value);

typedef GlProgramUniform4uiNative = Void Function(
    Uint32 program, Int32 location, Uint32 v0, Uint32 v1, Uint32 v2, Uint32 v3);
typedef GlProgramUniform4ui = void Function(
    int program, int location, int v0, int v1, int v2, int v3);

typedef GlProgramUniform4uivNative = Void Function(
    Uint32 program, Int32 location, Int32 count, Pointer<Uint32> value);
typedef GlProgramUniform4uiv = void Function(
    int program, int location, int count, Pointer<Uint32> value);

typedef GlProgramUniformMatrix2fvNative = Void Function(Uint32 program,
    Int32 location, Int32 count, Uint8 transpose, Pointer<Float> value);
typedef GlProgramUniformMatrix2fv = void Function(
    int program, int location, int count, int transpose, Pointer<Float> value);

typedef GlProgramUniformMatrix3fvNative = Void Function(Uint32 program,
    Int32 location, Int32 count, Uint8 transpose, Pointer<Float> value);
typedef GlProgramUniformMatrix3fv = void Function(
    int program, int location, int count, int transpose, Pointer<Float> value);

typedef GlProgramUniformMatrix4fvNative = Void Function(Uint32 program,
    Int32 location, Int32 count, Uint8 transpose, Pointer<Float> value);
typedef GlProgramUniformMatrix4fv = void Function(
    int program, int location, int count, int transpose, Pointer<Float> value);

typedef GlProgramUniformMatrix2dvNative = Void Function(Uint32 program,
    Int32 location, Int32 count, Uint8 transpose, Pointer<Double> value);
typedef GlProgramUniformMatrix2dv = void Function(
    int program, int location, int count, int transpose, Pointer<Double> value);

typedef GlProgramUniformMatrix3dvNative = Void Function(Uint32 program,
    Int32 location, Int32 count, Uint8 transpose, Pointer<Double> value);
typedef GlProgramUniformMatrix3dv = void Function(
    int program, int location, int count, int transpose, Pointer<Double> value);

typedef GlProgramUniformMatrix4dvNative = Void Function(Uint32 program,
    Int32 location, Int32 count, Uint8 transpose, Pointer<Double> value);
typedef GlProgramUniformMatrix4dv = void Function(
    int program, int location, int count, int transpose, Pointer<Double> value);

typedef GlProgramUniformMatrix2x3fvNative = Void Function(Uint32 program,
    Int32 location, Int32 count, Uint8 transpose, Pointer<Float> value);
typedef GlProgramUniformMatrix2x3fv = void Function(
    int program, int location, int count, int transpose, Pointer<Float> value);

typedef GlProgramUniformMatrix3x2fvNative = Void Function(Uint32 program,
    Int32 location, Int32 count, Uint8 transpose, Pointer<Float> value);
typedef GlProgramUniformMatrix3x2fv = void Function(
    int program, int location, int count, int transpose, Pointer<Float> value);

typedef GlProgramUniformMatrix2x4fvNative = Void Function(Uint32 program,
    Int32 location, Int32 count, Uint8 transpose, Pointer<Float> value);
typedef GlProgramUniformMatrix2x4fv = void Function(
    int program, int location, int count, int transpose, Pointer<Float> value);

typedef GlProgramUniformMatrix4x2fvNative = Void Function(Uint32 program,
    Int32 location, Int32 count, Uint8 transpose, Pointer<Float> value);
typedef GlProgramUniformMatrix4x2fv = void Function(
    int program, int location, int count, int transpose, Pointer<Float> value);

typedef GlProgramUniformMatrix3x4fvNative = Void Function(Uint32 program,
    Int32 location, Int32 count, Uint8 transpose, Pointer<Float> value);
typedef GlProgramUniformMatrix3x4fv = void Function(
    int program, int location, int count, int transpose, Pointer<Float> value);

typedef GlProgramUniformMatrix4x3fvNative = Void Function(Uint32 program,
    Int32 location, Int32 count, Uint8 transpose, Pointer<Float> value);
typedef GlProgramUniformMatrix4x3fv = void Function(
    int program, int location, int count, int transpose, Pointer<Float> value);

typedef GlProgramUniformMatrix2x3dvNative = Void Function(Uint32 program,
    Int32 location, Int32 count, Uint8 transpose, Pointer<Double> value);
typedef GlProgramUniformMatrix2x3dv = void Function(
    int program, int location, int count, int transpose, Pointer<Double> value);

typedef GlProgramUniformMatrix3x2dvNative = Void Function(Uint32 program,
    Int32 location, Int32 count, Uint8 transpose, Pointer<Double> value);
typedef GlProgramUniformMatrix3x2dv = void Function(
    int program, int location, int count, int transpose, Pointer<Double> value);

typedef GlProgramUniformMatrix2x4dvNative = Void Function(Uint32 program,
    Int32 location, Int32 count, Uint8 transpose, Pointer<Double> value);
typedef GlProgramUniformMatrix2x4dv = void Function(
    int program, int location, int count, int transpose, Pointer<Double> value);

typedef GlProgramUniformMatrix4x2dvNative = Void Function(Uint32 program,
    Int32 location, Int32 count, Uint8 transpose, Pointer<Double> value);
typedef GlProgramUniformMatrix4x2dv = void Function(
    int program, int location, int count, int transpose, Pointer<Double> value);

typedef GlProgramUniformMatrix3x4dvNative = Void Function(Uint32 program,
    Int32 location, Int32 count, Uint8 transpose, Pointer<Double> value);
typedef GlProgramUniformMatrix3x4dv = void Function(
    int program, int location, int count, int transpose, Pointer<Double> value);

typedef GlProgramUniformMatrix4x3dvNative = Void Function(Uint32 program,
    Int32 location, Int32 count, Uint8 transpose, Pointer<Double> value);
typedef GlProgramUniformMatrix4x3dv = void Function(
    int program, int location, int count, int transpose, Pointer<Double> value);

typedef GlValidateProgramPipelineNative = Void Function(Uint32 pipeline);
typedef GlValidateProgramPipeline = void Function(int pipeline);

typedef GlGetProgramPipelineInfoLogNative = Void Function(
    Uint32 pipeline, Int32 bufSize, Pointer<Int32> length, Pointer infoLog);
typedef GlGetProgramPipelineInfoLog = void Function(
    int pipeline, int bufSize, Pointer<Int32> length, Pointer infoLog);

typedef GlVertexAttribL1dNative = Void Function(Uint32 index, Double x);
typedef GlVertexAttribL1d = void Function(int index, double x);

typedef GlVertexAttribL2dNative = Void Function(
    Uint32 index, Double x, Double y);
typedef GlVertexAttribL2d = void Function(int index, double x, double y);

typedef GlVertexAttribL3dNative = Void Function(
    Uint32 index, Double x, Double y, Double z);
typedef GlVertexAttribL3d = void Function(
    int index, double x, double y, double z);

typedef GlVertexAttribL4dNative = Void Function(
    Uint32 index, Double x, Double y, Double z, Double w);
typedef GlVertexAttribL4d = void Function(
    int index, double x, double y, double z, double w);

typedef GlVertexAttribL1dvNative = Void Function(
    Uint32 index, Pointer<Double> v);
typedef GlVertexAttribL1dv = void Function(int index, Pointer<Double> v);

typedef GlVertexAttribL2dvNative = Void Function(
    Uint32 index, Pointer<Double> v);
typedef GlVertexAttribL2dv = void Function(int index, Pointer<Double> v);

typedef GlVertexAttribL3dvNative = Void Function(
    Uint32 index, Pointer<Double> v);
typedef GlVertexAttribL3dv = void Function(int index, Pointer<Double> v);

typedef GlVertexAttribL4dvNative = Void Function(
    Uint32 index, Pointer<Double> v);
typedef GlVertexAttribL4dv = void Function(int index, Pointer<Double> v);

typedef GlVertexAttribLPointerNative = Void Function(
    Uint32 index, Int32 size, Uint32 type, Int32 stride, Uint32 pointer);
typedef GlVertexAttribLPointer = void Function(
    int index, int size, int type, int stride, int pointer);

typedef GlGetVertexAttribLdvNative = Void Function(
    Uint32 index, Uint32 pname, Pointer<Double> params);
typedef GlGetVertexAttribLdv = void Function(
    int index, int pname, Pointer<Double> params);

typedef GlViewportArrayvNative = Void Function(
    Uint32 first, Int32 count, Pointer<Float> v);
typedef GlViewportArrayv = void Function(
    int first, int count, Pointer<Float> v);

typedef GlViewportIndexedfNative = Void Function(
    Uint32 index, Float x, Float y, Float w, Float h);
typedef GlViewportIndexedf = void Function(
    int index, double x, double y, double w, double h);

typedef GlViewportIndexedfvNative = Void Function(
    Uint32 index, Pointer<Float> v);
typedef GlViewportIndexedfv = void Function(int index, Pointer<Float> v);

typedef GlScissorArrayvNative = Void Function(
    Uint32 first, Int32 count, Pointer<Int32> v);
typedef GlScissorArrayv = void Function(int first, int count, Pointer<Int32> v);

typedef GlScissorIndexedNative = Void Function(
    Uint32 index, Int32 left, Int32 bottom, Int32 width, Int32 height);
typedef GlScissorIndexed = void Function(
    int index, int left, int bottom, int width, int height);

typedef GlScissorIndexedvNative = Void Function(Uint32 index, Pointer<Int32> v);
typedef GlScissorIndexedv = void Function(int index, Pointer<Int32> v);

typedef GlDepthRangeArrayvNative = Void Function(
    Uint32 first, Int32 count, Pointer<Double> v);
typedef GlDepthRangeArrayv = void Function(
    int first, int count, Pointer<Double> v);

typedef GlDepthRangeIndexedNative = Void Function(
    Uint32 index, Double n, Double f);
typedef GlDepthRangeIndexed = void Function(int index, double n, double f);

typedef GlGetFloati_vNative = Void Function(
    Uint32 target, Uint32 index, Pointer<Float> data);
typedef GlGetFloati_v = void Function(
    int target, int index, Pointer<Float> data);

typedef GlGetDoublei_vNative = Void Function(
    Uint32 target, Uint32 index, Pointer<Double> data);
typedef GlGetDoublei_v = void Function(
    int target, int index, Pointer<Double> data);

//GL_VERSION_4_2
typedef GlDrawArraysInstancedBaseInstanceNative = Void Function(Uint32 mode,
    Int32 first, Int32 count, Int32 instancecount, Uint32 baseinstance);
typedef GlDrawArraysInstancedBaseInstance = void Function(
    int mode, int first, int count, int instancecount, int baseinstance);

typedef GlDrawElementsInstancedBaseInstanceNative = Void Function(
    Uint32 mode,
    Int32 count,
    Uint32 type,
    Pointer indices,
    Int32 instancecount,
    Uint32 baseinstance);
typedef GlDrawElementsInstancedBaseInstance = void Function(int mode, int count,
    int type, Pointer indices, int instancecount, int baseinstance);

typedef GlDrawElementsInstancedBaseVertexBaseInstanceNative = Void Function(
    Uint32 mode,
    Int32 count,
    Uint32 type,
    Pointer indices,
    Int32 instancecount,
    Int32 basevertex,
    Uint32 baseinstance);
typedef GlDrawElementsInstancedBaseVertexBaseInstance = void Function(
    int mode,
    int count,
    int type,
    Pointer indices,
    int instancecount,
    int basevertex,
    int baseinstance);

typedef GlGetInternalformativNative = Void Function(Uint32 target,
    Uint32 internalformat, Uint32 pname, Int32 count, Pointer<Int32> params);
typedef GlGetInternalformativ = void Function(int target, int internalformat,
    int pname, int count, Pointer<Int32> params);

typedef GlGetActiveAtomicCounterBufferivNative = Void Function(
    Uint32 program, Uint32 bufferIndex, Uint32 pname, Pointer<Int32> params);
typedef GlGetActiveAtomicCounterBufferiv = void Function(
    int program, int bufferIndex, int pname, Pointer<Int32> params);

typedef GlBindImageTextureNative = Void Function(Uint32 unit, Uint32 texture,
    Int32 level, Uint8 layered, Int32 layer, Uint32 access, Uint32 format);
typedef GlBindImageTexture = void Function(int unit, int texture, int level,
    int layered, int layer, int access, int format);

typedef GlMemoryBarrierNative = Void Function(Uint32 barriers);
typedef GlMemoryBarrier = void Function(int barriers);

typedef GlTexStorage1DNative = Void Function(
    Uint32 target, Int32 levels, Uint32 internalformat, Int32 width);
typedef GlTexStorage1D = void Function(
    int target, int levels, int internalformat, int width);

typedef GlTexStorage2DNative = Void Function(Uint32 target, Int32 levels,
    Uint32 internalformat, Int32 width, Int32 height);
typedef GlTexStorage2D = void Function(
    int target, int levels, int internalformat, int width, int height);

typedef GlTexStorage3DNative = Void Function(Uint32 target, Int32 levels,
    Uint32 internalformat, Int32 width, Int32 height, Int32 depth);
typedef GlTexStorage3D = void Function(int target, int levels,
    int internalformat, int width, int height, int depth);

typedef GlDrawTransformFeedbackInstancedNative = Void Function(
    Uint32 mode, Uint32 id, Int32 instancecount);
typedef GlDrawTransformFeedbackInstanced = void Function(
    int mode, int id, int instancecount);

typedef GlDrawTransformFeedbackStreamInstancedNative = Void Function(
    Uint32 mode, Uint32 id, Uint32 stream, Int32 instancecount);
typedef GlDrawTransformFeedbackStreamInstanced = void Function(
    int mode, int id, int stream, int instancecount);

//GL_VERSION_4_3
typedef GlClearBufferDataNative = Void Function(Uint32 target,
    Uint32 internalformat, Uint32 format, Uint32 type, Pointer data);
typedef GlClearBufferData = void Function(
    int target, int internalformat, int format, int type, Pointer data);

typedef GlClearBufferSubDataNative = Void Function(
    Uint32 target,
    Uint32 internalformat,
    Int64 offset,
    Int64 size,
    Uint32 format,
    Uint32 type,
    Pointer data);
typedef GlClearBufferSubData = void Function(int target, int internalformat,
    int offset, int size, int format, int type, Pointer data);

typedef GlDispatchComputeNative = Void Function(
    Uint32 num_groups_x, Uint32 num_groups_y, Uint32 num_groups_z);
typedef GlDispatchCompute = void Function(
    int num_groups_x, int num_groups_y, int num_groups_z);

typedef GlDispatchComputeIndirectNative = Void Function(Int64 indirect);
typedef GlDispatchComputeIndirect = void Function(int indirect);

typedef GlCopyImageSubDataNative = Void Function(
    Uint32 srcName,
    Uint32 srcTarget,
    Int32 srcLevel,
    Int32 srcX,
    Int32 srcY,
    Int32 srcZ,
    Uint32 dstName,
    Uint32 dstTarget,
    Int32 dstLevel,
    Int32 dstX,
    Int32 dstY,
    Int32 dstZ,
    Int32 srcWidth,
    Int32 srcHeight,
    Int32 srcDepth);
typedef GlCopyImageSubData = void Function(
    int srcName,
    int srcTarget,
    int srcLevel,
    int srcX,
    int srcY,
    int srcZ,
    int dstName,
    int dstTarget,
    int dstLevel,
    int dstX,
    int dstY,
    int dstZ,
    int srcWidth,
    int srcHeight,
    int srcDepth);

typedef GlFramebufferParameteriNative = Void Function(
    Uint32 target, Uint32 pname, Int32 param);
typedef GlFramebufferParameteri = void Function(
    int target, int pname, int param);

typedef GlGetFramebufferParameterivNative = Void Function(
    Uint32 target, Uint32 pname, Pointer<Int32> params);
typedef GlGetFramebufferParameteriv = void Function(
    int target, int pname, Pointer<Int32> params);

typedef GlGetInternalformati64vNative = Void Function(Uint32 target,
    Uint32 internalformat, Uint32 pname, Int32 count, Pointer<Int64> params);
typedef GlGetInternalformati64v = void Function(int target, int internalformat,
    int pname, int count, Pointer<Int64> params);

typedef GlInvalidateTexSubImageNative = Void Function(
    Uint32 texture,
    Int32 level,
    Int32 xoffset,
    Int32 yoffset,
    Int32 zoffset,
    Int32 width,
    Int32 height,
    Int32 depth);
typedef GlInvalidateTexSubImage = void Function(int texture, int level,
    int xoffset, int yoffset, int zoffset, int width, int height, int depth);

typedef GlInvalidateTexImageNative = Void Function(Uint32 texture, Int32 level);
typedef GlInvalidateTexImage = void Function(int texture, int level);

typedef GlInvalidateBufferSubDataNative = Void Function(
    Uint32 buffer, Int64 offset, Int64 length);
typedef GlInvalidateBufferSubData = void Function(
    int buffer, int offset, int length);

typedef GlInvalidateBufferDataNative = Void Function(Uint32 buffer);
typedef GlInvalidateBufferData = void Function(int buffer);

typedef GlInvalidateFramebufferNative = Void Function(
    Uint32 target, Int32 numAttachments, Pointer<Uint32> attachments);
typedef GlInvalidateFramebuffer = void Function(
    int target, int numAttachments, Pointer<Uint32> attachments);

typedef GlInvalidateSubFramebufferNative = Void Function(
    Uint32 target,
    Int32 numAttachments,
    Pointer<Uint32> attachments,
    Int32 x,
    Int32 y,
    Int32 width,
    Int32 height);
typedef GlInvalidateSubFramebuffer = void Function(
    int target,
    int numAttachments,
    Pointer<Uint32> attachments,
    int x,
    int y,
    int width,
    int height);

typedef GlMultiDrawArraysIndirectNative = Void Function(
    Uint32 mode, Pointer indirect, Int32 drawcount, Int32 stride);
typedef GlMultiDrawArraysIndirect = void Function(
    int mode, Pointer indirect, int drawcount, int stride);

typedef GlMultiDrawElementsIndirectNative = Void Function(
    Uint32 mode, Uint32 type, Pointer indirect, Int32 drawcount, Int32 stride);
typedef GlMultiDrawElementsIndirect = void Function(
    int mode, int type, Pointer indirect, int drawcount, int stride);

typedef GlGetProgramInterfaceivNative = Void Function(Uint32 program,
    Uint32 programInterface, Uint32 pname, Pointer<Int32> params);
typedef GlGetProgramInterfaceiv = void Function(
    int program, int programInterface, int pname, Pointer<Int32> params);

typedef GlGetProgramResourceIndexNative = Uint32 Function(
    Uint32 program, Uint32 programInterface, Pointer name);
typedef GlGetProgramResourceIndex = int Function(
    int program, int programInterface, /*String*/ Pointer name);

typedef GlGetProgramResourceNameNative = Void Function(
    Uint32 program,
    Uint32 programInterface,
    Uint32 index,
    Int32 bufSize,
    Pointer<Int32> length,
    Pointer name);
typedef GlGetProgramResourceName = void Function(
    int program,
    int programInterface,
    int index,
    int bufSize,
    Pointer<Int32> length,
    Pointer name);

typedef GlGetProgramResourceivNative = Void Function(
    Uint32 program,
    Uint32 programInterface,
    Uint32 index,
    Int32 propCount,
    Pointer<Uint32> props,
    Int32 count,
    Pointer<Int32> length,
    Pointer<Int32> params);
typedef GlGetProgramResourceiv = void Function(
    int program,
    int programInterface,
    int index,
    int propCount,
    Pointer<Uint32> props,
    int count,
    Pointer<Int32> length,
    Pointer<Int32> params);

typedef GlGetProgramResourceLocationNative = Int32 Function(
    Uint32 program, Uint32 programInterface, Pointer name);
typedef GlGetProgramResourceLocation = int Function(
    int program, int programInterface, /*String*/ Pointer name);

typedef GlGetProgramResourceLocationIndexNative = Int32 Function(
    Uint32 program, Uint32 programInterface, Pointer name);
typedef GlGetProgramResourceLocationIndex = int Function(
    int program, int programInterface, /*String*/ Pointer name);

typedef GlShaderStorageBlockBindingNative = Void Function(
    Uint32 program, Uint32 storageBlockIndex, Uint32 storageBlockBinding);
typedef GlShaderStorageBlockBinding = void Function(
    int program, int storageBlockIndex, int storageBlockBinding);

typedef GlTexBufferRangeNative = Void Function(Uint32 target,
    Uint32 internalformat, Uint32 buffer, Int64 offset, Int64 size);
typedef GlTexBufferRange = void Function(
    int target, int internalformat, int buffer, int offset, int size);

typedef GlTexStorage2DMultisampleNative = Void Function(
    Uint32 target,
    Int32 samples,
    Uint32 internalformat,
    Int32 width,
    Int32 height,
    Uint8 fixedsamplelocations);
typedef GlTexStorage2DMultisample = void Function(int target, int samples,
    int internalformat, int width, int height, int fixedsamplelocations);

typedef GlTexStorage3DMultisampleNative = Void Function(
    Uint32 target,
    Int32 samples,
    Uint32 internalformat,
    Int32 width,
    Int32 height,
    Int32 depth,
    Uint8 fixedsamplelocations);
typedef GlTexStorage3DMultisample = void Function(
    int target,
    int samples,
    int internalformat,
    int width,
    int height,
    int depth,
    int fixedsamplelocations);

typedef GlTextureViewNative = Void Function(
    Uint32 texture,
    Uint32 target,
    Uint32 origtexture,
    Uint32 internalformat,
    Uint32 minlevel,
    Uint32 numlevels,
    Uint32 minlayer,
    Uint32 numlayers);
typedef GlTextureView = void Function(
    int texture,
    int target,
    int origtexture,
    int internalformat,
    int minlevel,
    int numlevels,
    int minlayer,
    int numlayers);

typedef GlBindVertexBufferNative = Void Function(
    Uint32 bindingindex, Uint32 buffer, Int64 offset, Int32 stride);
typedef GlBindVertexBuffer = void Function(
    int bindingindex, int buffer, int offset, int stride);

typedef GlVertexAttribFormatNative = Void Function(Uint32 attribindex,
    Int32 size, Uint32 type, Uint8 normalized, Uint32 relativeoffset);
typedef GlVertexAttribFormat = void Function(
    int attribindex, int size, int type, int normalized, int relativeoffset);

typedef GlVertexAttribIFormatNative = Void Function(
    Uint32 attribindex, Int32 size, Uint32 type, Uint32 relativeoffset);
typedef GlVertexAttribIFormat = void Function(
    int attribindex, int size, int type, int relativeoffset);

typedef GlVertexAttribLFormatNative = Void Function(
    Uint32 attribindex, Int32 size, Uint32 type, Uint32 relativeoffset);
typedef GlVertexAttribLFormat = void Function(
    int attribindex, int size, int type, int relativeoffset);

typedef GlVertexAttribBindingNative = Void Function(
    Uint32 attribindex, Uint32 bindingindex);
typedef GlVertexAttribBinding = void Function(
    int attribindex, int bindingindex);

typedef GlVertexBindingDivisorNative = Void Function(
    Uint32 bindingindex, Uint32 divisor);
typedef GlVertexBindingDivisor = void Function(int bindingindex, int divisor);

typedef GlDebugMessageControlNative = Void Function(Uint32 source, Uint32 type,
    Uint32 severity, Int32 count, Pointer<Uint32> ids, Uint8 enabled);
typedef GlDebugMessageControl = void Function(int source, int type,
    int severity, int count, Pointer<Uint32> ids, int enabled);

typedef GlDebugMessageInsertNative = Void Function(Uint32 source, Uint32 type,
    Uint32 id, Uint32 severity, Int32 length, Pointer buf);
typedef GlDebugMessageInsert = void Function(int source, int type, int id,
    int severity, int length, /*String*/ Pointer buf);

typedef GlDebugMessageCallbackNative = Void Function(
    Pointer callback, Pointer userParam);
typedef GlDebugMessageCallback = void Function(
    Pointer callback, Pointer userParam);

typedef GlGetDebugMessageLogNative = Uint32 Function(
    Uint32 count,
    Int32 bufSize,
    Pointer<Uint32> sources,
    Pointer<Uint32> types,
    Pointer<Uint32> ids,
    Pointer<Uint32> severities,
    Pointer<Int32> lengths,
    Pointer messageLog);
typedef GlGetDebugMessageLog = int Function(
    int count,
    int bufSize,
    Pointer<Uint32> sources,
    Pointer<Uint32> types,
    Pointer<Uint32> ids,
    Pointer<Uint32> severities,
    Pointer<Int32> lengths,
    Pointer messageLog);

typedef GlPushDebugGroupNative = Void Function(
    Uint32 source, Uint32 id, Int32 length, Pointer message);
typedef GlPushDebugGroup = void Function(
    int source, int id, int length, /*String*/ Pointer message);

typedef GlPopDebugGroupNative = Void Function();
typedef GlPopDebugGroup = void Function();

typedef GlObjectLabelNative = Void Function(
    Uint32 identifier, Uint32 name, Int32 length, Pointer label);
typedef GlObjectLabel = void Function(
    int identifier, int name, int length, /*String*/ Pointer label);

typedef GlGetObjectLabelNative = Void Function(Uint32 identifier, Uint32 name,
    Int32 bufSize, Pointer<Int32> length, Pointer label);
typedef GlGetObjectLabel = void Function(int identifier, int name, int bufSize,
    Pointer<Int32> length, Pointer label);

typedef GlObjectPtrLabelNative = Void Function(
    Pointer ptr, Int32 length, Pointer label);
typedef GlObjectPtrLabel = void Function(
    Pointer ptr, int length, /*String*/ Pointer label);

typedef GlGetObjectPtrLabelNative = Void Function(
    Pointer ptr, Int32 bufSize, Pointer<Int32> length, Pointer label);
typedef GlGetObjectPtrLabel = void Function(
    Pointer ptr, int bufSize, Pointer<Int32> length, Pointer label);

//GL_VERSION_4_4
typedef GlBufferStorageNative = Void Function(
    Uint32 target, Int64 size, Pointer data, Uint32 flags);
typedef GlBufferStorage = void Function(
    int target, int size, Pointer data, int flags);

typedef GlClearTexImageNative = Void Function(
    Uint32 texture, Int32 level, Uint32 format, Uint32 type, Pointer data);
typedef GlClearTexImage = void Function(
    int texture, int level, int format, int type, Pointer data);

typedef GlClearTexSubImageNative = Void Function(
    Uint32 texture,
    Int32 level,
    Int32 xoffset,
    Int32 yoffset,
    Int32 zoffset,
    Int32 width,
    Int32 height,
    Int32 depth,
    Uint32 format,
    Uint32 type,
    Pointer data);
typedef GlClearTexSubImage = void Function(
    int texture,
    int level,
    int xoffset,
    int yoffset,
    int zoffset,
    int width,
    int height,
    int depth,
    int format,
    int type,
    Pointer data);

typedef GlBindBuffersBaseNative = Void Function(
    Uint32 target, Uint32 first, Int32 count, Pointer<Uint32> buffers);
typedef GlBindBuffersBase = void Function(
    int target, int first, int count, Pointer<Uint32> buffers);

typedef GlBindBuffersRangeNative = Void Function(
    Uint32 target,
    Uint32 first,
    Int32 count,
    Pointer<Uint32> buffers,
    Pointer<Int64> offsets,
    Pointer<Int64> sizes);
typedef GlBindBuffersRange = void Function(int target, int first, int count,
    Pointer<Uint32> buffers, Pointer<Int64> offsets, Pointer<Int64> sizes);

typedef GlBindTexturesNative = Void Function(
    Uint32 first, Int32 count, Pointer<Uint32> textures);
typedef GlBindTextures = void Function(
    int first, int count, Pointer<Uint32> textures);

typedef GlBindSamplersNative = Void Function(
    Uint32 first, Int32 count, Pointer<Uint32> samplers);
typedef GlBindSamplers = void Function(
    int first, int count, Pointer<Uint32> samplers);

typedef GlBindImageTexturesNative = Void Function(
    Uint32 first, Int32 count, Pointer<Uint32> textures);
typedef GlBindImageTextures = void Function(
    int first, int count, Pointer<Uint32> textures);

typedef GlBindVertexBuffersNative = Void Function(Uint32 first, Int32 count,
    Pointer<Uint32> buffers, Pointer<Int64> offsets, Pointer<Int32> strides);
typedef GlBindVertexBuffers = void Function(int first, int count,
    Pointer<Uint32> buffers, Pointer<Int64> offsets, Pointer<Int32> strides);

//GL_VERSION_4_5
typedef GlClipControlNative = Void Function(Uint32 origin, Uint32 depth);
typedef GlClipControl = void Function(int origin, int depth);

typedef GlCreateTransformFeedbacksNative = Void Function(
    Int32 n, Pointer<Uint32> ids);
typedef GlCreateTransformFeedbacks = void Function(int n, Pointer<Uint32> ids);

typedef GlTransformFeedbackBufferBaseNative = Void Function(
    Uint32 xfb, Uint32 index, Uint32 buffer);
typedef GlTransformFeedbackBufferBase = void Function(
    int xfb, int index, int buffer);

typedef GlTransformFeedbackBufferRangeNative = Void Function(
    Uint32 xfb, Uint32 index, Uint32 buffer, Int64 offset, Int64 size);
typedef GlTransformFeedbackBufferRange = void Function(
    int xfb, int index, int buffer, int offset, int size);

typedef GlGetTransformFeedbackivNative = Void Function(
    Uint32 xfb, Uint32 pname, Pointer<Int32> param);
typedef GlGetTransformFeedbackiv = void Function(
    int xfb, int pname, Pointer<Int32> param);

typedef GlGetTransformFeedbacki_vNative = Void Function(
    Uint32 xfb, Uint32 pname, Uint32 index, Pointer<Int32> param);
typedef GlGetTransformFeedbacki_v = void Function(
    int xfb, int pname, int index, Pointer<Int32> param);

typedef GlGetTransformFeedbacki64_vNative = Void Function(
    Uint32 xfb, Uint32 pname, Uint32 index, Pointer<Int64> param);
typedef GlGetTransformFeedbacki64_v = void Function(
    int xfb, int pname, int index, Pointer<Int64> param);

typedef GlCreateBuffersNative = Void Function(Int32 n, Pointer<Uint32> buffers);
typedef GlCreateBuffers = void Function(int n, Pointer<Uint32> buffers);

typedef GlNamedBufferStorageNative = Void Function(
    Uint32 buffer, Int64 size, Pointer data, Uint32 flags);
typedef GlNamedBufferStorage = void Function(
    int buffer, int size, Pointer data, int flags);

typedef GlNamedBufferDataNative = Void Function(
    Uint32 buffer, Int64 size, Pointer data, Uint32 usage);
typedef GlNamedBufferData = void Function(
    int buffer, int size, Pointer data, int usage);

typedef GlNamedBufferSubDataNative = Void Function(
    Uint32 buffer, Int64 offset, Int64 size, Pointer data);
typedef GlNamedBufferSubData = void Function(
    int buffer, int offset, int size, Pointer data);

typedef GlCopyNamedBufferSubDataNative = Void Function(Uint32 readBuffer,
    Uint32 writeBuffer, Int64 readOffset, Int64 writeOffset, Int64 size);
typedef GlCopyNamedBufferSubData = void Function(
    int readBuffer, int writeBuffer, int readOffset, int writeOffset, int size);

typedef GlClearNamedBufferDataNative = Void Function(Uint32 buffer,
    Uint32 internalformat, Uint32 format, Uint32 type, Pointer data);
typedef GlClearNamedBufferData = void Function(
    int buffer, int internalformat, int format, int type, Pointer data);

typedef GlClearNamedBufferSubDataNative = Void Function(
    Uint32 buffer,
    Uint32 internalformat,
    Int64 offset,
    Int64 size,
    Uint32 format,
    Uint32 type,
    Pointer data);
typedef GlClearNamedBufferSubData = void Function(
    int buffer,
    int internalformat,
    int offset,
    int size,
    int format,
    int type,
    Pointer data);

typedef GlMapNamedBufferNative = Pointer Function(Uint32 buffer, Uint32 access);
typedef GlMapNamedBuffer = Pointer Function(int buffer, int access);

typedef GlMapNamedBufferRangeNative = Pointer Function(
    Uint32 buffer, Int64 offset, Int64 length, Uint32 access);
typedef GlMapNamedBufferRange = Pointer Function(
    int buffer, int offset, int length, int access);

typedef GlUnmapNamedBufferNative = Uint8 Function(Uint32 buffer);
typedef GlUnmapNamedBuffer = int Function(int buffer);

typedef GlFlushMappedNamedBufferRangeNative = Void Function(
    Uint32 buffer, Int64 offset, Int64 length);
typedef GlFlushMappedNamedBufferRange = void Function(
    int buffer, int offset, int length);

typedef GlGetNamedBufferParameterivNative = Void Function(
    Uint32 buffer, Uint32 pname, Pointer<Int32> params);
typedef GlGetNamedBufferParameteriv = void Function(
    int buffer, int pname, Pointer<Int32> params);

typedef GlGetNamedBufferParameteri64vNative = Void Function(
    Uint32 buffer, Uint32 pname, Pointer<Int64> params);
typedef GlGetNamedBufferParameteri64v = void Function(
    int buffer, int pname, Pointer<Int64> params);

typedef GlGetNamedBufferPointervNative = Void Function(
    Uint32 buffer, Uint32 pname, Pointer params);
typedef GlGetNamedBufferPointerv = void Function(
    int buffer, int pname, Pointer params);

typedef GlGetNamedBufferSubDataNative = Void Function(
    Uint32 buffer, Int64 offset, Int64 size, Pointer data);
typedef GlGetNamedBufferSubData = void Function(
    int buffer, int offset, int size, Pointer data);

typedef GlCreateFramebuffersNative = Void Function(
    Int32 n, Pointer<Uint32> framebuffers);
typedef GlCreateFramebuffers = void Function(
    int n, Pointer<Uint32> framebuffers);

typedef GlNamedFramebufferRenderbufferNative = Void Function(Uint32 framebuffer,
    Uint32 attachment, Uint32 renderbuffertarget, Uint32 renderbuffer);
typedef GlNamedFramebufferRenderbuffer = void Function(
    int framebuffer, int attachment, int renderbuffertarget, int renderbuffer);

typedef GlNamedFramebufferParameteriNative = Void Function(
    Uint32 framebuffer, Uint32 pname, Int32 param);
typedef GlNamedFramebufferParameteri = void Function(
    int framebuffer, int pname, int param);

typedef GlNamedFramebufferTextureNative = Void Function(
    Uint32 framebuffer, Uint32 attachment, Uint32 texture, Int32 level);
typedef GlNamedFramebufferTexture = void Function(
    int framebuffer, int attachment, int texture, int level);

typedef GlNamedFramebufferTextureLayerNative = Void Function(Uint32 framebuffer,
    Uint32 attachment, Uint32 texture, Int32 level, Int32 layer);
typedef GlNamedFramebufferTextureLayer = void Function(
    int framebuffer, int attachment, int texture, int level, int layer);

typedef GlNamedFramebufferDrawBufferNative = Void Function(
    Uint32 framebuffer, Uint32 buf);
typedef GlNamedFramebufferDrawBuffer = void Function(int framebuffer, int buf);

typedef GlNamedFramebufferDrawBuffersNative = Void Function(
    Uint32 framebuffer, Int32 n, Pointer<Uint32> bufs);
typedef GlNamedFramebufferDrawBuffers = void Function(
    int framebuffer, int n, Pointer<Uint32> bufs);

typedef GlNamedFramebufferReadBufferNative = Void Function(
    Uint32 framebuffer, Uint32 src);
typedef GlNamedFramebufferReadBuffer = void Function(int framebuffer, int src);

typedef GlInvalidateNamedFramebufferDataNative = Void Function(
    Uint32 framebuffer, Int32 numAttachments, Pointer<Uint32> attachments);
typedef GlInvalidateNamedFramebufferData = void Function(
    int framebuffer, int numAttachments, Pointer<Uint32> attachments);

typedef GlInvalidateNamedFramebufferSubDataNative = Void Function(
    Uint32 framebuffer,
    Int32 numAttachments,
    Pointer<Uint32> attachments,
    Int32 x,
    Int32 y,
    Int32 width,
    Int32 height);
typedef GlInvalidateNamedFramebufferSubData = void Function(
    int framebuffer,
    int numAttachments,
    Pointer<Uint32> attachments,
    int x,
    int y,
    int width,
    int height);

typedef GlClearNamedFramebufferivNative = Void Function(
    Uint32 framebuffer, Uint32 buffer, Int32 drawbuffer, Pointer<Int32> value);
typedef GlClearNamedFramebufferiv = void Function(
    int framebuffer, int buffer, int drawbuffer, Pointer<Int32> value);

typedef GlClearNamedFramebufferuivNative = Void Function(
    Uint32 framebuffer, Uint32 buffer, Int32 drawbuffer, Pointer<Uint32> value);
typedef GlClearNamedFramebufferuiv = void Function(
    int framebuffer, int buffer, int drawbuffer, Pointer<Uint32> value);

typedef GlClearNamedFramebufferfvNative = Void Function(
    Uint32 framebuffer, Uint32 buffer, Int32 drawbuffer, Pointer<Float> value);
typedef GlClearNamedFramebufferfv = void Function(
    int framebuffer, int buffer, int drawbuffer, Pointer<Float> value);

typedef GlClearNamedFramebufferfiNative = Void Function(Uint32 framebuffer,
    Uint32 buffer, Int32 drawbuffer, Float depth, Int32 stencil);
typedef GlClearNamedFramebufferfi = void Function(
    int framebuffer, int buffer, int drawbuffer, double depth, int stencil);

typedef GlBlitNamedFramebufferNative = Void Function(
    Uint32 readFramebuffer,
    Uint32 drawFramebuffer,
    Int32 srcX0,
    Int32 srcY0,
    Int32 srcX1,
    Int32 srcY1,
    Int32 dstX0,
    Int32 dstY0,
    Int32 dstX1,
    Int32 dstY1,
    Uint32 mask,
    Uint32 filter);
typedef GlBlitNamedFramebuffer = void Function(
    int readFramebuffer,
    int drawFramebuffer,
    int srcX0,
    int srcY0,
    int srcX1,
    int srcY1,
    int dstX0,
    int dstY0,
    int dstX1,
    int dstY1,
    int mask,
    int filter);

typedef GlCheckNamedFramebufferStatusNative = Uint32 Function(
    Uint32 framebuffer, Uint32 target);
typedef GlCheckNamedFramebufferStatus = int Function(
    int framebuffer, int target);

typedef GlGetNamedFramebufferParameterivNative = Void Function(
    Uint32 framebuffer, Uint32 pname, Pointer<Int32> param);
typedef GlGetNamedFramebufferParameteriv = void Function(
    int framebuffer, int pname, Pointer<Int32> param);

typedef GlGetNamedFramebufferAttachmentParameterivNative = Void Function(
    Uint32 framebuffer, Uint32 attachment, Uint32 pname, Pointer<Int32> params);
typedef GlGetNamedFramebufferAttachmentParameteriv = void Function(
    int framebuffer, int attachment, int pname, Pointer<Int32> params);

typedef GlCreateRenderbuffersNative = Void Function(
    Int32 n, Pointer<Uint32> renderbuffers);
typedef GlCreateRenderbuffers = void Function(
    int n, Pointer<Uint32> renderbuffers);

typedef GlNamedRenderbufferStorageNative = Void Function(
    Uint32 renderbuffer, Uint32 internalformat, Int32 width, Int32 height);
typedef GlNamedRenderbufferStorage = void Function(
    int renderbuffer, int internalformat, int width, int height);

typedef GlNamedRenderbufferStorageMultisampleNative = Void Function(
    Uint32 renderbuffer,
    Int32 samples,
    Uint32 internalformat,
    Int32 width,
    Int32 height);
typedef GlNamedRenderbufferStorageMultisample = void Function(
    int renderbuffer, int samples, int internalformat, int width, int height);

typedef GlGetNamedRenderbufferParameterivNative = Void Function(
    Uint32 renderbuffer, Uint32 pname, Pointer<Int32> params);
typedef GlGetNamedRenderbufferParameteriv = void Function(
    int renderbuffer, int pname, Pointer<Int32> params);

typedef GlCreateTexturesNative = Void Function(
    Uint32 target, Int32 n, Pointer<Uint32> textures);
typedef GlCreateTextures = void Function(
    int target, int n, Pointer<Uint32> textures);

typedef GlTextureBufferNative = Void Function(
    Uint32 texture, Uint32 internalformat, Uint32 buffer);
typedef GlTextureBuffer = void Function(
    int texture, int internalformat, int buffer);

typedef GlTextureBufferRangeNative = Void Function(Uint32 texture,
    Uint32 internalformat, Uint32 buffer, Int64 offset, Int64 size);
typedef GlTextureBufferRange = void Function(
    int texture, int internalformat, int buffer, int offset, int size);

typedef GlTextureStorage1DNative = Void Function(
    Uint32 texture, Int32 levels, Uint32 internalformat, Int32 width);
typedef GlTextureStorage1D = void Function(
    int texture, int levels, int internalformat, int width);

typedef GlTextureStorage2DNative = Void Function(Uint32 texture, Int32 levels,
    Uint32 internalformat, Int32 width, Int32 height);
typedef GlTextureStorage2D = void Function(
    int texture, int levels, int internalformat, int width, int height);

typedef GlTextureStorage3DNative = Void Function(Uint32 texture, Int32 levels,
    Uint32 internalformat, Int32 width, Int32 height, Int32 depth);
typedef GlTextureStorage3D = void Function(int texture, int levels,
    int internalformat, int width, int height, int depth);

typedef GlTextureStorage2DMultisampleNative = Void Function(
    Uint32 texture,
    Int32 samples,
    Uint32 internalformat,
    Int32 width,
    Int32 height,
    Uint8 fixedsamplelocations);
typedef GlTextureStorage2DMultisample = void Function(int texture, int samples,
    int internalformat, int width, int height, int fixedsamplelocations);

typedef GlTextureStorage3DMultisampleNative = Void Function(
    Uint32 texture,
    Int32 samples,
    Uint32 internalformat,
    Int32 width,
    Int32 height,
    Int32 depth,
    Uint8 fixedsamplelocations);
typedef GlTextureStorage3DMultisample = void Function(
    int texture,
    int samples,
    int internalformat,
    int width,
    int height,
    int depth,
    int fixedsamplelocations);

typedef GlTextureSubImage1DNative = Void Function(Uint32 texture, Int32 level,
    Int32 xoffset, Int32 width, Uint32 format, Uint32 type, Pointer pixels);
typedef GlTextureSubImage1D = void Function(int texture, int level, int xoffset,
    int width, int format, int type, Pointer pixels);

typedef GlTextureSubImage2DNative = Void Function(
    Uint32 texture,
    Int32 level,
    Int32 xoffset,
    Int32 yoffset,
    Int32 width,
    Int32 height,
    Uint32 format,
    Uint32 type,
    Pointer pixels);
typedef GlTextureSubImage2D = void Function(int texture, int level, int xoffset,
    int yoffset, int width, int height, int format, int type, Pointer pixels);

typedef GlTextureSubImage3DNative = Void Function(
    Uint32 texture,
    Int32 level,
    Int32 xoffset,
    Int32 yoffset,
    Int32 zoffset,
    Int32 width,
    Int32 height,
    Int32 depth,
    Uint32 format,
    Uint32 type,
    Pointer pixels);
typedef GlTextureSubImage3D = void Function(
    int texture,
    int level,
    int xoffset,
    int yoffset,
    int zoffset,
    int width,
    int height,
    int depth,
    int format,
    int type,
    Pointer pixels);

typedef GlCompressedTextureSubImage1DNative = Void Function(
    Uint32 texture,
    Int32 level,
    Int32 xoffset,
    Int32 width,
    Uint32 format,
    Int32 imageSize,
    Pointer data);
typedef GlCompressedTextureSubImage1D = void Function(int texture, int level,
    int xoffset, int width, int format, int imageSize, Pointer data);

typedef GlCompressedTextureSubImage2DNative = Void Function(
    Uint32 texture,
    Int32 level,
    Int32 xoffset,
    Int32 yoffset,
    Int32 width,
    Int32 height,
    Uint32 format,
    Int32 imageSize,
    Pointer data);
typedef GlCompressedTextureSubImage2D = void Function(
    int texture,
    int level,
    int xoffset,
    int yoffset,
    int width,
    int height,
    int format,
    int imageSize,
    Pointer data);

typedef GlCompressedTextureSubImage3DNative = Void Function(
    Uint32 texture,
    Int32 level,
    Int32 xoffset,
    Int32 yoffset,
    Int32 zoffset,
    Int32 width,
    Int32 height,
    Int32 depth,
    Uint32 format,
    Int32 imageSize,
    Pointer data);
typedef GlCompressedTextureSubImage3D = void Function(
    int texture,
    int level,
    int xoffset,
    int yoffset,
    int zoffset,
    int width,
    int height,
    int depth,
    int format,
    int imageSize,
    Pointer data);

typedef GlCopyTextureSubImage1DNative = Void Function(
    Uint32 texture, Int32 level, Int32 xoffset, Int32 x, Int32 y, Int32 width);
typedef GlCopyTextureSubImage1D = void Function(
    int texture, int level, int xoffset, int x, int y, int width);

typedef GlCopyTextureSubImage2DNative = Void Function(
    Uint32 texture,
    Int32 level,
    Int32 xoffset,
    Int32 yoffset,
    Int32 x,
    Int32 y,
    Int32 width,
    Int32 height);
typedef GlCopyTextureSubImage2D = void Function(int texture, int level,
    int xoffset, int yoffset, int x, int y, int width, int height);

typedef GlCopyTextureSubImage3DNative = Void Function(
    Uint32 texture,
    Int32 level,
    Int32 xoffset,
    Int32 yoffset,
    Int32 zoffset,
    Int32 x,
    Int32 y,
    Int32 width,
    Int32 height);
typedef GlCopyTextureSubImage3D = void Function(int texture, int level,
    int xoffset, int yoffset, int zoffset, int x, int y, int width, int height);

typedef GlTextureParameterfNative = Void Function(
    Uint32 texture, Uint32 pname, Float param);
typedef GlTextureParameterf = void Function(
    int texture, int pname, double param);

typedef GlTextureParameterfvNative = Void Function(
    Uint32 texture, Uint32 pname, Pointer<Float> param);
typedef GlTextureParameterfv = void Function(
    int texture, int pname, Pointer<Float> param);

typedef GlTextureParameteriNative = Void Function(
    Uint32 texture, Uint32 pname, Int32 param);
typedef GlTextureParameteri = void Function(int texture, int pname, int param);

typedef GlTextureParameterIivNative = Void Function(
    Uint32 texture, Uint32 pname, Pointer<Int32> params);
typedef GlTextureParameterIiv = void Function(
    int texture, int pname, Pointer<Int32> params);

typedef GlTextureParameterIuivNative = Void Function(
    Uint32 texture, Uint32 pname, Pointer<Uint32> params);
typedef GlTextureParameterIuiv = void Function(
    int texture, int pname, Pointer<Uint32> params);

typedef GlTextureParameterivNative = Void Function(
    Uint32 texture, Uint32 pname, Pointer<Int32> param);
typedef GlTextureParameteriv = void Function(
    int texture, int pname, Pointer<Int32> param);

typedef GlGenerateTextureMipmapNative = Void Function(Uint32 texture);
typedef GlGenerateTextureMipmap = void Function(int texture);

typedef GlBindTextureUnitNative = Void Function(Uint32 unit, Uint32 texture);
typedef GlBindTextureUnit = void Function(int unit, int texture);

typedef GlGetTextureImageNative = Void Function(Uint32 texture, Int32 level,
    Uint32 format, Uint32 type, Int32 bufSize, Pointer pixels);
typedef GlGetTextureImage = void Function(
    int texture, int level, int format, int type, int bufSize, Pointer pixels);

typedef GlGetCompressedTextureImageNative = Void Function(
    Uint32 texture, Int32 level, Int32 bufSize, Pointer pixels);
typedef GlGetCompressedTextureImage = void Function(
    int texture, int level, int bufSize, Pointer pixels);

typedef GlGetTextureLevelParameterfvNative = Void Function(
    Uint32 texture, Int32 level, Uint32 pname, Pointer<Float> params);
typedef GlGetTextureLevelParameterfv = void Function(
    int texture, int level, int pname, Pointer<Float> params);

typedef GlGetTextureLevelParameterivNative = Void Function(
    Uint32 texture, Int32 level, Uint32 pname, Pointer<Int32> params);
typedef GlGetTextureLevelParameteriv = void Function(
    int texture, int level, int pname, Pointer<Int32> params);

typedef GlGetTextureParameterfvNative = Void Function(
    Uint32 texture, Uint32 pname, Pointer<Float> params);
typedef GlGetTextureParameterfv = void Function(
    int texture, int pname, Pointer<Float> params);

typedef GlGetTextureParameterIivNative = Void Function(
    Uint32 texture, Uint32 pname, Pointer<Int32> params);
typedef GlGetTextureParameterIiv = void Function(
    int texture, int pname, Pointer<Int32> params);

typedef GlGetTextureParameterIuivNative = Void Function(
    Uint32 texture, Uint32 pname, Pointer<Uint32> params);
typedef GlGetTextureParameterIuiv = void Function(
    int texture, int pname, Pointer<Uint32> params);

typedef GlGetTextureParameterivNative = Void Function(
    Uint32 texture, Uint32 pname, Pointer<Int32> params);
typedef GlGetTextureParameteriv = void Function(
    int texture, int pname, Pointer<Int32> params);

typedef GlCreateVertexArraysNative = Void Function(
    Int32 n, Pointer<Uint32> arrays);
typedef GlCreateVertexArrays = void Function(int n, Pointer<Uint32> arrays);

typedef GlDisableVertexArrayAttribNative = Void Function(
    Uint32 vaobj, Uint32 index);
typedef GlDisableVertexArrayAttrib = void Function(int vaobj, int index);

typedef GlEnableVertexArrayAttribNative = Void Function(
    Uint32 vaobj, Uint32 index);
typedef GlEnableVertexArrayAttrib = void Function(int vaobj, int index);

typedef GlVertexArrayElementBufferNative = Void Function(
    Uint32 vaobj, Uint32 buffer);
typedef GlVertexArrayElementBuffer = void Function(int vaobj, int buffer);

typedef GlVertexArrayVertexBufferNative = Void Function(Uint32 vaobj,
    Uint32 bindingindex, Uint32 buffer, Int64 offset, Int32 stride);
typedef GlVertexArrayVertexBuffer = void Function(
    int vaobj, int bindingindex, int buffer, int offset, int stride);

typedef GlVertexArrayVertexBuffersNative = Void Function(
    Uint32 vaobj,
    Uint32 first,
    Int32 count,
    Pointer<Uint32> buffers,
    Pointer<Int64> offsets,
    Pointer<Int32> strides);
typedef GlVertexArrayVertexBuffers = void Function(
    int vaobj,
    int first,
    int count,
    Pointer<Uint32> buffers,
    Pointer<Int64> offsets,
    Pointer<Int32> strides);

typedef GlVertexArrayAttribBindingNative = Void Function(
    Uint32 vaobj, Uint32 attribindex, Uint32 bindingindex);
typedef GlVertexArrayAttribBinding = void Function(
    int vaobj, int attribindex, int bindingindex);

typedef GlVertexArrayAttribFormatNative = Void Function(
    Uint32 vaobj,
    Uint32 attribindex,
    Int32 size,
    Uint32 type,
    Uint8 normalized,
    Uint32 relativeoffset);
typedef GlVertexArrayAttribFormat = void Function(int vaobj, int attribindex,
    int size, int type, int normalized, int relativeoffset);

typedef GlVertexArrayAttribIFormatNative = Void Function(Uint32 vaobj,
    Uint32 attribindex, Int32 size, Uint32 type, Uint32 relativeoffset);
typedef GlVertexArrayAttribIFormat = void Function(
    int vaobj, int attribindex, int size, int type, int relativeoffset);

typedef GlVertexArrayAttribLFormatNative = Void Function(Uint32 vaobj,
    Uint32 attribindex, Int32 size, Uint32 type, Uint32 relativeoffset);
typedef GlVertexArrayAttribLFormat = void Function(
    int vaobj, int attribindex, int size, int type, int relativeoffset);

typedef GlVertexArrayBindingDivisorNative = Void Function(
    Uint32 vaobj, Uint32 bindingindex, Uint32 divisor);
typedef GlVertexArrayBindingDivisor = void Function(
    int vaobj, int bindingindex, int divisor);

typedef GlGetVertexArrayivNative = Void Function(
    Uint32 vaobj, Uint32 pname, Pointer<Int32> param);
typedef GlGetVertexArrayiv = void Function(
    int vaobj, int pname, Pointer<Int32> param);

typedef GlGetVertexArrayIndexedivNative = Void Function(
    Uint32 vaobj, Uint32 index, Uint32 pname, Pointer<Int32> param);
typedef GlGetVertexArrayIndexediv = void Function(
    int vaobj, int index, int pname, Pointer<Int32> param);

typedef GlGetVertexArrayIndexed64ivNative = Void Function(
    Uint32 vaobj, Uint32 index, Uint32 pname, Pointer<Int64> param);
typedef GlGetVertexArrayIndexed64iv = void Function(
    int vaobj, int index, int pname, Pointer<Int64> param);

typedef GlCreateSamplersNative = Void Function(
    Int32 n, Pointer<Uint32> samplers);
typedef GlCreateSamplers = void Function(int n, Pointer<Uint32> samplers);

typedef GlCreateProgramPipelinesNative = Void Function(
    Int32 n, Pointer<Uint32> pipelines);
typedef GlCreateProgramPipelines = void Function(
    int n, Pointer<Uint32> pipelines);

typedef GlCreateQueriesNative = Void Function(
    Uint32 target, Int32 n, Pointer<Uint32> ids);
typedef GlCreateQueries = void Function(int target, int n, Pointer<Uint32> ids);

typedef GlGetQueryBufferObjecti64vNative = Void Function(
    Uint32 id, Uint32 buffer, Uint32 pname, Int64 offset);
typedef GlGetQueryBufferObjecti64v = void Function(
    int id, int buffer, int pname, int offset);

typedef GlGetQueryBufferObjectivNative = Void Function(
    Uint32 id, Uint32 buffer, Uint32 pname, Int64 offset);
typedef GlGetQueryBufferObjectiv = void Function(
    int id, int buffer, int pname, int offset);

typedef GlGetQueryBufferObjectui64vNative = Void Function(
    Uint32 id, Uint32 buffer, Uint32 pname, Int64 offset);
typedef GlGetQueryBufferObjectui64v = void Function(
    int id, int buffer, int pname, int offset);

typedef GlGetQueryBufferObjectuivNative = Void Function(
    Uint32 id, Uint32 buffer, Uint32 pname, Int64 offset);
typedef GlGetQueryBufferObjectuiv = void Function(
    int id, int buffer, int pname, int offset);

typedef GlMemoryBarrierByRegionNative = Void Function(Uint32 barriers);
typedef GlMemoryBarrierByRegion = void Function(int barriers);

typedef GlGetTextureSubImageNative = Void Function(
    Uint32 texture,
    Int32 level,
    Int32 xoffset,
    Int32 yoffset,
    Int32 zoffset,
    Int32 width,
    Int32 height,
    Int32 depth,
    Uint32 format,
    Uint32 type,
    Int32 bufSize,
    Pointer pixels);
typedef GlGetTextureSubImage = void Function(
    int texture,
    int level,
    int xoffset,
    int yoffset,
    int zoffset,
    int width,
    int height,
    int depth,
    int format,
    int type,
    int bufSize,
    Pointer pixels);

typedef GlGetCompressedTextureSubImageNative = Void Function(
    Uint32 texture,
    Int32 level,
    Int32 xoffset,
    Int32 yoffset,
    Int32 zoffset,
    Int32 width,
    Int32 height,
    Int32 depth,
    Int32 bufSize,
    Pointer pixels);
typedef GlGetCompressedTextureSubImage = void Function(
    int texture,
    int level,
    int xoffset,
    int yoffset,
    int zoffset,
    int width,
    int height,
    int depth,
    int bufSize,
    Pointer pixels);

typedef GlGetGraphicsResetStatusNative = Uint32 Function();
typedef GlGetGraphicsResetStatus = int Function();

typedef GlGetnCompressedTexImageNative = Void Function(
    Uint32 target, Int32 lod, Int32 bufSize, Pointer pixels);
typedef GlGetnCompressedTexImage = void Function(
    int target, int lod, int bufSize, Pointer pixels);

typedef GlGetnTexImageNative = Void Function(Uint32 target, Int32 level,
    Uint32 format, Uint32 type, Int32 bufSize, Pointer pixels);
typedef GlGetnTexImage = void Function(
    int target, int level, int format, int type, int bufSize, Pointer pixels);

typedef GlGetnUniformdvNative = Void Function(
    Uint32 program, Int32 location, Int32 bufSize, Pointer<Double> params);
typedef GlGetnUniformdv = void Function(
    int program, int location, int bufSize, Pointer<Double> params);

typedef GlGetnUniformfvNative = Void Function(
    Uint32 program, Int32 location, Int32 bufSize, Pointer<Float> params);
typedef GlGetnUniformfv = void Function(
    int program, int location, int bufSize, Pointer<Float> params);

typedef GlGetnUniformivNative = Void Function(
    Uint32 program, Int32 location, Int32 bufSize, Pointer<Int32> params);
typedef GlGetnUniformiv = void Function(
    int program, int location, int bufSize, Pointer<Int32> params);

typedef GlGetnUniformuivNative = Void Function(
    Uint32 program, Int32 location, Int32 bufSize, Pointer<Uint32> params);
typedef GlGetnUniformuiv = void Function(
    int program, int location, int bufSize, Pointer<Uint32> params);

typedef GlReadnPixelsNative = Void Function(Int32 x, Int32 y, Int32 width,
    Int32 height, Uint32 format, Uint32 type, Int32 bufSize, Pointer data);
typedef GlReadnPixels = void Function(int x, int y, int width, int height,
    int format, int type, int bufSize, Pointer data);

typedef GlTextureBarrierNative = Void Function();
typedef GlTextureBarrier = void Function();

//GL_VERSION_4_6
typedef GlSpecializeShaderNative = Void Function(
    Uint32 shader,
    Pointer pEntryPoint,
    Uint32 numSpecializationConstants,
    Pointer<Uint32> pConstantIndex,
    Pointer<Uint32> pConstantValue);
typedef GlSpecializeShader = void Function(
    int shader,
    /*String*/ Pointer pEntryPoint,
    int numSpecializationConstants,
    Pointer<Uint32> pConstantIndex,
    Pointer<Uint32> pConstantValue);

typedef GlMultiDrawArraysIndirectCountNative = Void Function(Uint32 mode,
    Pointer indirect, Int64 drawcount, Int32 maxdrawcount, Int32 stride);
typedef GlMultiDrawArraysIndirectCount = void Function(
    int mode, Pointer indirect, int drawcount, int maxdrawcount, int stride);

typedef GlMultiDrawElementsIndirectCountNative = Void Function(
    Uint32 mode,
    Uint32 type,
    Pointer indirect,
    Int64 drawcount,
    Int32 maxdrawcount,
    Int32 stride);
typedef GlMultiDrawElementsIndirectCount = void Function(int mode, int type,
    Pointer indirect, int drawcount, int maxdrawcount, int stride);

typedef GlPolygonOffsetClampNative = Void Function(
    Float factor, Float units, Float clamp);
typedef GlPolygonOffsetClamp = void Function(
    double factor, double units, double clamp);

//GL_ARB_ES3_2_compatibility
typedef GlPrimitiveBoundingBoxARBNative = Void Function(Float minX, Float minY,
    Float minZ, Float minW, Float maxX, Float maxY, Float maxZ, Float maxW);
typedef GlPrimitiveBoundingBoxARB = void Function(
    double minX,
    double minY,
    double minZ,
    double minW,
    double maxX,
    double maxY,
    double maxZ,
    double maxW);

//GL_ARB_bindless_texture
typedef GlGetTextureHandleARBNative = Uint64 Function(Uint32 texture);
typedef GlGetTextureHandleARB = int Function(int texture);

typedef GlGetTextureSamplerHandleARBNative = Uint64 Function(
    Uint32 texture, Uint32 sampler);
typedef GlGetTextureSamplerHandleARB = int Function(int texture, int sampler);

typedef GlMakeTextureHandleResidentARBNative = Void Function(Uint64 handle);
typedef GlMakeTextureHandleResidentARB = void Function(int handle);

typedef GlMakeTextureHandleNonResidentARBNative = Void Function(Uint64 handle);
typedef GlMakeTextureHandleNonResidentARB = void Function(int handle);

typedef GlGetImageHandleARBNative = Uint64 Function(
    Uint32 texture, Int32 level, Uint8 layered, Int32 layer, Uint32 format);
typedef GlGetImageHandleARB = int Function(
    int texture, int level, int layered, int layer, int format);

typedef GlMakeImageHandleResidentARBNative = Void Function(
    Uint64 handle, Uint32 access);
typedef GlMakeImageHandleResidentARB = void Function(int handle, int access);

typedef GlMakeImageHandleNonResidentARBNative = Void Function(Uint64 handle);
typedef GlMakeImageHandleNonResidentARB = void Function(int handle);

typedef GlUniformHandleui64ARBNative = Void Function(
    Int32 location, Uint64 value);
typedef GlUniformHandleui64ARB = void Function(int location, int value);

typedef GlUniformHandleui64vARBNative = Void Function(
    Int32 location, Int32 count, Pointer<Uint64> value);
typedef GlUniformHandleui64vARB = void Function(
    int location, int count, Pointer<Uint64> value);

typedef GlProgramUniformHandleui64ARBNative = Void Function(
    Uint32 program, Int32 location, Uint64 value);
typedef GlProgramUniformHandleui64ARB = void Function(
    int program, int location, int value);

typedef GlProgramUniformHandleui64vARBNative = Void Function(
    Uint32 program, Int32 location, Int32 count, Pointer<Uint64> values);
typedef GlProgramUniformHandleui64vARB = void Function(
    int program, int location, int count, Pointer<Uint64> values);

typedef GlIsTextureHandleResidentARBNative = Uint8 Function(Uint64 handle);
typedef GlIsTextureHandleResidentARB = int Function(int handle);

typedef GlIsImageHandleResidentARBNative = Uint8 Function(Uint64 handle);
typedef GlIsImageHandleResidentARB = int Function(int handle);

typedef GlVertexAttribL1ui64ARBNative = Void Function(Uint32 index, Uint64 x);
typedef GlVertexAttribL1ui64ARB = void Function(int index, int x);

typedef GlVertexAttribL1ui64vARBNative = Void Function(
    Uint32 index, Pointer<Uint64> v);
typedef GlVertexAttribL1ui64vARB = void Function(int index, Pointer<Uint64> v);

typedef GlGetVertexAttribLui64vARBNative = Void Function(
    Uint32 index, Uint32 pname, Pointer<Uint64> params);
typedef GlGetVertexAttribLui64vARB = void Function(
    int index, int pname, Pointer<Uint64> params);

//GL_ARB_cl_event
typedef GlCreateSyncFromCLeventARBNative = Pointer Function(
    Pointer context, Pointer event, Uint32 flags);
typedef GlCreateSyncFromCLeventARB = Pointer Function(
    Pointer context, Pointer event, int flags);

//GL_ARB_compute_variable_group_size
typedef GlDispatchComputeGroupSizeARBNative = Void Function(
    Uint32 num_groups_x,
    Uint32 num_groups_y,
    Uint32 num_groups_z,
    Uint32 group_size_x,
    Uint32 group_size_y,
    Uint32 group_size_z);
typedef GlDispatchComputeGroupSizeARB = void Function(
    int num_groups_x,
    int num_groups_y,
    int num_groups_z,
    int group_size_x,
    int group_size_y,
    int group_size_z);

//GL_ARB_debug_output
typedef GlDebugMessageControlARBNative = Void Function(
    Uint32 source,
    Uint32 type,
    Uint32 severity,
    Int32 count,
    Pointer<Uint32> ids,
    Uint8 enabled);
typedef GlDebugMessageControlARB = void Function(int source, int type,
    int severity, int count, Pointer<Uint32> ids, int enabled);

typedef GlDebugMessageInsertARBNative = Void Function(Uint32 source,
    Uint32 type, Uint32 id, Uint32 severity, Int32 length, Pointer buf);
typedef GlDebugMessageInsertARB = void Function(int source, int type, int id,
    int severity, int length, /*String*/ Pointer buf);

typedef GlDebugMessageCallbackARBNative = Void Function(
    Pointer callback, Pointer userParam);
typedef GlDebugMessageCallbackARB = void Function(
    Pointer callback, Pointer userParam);

typedef GlGetDebugMessageLogARBNative = Uint32 Function(
    Uint32 count,
    Int32 bufSize,
    Pointer<Uint32> sources,
    Pointer<Uint32> types,
    Pointer<Uint32> ids,
    Pointer<Uint32> severities,
    Pointer<Int32> lengths,
    Pointer messageLog);
typedef GlGetDebugMessageLogARB = int Function(
    int count,
    int bufSize,
    Pointer<Uint32> sources,
    Pointer<Uint32> types,
    Pointer<Uint32> ids,
    Pointer<Uint32> severities,
    Pointer<Int32> lengths,
    Pointer messageLog);

//GL_ARB_draw_buffers_blend
typedef GlBlendEquationiARBNative = Void Function(Uint32 buf, Uint32 mode);
typedef GlBlendEquationiARB = void Function(int buf, int mode);

typedef GlBlendEquationSeparateiARBNative = Void Function(
    Uint32 buf, Uint32 modeRGB, Uint32 modeAlpha);
typedef GlBlendEquationSeparateiARB = void Function(
    int buf, int modeRGB, int modeAlpha);

typedef GlBlendFunciARBNative = Void Function(
    Uint32 buf, Uint32 src, Uint32 dst);
typedef GlBlendFunciARB = void Function(int buf, int src, int dst);

typedef GlBlendFuncSeparateiARBNative = Void Function(
    Uint32 buf, Uint32 srcRGB, Uint32 dstRGB, Uint32 srcAlpha, Uint32 dstAlpha);
typedef GlBlendFuncSeparateiARB = void Function(
    int buf, int srcRGB, int dstRGB, int srcAlpha, int dstAlpha);

//GL_ARB_draw_instanced
typedef GlDrawArraysInstancedARBNative = Void Function(
    Uint32 mode, Int32 first, Int32 count, Int32 primcount);
typedef GlDrawArraysInstancedARB = void Function(
    int mode, int first, int count, int primcount);

typedef GlDrawElementsInstancedARBNative = Void Function(
    Uint32 mode, Int32 count, Uint32 type, Pointer indices, Int32 primcount);
typedef GlDrawElementsInstancedARB = void Function(
    int mode, int count, int type, Pointer indices, int primcount);

//GL_ARB_geometry_shader4
typedef GlProgramParameteriARBNative = Void Function(
    Uint32 program, Uint32 pname, Int32 value);
typedef GlProgramParameteriARB = void Function(
    int program, int pname, int value);

typedef GlFramebufferTextureARBNative = Void Function(
    Uint32 target, Uint32 attachment, Uint32 texture, Int32 level);
typedef GlFramebufferTextureARB = void Function(
    int target, int attachment, int texture, int level);

typedef GlFramebufferTextureLayerARBNative = Void Function(
    Uint32 target, Uint32 attachment, Uint32 texture, Int32 level, Int32 layer);
typedef GlFramebufferTextureLayerARB = void Function(
    int target, int attachment, int texture, int level, int layer);

typedef GlFramebufferTextureFaceARBNative = Void Function(
    Uint32 target, Uint32 attachment, Uint32 texture, Int32 level, Uint32 face);
typedef GlFramebufferTextureFaceARB = void Function(
    int target, int attachment, int texture, int level, int face);

//GL_ARB_gl_spirv
typedef GlSpecializeShaderARBNative = Void Function(
    Uint32 shader,
    Pointer pEntryPoint,
    Uint32 numSpecializationConstants,
    Pointer<Uint32> pConstantIndex,
    Pointer<Uint32> pConstantValue);
typedef GlSpecializeShaderARB = void Function(
    int shader,
    /*String*/ Pointer pEntryPoint,
    int numSpecializationConstants,
    Pointer<Uint32> pConstantIndex,
    Pointer<Uint32> pConstantValue);

//GL_ARB_gpu_shader_int64
typedef GlUniform1i64ARBNative = Void Function(Int32 location, Int64 x);
typedef GlUniform1i64ARB = void Function(int location, int x);

typedef GlUniform2i64ARBNative = Void Function(
    Int32 location, Int64 x, Int64 y);
typedef GlUniform2i64ARB = void Function(int location, int x, int y);

typedef GlUniform3i64ARBNative = Void Function(
    Int32 location, Int64 x, Int64 y, Int64 z);
typedef GlUniform3i64ARB = void Function(int location, int x, int y, int z);

typedef GlUniform4i64ARBNative = Void Function(
    Int32 location, Int64 x, Int64 y, Int64 z, Int64 w);
typedef GlUniform4i64ARB = void Function(
    int location, int x, int y, int z, int w);

typedef GlUniform1i64vARBNative = Void Function(
    Int32 location, Int32 count, Pointer<Int64> value);
typedef GlUniform1i64vARB = void Function(
    int location, int count, Pointer<Int64> value);

typedef GlUniform2i64vARBNative = Void Function(
    Int32 location, Int32 count, Pointer<Int64> value);
typedef GlUniform2i64vARB = void Function(
    int location, int count, Pointer<Int64> value);

typedef GlUniform3i64vARBNative = Void Function(
    Int32 location, Int32 count, Pointer<Int64> value);
typedef GlUniform3i64vARB = void Function(
    int location, int count, Pointer<Int64> value);

typedef GlUniform4i64vARBNative = Void Function(
    Int32 location, Int32 count, Pointer<Int64> value);
typedef GlUniform4i64vARB = void Function(
    int location, int count, Pointer<Int64> value);

typedef GlUniform1ui64ARBNative = Void Function(Int32 location, Uint64 x);
typedef GlUniform1ui64ARB = void Function(int location, int x);

typedef GlUniform2ui64ARBNative = Void Function(
    Int32 location, Uint64 x, Uint64 y);
typedef GlUniform2ui64ARB = void Function(int location, int x, int y);

typedef GlUniform3ui64ARBNative = Void Function(
    Int32 location, Uint64 x, Uint64 y, Uint64 z);
typedef GlUniform3ui64ARB = void Function(int location, int x, int y, int z);

typedef GlUniform4ui64ARBNative = Void Function(
    Int32 location, Uint64 x, Uint64 y, Uint64 z, Uint64 w);
typedef GlUniform4ui64ARB = void Function(
    int location, int x, int y, int z, int w);

typedef GlUniform1ui64vARBNative = Void Function(
    Int32 location, Int32 count, Pointer<Uint64> value);
typedef GlUniform1ui64vARB = void Function(
    int location, int count, Pointer<Uint64> value);

typedef GlUniform2ui64vARBNative = Void Function(
    Int32 location, Int32 count, Pointer<Uint64> value);
typedef GlUniform2ui64vARB = void Function(
    int location, int count, Pointer<Uint64> value);

typedef GlUniform3ui64vARBNative = Void Function(
    Int32 location, Int32 count, Pointer<Uint64> value);
typedef GlUniform3ui64vARB = void Function(
    int location, int count, Pointer<Uint64> value);

typedef GlUniform4ui64vARBNative = Void Function(
    Int32 location, Int32 count, Pointer<Uint64> value);
typedef GlUniform4ui64vARB = void Function(
    int location, int count, Pointer<Uint64> value);

typedef GlGetUniformi64vARBNative = Void Function(
    Uint32 program, Int32 location, Pointer<Int64> params);
typedef GlGetUniformi64vARB = void Function(
    int program, int location, Pointer<Int64> params);

typedef GlGetUniformui64vARBNative = Void Function(
    Uint32 program, Int32 location, Pointer<Uint64> params);
typedef GlGetUniformui64vARB = void Function(
    int program, int location, Pointer<Uint64> params);

typedef GlGetnUniformi64vARBNative = Void Function(
    Uint32 program, Int32 location, Int32 bufSize, Pointer<Int64> params);
typedef GlGetnUniformi64vARB = void Function(
    int program, int location, int bufSize, Pointer<Int64> params);

typedef GlGetnUniformui64vARBNative = Void Function(
    Uint32 program, Int32 location, Int32 bufSize, Pointer<Uint64> params);
typedef GlGetnUniformui64vARB = void Function(
    int program, int location, int bufSize, Pointer<Uint64> params);

typedef GlProgramUniform1i64ARBNative = Void Function(
    Uint32 program, Int32 location, Int64 x);
typedef GlProgramUniform1i64ARB = void Function(
    int program, int location, int x);

typedef GlProgramUniform2i64ARBNative = Void Function(
    Uint32 program, Int32 location, Int64 x, Int64 y);
typedef GlProgramUniform2i64ARB = void Function(
    int program, int location, int x, int y);

typedef GlProgramUniform3i64ARBNative = Void Function(
    Uint32 program, Int32 location, Int64 x, Int64 y, Int64 z);
typedef GlProgramUniform3i64ARB = void Function(
    int program, int location, int x, int y, int z);

typedef GlProgramUniform4i64ARBNative = Void Function(
    Uint32 program, Int32 location, Int64 x, Int64 y, Int64 z, Int64 w);
typedef GlProgramUniform4i64ARB = void Function(
    int program, int location, int x, int y, int z, int w);

typedef GlProgramUniform1i64vARBNative = Void Function(
    Uint32 program, Int32 location, Int32 count, Pointer<Int64> value);
typedef GlProgramUniform1i64vARB = void Function(
    int program, int location, int count, Pointer<Int64> value);

typedef GlProgramUniform2i64vARBNative = Void Function(
    Uint32 program, Int32 location, Int32 count, Pointer<Int64> value);
typedef GlProgramUniform2i64vARB = void Function(
    int program, int location, int count, Pointer<Int64> value);

typedef GlProgramUniform3i64vARBNative = Void Function(
    Uint32 program, Int32 location, Int32 count, Pointer<Int64> value);
typedef GlProgramUniform3i64vARB = void Function(
    int program, int location, int count, Pointer<Int64> value);

typedef GlProgramUniform4i64vARBNative = Void Function(
    Uint32 program, Int32 location, Int32 count, Pointer<Int64> value);
typedef GlProgramUniform4i64vARB = void Function(
    int program, int location, int count, Pointer<Int64> value);

typedef GlProgramUniform1ui64ARBNative = Void Function(
    Uint32 program, Int32 location, Uint64 x);
typedef GlProgramUniform1ui64ARB = void Function(
    int program, int location, int x);

typedef GlProgramUniform2ui64ARBNative = Void Function(
    Uint32 program, Int32 location, Uint64 x, Uint64 y);
typedef GlProgramUniform2ui64ARB = void Function(
    int program, int location, int x, int y);

typedef GlProgramUniform3ui64ARBNative = Void Function(
    Uint32 program, Int32 location, Uint64 x, Uint64 y, Uint64 z);
typedef GlProgramUniform3ui64ARB = void Function(
    int program, int location, int x, int y, int z);

typedef GlProgramUniform4ui64ARBNative = Void Function(
    Uint32 program, Int32 location, Uint64 x, Uint64 y, Uint64 z, Uint64 w);
typedef GlProgramUniform4ui64ARB = void Function(
    int program, int location, int x, int y, int z, int w);

typedef GlProgramUniform1ui64vARBNative = Void Function(
    Uint32 program, Int32 location, Int32 count, Pointer<Uint64> value);
typedef GlProgramUniform1ui64vARB = void Function(
    int program, int location, int count, Pointer<Uint64> value);

typedef GlProgramUniform2ui64vARBNative = Void Function(
    Uint32 program, Int32 location, Int32 count, Pointer<Uint64> value);
typedef GlProgramUniform2ui64vARB = void Function(
    int program, int location, int count, Pointer<Uint64> value);

typedef GlProgramUniform3ui64vARBNative = Void Function(
    Uint32 program, Int32 location, Int32 count, Pointer<Uint64> value);
typedef GlProgramUniform3ui64vARB = void Function(
    int program, int location, int count, Pointer<Uint64> value);

typedef GlProgramUniform4ui64vARBNative = Void Function(
    Uint32 program, Int32 location, Int32 count, Pointer<Uint64> value);
typedef GlProgramUniform4ui64vARB = void Function(
    int program, int location, int count, Pointer<Uint64> value);

//GL_ARB_indirect_parameters
typedef GlMultiDrawArraysIndirectCountARBNative = Void Function(Uint32 mode,
    Pointer indirect, Int64 drawcount, Int32 maxdrawcount, Int32 stride);
typedef GlMultiDrawArraysIndirectCountARB = void Function(
    int mode, Pointer indirect, int drawcount, int maxdrawcount, int stride);

typedef GlMultiDrawElementsIndirectCountARBNative = Void Function(
    Uint32 mode,
    Uint32 type,
    Pointer indirect,
    Int64 drawcount,
    Int32 maxdrawcount,
    Int32 stride);
typedef GlMultiDrawElementsIndirectCountARB = void Function(int mode, int type,
    Pointer indirect, int drawcount, int maxdrawcount, int stride);

//GL_ARB_instanced_arrays
typedef GlVertexAttribDivisorARBNative = Void Function(
    Uint32 index, Uint32 divisor);
typedef GlVertexAttribDivisorARB = void Function(int index, int divisor);

//GL_ARB_parallel_shader_compile
typedef GlMaxShaderCompilerThreadsARBNative = Void Function(Uint32 count);
typedef GlMaxShaderCompilerThreadsARB = void Function(int count);

//GL_ARB_robustness
typedef GlGetGraphicsResetStatusARBNative = Uint32 Function();
typedef GlGetGraphicsResetStatusARB = int Function();

typedef GlGetnTexImageARBNative = Void Function(Uint32 target, Int32 level,
    Uint32 format, Uint32 type, Int32 bufSize, Pointer img);
typedef GlGetnTexImageARB = void Function(
    int target, int level, int format, int type, int bufSize, Pointer img);

typedef GlReadnPixelsARBNative = Void Function(Int32 x, Int32 y, Int32 width,
    Int32 height, Uint32 format, Uint32 type, Int32 bufSize, Pointer data);
typedef GlReadnPixelsARB = void Function(int x, int y, int width, int height,
    int format, int type, int bufSize, Pointer data);

typedef GlGetnCompressedTexImageARBNative = Void Function(
    Uint32 target, Int32 lod, Int32 bufSize, Pointer img);
typedef GlGetnCompressedTexImageARB = void Function(
    int target, int lod, int bufSize, Pointer img);

typedef GlGetnUniformfvARBNative = Void Function(
    Uint32 program, Int32 location, Int32 bufSize, Pointer<Float> params);
typedef GlGetnUniformfvARB = void Function(
    int program, int location, int bufSize, Pointer<Float> params);

typedef GlGetnUniformivARBNative = Void Function(
    Uint32 program, Int32 location, Int32 bufSize, Pointer<Int32> params);
typedef GlGetnUniformivARB = void Function(
    int program, int location, int bufSize, Pointer<Int32> params);

typedef GlGetnUniformuivARBNative = Void Function(
    Uint32 program, Int32 location, Int32 bufSize, Pointer<Uint32> params);
typedef GlGetnUniformuivARB = void Function(
    int program, int location, int bufSize, Pointer<Uint32> params);

typedef GlGetnUniformdvARBNative = Void Function(
    Uint32 program, Int32 location, Int32 bufSize, Pointer<Double> params);
typedef GlGetnUniformdvARB = void Function(
    int program, int location, int bufSize, Pointer<Double> params);

//GL_ARB_sample_locations
typedef GlFramebufferSampleLocationsfvARBNative = Void Function(
    Uint32 target, Uint32 start, Int32 count, Pointer<Float> v);
typedef GlFramebufferSampleLocationsfvARB = void Function(
    int target, int start, int count, Pointer<Float> v);

typedef GlNamedFramebufferSampleLocationsfvARBNative = Void Function(
    Uint32 framebuffer, Uint32 start, Int32 count, Pointer<Float> v);
typedef GlNamedFramebufferSampleLocationsfvARB = void Function(
    int framebuffer, int start, int count, Pointer<Float> v);

typedef GlEvaluateDepthValuesARBNative = Void Function();
typedef GlEvaluateDepthValuesARB = void Function();

//GL_ARB_sample_shading
typedef GlMinSampleShadingARBNative = Void Function(Float value);
typedef GlMinSampleShadingARB = void Function(double value);

//GL_ARB_shading_language_include
typedef GlNamedStringARBNative = Void Function(
    Uint32 type, Int32 namelen, Pointer name, Int32 stringlen, Pointer string);
typedef GlNamedStringARB = void Function(int type, int namelen,
    /*String*/ Pointer name, int stringlen, /*String*/ Pointer string);

typedef GlDeleteNamedStringARBNative = Void Function(
    Int32 namelen, Pointer name);
typedef GlDeleteNamedStringARB = void Function(
    int namelen, /*String*/ Pointer name);

typedef GlCompileShaderIncludeARBNative = Void Function(
    Uint32 shader, Int32 count, Pointer path, Pointer<Int32> length);
typedef GlCompileShaderIncludeARB = void Function(int shader, int count,
    /*List<String>*/ Pointer path, Pointer<Int32> length);

typedef GlIsNamedStringARBNative = Uint8 Function(Int32 namelen, Pointer name);
typedef GlIsNamedStringARB = int Function(int namelen, /*String*/ Pointer name);

typedef GlGetNamedStringARBNative = Void Function(Int32 namelen, Pointer name,
    Int32 bufSize, Pointer<Int32> stringlen, Pointer string);
typedef GlGetNamedStringARB = void Function(
    int namelen,
    /*String*/ Pointer name,
    int bufSize,
    Pointer<Int32> stringlen,
    Pointer string);

typedef GlGetNamedStringivARBNative = Void Function(
    Int32 namelen, Pointer name, Uint32 pname, Pointer<Int32> params);
typedef GlGetNamedStringivARB = void Function(
    int namelen, /*String*/ Pointer name, int pname, Pointer<Int32> params);

//GL_ARB_sparse_buffer
typedef GlBufferPageCommitmentARBNative = Void Function(
    Uint32 target, Int64 offset, Int64 size, Uint8 commit);
typedef GlBufferPageCommitmentARB = void Function(
    int target, int offset, int size, int commit);

typedef GlNamedBufferPageCommitmentEXTNative = Void Function(
    Uint32 buffer, Int64 offset, Int64 size, Uint8 commit);
typedef GlNamedBufferPageCommitmentEXT = void Function(
    int buffer, int offset, int size, int commit);

typedef GlNamedBufferPageCommitmentARBNative = Void Function(
    Uint32 buffer, Int64 offset, Int64 size, Uint8 commit);
typedef GlNamedBufferPageCommitmentARB = void Function(
    int buffer, int offset, int size, int commit);

//GL_ARB_sparse_texture
typedef GlTexPageCommitmentARBNative = Void Function(
    Uint32 target,
    Int32 level,
    Int32 xoffset,
    Int32 yoffset,
    Int32 zoffset,
    Int32 width,
    Int32 height,
    Int32 depth,
    Uint8 commit);
typedef GlTexPageCommitmentARB = void Function(
    int target,
    int level,
    int xoffset,
    int yoffset,
    int zoffset,
    int width,
    int height,
    int depth,
    int commit);

//GL_ARB_texture_buffer_object
typedef GlTexBufferARBNative = Void Function(
    Uint32 target, Uint32 internalformat, Uint32 buffer);
typedef GlTexBufferARB = void Function(
    int target, int internalformat, int buffer);

//GL_ARB_viewport_array
typedef GlDepthRangeArraydvNVNative = Void Function(
    Uint32 first, Int32 count, Pointer<Double> v);
typedef GlDepthRangeArraydvNV = void Function(
    int first, int count, Pointer<Double> v);

typedef GlDepthRangeIndexeddNVNative = Void Function(
    Uint32 index, Double n, Double f);
typedef GlDepthRangeIndexeddNV = void Function(int index, double n, double f);

//GL_KHR_blend_equation_advanced
typedef GlBlendBarrierKHRNative = Void Function();
typedef GlBlendBarrierKHR = void Function();

//GL_KHR_parallel_shader_compile
typedef GlMaxShaderCompilerThreadsKHRNative = Void Function(Uint32 count);
typedef GlMaxShaderCompilerThreadsKHR = void Function(int count);

//GL_AMD_framebuffer_multisample_advanced
typedef GlRenderbufferStorageMultisampleAdvancedAMDNative = Void Function(
    Uint32 target,
    Int32 samples,
    Int32 storageSamples,
    Uint32 internalformat,
    Int32 width,
    Int32 height);
typedef GlRenderbufferStorageMultisampleAdvancedAMD = void Function(int target,
    int samples, int storageSamples, int internalformat, int width, int height);

typedef GlNamedRenderbufferStorageMultisampleAdvancedAMDNative = Void Function(
    Uint32 renderbuffer,
    Int32 samples,
    Int32 storageSamples,
    Uint32 internalformat,
    Int32 width,
    Int32 height);
typedef GlNamedRenderbufferStorageMultisampleAdvancedAMD = void Function(
    int renderbuffer,
    int samples,
    int storageSamples,
    int internalformat,
    int width,
    int height);

//GL_AMD_performance_monitor
typedef GlGetPerfMonitorGroupsAMDNative = Void Function(
    Pointer<Int32> numGroups, Int32 groupsSize, Pointer<Uint32> groups);
typedef GlGetPerfMonitorGroupsAMD = void Function(
    Pointer<Int32> numGroups, int groupsSize, Pointer<Uint32> groups);

typedef GlGetPerfMonitorCountersAMDNative = Void Function(
    Uint32 group,
    Pointer<Int32> numCounters,
    Pointer<Int32> maxActiveCounters,
    Int32 counterSize,
    Pointer<Uint32> counters);
typedef GlGetPerfMonitorCountersAMD = void Function(
    int group,
    Pointer<Int32> numCounters,
    Pointer<Int32> maxActiveCounters,
    int counterSize,
    Pointer<Uint32> counters);

typedef GlGetPerfMonitorGroupStringAMDNative = Void Function(
    Uint32 group, Int32 bufSize, Pointer<Int32> length, Pointer groupString);
typedef GlGetPerfMonitorGroupStringAMD = void Function(
    int group, int bufSize, Pointer<Int32> length, Pointer groupString);

typedef GlGetPerfMonitorCounterStringAMDNative = Void Function(
    Uint32 group,
    Uint32 counter,
    Int32 bufSize,
    Pointer<Int32> length,
    Pointer counterString);
typedef GlGetPerfMonitorCounterStringAMD = void Function(int group, int counter,
    int bufSize, Pointer<Int32> length, Pointer counterString);

typedef GlGetPerfMonitorCounterInfoAMDNative = Void Function(
    Uint32 group, Uint32 counter, Uint32 pname, Pointer data);
typedef GlGetPerfMonitorCounterInfoAMD = void Function(
    int group, int counter, int pname, Pointer data);

typedef GlGenPerfMonitorsAMDNative = Void Function(
    Int32 n, Pointer<Uint32> monitors);
typedef GlGenPerfMonitorsAMD = void Function(int n, Pointer<Uint32> monitors);

typedef GlDeletePerfMonitorsAMDNative = Void Function(
    Int32 n, Pointer<Uint32> monitors);
typedef GlDeletePerfMonitorsAMD = void Function(
    int n, Pointer<Uint32> monitors);

typedef GlSelectPerfMonitorCountersAMDNative = Void Function(Uint32 monitor,
    Uint8 enable, Uint32 group, Int32 numCounters, Pointer<Uint32> counterList);
typedef GlSelectPerfMonitorCountersAMD = void Function(int monitor, int enable,
    int group, int numCounters, Pointer<Uint32> counterList);

typedef GlBeginPerfMonitorAMDNative = Void Function(Uint32 monitor);
typedef GlBeginPerfMonitorAMD = void Function(int monitor);

typedef GlEndPerfMonitorAMDNative = Void Function(Uint32 monitor);
typedef GlEndPerfMonitorAMD = void Function(int monitor);

typedef GlGetPerfMonitorCounterDataAMDNative = Void Function(
    Uint32 monitor,
    Uint32 pname,
    Int32 dataSize,
    Pointer<Uint32> data,
    Pointer<Int32> bytesWritten);
typedef GlGetPerfMonitorCounterDataAMD = void Function(int monitor, int pname,
    int dataSize, Pointer<Uint32> data, Pointer<Int32> bytesWritten);

//GL_EXT_EGL_image_storage
typedef GlEGLImageTargetTexStorageEXTNative = Void Function(
    Uint32 target, Pointer image, Pointer<Int32> attrib_list);
typedef GlEGLImageTargetTexStorageEXT = void Function(
    int target, Pointer image, Pointer<Int32> attrib_list);

typedef GlEGLImageTargetTextureStorageEXTNative = Void Function(
    Uint32 texture, Pointer image, Pointer<Int32> attrib_list);
typedef GlEGLImageTargetTextureStorageEXT = void Function(
    int texture, Pointer image, Pointer<Int32> attrib_list);

//GL_EXT_debug_label
typedef GlLabelObjectEXTNative = Void Function(
    Uint32 type, Uint32 object, Int32 length, Pointer label);
typedef GlLabelObjectEXT = void Function(
    int type, int object, int length, /*String*/ Pointer label);

typedef GlGetObjectLabelEXTNative = Void Function(Uint32 type, Uint32 object,
    Int32 bufSize, Pointer<Int32> length, Pointer label);
typedef GlGetObjectLabelEXT = void Function(
    int type, int object, int bufSize, Pointer<Int32> length, Pointer label);

//GL_EXT_debug_marker
typedef GlInsertEventMarkerEXTNative = Void Function(
    Int32 length, Pointer marker);
typedef GlInsertEventMarkerEXT = void Function(
    int length, /*String*/ Pointer marker);

typedef GlPushGroupMarkerEXTNative = Void Function(
    Int32 length, Pointer marker);
typedef GlPushGroupMarkerEXT = void Function(
    int length, /*String*/ Pointer marker);

typedef GlPopGroupMarkerEXTNative = Void Function();
typedef GlPopGroupMarkerEXT = void Function();

//GL_EXT_direct_state_access
typedef GlMatrixLoadfEXTNative = Void Function(Uint32 mode, Pointer<Float> m);
typedef GlMatrixLoadfEXT = void Function(int mode, Pointer<Float> m);

typedef GlMatrixLoaddEXTNative = Void Function(Uint32 mode, Pointer<Double> m);
typedef GlMatrixLoaddEXT = void Function(int mode, Pointer<Double> m);

typedef GlMatrixMultfEXTNative = Void Function(Uint32 mode, Pointer<Float> m);
typedef GlMatrixMultfEXT = void Function(int mode, Pointer<Float> m);

typedef GlMatrixMultdEXTNative = Void Function(Uint32 mode, Pointer<Double> m);
typedef GlMatrixMultdEXT = void Function(int mode, Pointer<Double> m);

typedef GlMatrixLoadIdentityEXTNative = Void Function(Uint32 mode);
typedef GlMatrixLoadIdentityEXT = void Function(int mode);

typedef GlMatrixRotatefEXTNative = Void Function(
    Uint32 mode, Float angle, Float x, Float y, Float z);
typedef GlMatrixRotatefEXT = void Function(
    int mode, double angle, double x, double y, double z);

typedef GlMatrixRotatedEXTNative = Void Function(
    Uint32 mode, Double angle, Double x, Double y, Double z);
typedef GlMatrixRotatedEXT = void Function(
    int mode, double angle, double x, double y, double z);

typedef GlMatrixScalefEXTNative = Void Function(
    Uint32 mode, Float x, Float y, Float z);
typedef GlMatrixScalefEXT = void Function(
    int mode, double x, double y, double z);

typedef GlMatrixScaledEXTNative = Void Function(
    Uint32 mode, Double x, Double y, Double z);
typedef GlMatrixScaledEXT = void Function(
    int mode, double x, double y, double z);

typedef GlMatrixTranslatefEXTNative = Void Function(
    Uint32 mode, Float x, Float y, Float z);
typedef GlMatrixTranslatefEXT = void Function(
    int mode, double x, double y, double z);

typedef GlMatrixTranslatedEXTNative = Void Function(
    Uint32 mode, Double x, Double y, Double z);
typedef GlMatrixTranslatedEXT = void Function(
    int mode, double x, double y, double z);

typedef GlMatrixFrustumEXTNative = Void Function(Uint32 mode, Double left,
    Double right, Double bottom, Double top, Double zNear, Double zFar);
typedef GlMatrixFrustumEXT = void Function(int mode, double left, double right,
    double bottom, double top, double zNear, double zFar);

typedef GlMatrixOrthoEXTNative = Void Function(Uint32 mode, Double left,
    Double right, Double bottom, Double top, Double zNear, Double zFar);
typedef GlMatrixOrthoEXT = void Function(int mode, double left, double right,
    double bottom, double top, double zNear, double zFar);

typedef GlMatrixPopEXTNative = Void Function(Uint32 mode);
typedef GlMatrixPopEXT = void Function(int mode);

typedef GlMatrixPushEXTNative = Void Function(Uint32 mode);
typedef GlMatrixPushEXT = void Function(int mode);

typedef GlClientAttribDefaultEXTNative = Void Function(Uint32 mask);
typedef GlClientAttribDefaultEXT = void Function(int mask);

typedef GlPushClientAttribDefaultEXTNative = Void Function(Uint32 mask);
typedef GlPushClientAttribDefaultEXT = void Function(int mask);

typedef GlTextureParameterfEXTNative = Void Function(
    Uint32 texture, Uint32 target, Uint32 pname, Float param);
typedef GlTextureParameterfEXT = void Function(
    int texture, int target, int pname, double param);

typedef GlTextureParameterfvEXTNative = Void Function(
    Uint32 texture, Uint32 target, Uint32 pname, Pointer<Float> params);
typedef GlTextureParameterfvEXT = void Function(
    int texture, int target, int pname, Pointer<Float> params);

typedef GlTextureParameteriEXTNative = Void Function(
    Uint32 texture, Uint32 target, Uint32 pname, Int32 param);
typedef GlTextureParameteriEXT = void Function(
    int texture, int target, int pname, int param);

typedef GlTextureParameterivEXTNative = Void Function(
    Uint32 texture, Uint32 target, Uint32 pname, Pointer<Int32> params);
typedef GlTextureParameterivEXT = void Function(
    int texture, int target, int pname, Pointer<Int32> params);

typedef GlTextureImage1DEXTNative = Void Function(
    Uint32 texture,
    Uint32 target,
    Int32 level,
    Int32 internalformat,
    Int32 width,
    Int32 border,
    Uint32 format,
    Uint32 type,
    Pointer pixels);
typedef GlTextureImage1DEXT = void Function(
    int texture,
    int target,
    int level,
    int internalformat,
    int width,
    int border,
    int format,
    int type,
    Pointer pixels);

typedef GlTextureImage2DEXTNative = Void Function(
    Uint32 texture,
    Uint32 target,
    Int32 level,
    Int32 internalformat,
    Int32 width,
    Int32 height,
    Int32 border,
    Uint32 format,
    Uint32 type,
    Pointer pixels);
typedef GlTextureImage2DEXT = void Function(
    int texture,
    int target,
    int level,
    int internalformat,
    int width,
    int height,
    int border,
    int format,
    int type,
    Pointer pixels);

typedef GlTextureSubImage1DEXTNative = Void Function(
    Uint32 texture,
    Uint32 target,
    Int32 level,
    Int32 xoffset,
    Int32 width,
    Uint32 format,
    Uint32 type,
    Pointer pixels);
typedef GlTextureSubImage1DEXT = void Function(int texture, int target,
    int level, int xoffset, int width, int format, int type, Pointer pixels);

typedef GlTextureSubImage2DEXTNative = Void Function(
    Uint32 texture,
    Uint32 target,
    Int32 level,
    Int32 xoffset,
    Int32 yoffset,
    Int32 width,
    Int32 height,
    Uint32 format,
    Uint32 type,
    Pointer pixels);
typedef GlTextureSubImage2DEXT = void Function(
    int texture,
    int target,
    int level,
    int xoffset,
    int yoffset,
    int width,
    int height,
    int format,
    int type,
    Pointer pixels);

typedef GlCopyTextureImage1DEXTNative = Void Function(
    Uint32 texture,
    Uint32 target,
    Int32 level,
    Uint32 internalformat,
    Int32 x,
    Int32 y,
    Int32 width,
    Int32 border);
typedef GlCopyTextureImage1DEXT = void Function(int texture, int target,
    int level, int internalformat, int x, int y, int width, int border);

typedef GlCopyTextureImage2DEXTNative = Void Function(
    Uint32 texture,
    Uint32 target,
    Int32 level,
    Uint32 internalformat,
    Int32 x,
    Int32 y,
    Int32 width,
    Int32 height,
    Int32 border);
typedef GlCopyTextureImage2DEXT = void Function(
    int texture,
    int target,
    int level,
    int internalformat,
    int x,
    int y,
    int width,
    int height,
    int border);

typedef GlCopyTextureSubImage1DEXTNative = Void Function(Uint32 texture,
    Uint32 target, Int32 level, Int32 xoffset, Int32 x, Int32 y, Int32 width);
typedef GlCopyTextureSubImage1DEXT = void Function(
    int texture, int target, int level, int xoffset, int x, int y, int width);

typedef GlCopyTextureSubImage2DEXTNative = Void Function(
    Uint32 texture,
    Uint32 target,
    Int32 level,
    Int32 xoffset,
    Int32 yoffset,
    Int32 x,
    Int32 y,
    Int32 width,
    Int32 height);
typedef GlCopyTextureSubImage2DEXT = void Function(int texture, int target,
    int level, int xoffset, int yoffset, int x, int y, int width, int height);

typedef GlGetTextureImageEXTNative = Void Function(Uint32 texture,
    Uint32 target, Int32 level, Uint32 format, Uint32 type, Pointer pixels);
typedef GlGetTextureImageEXT = void Function(
    int texture, int target, int level, int format, int type, Pointer pixels);

typedef GlGetTextureParameterfvEXTNative = Void Function(
    Uint32 texture, Uint32 target, Uint32 pname, Pointer<Float> params);
typedef GlGetTextureParameterfvEXT = void Function(
    int texture, int target, int pname, Pointer<Float> params);

typedef GlGetTextureParameterivEXTNative = Void Function(
    Uint32 texture, Uint32 target, Uint32 pname, Pointer<Int32> params);
typedef GlGetTextureParameterivEXT = void Function(
    int texture, int target, int pname, Pointer<Int32> params);

typedef GlGetTextureLevelParameterfvEXTNative = Void Function(Uint32 texture,
    Uint32 target, Int32 level, Uint32 pname, Pointer<Float> params);
typedef GlGetTextureLevelParameterfvEXT = void Function(
    int texture, int target, int level, int pname, Pointer<Float> params);

typedef GlGetTextureLevelParameterivEXTNative = Void Function(Uint32 texture,
    Uint32 target, Int32 level, Uint32 pname, Pointer<Int32> params);
typedef GlGetTextureLevelParameterivEXT = void Function(
    int texture, int target, int level, int pname, Pointer<Int32> params);

typedef GlTextureImage3DEXTNative = Void Function(
    Uint32 texture,
    Uint32 target,
    Int32 level,
    Int32 internalformat,
    Int32 width,
    Int32 height,
    Int32 depth,
    Int32 border,
    Uint32 format,
    Uint32 type,
    Pointer pixels);
typedef GlTextureImage3DEXT = void Function(
    int texture,
    int target,
    int level,
    int internalformat,
    int width,
    int height,
    int depth,
    int border,
    int format,
    int type,
    Pointer pixels);

typedef GlTextureSubImage3DEXTNative = Void Function(
    Uint32 texture,
    Uint32 target,
    Int32 level,
    Int32 xoffset,
    Int32 yoffset,
    Int32 zoffset,
    Int32 width,
    Int32 height,
    Int32 depth,
    Uint32 format,
    Uint32 type,
    Pointer pixels);
typedef GlTextureSubImage3DEXT = void Function(
    int texture,
    int target,
    int level,
    int xoffset,
    int yoffset,
    int zoffset,
    int width,
    int height,
    int depth,
    int format,
    int type,
    Pointer pixels);

typedef GlCopyTextureSubImage3DEXTNative = Void Function(
    Uint32 texture,
    Uint32 target,
    Int32 level,
    Int32 xoffset,
    Int32 yoffset,
    Int32 zoffset,
    Int32 x,
    Int32 y,
    Int32 width,
    Int32 height);
typedef GlCopyTextureSubImage3DEXT = void Function(
    int texture,
    int target,
    int level,
    int xoffset,
    int yoffset,
    int zoffset,
    int x,
    int y,
    int width,
    int height);

typedef GlBindMultiTextureEXTNative = Void Function(
    Uint32 texunit, Uint32 target, Uint32 texture);
typedef GlBindMultiTextureEXT = void Function(
    int texunit, int target, int texture);

typedef GlMultiTexCoordPointerEXTNative = Void Function(
    Uint32 texunit, Int32 size, Uint32 type, Int32 stride, Uint32 pointer);
typedef GlMultiTexCoordPointerEXT = void Function(
    int texunit, int size, int type, int stride, int pointer);

typedef GlMultiTexEnvfEXTNative = Void Function(
    Uint32 texunit, Uint32 target, Uint32 pname, Float param);
typedef GlMultiTexEnvfEXT = void Function(
    int texunit, int target, int pname, double param);

typedef GlMultiTexEnvfvEXTNative = Void Function(
    Uint32 texunit, Uint32 target, Uint32 pname, Pointer<Float> params);
typedef GlMultiTexEnvfvEXT = void Function(
    int texunit, int target, int pname, Pointer<Float> params);

typedef GlMultiTexEnviEXTNative = Void Function(
    Uint32 texunit, Uint32 target, Uint32 pname, Int32 param);
typedef GlMultiTexEnviEXT = void Function(
    int texunit, int target, int pname, int param);

typedef GlMultiTexEnvivEXTNative = Void Function(
    Uint32 texunit, Uint32 target, Uint32 pname, Pointer<Int32> params);
typedef GlMultiTexEnvivEXT = void Function(
    int texunit, int target, int pname, Pointer<Int32> params);

typedef GlMultiTexGendEXTNative = Void Function(
    Uint32 texunit, Uint32 coord, Uint32 pname, Double param);
typedef GlMultiTexGendEXT = void Function(
    int texunit, int coord, int pname, double param);

typedef GlMultiTexGendvEXTNative = Void Function(
    Uint32 texunit, Uint32 coord, Uint32 pname, Pointer<Double> params);
typedef GlMultiTexGendvEXT = void Function(
    int texunit, int coord, int pname, Pointer<Double> params);

typedef GlMultiTexGenfEXTNative = Void Function(
    Uint32 texunit, Uint32 coord, Uint32 pname, Float param);
typedef GlMultiTexGenfEXT = void Function(
    int texunit, int coord, int pname, double param);

typedef GlMultiTexGenfvEXTNative = Void Function(
    Uint32 texunit, Uint32 coord, Uint32 pname, Pointer<Float> params);
typedef GlMultiTexGenfvEXT = void Function(
    int texunit, int coord, int pname, Pointer<Float> params);

typedef GlMultiTexGeniEXTNative = Void Function(
    Uint32 texunit, Uint32 coord, Uint32 pname, Int32 param);
typedef GlMultiTexGeniEXT = void Function(
    int texunit, int coord, int pname, int param);

typedef GlMultiTexGenivEXTNative = Void Function(
    Uint32 texunit, Uint32 coord, Uint32 pname, Pointer<Int32> params);
typedef GlMultiTexGenivEXT = void Function(
    int texunit, int coord, int pname, Pointer<Int32> params);

typedef GlGetMultiTexEnvfvEXTNative = Void Function(
    Uint32 texunit, Uint32 target, Uint32 pname, Pointer<Float> params);
typedef GlGetMultiTexEnvfvEXT = void Function(
    int texunit, int target, int pname, Pointer<Float> params);

typedef GlGetMultiTexEnvivEXTNative = Void Function(
    Uint32 texunit, Uint32 target, Uint32 pname, Pointer<Int32> params);
typedef GlGetMultiTexEnvivEXT = void Function(
    int texunit, int target, int pname, Pointer<Int32> params);

typedef GlGetMultiTexGendvEXTNative = Void Function(
    Uint32 texunit, Uint32 coord, Uint32 pname, Pointer<Double> params);
typedef GlGetMultiTexGendvEXT = void Function(
    int texunit, int coord, int pname, Pointer<Double> params);

typedef GlGetMultiTexGenfvEXTNative = Void Function(
    Uint32 texunit, Uint32 coord, Uint32 pname, Pointer<Float> params);
typedef GlGetMultiTexGenfvEXT = void Function(
    int texunit, int coord, int pname, Pointer<Float> params);

typedef GlGetMultiTexGenivEXTNative = Void Function(
    Uint32 texunit, Uint32 coord, Uint32 pname, Pointer<Int32> params);
typedef GlGetMultiTexGenivEXT = void Function(
    int texunit, int coord, int pname, Pointer<Int32> params);

typedef GlMultiTexParameteriEXTNative = Void Function(
    Uint32 texunit, Uint32 target, Uint32 pname, Int32 param);
typedef GlMultiTexParameteriEXT = void Function(
    int texunit, int target, int pname, int param);

typedef GlMultiTexParameterivEXTNative = Void Function(
    Uint32 texunit, Uint32 target, Uint32 pname, Pointer<Int32> params);
typedef GlMultiTexParameterivEXT = void Function(
    int texunit, int target, int pname, Pointer<Int32> params);

typedef GlMultiTexParameterfEXTNative = Void Function(
    Uint32 texunit, Uint32 target, Uint32 pname, Float param);
typedef GlMultiTexParameterfEXT = void Function(
    int texunit, int target, int pname, double param);

typedef GlMultiTexParameterfvEXTNative = Void Function(
    Uint32 texunit, Uint32 target, Uint32 pname, Pointer<Float> params);
typedef GlMultiTexParameterfvEXT = void Function(
    int texunit, int target, int pname, Pointer<Float> params);

typedef GlMultiTexImage1DEXTNative = Void Function(
    Uint32 texunit,
    Uint32 target,
    Int32 level,
    Int32 internalformat,
    Int32 width,
    Int32 border,
    Uint32 format,
    Uint32 type,
    Pointer pixels);
typedef GlMultiTexImage1DEXT = void Function(
    int texunit,
    int target,
    int level,
    int internalformat,
    int width,
    int border,
    int format,
    int type,
    Pointer pixels);

typedef GlMultiTexImage2DEXTNative = Void Function(
    Uint32 texunit,
    Uint32 target,
    Int32 level,
    Int32 internalformat,
    Int32 width,
    Int32 height,
    Int32 border,
    Uint32 format,
    Uint32 type,
    Pointer pixels);
typedef GlMultiTexImage2DEXT = void Function(
    int texunit,
    int target,
    int level,
    int internalformat,
    int width,
    int height,
    int border,
    int format,
    int type,
    Pointer pixels);

typedef GlMultiTexSubImage1DEXTNative = Void Function(
    Uint32 texunit,
    Uint32 target,
    Int32 level,
    Int32 xoffset,
    Int32 width,
    Uint32 format,
    Uint32 type,
    Pointer pixels);
typedef GlMultiTexSubImage1DEXT = void Function(int texunit, int target,
    int level, int xoffset, int width, int format, int type, Pointer pixels);

typedef GlMultiTexSubImage2DEXTNative = Void Function(
    Uint32 texunit,
    Uint32 target,
    Int32 level,
    Int32 xoffset,
    Int32 yoffset,
    Int32 width,
    Int32 height,
    Uint32 format,
    Uint32 type,
    Pointer pixels);
typedef GlMultiTexSubImage2DEXT = void Function(
    int texunit,
    int target,
    int level,
    int xoffset,
    int yoffset,
    int width,
    int height,
    int format,
    int type,
    Pointer pixels);

typedef GlCopyMultiTexImage1DEXTNative = Void Function(
    Uint32 texunit,
    Uint32 target,
    Int32 level,
    Uint32 internalformat,
    Int32 x,
    Int32 y,
    Int32 width,
    Int32 border);
typedef GlCopyMultiTexImage1DEXT = void Function(int texunit, int target,
    int level, int internalformat, int x, int y, int width, int border);

typedef GlCopyMultiTexImage2DEXTNative = Void Function(
    Uint32 texunit,
    Uint32 target,
    Int32 level,
    Uint32 internalformat,
    Int32 x,
    Int32 y,
    Int32 width,
    Int32 height,
    Int32 border);
typedef GlCopyMultiTexImage2DEXT = void Function(
    int texunit,
    int target,
    int level,
    int internalformat,
    int x,
    int y,
    int width,
    int height,
    int border);

typedef GlCopyMultiTexSubImage1DEXTNative = Void Function(Uint32 texunit,
    Uint32 target, Int32 level, Int32 xoffset, Int32 x, Int32 y, Int32 width);
typedef GlCopyMultiTexSubImage1DEXT = void Function(
    int texunit, int target, int level, int xoffset, int x, int y, int width);

typedef GlCopyMultiTexSubImage2DEXTNative = Void Function(
    Uint32 texunit,
    Uint32 target,
    Int32 level,
    Int32 xoffset,
    Int32 yoffset,
    Int32 x,
    Int32 y,
    Int32 width,
    Int32 height);
typedef GlCopyMultiTexSubImage2DEXT = void Function(int texunit, int target,
    int level, int xoffset, int yoffset, int x, int y, int width, int height);

typedef GlGetMultiTexImageEXTNative = Void Function(Uint32 texunit,
    Uint32 target, Int32 level, Uint32 format, Uint32 type, Pointer pixels);
typedef GlGetMultiTexImageEXT = void Function(
    int texunit, int target, int level, int format, int type, Pointer pixels);

typedef GlGetMultiTexParameterfvEXTNative = Void Function(
    Uint32 texunit, Uint32 target, Uint32 pname, Pointer<Float> params);
typedef GlGetMultiTexParameterfvEXT = void Function(
    int texunit, int target, int pname, Pointer<Float> params);

typedef GlGetMultiTexParameterivEXTNative = Void Function(
    Uint32 texunit, Uint32 target, Uint32 pname, Pointer<Int32> params);
typedef GlGetMultiTexParameterivEXT = void Function(
    int texunit, int target, int pname, Pointer<Int32> params);

typedef GlGetMultiTexLevelParameterfvEXTNative = Void Function(Uint32 texunit,
    Uint32 target, Int32 level, Uint32 pname, Pointer<Float> params);
typedef GlGetMultiTexLevelParameterfvEXT = void Function(
    int texunit, int target, int level, int pname, Pointer<Float> params);

typedef GlGetMultiTexLevelParameterivEXTNative = Void Function(Uint32 texunit,
    Uint32 target, Int32 level, Uint32 pname, Pointer<Int32> params);
typedef GlGetMultiTexLevelParameterivEXT = void Function(
    int texunit, int target, int level, int pname, Pointer<Int32> params);

typedef GlMultiTexImage3DEXTNative = Void Function(
    Uint32 texunit,
    Uint32 target,
    Int32 level,
    Int32 internalformat,
    Int32 width,
    Int32 height,
    Int32 depth,
    Int32 border,
    Uint32 format,
    Uint32 type,
    Pointer pixels);
typedef GlMultiTexImage3DEXT = void Function(
    int texunit,
    int target,
    int level,
    int internalformat,
    int width,
    int height,
    int depth,
    int border,
    int format,
    int type,
    Pointer pixels);

typedef GlMultiTexSubImage3DEXTNative = Void Function(
    Uint32 texunit,
    Uint32 target,
    Int32 level,
    Int32 xoffset,
    Int32 yoffset,
    Int32 zoffset,
    Int32 width,
    Int32 height,
    Int32 depth,
    Uint32 format,
    Uint32 type,
    Pointer pixels);
typedef GlMultiTexSubImage3DEXT = void Function(
    int texunit,
    int target,
    int level,
    int xoffset,
    int yoffset,
    int zoffset,
    int width,
    int height,
    int depth,
    int format,
    int type,
    Pointer pixels);

typedef GlCopyMultiTexSubImage3DEXTNative = Void Function(
    Uint32 texunit,
    Uint32 target,
    Int32 level,
    Int32 xoffset,
    Int32 yoffset,
    Int32 zoffset,
    Int32 x,
    Int32 y,
    Int32 width,
    Int32 height);
typedef GlCopyMultiTexSubImage3DEXT = void Function(
    int texunit,
    int target,
    int level,
    int xoffset,
    int yoffset,
    int zoffset,
    int x,
    int y,
    int width,
    int height);

typedef GlEnableClientStateIndexedEXTNative = Void Function(
    Uint32 array, Uint32 index);
typedef GlEnableClientStateIndexedEXT = void Function(int array, int index);

typedef GlDisableClientStateIndexedEXTNative = Void Function(
    Uint32 array, Uint32 index);
typedef GlDisableClientStateIndexedEXT = void Function(int array, int index);

typedef GlGetFloatIndexedvEXTNative = Void Function(
    Uint32 target, Uint32 index, Pointer<Float> data);
typedef GlGetFloatIndexedvEXT = void Function(
    int target, int index, Pointer<Float> data);

typedef GlGetDoubleIndexedvEXTNative = Void Function(
    Uint32 target, Uint32 index, Pointer<Double> data);
typedef GlGetDoubleIndexedvEXT = void Function(
    int target, int index, Pointer<Double> data);

typedef GlGetPointerIndexedvEXTNative = Void Function(
    Uint32 target, Uint32 index, Pointer data);
typedef GlGetPointerIndexedvEXT = void Function(
    int target, int index, Pointer data);

typedef GlEnableIndexedEXTNative = Void Function(Uint32 target, Uint32 index);
typedef GlEnableIndexedEXT = void Function(int target, int index);

typedef GlDisableIndexedEXTNative = Void Function(Uint32 target, Uint32 index);
typedef GlDisableIndexedEXT = void Function(int target, int index);

typedef GlIsEnabledIndexedEXTNative = Uint8 Function(
    Uint32 target, Uint32 index);
typedef GlIsEnabledIndexedEXT = int Function(int target, int index);

typedef GlGetIntegerIndexedvEXTNative = Void Function(
    Uint32 target, Uint32 index, Pointer<Int32> data);
typedef GlGetIntegerIndexedvEXT = void Function(
    int target, int index, Pointer<Int32> data);

typedef GlGetBooleanIndexedvEXTNative = Void Function(
    Uint32 target, Uint32 index, Pointer data);
typedef GlGetBooleanIndexedvEXT = void Function(
    int target, int index, Pointer data);

typedef GlCompressedTextureImage3DEXTNative = Void Function(
    Uint32 texture,
    Uint32 target,
    Int32 level,
    Uint32 internalformat,
    Int32 width,
    Int32 height,
    Int32 depth,
    Int32 border,
    Int32 imageSize,
    Pointer bits);
typedef GlCompressedTextureImage3DEXT = void Function(
    int texture,
    int target,
    int level,
    int internalformat,
    int width,
    int height,
    int depth,
    int border,
    int imageSize,
    Pointer bits);

typedef GlCompressedTextureImage2DEXTNative = Void Function(
    Uint32 texture,
    Uint32 target,
    Int32 level,
    Uint32 internalformat,
    Int32 width,
    Int32 height,
    Int32 border,
    Int32 imageSize,
    Pointer bits);
typedef GlCompressedTextureImage2DEXT = void Function(
    int texture,
    int target,
    int level,
    int internalformat,
    int width,
    int height,
    int border,
    int imageSize,
    Pointer bits);

typedef GlCompressedTextureImage1DEXTNative = Void Function(
    Uint32 texture,
    Uint32 target,
    Int32 level,
    Uint32 internalformat,
    Int32 width,
    Int32 border,
    Int32 imageSize,
    Pointer bits);
typedef GlCompressedTextureImage1DEXT = void Function(
    int texture,
    int target,
    int level,
    int internalformat,
    int width,
    int border,
    int imageSize,
    Pointer bits);

typedef GlCompressedTextureSubImage3DEXTNative = Void Function(
    Uint32 texture,
    Uint32 target,
    Int32 level,
    Int32 xoffset,
    Int32 yoffset,
    Int32 zoffset,
    Int32 width,
    Int32 height,
    Int32 depth,
    Uint32 format,
    Int32 imageSize,
    Pointer bits);
typedef GlCompressedTextureSubImage3DEXT = void Function(
    int texture,
    int target,
    int level,
    int xoffset,
    int yoffset,
    int zoffset,
    int width,
    int height,
    int depth,
    int format,
    int imageSize,
    Pointer bits);

typedef GlCompressedTextureSubImage2DEXTNative = Void Function(
    Uint32 texture,
    Uint32 target,
    Int32 level,
    Int32 xoffset,
    Int32 yoffset,
    Int32 width,
    Int32 height,
    Uint32 format,
    Int32 imageSize,
    Pointer bits);
typedef GlCompressedTextureSubImage2DEXT = void Function(
    int texture,
    int target,
    int level,
    int xoffset,
    int yoffset,
    int width,
    int height,
    int format,
    int imageSize,
    Pointer bits);

typedef GlCompressedTextureSubImage1DEXTNative = Void Function(
    Uint32 texture,
    Uint32 target,
    Int32 level,
    Int32 xoffset,
    Int32 width,
    Uint32 format,
    Int32 imageSize,
    Pointer bits);
typedef GlCompressedTextureSubImage1DEXT = void Function(
    int texture,
    int target,
    int level,
    int xoffset,
    int width,
    int format,
    int imageSize,
    Pointer bits);

typedef GlGetCompressedTextureImageEXTNative = Void Function(
    Uint32 texture, Uint32 target, Int32 lod, Pointer img);
typedef GlGetCompressedTextureImageEXT = void Function(
    int texture, int target, int lod, Pointer img);

typedef GlCompressedMultiTexImage3DEXTNative = Void Function(
    Uint32 texunit,
    Uint32 target,
    Int32 level,
    Uint32 internalformat,
    Int32 width,
    Int32 height,
    Int32 depth,
    Int32 border,
    Int32 imageSize,
    Pointer bits);
typedef GlCompressedMultiTexImage3DEXT = void Function(
    int texunit,
    int target,
    int level,
    int internalformat,
    int width,
    int height,
    int depth,
    int border,
    int imageSize,
    Pointer bits);

typedef GlCompressedMultiTexImage2DEXTNative = Void Function(
    Uint32 texunit,
    Uint32 target,
    Int32 level,
    Uint32 internalformat,
    Int32 width,
    Int32 height,
    Int32 border,
    Int32 imageSize,
    Pointer bits);
typedef GlCompressedMultiTexImage2DEXT = void Function(
    int texunit,
    int target,
    int level,
    int internalformat,
    int width,
    int height,
    int border,
    int imageSize,
    Pointer bits);

typedef GlCompressedMultiTexImage1DEXTNative = Void Function(
    Uint32 texunit,
    Uint32 target,
    Int32 level,
    Uint32 internalformat,
    Int32 width,
    Int32 border,
    Int32 imageSize,
    Pointer bits);
typedef GlCompressedMultiTexImage1DEXT = void Function(
    int texunit,
    int target,
    int level,
    int internalformat,
    int width,
    int border,
    int imageSize,
    Pointer bits);

typedef GlCompressedMultiTexSubImage3DEXTNative = Void Function(
    Uint32 texunit,
    Uint32 target,
    Int32 level,
    Int32 xoffset,
    Int32 yoffset,
    Int32 zoffset,
    Int32 width,
    Int32 height,
    Int32 depth,
    Uint32 format,
    Int32 imageSize,
    Pointer bits);
typedef GlCompressedMultiTexSubImage3DEXT = void Function(
    int texunit,
    int target,
    int level,
    int xoffset,
    int yoffset,
    int zoffset,
    int width,
    int height,
    int depth,
    int format,
    int imageSize,
    Pointer bits);

typedef GlCompressedMultiTexSubImage2DEXTNative = Void Function(
    Uint32 texunit,
    Uint32 target,
    Int32 level,
    Int32 xoffset,
    Int32 yoffset,
    Int32 width,
    Int32 height,
    Uint32 format,
    Int32 imageSize,
    Pointer bits);
typedef GlCompressedMultiTexSubImage2DEXT = void Function(
    int texunit,
    int target,
    int level,
    int xoffset,
    int yoffset,
    int width,
    int height,
    int format,
    int imageSize,
    Pointer bits);

typedef GlCompressedMultiTexSubImage1DEXTNative = Void Function(
    Uint32 texunit,
    Uint32 target,
    Int32 level,
    Int32 xoffset,
    Int32 width,
    Uint32 format,
    Int32 imageSize,
    Pointer bits);
typedef GlCompressedMultiTexSubImage1DEXT = void Function(
    int texunit,
    int target,
    int level,
    int xoffset,
    int width,
    int format,
    int imageSize,
    Pointer bits);

typedef GlGetCompressedMultiTexImageEXTNative = Void Function(
    Uint32 texunit, Uint32 target, Int32 lod, Pointer img);
typedef GlGetCompressedMultiTexImageEXT = void Function(
    int texunit, int target, int lod, Pointer img);

typedef GlMatrixLoadTransposefEXTNative = Void Function(
    Uint32 mode, Pointer<Float> m);
typedef GlMatrixLoadTransposefEXT = void Function(int mode, Pointer<Float> m);

typedef GlMatrixLoadTransposedEXTNative = Void Function(
    Uint32 mode, Pointer<Double> m);
typedef GlMatrixLoadTransposedEXT = void Function(int mode, Pointer<Double> m);

typedef GlMatrixMultTransposefEXTNative = Void Function(
    Uint32 mode, Pointer<Float> m);
typedef GlMatrixMultTransposefEXT = void Function(int mode, Pointer<Float> m);

typedef GlMatrixMultTransposedEXTNative = Void Function(
    Uint32 mode, Pointer<Double> m);
typedef GlMatrixMultTransposedEXT = void Function(int mode, Pointer<Double> m);

typedef GlNamedBufferDataEXTNative = Void Function(
    Uint32 buffer, Int64 size, Pointer data, Uint32 usage);
typedef GlNamedBufferDataEXT = void Function(
    int buffer, int size, Pointer data, int usage);

typedef GlNamedBufferSubDataEXTNative = Void Function(
    Uint32 buffer, Int64 offset, Int64 size, Pointer data);
typedef GlNamedBufferSubDataEXT = void Function(
    int buffer, int offset, int size, Pointer data);

typedef GlMapNamedBufferEXTNative = Pointer Function(
    Uint32 buffer, Uint32 access);
typedef GlMapNamedBufferEXT = Pointer Function(int buffer, int access);

typedef GlUnmapNamedBufferEXTNative = Uint8 Function(Uint32 buffer);
typedef GlUnmapNamedBufferEXT = int Function(int buffer);

typedef GlGetNamedBufferParameterivEXTNative = Void Function(
    Uint32 buffer, Uint32 pname, Pointer<Int32> params);
typedef GlGetNamedBufferParameterivEXT = void Function(
    int buffer, int pname, Pointer<Int32> params);

typedef GlGetNamedBufferPointervEXTNative = Void Function(
    Uint32 buffer, Uint32 pname, Pointer params);
typedef GlGetNamedBufferPointervEXT = void Function(
    int buffer, int pname, Pointer params);

typedef GlGetNamedBufferSubDataEXTNative = Void Function(
    Uint32 buffer, Int64 offset, Int64 size, Pointer data);
typedef GlGetNamedBufferSubDataEXT = void Function(
    int buffer, int offset, int size, Pointer data);

typedef GlProgramUniform1fEXTNative = Void Function(
    Uint32 program, Int32 location, Float v0);
typedef GlProgramUniform1fEXT = void Function(
    int program, int location, double v0);

typedef GlProgramUniform2fEXTNative = Void Function(
    Uint32 program, Int32 location, Float v0, Float v1);
typedef GlProgramUniform2fEXT = void Function(
    int program, int location, double v0, double v1);

typedef GlProgramUniform3fEXTNative = Void Function(
    Uint32 program, Int32 location, Float v0, Float v1, Float v2);
typedef GlProgramUniform3fEXT = void Function(
    int program, int location, double v0, double v1, double v2);

typedef GlProgramUniform4fEXTNative = Void Function(
    Uint32 program, Int32 location, Float v0, Float v1, Float v2, Float v3);
typedef GlProgramUniform4fEXT = void Function(
    int program, int location, double v0, double v1, double v2, double v3);

typedef GlProgramUniform1iEXTNative = Void Function(
    Uint32 program, Int32 location, Int32 v0);
typedef GlProgramUniform1iEXT = void Function(
    int program, int location, int v0);

typedef GlProgramUniform2iEXTNative = Void Function(
    Uint32 program, Int32 location, Int32 v0, Int32 v1);
typedef GlProgramUniform2iEXT = void Function(
    int program, int location, int v0, int v1);

typedef GlProgramUniform3iEXTNative = Void Function(
    Uint32 program, Int32 location, Int32 v0, Int32 v1, Int32 v2);
typedef GlProgramUniform3iEXT = void Function(
    int program, int location, int v0, int v1, int v2);

typedef GlProgramUniform4iEXTNative = Void Function(
    Uint32 program, Int32 location, Int32 v0, Int32 v1, Int32 v2, Int32 v3);
typedef GlProgramUniform4iEXT = void Function(
    int program, int location, int v0, int v1, int v2, int v3);

typedef GlProgramUniform1fvEXTNative = Void Function(
    Uint32 program, Int32 location, Int32 count, Pointer<Float> value);
typedef GlProgramUniform1fvEXT = void Function(
    int program, int location, int count, Pointer<Float> value);

typedef GlProgramUniform2fvEXTNative = Void Function(
    Uint32 program, Int32 location, Int32 count, Pointer<Float> value);
typedef GlProgramUniform2fvEXT = void Function(
    int program, int location, int count, Pointer<Float> value);

typedef GlProgramUniform3fvEXTNative = Void Function(
    Uint32 program, Int32 location, Int32 count, Pointer<Float> value);
typedef GlProgramUniform3fvEXT = void Function(
    int program, int location, int count, Pointer<Float> value);

typedef GlProgramUniform4fvEXTNative = Void Function(
    Uint32 program, Int32 location, Int32 count, Pointer<Float> value);
typedef GlProgramUniform4fvEXT = void Function(
    int program, int location, int count, Pointer<Float> value);

typedef GlProgramUniform1ivEXTNative = Void Function(
    Uint32 program, Int32 location, Int32 count, Pointer<Int32> value);
typedef GlProgramUniform1ivEXT = void Function(
    int program, int location, int count, Pointer<Int32> value);

typedef GlProgramUniform2ivEXTNative = Void Function(
    Uint32 program, Int32 location, Int32 count, Pointer<Int32> value);
typedef GlProgramUniform2ivEXT = void Function(
    int program, int location, int count, Pointer<Int32> value);

typedef GlProgramUniform3ivEXTNative = Void Function(
    Uint32 program, Int32 location, Int32 count, Pointer<Int32> value);
typedef GlProgramUniform3ivEXT = void Function(
    int program, int location, int count, Pointer<Int32> value);

typedef GlProgramUniform4ivEXTNative = Void Function(
    Uint32 program, Int32 location, Int32 count, Pointer<Int32> value);
typedef GlProgramUniform4ivEXT = void Function(
    int program, int location, int count, Pointer<Int32> value);

typedef GlProgramUniformMatrix2fvEXTNative = Void Function(Uint32 program,
    Int32 location, Int32 count, Uint8 transpose, Pointer<Float> value);
typedef GlProgramUniformMatrix2fvEXT = void Function(
    int program, int location, int count, int transpose, Pointer<Float> value);

typedef GlProgramUniformMatrix3fvEXTNative = Void Function(Uint32 program,
    Int32 location, Int32 count, Uint8 transpose, Pointer<Float> value);
typedef GlProgramUniformMatrix3fvEXT = void Function(
    int program, int location, int count, int transpose, Pointer<Float> value);

typedef GlProgramUniformMatrix4fvEXTNative = Void Function(Uint32 program,
    Int32 location, Int32 count, Uint8 transpose, Pointer<Float> value);
typedef GlProgramUniformMatrix4fvEXT = void Function(
    int program, int location, int count, int transpose, Pointer<Float> value);

typedef GlProgramUniformMatrix2x3fvEXTNative = Void Function(Uint32 program,
    Int32 location, Int32 count, Uint8 transpose, Pointer<Float> value);
typedef GlProgramUniformMatrix2x3fvEXT = void Function(
    int program, int location, int count, int transpose, Pointer<Float> value);

typedef GlProgramUniformMatrix3x2fvEXTNative = Void Function(Uint32 program,
    Int32 location, Int32 count, Uint8 transpose, Pointer<Float> value);
typedef GlProgramUniformMatrix3x2fvEXT = void Function(
    int program, int location, int count, int transpose, Pointer<Float> value);

typedef GlProgramUniformMatrix2x4fvEXTNative = Void Function(Uint32 program,
    Int32 location, Int32 count, Uint8 transpose, Pointer<Float> value);
typedef GlProgramUniformMatrix2x4fvEXT = void Function(
    int program, int location, int count, int transpose, Pointer<Float> value);

typedef GlProgramUniformMatrix4x2fvEXTNative = Void Function(Uint32 program,
    Int32 location, Int32 count, Uint8 transpose, Pointer<Float> value);
typedef GlProgramUniformMatrix4x2fvEXT = void Function(
    int program, int location, int count, int transpose, Pointer<Float> value);

typedef GlProgramUniformMatrix3x4fvEXTNative = Void Function(Uint32 program,
    Int32 location, Int32 count, Uint8 transpose, Pointer<Float> value);
typedef GlProgramUniformMatrix3x4fvEXT = void Function(
    int program, int location, int count, int transpose, Pointer<Float> value);

typedef GlProgramUniformMatrix4x3fvEXTNative = Void Function(Uint32 program,
    Int32 location, Int32 count, Uint8 transpose, Pointer<Float> value);
typedef GlProgramUniformMatrix4x3fvEXT = void Function(
    int program, int location, int count, int transpose, Pointer<Float> value);

typedef GlTextureBufferEXTNative = Void Function(
    Uint32 texture, Uint32 target, Uint32 internalformat, Uint32 buffer);
typedef GlTextureBufferEXT = void Function(
    int texture, int target, int internalformat, int buffer);

typedef GlMultiTexBufferEXTNative = Void Function(
    Uint32 texunit, Uint32 target, Uint32 internalformat, Uint32 buffer);
typedef GlMultiTexBufferEXT = void Function(
    int texunit, int target, int internalformat, int buffer);

typedef GlTextureParameterIivEXTNative = Void Function(
    Uint32 texture, Uint32 target, Uint32 pname, Pointer<Int32> params);
typedef GlTextureParameterIivEXT = void Function(
    int texture, int target, int pname, Pointer<Int32> params);

typedef GlTextureParameterIuivEXTNative = Void Function(
    Uint32 texture, Uint32 target, Uint32 pname, Pointer<Uint32> params);
typedef GlTextureParameterIuivEXT = void Function(
    int texture, int target, int pname, Pointer<Uint32> params);

typedef GlGetTextureParameterIivEXTNative = Void Function(
    Uint32 texture, Uint32 target, Uint32 pname, Pointer<Int32> params);
typedef GlGetTextureParameterIivEXT = void Function(
    int texture, int target, int pname, Pointer<Int32> params);

typedef GlGetTextureParameterIuivEXTNative = Void Function(
    Uint32 texture, Uint32 target, Uint32 pname, Pointer<Uint32> params);
typedef GlGetTextureParameterIuivEXT = void Function(
    int texture, int target, int pname, Pointer<Uint32> params);

typedef GlMultiTexParameterIivEXTNative = Void Function(
    Uint32 texunit, Uint32 target, Uint32 pname, Pointer<Int32> params);
typedef GlMultiTexParameterIivEXT = void Function(
    int texunit, int target, int pname, Pointer<Int32> params);

typedef GlMultiTexParameterIuivEXTNative = Void Function(
    Uint32 texunit, Uint32 target, Uint32 pname, Pointer<Uint32> params);
typedef GlMultiTexParameterIuivEXT = void Function(
    int texunit, int target, int pname, Pointer<Uint32> params);

typedef GlGetMultiTexParameterIivEXTNative = Void Function(
    Uint32 texunit, Uint32 target, Uint32 pname, Pointer<Int32> params);
typedef GlGetMultiTexParameterIivEXT = void Function(
    int texunit, int target, int pname, Pointer<Int32> params);

typedef GlGetMultiTexParameterIuivEXTNative = Void Function(
    Uint32 texunit, Uint32 target, Uint32 pname, Pointer<Uint32> params);
typedef GlGetMultiTexParameterIuivEXT = void Function(
    int texunit, int target, int pname, Pointer<Uint32> params);

typedef GlProgramUniform1uiEXTNative = Void Function(
    Uint32 program, Int32 location, Uint32 v0);
typedef GlProgramUniform1uiEXT = void Function(
    int program, int location, int v0);

typedef GlProgramUniform2uiEXTNative = Void Function(
    Uint32 program, Int32 location, Uint32 v0, Uint32 v1);
typedef GlProgramUniform2uiEXT = void Function(
    int program, int location, int v0, int v1);

typedef GlProgramUniform3uiEXTNative = Void Function(
    Uint32 program, Int32 location, Uint32 v0, Uint32 v1, Uint32 v2);
typedef GlProgramUniform3uiEXT = void Function(
    int program, int location, int v0, int v1, int v2);

typedef GlProgramUniform4uiEXTNative = Void Function(
    Uint32 program, Int32 location, Uint32 v0, Uint32 v1, Uint32 v2, Uint32 v3);
typedef GlProgramUniform4uiEXT = void Function(
    int program, int location, int v0, int v1, int v2, int v3);

typedef GlProgramUniform1uivEXTNative = Void Function(
    Uint32 program, Int32 location, Int32 count, Pointer<Uint32> value);
typedef GlProgramUniform1uivEXT = void Function(
    int program, int location, int count, Pointer<Uint32> value);

typedef GlProgramUniform2uivEXTNative = Void Function(
    Uint32 program, Int32 location, Int32 count, Pointer<Uint32> value);
typedef GlProgramUniform2uivEXT = void Function(
    int program, int location, int count, Pointer<Uint32> value);

typedef GlProgramUniform3uivEXTNative = Void Function(
    Uint32 program, Int32 location, Int32 count, Pointer<Uint32> value);
typedef GlProgramUniform3uivEXT = void Function(
    int program, int location, int count, Pointer<Uint32> value);

typedef GlProgramUniform4uivEXTNative = Void Function(
    Uint32 program, Int32 location, Int32 count, Pointer<Uint32> value);
typedef GlProgramUniform4uivEXT = void Function(
    int program, int location, int count, Pointer<Uint32> value);

typedef GlNamedProgramLocalParameters4fvEXTNative = Void Function(
    Uint32 program,
    Uint32 target,
    Uint32 index,
    Int32 count,
    Pointer<Float> params);
typedef GlNamedProgramLocalParameters4fvEXT = void Function(
    int program, int target, int index, int count, Pointer<Float> params);

typedef GlNamedProgramLocalParameterI4iEXTNative = Void Function(Uint32 program,
    Uint32 target, Uint32 index, Int32 x, Int32 y, Int32 z, Int32 w);
typedef GlNamedProgramLocalParameterI4iEXT = void Function(
    int program, int target, int index, int x, int y, int z, int w);

typedef GlNamedProgramLocalParameterI4ivEXTNative = Void Function(
    Uint32 program, Uint32 target, Uint32 index, Pointer<Int32> params);
typedef GlNamedProgramLocalParameterI4ivEXT = void Function(
    int program, int target, int index, Pointer<Int32> params);

typedef GlNamedProgramLocalParametersI4ivEXTNative = Void Function(
    Uint32 program,
    Uint32 target,
    Uint32 index,
    Int32 count,
    Pointer<Int32> params);
typedef GlNamedProgramLocalParametersI4ivEXT = void Function(
    int program, int target, int index, int count, Pointer<Int32> params);

typedef GlNamedProgramLocalParameterI4uiEXTNative = Void Function(
    Uint32 program,
    Uint32 target,
    Uint32 index,
    Uint32 x,
    Uint32 y,
    Uint32 z,
    Uint32 w);
typedef GlNamedProgramLocalParameterI4uiEXT = void Function(
    int program, int target, int index, int x, int y, int z, int w);

typedef GlNamedProgramLocalParameterI4uivEXTNative = Void Function(
    Uint32 program, Uint32 target, Uint32 index, Pointer<Uint32> params);
typedef GlNamedProgramLocalParameterI4uivEXT = void Function(
    int program, int target, int index, Pointer<Uint32> params);

typedef GlNamedProgramLocalParametersI4uivEXTNative = Void Function(
    Uint32 program,
    Uint32 target,
    Uint32 index,
    Int32 count,
    Pointer<Uint32> params);
typedef GlNamedProgramLocalParametersI4uivEXT = void Function(
    int program, int target, int index, int count, Pointer<Uint32> params);

typedef GlGetNamedProgramLocalParameterIivEXTNative = Void Function(
    Uint32 program, Uint32 target, Uint32 index, Pointer<Int32> params);
typedef GlGetNamedProgramLocalParameterIivEXT = void Function(
    int program, int target, int index, Pointer<Int32> params);

typedef GlGetNamedProgramLocalParameterIuivEXTNative = Void Function(
    Uint32 program, Uint32 target, Uint32 index, Pointer<Uint32> params);
typedef GlGetNamedProgramLocalParameterIuivEXT = void Function(
    int program, int target, int index, Pointer<Uint32> params);

typedef GlEnableClientStateiEXTNative = Void Function(
    Uint32 array, Uint32 index);
typedef GlEnableClientStateiEXT = void Function(int array, int index);

typedef GlDisableClientStateiEXTNative = Void Function(
    Uint32 array, Uint32 index);
typedef GlDisableClientStateiEXT = void Function(int array, int index);

typedef GlGetFloati_vEXTNative = Void Function(
    Uint32 pname, Uint32 index, Pointer<Float> params);
typedef GlGetFloati_vEXT = void Function(
    int pname, int index, Pointer<Float> params);

typedef GlGetDoublei_vEXTNative = Void Function(
    Uint32 pname, Uint32 index, Pointer<Double> params);
typedef GlGetDoublei_vEXT = void Function(
    int pname, int index, Pointer<Double> params);

typedef GlGetPointeri_vEXTNative = Void Function(
    Uint32 pname, Uint32 index, Pointer params);
typedef GlGetPointeri_vEXT = void Function(
    int pname, int index, Pointer params);

typedef GlNamedProgramStringEXTNative = Void Function(
    Uint32 program, Uint32 target, Uint32 format, Int32 len, Pointer string);
typedef GlNamedProgramStringEXT = void Function(
    int program, int target, int format, int len, Pointer string);

typedef GlNamedProgramLocalParameter4dEXTNative = Void Function(Uint32 program,
    Uint32 target, Uint32 index, Double x, Double y, Double z, Double w);
typedef GlNamedProgramLocalParameter4dEXT = void Function(
    int program, int target, int index, double x, double y, double z, double w);

typedef GlNamedProgramLocalParameter4dvEXTNative = Void Function(
    Uint32 program, Uint32 target, Uint32 index, Pointer<Double> params);
typedef GlNamedProgramLocalParameter4dvEXT = void Function(
    int program, int target, int index, Pointer<Double> params);

typedef GlNamedProgramLocalParameter4fEXTNative = Void Function(Uint32 program,
    Uint32 target, Uint32 index, Float x, Float y, Float z, Float w);
typedef GlNamedProgramLocalParameter4fEXT = void Function(
    int program, int target, int index, double x, double y, double z, double w);

typedef GlNamedProgramLocalParameter4fvEXTNative = Void Function(
    Uint32 program, Uint32 target, Uint32 index, Pointer<Float> params);
typedef GlNamedProgramLocalParameter4fvEXT = void Function(
    int program, int target, int index, Pointer<Float> params);

typedef GlGetNamedProgramLocalParameterdvEXTNative = Void Function(
    Uint32 program, Uint32 target, Uint32 index, Pointer<Double> params);
typedef GlGetNamedProgramLocalParameterdvEXT = void Function(
    int program, int target, int index, Pointer<Double> params);

typedef GlGetNamedProgramLocalParameterfvEXTNative = Void Function(
    Uint32 program, Uint32 target, Uint32 index, Pointer<Float> params);
typedef GlGetNamedProgramLocalParameterfvEXT = void Function(
    int program, int target, int index, Pointer<Float> params);

typedef GlGetNamedProgramivEXTNative = Void Function(
    Uint32 program, Uint32 target, Uint32 pname, Pointer<Int32> params);
typedef GlGetNamedProgramivEXT = void Function(
    int program, int target, int pname, Pointer<Int32> params);

typedef GlGetNamedProgramStringEXTNative = Void Function(
    Uint32 program, Uint32 target, Uint32 pname, Pointer string);
typedef GlGetNamedProgramStringEXT = void Function(
    int program, int target, int pname, Pointer string);

typedef GlNamedRenderbufferStorageEXTNative = Void Function(
    Uint32 renderbuffer, Uint32 internalformat, Int32 width, Int32 height);
typedef GlNamedRenderbufferStorageEXT = void Function(
    int renderbuffer, int internalformat, int width, int height);

typedef GlGetNamedRenderbufferParameterivEXTNative = Void Function(
    Uint32 renderbuffer, Uint32 pname, Pointer<Int32> params);
typedef GlGetNamedRenderbufferParameterivEXT = void Function(
    int renderbuffer, int pname, Pointer<Int32> params);

typedef GlNamedRenderbufferStorageMultisampleEXTNative = Void Function(
    Uint32 renderbuffer,
    Int32 samples,
    Uint32 internalformat,
    Int32 width,
    Int32 height);
typedef GlNamedRenderbufferStorageMultisampleEXT = void Function(
    int renderbuffer, int samples, int internalformat, int width, int height);

typedef GlNamedRenderbufferStorageMultisampleCoverageEXTNative = Void Function(
    Uint32 renderbuffer,
    Int32 coverageSamples,
    Int32 colorSamples,
    Uint32 internalformat,
    Int32 width,
    Int32 height);
typedef GlNamedRenderbufferStorageMultisampleCoverageEXT = void Function(
    int renderbuffer,
    int coverageSamples,
    int colorSamples,
    int internalformat,
    int width,
    int height);

typedef GlCheckNamedFramebufferStatusEXTNative = Uint32 Function(
    Uint32 framebuffer, Uint32 target);
typedef GlCheckNamedFramebufferStatusEXT = int Function(
    int framebuffer, int target);

typedef GlNamedFramebufferTexture1DEXTNative = Void Function(Uint32 framebuffer,
    Uint32 attachment, Uint32 textarget, Uint32 texture, Int32 level);
typedef GlNamedFramebufferTexture1DEXT = void Function(
    int framebuffer, int attachment, int textarget, int texture, int level);

typedef GlNamedFramebufferTexture2DEXTNative = Void Function(Uint32 framebuffer,
    Uint32 attachment, Uint32 textarget, Uint32 texture, Int32 level);
typedef GlNamedFramebufferTexture2DEXT = void Function(
    int framebuffer, int attachment, int textarget, int texture, int level);

typedef GlNamedFramebufferTexture3DEXTNative = Void Function(
    Uint32 framebuffer,
    Uint32 attachment,
    Uint32 textarget,
    Uint32 texture,
    Int32 level,
    Int32 zoffset);
typedef GlNamedFramebufferTexture3DEXT = void Function(int framebuffer,
    int attachment, int textarget, int texture, int level, int zoffset);

typedef GlNamedFramebufferRenderbufferEXTNative = Void Function(
    Uint32 framebuffer,
    Uint32 attachment,
    Uint32 renderbuffertarget,
    Uint32 renderbuffer);
typedef GlNamedFramebufferRenderbufferEXT = void Function(
    int framebuffer, int attachment, int renderbuffertarget, int renderbuffer);

typedef GlGetNamedFramebufferAttachmentParameterivEXTNative = Void Function(
    Uint32 framebuffer, Uint32 attachment, Uint32 pname, Pointer<Int32> params);
typedef GlGetNamedFramebufferAttachmentParameterivEXT = void Function(
    int framebuffer, int attachment, int pname, Pointer<Int32> params);

typedef GlGenerateTextureMipmapEXTNative = Void Function(
    Uint32 texture, Uint32 target);
typedef GlGenerateTextureMipmapEXT = void Function(int texture, int target);

typedef GlGenerateMultiTexMipmapEXTNative = Void Function(
    Uint32 texunit, Uint32 target);
typedef GlGenerateMultiTexMipmapEXT = void Function(int texunit, int target);

typedef GlFramebufferDrawBufferEXTNative = Void Function(
    Uint32 framebuffer, Uint32 mode);
typedef GlFramebufferDrawBufferEXT = void Function(int framebuffer, int mode);

typedef GlFramebufferDrawBuffersEXTNative = Void Function(
    Uint32 framebuffer, Int32 n, Pointer<Uint32> bufs);
typedef GlFramebufferDrawBuffersEXT = void Function(
    int framebuffer, int n, Pointer<Uint32> bufs);

typedef GlFramebufferReadBufferEXTNative = Void Function(
    Uint32 framebuffer, Uint32 mode);
typedef GlFramebufferReadBufferEXT = void Function(int framebuffer, int mode);

typedef GlGetFramebufferParameterivEXTNative = Void Function(
    Uint32 framebuffer, Uint32 pname, Pointer<Int32> params);
typedef GlGetFramebufferParameterivEXT = void Function(
    int framebuffer, int pname, Pointer<Int32> params);

typedef GlNamedCopyBufferSubDataEXTNative = Void Function(Uint32 readBuffer,
    Uint32 writeBuffer, Int64 readOffset, Int64 writeOffset, Int64 size);
typedef GlNamedCopyBufferSubDataEXT = void Function(
    int readBuffer, int writeBuffer, int readOffset, int writeOffset, int size);

typedef GlNamedFramebufferTextureEXTNative = Void Function(
    Uint32 framebuffer, Uint32 attachment, Uint32 texture, Int32 level);
typedef GlNamedFramebufferTextureEXT = void Function(
    int framebuffer, int attachment, int texture, int level);

typedef GlNamedFramebufferTextureLayerEXTNative = Void Function(
    Uint32 framebuffer,
    Uint32 attachment,
    Uint32 texture,
    Int32 level,
    Int32 layer);
typedef GlNamedFramebufferTextureLayerEXT = void Function(
    int framebuffer, int attachment, int texture, int level, int layer);

typedef GlNamedFramebufferTextureFaceEXTNative = Void Function(
    Uint32 framebuffer,
    Uint32 attachment,
    Uint32 texture,
    Int32 level,
    Uint32 face);
typedef GlNamedFramebufferTextureFaceEXT = void Function(
    int framebuffer, int attachment, int texture, int level, int face);

typedef GlTextureRenderbufferEXTNative = Void Function(
    Uint32 texture, Uint32 target, Uint32 renderbuffer);
typedef GlTextureRenderbufferEXT = void Function(
    int texture, int target, int renderbuffer);

typedef GlMultiTexRenderbufferEXTNative = Void Function(
    Uint32 texunit, Uint32 target, Uint32 renderbuffer);
typedef GlMultiTexRenderbufferEXT = void Function(
    int texunit, int target, int renderbuffer);

typedef GlVertexArrayVertexOffsetEXTNative = Void Function(Uint32 vaobj,
    Uint32 buffer, Int32 size, Uint32 type, Int32 stride, Int64 offset);
typedef GlVertexArrayVertexOffsetEXT = void Function(
    int vaobj, int buffer, int size, int type, int stride, int offset);

typedef GlVertexArrayColorOffsetEXTNative = Void Function(Uint32 vaobj,
    Uint32 buffer, Int32 size, Uint32 type, Int32 stride, Int64 offset);
typedef GlVertexArrayColorOffsetEXT = void Function(
    int vaobj, int buffer, int size, int type, int stride, int offset);

typedef GlVertexArrayEdgeFlagOffsetEXTNative = Void Function(
    Uint32 vaobj, Uint32 buffer, Int32 stride, Int64 offset);
typedef GlVertexArrayEdgeFlagOffsetEXT = void Function(
    int vaobj, int buffer, int stride, int offset);

typedef GlVertexArrayIndexOffsetEXTNative = Void Function(
    Uint32 vaobj, Uint32 buffer, Uint32 type, Int32 stride, Int64 offset);
typedef GlVertexArrayIndexOffsetEXT = void Function(
    int vaobj, int buffer, int type, int stride, int offset);

typedef GlVertexArrayNormalOffsetEXTNative = Void Function(
    Uint32 vaobj, Uint32 buffer, Uint32 type, Int32 stride, Int64 offset);
typedef GlVertexArrayNormalOffsetEXT = void Function(
    int vaobj, int buffer, int type, int stride, int offset);

typedef GlVertexArrayTexCoordOffsetEXTNative = Void Function(Uint32 vaobj,
    Uint32 buffer, Int32 size, Uint32 type, Int32 stride, Int64 offset);
typedef GlVertexArrayTexCoordOffsetEXT = void Function(
    int vaobj, int buffer, int size, int type, int stride, int offset);

typedef GlVertexArrayMultiTexCoordOffsetEXTNative = Void Function(
    Uint32 vaobj,
    Uint32 buffer,
    Uint32 texunit,
    Int32 size,
    Uint32 type,
    Int32 stride,
    Int64 offset);
typedef GlVertexArrayMultiTexCoordOffsetEXT = void Function(int vaobj,
    int buffer, int texunit, int size, int type, int stride, int offset);

typedef GlVertexArrayFogCoordOffsetEXTNative = Void Function(
    Uint32 vaobj, Uint32 buffer, Uint32 type, Int32 stride, Int64 offset);
typedef GlVertexArrayFogCoordOffsetEXT = void Function(
    int vaobj, int buffer, int type, int stride, int offset);

typedef GlVertexArraySecondaryColorOffsetEXTNative = Void Function(Uint32 vaobj,
    Uint32 buffer, Int32 size, Uint32 type, Int32 stride, Int64 offset);
typedef GlVertexArraySecondaryColorOffsetEXT = void Function(
    int vaobj, int buffer, int size, int type, int stride, int offset);

typedef GlVertexArrayVertexAttribOffsetEXTNative = Void Function(
    Uint32 vaobj,
    Uint32 buffer,
    Uint32 index,
    Int32 size,
    Uint32 type,
    Uint8 normalized,
    Int32 stride,
    Int64 offset);
typedef GlVertexArrayVertexAttribOffsetEXT = void Function(
    int vaobj,
    int buffer,
    int index,
    int size,
    int type,
    int normalized,
    int stride,
    int offset);

typedef GlVertexArrayVertexAttribIOffsetEXTNative = Void Function(
    Uint32 vaobj,
    Uint32 buffer,
    Uint32 index,
    Int32 size,
    Uint32 type,
    Int32 stride,
    Int64 offset);
typedef GlVertexArrayVertexAttribIOffsetEXT = void Function(int vaobj,
    int buffer, int index, int size, int type, int stride, int offset);

typedef GlEnableVertexArrayEXTNative = Void Function(
    Uint32 vaobj, Uint32 array);
typedef GlEnableVertexArrayEXT = void Function(int vaobj, int array);

typedef GlDisableVertexArrayEXTNative = Void Function(
    Uint32 vaobj, Uint32 array);
typedef GlDisableVertexArrayEXT = void Function(int vaobj, int array);

typedef GlEnableVertexArrayAttribEXTNative = Void Function(
    Uint32 vaobj, Uint32 index);
typedef GlEnableVertexArrayAttribEXT = void Function(int vaobj, int index);

typedef GlDisableVertexArrayAttribEXTNative = Void Function(
    Uint32 vaobj, Uint32 index);
typedef GlDisableVertexArrayAttribEXT = void Function(int vaobj, int index);

typedef GlGetVertexArrayIntegervEXTNative = Void Function(
    Uint32 vaobj, Uint32 pname, Pointer<Int32> param);
typedef GlGetVertexArrayIntegervEXT = void Function(
    int vaobj, int pname, Pointer<Int32> param);

typedef GlGetVertexArrayPointervEXTNative = Void Function(
    Uint32 vaobj, Uint32 pname, Pointer param);
typedef GlGetVertexArrayPointervEXT = void Function(
    int vaobj, int pname, Pointer param);

typedef GlGetVertexArrayIntegeri_vEXTNative = Void Function(
    Uint32 vaobj, Uint32 index, Uint32 pname, Pointer<Int32> param);
typedef GlGetVertexArrayIntegeri_vEXT = void Function(
    int vaobj, int index, int pname, Pointer<Int32> param);

typedef GlGetVertexArrayPointeri_vEXTNative = Void Function(
    Uint32 vaobj, Uint32 index, Uint32 pname, Pointer param);
typedef GlGetVertexArrayPointeri_vEXT = void Function(
    int vaobj, int index, int pname, Pointer param);

typedef GlMapNamedBufferRangeEXTNative = Pointer Function(
    Uint32 buffer, Int64 offset, Int64 length, Uint32 access);
typedef GlMapNamedBufferRangeEXT = Pointer Function(
    int buffer, int offset, int length, int access);

typedef GlFlushMappedNamedBufferRangeEXTNative = Void Function(
    Uint32 buffer, Int64 offset, Int64 length);
typedef GlFlushMappedNamedBufferRangeEXT = void Function(
    int buffer, int offset, int length);

typedef GlNamedBufferStorageEXTNative = Void Function(
    Uint32 buffer, Int64 size, Pointer data, Uint32 flags);
typedef GlNamedBufferStorageEXT = void Function(
    int buffer, int size, Pointer data, int flags);

typedef GlClearNamedBufferDataEXTNative = Void Function(Uint32 buffer,
    Uint32 internalformat, Uint32 format, Uint32 type, Pointer data);
typedef GlClearNamedBufferDataEXT = void Function(
    int buffer, int internalformat, int format, int type, Pointer data);

typedef GlClearNamedBufferSubDataEXTNative = Void Function(
    Uint32 buffer,
    Uint32 internalformat,
    Int64 offset,
    Int64 size,
    Uint32 format,
    Uint32 type,
    Pointer data);
typedef GlClearNamedBufferSubDataEXT = void Function(
    int buffer,
    int internalformat,
    int offset,
    int size,
    int format,
    int type,
    Pointer data);

typedef GlNamedFramebufferParameteriEXTNative = Void Function(
    Uint32 framebuffer, Uint32 pname, Int32 param);
typedef GlNamedFramebufferParameteriEXT = void Function(
    int framebuffer, int pname, int param);

typedef GlGetNamedFramebufferParameterivEXTNative = Void Function(
    Uint32 framebuffer, Uint32 pname, Pointer<Int32> params);
typedef GlGetNamedFramebufferParameterivEXT = void Function(
    int framebuffer, int pname, Pointer<Int32> params);

typedef GlProgramUniform1dEXTNative = Void Function(
    Uint32 program, Int32 location, Double x);
typedef GlProgramUniform1dEXT = void Function(
    int program, int location, double x);

typedef GlProgramUniform2dEXTNative = Void Function(
    Uint32 program, Int32 location, Double x, Double y);
typedef GlProgramUniform2dEXT = void Function(
    int program, int location, double x, double y);

typedef GlProgramUniform3dEXTNative = Void Function(
    Uint32 program, Int32 location, Double x, Double y, Double z);
typedef GlProgramUniform3dEXT = void Function(
    int program, int location, double x, double y, double z);

typedef GlProgramUniform4dEXTNative = Void Function(
    Uint32 program, Int32 location, Double x, Double y, Double z, Double w);
typedef GlProgramUniform4dEXT = void Function(
    int program, int location, double x, double y, double z, double w);

typedef GlProgramUniform1dvEXTNative = Void Function(
    Uint32 program, Int32 location, Int32 count, Pointer<Double> value);
typedef GlProgramUniform1dvEXT = void Function(
    int program, int location, int count, Pointer<Double> value);

typedef GlProgramUniform2dvEXTNative = Void Function(
    Uint32 program, Int32 location, Int32 count, Pointer<Double> value);
typedef GlProgramUniform2dvEXT = void Function(
    int program, int location, int count, Pointer<Double> value);

typedef GlProgramUniform3dvEXTNative = Void Function(
    Uint32 program, Int32 location, Int32 count, Pointer<Double> value);
typedef GlProgramUniform3dvEXT = void Function(
    int program, int location, int count, Pointer<Double> value);

typedef GlProgramUniform4dvEXTNative = Void Function(
    Uint32 program, Int32 location, Int32 count, Pointer<Double> value);
typedef GlProgramUniform4dvEXT = void Function(
    int program, int location, int count, Pointer<Double> value);

typedef GlProgramUniformMatrix2dvEXTNative = Void Function(Uint32 program,
    Int32 location, Int32 count, Uint8 transpose, Pointer<Double> value);
typedef GlProgramUniformMatrix2dvEXT = void Function(
    int program, int location, int count, int transpose, Pointer<Double> value);

typedef GlProgramUniformMatrix3dvEXTNative = Void Function(Uint32 program,
    Int32 location, Int32 count, Uint8 transpose, Pointer<Double> value);
typedef GlProgramUniformMatrix3dvEXT = void Function(
    int program, int location, int count, int transpose, Pointer<Double> value);

typedef GlProgramUniformMatrix4dvEXTNative = Void Function(Uint32 program,
    Int32 location, Int32 count, Uint8 transpose, Pointer<Double> value);
typedef GlProgramUniformMatrix4dvEXT = void Function(
    int program, int location, int count, int transpose, Pointer<Double> value);

typedef GlProgramUniformMatrix2x3dvEXTNative = Void Function(Uint32 program,
    Int32 location, Int32 count, Uint8 transpose, Pointer<Double> value);
typedef GlProgramUniformMatrix2x3dvEXT = void Function(
    int program, int location, int count, int transpose, Pointer<Double> value);

typedef GlProgramUniformMatrix2x4dvEXTNative = Void Function(Uint32 program,
    Int32 location, Int32 count, Uint8 transpose, Pointer<Double> value);
typedef GlProgramUniformMatrix2x4dvEXT = void Function(
    int program, int location, int count, int transpose, Pointer<Double> value);

typedef GlProgramUniformMatrix3x2dvEXTNative = Void Function(Uint32 program,
    Int32 location, Int32 count, Uint8 transpose, Pointer<Double> value);
typedef GlProgramUniformMatrix3x2dvEXT = void Function(
    int program, int location, int count, int transpose, Pointer<Double> value);

typedef GlProgramUniformMatrix3x4dvEXTNative = Void Function(Uint32 program,
    Int32 location, Int32 count, Uint8 transpose, Pointer<Double> value);
typedef GlProgramUniformMatrix3x4dvEXT = void Function(
    int program, int location, int count, int transpose, Pointer<Double> value);

typedef GlProgramUniformMatrix4x2dvEXTNative = Void Function(Uint32 program,
    Int32 location, Int32 count, Uint8 transpose, Pointer<Double> value);
typedef GlProgramUniformMatrix4x2dvEXT = void Function(
    int program, int location, int count, int transpose, Pointer<Double> value);

typedef GlProgramUniformMatrix4x3dvEXTNative = Void Function(Uint32 program,
    Int32 location, Int32 count, Uint8 transpose, Pointer<Double> value);
typedef GlProgramUniformMatrix4x3dvEXT = void Function(
    int program, int location, int count, int transpose, Pointer<Double> value);

typedef GlTextureBufferRangeEXTNative = Void Function(
    Uint32 texture,
    Uint32 target,
    Uint32 internalformat,
    Uint32 buffer,
    Int64 offset,
    Int64 size);
typedef GlTextureBufferRangeEXT = void Function(int texture, int target,
    int internalformat, int buffer, int offset, int size);

typedef GlTextureStorage1DEXTNative = Void Function(Uint32 texture,
    Uint32 target, Int32 levels, Uint32 internalformat, Int32 width);
typedef GlTextureStorage1DEXT = void Function(
    int texture, int target, int levels, int internalformat, int width);

typedef GlTextureStorage2DEXTNative = Void Function(
    Uint32 texture,
    Uint32 target,
    Int32 levels,
    Uint32 internalformat,
    Int32 width,
    Int32 height);
typedef GlTextureStorage2DEXT = void Function(int texture, int target,
    int levels, int internalformat, int width, int height);

typedef GlTextureStorage3DEXTNative = Void Function(
    Uint32 texture,
    Uint32 target,
    Int32 levels,
    Uint32 internalformat,
    Int32 width,
    Int32 height,
    Int32 depth);
typedef GlTextureStorage3DEXT = void Function(int texture, int target,
    int levels, int internalformat, int width, int height, int depth);

typedef GlTextureStorage2DMultisampleEXTNative = Void Function(
    Uint32 texture,
    Uint32 target,
    Int32 samples,
    Uint32 internalformat,
    Int32 width,
    Int32 height,
    Uint8 fixedsamplelocations);
typedef GlTextureStorage2DMultisampleEXT = void Function(
    int texture,
    int target,
    int samples,
    int internalformat,
    int width,
    int height,
    int fixedsamplelocations);

typedef GlTextureStorage3DMultisampleEXTNative = Void Function(
    Uint32 texture,
    Uint32 target,
    Int32 samples,
    Uint32 internalformat,
    Int32 width,
    Int32 height,
    Int32 depth,
    Uint8 fixedsamplelocations);
typedef GlTextureStorage3DMultisampleEXT = void Function(
    int texture,
    int target,
    int samples,
    int internalformat,
    int width,
    int height,
    int depth,
    int fixedsamplelocations);

typedef GlVertexArrayBindVertexBufferEXTNative = Void Function(Uint32 vaobj,
    Uint32 bindingindex, Uint32 buffer, Int64 offset, Int32 stride);
typedef GlVertexArrayBindVertexBufferEXT = void Function(
    int vaobj, int bindingindex, int buffer, int offset, int stride);

typedef GlVertexArrayVertexAttribFormatEXTNative = Void Function(
    Uint32 vaobj,
    Uint32 attribindex,
    Int32 size,
    Uint32 type,
    Uint8 normalized,
    Uint32 relativeoffset);
typedef GlVertexArrayVertexAttribFormatEXT = void Function(int vaobj,
    int attribindex, int size, int type, int normalized, int relativeoffset);

typedef GlVertexArrayVertexAttribIFormatEXTNative = Void Function(Uint32 vaobj,
    Uint32 attribindex, Int32 size, Uint32 type, Uint32 relativeoffset);
typedef GlVertexArrayVertexAttribIFormatEXT = void Function(
    int vaobj, int attribindex, int size, int type, int relativeoffset);

typedef GlVertexArrayVertexAttribLFormatEXTNative = Void Function(Uint32 vaobj,
    Uint32 attribindex, Int32 size, Uint32 type, Uint32 relativeoffset);
typedef GlVertexArrayVertexAttribLFormatEXT = void Function(
    int vaobj, int attribindex, int size, int type, int relativeoffset);

typedef GlVertexArrayVertexAttribBindingEXTNative = Void Function(
    Uint32 vaobj, Uint32 attribindex, Uint32 bindingindex);
typedef GlVertexArrayVertexAttribBindingEXT = void Function(
    int vaobj, int attribindex, int bindingindex);

typedef GlVertexArrayVertexBindingDivisorEXTNative = Void Function(
    Uint32 vaobj, Uint32 bindingindex, Uint32 divisor);
typedef GlVertexArrayVertexBindingDivisorEXT = void Function(
    int vaobj, int bindingindex, int divisor);

typedef GlVertexArrayVertexAttribLOffsetEXTNative = Void Function(
    Uint32 vaobj,
    Uint32 buffer,
    Uint32 index,
    Int32 size,
    Uint32 type,
    Int32 stride,
    Int64 offset);
typedef GlVertexArrayVertexAttribLOffsetEXT = void Function(int vaobj,
    int buffer, int index, int size, int type, int stride, int offset);

typedef GlTexturePageCommitmentEXTNative = Void Function(
    Uint32 texture,
    Int32 level,
    Int32 xoffset,
    Int32 yoffset,
    Int32 zoffset,
    Int32 width,
    Int32 height,
    Int32 depth,
    Uint8 commit);
typedef GlTexturePageCommitmentEXT = void Function(
    int texture,
    int level,
    int xoffset,
    int yoffset,
    int zoffset,
    int width,
    int height,
    int depth,
    int commit);

typedef GlVertexArrayVertexAttribDivisorEXTNative = Void Function(
    Uint32 vaobj, Uint32 index, Uint32 divisor);
typedef GlVertexArrayVertexAttribDivisorEXT = void Function(
    int vaobj, int index, int divisor);

//GL_EXT_draw_instanced
typedef GlDrawArraysInstancedEXTNative = Void Function(
    Uint32 mode, Int32 start, Int32 count, Int32 primcount);
typedef GlDrawArraysInstancedEXT = void Function(
    int mode, int start, int count, int primcount);

typedef GlDrawElementsInstancedEXTNative = Void Function(
    Uint32 mode, Int32 count, Uint32 type, Pointer indices, Int32 primcount);
typedef GlDrawElementsInstancedEXT = void Function(
    int mode, int count, int type, Pointer indices, int primcount);

//GL_EXT_polygon_offset_clamp
typedef GlPolygonOffsetClampEXTNative = Void Function(
    Float factor, Float units, Float clamp);
typedef GlPolygonOffsetClampEXT = void Function(
    double factor, double units, double clamp);

//GL_EXT_raster_multisample
typedef GlRasterSamplesEXTNative = Void Function(
    Uint32 samples, Uint8 fixedsamplelocations);
typedef GlRasterSamplesEXT = void Function(
    int samples, int fixedsamplelocations);

//GL_EXT_separate_shader_objects
typedef GlUseShaderProgramEXTNative = Void Function(
    Uint32 type, Uint32 program);
typedef GlUseShaderProgramEXT = void Function(int type, int program);

typedef GlActiveProgramEXTNative = Void Function(Uint32 program);
typedef GlActiveProgramEXT = void Function(int program);

typedef GlCreateShaderProgramEXTNative = Uint32 Function(
    Uint32 type, Pointer string);
typedef GlCreateShaderProgramEXT = int Function(
    int type, /*String*/ Pointer string);

//GL_EXT_shader_framebuffer_fetch_non_coherent
typedef GlFramebufferFetchBarrierEXTNative = Void Function();
typedef GlFramebufferFetchBarrierEXT = void Function();

//GL_EXT_window_rectangles
typedef GlWindowRectanglesEXTNative = Void Function(
    Uint32 mode, Int32 count, Pointer<Int32> box);
typedef GlWindowRectanglesEXT = void Function(
    int mode, int count, Pointer<Int32> box);

//GL_INTEL_framebuffer_CMAA
typedef GlApplyFramebufferAttachmentCMAAINTELNative = Void Function();
typedef GlApplyFramebufferAttachmentCMAAINTEL = void Function();

//GL_INTEL_performance_query
typedef GlBeginPerfQueryINTELNative = Void Function(Uint32 queryHandle);
typedef GlBeginPerfQueryINTEL = void Function(int queryHandle);

typedef GlCreatePerfQueryINTELNative = Void Function(
    Uint32 queryId, Pointer<Uint32> queryHandle);
typedef GlCreatePerfQueryINTEL = void Function(
    int queryId, Pointer<Uint32> queryHandle);

typedef GlDeletePerfQueryINTELNative = Void Function(Uint32 queryHandle);
typedef GlDeletePerfQueryINTEL = void Function(int queryHandle);

typedef GlEndPerfQueryINTELNative = Void Function(Uint32 queryHandle);
typedef GlEndPerfQueryINTEL = void Function(int queryHandle);

typedef GlGetFirstPerfQueryIdINTELNative = Void Function(
    Pointer<Uint32> queryId);
typedef GlGetFirstPerfQueryIdINTEL = void Function(Pointer<Uint32> queryId);

typedef GlGetNextPerfQueryIdINTELNative = Void Function(
    Uint32 queryId, Pointer<Uint32> nextQueryId);
typedef GlGetNextPerfQueryIdINTEL = void Function(
    int queryId, Pointer<Uint32> nextQueryId);

typedef GlGetPerfCounterInfoINTELNative = Void Function(
    Uint32 queryId,
    Uint32 counterId,
    Uint32 counterNameLength,
    Pointer counterName,
    Uint32 counterDescLength,
    Pointer counterDesc,
    Pointer<Uint32> counterOffset,
    Pointer<Uint32> counterDataSize,
    Pointer<Uint32> counterTypeEnum,
    Pointer<Uint32> counterDataTypeEnum,
    Pointer<Uint64> rawCounterMaxValue);
typedef GlGetPerfCounterInfoINTEL = void Function(
    int queryId,
    int counterId,
    int counterNameLength,
    Pointer counterName,
    int counterDescLength,
    Pointer counterDesc,
    Pointer<Uint32> counterOffset,
    Pointer<Uint32> counterDataSize,
    Pointer<Uint32> counterTypeEnum,
    Pointer<Uint32> counterDataTypeEnum,
    Pointer<Uint64> rawCounterMaxValue);

typedef GlGetPerfQueryDataINTELNative = Void Function(Uint32 queryHandle,
    Uint32 flags, Int32 dataSize, Pointer data, Pointer<Uint32> bytesWritten);
typedef GlGetPerfQueryDataINTEL = void Function(int queryHandle, int flags,
    int dataSize, Pointer data, Pointer<Uint32> bytesWritten);

typedef GlGetPerfQueryIdByNameINTELNative = Void Function(
    Pointer queryName, Pointer<Uint32> queryId);
typedef GlGetPerfQueryIdByNameINTEL = void Function(
    Pointer queryName, Pointer<Uint32> queryId);

typedef GlGetPerfQueryInfoINTELNative = Void Function(
    Uint32 queryId,
    Uint32 queryNameLength,
    Pointer queryName,
    Pointer<Uint32> dataSize,
    Pointer<Uint32> noCounters,
    Pointer<Uint32> noInstances,
    Pointer<Uint32> capsMask);
typedef GlGetPerfQueryInfoINTEL = void Function(
    int queryId,
    int queryNameLength,
    Pointer queryName,
    Pointer<Uint32> dataSize,
    Pointer<Uint32> noCounters,
    Pointer<Uint32> noInstances,
    Pointer<Uint32> capsMask);

//GL_MESA_framebuffer_flip_y
typedef GlFramebufferParameteriMESANative = Void Function(
    Uint32 target, Uint32 pname, Int32 param);
typedef GlFramebufferParameteriMESA = void Function(
    int target, int pname, int param);

typedef GlGetFramebufferParameterivMESANative = Void Function(
    Uint32 target, Uint32 pname, Pointer<Int32> params);
typedef GlGetFramebufferParameterivMESA = void Function(
    int target, int pname, Pointer<Int32> params);

//GL_NV_bindless_multi_draw_indirect
typedef GlMultiDrawArraysIndirectBindlessNVNative = Void Function(Uint32 mode,
    Pointer indirect, Int32 drawCount, Int32 stride, Int32 vertexBufferCount);
typedef GlMultiDrawArraysIndirectBindlessNV = void Function(int mode,
    Pointer indirect, int drawCount, int stride, int vertexBufferCount);

typedef GlMultiDrawElementsIndirectBindlessNVNative = Void Function(
    Uint32 mode,
    Uint32 type,
    Pointer indirect,
    Int32 drawCount,
    Int32 stride,
    Int32 vertexBufferCount);
typedef GlMultiDrawElementsIndirectBindlessNV = void Function(
    int mode,
    int type,
    Pointer indirect,
    int drawCount,
    int stride,
    int vertexBufferCount);

//GL_NV_bindless_multi_draw_indirect_count
typedef GlMultiDrawArraysIndirectBindlessCountNVNative = Void Function(
    Uint32 mode,
    Pointer indirect,
    Int32 drawCount,
    Int32 maxDrawCount,
    Int32 stride,
    Int32 vertexBufferCount);
typedef GlMultiDrawArraysIndirectBindlessCountNV = void Function(
    int mode,
    Pointer indirect,
    int drawCount,
    int maxDrawCount,
    int stride,
    int vertexBufferCount);

typedef GlMultiDrawElementsIndirectBindlessCountNVNative = Void Function(
    Uint32 mode,
    Uint32 type,
    Pointer indirect,
    Int32 drawCount,
    Int32 maxDrawCount,
    Int32 stride,
    Int32 vertexBufferCount);
typedef GlMultiDrawElementsIndirectBindlessCountNV = void Function(
    int mode,
    int type,
    Pointer indirect,
    int drawCount,
    int maxDrawCount,
    int stride,
    int vertexBufferCount);

//GL_NV_bindless_texture
typedef GlGetTextureHandleNVNative = Uint64 Function(Uint32 texture);
typedef GlGetTextureHandleNV = int Function(int texture);

typedef GlGetTextureSamplerHandleNVNative = Uint64 Function(
    Uint32 texture, Uint32 sampler);
typedef GlGetTextureSamplerHandleNV = int Function(int texture, int sampler);

typedef GlMakeTextureHandleResidentNVNative = Void Function(Uint64 handle);
typedef GlMakeTextureHandleResidentNV = void Function(int handle);

typedef GlMakeTextureHandleNonResidentNVNative = Void Function(Uint64 handle);
typedef GlMakeTextureHandleNonResidentNV = void Function(int handle);

typedef GlGetImageHandleNVNative = Uint64 Function(
    Uint32 texture, Int32 level, Uint8 layered, Int32 layer, Uint32 format);
typedef GlGetImageHandleNV = int Function(
    int texture, int level, int layered, int layer, int format);

typedef GlMakeImageHandleResidentNVNative = Void Function(
    Uint64 handle, Uint32 access);
typedef GlMakeImageHandleResidentNV = void Function(int handle, int access);

typedef GlMakeImageHandleNonResidentNVNative = Void Function(Uint64 handle);
typedef GlMakeImageHandleNonResidentNV = void Function(int handle);

typedef GlUniformHandleui64NVNative = Void Function(
    Int32 location, Uint64 value);
typedef GlUniformHandleui64NV = void Function(int location, int value);

typedef GlUniformHandleui64vNVNative = Void Function(
    Int32 location, Int32 count, Pointer<Uint64> value);
typedef GlUniformHandleui64vNV = void Function(
    int location, int count, Pointer<Uint64> value);

typedef GlProgramUniformHandleui64NVNative = Void Function(
    Uint32 program, Int32 location, Uint64 value);
typedef GlProgramUniformHandleui64NV = void Function(
    int program, int location, int value);

typedef GlProgramUniformHandleui64vNVNative = Void Function(
    Uint32 program, Int32 location, Int32 count, Pointer<Uint64> values);
typedef GlProgramUniformHandleui64vNV = void Function(
    int program, int location, int count, Pointer<Uint64> values);

typedef GlIsTextureHandleResidentNVNative = Uint8 Function(Uint64 handle);
typedef GlIsTextureHandleResidentNV = int Function(int handle);

typedef GlIsImageHandleResidentNVNative = Uint8 Function(Uint64 handle);
typedef GlIsImageHandleResidentNV = int Function(int handle);

//GL_NV_blend_equation_advanced
typedef GlBlendParameteriNVNative = Void Function(Uint32 pname, Int32 value);
typedef GlBlendParameteriNV = void Function(int pname, int value);

typedef GlBlendBarrierNVNative = Void Function();
typedef GlBlendBarrierNV = void Function();

//GL_NV_clip_space_w_scaling
typedef GlViewportPositionWScaleNVNative = Void Function(
    Uint32 index, Float xcoeff, Float ycoeff);
typedef GlViewportPositionWScaleNV = void Function(
    int index, double xcoeff, double ycoeff);

//GL_NV_command_list
typedef GlCreateStatesNVNative = Void Function(Int32 n, Pointer<Uint32> states);
typedef GlCreateStatesNV = void Function(int n, Pointer<Uint32> states);

typedef GlDeleteStatesNVNative = Void Function(Int32 n, Pointer<Uint32> states);
typedef GlDeleteStatesNV = void Function(int n, Pointer<Uint32> states);

typedef GlIsStateNVNative = Uint8 Function(Uint32 state);
typedef GlIsStateNV = int Function(int state);

typedef GlStateCaptureNVNative = Void Function(Uint32 state, Uint32 mode);
typedef GlStateCaptureNV = void Function(int state, int mode);

typedef GlGetCommandHeaderNVNative = Uint32 Function(
    Uint32 tokenID, Uint32 size);
typedef GlGetCommandHeaderNV = int Function(int tokenID, int size);

typedef GlGetStageIndexNVNative = Uint16 Function(Uint32 shadertype);
typedef GlGetStageIndexNV = int Function(int shadertype);

typedef GlDrawCommandsNVNative = Void Function(
    Uint32 primitiveMode,
    Uint32 buffer,
    Pointer<Int64> indirects,
    Pointer<Int32> sizes,
    Uint32 count);
typedef GlDrawCommandsNV = void Function(int primitiveMode, int buffer,
    Pointer<Int64> indirects, Pointer<Int32> sizes, int count);

typedef GlDrawCommandsAddressNVNative = Void Function(Uint32 primitiveMode,
    Pointer<Uint64> indirects, Pointer<Int32> sizes, Uint32 count);
typedef GlDrawCommandsAddressNV = void Function(int primitiveMode,
    Pointer<Uint64> indirects, Pointer<Int32> sizes, int count);

typedef GlDrawCommandsStatesNVNative = Void Function(
    Uint32 buffer,
    Pointer<Int64> indirects,
    Pointer<Int32> sizes,
    Pointer<Uint32> states,
    Pointer<Uint32> fbos,
    Uint32 count);
typedef GlDrawCommandsStatesNV = void Function(
    int buffer,
    Pointer<Int64> indirects,
    Pointer<Int32> sizes,
    Pointer<Uint32> states,
    Pointer<Uint32> fbos,
    int count);

typedef GlDrawCommandsStatesAddressNVNative = Void Function(
    Pointer<Uint64> indirects,
    Pointer<Int32> sizes,
    Pointer<Uint32> states,
    Pointer<Uint32> fbos,
    Uint32 count);
typedef GlDrawCommandsStatesAddressNV = void Function(
    Pointer<Uint64> indirects,
    Pointer<Int32> sizes,
    Pointer<Uint32> states,
    Pointer<Uint32> fbos,
    int count);

typedef GlCreateCommandListsNVNative = Void Function(
    Int32 n, Pointer<Uint32> lists);
typedef GlCreateCommandListsNV = void Function(int n, Pointer<Uint32> lists);

typedef GlDeleteCommandListsNVNative = Void Function(
    Int32 n, Pointer<Uint32> lists);
typedef GlDeleteCommandListsNV = void Function(int n, Pointer<Uint32> lists);

typedef GlIsCommandListNVNative = Uint8 Function(Uint32 list);
typedef GlIsCommandListNV = int Function(int list);

typedef GlListDrawCommandsStatesClientNVNative = Void Function(
    Uint32 list,
    Uint32 segment,
    Pointer indirects,
    Pointer<Int32> sizes,
    Pointer<Uint32> states,
    Pointer<Uint32> fbos,
    Uint32 count);
typedef GlListDrawCommandsStatesClientNV = void Function(
    int list,
    int segment,
    Pointer indirects,
    Pointer<Int32> sizes,
    Pointer<Uint32> states,
    Pointer<Uint32> fbos,
    int count);

typedef GlCommandListSegmentsNVNative = Void Function(
    Uint32 list, Uint32 segments);
typedef GlCommandListSegmentsNV = void Function(int list, int segments);

typedef GlCompileCommandListNVNative = Void Function(Uint32 list);
typedef GlCompileCommandListNV = void Function(int list);

typedef GlCallCommandListNVNative = Void Function(Uint32 list);
typedef GlCallCommandListNV = void Function(int list);

//GL_NV_conditional_render
typedef GlBeginConditionalRenderNVNative = Void Function(
    Uint32 id, Uint32 mode);
typedef GlBeginConditionalRenderNV = void Function(int id, int mode);

typedef GlEndConditionalRenderNVNative = Void Function();
typedef GlEndConditionalRenderNV = void Function();

//GL_NV_conservative_raster
typedef GlSubpixelPrecisionBiasNVNative = Void Function(
    Uint32 xbits, Uint32 ybits);
typedef GlSubpixelPrecisionBiasNV = void Function(int xbits, int ybits);

//GL_NV_conservative_raster_dilate
typedef GlConservativeRasterParameterfNVNative = Void Function(
    Uint32 pname, Float value);
typedef GlConservativeRasterParameterfNV = void Function(
    int pname, double value);

//GL_NV_conservative_raster_pre_snap_triangles
typedef GlConservativeRasterParameteriNVNative = Void Function(
    Uint32 pname, Int32 param);
typedef GlConservativeRasterParameteriNV = void Function(int pname, int param);

//GL_NV_depth_buffer_float
typedef GlDepthRangedNVNative = Void Function(Double zNear, Double zFar);
typedef GlDepthRangedNV = void Function(double zNear, double zFar);

typedef GlClearDepthdNVNative = Void Function(Double depth);
typedef GlClearDepthdNV = void Function(double depth);

typedef GlDepthBoundsdNVNative = Void Function(Double zmin, Double zmax);
typedef GlDepthBoundsdNV = void Function(double zmin, double zmax);

//GL_NV_draw_vulkan_image
typedef GlDrawVkImageNVNative = Void Function(
    Uint64 vkImage,
    Uint32 sampler,
    Float x0,
    Float y0,
    Float x1,
    Float y1,
    Float z,
    Float s0,
    Float t0,
    Float s1,
    Float t1);
typedef GlDrawVkImageNV = void Function(
    int vkImage,
    int sampler,
    double x0,
    double y0,
    double x1,
    double y1,
    double z,
    double s0,
    double t0,
    double s1,
    double t1);

typedef GlGetVkProcAddrNVNative = Pointer Function(Pointer name);
typedef GlGetVkProcAddrNV = Pointer Function(/*String*/ Pointer name);

typedef GlWaitVkSemaphoreNVNative = Void Function(Uint64 vkSemaphore);
typedef GlWaitVkSemaphoreNV = void Function(int vkSemaphore);

typedef GlSignalVkSemaphoreNVNative = Void Function(Uint64 vkSemaphore);
typedef GlSignalVkSemaphoreNV = void Function(int vkSemaphore);

typedef GlSignalVkFenceNVNative = Void Function(Uint64 vkFence);
typedef GlSignalVkFenceNV = void Function(int vkFence);

//GL_NV_fragment_coverage_to_color
typedef GlFragmentCoverageColorNVNative = Void Function(Uint32 color);
typedef GlFragmentCoverageColorNV = void Function(int color);

//GL_NV_framebuffer_mixed_samples
typedef GlCoverageModulationTableNVNative = Void Function(
    Int32 n, Pointer<Float> v);
typedef GlCoverageModulationTableNV = void Function(int n, Pointer<Float> v);

typedef GlGetCoverageModulationTableNVNative = Void Function(
    Int32 bufSize, Pointer<Float> v);
typedef GlGetCoverageModulationTableNV = void Function(
    int bufSize, Pointer<Float> v);

typedef GlCoverageModulationNVNative = Void Function(Uint32 components);
typedef GlCoverageModulationNV = void Function(int components);

//GL_NV_framebuffer_multisample_coverage
typedef GlRenderbufferStorageMultisampleCoverageNVNative = Void Function(
    Uint32 target,
    Int32 coverageSamples,
    Int32 colorSamples,
    Uint32 internalformat,
    Int32 width,
    Int32 height);
typedef GlRenderbufferStorageMultisampleCoverageNV = void Function(
    int target,
    int coverageSamples,
    int colorSamples,
    int internalformat,
    int width,
    int height);

//GL_NV_gpu_shader5
typedef GlUniform1i64NVNative = Void Function(Int32 location, Int64 x);
typedef GlUniform1i64NV = void Function(int location, int x);

typedef GlUniform2i64NVNative = Void Function(Int32 location, Int64 x, Int64 y);
typedef GlUniform2i64NV = void Function(int location, int x, int y);

typedef GlUniform3i64NVNative = Void Function(
    Int32 location, Int64 x, Int64 y, Int64 z);
typedef GlUniform3i64NV = void Function(int location, int x, int y, int z);

typedef GlUniform4i64NVNative = Void Function(
    Int32 location, Int64 x, Int64 y, Int64 z, Int64 w);
typedef GlUniform4i64NV = void Function(
    int location, int x, int y, int z, int w);

typedef GlUniform1i64vNVNative = Void Function(
    Int32 location, Int32 count, Pointer<Int64> value);
typedef GlUniform1i64vNV = void Function(
    int location, int count, Pointer<Int64> value);

typedef GlUniform2i64vNVNative = Void Function(
    Int32 location, Int32 count, Pointer<Int64> value);
typedef GlUniform2i64vNV = void Function(
    int location, int count, Pointer<Int64> value);

typedef GlUniform3i64vNVNative = Void Function(
    Int32 location, Int32 count, Pointer<Int64> value);
typedef GlUniform3i64vNV = void Function(
    int location, int count, Pointer<Int64> value);

typedef GlUniform4i64vNVNative = Void Function(
    Int32 location, Int32 count, Pointer<Int64> value);
typedef GlUniform4i64vNV = void Function(
    int location, int count, Pointer<Int64> value);

typedef GlUniform1ui64NVNative = Void Function(Int32 location, Uint64 x);
typedef GlUniform1ui64NV = void Function(int location, int x);

typedef GlUniform2ui64NVNative = Void Function(
    Int32 location, Uint64 x, Uint64 y);
typedef GlUniform2ui64NV = void Function(int location, int x, int y);

typedef GlUniform3ui64NVNative = Void Function(
    Int32 location, Uint64 x, Uint64 y, Uint64 z);
typedef GlUniform3ui64NV = void Function(int location, int x, int y, int z);

typedef GlUniform4ui64NVNative = Void Function(
    Int32 location, Uint64 x, Uint64 y, Uint64 z, Uint64 w);
typedef GlUniform4ui64NV = void Function(
    int location, int x, int y, int z, int w);

typedef GlUniform1ui64vNVNative = Void Function(
    Int32 location, Int32 count, Pointer<Uint64> value);
typedef GlUniform1ui64vNV = void Function(
    int location, int count, Pointer<Uint64> value);

typedef GlUniform2ui64vNVNative = Void Function(
    Int32 location, Int32 count, Pointer<Uint64> value);
typedef GlUniform2ui64vNV = void Function(
    int location, int count, Pointer<Uint64> value);

typedef GlUniform3ui64vNVNative = Void Function(
    Int32 location, Int32 count, Pointer<Uint64> value);
typedef GlUniform3ui64vNV = void Function(
    int location, int count, Pointer<Uint64> value);

typedef GlUniform4ui64vNVNative = Void Function(
    Int32 location, Int32 count, Pointer<Uint64> value);
typedef GlUniform4ui64vNV = void Function(
    int location, int count, Pointer<Uint64> value);

typedef GlGetUniformi64vNVNative = Void Function(
    Uint32 program, Int32 location, Pointer<Int64> params);
typedef GlGetUniformi64vNV = void Function(
    int program, int location, Pointer<Int64> params);

typedef GlProgramUniform1i64NVNative = Void Function(
    Uint32 program, Int32 location, Int64 x);
typedef GlProgramUniform1i64NV = void Function(
    int program, int location, int x);

typedef GlProgramUniform2i64NVNative = Void Function(
    Uint32 program, Int32 location, Int64 x, Int64 y);
typedef GlProgramUniform2i64NV = void Function(
    int program, int location, int x, int y);

typedef GlProgramUniform3i64NVNative = Void Function(
    Uint32 program, Int32 location, Int64 x, Int64 y, Int64 z);
typedef GlProgramUniform3i64NV = void Function(
    int program, int location, int x, int y, int z);

typedef GlProgramUniform4i64NVNative = Void Function(
    Uint32 program, Int32 location, Int64 x, Int64 y, Int64 z, Int64 w);
typedef GlProgramUniform4i64NV = void Function(
    int program, int location, int x, int y, int z, int w);

typedef GlProgramUniform1i64vNVNative = Void Function(
    Uint32 program, Int32 location, Int32 count, Pointer<Int64> value);
typedef GlProgramUniform1i64vNV = void Function(
    int program, int location, int count, Pointer<Int64> value);

typedef GlProgramUniform2i64vNVNative = Void Function(
    Uint32 program, Int32 location, Int32 count, Pointer<Int64> value);
typedef GlProgramUniform2i64vNV = void Function(
    int program, int location, int count, Pointer<Int64> value);

typedef GlProgramUniform3i64vNVNative = Void Function(
    Uint32 program, Int32 location, Int32 count, Pointer<Int64> value);
typedef GlProgramUniform3i64vNV = void Function(
    int program, int location, int count, Pointer<Int64> value);

typedef GlProgramUniform4i64vNVNative = Void Function(
    Uint32 program, Int32 location, Int32 count, Pointer<Int64> value);
typedef GlProgramUniform4i64vNV = void Function(
    int program, int location, int count, Pointer<Int64> value);

typedef GlProgramUniform1ui64NVNative = Void Function(
    Uint32 program, Int32 location, Uint64 x);
typedef GlProgramUniform1ui64NV = void Function(
    int program, int location, int x);

typedef GlProgramUniform2ui64NVNative = Void Function(
    Uint32 program, Int32 location, Uint64 x, Uint64 y);
typedef GlProgramUniform2ui64NV = void Function(
    int program, int location, int x, int y);

typedef GlProgramUniform3ui64NVNative = Void Function(
    Uint32 program, Int32 location, Uint64 x, Uint64 y, Uint64 z);
typedef GlProgramUniform3ui64NV = void Function(
    int program, int location, int x, int y, int z);

typedef GlProgramUniform4ui64NVNative = Void Function(
    Uint32 program, Int32 location, Uint64 x, Uint64 y, Uint64 z, Uint64 w);
typedef GlProgramUniform4ui64NV = void Function(
    int program, int location, int x, int y, int z, int w);

typedef GlProgramUniform1ui64vNVNative = Void Function(
    Uint32 program, Int32 location, Int32 count, Pointer<Uint64> value);
typedef GlProgramUniform1ui64vNV = void Function(
    int program, int location, int count, Pointer<Uint64> value);

typedef GlProgramUniform2ui64vNVNative = Void Function(
    Uint32 program, Int32 location, Int32 count, Pointer<Uint64> value);
typedef GlProgramUniform2ui64vNV = void Function(
    int program, int location, int count, Pointer<Uint64> value);

typedef GlProgramUniform3ui64vNVNative = Void Function(
    Uint32 program, Int32 location, Int32 count, Pointer<Uint64> value);
typedef GlProgramUniform3ui64vNV = void Function(
    int program, int location, int count, Pointer<Uint64> value);

typedef GlProgramUniform4ui64vNVNative = Void Function(
    Uint32 program, Int32 location, Int32 count, Pointer<Uint64> value);
typedef GlProgramUniform4ui64vNV = void Function(
    int program, int location, int count, Pointer<Uint64> value);

//GL_NV_internalformat_sample_query
typedef GlGetInternalformatSampleivNVNative = Void Function(
    Uint32 target,
    Uint32 internalformat,
    Int32 samples,
    Uint32 pname,
    Int32 count,
    Pointer<Int32> params);
typedef GlGetInternalformatSampleivNV = void Function(
    int target,
    int internalformat,
    int samples,
    int pname,
    int count,
    Pointer<Int32> params);

//GL_NV_memory_attachment
typedef GlGetMemoryObjectDetachedResourcesuivNVNative = Void Function(
    Uint32 memory,
    Uint32 pname,
    Int32 first,
    Int32 count,
    Pointer<Uint32> params);
typedef GlGetMemoryObjectDetachedResourcesuivNV = void Function(
    int memory, int pname, int first, int count, Pointer<Uint32> params);

typedef GlResetMemoryObjectParameterNVNative = Void Function(
    Uint32 memory, Uint32 pname);
typedef GlResetMemoryObjectParameterNV = void Function(int memory, int pname);

typedef GlTexAttachMemoryNVNative = Void Function(
    Uint32 target, Uint32 memory, Uint64 offset);
typedef GlTexAttachMemoryNV = void Function(int target, int memory, int offset);

typedef GlBufferAttachMemoryNVNative = Void Function(
    Uint32 target, Uint32 memory, Uint64 offset);
typedef GlBufferAttachMemoryNV = void Function(
    int target, int memory, int offset);

typedef GlTextureAttachMemoryNVNative = Void Function(
    Uint32 texture, Uint32 memory, Uint64 offset);
typedef GlTextureAttachMemoryNV = void Function(
    int texture, int memory, int offset);

typedef GlNamedBufferAttachMemoryNVNative = Void Function(
    Uint32 buffer, Uint32 memory, Uint64 offset);
typedef GlNamedBufferAttachMemoryNV = void Function(
    int buffer, int memory, int offset);

//GL_NV_memory_object_sparse
typedef GlBufferPageCommitmentMemNVNative = Void Function(Uint32 target,
    Int64 offset, Int64 size, Uint32 memory, Uint64 memOffset, Uint8 commit);
typedef GlBufferPageCommitmentMemNV = void Function(
    int target, int offset, int size, int memory, int memOffset, int commit);

typedef GlTexPageCommitmentMemNVNative = Void Function(
    Uint32 target,
    Int32 layer,
    Int32 level,
    Int32 xoffset,
    Int32 yoffset,
    Int32 zoffset,
    Int32 width,
    Int32 height,
    Int32 depth,
    Uint32 memory,
    Uint64 offset,
    Uint8 commit);
typedef GlTexPageCommitmentMemNV = void Function(
    int target,
    int layer,
    int level,
    int xoffset,
    int yoffset,
    int zoffset,
    int width,
    int height,
    int depth,
    int memory,
    int offset,
    int commit);

typedef GlNamedBufferPageCommitmentMemNVNative = Void Function(Uint32 buffer,
    Int64 offset, Int64 size, Uint32 memory, Uint64 memOffset, Uint8 commit);
typedef GlNamedBufferPageCommitmentMemNV = void Function(
    int buffer, int offset, int size, int memory, int memOffset, int commit);

typedef GlTexturePageCommitmentMemNVNative = Void Function(
    Uint32 texture,
    Int32 layer,
    Int32 level,
    Int32 xoffset,
    Int32 yoffset,
    Int32 zoffset,
    Int32 width,
    Int32 height,
    Int32 depth,
    Uint32 memory,
    Uint64 offset,
    Uint8 commit);
typedef GlTexturePageCommitmentMemNV = void Function(
    int texture,
    int layer,
    int level,
    int xoffset,
    int yoffset,
    int zoffset,
    int width,
    int height,
    int depth,
    int memory,
    int offset,
    int commit);

//GL_NV_mesh_shader
typedef GlDrawMeshTasksNVNative = Void Function(Uint32 first, Uint32 count);
typedef GlDrawMeshTasksNV = void Function(int first, int count);

typedef GlDrawMeshTasksIndirectNVNative = Void Function(Int64 indirect);
typedef GlDrawMeshTasksIndirectNV = void Function(int indirect);

typedef GlMultiDrawMeshTasksIndirectNVNative = Void Function(
    Int64 indirect, Int32 drawcount, Int32 stride);
typedef GlMultiDrawMeshTasksIndirectNV = void Function(
    int indirect, int drawcount, int stride);

typedef GlMultiDrawMeshTasksIndirectCountNVNative = Void Function(
    Int64 indirect, Int64 drawcount, Int32 maxdrawcount, Int32 stride);
typedef GlMultiDrawMeshTasksIndirectCountNV = void Function(
    int indirect, int drawcount, int maxdrawcount, int stride);

//GL_NV_path_rendering
typedef GlGenPathsNVNative = Uint32 Function(Int32 range);
typedef GlGenPathsNV = int Function(int range);

typedef GlDeletePathsNVNative = Void Function(Uint32 path, Int32 range);
typedef GlDeletePathsNV = void Function(int path, int range);

typedef GlIsPathNVNative = Uint8 Function(Uint32 path);
typedef GlIsPathNV = int Function(int path);

typedef GlPathCommandsNVNative = Void Function(Uint32 path, Int32 numCommands,
    Pointer commands, Int32 numCoords, Uint32 coordType, Pointer coords);
typedef GlPathCommandsNV = void Function(int path, int numCommands,
    /*String*/ Pointer commands, int numCoords, int coordType, Pointer coords);

typedef GlPathCoordsNVNative = Void Function(
    Uint32 path, Int32 numCoords, Uint32 coordType, Pointer coords);
typedef GlPathCoordsNV = void Function(
    int path, int numCoords, int coordType, Pointer coords);

typedef GlPathSubCommandsNVNative = Void Function(
    Uint32 path,
    Int32 commandStart,
    Int32 commandsToDelete,
    Int32 numCommands,
    Pointer commands,
    Int32 numCoords,
    Uint32 coordType,
    Pointer coords);
typedef GlPathSubCommandsNV = void Function(
    int path,
    int commandStart,
    int commandsToDelete,
    int numCommands,
    /*String*/ Pointer commands,
    int numCoords,
    int coordType,
    Pointer coords);

typedef GlPathSubCoordsNVNative = Void Function(Uint32 path, Int32 coordStart,
    Int32 numCoords, Uint32 coordType, Pointer coords);
typedef GlPathSubCoordsNV = void Function(
    int path, int coordStart, int numCoords, int coordType, Pointer coords);

typedef GlPathStringNVNative = Void Function(
    Uint32 path, Uint32 format, Int32 length, Pointer pathString);
typedef GlPathStringNV = void Function(
    int path, int format, int length, Pointer pathString);

typedef GlPathGlyphsNVNative = Void Function(
    Uint32 firstPathName,
    Uint32 fontTarget,
    Pointer fontName,
    Uint32 fontStyle,
    Int32 numGlyphs,
    Uint32 type,
    Pointer charcodes,
    Uint32 handleMissingGlyphs,
    Uint32 pathParameterTemplate,
    Float emScale);
typedef GlPathGlyphsNV = void Function(
    int firstPathName,
    int fontTarget,
    Pointer fontName,
    int fontStyle,
    int numGlyphs,
    int type,
    Pointer charcodes,
    int handleMissingGlyphs,
    int pathParameterTemplate,
    double emScale);

typedef GlPathGlyphRangeNVNative = Void Function(
    Uint32 firstPathName,
    Uint32 fontTarget,
    Pointer fontName,
    Uint32 fontStyle,
    Uint32 firstGlyph,
    Int32 numGlyphs,
    Uint32 handleMissingGlyphs,
    Uint32 pathParameterTemplate,
    Float emScale);
typedef GlPathGlyphRangeNV = void Function(
    int firstPathName,
    int fontTarget,
    Pointer fontName,
    int fontStyle,
    int firstGlyph,
    int numGlyphs,
    int handleMissingGlyphs,
    int pathParameterTemplate,
    double emScale);

typedef GlWeightPathsNVNative = Void Function(Uint32 resultPath, Int32 numPaths,
    Pointer<Uint32> paths, Pointer<Float> weights);
typedef GlWeightPathsNV = void Function(int resultPath, int numPaths,
    Pointer<Uint32> paths, Pointer<Float> weights);

typedef GlCopyPathNVNative = Void Function(Uint32 resultPath, Uint32 srcPath);
typedef GlCopyPathNV = void Function(int resultPath, int srcPath);

typedef GlInterpolatePathsNVNative = Void Function(
    Uint32 resultPath, Uint32 pathA, Uint32 pathB, Float weight);
typedef GlInterpolatePathsNV = void Function(
    int resultPath, int pathA, int pathB, double weight);

typedef GlTransformPathNVNative = Void Function(Uint32 resultPath,
    Uint32 srcPath, Uint32 transformType, Pointer<Float> transformValues);
typedef GlTransformPathNV = void Function(int resultPath, int srcPath,
    int transformType, Pointer<Float> transformValues);

typedef GlPathParameterivNVNative = Void Function(
    Uint32 path, Uint32 pname, Pointer<Int32> value);
typedef GlPathParameterivNV = void Function(
    int path, int pname, Pointer<Int32> value);

typedef GlPathParameteriNVNative = Void Function(
    Uint32 path, Uint32 pname, Int32 value);
typedef GlPathParameteriNV = void Function(int path, int pname, int value);

typedef GlPathParameterfvNVNative = Void Function(
    Uint32 path, Uint32 pname, Pointer<Float> value);
typedef GlPathParameterfvNV = void Function(
    int path, int pname, Pointer<Float> value);

typedef GlPathParameterfNVNative = Void Function(
    Uint32 path, Uint32 pname, Float value);
typedef GlPathParameterfNV = void Function(int path, int pname, double value);

typedef GlPathDashArrayNVNative = Void Function(
    Uint32 path, Int32 dashCount, Pointer<Float> dashArray);
typedef GlPathDashArrayNV = void Function(
    int path, int dashCount, Pointer<Float> dashArray);

typedef GlPathStencilFuncNVNative = Void Function(
    Uint32 func, Int32 ref, Uint32 mask);
typedef GlPathStencilFuncNV = void Function(int func, int ref, int mask);

typedef GlPathStencilDepthOffsetNVNative = Void Function(
    Float factor, Float units);
typedef GlPathStencilDepthOffsetNV = void Function(double factor, double units);

typedef GlStencilFillPathNVNative = Void Function(
    Uint32 path, Uint32 fillMode, Uint32 mask);
typedef GlStencilFillPathNV = void Function(int path, int fillMode, int mask);

typedef GlStencilStrokePathNVNative = Void Function(
    Uint32 path, Int32 reference, Uint32 mask);
typedef GlStencilStrokePathNV = void Function(
    int path, int reference, int mask);

typedef GlStencilFillPathInstancedNVNative = Void Function(
    Int32 numPaths,
    Uint32 pathNameType,
    Pointer paths,
    Uint32 pathBase,
    Uint32 fillMode,
    Uint32 mask,
    Uint32 transformType,
    Pointer<Float> transformValues);
typedef GlStencilFillPathInstancedNV = void Function(
    int numPaths,
    int pathNameType,
    Pointer paths,
    int pathBase,
    int fillMode,
    int mask,
    int transformType,
    Pointer<Float> transformValues);

typedef GlStencilStrokePathInstancedNVNative = Void Function(
    Int32 numPaths,
    Uint32 pathNameType,
    Pointer paths,
    Uint32 pathBase,
    Int32 reference,
    Uint32 mask,
    Uint32 transformType,
    Pointer<Float> transformValues);
typedef GlStencilStrokePathInstancedNV = void Function(
    int numPaths,
    int pathNameType,
    Pointer paths,
    int pathBase,
    int reference,
    int mask,
    int transformType,
    Pointer<Float> transformValues);

typedef GlPathCoverDepthFuncNVNative = Void Function(Uint32 func);
typedef GlPathCoverDepthFuncNV = void Function(int func);

typedef GlCoverFillPathNVNative = Void Function(Uint32 path, Uint32 coverMode);
typedef GlCoverFillPathNV = void Function(int path, int coverMode);

typedef GlCoverStrokePathNVNative = Void Function(
    Uint32 path, Uint32 coverMode);
typedef GlCoverStrokePathNV = void Function(int path, int coverMode);

typedef GlCoverFillPathInstancedNVNative = Void Function(
    Int32 numPaths,
    Uint32 pathNameType,
    Pointer paths,
    Uint32 pathBase,
    Uint32 coverMode,
    Uint32 transformType,
    Pointer<Float> transformValues);
typedef GlCoverFillPathInstancedNV = void Function(
    int numPaths,
    int pathNameType,
    Pointer paths,
    int pathBase,
    int coverMode,
    int transformType,
    Pointer<Float> transformValues);

typedef GlCoverStrokePathInstancedNVNative = Void Function(
    Int32 numPaths,
    Uint32 pathNameType,
    Pointer paths,
    Uint32 pathBase,
    Uint32 coverMode,
    Uint32 transformType,
    Pointer<Float> transformValues);
typedef GlCoverStrokePathInstancedNV = void Function(
    int numPaths,
    int pathNameType,
    Pointer paths,
    int pathBase,
    int coverMode,
    int transformType,
    Pointer<Float> transformValues);

typedef GlGetPathParameterivNVNative = Void Function(
    Uint32 path, Uint32 pname, Pointer<Int32> value);
typedef GlGetPathParameterivNV = void Function(
    int path, int pname, Pointer<Int32> value);

typedef GlGetPathParameterfvNVNative = Void Function(
    Uint32 path, Uint32 pname, Pointer<Float> value);
typedef GlGetPathParameterfvNV = void Function(
    int path, int pname, Pointer<Float> value);

typedef GlGetPathCommandsNVNative = Void Function(
    Uint32 path, Pointer<Uint8> commands);
typedef GlGetPathCommandsNV = void Function(int path, Pointer<Uint8> commands);

typedef GlGetPathCoordsNVNative = Void Function(
    Uint32 path, Pointer<Float> coords);
typedef GlGetPathCoordsNV = void Function(int path, Pointer<Float> coords);

typedef GlGetPathDashArrayNVNative = Void Function(
    Uint32 path, Pointer<Float> dashArray);
typedef GlGetPathDashArrayNV = void Function(
    int path, Pointer<Float> dashArray);

typedef GlGetPathMetricsNVNative = Void Function(
    Uint32 metricQueryMask,
    Int32 numPaths,
    Uint32 pathNameType,
    Pointer paths,
    Uint32 pathBase,
    Int32 stride,
    Pointer<Float> metrics);
typedef GlGetPathMetricsNV = void Function(
    int metricQueryMask,
    int numPaths,
    int pathNameType,
    Pointer paths,
    int pathBase,
    int stride,
    Pointer<Float> metrics);

typedef GlGetPathMetricRangeNVNative = Void Function(Uint32 metricQueryMask,
    Uint32 firstPathName, Int32 numPaths, Int32 stride, Pointer<Float> metrics);
typedef GlGetPathMetricRangeNV = void Function(int metricQueryMask,
    int firstPathName, int numPaths, int stride, Pointer<Float> metrics);

typedef GlGetPathSpacingNVNative = Void Function(
    Uint32 pathListMode,
    Int32 numPaths,
    Uint32 pathNameType,
    Pointer paths,
    Uint32 pathBase,
    Float advanceScale,
    Float kerningScale,
    Uint32 transformType,
    Pointer<Float> returnedSpacing);
typedef GlGetPathSpacingNV = void Function(
    int pathListMode,
    int numPaths,
    int pathNameType,
    Pointer paths,
    int pathBase,
    double advanceScale,
    double kerningScale,
    int transformType,
    Pointer<Float> returnedSpacing);

typedef GlIsPointInFillPathNVNative = Uint8 Function(
    Uint32 path, Uint32 mask, Float x, Float y);
typedef GlIsPointInFillPathNV = int Function(
    int path, int mask, double x, double y);

typedef GlIsPointInStrokePathNVNative = Uint8 Function(
    Uint32 path, Float x, Float y);
typedef GlIsPointInStrokePathNV = int Function(int path, double x, double y);

typedef GlGetPathLengthNVNative = Float Function(
    Uint32 path, Int32 startSegment, Int32 numSegments);
typedef GlGetPathLengthNV = double Function(
    int path, int startSegment, int numSegments);

typedef GlPointAlongPathNVNative = Uint8 Function(
    Uint32 path,
    Int32 startSegment,
    Int32 numSegments,
    Float distance,
    Pointer<Float> x,
    Pointer<Float> y,
    Pointer<Float> tangentX,
    Pointer<Float> tangentY);
typedef GlPointAlongPathNV = int Function(
    int path,
    int startSegment,
    int numSegments,
    double distance,
    Pointer<Float> x,
    Pointer<Float> y,
    Pointer<Float> tangentX,
    Pointer<Float> tangentY);

typedef GlMatrixLoad3x2fNVNative = Void Function(
    Uint32 matrixMode, Pointer<Float> m);
typedef GlMatrixLoad3x2fNV = void Function(int matrixMode, Pointer<Float> m);

typedef GlMatrixLoad3x3fNVNative = Void Function(
    Uint32 matrixMode, Pointer<Float> m);
typedef GlMatrixLoad3x3fNV = void Function(int matrixMode, Pointer<Float> m);

typedef GlMatrixLoadTranspose3x3fNVNative = Void Function(
    Uint32 matrixMode, Pointer<Float> m);
typedef GlMatrixLoadTranspose3x3fNV = void Function(
    int matrixMode, Pointer<Float> m);

typedef GlMatrixMult3x2fNVNative = Void Function(
    Uint32 matrixMode, Pointer<Float> m);
typedef GlMatrixMult3x2fNV = void Function(int matrixMode, Pointer<Float> m);

typedef GlMatrixMult3x3fNVNative = Void Function(
    Uint32 matrixMode, Pointer<Float> m);
typedef GlMatrixMult3x3fNV = void Function(int matrixMode, Pointer<Float> m);

typedef GlMatrixMultTranspose3x3fNVNative = Void Function(
    Uint32 matrixMode, Pointer<Float> m);
typedef GlMatrixMultTranspose3x3fNV = void Function(
    int matrixMode, Pointer<Float> m);

typedef GlStencilThenCoverFillPathNVNative = Void Function(
    Uint32 path, Uint32 fillMode, Uint32 mask, Uint32 coverMode);
typedef GlStencilThenCoverFillPathNV = void Function(
    int path, int fillMode, int mask, int coverMode);

typedef GlStencilThenCoverStrokePathNVNative = Void Function(
    Uint32 path, Int32 reference, Uint32 mask, Uint32 coverMode);
typedef GlStencilThenCoverStrokePathNV = void Function(
    int path, int reference, int mask, int coverMode);

typedef GlStencilThenCoverFillPathInstancedNVNative = Void Function(
    Int32 numPaths,
    Uint32 pathNameType,
    Pointer paths,
    Uint32 pathBase,
    Uint32 fillMode,
    Uint32 mask,
    Uint32 coverMode,
    Uint32 transformType,
    Pointer<Float> transformValues);
typedef GlStencilThenCoverFillPathInstancedNV = void Function(
    int numPaths,
    int pathNameType,
    Pointer paths,
    int pathBase,
    int fillMode,
    int mask,
    int coverMode,
    int transformType,
    Pointer<Float> transformValues);

typedef GlStencilThenCoverStrokePathInstancedNVNative = Void Function(
    Int32 numPaths,
    Uint32 pathNameType,
    Pointer paths,
    Uint32 pathBase,
    Int32 reference,
    Uint32 mask,
    Uint32 coverMode,
    Uint32 transformType,
    Pointer<Float> transformValues);
typedef GlStencilThenCoverStrokePathInstancedNV = void Function(
    int numPaths,
    int pathNameType,
    Pointer paths,
    int pathBase,
    int reference,
    int mask,
    int coverMode,
    int transformType,
    Pointer<Float> transformValues);

typedef GlPathGlyphIndexRangeNVNative = Uint32 Function(
    Uint32 fontTarget,
    Pointer fontName,
    Uint32 fontStyle,
    Uint32 pathParameterTemplate,
    Float emScale,
    Pointer<Uint32> baseAndCount);
typedef GlPathGlyphIndexRangeNV = int Function(
    int fontTarget,
    Pointer fontName,
    int fontStyle,
    int pathParameterTemplate,
    double emScale,
    Pointer<Uint32> baseAndCount);

typedef GlPathGlyphIndexArrayNVNative = Uint32 Function(
    Uint32 firstPathName,
    Uint32 fontTarget,
    Pointer fontName,
    Uint32 fontStyle,
    Uint32 firstGlyphIndex,
    Int32 numGlyphs,
    Uint32 pathParameterTemplate,
    Float emScale);
typedef GlPathGlyphIndexArrayNV = int Function(
    int firstPathName,
    int fontTarget,
    Pointer fontName,
    int fontStyle,
    int firstGlyphIndex,
    int numGlyphs,
    int pathParameterTemplate,
    double emScale);

typedef GlPathMemoryGlyphIndexArrayNVNative = Uint32 Function(
    Uint32 firstPathName,
    Uint32 fontTarget,
    Int64 fontSize,
    Pointer fontData,
    Int32 faceIndex,
    Uint32 firstGlyphIndex,
    Int32 numGlyphs,
    Uint32 pathParameterTemplate,
    Float emScale);
typedef GlPathMemoryGlyphIndexArrayNV = int Function(
    int firstPathName,
    int fontTarget,
    int fontSize,
    Pointer fontData,
    int faceIndex,
    int firstGlyphIndex,
    int numGlyphs,
    int pathParameterTemplate,
    double emScale);

typedef GlProgramPathFragmentInputGenNVNative = Void Function(Uint32 program,
    Int32 location, Uint32 genMode, Int32 components, Pointer<Float> coeffs);
typedef GlProgramPathFragmentInputGenNV = void Function(int program,
    int location, int genMode, int components, Pointer<Float> coeffs);

typedef GlGetProgramResourcefvNVNative = Void Function(
    Uint32 program,
    Uint32 programInterface,
    Uint32 index,
    Int32 propCount,
    Pointer<Uint32> props,
    Int32 count,
    Pointer<Int32> length,
    Pointer<Float> params);
typedef GlGetProgramResourcefvNV = void Function(
    int program,
    int programInterface,
    int index,
    int propCount,
    Pointer<Uint32> props,
    int count,
    Pointer<Int32> length,
    Pointer<Float> params);

//GL_NV_sample_locations
typedef GlFramebufferSampleLocationsfvNVNative = Void Function(
    Uint32 target, Uint32 start, Int32 count, Pointer<Float> v);
typedef GlFramebufferSampleLocationsfvNV = void Function(
    int target, int start, int count, Pointer<Float> v);

typedef GlNamedFramebufferSampleLocationsfvNVNative = Void Function(
    Uint32 framebuffer, Uint32 start, Int32 count, Pointer<Float> v);
typedef GlNamedFramebufferSampleLocationsfvNV = void Function(
    int framebuffer, int start, int count, Pointer<Float> v);

typedef GlResolveDepthValuesNVNative = Void Function();
typedef GlResolveDepthValuesNV = void Function();

//GL_NV_scissor_exclusive
typedef GlScissorExclusiveNVNative = Void Function(
    Int32 x, Int32 y, Int32 width, Int32 height);
typedef GlScissorExclusiveNV = void Function(
    int x, int y, int width, int height);

typedef GlScissorExclusiveArrayvNVNative = Void Function(
    Uint32 first, Int32 count, Pointer<Int32> v);
typedef GlScissorExclusiveArrayvNV = void Function(
    int first, int count, Pointer<Int32> v);

//GL_NV_shader_buffer_load
typedef GlMakeBufferResidentNVNative = Void Function(
    Uint32 target, Uint32 access);
typedef GlMakeBufferResidentNV = void Function(int target, int access);

typedef GlMakeBufferNonResidentNVNative = Void Function(Uint32 target);
typedef GlMakeBufferNonResidentNV = void Function(int target);

typedef GlIsBufferResidentNVNative = Uint8 Function(Uint32 target);
typedef GlIsBufferResidentNV = int Function(int target);

typedef GlMakeNamedBufferResidentNVNative = Void Function(
    Uint32 buffer, Uint32 access);
typedef GlMakeNamedBufferResidentNV = void Function(int buffer, int access);

typedef GlMakeNamedBufferNonResidentNVNative = Void Function(Uint32 buffer);
typedef GlMakeNamedBufferNonResidentNV = void Function(int buffer);

typedef GlIsNamedBufferResidentNVNative = Uint8 Function(Uint32 buffer);
typedef GlIsNamedBufferResidentNV = int Function(int buffer);

typedef GlGetBufferParameterui64vNVNative = Void Function(
    Uint32 target, Uint32 pname, Pointer<Uint64> params);
typedef GlGetBufferParameterui64vNV = void Function(
    int target, int pname, Pointer<Uint64> params);

typedef GlGetNamedBufferParameterui64vNVNative = Void Function(
    Uint32 buffer, Uint32 pname, Pointer<Uint64> params);
typedef GlGetNamedBufferParameterui64vNV = void Function(
    int buffer, int pname, Pointer<Uint64> params);

typedef GlGetIntegerui64vNVNative = Void Function(
    Uint32 value, Pointer<Uint64> result);
typedef GlGetIntegerui64vNV = void Function(int value, Pointer<Uint64> result);

typedef GlUniformui64NVNative = Void Function(Int32 location, Uint64 value);
typedef GlUniformui64NV = void Function(int location, int value);

typedef GlUniformui64vNVNative = Void Function(
    Int32 location, Int32 count, Pointer<Uint64> value);
typedef GlUniformui64vNV = void Function(
    int location, int count, Pointer<Uint64> value);

typedef GlGetUniformui64vNVNative = Void Function(
    Uint32 program, Int32 location, Pointer<Uint64> params);
typedef GlGetUniformui64vNV = void Function(
    int program, int location, Pointer<Uint64> params);

typedef GlProgramUniformui64NVNative = Void Function(
    Uint32 program, Int32 location, Uint64 value);
typedef GlProgramUniformui64NV = void Function(
    int program, int location, int value);

typedef GlProgramUniformui64vNVNative = Void Function(
    Uint32 program, Int32 location, Int32 count, Pointer<Uint64> value);
typedef GlProgramUniformui64vNV = void Function(
    int program, int location, int count, Pointer<Uint64> value);

//GL_NV_shading_rate_image
typedef GlBindShadingRateImageNVNative = Void Function(Uint32 texture);
typedef GlBindShadingRateImageNV = void Function(int texture);

typedef GlGetShadingRateImagePaletteNVNative = Void Function(
    Uint32 viewport, Uint32 entry, Pointer<Uint32> rate);
typedef GlGetShadingRateImagePaletteNV = void Function(
    int viewport, int entry, Pointer<Uint32> rate);

typedef GlGetShadingRateSampleLocationivNVNative = Void Function(
    Uint32 rate, Uint32 samples, Uint32 index, Pointer<Int32> location);
typedef GlGetShadingRateSampleLocationivNV = void Function(
    int rate, int samples, int index, Pointer<Int32> location);

typedef GlShadingRateImageBarrierNVNative = Void Function(Uint8 synchronize);
typedef GlShadingRateImageBarrierNV = void Function(int synchronize);

typedef GlShadingRateImagePaletteNVNative = Void Function(
    Uint32 viewport, Uint32 first, Int32 count, Pointer<Uint32> rates);
typedef GlShadingRateImagePaletteNV = void Function(
    int viewport, int first, int count, Pointer<Uint32> rates);

typedef GlShadingRateSampleOrderNVNative = Void Function(Uint32 order);
typedef GlShadingRateSampleOrderNV = void Function(int order);

typedef GlShadingRateSampleOrderCustomNVNative = Void Function(
    Uint32 rate, Uint32 samples, Pointer<Int32> locations);
typedef GlShadingRateSampleOrderCustomNV = void Function(
    int rate, int samples, Pointer<Int32> locations);

//GL_NV_texture_barrier
typedef GlTextureBarrierNVNative = Void Function();
typedef GlTextureBarrierNV = void Function();

//GL_NV_vertex_attrib_integer_64bit
typedef GlVertexAttribL1i64NVNative = Void Function(Uint32 index, Int64 x);
typedef GlVertexAttribL1i64NV = void Function(int index, int x);

typedef GlVertexAttribL2i64NVNative = Void Function(
    Uint32 index, Int64 x, Int64 y);
typedef GlVertexAttribL2i64NV = void Function(int index, int x, int y);

typedef GlVertexAttribL3i64NVNative = Void Function(
    Uint32 index, Int64 x, Int64 y, Int64 z);
typedef GlVertexAttribL3i64NV = void Function(int index, int x, int y, int z);

typedef GlVertexAttribL4i64NVNative = Void Function(
    Uint32 index, Int64 x, Int64 y, Int64 z, Int64 w);
typedef GlVertexAttribL4i64NV = void Function(
    int index, int x, int y, int z, int w);

typedef GlVertexAttribL1i64vNVNative = Void Function(
    Uint32 index, Pointer<Int64> v);
typedef GlVertexAttribL1i64vNV = void Function(int index, Pointer<Int64> v);

typedef GlVertexAttribL2i64vNVNative = Void Function(
    Uint32 index, Pointer<Int64> v);
typedef GlVertexAttribL2i64vNV = void Function(int index, Pointer<Int64> v);

typedef GlVertexAttribL3i64vNVNative = Void Function(
    Uint32 index, Pointer<Int64> v);
typedef GlVertexAttribL3i64vNV = void Function(int index, Pointer<Int64> v);

typedef GlVertexAttribL4i64vNVNative = Void Function(
    Uint32 index, Pointer<Int64> v);
typedef GlVertexAttribL4i64vNV = void Function(int index, Pointer<Int64> v);

typedef GlVertexAttribL1ui64NVNative = Void Function(Uint32 index, Uint64 x);
typedef GlVertexAttribL1ui64NV = void Function(int index, int x);

typedef GlVertexAttribL2ui64NVNative = Void Function(
    Uint32 index, Uint64 x, Uint64 y);
typedef GlVertexAttribL2ui64NV = void Function(int index, int x, int y);

typedef GlVertexAttribL3ui64NVNative = Void Function(
    Uint32 index, Uint64 x, Uint64 y, Uint64 z);
typedef GlVertexAttribL3ui64NV = void Function(int index, int x, int y, int z);

typedef GlVertexAttribL4ui64NVNative = Void Function(
    Uint32 index, Uint64 x, Uint64 y, Uint64 z, Uint64 w);
typedef GlVertexAttribL4ui64NV = void Function(
    int index, int x, int y, int z, int w);

typedef GlVertexAttribL1ui64vNVNative = Void Function(
    Uint32 index, Pointer<Uint64> v);
typedef GlVertexAttribL1ui64vNV = void Function(int index, Pointer<Uint64> v);

typedef GlVertexAttribL2ui64vNVNative = Void Function(
    Uint32 index, Pointer<Uint64> v);
typedef GlVertexAttribL2ui64vNV = void Function(int index, Pointer<Uint64> v);

typedef GlVertexAttribL3ui64vNVNative = Void Function(
    Uint32 index, Pointer<Uint64> v);
typedef GlVertexAttribL3ui64vNV = void Function(int index, Pointer<Uint64> v);

typedef GlVertexAttribL4ui64vNVNative = Void Function(
    Uint32 index, Pointer<Uint64> v);
typedef GlVertexAttribL4ui64vNV = void Function(int index, Pointer<Uint64> v);

typedef GlGetVertexAttribLi64vNVNative = Void Function(
    Uint32 index, Uint32 pname, Pointer<Int64> params);
typedef GlGetVertexAttribLi64vNV = void Function(
    int index, int pname, Pointer<Int64> params);

typedef GlGetVertexAttribLui64vNVNative = Void Function(
    Uint32 index, Uint32 pname, Pointer<Uint64> params);
typedef GlGetVertexAttribLui64vNV = void Function(
    int index, int pname, Pointer<Uint64> params);

typedef GlVertexAttribLFormatNVNative = Void Function(
    Uint32 index, Int32 size, Uint32 type, Int32 stride);
typedef GlVertexAttribLFormatNV = void Function(
    int index, int size, int type, int stride);

//GL_NV_vertex_buffer_unified_memory
typedef GlBufferAddressRangeNVNative = Void Function(
    Uint32 pname, Uint32 index, Uint64 address, Int64 length);
typedef GlBufferAddressRangeNV = void Function(
    int pname, int index, int address, int length);

typedef GlVertexFormatNVNative = Void Function(
    Int32 size, Uint32 type, Int32 stride);
typedef GlVertexFormatNV = void Function(int size, int type, int stride);

typedef GlNormalFormatNVNative = Void Function(Uint32 type, Int32 stride);
typedef GlNormalFormatNV = void Function(int type, int stride);

typedef GlColorFormatNVNative = Void Function(
    Int32 size, Uint32 type, Int32 stride);
typedef GlColorFormatNV = void Function(int size, int type, int stride);

typedef GlIndexFormatNVNative = Void Function(Uint32 type, Int32 stride);
typedef GlIndexFormatNV = void Function(int type, int stride);

typedef GlTexCoordFormatNVNative = Void Function(
    Int32 size, Uint32 type, Int32 stride);
typedef GlTexCoordFormatNV = void Function(int size, int type, int stride);

typedef GlEdgeFlagFormatNVNative = Void Function(Int32 stride);
typedef GlEdgeFlagFormatNV = void Function(int stride);

typedef GlSecondaryColorFormatNVNative = Void Function(
    Int32 size, Uint32 type, Int32 stride);
typedef GlSecondaryColorFormatNV = void Function(
    int size, int type, int stride);

typedef GlFogCoordFormatNVNative = Void Function(Uint32 type, Int32 stride);
typedef GlFogCoordFormatNV = void Function(int type, int stride);

typedef GlVertexAttribFormatNVNative = Void Function(
    Uint32 index, Int32 size, Uint32 type, Uint8 normalized, Int32 stride);
typedef GlVertexAttribFormatNV = void Function(
    int index, int size, int type, int normalized, int stride);

typedef GlVertexAttribIFormatNVNative = Void Function(
    Uint32 index, Int32 size, Uint32 type, Int32 stride);
typedef GlVertexAttribIFormatNV = void Function(
    int index, int size, int type, int stride);

typedef GlGetIntegerui64i_vNVNative = Void Function(
    Uint32 value, Uint32 index, Pointer<Uint64> result);
typedef GlGetIntegerui64i_vNV = void Function(
    int value, int index, Pointer<Uint64> result);

//GL_NV_viewport_swizzle
typedef GlViewportSwizzleNVNative = Void Function(Uint32 index, Uint32 swizzlex,
    Uint32 swizzley, Uint32 swizzlez, Uint32 swizzlew);
typedef GlViewportSwizzleNV = void Function(
    int index, int swizzlex, int swizzley, int swizzlez, int swizzlew);

//GL_OVR_multiview
typedef GlFramebufferTextureMultiviewOVRNative = Void Function(
    Uint32 target,
    Uint32 attachment,
    Uint32 texture,
    Int32 level,
    Int32 baseViewIndex,
    Int32 numViews);
typedef GlFramebufferTextureMultiviewOVR = void Function(int target,
    int attachment, int texture, int level, int baseViewIndex, int numViews);
