# 基础提示 Basic Prompting

在上一篇指南中，我们介绍了并且提供了一个基本的 prompt 示例。

在这篇指南中，我们将提供更多的 prompt 使用示例，并介绍在更高级的指南中将会很重要的关键概念。

通常，学习概念的最佳方法是通过示例进行学习。下面我们将涵盖一些精心制作的 prompt 的示例，这些 prompt 可以用于执行各种有趣和不同的任务。

主题：
- [文本摘要](#文本摘要)
- [信息提取](#信息提取)
- [问答](#问答)
- [文本分类](#文本分类)
- [对话](#对话)
- [代码生成](#代码生成)
- [推理](#推理)
- [Python 笔记本](#Python 笔记本)

---

## 文本摘要
自然语言生成中的一项标准任务是文本摘要。文本摘要可以包含许多不同的风格和领域。语言模型最有前途的应用之一是将文章和概念总结成快速易读的摘要。让我们尝试使用提示来进行基本的摘要任务。

假设我有兴趣了解抗生素，我可以尝试使用以下提示：

*Prompt:*
```
解释什么是抗生素

A:
```

*Output:*
```
抗生素是一种用于治疗细菌感染的药物。它们通过杀死细菌或防止其繁殖来使机体免疫系统对抗感染。抗生素通常以口服药片、胶囊或液体溶液的形式服用，有时也会静脉注射。它们对病毒感染无效，不当使用会导致抗生素耐药性。
```

在这里，"A:" 是一个显式的提示格式，用于问题回答。我在这里使用它来告诉模型存在预期的后续内容。在这个例子中，这并不清楚有什么用处，但我们会在后面的例子中详细讲解。让我们假设这个输出信息太多，我们希望进一步摘要。我们可以指示模型进行一句话总结，如下所示：
*Prompt:*

```
抗生素是一种用于治疗细菌感染的药物。它们通过杀死细菌或防止其繁殖来使机体免疫系统对抗感染。抗生素通常以口服药片、胶囊或液体溶液的形式服用，有时也会静脉注射。它们对病毒感染无效，不当使用会导致抗生素耐药性。

请用一句话解释上面的内容：
```

*Output:*
```
抗生素是一种药物，用于通过杀死或防止细菌繁殖来治疗细菌感染，但不对病毒有效，不当使用会导致抗生素耐药性。
```

在不过多关注上述输出的准确性的情况下，我们可以看到模型尝试将段落总结为一句话。您可以聪明地使用指示，但我们将在以后的章节中介绍。随时暂停并进行实验，看看是否可以得到更好的结果。

---
## 信息提取
尽管语言模型是被训练用于执行自然语言生成及相关任务的，但它也非常擅长执行分类和一系列其他的自然语言处理（NLP）任务。

以下是一个从给定段落中提取信息的提示示例。

*Prompt:*
```
研究论文中的作者贡献声明和致谢应明确并具体说明作者在撰写和分析手稿过程中是否以及在什么程度上使用了诸如ChatGPT这样的AI技术。它们还应指出使用了哪些LLMs。这将提醒编辑和审稿人更仔细地审查手稿，以寻找潜在的偏见、不准确性和不正确的来源证明。同样，科学期刊应在选择提交的手稿时透明地公开使用LLMs的情况。

提及该段落中提到的大型语言模型产品是什么？
```

*Output:*
```
该段落中提到的大型语言模型产品是ChatGPT。
```

我们可以通过许多方法来改进上述结果，但这已经非常有用了。

现在显然可以通过简单地指示它要做什么来要求模型执行不同的任务。这是AI产品构建者已经在使用的强大功能，以构建强大的产品和体验。

段落来源: [ChatGPT: five priorities for research](https://www.nature.com/articles/d41586-023-00288-7) 


---
## 问答

获取模型对特定答案的响应的最佳方法之一是改进提示的格式。如前所述，提示可以结合指令、上下文、输入和输出指示符来获得更好的结果。虽然这些组件并非必需，但随着您指令越具体，您将获得更好的结果。以下是如何在更具结构的提示中进行的示例。

*Prompt:*
```
根据以下内容回答问题。保持答案简短。如果不确定答案，请回答“不确定答案”。

背景：Teplizumab可以追溯到新泽西州的一家名为Ortho Pharmaceutical的药品公司。在那里，科学家们生成了一种名为OKT3的抗体的早期版本。该分子最初是从小鼠中提取的，它能够结合到T细胞的表面，并限制它们的细胞杀伤潜力。1986年，它获得批准，用于帮助预防肾脏移植后的器官排斥，成为首个允许人类使用的治疗性抗体。

问题：OKT3最初是从哪里提取的？

答案：
```

*Output:*
```
OKT3最初是从小鼠中提取的。
```

内容来源: [Nature](https://www.nature.com/articles/d41586-023-00400-x).

---

## 文本分类
到目前为止，我们已经使用简单的指令执行任务。作为一个 Prompt 工程师，您需要提高提供更好指令的能力。但这还不够！您还会发现，在更难的用例中，仅提供指令是不够的。这就是您需要更多考虑上下文和可以在提示中使用的不同元素的地方。您可以提供的其他元素包括输入数据或示例。

让我们尝试通过提供文本分类的示例来演示这一点。

*Prompt:*
```
Classify the text into neutral, negative or positive. 

Text: I think the food was okay. 
Sentiment:
```

*Output:*
```
Neutral 
```
这里的回答是Neutral(首字母大写)，本例子是想让回答变成小写的neutral

我们给出了分类文本的指令，模型以'Neutral'响应，这是正确的。没有什么错的，但是假设我们真正需要的是让模型以我们想要的确切格式返回标签。所以，我们不想要Neutral，而是想要它返回全小写的neutral。我们如何做到这一点。有不同的方法来做到这一点。我们关心的是具体性，在提示中提供的信息越多，结果就越好。我们可以尝试提供示例来指定正确的行为。让我们再试一次：
*Prompt:*
```
Classify the text into neutral, negative or positive. 

Text: I think the vacation is okay.
Sentiment: neutral 

Text: I think the food was okay. 
Sentiment:
```

*Output:*
```
neutral
```

完美！这次模型返回了neutral，这正是我要寻找的具体标签。似乎提示中提供的示例帮助模型在其输出中变得更加具体。为了强调为什么有时候具体性很重要，请看这个例子并找出问题：
*Prompt:*
```
Classify the text into nutral, negative or positive. 

Text: I think the vacation is okay.
Sentiment:
```

*Output:*
```
Neutral
```

这里的问题是什么？

---

## Conversation
通过prompt engineering，您可以告诉LLM系统如何行事，其意图和身份，这在构建客户服务聊天机器人等对话系统时特别有用。

例如，让我们创建一个对问题生成更多技术和科学响应的对话系统。请注意，我们通过指令明确告诉它如何行事。这有时被称为角色提示。

*Prompt:*
```
下面是与一名技术和科学气氛的AI研究助理进行的对话。

人类：你好，你是谁？
AI：问候！我是一个AI研究助手。今天我能帮你什么忙吗？
人类：你能告诉我黑洞的形成吗？
AI：
```

*Output:*

```
当然可以！黑洞是时空中引力极强的区域，甚至连光也无法逃脱。当一个非常质量巨大的恒星死亡并且其核心坍塌时，就会形成一个无限密度的奇点，从而形成黑洞。奇点的强烈引力将周围的所有物质和辐射吸引进来，从而形成黑洞。
```

我们的AI研究助手听起来有点太技术了，对吧？好的，让我们改变这种行为，指示系统提供更易于理解的答案。

*Prompt:*

```
下面是与一名AI研究助手的对话。助手的回答应该易于被小学生理解。
人类：你好，你是谁？
AI：问候！我是一个AI研究助手。今天我能帮你什么忙吗？
人类：你能告诉我黑洞的形成吗？
AI：
```

*Output:*
```
当然可以！黑洞是由于非常质量巨大的恒星耗尽燃料而坍塌形成的。恒星的引力非常强大，甚至连光也无法逃离其吸引。这会在时空中创造一个引力极强的点，称为黑洞。
```

我认为我们取得了一些进展。你可以继续改进。我相信如果你添加更多的例子，你可能会得到更好的结果。

---

## 代码生成
代码生成是LLM非常有效的应用之一，Copilot是一个很好的例子。通过巧妙的提示，你可以执行大量的代码生成任务。让我们看一些下面的例子。

首先，让我们尝试一个简单的程序来问候用户。

*Prompt:*
```
/*
询问用户姓名并说“Hello”
*/
```

*Output:*
```
let name = prompt("What is your name?");
console.log(`Hello, ${name}!`);
```

你可以看到，我们甚至不需要指定要使用的语言。

让我们稍微提高一下难度。我想向你展示在设计提示时LLM可以有多强大。

*Prompt:*
```
"""
Table departments, columns = [DepartmentId, DepartmentName]
Table students, columns = [DepartmentId, StudentId, StudentName]
创建一个MySQL查询，查询计算机科学系的所有学生
"""
```

*Output:*
```
SELECT StudentId, StudentName 
FROM students 
WHERE DepartmentId IN (SELECT DepartmentId FROM departments WHERE DepartmentName = 'Computer Science');
```

这非常令人印象深刻。在这种情况下，我们提供了关于数据库模式的数据，并要求它生成一个有效的MySQL查询。
---

## 推理
也许目前对于LLM来说最具挑战性的任务之一是需要一定推理能力的任务。推理是我最为期待的领域之一，因为LLM可以从中得到各种复杂的应用。

在涉及到数学能力的任务方面已经有了一些改进。尽管如此，需要注意的是目前的LLM在执行推理任务方面仍然存在困难，因此需要更高级的提示工程技术。我们将在下一篇指南中介绍这些高级技术。现在，我们将介绍一些基本示例，以展示LLM的算术能力。

*Prompt:*
```
9000 * 9000等于多少？
```

*Output:*
```
81,000,000
```

让我们试试更难的题目。

*Prompt:*
```
这组数字中的奇数加起来是一个偶数：15, 32, 5, 13, 82, 7, 1. 

A: 
```

*Output*
```
不，这组数字中的奇数加起来是一个奇数：119。
```

这是错误的！让我们通过改进提示来改进结果。

*Prompt:*
```
这组数字中的奇数加起来是一个偶数：15, 32, 5, 13, 82, 7, 1. 

通过分步解决问题。首先，识别出奇数，将它们相加，并指示结果是奇数还是偶数。
```

*Output:*
```
奇数：15, 5, 13, 7, 1
总和：41
41是一个奇数。
```

好多了，对吧？顺便说一句，我尝试了几次，有时系统会失败。如果您提供更好的指示结合示例，可能有助于获得更准确的结果。
另外GPT4在这方面有很大的改进和提升！

我们将继续在本节中包含更多常见应用的示例。

在接下来的指南中，我们将介绍更高级的提示工程概念，以提高在所有这些和更难的任务上的性能。

---
## Python 笔记本

|描述|笔记本|
|--|--|
|学习如何使用 openai 和 LangChain 库执行许多不同类型的常见任务|[开始使用提示工程](../notebooks/pe-lecture.ipynb)|

---

[上一节（提示简介）](./prompts-intro.md)

[下一节（高级提示技巧）](./prompts-advanced-usage.md)
