---
layout: post
title:  microsoft proxy 3
---
### microsoft/proxy` 到底咋样？ 之前置知识 之笨比也能认识什么是多态 （全文第一章）

vspefs vspefs@protonmail.com
HaE :email_2: zwl3170868212@outlook.com


## Disclaimers

- 本文写于2024/09/07，正值proxy 3.0发布之际。
- 作者理论知识与工程经验均不足，如有错误敬请斧正。
= 部分代码经过测试，部分代码未经测试。领会一下精神就可以。

---

## 传说中的，`proxy`

2022年，微软的DevBlogs中偷偷登上了这么一篇文章 [proxy: Runtime Polymorphism Made Easier Than Ever](https://devblogs.microsoft.com/cppblog/proxy-runtime-polymorphism-made-easier-than-ever/)。这位叫作Mingxin Wang的微软工程师宣称，他们基于对OOP的深入理论研究，完成了对C++运行时多态的一次突破性革新，也就是这篇博客中带来的`proxy`库。并且据现在看来，微软当年就在Windows的代码中使用`proxy`了。

当时的GitHub仓库中他们提到，具体的设计思想应当参见他们在WG21的提案，即 [Proxy: A Polymorphic Programming Library](https://wg21.link/p0957)。然而，如果你仔细查看了这篇论文，会发现它最早的投稿位于2018年，彼时提案的名称还叫作 `p0957r0` https://wg21.link/p0957r0。当时的参考实现还指向Wang个人的 [PFA: A Generic, Extendable and Efficient Solution for Polymorphic Programming](https://github.com/wmx16835/cpp_pfa)——现在不仅仓库没了，Wang的GitHub账号也改名了。

也许这一开始是Wang的个人项目，后来被微软采纳了。出于这种可能性，我们应该为Wang鼓掌——毕竟如何解决虚函数和继承多态的种种问题，是C++社区中一个长期且艰巨的课题。Wang对此做出的方案能被微软采纳并成为官方项目，是一件可喜的事情。

而我们，应当先看看虚函数和继承多态的问题到底在哪里，才能知道`proxy`是如何解决的。

TIP: 如果你清楚这些问题，可以跳过本章内容。

## 基本的多态

首先，我们有一个严肃的问题：C++设计OOP、继承、多态的时候，笔者还没有出生。

我的意思是：一方面笔者并没有亲历过OOP发展、流行的历程，因此在一些八卦细节上可能出现谬误；另一方面，笔者勉强还是比Rust这些语言大一点，所以基于时间这个属性在比较上的传递性，聪明的读者应该不难推断出来，C++在这方面的设计、实现、成熟要远早于当代语言，在技术和理论上是必然存在落后的。

CAUTION: 笔者要开始口胡了！

现在我们先来明晰一下，一些关键术语的定义：

- 继承（Inheritance）  一种OOP中高度符合直觉的代码复用的手段。一般具有“访问权限控制”等安全性特性。

- 多态（Polymorphism） 指在不同的场景中使用同一个操作，该操作的具体行为随着使用场景的不同而不同的行为。 +
  _实际上，笔者私下觉得polymorphism这个英文比翻译的“多态”更传神一点，因为体现出了"morph"这个动作：本来是同一个操作，面对不同的情况，就morph了——变形了嘛。_

- 静态多态（Static Polymorphism） 在编译期即可确定操作的具体行为的多态。因为一切多态的检测、处理与绑定，都可以在编译时完成，所以理论上是没有运行时开销的。 在C++中，静态多态大部分时候通过模板元编程技巧（尤其值得强调CRTP）实现。

- 动态多态（Dynamic Polymorphism） 必须在运行时才能确定操作的具体行为的多态。因为运行时至少要处理“应该采用什么行为”这个问题，所以无论如何都存在着运行时开销。 在C++中，动态多态大部分时候通过继承和虚函数实现。

所以说，继承和多态其实并不是一回事。继承是一种代码复用的手段，多态是单一操作的多样化，两者十六根竿子相互打不着。然而基于OOP的概念，当我们把多态定义中“不同的场景”理解为“对不同的对象”，那么这一概念就可以适用于子类与子类、子类与父类之间的关系，因此一些复杂的继承关系中，我们往往需要多态这一特性来解决一些问题。

进一步说，在许多不同的编程范式和方法技巧中，多态都是一个很重要的工具。它本质上其实是一种“抽象”的手段，用于强化语言的表达能力，以此能更简洁地处理一些问题，并非是一门编程语言能用来比较高低的“硬”能力。事实上，C/C++把指针直接给用户使用，再也没有比指针更硬、更强的语言特性了。

因为编程语言无论数学上如何设计，它的最终目的是在计算机上运行并解决工程上的问题。回到工程上之后，指针对内存的直接操作，就是最原始、最强大的操作，甚至可以是“唯一”的操作。

因此，让我们回归原始，用C和指针来设计一个最简单的多态系统。（最终完整源码见src/raw_polymorphism_c.c）

.你的需求
. 设计一系列的饮品，其中包括`water`（水）、`milk`（牛奶）、`coffee`（咖啡）、`poison`（毒药）。
. 这些饮品都有共同的属性，如`temperature`（温度）。
. 不同的饮品可能有自己的特性，如`milk`和`coffee`有`concetration`（浓度），`poison`有`deadly`（致命性）。
. 使用统一的`drink()`函数，可以模拟饮用不同饮品的不同行为。具体行为保存在具有独特类型`drink_result_t`的返回值中。

我们很容易就能写出如下的代码：

```
#include <stdint.h> // 纯因为我喜欢写定长整数类型

typedef 
  struct drink_result
  {
    bool success;
    const char *message;
  }
  drink_result_t;

typedef
  struct water
  {
    int16_t temperature;
  }
  water_t;

typedef
  struct milk
  {
    int16_t temperature;
    float concentration;
  }
  milk_t;

typedef 
  struct coffee
  {
    int16_t temperature;
    bool sugar;
    float concentration;
  }
  coffee_t;

typedef 
  struct posion
  {
    int16_t temperature;
    bool deadly;
  }
  poison_t;
```

此时你轻蔑地一笑，已经打算写出：

```
drink_result_t drink(water_t w);
drink_result_t drink(milk_t m);
```

然后你忽然发现啊，报错了，因为C不支持函数重载。我们聪明的大脑飞速运转，原来函数重载footnote:[特别是此处的`drink()`函数，实际上以OOP的理论，可以视作所有“饮品”所共有的一个，类型为`drink_result_t (*)(void)`的**成员函数**。仅为一则脚注，具体内容此处不展开。]又怎么不算是多态的一种呢？我们既然说要实现一个多态系统……那就也靠我们自己来实现吧。

好吧。幸亏聪明的我们对C语言可谓是了如指掌，知道如何使用`void*`来让`drink()`接受任意类型的参数。我们再进一步给每个饮品的struct打上tag，这样`drink()`接受了参数之后，便可以通过tag来判断参数的具体类型，然后做出相应的行为。

```
#include <stdint.h>

typedef
  enum drink_tag
  {
    WATER,
    MILK,
    COFFEE,
    POISON
  }
  drink_tag_t;

typedef 
  struct drink_result
  {
    bool success;
    const char *message;
  }
  drink_result_t;

typedef
  struct water
  {
    drink_tag_t tag;
    int16_t temperature;
  }
  water_t;

typedef
  struct milk
  {
    drink_tag_t tag;
    int16_t temperature;
    float concentration;
  }
  milk_t;

typedef 
  struct coffee
  {
    drink_tag_t tag;
    int16_t temperature;
    bool sugar;
    float concentration;
  }
  coffee_t;

typedef 
  struct posion
  {
    drink_tag_t tag;
    int16_t temperature;
    bool deadly;
  }
  poison_t;

drink_result_t drink(void* obj)
{
  drink_tag_t tag = *(drink_tag_t*)obj;
  switch (tag)
  {
    case WATER:
      {
        water_t *w = (water_t*)obj;
        // ...
      }
      break;
    case MILK:
      {
        milk_t *m = (milk_t*)obj;
        // ...
      }
      break;
    case COFFEE:
      {
        coffee_t *c = (coffee_t*)obj;
        // ...
      }
      break;
    case POISON:
      {
        poison_t *p = (poison_t*)obj;
        // ...
      }
      break;
    default:
      return (drink_result_t){ .success = false, .message = "Unknown drink" };
  }
}
```

这下神清气爽了。不过，这段代码里可是大有学问。明明是`void*`，我们为什么可以直接转换为`drink_tag_t*`类型，并且还能正常获取到tag的值呢？这是因为我们在`water_t`、`milk_t`等struct的第一个成员就是`drink_tag_t`，这样对于这些类型任意的实例，`tag`成员变量的偏移值实际上是0，因此我们不经过修改，直接以`drink_tag_t*`的方式访问`void*`指针所指向的地址，就能得到`tag`的值。

## 较完善的静态多态

但这样也必然存在着问题。一个明显的问题就是，我们的`drink()`函数是一个巨大的switch-case，这样的代码不仅不优雅，而且不易维护。我们想要的是，我们在定义新的饮品时，原地顺手就把新饮品的`drink()`给实现了，而不是去修改一个巨大的`drink()`函数和里面的switch-case。这不仅是便利性上的问题，更是因为后者的方式很容易堆积出屎山。footnote:[具体怎么堆积兴许已经有很多写得比我好的资料了。如果没有我以后再写吧。]

现在我们就有了新的需求。

- 不同饮品的`drink()`函数，其具体行为应当是分开实现的。
- 实现新的饮品时，不应当修改已有的代码。

这就头疼了。我们仔细看这个`drink()`函数，它包含了两个参与者：`drink()`函数本身，以及`drink()`接受的变量`obj`。现在我们一旦实现好了`drink()`，就不能再去动它。

而如果我们无法对`drink()`进行修改，那能指望的就只有`obj`里能藏着一些东西，让我们能够以一种固定的方式，在`obj`里找到`drink()`的实现。

很自然地，我们就会想到，我们能不能在`obj`里藏着一个函数指针呢？我们不妨叫它`addr_drink`，我们就可以这样写：

```
#include <stdint.h>

typedef 
  struct drink_result
  {
    bool success;
    const char *message;
  }
  drink_result_t;

typedef
  struct water
  {
    drink_result_t (*addr_drink)(void*);
    int16_t temperature;
  }
  water_t;

typedef
  struct milk
  {
    drink_result_t (*addr_drink)(void*);
    int16_t temperature;
    float concentration;
  }
  milk_t;

// ...

drink_result_t drink(void* obj)
{
  return ((water_t*)obj)->addr_drink(obj);
}
```

打住。这样虽然跑得起来，但是太难看了——他妈的，为什么要把`obj`转换成`water_t*`？我知道如果只考虑`addr_drink`的话，其实转换成`water_t*`还是`poison_t*`问题都不大，但是这样的代码实在是太丑了。

刚好，我们都是C++出身的。我们都知道OOP和继承的十八般武艺。我们正遇到的情景，难道不刚好契合“基类”和“派生类”的情景吗？因此我们抽象出一个`metadrink_t`，并且再次运用struct的内存布局特性，写出这样的代码：
```
#include <stdint.h>

typedef 
  struct drink_result
  {
    bool success;
    const char *message;
  }
  drink_result_t;

typedef
  struct metadrink
  {
    drink_result_t (*addr_drink)(void*);
  }
  metadrink_t;

typedef
  struct water
  {
    metadrink_t meta;
    int16_t temperature;
  }
  water_t;

drink_result_t drink_water(void* obj)
{
  water_t *w = (water_t*)obj;
  // water_t的具体行为...
}

// ...

drink_result_t drink(void* obj)
{
  return ((metadrink_t*)obj)->addr_drink(obj);
}
```

哦操，无敌了。我们再写几个helper函数，帮我们装配这些饮品类型。`water_t`的helper函数就像这样：

```c
water_t make_water(int16_t temperature)
{
  return (water_t){ .meta = { .addr_drink = drink_water }, .temperature = temperature };
}
```

现在我们总算满足了这些需求。我们可以随意定义新的饮品，只要它们实现了`metadrink_t`的接口，我们就可以把它们放到`drink()`里面去。这样的代码，不仅优雅，而且易于维护。

值得一提的是，我们刚刚实现的东西和本节的主题其实**一点关系都没有**。本节的主题是“虚函数和继承多态存在哪些问题”。而实际上——

- 我们刚刚实现的东西，是因为C非常地“极简”，我们才不得不使用这种方式来实现“多态”。

- 你可能确实想得比较多，但是笔者此时设计这个系统的时候，设想的场景目前其实是很简单的，即上文里存在`water_t w = make_water(50);`之类的变量声明，而我们在下文中调用`auto ret = drink(&w);`。 
  - 只不过，我们在反复的迭代、批判与自我批判中，想出了一个相对优雅、灵活、可拓展性强的实现方式。这种方式，确实，是实现更复杂的动态多态的原型。但此处，我们仅用它来处理了一些静态多态可以处理的简单问题。

- 比起一开始的“函数重载”的想法，我们这个实现确实已经走入多态的歧途了。如果用C++的函数重载实现`drink()`，那么实际上不同饮品的`drink()`名字看着虽然一样，但根本就是不同的函数，八八六十四个杆子也打不着的那种不同。而我们这个实现，实际上是在运行时，通过同一套逻辑，根据`obj`的具体类型，调用不同的函数。这就是上文为什么说它“是实现更复杂的动态多态的原型”。 
  - 但是，在我们提到的场景中，这种动态并不是必要的。我们只不过没法对编译器开刀，所以只好自己实现运行时的这套逻辑。在高级语言的现代编译器中，这种逻辑是编译器自己实现的，而不需要我们手动实现。

所以我们做了这么多工作，虽然它很有潜力，但从“解决了什么问题”的角度上看，只是在C里面用运行时的方式，解决了一个C++里编译器会在编译时为我们解决的问题。 

总的来说，它**现在**是一个“运行时静态多态”系统。

而笔者最终还是选择，在此先实现一遍简单的“运行时静态多态”系统。因为这样可以让（没有基础的）同学们更容易理解“多态”这个概念，也能够认识到“多态”这个特性在底层是如何实现的（或者可能如何实现），如此才好进一步说明动态多态、虚函数这些设计的原理、实现和局限性。

## 动态多态的需求

话又说回来，有的同学会问，这“静态多态”不是相当他妈的好使吗？动态多态有啥好处，有啥必要？这个问题，我们马上就来讨论。

我们权当上面的代码提供的是饮品“单点”的功能吧，并且不牵涉到和其它系统的交互。而今天老板敲门进来，说点单系统要上线了，我们的饮品系统要和点单系统交互了。这时候，我们就要考虑到，我们的饮品系统是如何和其它系统交互的。此外还要考虑到一些实现细节：一系列的点单是否需要一个“队列”来存储不同的点单信息，这个队列又如何实现？

动态多态的需求存在于“系统交互”中。但为了教学和文章组织结构的便利，我们先来考虑这个“队列”的实现问题。

在C语言中，我们几乎没有选择，只能使用一个数组来实现这个队列。但是我们的问题在于，这个队列的类型是什么？我们既要存储`water_t`，又要存储`milk_t`，还要存储`coffee_t`、`poison_t`，那么这个单一数组的类型到底是什么？一个`union`吗？但是`union`的问题在于，我们无法在运行时知道这个`union`里面到底是什么类型的数据。

我们立马可以想到用tag的形式解决这个问题。相当不错。这就是所谓的__tagged union__技术。事实上，进一步利用struct的内存布局特性，我们可以写出一个相当不错的实现：

```
#include <stdint.h>

typedef 
  struct drink_result
  {
    bool success;
    const char *message;
  }
  drink_result_t;

typedef
  enum drink_tag
  {
    WATER,
    MILK,
    COFFEE,
    POISON
  }
  drink_tag_t;

typedef
  struct metadrink
  {
    drink_tag_t tag;
    drink_result_t (*addr_drink)(void*);
  }
  metadrink_t;

typedef
  struct water
  {
    metadrink_t meta;
    int16_t temperature;
  }
  water_t;

drink_result_t drink_water(void* obj)
{
  water_t *w = (water_t*)obj;
  // water_t的具体行为...
}

water_t make_water(int16_t temperature)
{
  return (water_t){ .meta = { .tag = WATER, .addr_drink = drink_water }, .temperature = temperature };
}

// 其他类型
// ...

drink_result_t drink(void* obj)
{
  return ((metadrink_t*)obj)->addr_drink(obj);
}

typedef
  union order
  {
    water_t water;
    milk_t milk;
    coffee_t coffee;
    poison_t poison;
  }
  order_t;

order_t orders[100];  // 假设最多100个点单
size_t order_count = 0;

bool order(order_t o)
{
  if (order_count >= 100)
    return false;
  orders[order_count++] = o;
  return true;
}

bool process_orders()
{
  for (size_t i = 0; i < order_count; ++i)
  {
    switch (*(drink_tag_t*)&orders[i])
    {
      case WATER:
        {
          water_t w = *(water_t*)&orders[i];
          // ...
        }
        break;
      case MILK:
        {
          milk_t m = *(milk_t*)&orders[i];
          // ...
        }
        break;
      case COFFEE:
        {
          coffee_t *c = *(coffee_t*)&orders[i];
          // ...
        }
        break;
      case POISON:
        {
          poison_t *p = *(poison_t*)&orders[i];
          // ...
        }
        break;
      default:
        return false;
    }
  }
}
```

还挺巧妙的。`drink_tag_t`的实例是`metadrink_t`的第一个成员，`metadrink_t`的实例又是任何饮品类的第一个成员。这样，对于指向任意饮品的指针`obj`，我们就可以通过`(drink_tag_t*)obj`来访问这个饮品的tag，同时不破坏以`(metadrink_t*)obj`的方式获取`obj`的元数据（即`addr_drink`等信息）的能力。

要注意，这里__tagged union__的使用并非为了解决“操作的多态”的问题，而是为了解决“存储的多态”，或者说“数据的多态”的问题——这个问题严格来说很难被称之为多态，不过它有个更准确的名称，也就是“异构容器”（Heterogeneous Container）。


- 异构容器（Heterogeneous Container） 一种数据结构，其中可以存储不同类型的数据。

不过，这一切都取决于你老板的需求。正如我们在实现`drink()`时所提到的，这种tag + switch-case的方式，虽然能够解决问题，但是它要求程序员不厌其烦，一旦有新的饮品加入，就要修改tag的定义，以及那个巨大的switch-case；并且它要求程序员上下齐心，维护一个时效性强、统一的文档，并且所有上下游的程序员都要严格遵守这个文档，任何一环的设计有所变动立刻更新代码。

这就回到了“系统交互”这个问题上。我们目前的__tagged union__方案说到底还是静态多态的，同时还满足了异构容器这个需求。但是在“系统交互”的角度来说，这种设计是并不优雅的。

实际上，我们有一个名词描述这种设计，即这个设计具有侵入性（Intrusive）。这个词很好理解啊——一个新系统的设计会“侵入”这个系统处理的成员的逻辑，要求这些成员或相关系统的设计也遵守它的系统规范，甚至于修改它们原本的设计。

在我们设计的这个系统里，也就是说，因为我们要用switch-case的形式来处理不同的饮品，所以我们要求每个饮品都要有这个tag，还要能通过`(drink_tag_t*)obj`的形式访问。从这个角度看，这个设计是侵入性的。

同时以一种比较强行的说法来讲，因为你这一层采用了tag + switch-case的方式，所以你上下游的同行们不得不捏着鼻子，自己的舅舅惯着你的爸，他们想加一个新的饮品，还得联系你，求着你在你维护的那个大switch-case里加一个case。这太侵入性了。

如果读者是大学生，没做过工程，总做过小组作业吧。我们勉强来这么比喻：

小组作业里，每个人分工做不同的环节。你负责的环节，就像这里的switch-case一样，别人在修改他们的环节的时候，还要特地来求你，找你把switch-case里的特定代码修改一遍。这么下来，你第二天就得罢工。

而如果你开放这个`drink()`的管理权限，让他们每个人想来改的时候都随便写，那你罢工之前他们就能把这个函数搞得一团糟。

所以使用__tagged union__的时候，你一定要知道你在干什么，也要知道大伙都能干什么。和谐团队，你我有责。

## 基于虚函数和继承的多态

因此，我们需要一种更加优雅的设计，来解决这个问题。这个设计就是C#这种语言中的接口（Interface），也就是C++中的抽象基类（Abstract Base Class），也就是aaa语言中的bbb。总之，我们需要一种方式，让我们的饮品类不再需要修改自己的定义，就能够**自由地**加入到我们的系统中。而这种方式的核心，就是虚函数。

to be continued...