---
layout: post
title:  第158期
---
# C++ 中文周刊 2024-05-25 第158期


[周刊项目地址](https://github.com/wanghenshui/cppweeklynews)

公众号

<img src="https://wanghenshui.github.io/cppweeklynews/assets/code.png" alt=""  width="30%">

qq群 [点击进入](https://qm.qq.com/q/6NGizNPyG4)

RSS https://github.com/wanghenshui/cppweeklynews/releases.atom

欢迎投稿，推荐或自荐文章/软件/资源等，评论区留言

本期文章由 HNY 赞助, 本期内容很少

---

## 资讯

标准委员会动态/ide/编译器信息放在这里

[五月邮件](https://www.open-std.org/jtc1/sc22/wg21/docs/papers/2024/#mailing2024-05) 

基本就是range constract executor 相关提案乱炖

讲几个R0

- executor还没定，基于他的async object就来了。大概意思就是move only function封装用executor来管理/分配内存/生命周期管理，作者还给了[POC](https://godbolt.org/z/rrbW6veYd) 没有细看

- [Type-aware allocation and deallocation functions](https://www.open-std.org/jtc1/sc22/wg21/docs/papers/2024/p2719r0.html)

简单来说就是针对类级别的更精细的内存控制

```cpp
operator new(sizeof(T), type_identity<T>{}, args…)
```

通常这种都是自己搞个数组placement new

提供根据类型的new接口，能更简单实现这种逻辑。看一乐，提供一种思路

- [P3125R0: Pointer Tagging](https://www.open-std.org/jtc1/sc22/wg21/docs/papers/2024/p3125r0.pdf)

这个其实就是很多指针实际上更多是抽象的，可以利用bit做事，但标准对这块不是很清晰，算是UB吧

比如llvm的PointerIntPair arm的MTE hash trie的指针管理 或者pointer swizzle技巧那种把指针搞出复合语义

这种玩意其实就是tag pointer，不同tag表达不同含义，感觉标准化会更好一些

- [Floating-Point Maximum/Minimum Function Objects](https://www.open-std.org/jtc1/sc22/wg21/docs/papers/2024/p3307r0.html)

浮点数的min/max处理了太多边角场景(NaN之类的)，不够快，不想用ffastmath情况下提供了一套新接口

- [elide](https://www.open-std.org/jtc1/sc22/wg21/docs/papers/2024/p3288r0.html) 

帮你把optional variant any里的T掏出来。这个很干净

就是一个惰性延迟wrapper

[实现godbolt](https://godbolt.org/z/65fEd3axf)

- [A Relocating Swap](https://www.open-std.org/jtc1/sc22/wg21/docs/papers/2024/p3239r0.pdf)

帮P2786加了个接口实现P1144相同能力。看不懂？没事我也不懂

[编译器信息最新动态推荐关注hellogcc公众号 本周更新 2024-0522第255期](https://mp.weixin.qq.com/s/rldwIAic0pVimg0-hLCRPg)


## 文章

#### [超好用的 C++ 在线编译器（VSCode 版）](https://zhuanlan.zhihu.com/p/694365783)

godbolt集成vscode了，挺好的

#### [C++神秘学习——memcpy的一个ub](https://zhuanlan.zhihu.com/p/699259091)


memcpy data()了，编译器假设不空优化导致asan报错

vector string当buffer没问题，都用他们当buffer不用他们的成员函数复制是怎么个意思，瞧不起assign？

这个也和群友激烈讨论了

笔者的个人观点，data()虽然不是const，但是最好最好不乱玩，能用成员用成员，实在不行才hack，比如resize这种

assign肯定也是memcpy，他会帮你判断的，你直接拿来用，那肯定说明不为空，那编译器的假设笔者认为没毛病

#### [write()和mmap写混用与cache alias](https://zhuanlan.zhihu.com/p/699052979)

学到了

#### [SLUB 分配器的下一步计划](https://zhuanlan.zhihu.com/p/699058331)

看一乐

#### [C++无锁(lock free)数据结构与有锁数据结构相比，速度，性能等有何区别?多线程中如何选择？](https://www.zhihu.com/question/558986994/answer/3498768792)

看一乐

#### [long double to_string会丢失精度？](https://www.reddit.com/r/cpp/comments/1czb8ul/stdto_stringlong_double_is_broken_and_rounds_the/)

```cpp
#include <string>
#include <iostream>
#include <iomanip>
using namespace std;
int main() {
    long double d = -20704.000055577169;
    string s = to_string(d);
    cout << s << endl;//-20704.000056 
    cout << setprecision(12) << fixed << s << endl;
}
```

两个输出没有差别。注意这个坑 [godbolt](https://godbolt.org/z/9EWYexK6E)

#### [Looking up a C++ Hash Table with a pre-known hash](https://ebadblog.com/looking-up-a-c++-hash-table-with-a-pre-known-hash)

如果你知道了hash，如何避免容器计算hash？定制Equal，把hash比较也放进去，直接看完整代码

```cpp
template<typename Hash>
class KeyHashPair {
private:
    std::string_view key_;
    std::size_t hash_;
public:
    KeyHashPair() = delete;
    KeyHashPair(std::string_view sv) : key_(sv), hash_(Hash{}(key_)) {}

    std::string_view key() const { return key_; }
    std::size_t hash() const { return hash_; }
};

struct Hash {
    using is_transparent = void;

    std::size_t operator()(std::string_view sv) const {
        return std::hash<std::string_view>{}(sv);
    }
    std::size_t operator()(KeyHashPair<Hash> pair) const {
        return pair.hash();
    }
};

struct KeyEqual {
    using is_transparent = void;

    bool operator()(std::string_view lhs, std::string_view rhs) const {
        return lhs == rhs;
    }
    template<typename Hash>
    bool operator()(KeyHashPair<Hash> lhs, std::string_view rhs) const {
        return lhs.key() == rhs;
    }
};

using Set = std::unordered_set<std::string, Hash, KeyEqual>;

int main() {
    Set set{"foo"};

    const std::string string{"foo"};
    const KeyHashPair<Set::hasher> pair{string};

    assert(set.contains(pair));
}
```
还是有点思路提升的，但并没有把hash存下来，其实更合理的思路是直接比较set内部的hash，可惜没有暴露

## 开源项目介绍

- [asteria](https://github.com/lhmouse/asteria) 一个脚本语言，可嵌入，长期找人，希望胖友们帮帮忙，也可以加群753302367和作者对线
- [quill](https://github.com/odygrd/quill/releases/tag/v4.0.0) 4.0发布 编译时间 写入速度双提升
- [ipvar](https://github.com/kboutora/ipvar) 多进程共享变量，没明白什么场景用得上

## 工作招聘

- 字节时序数据库招聘 https://www.zhihu.com/question/445283801/answer/2771155828
- 
## 互动环节

和群友聊天聊到了某些爱装逼的人，发现每一代学生都是这样的思维，沉迷某些技术 术语，爱装逼

虽然笔者讲出来有一点好为人师的感觉，但我还是很后悔大学浪费很多时间在嘴贫装逼上的。

那么问题来了，咱们读者是学生还是工作党，如果是学生，本周刊对你有没有收益？还是在咱这里学装逼来了，切记低调别装逼

如果不懂或者认为笔者有错误，大胆评论区指出，谢谢先，千万别模棱两可混过去了，笔者也不一定懂

---

[上一期](https://wanghenshui.github.io/cppweeklynews/posts/157.html)
