---
layout: post
title:  第155期
---
# C++ 中文周刊 2024-04-19 第155期


[周刊项目地址](https://github.com/wanghenshui/cppweeklynews)

公众号

<img src="https://wanghenshui.github.io/cppweeklynews/assets/code.png" alt=""  width="30%">

qq群 [点击进入](https://qm.qq.com/q/6NGizNPyG4)

RSS https://github.com/wanghenshui/cppweeklynews/releases.atom

欢迎投稿，推荐或自荐文章/软件/资源等，评论区留言

本期文章由 HNY 寻找我的皮卡丘 岚岚路 赞助

---

## 资讯

标准委员会动态/ide/编译器信息放在这里

[标准委员四月邮件](https://www.open-std.org/jtc1/sc22/wg21/docs/papers/2024/#mailing2024-04)

最近比较热闹的就是P1144 和 P2786 吵架了 1144作者也在收集意见 [Help wanted: Compile your codebase with P1144 and P2786 relocatability!](https://quuxplusone.github.io/blog/2024/04/10/p1144-your-codebase/)

开源库都实现了1144，2786点占坑的意思

另外就是 异常，[lewis baker弄了新东西](https://www.open-std.org/jtc1/sc22/wg21/docs/papers/2024/p3166r0.html#org65638c7) 

感动

[编译器信息最新动态推荐关注hellogcc公众号  本周更新 2024-04-17 第250期 ](https://mp.weixin.qq.com/s/XemVtIRRkOjhuhUlX2pt8A)

无人关注的角落 cmake支持了[import std](https://gitlab.kitware.com/cmake/cmake/-/merge_requests/9337)


## 文章

#### [C++20协程详解（1） -- 协程概念](https://zhuanlan.zhihu.com/p/693105590)
#### [C++20协程详解（2） -- 理解co_await运算符](https://zhuanlan.zhihu.com/p/693149493)

lewis baker文章翻译。没看的都看看，17年的文了

#### [初探ThreadLocalStorage及其几个典型应用](https://zhuanlan.zhihu.com/p/587028371) 

写的挺有意思


#### [内存使用高伴随异常高的磁盘读IO原因分析](https://zhuanlan.zhihu.com/p/667417766)

省流 内存使用太高导致  反复page fault 用户的代码段也在page cache中，导致反复读盘

#### [聊聊cmov](https://wanghenshui.github.io/2024/04/05/cmov.html) 

没看的看一下，自吹自擂一下

#### [The single C++ line that is worth millions of dollars.](https://cppdepend.com/blog/the-single-c-line-that-is-worth-millions-of-dollars/)

介绍经典的求平方根代码

```c
float Q_rsqrt(float number)
{
  long i;
  float x2, y;
  const float threehalfs = 1.5F;

  x2 = number * 0.5F;
  y  = number;
  i  = * ( long * ) &y;                       // evil floating point bit level hacking
  i  = 0x5f3759df - ( i >> 1 );               // what the fuck?
  y  = * ( float * ) &i;
  y  = y * ( threehalfs - ( x2 * y * y ) );   // 1st iteration
  // y  = y * ( threehalfs - ( x2 * y * y ) );   // 2nd iteration, this can be removed

  return y;
}
```
[还是比较经典的。不知道原理没关系，具体的推导可以看这个](https://lamforest.github.io/2021/11/23/cpp/suan-fa-kuai-su-ping-fang-gen-dao-shu-suan-fa-zhong-de-0x5f3759df-de-lai-yuan/)


#### [llm.c代码详细解读（一）](https://zhuanlan.zhihu.com/p/692116370)

学一下吧，学无止境

#### [Greatest common divisor, the extended Euclidean algorithm, and speed!](https://lemire.me/blog/2024/04/13/greatest-common-divisor-the-extended-euclidean-algorithm-and-speed/)

目前的最快的最大公约数(GCD)算法是 Binary GCD algorithm

大概思路就是分奇偶讨论，替换掉除法

实现通常是这样


```cpp
template <typename int_type>
int_type binary_gcd(int_type u, int_type v) {
  if (u == 0) { return v; }
  if (v == 0) { return u; }
  auto shift = std::countr_zero(u | v);
  u >>= std::countr_zero(u);
  do {
   v >>= std::countr_zero(v);
   if (u > v) { std::swap(u, v); }
   v = v - u;
  } while (v != 0);
  return u << shift;
}
```


考虑优化这个代码

首先去掉swap

```cpp
int_type binary_gcd_noswap(int_type u, int_type v) {
  if (u == 0) { return v; }
  if (v == 0) { return u; }
  auto shift = std::countr_zero(u | v);
  u >>= std::countr_zero(u);
  do {
   int_type t = v >> std::countr_zero(v);
   if (u > t) v = u - t, u = t;
   else v = t - u;
  } while (v != 0);
  return u << shift;
}
```

压测了一下 gcc上没区别，clang上快，主要是gcc上gcd的实现用的是相同算法


[代码在这里](https://github.com/lemire/Code-used-on-Daniel-Lemire-s-blog/tree/master/2024/04/13)

#### [Speculations on arenas and custom strings in C++](https://nullprogram.com/blog/2024/04/14/)


```cpp
template<typename T>
struct slice {
    T   *data = 0;
    size len  = 0;
    size cap  = 0;

    slice<T> = default;

    template<size N>
    slice<T>(T (&a)[N]) : data{a}, len{N}, cap{N} {}

    T &operator[](size i) { ... }
}

template<typename T>
slice<T> append(arena *, slice<T>, T);

```

其实就是iobuf 哥们总爱重新发明东西

#### [Garbage Collection for Systems Programmers](https://bitbashing.io/gc-for-systems-programmers.html)

简单说就是free偶尔会很重，用rcu之类的手段还是很有必要的

#### [Fuzzing CDT: Finding, reproducing, and reporting bugs](https://gist.github.com/Som1Lse/95c2bf99385138451b614d8a94066ed7)


一个fuzz找bug的经验，很精彩，主要是通过fuzzer找到有问题的测试用例，

然后重写接口，增加调用，拿到更多有问题的测试用例，分析用例特点

#### [在 C++ 项目中有没用 std::error_code 作为错误处理的良好范例](https://www.zhihu.com/question/649463553/answer/3465752257)

有点意思，这里标记一个TODO，有空翻译一下


## 视频

#### [C++ Weekly - Ep 424 - .reset vs →reset() ](https://www.youtube.com/watch?v=HgPfbYfV9eE&ab_channel=C%2B%2BWeeklyWithJasonTurner)


一段幽默的代码

```cpp
#include <any>
#include <memory>

std::unique_ptr<std::any> get_value();


int main() {

    auto p = get_value();
    // 干了一点其他的活，之后释放指针
    p->reset();
}

```

发现问题没有 应该是`p.reset()` `p->reset()`实际上是`std::any`的

这也是重载 operator dot有风险的原因之一

只能说抽象，注意别写错

## 开源项目介绍

- [asteria](https://github.com/lhmouse/asteria) 一个脚本语言，可嵌入，长期找人，希望胖友们帮帮忙，也可以加群753302367和作者对线
- [rsa](https://github.com/adam-mcdaniel/rsa) 一个rsa库
- [blaze](https://bitbucket.org/blaze-lib/blaze/src/master/) 一个数学库，类似eigen
- [C Ray Tracer](https://github.com/michbogos/crt)


## 互动环节

周末下雨本计划搬家，收拾了半天结果下雨硬是没搬，浪费了宝贵的周末，哎呦，每次浪费时间都特别懊悔

---


[上一期](https://wanghenshui.github.io/cppweeklynews/posts/154.html)
