---
layout: post
title:  第154期
---
# C++ 中文周刊 2024-04-13 第154期


[周刊项目地址](https://github.com/wanghenshui/cppweeklynews)

公众号

<img src="https://wanghenshui.github.io/cppweeklynews/assets/code.png" alt=""  width="30%">

qq群 [点击进入](https://qm.qq.com/q/6NGizNPyG4)

RSS https://github.com/wanghenshui/cppweeklynews/releases.atom

欢迎投稿，推荐或自荐文章/软件/资源等，评论区留言

本期文章由 HNY 啃萝卜 赞助

---

## 资讯

标准委员会动态/ide/编译器信息放在这里

[编译器信息最新动态推荐关注hellogcc公众号 本周更新 2024-04-03 第248期](https://mp.weixin.qq.com/s/8A9xYEIZn0ZIL214mmMKMw)

clion 新版本发布 https://www.jetbrains.com/clion/whatsnew/#v20241-apr-09


[Results summary: 2024 Annual C++ Developer Survey "Lite"](https://isocpp.org/files/papers/CppDevSurvey-2024-summary.pdf)

一年一度的调查问卷报告出了，样本有点少，说几个有意思的数据

- c++ 五年以上经验 占80% 大家都是老登
- 大部分使用c++17特性
- 主要痛点在环境/脚手架/编译时间/调试 module什么时候能好用我操了
- c++20 特性 concept/coroutine/module concept接受程度最高（module没法用吧，coroutine主要是传染性，不想改代码）

感兴趣的可以自己看一下，大部分都是图


## 文章

#### move性能下降？

群里聊到小红书看到的一个move优化不生效的问题

https://quick-bench.com/q/P-nqRmfT4ChFdNHHd9NCFALRRDI

经过群里的压测比较，并没有明显差异

大家有其他见解也可以补充


#### [How not to check array size in C++](https://pvs-studio.com/en/blog/posts/cpp/1112/)

省流:用std::size

c里有一种检查数组长度的方法 `sizeof(a) / sizeof(a[0])`

现在是2024年，有没有一种优雅的方法呢

显然你会说 用vector/array ，先别走这么远，先来个尝试

```cpp
template <typename T, size_t N>
char (&ArraySizeHelper(T (&array)[N]))[N];

#define countof(array) (sizeof(ArraySizeHelper(array)))
```

看懂发生了什么吗，这个ArraySizeHelper是个函数模版，接受T(&)[N] 返回一个char(&)[N] 然后你就拿到了N

为什么不实现，我靠，你要是实现了玩意真有傻逼同事用咋办，就在sizeof里用用得了

多么扭曲的写法，想出这玩意的人排便通畅吗，就不怕被同事打吗

后来到了c++11 咱们终于现代了

```cpp
template <typename T, size_t N>
constexpr size_t countof(T (&arr)[N]) noexcept
{
  return N;
}
```
都支持数组，顺便给vector啥的也支持上

```cpp
template <typename Cont>
constexpr auto countof(const Cont &cont) -> decltype(cont.size())
  noexcept(noexcept(cont.size()))
{
  return cont.size();
}

```

我操，是不是重新发明了[std::size](https://en.cppreference.com/w/cpp/iterator/size) 哈哈c++17才支持

尽量用std::size

两个指针怎么办，可能你会说自己算被，用std::distance

上一期我们讲的范围问题还记得吗，转成range 拿range.size是最合理的，不要自己算，错误会被忽略掉

#### [译-Debugging a futex crash](https://wanghenshui.github.io/2024/04/09/debug-futex.html)

之前发过了，没看的再看看哈，这个思路还是挺清晰的

#### [LLVM IR 初探(0x00) alloca / 基本块 / getelementptr 踩坑](https://zhuanlan.zhihu.com/p/690032669)

学学LLVM

#### [C++20 modules and Boost: an analysis](https://anarthal.github.io/cppblog/modules)

module现状调查，哈哈，没有能用的大项目，没错，2020的东西到2024年也没做好

#### [Abstract Strategy Tree](https://atlas-blog.vercel.app/ast)

理解不了，有看懂的可以讲讲，我觉得有点为了秀而秀，没必要

#### [The case of the exception that a catch (…) didn’t catch](https://devblogs.microsoft.com/oldnewthing/20240405-00/?p=109621)

TLDR 有两个地方有异常，但只catch一处

#### [The Simple Beauty of XOR Floating Point Compression](https://clemenswinter.com/2024/04/07/the-simple-beauty-of-xor-floating-point-compression/)


TODO 没看懂

#### [C++协程——等待的艺术awaitable](https://zhuanlan.zhihu.com/p/683764594)

看一乐


## 开源项目介绍

- [asteria](https://github.com/lhmouse/asteria) 一个脚本语言，可嵌入，长期找人，希望胖友们帮帮忙，也可以加群753302367和作者对线
- https://github.com/zeus-cpp/expected 实现了expect c++17版本，我怎么记得有人实现过了
- https://github.com/karpathy/llm.c 一个llm简单实现
- https://github.com/pika-org/pika 一个sender reciver实现，感觉是fork的hpc然后拼一下std::exec


## 工作招聘

- [蚂蚁招聘-分布式 AI Infra 研发工程师](https://zhuanlan.zhihu.com/p/691063917)

目前这个行业是非常好的方向，不亚于搜推广了。感兴趣的可以试试

- [南京大学、浙江大学 2025年秋学季编译及软件安全技术研究组招生启事](https://zhuanlan.zhihu.com/p/691874163?utm_psn=1762083504278368256)

这个是对于学生而言的

不过和水友群里聊了一下，安全方向就业大环境不太好，16-19可能是巅峰吧，现在你看玄武实验室都没啥动静了

基本人不离职就没有新坑了，以前能进大厂的人才现在只能去小厂

不过这个方向是有钱的，只不过更倾向于小而美了。感兴趣的可以试试。

本台记者 要求匿名/WhiteCrow报道，在此表示感谢

## 互动环节

上周真是漫长的一周啊，真不想上六天班

水友群里有一个有个哥们说他的策划很漂亮实现她的需求都故意留几个bug

我闻到了恋爱的酸臭味了，我想起了之前喷哭测试的往事，一晃也五六年了

时间过的怎么又慢又快的，本周周报就到这里了

---

[上一期](https://wanghenshui.github.io/cppweeklynews/posts/153.html)
