---
layout: post
title:  第152期
---
# C++ 中文周刊 2024-03-25 第152期



[周刊项目地址](https://github.com/wanghenshui/cppweeklynews)

公众号

<img src="https://wanghenshui.github.io/cppweeklynews/assets/code.png" alt=""  width="30%">

qq群 [点击进入](https://qm.qq.com/q/6NGizNPyG4)

RSS https://github.com/wanghenshui/cppweeklynews/releases.atom

欢迎投稿，推荐或自荐文章/软件/资源等，评论区留言


---

## 资讯

标准委员会动态/ide/编译器信息放在这里

[编译器信息最新动态推荐关注hellogcc公众号 本周更新 2024-03-13 第245期 ](https://mp.weixin.qq.com/s/G5b4t6MNiPjzRWuISITWMw)

c++26 东京会议如火如荼，详情Mick235711已经发了，公众号也发了，这里不再赘述

## 文章

### [Introduction To Low Latency Programming: External Processing](https://tech.davidgorski.ca/introduction-to-low-latency-programming-external-processing/)

其实就是提前算好，包括不限于利用编译期 利用脚本生成以及constexpr

异步拆分，让别人算    

### [Condvars and atomics do not mix ](https://zeux.io/2024/03/23/condvars-atomic/)

用condvar 条件就要放到mutex下修改，即便这个变量是atomic，也要放到mutex下修改

### [Jumbled Protocol Buffer Message Layout](https://eason-zhan.github.io/posts/jumbled-protocol-buffer-message-layout/)

protoc会重排你定义的字段布局

```cpp
static void OptimizeLayoutHelper(std::vector<const FieldDescriptor*>* fields,
                                 const Options& options,
                                 MessageSCCAnalyzer* scc_analyzer) {
  if (fields->empty()) return;

  // The sorted numeric order of Family determines the declaration order in the
  // memory layout.
  enum Family {
    REPEATED = 0,
    STRING = 1,
    // Laying out LAZY_MESSAGE before MESSAGE allows a single memset to zero
    // MESSAGE and ZERO_INITIALIZABLE fields together.
    LAZY_MESSAGE = 2,
    MESSAGE = 3,
    ZERO_INITIALIZABLE = 4,
    OTHER = 5,
    kMaxFamily
  };


```

作者观察到一个现象，本来字段很多，删掉一部份字段，性能应该有提升，结果并没有

```protobuf
message Stats {
    int64 ts                   = 1;
    int64 show                 = 2;
    int64 click                = 3;
    int64 cost                 = 4;
    int64 hour_show            = 5;
    int64 hour_click           = 6;
    int64 hour_cost            = 7;
    int64 acc_show             = 8;
    int64 acc_click            = 9;
    int64 acc_cost             = 10;
    repeated int64 bucket      = 11;
    repeated int64 hour_bucket = 12;
    repeated int64 acc_bucket  = 13;
}

```
优化成这样

```protobuf
// After remove the `hour_*` fields
message StatsOpt {
    int64 ts                   = 1;
    int64 show                 = 2;
    int64 click                = 3;
    int64 cost                 = 4;
    int64 acc_show             = 5;
    int64 acc_click            = 6;
    int64 acc_cost             = 7;
    repeated int64 bucket      = 8;
    repeated int64 acc_bucket  = 9;
}

```

内存布局原来是这样

```txt
+------ 16 BYTE ------+- 8 BYTE -+------ 16 BYTE ------+- 8 BYTE -+------ 16 BYTE ------+
|    (11)bucket       | (11)size |      (12)hour       | (12)size |  (13)acc_bucket     |
+- 8 BYTE -+- 8 BYTE -+- 8 BYTE -+- 8 BYTE -+- 8 BYTE -+- 8 BYTE -+- 8 BYTE -+- 8 BYTE -+
| (13.a)   |   (1)ts  |  (2)show | (3)click |  (4)cost |    (5)   |    (6)   | (7)      |
+- 8 BYTE -+- 8 BYTE -+- 8 BYTE -+- 8 BYTE -+- 8 BYTE -+- 8 BYTE -+- 8 BYTE -+- 8 BYTE -+
|    (8)   |    (9)   |   (10)   |     *    |     *    |     *    |     *    |     *    |
+- 8 BYTE -+- 8 BYTE -+- 8 BYTE -+- 8 BYTE -+- 8 BYTE -+- 8 BYTE -+- 8 BYTE -+- 8 BYTE -+
```
现在是这样
```txt
+------ 16 BYTE ------+- 8 BYTE -+------ 16 BYTE ------+- 8 BYTE -+- 8 BYTE -+- 8 BYTE -+
|    (8)bucket        | (8)size  |      (9)hour        | (9)size  | (13.a)   |   (1)ts  |
+- 8 BYTE -+- 8 BYTE -+- 8 BYTE -+- 8 BYTE -+- 8 BYTE -+- 8 BYTE -+- 8 BYTE -+- 8 BYTE -+
|  (2)show | (3)click |  (4)cost |    (5)   |    (6)   | (7)      |     *    |     *    |
+- 8 BYTE -+- 8 BYTE -+- 8 BYTE -+- 8 BYTE -+- 8 BYTE -+- 8 BYTE -+- 8 BYTE -+- 8 BYTE -+

```

生成文件是这样的

```cpp
 struct Impl_ {
  ::PROTOBUF_NAMESPACE_ID::RepeatedField< int64_t > bucket_;
  mutable std::atomic<int> _bucket_cached_byte_size_;
  ::PROTOBUF_NAMESPACE_ID::RepeatedField< int64_t > acc_bucket_;
  mutable std::atomic<int> _acc_bucket_cached_byte_size_;
  int64_t ts_;
  int64_t show_;
  int64_t click_;
  int64_t cost_;
  int64_t acc_show_;
  int64_t acc_click_;
  int64_t acc_cost_;
  mutable ::PROTOBUF_NAMESPACE_ID::internal::CachedSize _cached_size_;
};

union { Impl_ _impl_; };
```

能看到ts和cost跨cacheline了。以前的字段虽然大，但不是夸cacheline的，优化后反而跨cacheline导致变慢


###  [C++ exit-time destructors](https://maskray.me/blog/2024-03-17-c++-exit-time-destructors)

介绍析构 runtime细节，非常细，值得一看    


### [Daily bit(e) of C++ | Coroutines: step by step](https://simontoth.substack.com/p/daily-bite-of-c-coroutines-step-by)

又一个协程教程

### [C++23: Encoding related changes](https://www.sandordargo.com/blog/2024/03/20/cpp23-encoding-related-changes)


介绍了一些编码方面的改进，包括多语言支持/unicode等等

```bash

std::locale::global(std::locale("Russian.1251"));
auto s = std::format("День недели: {}", std::chrono::Monday);

```
### [Bug hunting in Btrfs](https://tavianator.com/2024/btrfs_bug.html)


调试代码发现了btrfs有bug，然后去找bug在哪里，很细，值得一看，这里标记TODO

### [C++20: Basic Chrono Terminology with Time Duration and Time Point](https://www.modernescpp.com/index.php/c20-basic-chrono-terminology-with-time-duration-and-time-point/)

std::chrono::months 你猜是多少？30.436875

std::chrono::years 你猜是多少？365.2425

非常之令人无语，这种傻逼接口有存在的必要吗

### [Two handy GDB breakpoint tricks](https://nullprogram.com/blog/2024/01/28/)

gdb小技巧



## 工作招聘

金山招聘，感兴趣点击[链接](https://app.mokahr.com/m/recommendation-apply/wps/29467?sharePageId=3685475&recommendCode=NTAA6lb&codeType=1&code=081pntFa1LMf8H0yvUFa1yxtRl3pntFe&state=3#/recommendation/page/3685475)

## 互动环节

微信公众号终于有评论区了

最近有点卷，更新不太及时, 而且这几周没啥有营养的文章，非常可惜，有啥好玩的我单独发吧

---

[上一期](https://wanghenshui.github.io/cppweeklynews/posts/151.html)