---
layout: post
title:  第151期
---
# C++ 中文周刊 2024-03-09 第151期


[周刊项目地址](https://github.com/wanghenshui/cppweeklynews)

公众号

<img src="https://wanghenshui.github.io/cppweeklynews/assets/code.png" alt=""  width="30%">

qq群 [点击进入](https://qm.qq.com/q/6NGizNPyG4)

RSS https://github.com/wanghenshui/cppweeklynews/releases.atom

欢迎投稿，推荐或自荐文章/软件/资源等

请[提交 issue](https://github.com/wanghenshui/cppweeklynews/issues)   或评论区留言

本期文章由 不语 HNY {} 赞助

周末有点忙，内容不多，这周争取双更

话说看到了别人的知识星球真有一种这也能卖钱的感觉

c++知识普及还是很远，无论深度还是广度，优质内容还是太少了，这种稍微懂点就敢开知识星球开课了

---

## 资讯

标准委员会动态/ide/编译器信息放在这里

[编译器信息最新动态推荐关注hellogcc公众号 本周更新 2024-02-28 第243期 ](https://mp.weixin.qq.com/s/lb3T0XyK87c-oawfkjwXkA)


## 文章

#### [浅谈侵入式结构的应用](https://zhuanlan.zhihu.com/p/679066486)

总结的的非常好


#### [In C++/WinRT, you shouldn’t destroy an object while you’re co_awaiting it](https://devblogs.microsoft.com/oldnewthing/20240307-00/?p=109490)

co_wait对象如果被析构，可能有bug

```c++
struct MyThing : winrt::implements<MyThing, winrt::IInspectable>
{
    winrt::IAsyncAction m_pendingAction{ nullptr };

    winrt::IAsyncAction DoSomethingAsync() {
        auto lifetime = get_strong();
        m_pendingAction = LongOperationAsync();
        co_await m_pendingAction;
        PostProcessing();
    }

    void Cancel() {
        if (m_pendingAction) {
            m_pendingAction.Cancel();
            m_pendingAction = nullptr;
        }
    }
};
```

这段代码， 如果DoSomethingAsync的时候另一个线程Cancel了，pendingAction被析构了，co_await就会挂

解决方案，co_await副本，复制一份或者decay_copy auto{}

这种指针问题和co_await关系不大，但是容易忽略，普通函数也可以触发，比如异步调用lambda，然后lambda里reset指针，这种场景，可能需要copy这个对象

#### [Borrow Checker, Lifetimes and Destructor Arguments in C++ Avanced compile-time validation with stateful](https://a10nw01f.github.io/post/advanced_compile_time_validation/metaprogramming)

看得我眼睛疼 在线演示 https://godbolt.org/z/71qs619Ge


#### [LLVM's 'RFC: C++ Buffer Hardening' at Google](https://bughunters.google.com/blog/6368559657254912/llvm-s-rfc-c-buffer-hardening-at-google)

安全加固 c buffer的 google内部测试加固完性能衰退也就%1 希望llvm合了

#### [RAII all the things?](https://biowpn.github.io/bioweapon/2024/03/05/raii-all-the-things.html)

用unique_ptr来搞，以前讲过类似的。直接贴代码

```cpp
struct fcloser {
    void operator()(std::FILE* fp) const noexcept {
        std::fclose(fp);
    }
};

using file_ptr = std::unique_ptr<std::FILE, fcloser>;


struct mem_unmapper {
    size_t length{};

    void operator()(void* addr) const noexcept {
        ::munmap(addr, length);
    }
};

using mapped_mem_ptr = std::unique_ptr<void, mem_unmapper>;

[[nodiscard]] inline mapped_mem_ptr make_mapped_mem(void* addr, size_t length, int prot, int flags, int fd, off_t offset) {
    void* p = ::mmap(addr, length, prot, flags, fd, offset);
    if (p == MAP_FAILED) { // MAP_FAILED is not NULL
        return nullptr;
    }
    return {p, mem_unmapper{length}}; // unique_ptr owns a deleter, which remembers the length
}


// Intentionally non-RAII
class file_descriptor {
    int fd_{-1};
public:
    file_descriptor(int fd = -1): fd_(fd) {}
    file_descriptor(nullptr_t) {}
    operator int() const { return fd_; }
    explicit operator bool() const { return fd_ != -1; }
    friend bool operator==(file_descriptor, file_descriptor) = default; // Since C++20
};

struct fd_closer {
    using pointer = file_descriptor; // IMPORTANT
    void operator()(pointer fd) const noexcept {
        ::close(int(fd));
    }
};
//using unique_fd = std::unique_ptr<int,             fd_closer>; // Ok
using unique_fd = std::unique_ptr<file_descriptor, fd_closer>; // Ok
//using unique_fd = std::unique_ptr<void,            fd_closer>; // Ok

```

其他场景自己拼一个defer或者scope_exit

#### [How do I make an expression non-movable? What’s the opposite of std::move? ](https://devblogs.microsoft.com/oldnewthing/20240306-00/?p=109481)

如何实现强制不move？

```cpp
template<typename T>
std::remove_reference_t<T> const& no_move(T&& t)
{
    return t;
}

std::vector<int> v = no_move(make_vector());
```

#### [Python3.13的JIT是如何实现的](https://zhuanlan.zhihu.com/p/682997904)

这个也有点意思

#### [不用指针实现pimpl](https://github.com/friendlyanon/pimpl-but-the-p-is-silent)

代码很短


```c++
class impl
{
public:
  impl();
  ~impl();

  int add(int x) const;

private:
  alignas(private_align) unsigned char buffer[private_size];
};

class impl_private
{
public:
  explicit impl_private(int y);

  int add(int x) const;

private:
  int _y;
};

template<typename T>
using impl_t = std::conditional_t<std::is_const_v<std::remove_pointer_t<T>>,
                                  impl_private const,
                                  impl_private>*;

#define IMPL std::launder(reinterpret_cast<impl_t<decltype(this)>>(buffer))

impl::impl()
{
  (void)new (buffer) impl_private(1);
}

impl::~impl()
{
  IMPL->~impl_private();
}

int impl::add(int x) const
{
  return IMPL->add(x);
}
```

核心是用buffer存实现类，然后硬转，看一乐


## 工作招聘

字节跳动图数据库有个招聘，友情推荐一下 

字节图数据库 ByteGraph 团队招聘数据库研发工程师，参与 ByteGraph 存储引擎、查询引擎、数据库与计算融合引擎的核心代码开发。
实习、校招、社招均可，base 地北京/成都/杭州/新加坡均可，新加坡由于签证问题对级别有一定要求，细节可私聊。

可以加 微信 Expelidarmas或者邮件 huyingqian@bytedance.com

[详情可以看这个](https://zhuanlan.zhihu.com/p/685211021)

他们vldb发过论文的，字节的业务也很强

## 互动

还是缺少优质内容，大家给给点子

---

[上一期](https://wanghenshui.github.io/cppweeklynews/posts/150.html)